/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.io.GedcomIOException;
import genj.io.Options;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;

public class BackupFile {
    private static final SimpleDateFormat ISO_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public static boolean createBackup(File file) throws GedcomIOException {
        if (Options.getNbBackups() != 0 && file.exists()) {
            Pattern p = Pattern.compile(BackupFile.getBasename(file.getName()) + "_([0-9]{8}-[0-9]{6})" + BackupFile.getExtension(file.getName()));
            File bak = BackupFile.getBackupFile(file);
            File parent = bak.getParentFile();
            if (parent == null) {
                throw new GedcomIOException("Couldn't create backup for file " + file.getName() + ", problem accessing parent directory.", -1);
            }
            FilenameFilter filter = (dir, name) -> dir.equals(parent) && p.matcher(name).matches();
            Object[] backups = parent.listFiles(filter);
            if (backups == null) {
                throw new GedcomIOException("Couldn't create  backup for file " + file.getName() + ", problem listing backup files from parent directory " + parent.getAbsolutePath(), -1);
            }
            Arrays.sort(backups);
            if (backups.length >= Options.getNbBackups()) {
                for (int i = 0; i <= backups.length - Options.getNbBackups(); ++i) {
                    if (((File)backups[i]).delete()) continue;
                    throw new GedcomIOException("Couldn't delete backup file " + ((File)backups[0]).getName() + ", problem deleting old backup files.", -1);
                }
            }
            if (bak.exists()) {
                throw new GedcomIOException("Couldn't create backup file " + bak.getName() + ", backup file already exists.", -1);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (file.length() > 0L && !file.renameTo(bak)) {
                throw new GedcomIOException("Couldn't create backup for " + file.getName() + ", problem renaming backup file.", -1);
            }
        }
        return true;
    }

    private static File getBackupFile(File file) {
        String fileName = Options.getBackupDirectory() != null && !"".equals(Options.getBackupDirectory()) ? Options.getBackupDirectory() + File.separator + file.getName() : file.getAbsolutePath();
        return new File(BackupFile.getBasename(fileName) + "_" + ISO_FORMAT.format(new Date()) + BackupFile.getExtension(fileName));
    }

    private static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return fileName.substring(index);
    }

    private static String getBasename(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }
}

