/*
 * Decompiled with CFR 0.152.
 */
package ancestris.renderer.velocity;

import ancestris.renderer.velocity.EntityWrapper;
import ancestris.renderer.velocity.FamWrapper;
import ancestris.renderer.velocity.PropertyWrapper;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;

public class IndiWrapper
extends EntityWrapper {
    IndiWrapper(Indi i) {
        super((Entity)i);
    }

    public String getShortValue() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.property == null) {
            return "";
        }
        String birth = ((Entity)this.property).format("BIRT", OPTIONS.getBirthSymbol() + " {$V }{$D}{ $P}");
        String death = ((Entity)this.property).format("DEAT", OPTIONS.getDeathSymbol() + " {$V }{$D}{ $P}");
        return this.property.toString() + " " + birth + " " + death;
    }

    public PropertyWrapper getFamc() {
        Fam famc = ((Indi)this.property).getFamilyWhereBiologicalChild();
        return IndiWrapper.create((Property)famc);
    }

    public FamWrapper[] getFams() {
        Fam[] fams = ((Indi)this.property).getFamiliesWhereSpouse();
        FamWrapper[] reportFams = new FamWrapper[fams.length];
        for (int f = 0; f < fams.length; ++f) {
            reportFams[f] = new FamWrapper(fams[f], (Indi)this.property);
        }
        return reportFams;
    }

    public String getSosaString() {
        return ((Indi)this.property).getSosaString();
    }

    public String getMediaFilePath() {
        Property obje = ((Indi)this.property).getProperty("OBJE", true);
        String path = "";
        if (obje != null) {
            if (obje instanceof PropertyMedia) {
                Property file;
                PropertyMedia pm = (PropertyMedia)obje;
                Media media = (Media)pm.getTargetEntity();
                if (media != null && (file = media.getProperty("FILE", false)) instanceof PropertyFile) {
                    path = file.getValue();
                }
            } else {
                PropertyFile file = (PropertyFile)obje.getProperty("FILE");
                if (file != null) {
                    path = file.getValue();
                }
            }
        }
        return path;
    }
}

