/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.DirectedGraph;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.LayeredGraph;

public class VertexInsertionLayerAssigner {
    public <N, E> LayeredGraph<N, E> assignLayers(DirectedGraph<N, E> graph) {
        LayeredGraph<N, E> layeredGraph = LayeredGraph.createGraph(graph);
        this.insertDummyVertices(layeredGraph);
        return layeredGraph;
    }

    private <N, E> void insertDummyVertices(LayeredGraph<N, E> graph) {
        DirectedGraph<N, E> originalGraph = graph.getOriginalGraph();
        List<List<DirectedGraph.Vertex<N>>> layers = graph.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            List<DirectedGraph.Vertex<N>> layer = layers.get(i);
            for (DirectedGraph.Vertex<N> v : layer) {
                int layerIndex = v.getNumber();
                ArrayList edges = new ArrayList(v.getOutgoingEdges());
                for (DirectedGraph.Edge edge : edges) {
                    DirectedGraph.Vertex<?> nv = edge.getTarget();
                    int nvLayerIndex = nv.getNumber();
                    if (nvLayerIndex <= layerIndex + 1) continue;
                    DirectedGraph.Edge tmp = edge;
                    DirectedGraph.DummyVertex<N> dummyVertex = originalGraph.insertDummyVertex(tmp, DirectedGraph.DummyVertex.Type.BEND);
                    graph.assignLayer(dummyVertex, layerIndex + 1);
                }
            }
        }
    }
}

