/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.place.geonames;

import ancestris.api.place.Place;
import ancestris.api.place.PlaceFactory;
import genj.util.DirectAccessTokenizer;
import org.geonames.InsufficientStyleException;
import org.geonames.PostalCode;
import org.geonames.Toponym;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GeonamesPlace
implements Place {
    private PostalCode postalCode = null;
    private Toponym toponym = null;

    public GeonamesPlace(Toponym toponym) {
        this.toponym = toponym;
    }

    public void setPostalCode(PostalCode set) {
        this.postalCode = set;
    }

    public int compareTo(Place that) {
        return 0;
    }

    public String getCity() {
        return this.postalCode == null ? this.toponym.getName() : this.postalCode.getPlaceName();
    }

    public String getFirstAvailableJurisdiction() {
        return this.getJurisdiction(0);
    }

    public String[] getFormat() {
        return new DirectAccessTokenizer(GeonamesPlace.getPlaceFormat(), ",").getTokens();
    }

    public String getFormatAsString() {
        return GeonamesPlace.getPlaceFormat();
    }

    public static String getPlaceFormat() {
        return NbBundle.getMessage(GeonamesPlace.class, (String)"GeoNamesPlaceFormat");
    }

    public String getJurisdiction(int hierarchyLevel) {
        return this.getJurisdictions()[hierarchyLevel];
    }

    public String[] getJurisdictions() {
        String[] jurisdictions = new String[6];
        try {
            int index = 0;
            jurisdictions[index++] = this.toponym.getName();
            jurisdictions[index++] = this.postalCode != null ? this.postalCode.getPostalCode() : "";
            jurisdictions[index++] = this.toponym.getAdminCode4() != null ? this.toponym.getAdminCode4() : (this.toponym.getAdminCode3() != null ? this.toponym.getAdminCode3() : this.toponym.getAdminCode2());
            jurisdictions[index++] = this.toponym.getAdminName2();
            jurisdictions[index++] = this.toponym.getAdminName1();
            jurisdictions[index++] = this.toponym.getCountryName();
        }
        catch (InsufficientStyleException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return jurisdictions;
    }

    public String getValueStartingWithCity() {
        return new DirectAccessTokenizer(this.toString(), ",").toString();
    }

    public void setFormatAsString(boolean global, String format) {
    }

    public Double getLongitude() {
        return this.toponym.getLongitude();
    }

    public Double getLatitude() {
        return this.toponym.getLatitude();
    }

    public Long getPopulation() {
        if (this.toponym == null) {
            return 0L;
        }
        try {
            return this.toponym.getPopulation() == null ? 0L : this.toponym.getPopulation();
        }
        catch (InsufficientStyleException ex) {
            return 0L;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        int len = this.getJurisdictions().length;
        for (int i = 0; i < len; ++i) {
            String str = this.getJurisdiction(i);
            sb.append(str);
            if (i + 1 >= len) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String getPlaceToLocalFormat() {
        return this.toString().replaceAll(",", " ").replaceAll(" +", " ").trim();
    }

    public String getName() {
        String ret = this.toponym.getName();
        return ret == null ? "" : ret;
    }

    public String getCountryCode() {
        String ret = this.toponym.getCountryCode();
        return ret == null ? "" : ret;
    }

    public String getCountryName() {
        String ret = this.toponym.getCountryName();
        return ret == null ? "" : ret;
    }

    public String getAdminCode(int level) {
        String ret = "";
        try {
            switch (level) {
                case 5: {
                    ret = this.toponym.getAdminCode5();
                    break;
                }
                case 4: {
                    ret = this.toponym.getAdminCode4();
                    break;
                }
                case 3: {
                    ret = this.toponym.getAdminCode3();
                    break;
                }
                case 2: {
                    ret = this.toponym.getAdminCode2();
                    break;
                }
                default: {
                    ret = this.toponym.getAdminCode1();
                    break;
                }
            }
        }
        catch (InsufficientStyleException ex) {
            return "";
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public String getAdminName(int level) {
        String ret = "";
        switch (level) {
            case 5: {
                ret = this.toponym.getAdminName5();
                break;
            }
            case 4: {
                ret = this.toponym.getAdminName4();
                break;
            }
            case 3: {
                ret = this.toponym.getAdminName3();
                break;
            }
            case 2: {
                try {
                    ret = this.toponym.getAdminName2();
                }
                catch (InsufficientStyleException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            default: {
                try {
                    ret = this.toponym.getAdminName1();
                    break;
                }
                catch (InsufficientStyleException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public String getTimeZoneId() {
        String ret = "";
        try {
            if (this.toponym.getTimezone() != null) {
                ret = this.toponym.getTimezone().getTimezoneId();
            }
        }
        catch (InsufficientStyleException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return ret == null ? "" : ret;
    }

    public String getTimeZoneGmtOffset() {
        String ret = "";
        try {
            if (this.toponym.getTimezone() != null) {
                ret = String.valueOf(this.toponym.getTimezone().getGmtOffset());
            }
        }
        catch (InsufficientStyleException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return ret == null ? "" : ret;
    }

    public String getInfo() {
        return PlaceFactory.buildInfo((Place)this);
    }
}

