/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.contemporaries;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.util.Arrays;

public class ReportContemporaries
extends Report {
    public int optionLifeSpan = 70;
    private final String textTitle = this.translate("title");
    private final String textDate = this.translate("date");
    private final String textSelect = this.translate("select");
    private final String textNothing = this.translate("nothing");
    private final String textNoDates = this.translate("nodates");
    private final String textContemps = this.translate("contemps");

    public void start(Indi indi) {
        this.displayHeader();
        this.doReport(indi);
    }

    public void start(Gedcom gedcom) {
        Entity ent = this.getEntityFromUser(this.textSelect + " ", gedcom, "INDI");
        if (ent == null) {
            return;
        }
        Indi person = (Indi)ent;
        this.displayHeader();
        this.doReport(person);
    }

    public void doReport(Indi indi) {
        String strSpan;
        int subjectDOBYear = this.getYear(indi.getBirthDateOption());
        int subjectDODYear = this.getYear(indi.getDeathDateOption());
        if (subjectDOBYear == -1 && subjectDODYear == -1) {
            this.println(this.textNothing);
            this.println(this.textNoDates);
            return;
        }
        if (subjectDOBYear == -1) {
            subjectDOBYear = subjectDODYear - this.optionLifeSpan;
            strSpan = subjectDOBYear + "(est) - ";
        } else {
            strSpan = subjectDOBYear + " - ";
        }
        if (subjectDODYear == -1) {
            subjectDODYear = subjectDOBYear + this.optionLifeSpan;
            if (subjectDODYear < PointInTime.getNow().getYear()) {
                strSpan = strSpan + subjectDODYear + "(est)";
            }
        } else {
            strSpan = strSpan + subjectDODYear;
        }
        this.println(this.textContemps + " " + indi.getName() + " " + strSpan);
        this.println();
        Entity[] individuals = indi.getGedcom().getEntities("INDI", "INDI:NAME");
        for (Entity entity : Arrays.asList(individuals)) {
            Indi individual = (Indi)entity;
            if (individual == indi) continue;
            int tempDOBYear = this.getYear(individual.getBirthDateOption());
            int tempDODYear = this.getYear(individual.getDeathDateOption());
            if (tempDOBYear == -1 && tempDODYear == -1) continue;
            if (tempDOBYear == -1) {
                tempDOBYear = tempDODYear - this.optionLifeSpan;
                strSpan = tempDOBYear + "(est) - ";
            } else {
                strSpan = tempDOBYear + "-";
            }
            if (tempDODYear == -1) {
                tempDODYear = tempDOBYear + this.optionLifeSpan;
                if (tempDODYear < PointInTime.getNow().getYear()) {
                    strSpan = strSpan + tempDODYear + "(est)";
                }
            } else {
                strSpan = strSpan + tempDODYear;
            }
            if (tempDODYear < subjectDOBYear || tempDOBYear > subjectDODYear) continue;
            strSpan = "(" + individual.getId() + ")\t" + individual.getName() + "\t  " + strSpan;
            this.println(strSpan);
        }
    }

    public int getYear(PropertyDate someDate) {
        if (someDate == null || !someDate.isValid() || someDate.isRange()) {
            return -1;
        }
        int year = -1;
        try {
            year = someDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
        return year;
    }

    public void displayHeader() {
        this.println(ReportContemporaries.align((String)this.textTitle, (int)80, (int)1));
        this.println(this.textDate + ": " + PointInTime.getNow().toReportString());
        this.println();
    }
}

