/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.datecalculator;

import ancestris.core.TextOptions;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import javax.swing.JLabel;

public class ReportDateCalculator
extends Report {
    public String accepts(Object context) {
        if (context instanceof PropertyDate) {
            String tag = ((PropertyDate)context).getParent().getTag();
            if ("BIRT".equals(tag) || "CHR".equals(tag) && TextOptions.getInstance().isUseChr()) {
                return this.translate("xname.evt");
            }
            return this.translate("xname.birt");
        }
        return null;
    }

    public JLabel start(PropertyDate date) {
        String result;
        PointInTime pit = date.getStart();
        if (pit == null) {
            result = this.translate("date.undef");
        } else {
            String ageStr;
            try {
                pit = PointInTime.getPointInTime((long)pit.getTimeMillis());
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
            Property parent = date.getParent();
            if (parent.getProperty("AGE") != null) {
                ageStr = parent.getProperty("AGE").getValue();
            } else {
                ageStr = this.getValueFromUser(this.translate("date.title"), this.translate("age.title"), new String[0]);
                if (ageStr == null) {
                    return null;
                }
            }
            Delta age = new Delta(0, 0, 0);
            if (age.setValue(ageStr) || age.setValue(ageStr + "y")) {
                String tag = date.getParent().getTag();
                if ("BIRT".equals(tag) || "CHR".equals(tag) && TextOptions.getInstance().isUseChr()) {
                    PointInTime calcDate = ReportDateCalculator.getDateFromDateAndAge(pit, age, 1);
                    result = this.translate("date.evt.label", new Object[]{calcDate.toString()});
                } else {
                    PointInTime calcDate = ReportDateCalculator.getDateFromDateAndAge(pit, age, -1);
                    result = this.translate("date.birth.label", new Object[]{calcDate.toString()});
                }
            } else {
                result = this.translate("age.invalid");
            }
        }
        return new JLabel(result);
    }

    private static PointInTime getDateFromDateAndAge(PointInTime date, Delta age, int op) {
        if (date == null || age == null) {
            return null;
        }
        if (!date.isValid()) {
            return null;
        }
        Calendar calendar = date.getCalendar();
        if (calendar != age.getCalendar()) {
            return null;
        }
        if (date.getYear() == Integer.MAX_VALUE) {
            return null;
        }
        int year = date.getYear() + op * age.getYears();
        int month = date.getMonth();
        int day = date.getDay();
        if (date.getMonth() != Integer.MAX_VALUE) {
            month += op * age.getMonths();
            if (day != Integer.MAX_VALUE) {
                day += op * age.getDays();
            }
        }
        return ReportDateCalculator.normalize(new PointInTime(day, month, year, calendar));
    }

    private static PointInTime normalize(PointInTime pit) {
        int year = pit.getYear();
        int month = pit.getMonth();
        int day = pit.getDay();
        Calendar cal = pit.getCalendar();
        if (month == Integer.MAX_VALUE) {
            return pit;
        }
        if (month > cal.getMonths()) {
            return ReportDateCalculator.normalize(new PointInTime(day, month - cal.getMonths(), year + 1, cal));
        }
        if (month < 0) {
            return ReportDateCalculator.normalize(new PointInTime(day, month + cal.getMonths(), year - 1, cal));
        }
        if (day == Integer.MAX_VALUE) {
            return pit;
        }
        if (day > cal.getDays(month, year)) {
            return ReportDateCalculator.normalize(new PointInTime(day - cal.getDays(month, year), month + 1, year, cal));
        }
        if (day < 0) {
            return ReportDateCalculator.normalize(new PointInTime(day + cal.getDays(month - 1, year), month - 1, year, cal));
        }
        return pit;
    }
}

