/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.models.SourceRecordedEventsTableModel;
import ancestris.modules.editors.genealogyeditor.panels.FamiliesReferenceTreeTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.RecordedEventEditorPanel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.UnitOfWork;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SourceRecordedEventsTablePanel
extends JPanel {
    private Property mParent;
    private Entity mEntity;
    private Property mRegisteredEvent;
    private final SourceRecordedEventsTableModel mSourceEventTypesTableModel = new SourceRecordedEventsTableModel();
    private final ChangeListner changeListner = new ChangeListner();
    private final ChangeSupport changeSupport = new ChangeSupport(FamiliesReferenceTreeTablePanel.class);
    private JButton addSourceEventButton;
    private JButton deleteSourceEventButton;
    private JButton editSourceEventButton;
    private JScrollPane sourceEventsScrollPane;
    private EditorTable sourceEventsTable;
    private JToolBar sourceEventsToolBar;

    public SourceRecordedEventsTablePanel() {
        this.initComponents();
        this.sourceEventsTable.setID(SourceRecordedEventsTablePanel.class.getName());
    }

    private void initComponents() {
        this.sourceEventsToolBar = new JToolBar();
        this.addSourceEventButton = new JButton();
        this.editSourceEventButton = new JButton();
        this.deleteSourceEventButton = new JButton();
        this.sourceEventsScrollPane = new JScrollPane();
        this.sourceEventsTable = new EditorTable();
        this.sourceEventsToolBar.setFloatable(false);
        this.sourceEventsToolBar.setRollover(true);
        this.addSourceEventButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addSourceEventButton.setFocusable(false);
        this.addSourceEventButton.setHorizontalTextPosition(0);
        this.addSourceEventButton.setVerticalTextPosition(3);
        this.addSourceEventButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceRecordedEventsTablePanel.this.addSourceEventButtonActionPerformed(evt);
            }
        });
        this.sourceEventsToolBar.add(this.addSourceEventButton);
        this.editSourceEventButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editSourceEventButton.setFocusable(false);
        this.editSourceEventButton.setHorizontalTextPosition(0);
        this.editSourceEventButton.setVerticalTextPosition(3);
        this.editSourceEventButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceRecordedEventsTablePanel.this.editSourceEventButtonActionPerformed(evt);
            }
        });
        this.sourceEventsToolBar.add(this.editSourceEventButton);
        this.deleteSourceEventButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteSourceEventButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("SourceRecordedEventsTablePanel.deleteSourceEventButton.toolTipText"), new Object[0]));
        this.deleteSourceEventButton.setFocusable(false);
        this.deleteSourceEventButton.setHorizontalTextPosition(0);
        this.deleteSourceEventButton.setVerticalTextPosition(3);
        this.deleteSourceEventButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceRecordedEventsTablePanel.this.deleteSourceEventButtonActionPerformed(evt);
            }
        });
        this.sourceEventsToolBar.add(this.deleteSourceEventButton);
        this.sourceEventsTable.setModel(this.mSourceEventTypesTableModel);
        this.sourceEventsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SourceRecordedEventsTablePanel.this.sourceEventsTableMouseClicked(evt);
            }
        });
        this.sourceEventsScrollPane.setViewportView(this.sourceEventsTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceEventsToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.sourceEventsScrollPane, -1, 571, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.sourceEventsToolBar, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceEventsScrollPane, -1, 170, Short.MAX_VALUE)));
    }

    private void addSourceEventButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mEntity.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    if (SourceRecordedEventsTablePanel.this.mParent == null) {
                        SourceRecordedEventsTablePanel.this.mParent = SourceRecordedEventsTablePanel.this.mEntity.addProperty("DATA", "");
                    }
                    SourceRecordedEventsTablePanel.this.mRegisteredEvent = SourceRecordedEventsTablePanel.this.mParent.addProperty("EVEN", "");
                }
            });
            final RecordedEventEditorPanel recordedEventPanel = new RecordedEventEditorPanel();
            DialogManager.ADialog recordedEventDialog = new DialogManager.ADialog(NbBundle.getMessage(RecordedEventEditorPanel.class, (String)"RecordedEventEditorPanel.create.title"), (JComponent)recordedEventPanel);
            recordedEventPanel.set(this.mRegisteredEvent);
            recordedEventDialog.setDialogId(RecordedEventEditorPanel.class.getName());
            recordedEventPanel.addChangeListener(this.changeListner);
            if (recordedEventDialog.show() == DialogDescriptor.OK_OPTION) {
                try {
                    gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            SourceRecordedEventsTablePanel.this.mSourceEventTypesTableModel.add(SourceRecordedEventsTablePanel.this.mRegisteredEvent);
                            recordedEventPanel.commit();
                        }
                    });
                    this.editSourceEventButton.setEnabled(true);
                    this.deleteSourceEventButton.setEnabled(true);
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            recordedEventPanel.removeChangeListener(this.changeListner);
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editSourceEventButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.sourceEventsTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.sourceEventsTable.convertRowIndexToModel(selectedRow);
            Gedcom gedcom = this.mEntity.getGedcom();
            int undoNb = gedcom.getUndoNb();
            final RecordedEventEditorPanel recordedEventPanel = new RecordedEventEditorPanel();
            DialogManager.ADialog recordedEventDialog = new DialogManager.ADialog(NbBundle.getMessage(RecordedEventEditorPanel.class, (String)"RecordedEventEditorPanel.edit.title", (Object)this.mSourceEventTypesTableModel.getDisplayValueAt(rowIndex)), (JComponent)recordedEventPanel);
            recordedEventDialog.setDialogId(RecordedEventEditorPanel.class.getName());
            recordedEventPanel.set(this.mSourceEventTypesTableModel.getValueAt(rowIndex));
            recordedEventPanel.addChangeListener(this.changeListner);
            if (recordedEventDialog.show() == DialogDescriptor.OK_OPTION) {
                try {
                    gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            recordedEventPanel.commit();
                        }
                    });
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            recordedEventPanel.removeChangeListener(this.changeListner);
        }
    }

    private void sourceEventsTableMouseClicked(MouseEvent evt) {
        int selectedRow = this.sourceEventsTable.getSelectedRow();
        if (evt.getClickCount() >= 2 && selectedRow != -1) {
            int rowIndex = this.sourceEventsTable.convertRowIndexToModel(selectedRow);
            Gedcom gedcom = this.mEntity.getGedcom();
            int undoNb = gedcom.getUndoNb();
            final RecordedEventEditorPanel recordedEventPanel = new RecordedEventEditorPanel();
            DialogManager.ADialog recordedEventDialog = new DialogManager.ADialog(NbBundle.getMessage(RecordedEventEditorPanel.class, (String)"RecordedEventEditorPanel.edit.title", (Object)this.mSourceEventTypesTableModel.getDisplayValueAt(rowIndex)), (JComponent)recordedEventPanel);
            recordedEventPanel.set(this.mSourceEventTypesTableModel.getValueAt(rowIndex));
            recordedEventDialog.setDialogId(RecordedEventEditorPanel.class.getName());
            recordedEventPanel.addChangeListener(this.changeListner);
            if (recordedEventDialog.show() == DialogDescriptor.OK_OPTION) {
                try {
                    gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            recordedEventPanel.commit();
                        }
                    });
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            recordedEventPanel.removeChangeListener(this.changeListner);
        }
    }

    private void deleteSourceEventButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.sourceEventsTable.getSelectedRow();
        if (selectedRow != -1) {
            final int rowIndex = this.sourceEventsTable.convertRowIndexToModel(selectedRow);
            DialogManager createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(RecordedEventEditorPanel.class, (String)"RecordedEventEditorPanel.deleteSourceEvent.title"), (String)NbBundle.getMessage(RecordedEventEditorPanel.class, (String)"RecordedEventEditorPanel.deleteSourceEvent.text", (Object)this.mSourceEventTypesTableModel.getDisplayValueAt(selectedRow)));
            if (createYesNo.show() == DialogManager.YES_OPTION) {
                try {
                    this.mParent.getGedcom().doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            SourceRecordedEventsTablePanel.this.mParent.delProperty(SourceRecordedEventsTablePanel.this.mSourceEventTypesTableModel.remove(rowIndex));
                        }
                    });
                    this.changeListner.stateChanged(null);
                    if (this.mSourceEventTypesTableModel.getRowCount() <= 0) {
                        this.editSourceEventButton.setEnabled(false);
                        this.deleteSourceEventButton.setEnabled(false);
                    }
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void setEventTypesList(Entity entity, Property parent, List<Property> eventsTypeList) {
        this.mEntity = entity;
        this.mParent = parent;
        this.mSourceEventTypesTableModel.clear();
        if (eventsTypeList != null) {
            this.mSourceEventTypesTableModel.addAll(eventsTypeList);
        }
        if (this.mSourceEventTypesTableModel.getRowCount() > 0) {
            this.editSourceEventButton.setEnabled(true);
            this.deleteSourceEventButton.setEnabled(true);
        } else {
            this.editSourceEventButton.setEnabled(false);
            this.deleteSourceEventButton.setEnabled(false);
        }
    }

    private class ChangeListner
    implements ChangeListener {
        private ChangeListner() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            SourceRecordedEventsTablePanel.this.changeSupport.fireChange();
        }
    }
}

