/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.media;

import ancestris.modules.editors.media.MediaManagerActionPanel;
import ancestris.modules.editors.media.PathData;
import genj.util.Origin;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class MediaPathTableModel
extends AbstractTableModel {
    private static final String HTML_START = "<html><center>";
    private static final String HTML_MID = "<br>(";
    private static final String HTML_END = ")</center></html>";
    public final ImageIcon SEARCH_LOCAL_ICON = new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_SearchLocal.png"));
    public final ImageIcon SEARCH_REMOTE_ICON = new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_SearchRemote.png"));
    private MediaManagerActionPanel parent = null;
    public static int NBCOLUMNS = 8;
    public static int NBMEDIAS_COLUMN = 0;
    public static int FOUND_COLUMN = 1;
    public static int LOCAL_COLUMN = 2;
    public static int ENTITY_COLUMN = 3;
    public static int NEW_PATH_COLUMN = 4;
    public static int REL_COLUMN = 5;
    public static int ACTION_COLUMN = 6;
    public static int SELECTION_COLUMN = 7;
    private String rootPath = "";
    private final String[] columnNames;
    private Object[][] data;
    private Set<PathData> pathDataList = null;
    private boolean unfound = false;
    private boolean local = false;
    private boolean remote = false;
    private boolean relative = false;
    private boolean absolute = false;
    private boolean selected = false;
    protected int totalMedias = 0;
    protected int totalFound = 0;
    protected int totalLocal = 0;
    protected int totalEntity = 0;
    protected int totalRelative = 0;
    protected int totalSelection = 0;

    public MediaPathTableModel(MediaManagerActionPanel parent, Set<PathData> pathDataList, String rootPath) {
        this.parent = parent;
        this.pathDataList = pathDataList;
        this.rootPath = rootPath;
        this.columnNames = new String[NBCOLUMNS];
        if (pathDataList == null) {
            this.data = new Object[0][NBCOLUMNS];
            return;
        }
        this.resetData();
    }

    public void setFilter(boolean unfound, boolean local, boolean remote, boolean relative, boolean absolute, boolean selected) {
        this.unfound = unfound;
        this.local = local;
        this.remote = remote;
        this.relative = relative;
        this.absolute = absolute;
        this.selected = selected;
        this.resetData();
    }

    public boolean validate(PathData pd) {
        if (this.unfound && pd.found) {
            return false;
        }
        if (this.local && !pd.local) {
            return false;
        }
        if (this.remote && pd.local) {
            return false;
        }
        if (this.relative && !pd.relative) {
            return false;
        }
        if (this.absolute && pd.relative) {
            return false;
        }
        return !this.selected || pd.selected;
    }

    public final void resetData() {
        this.totalMedias = 0;
        this.totalFound = 0;
        this.totalLocal = 0;
        this.totalEntity = 0;
        this.totalRelative = 0;
        this.totalSelection = 0;
        int nb = 0;
        int nbRows = 0;
        for (PathData pathData : this.pathDataList) {
            if (!this.validate(pathData)) continue;
            ++nbRows;
        }
        this.data = new Object[nbRows][NBCOLUMNS];
        int i = 0;
        for (PathData pathData : this.pathDataList) {
            if (!this.validate(pathData)) continue;
            nb = pathData.getNbMedia();
            this.data[i][MediaPathTableModel.NBMEDIAS_COLUMN] = nb;
            this.data[i][MediaPathTableModel.FOUND_COLUMN] = pathData.found;
            this.data[i][MediaPathTableModel.NEW_PATH_COLUMN] = pathData.path;
            this.data[i][MediaPathTableModel.LOCAL_COLUMN] = pathData.local;
            this.data[i][MediaPathTableModel.ENTITY_COLUMN] = pathData.entity;
            this.data[i][MediaPathTableModel.REL_COLUMN] = pathData.relative;
            this.data[i][MediaPathTableModel.ACTION_COLUMN] = pathData.local ? this.SEARCH_LOCAL_ICON : this.SEARCH_REMOTE_ICON;
            this.data[i][MediaPathTableModel.SELECTION_COLUMN] = pathData.selected;
            ++i;
            this.totalMedias += nb;
            this.totalFound += pathData.found ? nb : 0;
            this.totalLocal += pathData.local ? nb : 0;
            this.totalEntity += pathData.entity ? nb : 0;
            this.totalRelative += pathData.relative ? nb : 0;
            this.totalSelection += pathData.selected ? 1 : 0;
        }
        this.columnNames[MediaPathTableModel.NBMEDIAS_COLUMN] = this.getColumnTitle("COL_NbMedia", this.totalMedias);
        this.columnNames[MediaPathTableModel.FOUND_COLUMN] = this.getColumnTitle("COL_Found", this.totalFound);
        this.columnNames[MediaPathTableModel.LOCAL_COLUMN] = this.getColumnTitle("COL_local", this.totalLocal);
        this.columnNames[MediaPathTableModel.ENTITY_COLUMN] = this.getColumnTitle("COL_entity", this.totalEntity);
        this.columnNames[MediaPathTableModel.NEW_PATH_COLUMN] = NbBundle.getMessage(this.getClass(), (String)"COL_newPath");
        this.columnNames[MediaPathTableModel.REL_COLUMN] = this.getColumnTitle("COL_makeRelative", this.totalRelative);
        this.columnNames[MediaPathTableModel.ACTION_COLUMN] = NbBundle.getMessage(this.getClass(), (String)"COL_searchPathButton");
        this.columnNames[MediaPathTableModel.SELECTION_COLUMN] = this.getColumnTitle("COL_selection", this.totalSelection);
        this.fireUpdateTable();
    }

    public void fireUpdateTable() {
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data[rowIndex][columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.getValueAt(0, c) != null ? this.getValueAt(0, c).getClass() : String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == REL_COLUMN || col == ACTION_COLUMN || col == SELECTION_COLUMN;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.data[rowIndex][columnIndex] = aValue;
        if (columnIndex == REL_COLUMN) {
            boolean isLocal = (Boolean)this.data[rowIndex][LOCAL_COLUMN];
            PathData pd = this.parent.getPathDataFromRow(rowIndex);
            if (isLocal) {
                Boolean rel = (Boolean)aValue;
                this.switchRelativeAbsolute(pd, rel);
                this.data[rowIndex][MediaPathTableModel.NEW_PATH_COLUMN] = pd.path;
                this.parent.commitChanges();
            } else {
                this.data[rowIndex][columnIndex] = false;
            }
        }
        if (columnIndex == LOCAL_COLUMN) {
            Boolean isLocal = (Boolean)aValue;
            this.data[rowIndex][MediaPathTableModel.ACTION_COLUMN] = isLocal != false ? this.SEARCH_LOCAL_ICON : this.SEARCH_REMOTE_ICON;
            this.fireTableCellUpdated(rowIndex, ACTION_COLUMN);
        }
        if (columnIndex == SELECTION_COLUMN) {
            PathData pd = this.parent.getPathDataFromRow(rowIndex);
            this.switchSelected(pd, (Boolean)aValue);
            this.parent.updateButtons();
            this.parent.updateSubpathTextField();
        }
    }

    protected String getColumnTitle(String resource, int total) {
        return HTML_START + NbBundle.getMessage(this.getClass(), (String)resource) + HTML_MID + total + HTML_END;
    }

    protected int switchRelativeAbsolute(PathData pd, boolean rel) {
        int nbChanges = 0;
        String oldPath = Origin.getPath((String)pd.path);
        Object newPath = "";
        Path rootbase = Paths.get(this.rootPath, new String[0]);
        Path path = Paths.get(oldPath, new String[0]);
        if (rel && !path.isAbsolute() || !rel && path.isAbsolute()) {
            return nbChanges;
        }
        ++nbChanges;
        if (rel) {
            Path relativePath = rootbase.relativize(path);
            newPath = relativePath.toString();
        } else {
            path = Paths.get(this.rootPath + MediaManagerActionPanel.FSLASH + oldPath, new String[0]);
            Path absolutePath = path.normalize();
            newPath = absolutePath.toString();
        }
        if (!((String)newPath).isEmpty() && !((String)newPath).endsWith(MediaManagerActionPanel.FSLASH)) {
            newPath = (String)newPath + MediaManagerActionPanel.FSLASH;
        }
        pd.setPath((String)newPath);
        pd.setRelative(rel);
        this.totalRelative += rel ? pd.getNbMedia() : -pd.getNbMedia();
        this.parent.updateHeader(REL_COLUMN, this.getColumnTitle("COL_makeRelative", this.totalRelative));
        return nbChanges;
    }

    protected void switchSelected(PathData pd, boolean set) {
        pd.selected = set;
        this.totalSelection += pd.selected ? 1 : -1;
        this.parent.updateHeader(SELECTION_COLUMN, this.getColumnTitle("COL_selection", this.totalSelection));
    }

    protected void updateHeaders() {
        this.parent.updateHeader(NBMEDIAS_COLUMN, this.getColumnTitle("COL_NbMedia", this.totalMedias));
        this.parent.updateHeader(FOUND_COLUMN, this.getColumnTitle("COL_Found", this.totalFound));
        this.parent.updateHeader(LOCAL_COLUMN, this.getColumnTitle("COL_local", this.totalLocal));
        this.parent.updateHeader(ENTITY_COLUMN, this.getColumnTitle("COL_entity", this.totalEntity));
        this.parent.updateHeader(REL_COLUMN, this.getColumnTitle("COL_makeRelative", this.totalRelative));
        this.parent.updateHeader(SELECTION_COLUMN, this.getColumnTitle("COL_selection", this.totalSelection));
    }
}

