/*
 * Decompiled with CFR 0.152.
 */
package genj.option;

import genj.option.Option;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public abstract class OptionProvider {
    private static List<Option> options;

    public abstract List<? extends Option> getOptions();

    public static void persistAll() {
        for (Option option : OptionProvider.getAllOptions()) {
            try {
                option.persist();
            }
            catch (Throwable throwable) {}
        }
    }

    public static synchronized List<Option> getAllOptions() {
        if (options != null) {
            return options;
        }
        ArrayList<Option> ops = new ArrayList<Option>(32);
        Iterator<OptionProvider> providers = OptionProvider.lookupProviders();
        while (providers.hasNext()) {
            OptionProvider provider = providers.next();
            for (Option option : provider.getOptions()) {
                try {
                    option.restore();
                    ops.add(option);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        options = ops;
        return options;
    }

    private static Iterator<OptionProvider> lookupProviders() {
        return ServiceLoader.load(OptionProvider.class).iterator();
    }
}

