/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.GTPlanarizer;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MinimumBendOrthogonalizer;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.RectangularCompactor;

public class OrthogonalLayout<N, E>
extends GraphLayout<N, E> {
    private MGraph<N, E> mGraph = null;
    private GraphScene<N, E> scene = null;
    private final boolean animate;
    public static final int gutter = 55;
    public final int halfGutter = 27;

    public OrthogonalLayout(GraphScene<N, E> scene, boolean animate) {
        this.scene = scene;
        this.animate = animate;
    }

    @Override
    protected void performGraphLayout(UniversalGraph<N, E> graph) {
        this.mGraph = MGraph.createGraph(graph, this.scene);
        GTPlanarizer<N, E> planarizer = new GTPlanarizer<N, E>();
        Collection epgs = planarizer.planarize(this.mGraph);
        MinimumBendOrthogonalizer orthogonalizer = new MinimumBendOrthogonalizer();
        Collection ors = orthogonalizer.orthogonalize(epgs);
        RectangularCompactor compactor = new RectangularCompactor();
        compactor.compact(ors);
        this.layoutNodes();
    }

    private void layoutNodes() {
        Collection<E> edges = this.scene.getEdges();
        for (E e : edges) {
            ConnectionWidget conn = (ConnectionWidget)this.scene.findWidget(e);
            conn.setRouter(RouterFactory.createOrthogonalSearchRouter(new LayerWidget[0]));
        }
        ArrayList<Widget> singletons = new ArrayList<Widget>();
        Collection<MGraph.Vertex<N>> vertices = this.mGraph.getVertices();
        int maxX = -1;
        int maxY = -1;
        for (MGraph.Vertex<N> v : vertices) {
            N node = v.getNodeDesignElement();
            if (node == null) continue;
            Widget w = this.scene.findWidget(node);
            int x = (int)v.getX();
            int y = (int)v.getY();
            Point p = new Point(x, y);
            if (p.x == 0 && p.y == 0) {
                singletons.add(w);
                continue;
            }
            if (this.animate) {
                this.scene.getSceneAnimator().animatePreferredLocation(w, p);
            }
            Rectangle bounds = w.getBounds();
            w.resolveBounds(p, bounds);
            if (x + bounds.width > maxX) {
                maxX = x + bounds.width;
            }
            if (y + bounds.height <= maxY) continue;
            maxY = y + bounds.height;
        }
        if (singletons == null || singletons.size() == 0) {
            return;
        }
        Rectangle sceneBounds = this.scene.getBounds();
        if (sceneBounds.width > maxX) {
            maxX = sceneBounds.width;
        }
        int x = 0;
        int y = maxY + 27;
        int maxHeight = -1;
        for (Widget w : singletons) {
            Rectangle bounds = w.getBounds();
            if (x + bounds.width > maxX) {
                x = 0;
                y = y + maxHeight + 27;
                maxHeight = -1;
            }
            Point p = new Point(x, y);
            if (this.animate) {
                this.scene.getSceneAnimator().animatePreferredLocation(w, p);
            }
            w.resolveBounds(p, bounds);
            x = x + bounds.width + 27;
            if (bounds.height <= maxHeight) continue;
            maxHeight = bounds.height;
        }
    }

    @Override
    protected void performNodesLayout(UniversalGraph<N, E> graph, Collection<N> nodes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

