/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.report;

import ancestris.core.actions.AncestrisAPIEntry;
import ancestris.view.GenjViewTopComponent;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.report.Report;
import genj.report.ReportViewFactory;
import genj.view.ViewFactory;
import java.util.ArrayList;
import org.openide.util.Lookup;

public final class ReportTopComponent
extends GenjViewTopComponent
implements AncestrisAPIEntry {
    private static final String PREFERRED_ID = "ReportTopComponent";
    private static ReportTopComponent factory;
    private static final ViewFactory viewfactory;

    public ReportTopComponent() {
        this.putClientProperty("print.printable", Boolean.TRUE);
    }

    public String getAncestrisDockMode() {
        return "ancestris-output";
    }

    public ViewFactory getViewFactory() {
        return viewfactory;
    }

    public static synchronized ReportTopComponent getFactory() {
        if (factory == null) {
            factory = new ReportTopComponent();
        }
        return factory;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public boolean processAction(String instructions, Entity entity) {
        String[] bits = instructions.split("\\.");
        String reportId = bits[0];
        String command = bits[1];
        for (Report report : new ArrayList(Lookup.getDefault().lookupAll(Report.class))) {
            if (!report.isEntryId(reportId)) continue;
            return report.processAction(command);
        }
        return false;
    }

    public boolean isEntryID(String id) {
        return "ReportContent".equals(id);
    }

    public Gedcom getAPIGedcom() {
        return this.getGedcom();
    }

    static {
        viewfactory = new ReportViewFactory();
    }
}

