/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.TagPath;
import java.io.IOException;

public class ImportGramps
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importgramps_name();
    }

    protected String getImportComment() {
        return Bundle.importgramps_note();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    protected boolean process() throws IOException {
        if (super.process()) {
            return true;
        }
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        String pathBefore = path.getShortName();
        String valueBefore = this.input.getValue();
        if (path.toString().contains("DATE:TIME") && !path.toString().contains("CHAN") && !this.currentXref.equals("HEAD")) {
            this.output.writeLine(this.input.getLevel() - 1, "_TIME", this.input.getValue());
            this.fixes.add(new ImportFix(this.currentXref, "invalidTagLocation.1", pathBefore, path.getParent().getParent().getShortName() + ":_TIME", valueBefore, valueBefore));
            return true;
        }
        return false;
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        return ret;
    }
}

