/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.labelgen;

import ancestris.core.TextOptions;
import ancestris.reports.FormatDateOptions;
import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.FormattingMainOptions;
import ancestris.reports.labelgen.ModeleEnum;
import ancestris.reports.labelgen.ScopeLabelOptions;
import ancestris.reports.labelgen.SheetSizeEnum;
import ancestris.reports.utils.ColorUtils;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import genj.renderer.MediaRenderer;
import genj.report.Report;
import genj.util.ImageSniffer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ReportLabelGenerator
extends Report {
    private static final String NS_XSLFO = "http://www.w3.org/1999/XSL/Format";
    public int modele = 0;
    private final String[] modeleList = new String[ModeleEnum.values().length];
    public FormatOptions formattingOptions = new FormatOptions();
    public SheetFormat sheetFormat = new SheetFormat();
    public ScopeLabelOptions scope = new ScopeLabelOptions();
    public MyData data = new MyData();
    public MyDataFormatOptions dataFormatOptions = new MyDataFormatOptions();
    public MyColorOptions colorOptions = new MyColorOptions();
    private org.w3c.dom.Document content;
    private Element cursor;
    private Queue<Entity> ents = new LinkedList<Entity>();
    private final Map<String, Color> nameColor = new HashMap<String, Color>();
    private final Set<Color> colorUsed = new HashSet<Color>();
    private boolean hasPicture = false;
    private boolean fullPicture = false;

    public String[] getModeles() {
        int i = 0;
        for (ModeleEnum value : ModeleEnum.values()) {
            this.modeleList[i] = this.translate(value.name());
            ++i;
        }
        return this.modeleList;
    }

    public int getModele() {
        return this.modele;
    }

    public void setModele(int set) {
        this.modele = set;
        String name = this.modeleList[set];
        ModeleEnum mode = ModeleEnum.getFromOrder(set);
        if (ModeleEnum.Libre != mode) {
            this.sheetFormat.size = mode.getSize();
            this.sheetFormat.reportOrientation = mode.getOrientation();
            this.sheetFormat.nbLines = mode.getNbLines();
            this.sheetFormat.nbCols = mode.getNbCols();
            this.sheetFormat.unit = 0;
            this.sheetFormat.length = mode.getLength();
            this.sheetFormat.height = mode.getHeight();
            this.sheetFormat.topMargin = mode.getTopMargin();
            this.sheetFormat.leftMargin = mode.getLeftMargin();
            this.sheetFormat.gutterVert = mode.getGutterVert();
            this.sheetFormat.gutterHori = mode.getGutterHori();
        }
    }

    public Document start(Gedcom gedcom) {
        if (this.init() > 0) {
            return null;
        }
        List<Entity> indis = this.scope.getScope(gedcom, this);
        if (indis.size() == 1) {
            Entity ent = indis.get(0);
            if (ent instanceof Indi) {
                Indi indi = (Indi)ent;
                this.getDataAsc(indi, 0);
                this.getDataDesc(indi, 0);
                if (this.scope.sortBySosa) {
                    this.sortEnts();
                }
                return this.start();
            }
        } else if (!indis.isEmpty()) {
            this.ents.addAll(indis);
            if (this.scope.sortBySosa) {
                this.sortEnts();
            }
            return this.start();
        }
        return null;
    }

    public Document start() {
        Document doc = new Document("Labels");
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.content = dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException t) {
            throw new RuntimeException(t);
        }
        SheetSizeEnum sheetSize = SheetSizeEnum.getValue(this.sheetFormat.sizes[this.sheetFormat.size]);
        Element root = this.cursor = (Element)this.content.appendChild(this.content.createElementNS(NS_XSLFO, "root"));
        this.cursor.setAttribute("xmlns", NS_XSLFO);
        this.cursor.setAttribute("font-family", this.formattingOptions.fontNames[this.formattingOptions.fontName]);
        this.cursor.setAttribute("font-size", "12");
        this.defineMaster(sheetSize);
        this.cursor = root;
        this.insertPage(sheetSize, this.sheetFormat.firstLabel);
        while (!this.ents.isEmpty()) {
            this.cursor = root;
            this.insertPage(sheetSize, 1);
        }
        doc.setDomDoc(this.content);
        return doc;
    }

    private int init() {
        this.hasPicture = false;
        this.fullPicture = false;
        this.ents.clear();
        this.nameColor.clear();
        this.colorUsed.clear();
        if (this.sheetFormat.firstLabel < 1 || this.sheetFormat.firstLabel > this.sheetFormat.nbCols * this.sheetFormat.nbLines) {
            this.println(this.translate("error.firstLabel"));
            return 1;
        }
        return 0;
    }

    private void defineMaster(SheetSizeEnum sheetSize) throws DOMException {
        Element elem = this.content.createElementNS(NS_XSLFO, "layout-master-set");
        this.cursor.appendChild(elem);
        this.cursor = elem;
        Element elem1 = this.content.createElementNS(NS_XSLFO, "simple-page-master");
        this.cursor.appendChild(elem1);
        this.cursor = elem1;
        this.cursor.setAttribute("master-name", sheetSize.name());
        double width = this.sheetFormat.reportOrientation == 0 ? sheetSize.getWidth() : sheetSize.getHeight();
        this.cursor.setAttribute("page-width", width + sheetSize.getUnit());
        double height = this.sheetFormat.reportOrientation == 0 ? sheetSize.getHeight() : sheetSize.getWidth();
        this.cursor.setAttribute("page-height", height + sheetSize.getUnit());
        this.cursor.setAttribute("margin-top", this.sheetFormat.topMargin + this.sheetFormat.units[this.sheetFormat.unit]);
        this.cursor.setAttribute("margin-left", this.sheetFormat.leftMargin + this.sheetFormat.units[this.sheetFormat.unit]);
        Element elem2 = this.content.createElementNS(NS_XSLFO, "region-body");
        this.cursor.appendChild(elem2);
    }

    private void insertPage(SheetSizeEnum sheetSize, int firstLabel) throws DOMException {
        Element elem3 = this.content.createElementNS(NS_XSLFO, "page-sequence");
        elem3.setAttribute("master-reference", sheetSize.name());
        this.cursor.appendChild(elem3);
        this.cursor = elem3;
        Element elem4 = this.content.createElementNS(NS_XSLFO, "flow");
        elem4.setAttribute("flow-name", "xsl-region-body");
        this.cursor.appendChild(elem4);
        this.cursor = elem4;
        Element elem5 = this.content.createElementNS(NS_XSLFO, "block");
        this.cursor.appendChild(elem5);
        this.cursor = elem5;
        Element elem6 = this.content.createElementNS(NS_XSLFO, "table");
        elem6.setAttribute("table-layout", "fixed");
        elem6.setAttribute("width", "100%");
        this.cursor.appendChild(elem6);
        this.cursor = elem6;
        int currentLabel = 1;
        for (int i = 0; i < this.sheetFormat.nbCols; ++i) {
            Element elem65 = this.content.createElementNS(NS_XSLFO, "table-column");
            elem65.setAttribute("column-width", this.sheetFormat.length + this.sheetFormat.units[this.sheetFormat.unit]);
            this.cursor.appendChild(elem65);
            if (i >= this.sheetFormat.nbCols - 1 || !(this.sheetFormat.gutterHori > 0.0)) continue;
            Element elem66 = this.content.createElementNS(NS_XSLFO, "table-column");
            elem66.setAttribute("column-width", this.sheetFormat.gutterHori + this.sheetFormat.units[this.sheetFormat.unit]);
            this.cursor.appendChild(elem66);
        }
        Element elem7 = this.content.createElementNS(NS_XSLFO, "table-body");
        this.cursor.appendChild(elem7);
        this.cursor = elem7;
        double colonneHeight = this.sheetFormat.height;
        for (int i = 0; i < this.sheetFormat.nbLines; ++i) {
            Element elemCol;
            Element elemRow = this.content.createElementNS(NS_XSLFO, "table-row");
            this.cursor.appendChild(elemRow);
            for (int j = 0; j < this.sheetFormat.nbCols; ++j) {
                currentLabel = i * this.sheetFormat.nbCols + j + 1;
                elemCol = this.content.createElementNS(NS_XSLFO, "table-cell");
                elemCol.setAttribute("width", this.sheetFormat.length + this.sheetFormat.units[this.sheetFormat.unit]);
                elemCol.setAttribute("height", colonneHeight + this.sheetFormat.units[this.sheetFormat.unit]);
                elemCol.setAttribute("text-align", "center");
                elemCol.setAttribute("overflow", "hidden");
                elemCol.setAttribute("padding", "0");
                elemRow.appendChild(elemCol);
                Element elemBlockCont = this.content.createElementNS(NS_XSLFO, "block-container");
                if (!this.ents.isEmpty() && currentLabel >= firstLabel && this.dataFormatOptions.printBorder) {
                    elemBlockCont.setAttribute("border", "1px solid " + ColorUtils.color2string(this.colorOptions.borderColor));
                }
                double containerWidth = this.sheetFormat.length - 0.2;
                elemBlockCont.setAttribute("width", containerWidth + this.sheetFormat.units[this.sheetFormat.unit]);
                double containerHeight = colonneHeight - 0.2;
                elemBlockCont.setAttribute("height", containerHeight + this.sheetFormat.units[this.sheetFormat.unit]);
                elemBlockCont.setAttribute("position", "absolute");
                elemBlockCont.setAttribute("top", "0.1" + this.sheetFormat.units[this.sheetFormat.unit]);
                elemBlockCont.setAttribute("left", "0.1" + this.sheetFormat.units[this.sheetFormat.unit]);
                elemBlockCont.setAttribute("overflow", "hidden");
                elemBlockCont.setAttribute("display-align", "center");
                elemCol.appendChild(elemBlockCont);
                if (currentLabel >= firstLabel) {
                    this.addText(elemBlockCont);
                } else {
                    this.pushText("", elemBlockCont, 12, "");
                }
                if (j >= this.sheetFormat.nbCols - 1 || !(this.sheetFormat.gutterHori > 0.0)) continue;
                Element elemSpace = this.content.createElementNS(NS_XSLFO, "table-cell");
                elemRow.appendChild(elemSpace);
                Element elemSpaceBlock = this.content.createElementNS(NS_XSLFO, "block");
                elemSpace.appendChild(elemSpaceBlock);
            }
            if (i >= this.sheetFormat.nbLines - 1 || !(this.sheetFormat.gutterVert > 0.0)) continue;
            Element elemRowSpace = this.content.createElementNS(NS_XSLFO, "table-row");
            this.cursor.appendChild(elemRowSpace);
            elemCol = this.content.createElementNS(NS_XSLFO, "table-cell");
            elemCol.setAttribute("height", this.sheetFormat.gutterVert + this.sheetFormat.units[this.sheetFormat.unit]);
            elemCol.setAttribute("border", "none");
            elemCol.setAttribute("number-columns-spanned", String.valueOf(this.sheetFormat.nbCols));
            elemRowSpace.appendChild(elemCol);
            Element elemBlock = this.content.createElementNS(NS_XSLFO, "block");
            elemCol.appendChild(elemBlock);
        }
    }

    private void addText(Element container) throws DOMException {
        Element elemBlockCont = container;
        Entity current = this.ents.poll();
        if (current == null) {
            this.pushText("", elemBlockCont, 12, "");
            return;
        }
        if (current instanceof Indi && !this.data.createIndiLabels || current instanceof Fam && !this.data.createFamLabels) {
            this.addText(elemBlockCont);
            return;
        }
        if (current instanceof Indi) {
            Indi indi = (Indi)current;
            elemBlockCont.setAttribute("background-color", ColorUtils.color2string(this.getBackColor(indi)));
            elemBlockCont.setAttribute("color", ColorUtils.color2string(this.getColor(indi)));
            if (this.data.picture) {
                InputSource image = MediaRenderer.getSource((Property)indi);
                if (image != null) {
                    this.hasPicture = true;
                    this.fullPicture = this.getFullPicture();
                    elemBlockCont = this.pushImage(image, elemBlockCont);
                    if (this.fullPicture) {
                        return;
                    }
                } else {
                    this.hasPicture = false;
                }
            }
            if (this.data.sosaNumber && this.data.id) {
                String value = indi.getSosaString() + "\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0" + indi.getId();
                this.pushText(value, elemBlockCont, 8, "");
            } else if (this.data.sosaNumber) {
                this.pushText(indi.getSosaString(), elemBlockCont, 8, "");
            } else if (this.data.id) {
                this.pushText(indi.getId(), elemBlockCont, 8, "");
            }
            String surname = indi.getFullSurname();
            String givenName = indi.getFirstName();
            if (!this.data.allFirstname) {
                String[] names = indi.getFirstName().split("  *");
                givenName = names[0];
            }
            switch (this.data.nameOrientation) {
                case 0: {
                    this.pushText(surname + " " + givenName, elemBlockCont, 12, "", true);
                    break;
                }
                case 1: {
                    this.pushText(givenName + " " + surname, elemBlockCont, 12, "", true);
                    break;
                }
                case 3: {
                    this.pushText(givenName, elemBlockCont, 11, "", true);
                    this.pushText(surname, elemBlockCont, 12, "", true);
                    break;
                }
                default: {
                    this.pushText(surname, elemBlockCont, 12, "", true);
                    this.pushText(givenName, elemBlockCont, 11, "", true);
                }
            }
            if (this.data.occupation > 0) {
                this.addOccupation(elemBlockCont, indi);
            }
            String birthDate = this.dataFormatOptions.date.getDate((Property)indi.getBirthDateOption());
            String birthPlace = this.dataFormatOptions.place.getPlace((Property)indi.getBirthPlaceOption());
            this.pushDatePlace(birthDate, birthPlace, elemBlockCont, this.data.birthdate, this.data.birthplace, TextOptions.getInstance().getBirthSymbol());
            if ((this.data.marrdate || this.data.marrplace) && !this.data.createFamLabels) {
                Fam[] fams = indi.getFamiliesWhereSpouse();
                if (fams.length > 0) {
                    String marriageDate = this.dataFormatOptions.date.getDate((Property)fams[0].getMarriageDate());
                    String marriagePlace = this.dataFormatOptions.place.getPlace((Property)fams[0].getMarriagePlace());
                    this.pushDatePlace(marriageDate, marriagePlace, elemBlockCont, this.data.marrdate, this.data.marrplace, TextOptions.getInstance().getMarriageSymbol());
                } else {
                    this.pushText(null, elemBlockCont, 10, "");
                    if (!this.dataFormatOptions.placeDateLine) {
                        this.pushText(null, elemBlockCont, 10, "");
                    }
                }
            }
            String deathDate = this.dataFormatOptions.date.getDate((Property)indi.getDeathDateOption());
            String deathPlace = this.dataFormatOptions.place.getPlace((Property)indi.getDeathPlaceOption());
            this.pushDatePlace(deathDate, deathPlace, elemBlockCont, this.data.deathdate, this.data.deathplace, TextOptions.getInstance().getDeathSymbol());
        }
        if (current instanceof Fam) {
            Fam fam = (Fam)current;
            elemBlockCont.setAttribute("color", ColorUtils.color2string(this.colorOptions.textColor));
            String marriageDate = this.dataFormatOptions.date.getDate((Property)fam.getMarriageDate());
            String marriagePlace = this.dataFormatOptions.place.getPlace((Property)fam.getMarriagePlace());
            String divDate = this.dataFormatOptions.date.getDate((Property)fam.getDivorceDate());
            String divPlace = this.dataFormatOptions.date.getDate(fam.getProperty(Fam.PATH_FAMDIVPLAC));
            if (this.data.id) {
                this.pushText(fam.getId(), elemBlockCont, 8, "");
            }
            this.pushDatePlace(marriageDate, marriagePlace, elemBlockCont, this.data.marrdate, this.data.marrplace, TextOptions.getInstance().getMarriageSymbol());
            this.pushDatePlace(divDate, divPlace, elemBlockCont, this.data.divdate, this.data.divplace, TextOptions.getInstance().getDivorceSymbol());
        }
    }

    private void addOccupation(Element elemBlockCont, Indi indi) throws DOMException {
        Property occu;
        Object value = "";
        if (this.data.occupation == 1 && (occu = indi.getProperty("OCCU")) != null) {
            value = occu.getReportValue();
        }
        if (this.data.occupation == 2) {
            for (Property occu2 : indi.getAllProperties("OCCU")) {
                value = (String)value + occu2.getReportValue() + ", ";
            }
            if (((String)value).length() > 0) {
                value = ((String)value).substring(0, ((String)value).length() - 2);
            }
        }
        if (value != null && !((String)value).isBlank()) {
            this.pushText((String)value, elemBlockCont, 10, "");
        } else {
            this.pushText(null, elemBlockCont, 10, "");
        }
    }

    private void pushDatePlace(String theDate, String thePlace, Element elemBlockCont, boolean date, boolean place, String symbol) throws DOMException {
        StringBuilder value = new StringBuilder();
        if (this.dataFormatOptions.placeDateLine) {
            if (date) {
                value.append(theDate);
            }
            if (place) {
                if (date) {
                    value.append(" ");
                }
                value.append(thePlace);
            }
            this.pushText(value.toString(), elemBlockCont, 10, symbol);
        } else {
            if (date) {
                this.pushText(theDate, elemBlockCont, 10, symbol);
            }
            if (place) {
                this.pushText(thePlace, elemBlockCont, 10, date ? "" : symbol);
            }
        }
    }

    private void pushText(String value, Element elemBlockCont, int initFontS, String symbol) throws DOMException {
        this.pushText(value, elemBlockCont, initFontS, symbol, false);
    }

    private void pushText(String value, Element elemBlockCont, int initFontS, String symbol, boolean bold) throws DOMException {
        Object valeur = value;
        if ((valeur == null || ((String)valeur).isBlank()) && !this.dataFormatOptions.keepSpace) {
            return;
        }
        if ((valeur == null || ((String)valeur).isBlank()) && this.dataFormatOptions.keepSpace) {
            valeur = "\u00a0";
        } else if (symbol != null && !symbol.isBlank()) {
            valeur = symbol + " " + (String)valeur;
        }
        int fontSize = this.adjustFontSize((String)valeur, initFontS, bold);
        Element elemBlock = this.content.createElementNS(NS_XSLFO, "block");
        elemBlock.setAttribute("font-size", "" + fontSize);
        if (bold) {
            elemBlock.setAttribute("font-weight", "bold");
        }
        Text textNode = this.content.createTextNode((String)valeur);
        elemBlock.appendChild(textNode);
        elemBlockCont.appendChild(elemBlock);
    }

    private Element pushImage(InputSource source, Element elemBlockCont) {
        Object src = "";
        if (source instanceof FileInput) {
            FileInput myFile = (FileInput)source;
            src = "file:///" + myFile.getLocation().replace('\\', '/');
        } else if (source instanceof URLInput) {
            URLInput myUrl = (URLInput)source;
            if (!myUrl.isAvailable()) {
                return elemBlockCont;
            }
            try {
                Dimension2D dim = new ImageSniffer(myUrl.open()).getDimensionInInches();
                if (dim == null) {
                    return elemBlockCont;
                }
                src = myUrl.getLocation();
            }
            catch (IOException e) {
                return elemBlockCont;
            }
        }
        Element table = this.content.createElementNS(NS_XSLFO, "table");
        double containerHeight = this.sheetFormat.height - 0.3;
        table.setAttribute("height", containerHeight + this.sheetFormat.units[this.sheetFormat.unit]);
        elemBlockCont.appendChild(table);
        double blockWidth = this.fullPicture ? this.sheetFormat.length - 0.2 : this.sheetFormat.length / 3.0 - 0.1;
        Element elem65 = this.content.createElementNS(NS_XSLFO, "table-column");
        elem65.setAttribute("column-width", blockWidth + this.sheetFormat.units[this.sheetFormat.unit]);
        table.appendChild(elem65);
        if (!this.fullPicture) {
            Element elem66 = this.content.createElementNS(NS_XSLFO, "table-column");
            blockWidth = 2.0 * this.sheetFormat.length / 3.0 - 0.1;
            elem66.setAttribute("column-width", blockWidth + this.sheetFormat.units[this.sheetFormat.unit]);
            table.appendChild(elem66);
        }
        Element tableBody = this.content.createElementNS(NS_XSLFO, "table-body");
        table.appendChild(tableBody);
        Element tableRow = this.content.createElementNS(NS_XSLFO, "table-row");
        tableBody.appendChild(tableRow);
        Element tableCell1 = this.content.createElementNS(NS_XSLFO, "table-cell");
        tableCell1.setAttribute("vertical-align", "middle");
        tableCell1.setAttribute("height", containerHeight + this.sheetFormat.units[this.sheetFormat.unit]);
        tableRow.appendChild(tableCell1);
        Element block = this.content.createElementNS(NS_XSLFO, "block");
        tableCell1.appendChild(block);
        Element image = this.content.createElementNS(NS_XSLFO, "external-graphic");
        block.appendChild(image);
        image.setAttribute("src", (String)src);
        image.setAttribute("height", containerHeight + this.sheetFormat.units[this.sheetFormat.unit]);
        blockWidth = this.fullPicture ? this.sheetFormat.length - 0.2 : this.sheetFormat.length / 3.0 - 0.1;
        image.setAttribute("width", blockWidth + this.sheetFormat.units[this.sheetFormat.unit]);
        image.setAttribute("content-height", "scale-to-fit");
        image.setAttribute("content-width", "scale-to-fit");
        if (!this.fullPicture) {
            Element blockCell2 = this.content.createElementNS(NS_XSLFO, "table-cell");
            blockWidth = 2.0 * this.sheetFormat.length / 3.0 - 0.1;
            blockCell2.setAttribute("width", blockWidth + this.sheetFormat.units[this.sheetFormat.unit]);
            blockCell2.setAttribute("height", containerHeight + this.sheetFormat.units[this.sheetFormat.unit]);
            tableRow.appendChild(blockCell2);
            return blockCell2;
        }
        return elemBlockCont;
    }

    private boolean getFullPicture() {
        boolean retour = this.hasPicture;
        retour = retour && !this.data.deathdate && !this.data.deathplace;
        retour = retour && !this.data.birthdate && !this.data.birthplace;
        retour = retour && this.data.occupation == 0 && !this.data.sosaNumber;
        retour = retour && !this.data.id;
        return retour;
    }

    private void getDataAsc(Indi person, int nbGen) {
        if (this.data.createIndiLabels) {
            this.ents.add((Entity)person);
        }
        if (this.scope.displayWife && nbGen == 0) {
            for (Fam f : person.getFamiliesWhereSpouse()) {
                Indi spouse;
                if (this.data.createFamLabels) {
                    this.ents.add((Entity)f);
                }
                if ((spouse = f.getOtherSpouse(person)) == null || !this.data.createIndiLabels) continue;
                this.ents.add((Entity)spouse);
            }
        }
        if (nbGen < this.scope.nbGenAsc && person.getFamilyWhereBiologicalChild() != null) {
            Fam parents = person.getFamilyWhereBiologicalChild();
            if (this.data.createFamLabels) {
                this.ents.add((Entity)parents);
            }
            if (this.scope.displaySiblings && nbGen == 0) {
                for (Indi child : parents.getChildren()) {
                    if (child.equals(person) || !this.data.createIndiLabels) continue;
                    this.ents.add((Entity)child);
                }
            }
            ++nbGen;
            if (parents.getHusband() != null) {
                this.getDataAsc(parents.getHusband(), nbGen);
            }
            if (parents.getWife() != null) {
                this.getDataAsc(parents.getWife(), nbGen);
            }
        }
    }

    private void getDataDesc(Indi person, int nbGen) {
        if (nbGen < this.scope.nbGenDesc) {
            ++nbGen;
            for (Indi child : person.getChildren()) {
                if (this.data.createIndiLabels) {
                    this.ents.add((Entity)child);
                }
                if (this.scope.displayWife) {
                    for (Fam spouse : child.getFamiliesWhereSpouse()) {
                        if (this.data.createFamLabels) {
                            this.ents.add((Entity)spouse);
                        }
                        if (!this.data.createIndiLabels) continue;
                        this.ents.add((Entity)spouse.getOtherSpouse(child));
                    }
                }
                this.getDataDesc(child, nbGen);
            }
        }
    }

    private int adjustFontSize(String value, int initFontS, boolean bold) {
        int fontS = initFontS;
        if (!this.formattingOptions.adjustFont) {
            return fontS;
        }
        Font theFont = new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], bold ? 1 : 0, fontS);
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setFont(theFont);
        FontMetrics fm = g2d.getFontMetrics();
        double maxWidth = 0.0;
        maxWidth = this.hasPicture ? (this.sheetFormat.unit == 0 ? ReportLabelGenerator.cmToPoints(2.0 * this.sheetFormat.length / 3.0 - 0.2) : ReportLabelGenerator.inchToPoints(2.0 * this.sheetFormat.length / 3.0 - 0.2)) : (this.sheetFormat.unit == 0 ? ReportLabelGenerator.cmToPoints(this.sheetFormat.length - 0.2) : ReportLabelGenerator.inchToPoints(this.sheetFormat.length - 0.2));
        double width = fm.stringWidth(value);
        while (fontS > 4 && width > maxWidth) {
            theFont = theFont.deriveFont((float)(--fontS));
            g2d.setFont(theFont);
            fm = g2d.getFontMetrics();
            width = fm.stringWidth(value);
        }
        g2d.dispose();
        return fontS;
    }

    private static double cmToPoints(double cm) {
        return cm * 28.34645652770996;
    }

    private static double inchToPoints(double inch) {
        return inch * 72.0;
    }

    private Color getColor(Indi person) {
        return switch (this.colorOptions.colorScheme) {
            case 0 -> Color.BLACK;
            case 1 -> {
                switch (person.getSex()) {
                    case 1: {
                        yield this.colorOptions.sexMText;
                    }
                    case 2: {
                        yield this.colorOptions.sexFText;
                    }
                }
                yield Color.BLACK;
            }
            default -> this.colorOptions.textColor;
        };
    }

    private Color getBackColor(Indi person) {
        return switch (this.colorOptions.colorScheme) {
            case 0 -> Color.WHITE;
            case 1 -> {
                switch (person.getSex()) {
                    case 1: {
                        yield this.colorOptions.sexMColor;
                    }
                    case 2: {
                        yield this.colorOptions.sexFColor;
                    }
                }
                yield Color.WHITE;
            }
            case 2 -> this.getRandomColor(person.getLastName());
            case 3 -> this.manageGeoColor(person);
            case 4 -> this.manageOccuColor(person);
            case 5 -> this.colorOptions.backgroundColor;
            default -> Color.WHITE;
        };
    }

    private Color manageGeoColor(Indi indi) {
        PropertyPlace place = indi.getBirthPlaceOption();
        if (place != null) {
            return this.getRandomColor(this.dataFormatOptions.place.getPlace((Property)place));
        }
        place = indi.getDeathPlaceOption();
        if (place != null) {
            return this.getRandomColor(this.dataFormatOptions.place.getPlace((Property)place));
        }
        Fam[] fams = indi.getFamiliesWhereSpouse();
        if (fams.length > 0 && (place = fams[0].getMarriagePlace()) != null) {
            return this.getRandomColor(this.dataFormatOptions.place.getPlace((Property)place));
        }
        return Color.WHITE;
    }

    private Color manageOccuColor(Indi indi) {
        Property occu = indi.getProperty("OCCU");
        if (occu != null) {
            return this.getRandomColor(occu.getDisplayValue());
        }
        return Color.WHITE;
    }

    private Color getRandomColor(String value) {
        if ("".equals(value)) {
            return Color.WHITE;
        }
        Color color = this.nameColor.get(value);
        if (color != null) {
            return color;
        }
        color = ColorUtils.getRandomColor();
        while (this.colorUsed.contains(color)) {
            color = ColorUtils.getRandomColor();
        }
        this.nameColor.put(value, color);
        this.colorUsed.add(color);
        return color;
    }

    private void sortEnts() {
        Collections.sort((LinkedList)this.ents, new MyComp());
    }

    public class FormatOptions {
        public int fontName = 0;
        public String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        public boolean adjustFont = true;
    }

    public class SheetFormat {
        public int size = 0;
        public String[] sizes = new String[]{"A4", "A3", "A5", "US-Letter"};
        public int reportOrientation = 0;
        public String[] reportOrientations = new String[]{NbBundle.getMessage(FormattingMainOptions.class, (String)"OrientationPO"), NbBundle.getMessage(FormattingMainOptions.class, (String)"OrientationLA")};
        public int nbLines = 7;
        public int nbCols = 5;
        public int firstLabel = 1;
        public int unit = 0;
        public String[] units = new String[]{"cm", "in"};
        public double length = 3.5;
        public double height = 3.5;
        public double topMargin = 1.0;
        public double leftMargin = 1.0;
        public double gutterVert = 0.2;
        public double gutterHori = 0.2;
    }

    public class MyData {
        public boolean createIndiLabels = true;
        public boolean createFamLabels = true;
        public boolean id = false;
        public boolean sosaNumber = true;
        public int nameOrientation = 0;
        public String[] nameOrientations = new String[]{ReportLabelGenerator.this.translate("SURN_GIVN"), ReportLabelGenerator.this.translate("GIVN_SURN"), ReportLabelGenerator.this.translate("TWO_LINE"), ReportLabelGenerator.this.translate("TWO_LINE_S")};
        public boolean allFirstname = true;
        public int occupation = 0;
        public String[] occupations = new String[]{ReportLabelGenerator.this.translate("NONE_OCCU"), ReportLabelGenerator.this.translate("ONLY_ONE_OCCU"), ReportLabelGenerator.this.translate("ALL_OCCUPATION")};
        public boolean birthdate = true;
        public boolean birthplace = true;
        public boolean deathdate = true;
        public boolean deathplace = true;
        public boolean marrdate = true;
        public boolean marrplace = true;
        public boolean divdate = false;
        public boolean divplace = false;
        public boolean picture = false;
    }

    public class MyDataFormatOptions {
        public boolean keepSpace = true;
        public boolean placeDateLine = true;
        public FormatPlaceOptions place = new FormatPlaceOptions();
        public FormatDateOptions date = new FormatDateOptions();
        public boolean printBorder = true;
    }

    public final class MyColorOptions {
        public int colorScheme = 0;
        public String[] colorSchemes = new String[]{ReportLabelGenerator.this.translate("colouroption.0"), ReportLabelGenerator.this.translate("colouroption.1"), ReportLabelGenerator.this.translate("colouroption.2"), ReportLabelGenerator.this.translate("colouroption.3"), ReportLabelGenerator.this.translate("colouroption.4"), ReportLabelGenerator.this.translate("colouroption.5")};
        public Color textColor = Color.BLACK;
        public Color backgroundColor = Color.WHITE;
        public Color borderColor = Color.BLACK;
        public Color sexMColor = new Color(255, 200, 200);
        public Color sexMText = Color.BLUE;
        public Color sexFColor = new Color(200, 200, 255);
        public Color sexFText = Color.RED;
    }

    private static class MyComp
    implements Comparator<Entity> {
        private MyComp() {
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof Indi) {
                Indi indi1 = (Indi)o1;
                if (o2 instanceof Indi) {
                    Indi indi2 = (Indi)o2;
                    Property sosa1 = indi1.getSosa(true);
                    Property sosa2 = indi2.getSosa(true);
                    if (sosa1 != null && sosa2 != null) {
                        return sosa1.compareTo(sosa2);
                    }
                    if (sosa1 != null && sosa2 == null) {
                        return -1;
                    }
                    if (sosa1 == null && sosa2 == null) {
                        return indi1.compareTo((Property)indi2);
                    }
                    return 1;
                }
                return -1;
            }
            if (o1 instanceof Fam) {
                Fam fam1 = (Fam)o1;
                if (o2 instanceof Fam) {
                    Fam fam2 = (Fam)o2;
                    return fam1.compareTo((Property)fam2);
                }
                return 1;
            }
            return 0;
        }
    }
}

