/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.occupationhistory;

import genj.chart.Chart;
import genj.chart.IndexedSeries;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyName;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ReportOccupationHistory
extends Report {
    private static String mainTag = "OCCU";
    private List<String> tagValues;
    private int lifespanWithoutDEAT = 80;
    public int topn = 10;
    public boolean makeGroupOther = false;

    public Chart start(Indi[] indis) {
        return this.start(indis[0].getGedcom());
    }

    public Chart start(Gedcom gedcom) {
        this.topn = Math.max(1, this.topn);
        this.lifespanWithoutDEAT = Math.max(20, Math.min(120, this.lifespanWithoutDEAT));
        Collection indis = gedcom.getIndis();
        this.tagValues = this.getTagValues(indis);
        int start = this.findStart(indis);
        int length = PointInTime.getNow().getYear() - start + 1;
        IndexedSeries others = new IndexedSeries("", start, length);
        TreeMap<String, IndexedSeries> name2series = new TreeMap<String, IndexedSeries>(new RankSort());
        for (Indi indi : indis) {
            this.analyze(indi, name2series, others, this.getRank(this.getProperty(indi, mainTag)));
        }
        if (name2series.isEmpty()) {
            return null;
        }
        if (this.makeGroupOther) {
            others.setName(this.translate("others"));
            name2series.put(String.valueOf('\uffff'), others);
        }
        return new Chart(this.translate("title", new Object[]{gedcom.getDisplayName()}), null, this.translate("yaxis"), IndexedSeries.toArray(name2series.values()), (NumberFormat)new DecimalFormat("#"), (NumberFormat)new DecimalFormat("#,###"), true);
    }

    private int findStart(Collection<Indi> indis) {
        int result = PointInTime.getNow().getYear() - 100;
        for (Indi indi : indis) {
            PointInTime start;
            PropertyDate birth = indi.getBirthDateOption();
            if (birth == null || !(start = birth.getStart()).isValid()) continue;
            try {
                result = Math.min(result, start.getPointInTime((Calendar)PointInTime.GREGORIAN).getYear());
            }
            catch (GedcomException gedcomException) {}
        }
        return result;
    }

    private void analyze(Indi indi, Map<String, IndexedSeries> name2series, IndexedSeries others, int rank) {
        IndexedSeries series;
        int start;
        PropertyName name = (PropertyName)indi.getProperty("NAME");
        if (name == null || !name.isValid()) {
            return;
        }
        String lastname = this.getProperty(indi, mainTag);
        if (lastname.isBlank()) {
            return;
        }
        try {
            start = indi.getBirthDateOption().getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
            if (start == Integer.MAX_VALUE) {
                return;
            }
        }
        catch (Throwable t) {
            return;
        }
        int end = Integer.MAX_VALUE;
        try {
            end = indi.getDeathDateOption().getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (end == Integer.MAX_VALUE) {
            end = start + this.lifespanWithoutDEAT;
        }
        if (rank > this.topn) {
            if (!this.makeGroupOther) {
                return;
            }
            series = others;
        } else {
            series = name2series.get(lastname);
            if (series == null) {
                series = new IndexedSeries(lastname, others);
                name2series.put(lastname, series);
            }
        }
        while (start <= end) {
            series.inc(start);
            ++start;
        }
    }

    private List<String> getTagValues(Collection<Indi> indis) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (Indi indi : indis) {
            String name = this.getProperty(indi, mainTag);
            if (name.isBlank()) continue;
            Integer count = (Integer)countMap.get(name);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            count = count + 1;
            countMap.put(name, count);
        }
        Map topNSortedMap = countMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(this.topn).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        return topNSortedMap.keySet().stream().toList();
    }

    private int getRank(String name) {
        int rank = this.tagValues.indexOf(name);
        return rank > -1 ? rank : this.tagValues.size() + 1;
    }

    private String getProperty(Indi indi, String tag) {
        Property prop;
        Property[] props = indi.getProperties(tag);
        Property property = prop = props.length > 0 ? props[props.length - 1] : null;
        if (prop == null) {
            return "";
        }
        return prop.getDisplayValue();
    }

    private class RankSort
    implements Comparator<String> {
        private RankSort() {
        }

        @Override
        public int compare(String o1, String o2) {
            return ReportOccupationHistory.this.getRank(o1) - ReportOccupationHistory.this.getRank(o2);
        }
    }
}

