/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.editors;

import ancestris.api.editor.Editor;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import javax.swing.JComponent;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public abstract class EntityEditor
extends Editor {
    private final boolean isNew;

    public EntityEditor(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean showPanel() {
        Gedcom gedcom = this.getContext().getGedcom();
        int undoNb = gedcom.getUndoNb();
        DialogManager.ADialog dialogManager = new DialogManager.ADialog(this.getTitle(), (JComponent)((Object)this));
        dialogManager.setDialogId(((Object)((Object)this)).getClass().getName());
        if (dialogManager.show().equals(NotifyDescriptor.OK_OPTION)) {
            if (this.changes.hasChanged()) {
                try {
                    gedcom.doUnitOfWork(gedcom1 -> this.commit());
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return false;
                }
                this.changes.fireChangeEvent();
            }
            return true;
        }
        while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
            gedcom.undoUnitOfWork(false);
        }
        return false;
    }

    public boolean isNew() {
        return this.isNew;
    }
}

