/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import ancestris.modules.editors.aries.utilities.PropertyTag2Name;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.PropertyXRef;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class AssociationsTableModel
extends AbstractTableModel {
    List<PropertyAssociation> mPropertyAssociationList = new ArrayList<PropertyAssociation>();
    final String[] columnsName = new String[]{NbBundle.getMessage(AssociationsTableModel.class, (String)"AssociationsTableModel.column.associatedIndi.title"), NbBundle.getMessage(AssociationsTableModel.class, (String)"AssociationsTableModel.column.event.title"), NbBundle.getMessage(AssociationsTableModel.class, (String)"AssociationsTableModel.column.relation.title"), NbBundle.getMessage(AssociationsTableModel.class, (String)"AssociationsTableModel.column.source.title"), NbBundle.getMessage(AssociationsTableModel.class, (String)"AssociationsTableModel.column.note.title")};

    @Override
    public int getRowCount() {
        return this.mPropertyAssociationList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        PropertyAssociation propertyAssociation = this.mPropertyAssociationList.get(row);
        if (propertyAssociation != null) {
            switch (column) {
                case 0: {
                    PropertyXRef target = propertyAssociation.getTarget();
                    if (target != null) {
                        Entity entity;
                        if (target.getEntity() != null && (entity = target.getEntity()) instanceof Indi) {
                            Indi indi = (Indi)entity;
                            return "(" + indi.getId() + ") " + indi.getName();
                        }
                        if (target.getEntity() != null && (entity = target.getEntity()) instanceof Fam) {
                            Fam fam = (Fam)entity;
                            return "(" + fam.getId() + ") " + fam.getNames();
                        }
                    } else {
                        return "";
                    }
                }
                case 1: {
                    if (propertyAssociation.isGrammar7()) {
                        Property event = propertyAssociation.getEvent(true);
                        return event != null ? PropertyTag2Name.getTagName(event.getTag()) : "";
                    }
                    PropertyRelationship relation = (PropertyRelationship)propertyAssociation.getProperty("RELA");
                    if (relation != null) {
                        String value = relation.getValue();
                        int index = value.lastIndexOf(":");
                        if (index >= 0) {
                            return PropertyTag2Name.getTagName(value.substring(index + 1).replaceAll("@", ""));
                        }
                        return "";
                    }
                }
                case 2: {
                    return propertyAssociation.getRole();
                }
                case 3: {
                    if (propertyAssociation.getProperty("SOUR") != null) {
                        return NbBundle.getMessage(AssociationsTableModel.class, (String)"AssociationsTableModel.column.source.value.yes");
                    }
                    return NbBundle.getMessage(AssociationsTableModel.class, (String)"AssociationsTableModel.column.source.value.no");
                }
                case 4: {
                    boolean hasNote = propertyAssociation.getProperty("NOTE") != null;
                    boolean bl = hasNote = hasNote || propertyAssociation.isGrammar7() && propertyAssociation.getProperty("SNOTE") != null;
                    if (hasNote) {
                        return NbBundle.getMessage(AssociationsTableModel.class, (String)"AssociationsTableModel.column.note.value.yes");
                    }
                    return NbBundle.getMessage(AssociationsTableModel.class, (String)"AssociationsTableModel.column.note.value.no");
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public String[] getColumnsName() {
        return this.columnsName;
    }

    public PropertyAssociation getValueAt(int row) {
        return this.mPropertyAssociationList.get(row);
    }

    public void add(PropertyAssociation propertyAssociation) {
        this.mPropertyAssociationList.add(propertyAssociation);
        this.fireTableDataChanged();
    }

    public void addAll(List<PropertyAssociation> propertyAssociationList) {
        this.mPropertyAssociationList.addAll(propertyAssociationList);
        this.fireTableDataChanged();
    }

    public PropertyAssociation remove(int row) {
        PropertyAssociation source = this.mPropertyAssociationList.remove(row);
        this.fireTableDataChanged();
        return source;
    }

    public void clear() {
        this.mPropertyAssociationList.clear();
    }
}

