/*
 * Decompiled with CFR 0.152.
 */
package gj.awt.geom;

import gj.awt.geom.Geometry;
import gj.awt.geom.PathIteratorKnowHow;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Path
implements Shape,
PathIteratorKnowHow {
    private final GeneralPath gp = new GeneralPath();
    private double lastAngle;
    private final Point2D.Double lastPoint = new Point2D.Double();
    private Rectangle2D overrideBounds = null;

    public synchronized Point2D getLastPoint() {
        return new Point2D.Double(this.lastPoint.x, this.lastPoint.y);
    }

    public synchronized double getLastAngle() {
        return this.lastAngle;
    }

    public synchronized void translate(Point2D delta) {
        this.translate(delta.getX(), delta.getY());
    }

    public synchronized void translate(double dx, double dy) {
        this.gp.transform(AffineTransform.getTranslateInstance(dx, dy));
        this.lastPoint.setLocation(this.lastPoint.getX() + dx, this.lastPoint.getY() + dy);
    }

    public synchronized void reset() {
        this.gp.reset();
        this.lastPoint.setLocation(0.0, 0.0);
        this.lastAngle = 0.0;
    }

    public synchronized Path set(Shape shape) {
        this.gp.reset();
        Point2D.Double p = new Point2D.Double();
        PathIterator it = shape.getPathIterator(null);
        float[] vals = new float[6];
        while (!it.isDone()) {
            int type = it.currentSegment(vals);
            int i = -1;
            switch (type) {
                case 4: {
                    throw new IllegalArgumentException("Path cannot be closed");
                }
                case 3: {
                    this.gp.curveTo(vals[0], vals[1], vals[2], vals[3], vals[4], vals[5]);
                    i = 4;
                    break;
                }
                case 1: {
                    this.gp.lineTo(vals[0], vals[1]);
                    i = 0;
                    break;
                }
                case 0: {
                    this.gp.moveTo(vals[0], vals[1]);
                    i = 0;
                    break;
                }
                case 2: {
                    this.gp.quadTo(vals[0], vals[1], vals[2], vals[3]);
                    i = 2;
                }
            }
            this.lastPoint.setLocation(p.getX(), p.getY());
            p.setLocation(vals[i + 0], vals[i + 1]);
            it.next();
        }
        this.lastAngle = Geometry.getAngle(this.lastPoint, p);
        this.lastPoint.setLocation(p.getX(), p.getY());
        return this;
    }

    public synchronized Path moveTo(Point2D p) {
        this.gp.moveTo((float)p.getX(), (float)p.getY());
        this.lastAngle = Geometry.getAngle(this.lastPoint, p);
        this.lastPoint.setLocation(p.getX(), p.getY());
        return this;
    }

    public synchronized Path lineTo(Point2D p) {
        this.gp.lineTo((float)p.getX(), (float)p.getY());
        this.lastAngle = Geometry.getAngle(this.lastPoint, p);
        this.lastPoint.setLocation(p.getX(), p.getY());
        return this;
    }

    public synchronized Path quadTo(Point2D c, Point2D p) {
        this.gp.quadTo((float)c.getX(), (float)c.getY(), (float)p.getX(), (float)p.getY());
        this.lastPoint.setLocation(p.getX(), p.getY());
        return this;
    }

    public synchronized Path curveTo(Point2D c1, Point2D c2, Point2D p) {
        this.gp.curveTo((float)c1.getX(), (float)c1.getY(), (float)c2.getX(), (float)c2.getY(), (float)p.getX(), (float)p.getY());
        this.lastPoint.setLocation(p.getX(), p.getY());
        return this;
    }

    public synchronized Path append(Shape s) {
        this.gp.append(s, false);
        return this;
    }

    public synchronized Path append(PathIterator pi) {
        this.gp.append(pi, false);
        return this;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.gp.contains(x, y, w, h);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.gp.contains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.gp.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.gp.contains(r);
    }

    @Override
    public Rectangle getBounds() {
        if (this.overrideBounds != null) {
            return this.overrideBounds.getBounds();
        }
        return this.gp.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        if (this.overrideBounds != null) {
            return this.overrideBounds;
        }
        return this.gp.getBounds2D();
    }

    public void setBounds2D(Rectangle2D r) {
        this.overrideBounds = r;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.gp.getPathIterator(at, flatness);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.gp.getPathIterator(at);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.gp.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.gp.intersects(r);
    }
}

