/*
 * Decompiled with CFR 0.152.
 */
package gj.util;

import gj.awt.geom.Geometry;
import gj.awt.geom.Path;
import gj.model.Arc;
import gj.model.Node;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ArcHelper {
    public static Path update(Arc arc) {
        return ArcHelper.update(arc.getPath(), arc.getStart(), arc.getEnd());
    }

    public static Path update(Path path, Node start, Node end) {
        return ArcHelper.update(path, start.getPosition(), start.getShape(), end.getPosition(), end.getShape());
    }

    public static Path update(Path path, Point2D[] points, Shape s1, Shape s2) {
        path.reset();
        Point2D a = Geometry.getIntersection(points[1], points[0], points[0], s1);
        Point2D b = Geometry.getIntersection(points[points.length - 2], points[points.length - 1], points[points.length - 1], s2);
        path.moveTo(a);
        for (int i = 1; i < points.length - 1; ++i) {
            path.lineTo(points[i]);
        }
        path.lineTo(b);
        return path;
    }

    public static Path update(Path path, Point2D p1, Shape s1, Point2D p2, Shape s2) {
        path.reset();
        if (p1.equals(p2)) {
            Rectangle2D bounds = s1.getBounds2D();
            double w = bounds.getMaxX() + bounds.getWidth() / 4.0;
            double h = bounds.getMaxY() + bounds.getHeight() / 4.0;
            Point2D a = p1;
            Point2D.Double b = new Point2D.Double(a.getX() + w, a.getY());
            Point2D.Double c = new Point2D.Double(a.getX() + w, a.getY() + h);
            Point2D.Double d = new Point2D.Double(a.getX(), a.getY() + h);
            ArcHelper.update(path, new Point2D[]{a, b, c, d, a}, s1, s1);
            return path;
        }
        path.moveTo(Geometry.getIntersection(p2, p1, p1, s1));
        path.lineTo(Geometry.getIntersection(p1, p2, p2, s2));
        return path;
    }
}

