// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'chrome://resources/cr_elements/cr_button/cr_button.m.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.m.js';
import './shared_css.js';

import {assert} from 'chrome://resources/js/assert.m.js';
import {WebUIListenerBehavior} from 'chrome://resources/js/web_ui_listener_behavior.m.js';
import {html, Polymer} from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';

import {AutogeneratedThemeColorInfo, ManageProfilesBrowserProxy, ManageProfilesBrowserProxyImpl} from '../manage_profiles_browser_proxy.js';
import {navigateToPreviousRoute, navigateToStep, ProfileCreationSteps, recordPageVisited, Routes} from '../navigation_behavior.js';

Polymer({
  is: 'profile-type-choice',

  _template: html`{__html_template__}`,

  behaviors: [WebUIListenerBehavior],

  properties: {
    /** @type {!AutogeneratedThemeColorInfo} */
    profileThemeInfo: {
      type: Object,
    },

    /**
     * If true, all buttons are disabled (to avoid creating two profiles).
     * @private {boolean}
     */
    loadSigninInProgess_: {
      type: Boolean,
      value: false,
    },
  },

  /** @private {?ManageProfilesBrowserProxy} */
  manageProfilesBrowserProxy_: null,

  /** @override */
  ready() {
    this.manageProfilesBrowserProxy_ =
        ManageProfilesBrowserProxyImpl.getInstance();
    this.addWebUIListener(
        'load-signin-finished',
        success => this.handleLoadSigninFinished_(success));
    this.manageProfilesBrowserProxy_.recordSignInPromoImpression();
  },

  /** @private */
  onNotNowClick_() {
    navigateToStep(
        Routes.NEW_PROFILE, ProfileCreationSteps.LOCAL_PROFILE_CUSTOMIZATION);
  },

  /** @private */
  onSignInClick_() {
    assert(!this.loadSigninInProgess_);
    this.loadSigninInProgess_ = true;

    // Explicitly record the page visit as this step is not pushed to the
    // history stack.
    recordPageVisited(ProfileCreationSteps.LOAD_SIGNIN);
    this.manageProfilesBrowserProxy_.loadSignInProfileCreationFlow(
        this.profileThemeInfo.color);
  },

  /** @private */
  onClickBack_() {
    navigateToPreviousRoute();
  },

  /** @private */
  handleLoadSigninFinished_(success) {
    // TODO(crbug.com/1126913): If failed, show some error message to inform the
    // user.
    this.loadSigninInProgess_ = false;
  }
});
