/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.metadata;

import java.util.function.Consumer;
import net.sf.jsqlparser.util.validation.UnexpectedValidationException;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.ValidationContext;
import net.sf.jsqlparser.util.validation.ValidationException;
import net.sf.jsqlparser.util.validation.metadata.MetadataContext;
import net.sf.jsqlparser.util.validation.metadata.Named;

public interface DatabaseMetaDataValidation
extends ValidationCapability {
    public static final String NAME = "meta data";

    @Override
    default public void validate(ValidationContext context, Consumer<ValidationException> errorConsumer) {
        Named named = context.get(MetadataContext.named, Named.class);
        boolean checkForExists = context.get(MetadataContext.exists, Boolean.class);
        try {
            boolean exists = this.exists(named);
            if (exists ^ checkForExists) {
                errorConsumer.accept(this.getErrorMessage(named, checkForExists));
            }
        }
        catch (ValidationException ve) {
            errorConsumer.accept(ve);
        }
        catch (UnsupportedOperationException ve) {
        }
        catch (Exception e) {
            errorConsumer.accept(this.getUnexpectedErrorMessage(named, e));
        }
    }

    public boolean exists(Named var1);

    default public ValidationException getErrorMessage(Named named, boolean checkForExists) {
        return this.toError(String.format("%s does %sexist.", named.getFqn(), checkForExists ? "not " : ""));
    }

    default public ValidationException getUnexpectedErrorMessage(Named named, Exception cause) {
        return new UnexpectedValidationException(named.getFqn() + ": cannot validate " + (Object)((Object)named.getNamedObject()) + "-name. detail: " + cause.getMessage(), cause);
    }

    @Override
    default public String getName() {
        return NAME;
    }
}

