/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.editors;

import java.util.ArrayList;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchedulerJob;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.ui.editors.data.AbstractDataEditor;

public class SchedulerJobLogEditor
extends AbstractDataEditor<OracleSchedulerJob> {
    private static final Log log = Log.getLog(SchedulerJobLogEditor.class);
    private static final String LOG_VIEW_NAME = "ALL_SCHEDULER_JOB_RUN_DETAILS";

    @Nullable
    public DBSDataContainer getDataContainer() {
        return this.getJobLogView();
    }

    protected DBDDataFilter getEditorDataFilter() {
        OracleSchedulerJob job = (OracleSchedulerJob)this.getDatabaseObject();
        OracleTableBase logView = this.getJobLogView();
        if (logView == null) {
            return null;
        }
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>();
        try {
            OracleTableColumn logDateAttr;
            OracleTableColumn jobNameAttr;
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            OracleTableColumn ownerAttr = logView.getAttribute((DBRProgressMonitor)monitor, "OWNER");
            if (ownerAttr != null) {
                DBDAttributeConstraint ac = new DBDAttributeConstraint((DBSAttributeBase)ownerAttr, ownerAttr.getOrdinalPosition());
                ac.setVisible(false);
                ac.setOperator(DBCLogicalOperator.EQUALS);
                ac.setValue((Object)job.getOwner());
                constraints.add(ac);
            }
            if ((jobNameAttr = logView.getAttribute((DBRProgressMonitor)monitor, "JOB_NAME")) != null) {
                DBDAttributeConstraint ac = new DBDAttributeConstraint((DBSAttributeBase)jobNameAttr, jobNameAttr.getOrdinalPosition());
                ac.setVisible(false);
                ac.setOperator(DBCLogicalOperator.EQUALS);
                ac.setValue((Object)job.getName());
                constraints.add(ac);
            }
            if ((logDateAttr = logView.getAttribute((DBRProgressMonitor)monitor, "LOG_DATE")) != null) {
                DBDAttributeConstraint ac = new DBDAttributeConstraint((DBSAttributeBase)logDateAttr, logDateAttr.getOrdinalPosition());
                ac.setOrderPosition(1);
                ac.setOrderDescending(true);
                ac.setVisible(true);
                constraints.add(ac);
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return new DBDDataFilter(constraints);
    }

    protected boolean isSuspendDataQuery() {
        return false;
    }

    protected String getDataQueryMessage() {
        return "Query job logs...";
    }

    public boolean isReadyToRun() {
        return this.getJobLogView() != null;
    }

    private OracleTableBase getJobLogView() {
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        try {
            OracleDataSource dataSource = ((OracleSchedulerJob)this.getDatabaseObject()).getDataSource();
            OracleSchema systemSchema = dataSource.getSchema((DBRProgressMonitor)monitor, "SYS");
            if (systemSchema != null) {
                return systemSchema.getView((DBRProgressMonitor)monitor, LOG_VIEW_NAME);
            }
            return null;
        }
        catch (DBException e) {
            log.error((Object)"Can't find log table", (Throwable)e);
            return null;
        }
    }
}

