/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.INavigatorListener;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;

public class DatabaseEditorListener
implements INavigatorListener {
    private final IDatabaseEditor databaseEditor;
    private DBPDataSourceContainer dataSourceContainer;

    DatabaseEditorListener(IDatabaseEditor databaseEditor) {
        this.databaseEditor = databaseEditor;
        IEditorInput editorInput = databaseEditor.getEditorInput();
        if (editorInput instanceof IDatabaseEditorInput) {
            IDatabaseEditorInput databaseEditorInput = (IDatabaseEditorInput)editorInput;
            if (databaseEditorInput.getDatabaseObject() instanceof DBPDataSourceContainer) {
                this.dataSourceContainer = (DBPDataSourceContainer)databaseEditorInput.getDatabaseObject();
            } else if (databaseEditorInput.getNavigatorNode() != null) {
                this.dataSourceContainer = databaseEditorInput.getNavigatorNode().getDataSourceContainer();
            }
            if (this.dataSourceContainer != null) {
                this.dataSourceContainer.acquire((DBPDataSourceTask)databaseEditor);
            }
        }
        DBWorkbench.getPlatform().getNavigatorModel().addListener((INavigatorListener)this);
    }

    public void dispose() {
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.release((DBPDataSourceTask)this.databaseEditor);
            this.dataSourceContainer = null;
        }
        DBWorkbench.getPlatform().getNavigatorModel().removeListener((INavigatorListener)this);
    }

    @Nullable
    public DBNNode getTreeNode() {
        IEditorInput input = this.databaseEditor.getEditorInput();
        return input instanceof IDatabaseEditorInput ? ((IDatabaseEditorInput)input).getNavigatorNode() : null;
    }

    public void nodeChanged(DBNEvent event) {
        if (this.isValuableNode(event.getNode())) {
            boolean closeEditor = false;
            if (event.getAction() == DBNEvent.Action.REMOVE) {
                closeEditor = true;
            } else if (event.getAction() == DBNEvent.Action.UPDATE) {
                if (event.getNodeChange() == DBNEvent.NodeChange.REFRESH || event.getNodeChange() == DBNEvent.NodeChange.LOAD) {
                    if (this.getTreeNode() == event.getNode()) {
                        this.databaseEditor.refreshPart(event, event.getNodeChange() == DBNEvent.NodeChange.REFRESH && event.getSource() == DBNEvent.FORCE_REFRESH);
                    }
                } else if (event.getNodeChange() == DBNEvent.NodeChange.UNLOAD) {
                    closeEditor = true;
                }
            }
            if (closeEditor) {
                IWorkbenchPage workbenchPage;
                if (DBWorkbench.getPlatform().isShuttingDown()) {
                    this.dispose();
                    return;
                }
                IWorkbenchWindow workbenchWindow = this.databaseEditor.getSite().getWorkbenchWindow();
                if (workbenchWindow != null && (workbenchPage = workbenchWindow.getActivePage()) != null) {
                    workbenchPage.closeEditor((IEditorPart)this.databaseEditor, false);
                }
            }
        }
    }

    protected boolean isValuableNode(DBNNode node) {
        DBNNode editorNode = this.getTreeNode();
        return node == editorNode || editorNode != null && editorNode.isChildOf(node);
    }
}

