# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Project Overview

Exit-options is a Qt6-based GUI application that provides a popup dialog with system exit options (logout, reboot, shutdown, suspend, lock) for MX Linux desktop environments, particularly optimized for Fluxbox.

## Build System

This is a Qt6 project using qmake build system:

```bash
# Build the application
qmake6
make

# Build with specific options (as used in debian packaging)
qmake6 DEFINES+=NO_DEBUG_ON_CONSOLE
make
```

## Key Architecture

### Core Components
- **main.cpp**: Application entry point with command-line parsing, translation loading, timeout handling, and single-instance enforcement
- **MainWindow**: QDialog-based main window that creates and manages action buttons
- **Configuration**: Hierarchical settings system (command line → user config → system config)

### Configuration System
Settings are loaded in priority order:
1. Command line arguments (highest priority)
2. User config: `~/.config/MX-Linux/exit-options.conf`
3. System config: `/etc/exit-options.conf`

### Desktop Environment Detection
The application detects the current desktop environment via `XDG_SESSION_DESKTOP` and adapts button labels accordingly (Fluxbox, IceWM, JWM support).

### Action System
Each button executes system commands using QProcess for:
- Lock screen (varies by DE)
- Logout/exit session
- Suspend/sleep
- Reboot
- Shutdown
- Desktop environment restart

## Translation System

The project supports extensive internationalization:

```bash
# Update translation files
/usr/lib/qt6/bin/lrelease translations/*.ts
```

Translation files are located in `translations/` directory with language codes (e.g., `exit-options_de.ts` for German).

## Theming and Icons

The application supports multiple icon themes stored in `icons/` subdirectories:
- adwaita, awesome, black-white, buuf, papirus, square-comfort

Icon paths can be customized via configuration files using icon name keys like `LockIcon=`, `LogoutIcon=`, etc.

## Command Line Interface

```bash
# Display help
exit-options --help

# Layout options
exit-options -v  # vertical layout
exit-options -h  # horizontal layout

# Timeout control
exit-options -t 10  # 10 second timeout
```

## Debian Packaging

The project includes debian packaging files with specific Qt6 build requirements:
- Uses `qmake6` explicitly
- Builds translation files during package build
- Generates version.h from debian/changelog

## Development Notes

- Built with Qt6 (widgets, core, gui modules)
- Uses C++17 standard
- Strict compiler warnings enabled in release builds
- Single-instance application (kills existing instances on startup)
- Automatic timeout functionality with configurable duration