
// input12ax7_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  1.500000
 // --table_div  20.270230
 // --table_op  0.250000

struct tableinput12ax7 { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tableinput12ax7_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tableinput12ax7&() const { return *(tableinput12ax7*)this; }
};

 static tableinput12ax7_imp<2048> input12ax7_table __rt_data = {
	0,-0.833333,341.167,2048, {
	0.000000000000,-0.000605240466,-0.001210226689,-0.001814958776,-0.002419436836,
	-0.003023660979,-0.003627631314,-0.004231347950,-0.004834810997,-0.005438020565,
	-0.006040976761,-0.006643679696,-0.007246129478,-0.007848326217,-0.008450270021,
	-0.009051961000,-0.009653399262,-0.010254584916,-0.010855518072,-0.011456198837,
	-0.012056627320,-0.012656803631,-0.013256727878,-0.013856400168,-0.014455820612,
	-0.015054989317,-0.015653906392,-0.016252571945,-0.016850986085,-0.017449148920,
	-0.018047060557,-0.018644721106,-0.019242130674,-0.019839289370,-0.020436197301,
	-0.021032854575,-0.021629261302,-0.022225417587,-0.022821323540,-0.023416979268,
	-0.024012384879,-0.024607540480,-0.025202446180,-0.025797102086,-0.026391508305,
	-0.026985664945,-0.027579572113,-0.028173229918,-0.028766638465,-0.029359797864,
	-0.029952708220,-0.030545369642,-0.031137782236,-0.031729946110,-0.032321861370,
	-0.032913528125,-0.033504946480,-0.034096116542,-0.034687038420,-0.035277712219,
	-0.035868138046,-0.036458316009,-0.037048246213,-0.037637928766,-0.038227363775,
	-0.038816551345,-0.039405491584,-0.039994184597,-0.040582630492,-0.041170829375,
	-0.041758781352,-0.042346486529,-0.042933945014,-0.043521156911,-0.044108122327,
	-0.044694841369,-0.045281314142,-0.045867540752,-0.046453521306,-0.047039255909,
	-0.047624744668,-0.048209987687,-0.048794985074,-0.049379736933,-0.049964243371,
	-0.050548504493,-0.051132520404,-0.051716291211,-0.052299817019,-0.052883097933,
	-0.053466134058,-0.054048925501,-0.054631472367,-0.055213774760,-0.055795832786,
	-0.056377646551,-0.056959216159,-0.057540541715,-0.058121623325,-0.058702461094,
	-0.059283055127,-0.059863405528,-0.060443512403,-0.061023375855,-0.061602995991,
	-0.062182372915,-0.062761506732,-0.063340397545,-0.063919045461,-0.064497450583,
	-0.065075613016,-0.065653532864,-0.066231210232,-0.066808645225,-0.067385837946,
	-0.067962788500,-0.068539496991,-0.069115963523,-0.069692188201,-0.070268171128,
	-0.070843912409,-0.071419412148,-0.071994670449,-0.072569687415,-0.073144463150,
	-0.073718997759,-0.074293291345,-0.074867344012,-0.075441155864,-0.076014727003,
	-0.076588057535,-0.077161147562,-0.077733997188,-0.078306606516,-0.078878975650,
	-0.079451104694,-0.080022993750,-0.080594642922,-0.081166052313,-0.081737222027,
	-0.082308152166,-0.082878842833,-0.083449294133,-0.084019506167,-0.084589479039,
	-0.085159212851,-0.085728707707,-0.086297963709,-0.086866980961,-0.087435759564,
	-0.088004299623,-0.088572601238,-0.089140664513,-0.089708489551,-0.090276076455,
	-0.090843425325,-0.091410536266,-0.091977409379,-0.092544044767,-0.093110442531,
	-0.093676602775,-0.094242525601,-0.094808211111,-0.095373659406,-0.095938870589,
	-0.096503844762,-0.097068582027,-0.097633082486,-0.098197346241,-0.098761373394,
	-0.099325164046,-0.099888718299,-0.100452036256,-0.101015118017,-0.101577963685,
	-0.102140573360,-0.102702947145,-0.103265085141,-0.103826987449,-0.104388654171,
	-0.104950085409,-0.105511281263,-0.106072241835,-0.106632967226,-0.107193457538,
	-0.107753712871,-0.108313733326,-0.108873519005,-0.109433070009,-0.109992386438,
	-0.110551468394,-0.111110315978,-0.111668929290,-0.112227308431,-0.112785453501,
	-0.113343364603,-0.113901041835,-0.114458485300,-0.115015695096,-0.115572671326,
	-0.116129414090,-0.116685923487,-0.117242199618,-0.117798242585,-0.118354052486,
	-0.118909629422,-0.119464973494,-0.120020084802,-0.120574963446,-0.121129609525,
	-0.121684023141,-0.122238204392,-0.122792153380,-0.123345870203,-0.123899354962,
	-0.124452607757,-0.125005628687,-0.125558417852,-0.126110975352,-0.126663301286,
	-0.127215395755,-0.127767258857,-0.128318890693,-0.128870291361,-0.129421460961,
	-0.129972399593,-0.130523107356,-0.131073584349,-0.131623830672,-0.132173846423,
	-0.132723631702,-0.133273186609,-0.133822511241,-0.134371605699,-0.134920470080,
	-0.135469104485,-0.136017509012,-0.136565683760,-0.137113628828,-0.137661344314,
	-0.138208830318,-0.138756086938,-0.139303114272,-0.139849912420,-0.140396481480,
	-0.140942821550,-0.141488932729,-0.142034815115,-0.142580468808,-0.143125893904,
	-0.143671090503,-0.144216058703,-0.144760798601,-0.145305310297,-0.145849593888,
	-0.146393649473,-0.146937477149,-0.147481077014,-0.148024449167,-0.148567593706,
	-0.149110510727,-0.149653200330,-0.150195662612,-0.150737897671,-0.151279905604,
	-0.151821686509,-0.152363240484,-0.152904567626,-0.153445668033,-0.153986541802,
	-0.154527189032,-0.155067609818,-0.155607804259,-0.156147772453,-0.156687514495,
	-0.157227030484,-0.157766320517,-0.158305384690,-0.158844223102,-0.159382835849,
	-0.159921223028,-0.160459384736,-0.160997321070,-0.161535032127,-0.162072518004,
	-0.162609778798,-0.163146814605,-0.163683625522,-0.164220211647,-0.164756573075,
	-0.165292709903,-0.165828622227,-0.166364310146,-0.166899773753,-0.167435013148,
	-0.167970028424,-0.168504819680,-0.169039387011,-0.169573730514,-0.170107850284,
	-0.170641746418,-0.171175419013,-0.171708868164,-0.172242093967,-0.172775096518,
	-0.173307875914,-0.173840432250,-0.174372765623,-0.174904876127,-0.175436763859,
	-0.175968428915,-0.176499871390,-0.177031091380,-0.177562088981,-0.178092864288,
	-0.178623417398,-0.179153748404,-0.179683857403,-0.180213744491,-0.180743409762,
	-0.181272853312,-0.181802075237,-0.182331075631,-0.182859854590,-0.183388412210,
	-0.183916748584,-0.184444863809,-0.184972757979,-0.185500431189,-0.186027883535,
	-0.186555115111,-0.187082126012,-0.187608916334,-0.188135486170,-0.188661835616,
	-0.189187964766,-0.189713873715,-0.190239562558,-0.190765031389,-0.191290280304,
	-0.191815309395,-0.192340118759,-0.192864708489,-0.193389078679,-0.193913229425,
	-0.194437160820,-0.194960872958,-0.195484365935,-0.196007639844,-0.196530694779,
	-0.197053530834,-0.197576148104,-0.198098546682,-0.198620726663,-0.199142688140,
	-0.199664431207,-0.200185955959,-0.200707262488,-0.201228350890,-0.201749221257,
	-0.202269873683,-0.202790308262,-0.203310525087,-0.203830524253,-0.204350305852,
	-0.204869869979,-0.205389216725,-0.205908346186,-0.206427258454,-0.206945953623,
	-0.207464431786,-0.207982693036,-0.208500737467,-0.209018565171,-0.209536176242,
	-0.210053570773,-0.210570748856,-0.211087710586,-0.211604456054,-0.212120985354,
	-0.212637298579,-0.213153395821,-0.213669277173,-0.214184942729,-0.214700392580,
	-0.215215626820,-0.215730645541,-0.216245448835,-0.216760036796,-0.217274409516,
	-0.217788567086,-0.218302509601,-0.218816237152,-0.219329749831,-0.219843047730,
	-0.220356130943,-0.220868999562,-0.221381653677,-0.221894093382,-0.222406318769,
	-0.222918329930,-0.223430126957,-0.223941709941,-0.224453078976,-0.224964234152,
	-0.225475175561,-0.225985903296,-0.226496417448,-0.227006718110,-0.227516805372,
	-0.228026679326,-0.228536340064,-0.229045787678,-0.229555022259,-0.230064043898,
	-0.230572852688,-0.231081448719,-0.231589832083,-0.232098002872,-0.232605961176,
	-0.233113707086,-0.233621240695,-0.234128562094,-0.234635671372,-0.235142568623,
	-0.235649253936,-0.236155727402,-0.236661989114,-0.237168039160,-0.237673877634,
	-0.238179504625,-0.238684920224,-0.239190124522,-0.239695117609,-0.240199899578,
	-0.240704470517,-0.241208830519,-0.241712979672,-0.242216918069,-0.242720645799,
	-0.243224162953,-0.243727469622,-0.244230565895,-0.244733451863,-0.245236127617,
	-0.245738593247,-0.246240848842,-0.246742894494,-0.247244730292,-0.247746356327,
	-0.248247772688,-0.248748979466,-0.249249976750,-0.249750764631,-0.250251343198,
	-0.250751712542,-0.251251872751,-0.251751823917,-0.252251566129,-0.252751099476,
	-0.253250424048,-0.253749539936,-0.254248447227,-0.254747146013,-0.255245636382,
	-0.255743918424,-0.256241992229,-0.256739857886,-0.257237515484,-0.257734965112,
	-0.258232206861,-0.258729240818,-0.259226067074,-0.259722685718,-0.260219096838,
	-0.260715300524,-0.261211296865,-0.261707085950,-0.262202667868,-0.262698042707,
	-0.263193210558,-0.263688171508,-0.264182925646,-0.264677473062,-0.265171813843,
	-0.265665948079,-0.266159875859,-0.266653597270,-0.267147112402,-0.267640421344,
	-0.268133524183,-0.268626421008,-0.269119111907,-0.269611596970,-0.270103876284,
	-0.270595949937,-0.271087818019,-0.271579480617,-0.272070937819,-0.272562189713,
	-0.273053236389,-0.273544077933,-0.274034714434,-0.274525145980,-0.275015372659,
	-0.275505394558,-0.275995211766,-0.276484824371,-0.276974232460,-0.277463436122,
	-0.277952435443,-0.278441230511,-0.278929821416,-0.279418208242,-0.279906391080,
	-0.280394370015,-0.280882145136,-0.281369716530,-0.281857084285,-0.282344248487,
	-0.282831209225,-0.283317966585,-0.283804520655,-0.284290871523,-0.284777019274,
	-0.285262963997,-0.285748705779,-0.286234244706,-0.286719580866,-0.287204714346,
	-0.287689645233,-0.288174373613,-0.288658899574,-0.289143223202,-0.289627344585,
	-0.290111263809,-0.290594980961,-0.291078496127,-0.291561809395,-0.292044920850,
	-0.292527830580,-0.293010538671,-0.293493045209,-0.293975350282,-0.294457453975,
	-0.294939356375,-0.295421057568,-0.295902557641,-0.296383856680,-0.296864954771,
	-0.297345852001,-0.297826548455,-0.298307044219,-0.298787339381,-0.299267434026,
	-0.299747328239,-0.300227022108,-0.300706515717,-0.301185809153,-0.301664902502,
	-0.302143795850,-0.302622489281,-0.303100982883,-0.303579276741,-0.304057370941,
	-0.304535265567,-0.305012960707,-0.305490456444,-0.305967752866,-0.306444850058,
	-0.306921748104,-0.307398447091,-0.307874947103,-0.308351248227,-0.308827350547,
	-0.309303254148,-0.309778959117,-0.310254465538,-0.310729773496,-0.311204883077,
	-0.311679794366,-0.312154507447,-0.312629022405,-0.313103339327,-0.313577458296,
	-0.314051379397,-0.314525102716,-0.314998628337,-0.315471956345,-0.315945086825,
	-0.316418019862,-0.316890755539,-0.317363293943,-0.317835635157,-0.318307779266,
	-0.318779726355,-0.319251476507,-0.319723029809,-0.320194386343,-0.320665546194,
	-0.321136509448,-0.321607276187,-0.322077846497,-0.322548220461,-0.323018398164,
	-0.323488379690,-0.323958165123,-0.324427754547,-0.324897148047,-0.325366345705,
	-0.325835347607,-0.326304153836,-0.326772764477,-0.327241179612,-0.327709399326,
	-0.328177423702,-0.328645252825,-0.329112886778,-0.329580325645,-0.330047569510,
	-0.330514618455,-0.330981472565,-0.331448131924,-0.331914596614,-0.332380866719,
	-0.332846942323,-0.333312823508,-0.333778510360,-0.334244002960,-0.334709301391,
	-0.335174405739,-0.335639316084,-0.336104032512,-0.336568555104,-0.337032883944,
	-0.337497019114,-0.337960960699,-0.338424708781,-0.338888263443,-0.339351624768,
	-0.339814792839,-0.340277767738,-0.340740549548,-0.341203138353,-0.341665534235,
	-0.342127737276,-0.342589747560,-0.343051565169,-0.343513190185,-0.343974622692,
	-0.344435862771,-0.344896910506,-0.345357765977,-0.345818429269,-0.346278900464,
	-0.346739179643,-0.347199266889,-0.347659162285,-0.348118865912,-0.348578377853,
	-0.349037698190,-0.349496827005,-0.349955764380,-0.350414510398,-0.350873065139,
	-0.351331428687,-0.351789601123,-0.352247582529,-0.352705372988,-0.353162972580,
	-0.353620381387,-0.354077599492,-0.354534626976,-0.354991463921,-0.355448110409,
	-0.355904566520,-0.356360832338,-0.356816907942,-0.357272793416,-0.357728488839,
	-0.358183994295,-0.358639309863,-0.359094435626,-0.359549371665,-0.360004118061,
	-0.360458674896,-0.360913042250,-0.361367220205,-0.361821208842,-0.362275008242,
	-0.362728618487,-0.363182039656,-0.363635271833,-0.364088315096,-0.364541169528,
	-0.364993835209,-0.365446312219,-0.365898600641,-0.366350700555,-0.366802612041,
	-0.367254335180,-0.367705870053,-0.368157216741,-0.368608375324,-0.369059345883,
	-0.369510128498,-0.369960723250,-0.370411130220,-0.370861349487,-0.371311381133,
	-0.371761225237,-0.372210881881,-0.372660351143,-0.373109633106,-0.373558727848,
	-0.374007635450,-0.374456355992,-0.374904889555,-0.375353236218,-0.375801396062,
	-0.376249369166,-0.376697155611,-0.377144755477,-0.377592168843,-0.378039395789,
	-0.378486436395,-0.378933290742,-0.379379958908,-0.379826440974,-0.380272737019,
	-0.380718847124,-0.381164771367,-0.381610509828,-0.382056062586,-0.382501429723,
	-0.382946611316,-0.383391607445,-0.383836418191,-0.384281043631,-0.384725483846,
	-0.385169738915,-0.385613808917,-0.386057693931,-0.386501394038,-0.386944909315,
	-0.387388239842,-0.387831385698,-0.388274346963,-0.388717123715,-0.389159716033,
	-0.389602123996,-0.390044347684,-0.390486387175,-0.390928242548,-0.391369913882,
	-0.391811401256,-0.392252704748,-0.392693824438,-0.393134760404,-0.393575512724,
	-0.394016081477,-0.394456466743,-0.394896668599,-0.395336687123,-0.395776522396,
	-0.396216174494,-0.396655643497,-0.397094929483,-0.397534032530,-0.397972952716,
	-0.398411690120,-0.398850244821,-0.399288616895,-0.399726806423,-0.400164813480,
	-0.400602638147,-0.401040280501,-0.401477740619,-0.401915018581,-0.402352114463,
	-0.402789028344,-0.403225760302,-0.403662310415,-0.404098678761,-0.404534865417,
	-0.404970870461,-0.405406693971,-0.405842336024,-0.406277796699,-0.406713076073,
	-0.407148174224,-0.407583091229,-0.408017827165,-0.408452382111,-0.408886756143,
	-0.409320949340,-0.409754961778,-0.410188793535,-0.410622444688,-0.411055915315,
	-0.411489205493,-0.411922315299,-0.412355244810,-0.412787994104,-0.413220563258,
	-0.413652952348,-0.414085161452,-0.414517190646,-0.414949040009,-0.415380709616,
	-0.415812199546,-0.416243509873,-0.416674640677,-0.417105592033,-0.417536364017,
	-0.417966956708,-0.418397370182,-0.418827604515,-0.419257659784,-0.419687536065,
	-0.420117233436,-0.420546751973,-0.420976091752,-0.421405252850,-0.421834235343,
	-0.422263039308,-0.422691664821,-0.423120111959,-0.423548380797,-0.423976471413,
	-0.424404383882,-0.424832118281,-0.425259674685,-0.425687053172,-0.426114253817,
	-0.426541276696,-0.426968121885,-0.427394789461,-0.427821279499,-0.428247592075,
	-0.428673727265,-0.429099685146,-0.429525465793,-0.429951069281,-0.430376495687,
	-0.430801745087,-0.431226817555,-0.431651713169,-0.432076432003,-0.432500974133,
	-0.432925339634,-0.433349528583,-0.433773541055,-0.434197377125,-0.434621036869,
	-0.435044520362,-0.435467827680,-0.435890958897,-0.436313914090,-0.436736693334,
	-0.437159296703,-0.437581724274,-0.438003976121,-0.438426052319,-0.438847952944,
	-0.439269678071,-0.439691227774,-0.440112602129,-0.440533801211,-0.440954825095,
	-0.441375673856,-0.441796347568,-0.442216846307,-0.442637170147,-0.443057319163,
	-0.443477293431,-0.443897093024,-0.444316718017,-0.444736168485,-0.445155444503,
	-0.445574546146,-0.445993473487,-0.446412226602,-0.446830805564,-0.447249210449,
	-0.447667441331,-0.448085498285,-0.448503381383,-0.448921090702,-0.449338626316,
	-0.449755988298,-0.450173176722,-0.450590191664,-0.451007033197,-0.451423701396,
	-0.451840196334,-0.452256518086,-0.452672666725,-0.453088642326,-0.453504444963,
	-0.453920074709,-0.454335531639,-0.454750815827,-0.455165927346,-0.455580866270,
	-0.455995632673,-0.456410226629,-0.456824648211,-0.457238897493,-0.457652974550,
	-0.458066879453,-0.458480612278,-0.458894173098,-0.459307561985,-0.459720779014,
	-0.460133824259,-0.460546697792,-0.460959399687,-0.461371930017,-0.461784288856,
	-0.462196476277,-0.462608492354,-0.463020337159,-0.463432010766,-0.463843513248,
	-0.464254844677,-0.464666005129,-0.465076994674,-0.465487813387,-0.465898461340,
	-0.466308938607,-0.466719245260,-0.467129381372,-0.467539347016,-0.467949142266,
	-0.468358767193,-0.468768221871,-0.469177506372,-0.469586620770,-0.469995565136,
	-0.470404339544,-0.470812944067,-0.471221378775,-0.471629643744,-0.472037739044,
	-0.472445664749,-0.472853420930,-0.473261007661,-0.473668425014,-0.474075673061,
	-0.474482751874,-0.474889661526,-0.475296402090,-0.475702973636,-0.476109376239,
	-0.476515609969,-0.476921674899,-0.477327571101,-0.477733298647,-0.478138857610,
	-0.478544248061,-0.478949470072,-0.479354523715,-0.479759409063,-0.480164126187,
	-0.480568675159,-0.480973056050,-0.481377268934,-0.481781313881,-0.482185190963,
	-0.482588900251,-0.482992441819,-0.483395815737,-0.483799022077,-0.484202060910,
	-0.484604932308,-0.485007636343,-0.485410173086,-0.485812542608,-0.486214744982,
	-0.486616780278,-0.487018648568,-0.487420349922,-0.487821884414,-0.488223252113,
	-0.488624453091,-0.489025487419,-0.489426355169,-0.489827056411,-0.490227591216,
	-0.490627959657,-0.491028161803,-0.491428197726,-0.491828067497,-0.492227771187,
	-0.492627308867,-0.493026680607,-0.493425886479,-0.493824926553,-0.494223800901,
	-0.494622509592,-0.495021052698,-0.495419430290,-0.495817642437,-0.496215689212,
	-0.496613570684,-0.497011286924,-0.497408838003,-0.497806223990,-0.498203444958,
	-0.498600500975,-0.498997392113,-0.499394118442,-0.499790680032,-0.500187076954,
	-0.500583309278,-0.500979377075,-0.501375280413,-0.501771019365,-0.502166594000,
	-0.502562004387,-0.502957250598,-0.503352332703,-0.503747250771,-0.504142004872,
	-0.504536595077,-0.504931021455,-0.505325284077,-0.505719383012,-0.506113318330,
	-0.506507090101,-0.506900698395,-0.507294143282,-0.507687424832,-0.508080543113,
	-0.508473498197,-0.508866290152,-0.509258919048,-0.509651384955,-0.510043687943,
	-0.510435828080,-0.510827805437,-0.511219620083,-0.511611272088,-0.512002761520,
	-0.512394088449,-0.512785252946,-0.513176255078,-0.513567094915,-0.513957772527,
	-0.514348287983,-0.514738641352,-0.515128832702,-0.515518862105,-0.515908729628,
	-0.516298435340,-0.516687979311,-0.517077361609,-0.517466582305,-0.517855641466,
	-0.518244539161,-0.518633275460,-0.519021850432,-0.519410264144,-0.519798516667,
	-0.520186608068,-0.520574538418,-0.520962307783,-0.521349916234,-0.521737363838,
	-0.522124650664,-0.522511776782,-0.522898742259,-0.523285547164,-0.523672191566,
	-0.524058675533,-0.524444999133,-0.524831162435,-0.525217165508,-0.525603008420,
	-0.525988691238,-0.526374214032,-0.526759576870,-0.527144779820,-0.527529822949,
	-0.527914706327,-0.528299430022,-0.528683994101,-0.529068398633,-0.529452643686,
	-0.529836729328,-0.530220655626,-0.530604422650,-0.530988030466,-0.531371479143,
	-0.531754768748,-0.532137899350,-0.532520871016,-0.532903683814,-0.533286337813,
	-0.533668833078,-0.534051169679,-0.534433347683,-0.534815367158,-0.535197228171,
	-0.535578930790,-0.535960475082,-0.536341861116,-0.536723088957,-0.537104158675,
	-0.537485070336,-0.537865824008,-0.538246419758,-0.538626857654,-0.539007137762,
	-0.539387260151,-0.539767224887,-0.540147032038,-0.540526681670,-0.540906173852,
	-0.541285508650,-0.541664686131,-0.542043706363,-0.542422569412,-0.542801275346,
	-0.543179824231,-0.543558216135,-0.543936451124,-0.544314529266,-0.544692450627,
	-0.545070215274,-0.545447823273,-0.545825274693,-0.546202569599,-0.546579708058,
	-0.546956690137,-0.547333515903,-0.547710185422,-0.548086698761,-0.548463055986,
	-0.548839257165,-0.549215302362,-0.549591191647,-0.549966925083,-0.550342502739,
	-0.550717924680,-0.551093190972,-0.551468301683,-0.551843256879,-0.552218056625,
	-0.552592700988,-0.552967190034,-0.553341523830,-0.553715702442,-0.554089725936,
	-0.554463594377,-0.554837307833,-0.555210866368,-0.555584270050,-0.555957518944,
	-0.556330613116,-0.556703552633,-0.557076337559,-0.557448967961,-0.557821443905,
	-0.558193765457,-0.558565932682,-0.558937945646,-0.559309804415,-0.559681509055,
	-0.560053059632,-0.560424456210,-0.560795698856,-0.561166787635,-0.561537722613,
	-0.561908503855,-0.562279131428,-0.562649605395,-0.563019925824,-0.563390092779,
	-0.563760106325,-0.564129966529,-0.564499673455,-0.564869227168,-0.565238627735,
	-0.565607875220,-0.565976969688,-0.566345911206,-0.566714699837,-0.567083335647,
	-0.567451818701,-0.567820149064,-0.568188326802,-0.568556351979,-0.568924224660,
	-0.569291944911,-0.569659512796,-0.570026928380,-0.570394191728,-0.570761302904,
	-0.571128261975,-0.571495069004,-0.571861724057,-0.572228227197,-0.572594578490,
	-0.572960778001,-0.573326825794,-0.573692721933,-0.574058466484,-0.574424059511,
	-0.574789501078,-0.575154791250,-0.575519930092,-0.575884917668,-0.576249754041,
	-0.576614439278,-0.576978973442,-0.577343356597,-0.577707588809,-0.578071670140,
	-0.578435600656,-0.578799380420,-0.579163009497,-0.579526487951,-0.579889815846,
	-0.580252993246,-0.580616020216,-0.580978896819,-0.581341623120,-0.581704199182,
	-0.582066625070,-0.582428900847,-0.582791026577,-0.583153002324,-0.583514828153,
	-0.583876504127,-0.584238030309,-0.584599406764,-0.584960633555,-0.585321710746,
	-0.585682638401,-0.586043416583,-0.586404045356,-0.586764524784,-0.587124854930,
	-0.587485035858,-0.587845067631,-0.588204950313,-0.588564683968,-0.588924268658,
	-0.589283704447,-0.589642991399,-0.590002129577,-0.590361119044,-0.590719959864,
	-0.591078652099,-0.591437195814,-0.591795591071,-0.592153837934,-0.592511936465,
	-0.592869886728,-0.593227688787,-0.593585342703,-0.593942848540,-0.594300206362,
	-0.594657416231,-0.595014478210,-0.595371392362,-0.595728158750,-0.596084777437,
	-0.596441248485,-0.596797571959,-0.597153747919,-0.597509776430,-0.597865657554,
	-0.598221391354,-0.598576977892,-0.598932417231,-0.599287709434,-0.599642854563,
	-0.599997852681,-0.600352703850,-0.600707408134,-0.601061965594,-0.601416376293,
	-0.601770640293,-0.602124757658,-0.602478728448,-0.602832552728,-0.603186230558,
	-0.603539762002,-0.603893147121,-0.604246385978,-0.604599478635,-0.604952425155,
	-0.605305225599,-0.605657880030,-0.606010388509,-0.606362751099,-0.606714967862,
	-0.607067038861,-0.607418964156,-0.607770743810,-0.608122377885,-0.608473866443,
	-0.608825209545,-0.609176407255,-0.609527459633,-0.609878366741,-0.610229128641,
	-0.610579745395,-0.610930217065,-0.611280543712,-0.611630725399,-0.611980762185,
	-0.612330654135,-0.612680401308,-0.613030003767,-0.613379461573,-0.613728774787,
	-0.614077943472,-0.614426967688,-0.614775847497,-0.615124582960,-0.615473174140,
	-0.615821621097,-0.616169923892,-0.616518082587,-0.616866097243,-0.617213967922,
	-0.617561694684,-0.617909277591,-0.618256716704,-0.618604012084,-0.618951163792,
	-0.619298171890,-0.619645036438,-0.619991757498,-0.620338335130,-0.620684769396,
	-0.621031060356,-0.621377208071,-0.621723212603,-0.622069074012,-0.622414792359,
	-0.622760367704,-0.623105800110,-0.623451089635,-0.623796236342,-0.624141240291,
	-0.624486101542,-0.624830820157,-0.625175396195,-0.625519829718,-0.625864120786,
	-0.626208269460,-0.626552275800,-0.626896139866,-0.627239861720,-0.627583441421,
	-0.627926879031,-0.628270174609,-0.628613328215,-0.628956339911,-0.629299209756,
	-0.629641937811,-0.629984524136,-0.630326968792,-0.630669271837,-0.631011433334,
	-0.631353453341,-0.631695331920,-0.632037069129,-0.632378665030,-0.632720119682,
	-0.633061433145,-0.633402605479,-0.633743636745,-0.634084527001,-0.634425276309,
	-0.634765884728,-0.635106352318,-0.635446679139,-0.635786865250,-0.636126910711,
	-0.636466815583,-0.636806579924,-0.637146203795,-0.637485687255,-0.637825030365,
	-0.638164233182,-0.638503295768,-0.638842218182,-0.639181000483,-0.639519642730,
	-0.639858144984,-0.640196507304,-0.640534729749,-0.640872812379,-0.641210755253,
	-0.641548558430,-0.641886221970,-0.642223745932,-0.642561130376,-0.642898375360,
	-0.643235480945,-0.643572447188,-0.643909274150,-0.644245961889,-0.644582510465,
	-0.644918919937,-0.645255190363,-0.645591321803,-0.645927314317,-0.646263167962,
	-0.646598882798,-0.646934458884,-0.647269896279,-0.647605195042,-0.647940355231,
	-0.648275376905,-0.648610260124,-0.648945004946,-0.649279611430,-0.649614079635,
	-0.649948409618,-0.650282601440,-0.650616655159,-0.650950570832,-0.651284348520,
	-0.651617988280,-0.651951490172,-0.652284854253,-0.652618080582,-0.652951169218,
	-0.653284120220,-0.653616933644,-0.653949609551,-0.654282147998,-0.654614549044,
	-0.654946812747,-0.655278939165,-0.655610928357,-0.655942780381,-0.656274495296,
	-0.656606073158,-0.656937514027,-0.657268817961,-0.657599985018,-0.657931015256,
	-0.658261908732,-0.658592665506,-0.658923285635,-0.659253769177,-0.659584116191,
	-0.659914326733,-0.660244400862,-0.660574338637,-0.660904140114,-0.661233805351,
	-0.661563334407,-0.661892727340,-0.662221984206,-0.662551105065,-0.662880089972,
	-0.663208938987,-0.663537652167,-0.663866229570,-0.664194671252,-0.664522977272,
	-0.664851147688,-0.665179182557,-0.665507081935,-0.665834845882,-0.666162474454,
	-0.666489967709,-0.666817325705,-0.667144548497,-0.667471636145,-0.667798588705,
	-0.668125406235,-0.668452088792,-0.668778636433,-0.669105049216,-0.669431327197,
	-0.669757470434,-0.670083478984,-0.670409352904,-0.670735092252,-0.671060697084,
	-0.671386167457,-0.671711503429,-0.672036705057,-0.672361772397,-0.672686705506,
	-0.673011504442,-0.673336169262,-0.673660700021,-0.673985096778,-0.674309359589,
	-0.674633488510,-0.674957483599,-0.675281344912,-0.675605072507,-0.675928666439,
	-0.676252126765,-0.676575453543,-0.676898646829,-0.677221706679,-0.677544633150,
	-0.677867426298,-0.678190086181,-0.678512612854,-0.678835006375,-0.679157266799,
	-0.679479394183,-0.679801388583,-0.680123250056,-0.680444978659,-0.680766574447,
	-0.681088037477,-0.681409367805,-0.681730565488,-0.682051630581,-0.682372563141,
	-0.682693363225,-0.683014030887,-0.683334566185,-0.683654969175,-0.683975239912,
	-0.684295378453,-0.684615384854,-0.684935259170,-0.685255001458,-0.685574611774,
	-0.685894090174,-0.686213436713,-0.686532651448,-0.686851734434,-0.687170685727,
	-0.687489505384,-0.687808193459,-0.688126750009,-0.688445175090,-0.688763468756,
	-0.689081631065,-0.689399662071,-0.689717561830,-0.690035330398,-0.690352967830,
	-0.690670474182,-0.690987849510,-0.691305093869,-0.691622207314,-0.691939189902,
	-0.692256041687,-0.692572762724,-0.692889353071,-0.693205812781,-0.693522141910,
	-0.693838340513,-0.694154408647,-0.694470346365,-0.694786153724,-0.695101830778,
	-0.695417377583,-0.695732794194,-0.696048080666,-0.696363237054,-0.696678263413,
	-0.696993159800,-0.697307926267,-0.697622562871,-0.697937069667,-0.698251446709,
	-0.698565694053,-0.698879811754,-0.699193799866,-0.699507658444,-0.699821387543,
	-0.700134987219,-0.700448457525,-0.700761798517,-0.701075010249,-0.701388092777,
	-0.701701046155,-0.702013870437,-0.702326565679,-0.702639131934,-0.702951569259,
	-0.703263877706,-0.703576057331,-0.703888108189,-0.704200030334,-0.704511823820,
	-0.704823488702,-0.705135025034,-0.705446432872,-0.705757712268,-0.706068863278,
	-0.706379885956,-0.706690780357,-0.707001546534,-0.707312184542,-0.707622694436,
	-0.707933076269,-0.708243330096,-0.708553455970,-0.708863453947,-0.709173324080,
	-0.709483066423,-0.709792681031,-0.710102167958,-0.710411527257,-0.710720758983,
	-0.711029863190,-0.711338839931,-0.711647689261,-0.711956411233,-0.712265005903,
	-0.712573473322,-0.712881813546,-0.713190026628,-0.713498112621,-0.713806071581,
	-0.714113903560,-0.714421608612,-0.714729186792,-0.715036638152,-0.715343962746,
	-0.715651160628,-0.715958231852,-0.716265176472,-0.716571994540,-0.716878686111,
	-0.717185251237,-0.717491689973,-0.717798002372,-0.718104188488,-0.718410248373,
	-0.718716182082,-0.719021989667,-0.719327671182,-0.719633226681,-0.719938656217,
	-0.720243959842,-0.720549137611,-0.720854189577,-0.721159115792,-0.721463916310,
	-0.721768591185,-0.722073140469,-0.722377564215,-0.722681862477,-0.722986035308,
	-0.723290082761,-0.723594004888,-0.723897801743,-0.724201473380,-0.724505019849,
	-0.724808441206,-0.725111737503,-0.725414908792,-0.725717955126,-0.726020876559,
	-0.726323673143,-0.726626344931,-0.726928891976,-0.727231314330,-0.727533612047,
	-0.727835785179,-0.728137833778,-0.728439757898,-0.728741557591,-0.729043232909,
	-0.729344783906,-0.729646210634,-0.729947513145,-0.730248691492,-0.730549745727,
	-0.730850675903,-0.731151482073,-0.731452164288,-0.731752722602,-0.732053157067,
	-0.732353467734,-0.732653654657,-0.732953717887,-0.733253657478,-0.733553473481,
	-0.733853165948,-0.734152734932,-0.734452180485,-0.734751502659,-0.735050701507,
	-0.735349777080,-0.735648729431,-0.735947558611,-0.736246264673,-0.736544847669,
	-0.736843307650,-0.737141644670,-0.737439858779,-0.737737950030,-0.738035918475,
	-0.738333764166,-0.738631487154,-0.738929087491,-0.739226565230,-0.739523920421,
	-0.739821153118,-0.740118263371,-0.740415251232,-0.740712116754,-0.741008859987,
	-0.741305480984,-0.741601979796,-0.741898356475,-0.742194611072,-0.742490743639,
	-0.742786754228,-0.743082642890,-0.743378409676,-0.743674054639,-0.743969577829,
	-0.744264979298,-0.744560259098,-0.744855417280,-0.745150453895,-0.745445368995,
	-0.745740162630,-0.746034834854,-0.746329385715,-0.746623815267,-0.746918123560,
	-0.747212310645,-0.747506376574,-0.747800321398,-0.748094145167,-0.748387847934,
	-0.748681429749,-0.748974890663,-0.749268230727,-0.749561449993,-0.749854548512,
	-0.750147526334,-0.750440383510,-0.750733120092,-0.751025736130,-0.751318231676,
	-0.751610606779,-0.751902861492,-0.752194995864,-0.752487009947,-0.752778903792,
	-0.753070677449,-0.753362330968,-0.753653864402,-0.753945277800,-0.754236571214,
	-0.754527744693,-0.754818798289,-0.755109732051,-0.755400546032,-0.755691240281,
	-0.755981814848,-0.756272269785,-0.756562605142,-0.756852820970,-0.757142917318,
	-0.757432894238,-0.757722751779,-0.758012489992,-0.758302108928,-0.758591608637,
	-0.758880989169,-0.759170250574,-0.759459392904,-0.759748416207,-0.760037320535,
	-0.760326105937,-0.760614772464,-0.760903320166,-0.761191749093,-0.761480059295,
	-0.761768250823,-0.762056323726,-0.762344278054,-0.762632113858,-0.762919831188,
	-0.763207430093,-0.763494910624,-0.763782272830,-0.764069516762,-0.764356642469,
	-0.764643650001,-0.764930539409,-0.765217310741,-0.765503964048,-0.765790499380,
	-0.766076916786,-0.766363216317,-0.766649398021,-0.766935461949,-0.767221408150,
	-0.767507236674,-0.767792947571,-0.768078540890,-0.768364016681,-0.768649374993,
	-0.768934615877,-0.769219739381,-0.769504745555,-0.769789634448,-0.770074406111,
	-0.770359060592,-0.770643597941,-0.770928018208,-0.771212321441,-0.771496507690,
	-0.771780577005,-0.772064529435,-0.772348365028,-0.772632083835,-0.772915685905,
	-0.773199171287,-0.773482540029,-0.773765792182,-0.774048927794,-0.774331946915,
	-0.774614849594,-0.774897635879,-0.775180305821,-0.775462859467,-0.775745296867,
	-0.776027618071,-0.776309823126,-0.776591912083,-0.776873884989,-0.777155741894,
	-0.777437482848,-0.777719107898,-0.778000617093,-0.778282010483,-0.778563288116,
	-0.778844450041,-0.779125496307,-0.779406426963,-0.779687242057,-0.779967941638,
	-0.780248525755,-0.780528994456,-0.780809347791,-0.781089585807,-0.781369708553,
	-0.781649716079,-0.781929608431,-0.782209385660,-0.782489047814,-0.782768594940,
	-0.783048027089,-0.783327344307,-0.783606546643,-0.783885634147,-0.784164606866,
	-0.784443464848,-0.784722208142,-0.785000836797,-0.785279350861,-0.785557750381,
	-0.785836035406,-0.786114205985,-0.786392262166,-0.786670203997,-0.786948031525,
	-0.787225744800,-0.787503343870,-0.787780828782,-0.788058199584,-0.788335456325,
	-0.788612599053,-0.788889627816,-0.789166542661,-0.789443343637,-0.789720030792,
	-0.789996604174,-0.790273063830,-0.790549409809,-0.790825642158,-0.791101760926,
	-0.791377766159,-0.791653657907,-0.791929436217,-0.792205101136,-0.792480652712,
	-0.792756090993,-0.793031416028,-0.793306627862,-0.793581726545,-0.793856712124,
	-0.794131584646,-0.794406344159,-0.794680990711,-0.794955524349,-0.795229945120,
	-0.795504253073,-0.795778448255,-0.796052530714,-0.796326500496,-0.796600357649,
	-0.796874102220,-0.797147734258,-0.797421253810,-0.797694660922,-0.797967955642,
	-0.798241138017,-0.798514208096,-0.798787165924,-0.799060011550,-0.799332745020,
	-0.799605366382,-0.799877875683,-0.800150272970,-0.800422558290,-0.800694731691,
	-0.800966793219,-0.801238742922,-0.801510580847,-0.801782307040,-0.802053921549,
	-0.802325424420,-0.802596815702,-0.802868095440,-0.803139263682,-0.803410320474,
	-0.803681265864,-0.803952099899,-0.804222822624,-0.804493434088,-0.804763934336,
	-0.805034323416,-0.805304601375,-0.805574768259,-0.805844824115,-0.806114768990,
	-0.806384602930,-0.806654325982,-0.806923938193,-0.807193439609,-0.807462830277,
	-0.807732110244,-0.808001279556,-0.808270338260,-0.808539286402,-0.808808124028,
	-0.809076851186,-0.809345467922,-0.809613974282,-0.809882370312,-0.810150656060,
	-0.810418831571,-0.810686896891,-0.810954852068,-0.811222697147,-0.811490432175,
	-0.811758057199,-0.812025572263,-0.812292977415,-0.812560272701,-0.812827458166,
	-0.813094533858,-0.813361499823,-0.813628356105,-0.813895102753,-0.814161739811,
	-0.814428267326,-0.814694685344,-0.814960993911,-0.815227193072,-0.815493282875,
	-0.815759263364,-0.816025134587,-0.816290896588,-0.816556549414,-0.816822093111,
	-0.817087527724,-0.817352853300,-0.817618069883,-0.817883177521,-0.818148176259,
	-0.818413066142,-0.818677847217,-0.818942519529,-0.819207083124,-0.819471538047,
	-0.819735884344,-0.820000122062,-0.820264251245,-0.820528271939,-0.820792184190,
	-0.821055988043,-0.821319683544,-0.821583270738,-0.821846749671,-0.822110120389,
	-0.822373382937,-0.822636537360,-0.822899583704,-0.823162522014,-0.823425352335,
	-0.823688074714,-0.823950689195,-0.824213195824,-0.824475594646,-0.824737885706,
	-0.825000069049,-0.825262144722,-0.825524112768,-0.825785973234,-0.826047726164,
	-0.826309371604,-0.826570909599,-0.826832340194,-0.827093663434,-0.827354879364,
	-0.827615988029,-0.827876989474,-0.828137883745,-0.828398670887,-0.828659350943,
	-0.828919923960,-0.829180389983,-0.829440749055,-0.829701001223,-0.829961146530,
	-0.830221185023,-0.830481116746,-0.830740941743,-0.831000660059,-0.831260271740,
	-0.831519776830,-0.831779175374,-0.832038467416,-0.832297653001,-0.832556732175,
	-0.832815704981,-0.833074571464,-0.833333331669
	}
};

double always_inline input12ax7clip(double x) {
    double f = fabs(x);
    f = f * input12ax7_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = input12ax7_table.data[0];
    } else if (i >= input12ax7_table.size-1) {
        f = input12ax7_table.data[input12ax7_table.size-1];
    } else {
    f -= i;
    f = input12ax7_table.data[i]*(1-f) + input12ax7_table.data[i+1]*f;
    }
    return copysign(f, x);
}

