/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceMenuBackgroundDelegate {
    private static SubstanceGradientBackgroundDelegate activeBackgroundDelegate = new SubstanceGradientBackgroundDelegate();
    private SubstanceFillBackgroundDelegate fillBackgroundDelegate;

    public SubstanceMenuBackgroundDelegate(float fillAlpha) {
        this.fillBackgroundDelegate = new SubstanceFillBackgroundDelegate(fillAlpha);
    }

    private void paintBackground(Graphics g, JMenuItem menuItem, int width, int height, SubstanceTheme theme, boolean hasDarkBorder) {
        activeBackgroundDelegate.update(g, menuItem, width, height, theme, hasDarkBorder);
    }

    public void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor, boolean hasDarkBorder, int textOffset) {
        if (!menuItem.isShowing()) {
            return;
        }
        ButtonModel model = menuItem.getModel();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        MenuElement[] selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath();
        boolean isRollover = selectedMenuPath.length == 0;
        for (MenuElement elem : selectedMenuPath) {
            if (elem != menuItem) continue;
            isRollover = true;
            break;
        }
        isRollover = isRollover && model.isRollover();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(TransitionLayout.getAlphaComposite((Component)menuItem, 0.7f));
        if (TransitionLayout.isOpaque(menuItem)) {
            graphics.setColor(menuItem.getBackground());
            Container comp = menuItem.getParent();
            if (!(comp instanceof JMenuBar)) {
                graphics.fillRect(0, 0, menuWidth, menuHeight);
            }
            this.fillBackgroundDelegate.setAlphaComposite(0.4f);
            while (comp != null && !(comp instanceof JMenuItem)) {
                if (comp instanceof JMenuBar) {
                    this.fillBackgroundDelegate.setAlphaComposite(0.7f);
                    break;
                }
                comp = comp.getParent();
            }
            this.fillBackgroundDelegate.update((Graphics)graphics, (Component)menuItem, menuItem.getParent() instanceof JMenuBar);
            if (menuItem.getParent() instanceof JPopupMenu) {
                GradientPaint gp;
                Color rightColor;
                Color leftColor;
                ColorScheme scheme;
                if (menuItem.getComponentOrientation().isLeftToRight()) {
                    SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                    if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                        scheme = SubstanceCoreUtilities.getActiveScheme(menuItem);
                        leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getUltraLightColor() : scheme.getLightColor();
                        rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getUltraLightColor() : scheme.getLightColor();
                        gp = new GradientPaint(0.0f, 0.0f, leftColor, textOffset, 0.0f, rightColor);
                        graphics.setPaint(gp);
                        graphics.fillRect(0, 0, textOffset - 2, menuHeight);
                    }
                } else {
                    SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                    if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                        scheme = SubstanceCoreUtilities.getActiveScheme(menuItem);
                        leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getLightColor() : scheme.getUltraLightColor();
                        rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getLightColor() : scheme.getUltraLightColor();
                        gp = new GradientPaint(menuWidth - textOffset, 0.0f, leftColor, menuWidth, 0.0f, rightColor);
                        graphics.setPaint(gp);
                        graphics.fillRect(menuWidth - textOffset - 2, 0, menuWidth, menuHeight);
                    }
                }
            }
        }
        FadeTracker fadeTracker = FadeTracker.getInstance();
        boolean isRolloverAnim = fadeTracker.isTracked(menuItem, FadeTracker.FadeKind.ROLLOVER);
        boolean isArmedAnim = fadeTracker.isTracked(menuItem, FadeTracker.FadeKind.ARM);
        boolean isSelectedAnim = fadeTracker.isTracked(menuItem, FadeTracker.FadeKind.SELECTION);
        if (model.isArmed() || isArmedAnim || isRollover || isRolloverAnim || menuItem instanceof JMenu && (model.isSelected() || isSelectedAnim)) {
            float alpha = 0.0f;
            if (isRolloverAnim) {
                float cyclePos = fadeTracker.getFade10(menuItem, FadeTracker.FadeKind.ROLLOVER);
                alpha = Math.max(alpha, 0.4f * cyclePos / 10.0f);
            } else if (isRollover) {
                alpha = Math.max(alpha, 0.4f);
            }
            if (isArmedAnim) {
                float cyclePos = fadeTracker.getFade10(menuItem, FadeTracker.FadeKind.ARM);
                alpha = Math.max(alpha, 0.4f * cyclePos / 10.0f);
            } else if (model.isArmed()) {
                alpha = Math.max(alpha, 0.4f);
            }
            if (isSelectedAnim) {
                float cyclePos = fadeTracker.getFade10(menuItem, FadeTracker.FadeKind.SELECTION);
                alpha = Math.max(alpha, 0.7f * cyclePos / 10.0f);
            } else if (menuItem instanceof JMenu && model.isSelected()) {
                alpha = Math.max(alpha, 0.7f);
            }
            graphics.setComposite(TransitionLayout.getAlphaComposite((Component)menuItem, alpha));
            this.paintBackground(graphics, menuItem, menuWidth, menuHeight, SubstanceCoreUtilities.getHighlightBackgroundTheme(menuItem, true), hasDarkBorder);
        }
        graphics.dispose();
    }
}

