/////////////////////////////////////////////////////////////////////////////
//  Copyright (C) 2002-2013 UltraVNC Team Members. All Rights Reserved.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
//  USA.
//
// If the source code for the program is not available from the place from
// which you received this file, check 
// http://www.uvnc.com/
//
////////////////////////////////////////////////////////////////////////////

class vncEncodeUltra2;

#if !defined(_WINVNC_EncodeULTRA2)
#define _WINVNC_EncodeULTRA2
#pragma once
#include "vncencoder.h"
#ifdef ULTRAVNC_VEYON_SUPPORT
#include <lzo/lzo1x.h>
#include <jpeglib.h>
#else
#include "lzo/minilzo.h"
#ifdef _INTERNALLIB
#include <jpeglib.h>
#else
#include "libjpeg-turbo-win/jpeglib.h"
#endif
#endif

// Class definition

class vncEncodeUltra2 : public vncEncoder
{
// Fields
public:

// Methods
public:
	// Create/Destroy methods
	vncEncodeUltra2();
	~vncEncodeUltra2();

	virtual void Init();
	virtual const char* GetEncodingName() { return "Ultra"; }

	virtual UINT RequiredBuffSize(UINT width, UINT height);
	virtual UINT NumCodedRects(const rfb::Rect &rect);

	virtual UINT EncodeRect(BYTE *source,VSocket *outConn, BYTE *dest, const rfb::Rect &rect);

// Implementation
private:
	BYTE		      *m_buffer;
	int			       m_bufflen;
	int SendJpegRect(BYTE *src,BYTE *dst, int dst_size, int w, int h, int quality,rfbPixelFormat m_remoteformat);
	bool				lzo;
	lzo_uint out_len;
	unsigned char *destbuffer;
	JSAMPROW *m_rowPointer;
	int m_rowPointerSize;
	void checkRowPointer(int h);
	int m_quality;
	struct jpeg_compress_struct cinfo;
	struct jpeg_error_mgr jerr;
};

#endif // _WINVNC_EncodeUltra

