/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ipc;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.concurrent.Executor;
import org.cryptomator.ipc.Client;
import org.cryptomator.ipc.HandleLaunchArgsMessage;
import org.cryptomator.ipc.IpcMessage;
import org.cryptomator.ipc.IpcMessageListener;
import org.cryptomator.ipc.LoopbackCommunicator;
import org.cryptomator.ipc.RevealRunningAppMessage;
import org.cryptomator.ipc.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IpcCommunicator
extends Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(IpcCommunicator.class);

    public static IpcCommunicator create(Iterable<Path> socketPaths) {
        Preconditions.checkArgument((boolean)socketPaths.iterator().hasNext(), (Object)"socketPaths must contain at least one element");
        for (Path p : socketPaths) {
            try {
                BasicFileAttributes attr = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                if (!attr.isOther()) continue;
                return Client.create(p);
            }
            catch (IOException iOException) {
            }
        }
        try {
            Path socketPath = socketPaths.iterator().next();
            Files.deleteIfExists(socketPath);
            return Server.create(socketPath);
        }
        catch (IOException e) {
            LOG.warn("Failed to create IPC server", (Throwable)e);
            return new LoopbackCommunicator();
        }
    }

    public boolean isClient();

    public void listen(IpcMessageListener var1, Executor var2);

    public void send(IpcMessage var1, Executor var2);

    default public void sendRevealRunningApp() {
        this.send(new RevealRunningAppMessage(), MoreExecutors.directExecutor());
    }

    default public void sendHandleLaunchargs(List<String> args) {
        this.send(new HandleLaunchArgsMessage(args), MoreExecutors.directExecutor());
    }

    @Override
    public void close() throws IOException;

    default public void closeUnchecked() throws UncheckedIOException {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

