/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Rectangle2D;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MainWindow
public class ResizeController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(ResizeController.class);
    private final Stage window;
    public Region tlResizer;
    public Region trResizer;
    public Region blResizer;
    public Region brResizer;
    public Region tResizer;
    public Region rResizer;
    public Region bResizer;
    public Region lResizer;
    public Region lDefaultRegion;
    public Region tDefaultRegion;
    public Region rDefaultRegion;
    public Region bDefaultRegion;
    private double origX;
    private double origY;
    private double origW;
    private double origH;
    private final Settings settings;
    private final BooleanBinding showResizingArrows;

    @Inject
    ResizeController(@MainWindow Stage window, Settings settings) {
        this.window = window;
        this.settings = settings;
        this.showResizingArrows = Bindings.createBooleanBinding(this::isShowResizingArrows, (Observable[])new Observable[]{window.fullScreenProperty()});
    }

    @FXML
    public void initialize() {
        LOG.trace("init ResizeController");
        if (this.neverTouched()) {
            this.settings.displayConfigurationProperty().setValue((Object)this.getMonitorSizes());
            return;
        }
        if (this.didDisplayConfigurationChange()) {
            Rectangle2D primaryScreenBounds = Screen.getPrimary().getBounds();
            this.window.setX((primaryScreenBounds.getWidth() - this.window.getMinWidth()) / 2.0);
            this.window.setY((primaryScreenBounds.getHeight() - this.window.getMinHeight()) / 2.0);
            this.window.setWidth(this.window.getMinWidth());
            this.window.setHeight(this.window.getMinHeight());
        } else {
            this.window.setHeight((double)this.settings.windowHeightProperty().get() > this.window.getMinHeight() ? (double)this.settings.windowHeightProperty().get() : this.window.getMinHeight());
            this.window.setWidth((double)this.settings.windowWidthProperty().get() > this.window.getMinWidth() ? (double)this.settings.windowWidthProperty().get() : this.window.getMinWidth());
            this.window.setX((double)this.settings.windowXPositionProperty().get());
            this.window.setY((double)this.settings.windowYPositionProperty().get());
        }
        this.savePositionalSettings();
    }

    private boolean neverTouched() {
        return this.settings.windowHeightProperty().get() == 0 && this.settings.windowWidthProperty().get() == 0 && this.settings.windowXPositionProperty().get() == 0 && this.settings.windowYPositionProperty().get() == 0;
    }

    private boolean didDisplayConfigurationChange() {
        boolean configurationHasChanged;
        String currentDisplayConfiguration = this.getMonitorSizes();
        String settingsDisplayConfiguration = (String)this.settings.displayConfigurationProperty().get();
        boolean bl = configurationHasChanged = !settingsDisplayConfiguration.equals(currentDisplayConfiguration);
        if (configurationHasChanged) {
            this.settings.displayConfigurationProperty().setValue((Object)currentDisplayConfiguration);
        }
        return configurationHasChanged;
    }

    private String getMonitorSizes() {
        ObservableList screens = Screen.getScreens();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < screens.size(); ++i) {
            Rectangle2D screenBounds = ((Screen)screens.get(i)).getBounds();
            if (!sb.isEmpty()) {
                sb.append(" ");
            }
            sb.append("displayId: " + i + ", " + screenBounds.getWidth() + "x" + screenBounds.getHeight() + ";");
        }
        return sb.toString();
    }

    private void startResize(MouseEvent evt) {
        this.origX = this.window.getX();
        this.origY = this.window.getY();
        this.origW = this.window.getWidth();
        this.origH = this.window.getHeight();
    }

    @FXML
    private void resizeTopLeft(MouseEvent evt) {
        this.resizeTop(evt);
        this.resizeLeft(evt);
    }

    @FXML
    private void resizeTopRight(MouseEvent evt) {
        this.resizeTop(evt);
        this.resizeRight(evt);
    }

    @FXML
    private void resizeBottomLeft(MouseEvent evt) {
        this.resizeBottom(evt);
        this.resizeLeft(evt);
    }

    @FXML
    private void resizeBottomRight(MouseEvent evt) {
        this.resizeBottom(evt);
        this.resizeRight(evt);
    }

    @FXML
    private void resizeTop(MouseEvent evt) {
        this.startResize(evt);
        double newY = evt.getScreenY();
        double dy = newY - this.origY;
        double newH = this.origH - dy;
        if (newH < this.window.getMaxHeight() && newH > this.window.getMinHeight()) {
            this.window.setY(newY);
            this.window.setHeight(newH);
        }
    }

    @FXML
    private void resizeLeft(MouseEvent evt) {
        this.startResize(evt);
        double newX = evt.getScreenX();
        double dx = newX - this.origX;
        double newW = this.origW - dx;
        if (newW < this.window.getMaxWidth() && newW > this.window.getMinWidth()) {
            this.window.setX(newX);
            this.window.setWidth(newW);
        }
    }

    @FXML
    private void resizeBottom(MouseEvent evt) {
        double newH = evt.getSceneY();
        if (newH < this.window.getMaxHeight() && newH > this.window.getMinHeight()) {
            this.window.setHeight(newH);
        }
    }

    @FXML
    private void resizeRight(MouseEvent evt) {
        double newW = evt.getSceneX();
        if (newW < this.window.getMaxWidth() && newW > this.window.getMinWidth()) {
            this.window.setWidth(newW);
        }
    }

    @FXML
    public void savePositionalSettings() {
        this.settings.windowHeightProperty().setValue((Number)this.window.getHeight());
        this.settings.windowWidthProperty().setValue((Number)this.window.getWidth());
        this.settings.windowYPositionProperty().setValue((Number)this.window.getY());
        this.settings.windowXPositionProperty().setValue((Number)this.window.getX());
    }

    public BooleanBinding showResizingArrowsProperty() {
        return this.showResizingArrows;
    }

    public boolean isShowResizingArrows() {
        return !this.window.isFullScreen();
    }
}

