/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.common;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MasterkeyBackupHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MasterkeyBackupHelper.class);

    public static String generateFileIdSuffix(byte[] fileBytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(fileBytes);
            return "." + BaseEncoding.base16().encode(digest, 0, 4);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Every Java Platform must support the Message Digest algorithm SHA-256", e);
        }
    }

    public static Path attemptMasterKeyBackup(Path masterKeyPath) throws IOException {
        byte[] keyFileContents = Files.readAllBytes(masterKeyPath);
        String backupFileName = masterKeyPath.getFileName().toString() + MasterkeyBackupHelper.generateFileIdSuffix(keyFileContents) + ".bkup";
        Path backupFilePath = masterKeyPath.resolveSibling(backupFileName);
        try (SeekableByteChannel ch = Files.newByteChannel(backupFilePath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            ch.write(ByteBuffer.wrap(keyFileContents));
        }
        catch (AccessDeniedException | FileAlreadyExistsException e) {
            MasterkeyBackupHelper.assertExistingBackupMatchesContent(backupFilePath, ByteBuffer.wrap(keyFileContents));
        }
        catch (IOException e) {
            LOG.warn("Failed to backup valid masterkey file.");
        }
        return backupFilePath;
    }

    private static void assertExistingBackupMatchesContent(Path backupFilePath, ByteBuffer expectedContent) {
        if (Files.exists(backupFilePath, new LinkOption[0])) {
            ByteBuffer buf = ByteBuffer.allocateDirect(expectedContent.remaining() + 1);
            try (SeekableByteChannel ch = Files.newByteChannel(backupFilePath, StandardOpenOption.READ);){
                ch.read(buf);
                buf.flip();
                if (buf.compareTo(expectedContent) != 0) {
                    LOG.warn("Corrupt masterkey backup {}. Please replace it manually or unlock the vault on a writable storage device.", (Object)backupFilePath);
                } else {
                    LOG.debug("Verified backup file: {}", (Object)backupFilePath);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to compare valid masterkey with backup file.", (Throwable)e);
            }
        }
    }
}

