# -*- coding: utf-8 -*-
"""
Copyright (c) 2019-2022 Tomasz Łuczak, TeaM-TL

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

function for GUI:
- copy_to_clipboard - copy result into clipboard (only Windows)
- only_numbers - validate only natural values
- only_integer - validate integer values
"""

from io import BytesIO
import re
from PIL import Image

import mswindows
if mswindows.windows() == 1:
    import win32clipboard


def copy_to_clipboard(file_in):
    """
    Copy results into clipboard
    https://stackoverflow.com/questions/34322132/copy-image-to-clipboard
    Copy to clipboard works for Windows only

    debug needed!
    """
    if mswindows.windows() == 1:
        image = Image.open(file_in)

        output = BytesIO()
        image.convert("RGB").save(output, "BMP")
        data = output.getvalue()[14:]
        output.close()

        win32clipboard.OpenClipboard()
        win32clipboard.EmptyClipboard()
        win32clipboard.SetClipboardData(win32clipboard.CF_DIB, data)
        win32clipboard.CloseClipboard()


def only_numbers(char):
    """  Validation entry widgets: only digits """
    return char.isdigit()


def only_integer(char):
    """  Validation entry widgets: only digits """
    if re.match('^[-]{0,1}[0-9]{,6}$', str(char)):
        result = True
    else:
        result = False
    return result

# EOF
