/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpfonts_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpfonts
 * @title: gimpfonts
 * @short_description: Operations related to fonts.
 *
 * Operations related to fonts.
 **/


/**
 * gimp_fonts_refresh:
 *
 * Refresh current fonts. This function always succeeds.
 *
 * This procedure retrieves all fonts currently in the user's font path
 * and updates the font dialogs accordingly. Depending on the amount of
 * fonts on the system, this can take considerable time.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_fonts_refresh (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-fonts-refresh",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_fonts_get_custom_configs:
 * @sysconfig: (out) (transfer full): sysconfig path.
 * @renaming_config: (out) (transfer full): fonts renaming config.
 * @dirs: (out) (array zero-terminated=1) (transfer full): custom fonts directories.
 *
 * Retrieve custom configs.
 *
 * This procedure returns custom FontConfig configs along with the
 * fonts renaming config.
 *
 * Returns: (transfer full): config path.
 *          The returned value must be freed with g_free().
 *
 * Since: 3.0
 **/
gchar *
_gimp_fonts_get_custom_configs (gchar  **sysconfig,
                                gchar  **renaming_config,
                                gchar ***dirs)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *config = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-fonts-get-custom-configs",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    {
      config = GIMP_VALUES_DUP_STRING (return_vals, 1);
      *sysconfig = GIMP_VALUES_DUP_STRING (return_vals, 2);
      *renaming_config = GIMP_VALUES_DUP_STRING (return_vals, 3);
      *dirs = GIMP_VALUES_DUP_STRV (return_vals, 4);
    }

  gimp_value_array_unref (return_vals);

  return config;
}

/**
 * gimp_fonts_get_list:
 * @filter: An optional regular expression used to filter the list.
 *
 * Retrieve the list of loaded fonts.
 *
 * This procedure returns a list of the fonts that are currently
 * available.
 * Each font returned can be used as input to
 * [func@Gimp.context_set_font].
 *
 * Returns: (element-type GimpFont) (array zero-terminated=1) (transfer container):
 *          The list of fonts.
 *          The returned value must be freed with g_free().
 **/
GimpFont **
gimp_fonts_get_list (const gchar *filter)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpFont **font_list = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, filter,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-fonts-get-list",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    font_list = g_value_dup_boxed (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return font_list;
}
