(in-package "DM")

; Matt K. addition, 9/5/2023:
; During processing of a5-rewrite below, even when preceded by (comp t),
; CMUCL Snapshot 2023-08 fails with the error:
; "CMUCL has run out of dynamic heap space (1530 MB)."
; This, even though ACL2 uses the maximum possible dynamic heap space for CMUCL.
; So we exclude CMUCL:
; cert-param: non-cmucl

(include-book "alt")

(defun a5 ()
  '(((0 1 2 3 4)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 3 2 1 0))
    ((0 1 3 4 2)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 4 3 1 0))
    ((0 1 4 2 3)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 2 4 1 0))
    ((0 2 1 4 3)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 4 1 2 0))
    ((0 2 3 1 4)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 1 3 2 0))
    ((0 2 4 3 1)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 3 4 2 0))
    ((0 3 1 2 4)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 2 1 3 0))
    ((0 3 2 4 1)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 4 2 3 0))
    ((0 3 4 1 2)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 1 4 3 0))
    ((0 4 1 3 2)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 3 1 4 0))
    ((0 4 2 1 3)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 1 2 4 0))
    ((0 4 3 2 1)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 2 3 4 0))
    ((1 0 2 4 3)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 4 2 0 1))
    ((1 0 3 2 4)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 2 3 0 1))
    ((1 0 4 3 2)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 3 4 0 1))
    ((1 2 0 3 4)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 3 0 2 1))
    ((1 2 3 4 0)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 4 3 2 1))
    ((1 2 4 0 3)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 0 4 2 1))
    ((1 3 0 4 2)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 4 0 3 1))
    ((1 3 2 0 4)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 0 2 3 1))
    ((1 3 4 2 0)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 2 4 3 1))
    ((1 4 0 2 3)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 2 0 4 1))
    ((1 4 2 3 0)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 3 2 4 1))
    ((1 4 3 0 2)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 0 3 4 1))
    ((2 0 1 3 4)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 3 1 0 2))
    ((2 0 3 4 1)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 4 3 0 2))
    ((2 0 4 1 3)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 1 4 0 2))
    ((2 1 0 4 3)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 4 0 1 2))
    ((2 1 3 0 4)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 0 3 1 2))
    ((2 1 4 3 0)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 3 4 1 2))
    ((2 3 0 1 4)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 1 0 3 2))
    ((2 3 1 4 0)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 4 1 3 2))
    ((2 3 4 0 1)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 0 4 3 2))
    ((2 4 0 3 1)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 3 0 4 2))
    ((2 4 1 0 3)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 0 1 4 2))
    ((2 4 3 1 0)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 1 3 4 2))
    ((3 0 1 4 2)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 4 1 0 3))
    ((3 0 2 1 4)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 1 2 0 3))
    ((3 0 4 2 1)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 2 4 0 3))
    ((3 1 0 2 4)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 2 0 1 3))
    ((3 1 2 4 0)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 4 2 1 3))
    ((3 1 4 0 2)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 2 1 0 4)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (2 3 1 4 0)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 0 4 1 3))
    ((3 2 0 4 1)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 4 0 2 3))
    ((3 2 1 0 4)
     (3 2 0 4 1)
     (3 2 4 1 0)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 1 4 0 2)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 0 4 2 1)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 3 4 0 1)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 1 4 3 0)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 0 4 1 3)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 3 4 2 0)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 2 4 0 3)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 3 4 1 2)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 2 4 3 1)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 1 4 2 3)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 0 1 2 3))
    ((3 2 4 1 0)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 1 2 4 0)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 0 2 1 4)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (1 3 2 0 4)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 0 4 3 2)
     (0 3 2 4 1)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 1 4 2 3))
    ((3 4 0 1 2)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 1 0 4 3))
    ((3 4 1 2 0)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 2 1 4 3))
    ((3 4 2 0 1)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 0 3 4 1)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 1 3 0 4)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 2 3 1 4)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 1 3 4 2)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 2 3 4 0)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 0 3 2 4)
     (1 0 4 3 2)
     (1 0 2 4 3))
    ((4 0 1 2 3)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 2 1 0 4))
    ((4 0 2 3 1)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 3 2 0 4))
    ((4 0 3 1 2)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 1 3 0 4))
    ((4 1 0 3 2)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 3 0 1 4))
    ((4 1 2 0 3)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 2 3 0 1)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 4 3 1 0)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 0 2 1 4))
    ((4 1 3 2 0)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 3 1 0 2)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (3 4 1 2 0)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 2 3 1 4))
    ((4 2 0 1 3)
     (4 2 1 3 0)
     (4 2 3 0 1)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 1 3 2 0)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (2 1 4 3 0)
     (2 1 0 4 3)
     (2 1 3 0 4)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 4 3 0 2)
     (1 2 4 0 3)
     (1 2 0 3 4)
     (1 2 3 4 0)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 1 0 2 4))
    ((4 2 1 3 0)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 0 3 1 2)
     (2 4 1 0 3)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 0 4 1 3)
     (2 0 1 3 4)
     (2 0 3 4 1)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 0 3 2 4)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 4 3 2 1)
     (0 2 4 3 1)
     (0 2 1 4 3)
     (0 2 3 1 4)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 3 1 2 4))
    ((4 2 3 0 1)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 3 2 1 0)
     (4 3 0 2 1)
     (4 3 1 0 2)
     (4 0 2 3 1)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 1 2 0 3)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (3 4 2 0 1)
     (3 4 0 1 2)
     (3 4 1 2 0)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (0 4 2 1 3)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 1 4 2 3)
     (0 1 2 3 4)
     (0 1 3 4 2)
     (1 4 2 3 0)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 0 4 3 2)
     (1 0 2 4 3)
     (1 0 3 2 4))
    ((4 3 0 2 1)
     (4 3 2 1 0)
     (4 3 1 0 2)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (4 2 3 0 1)
     (4 2 0 1 3)
     (4 2 1 3 0)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (3 2 4 1 0)
     (3 2 0 4 1)
     (3 2 1 0 4)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (2 4 3 1 0)
     (2 4 0 3 1)
     (2 4 1 0 3)
     (2 3 4 0 1)
     (2 3 0 1 4)
     (2 3 1 4 0)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 2 0 3 4))
    ((4 3 1 0 2)
     (4 3 0 2 1)
     (4 3 2 1 0)
     (4 1 3 2 0)
     (4 1 0 3 2)
     (4 1 2 0 3)
     (4 0 3 1 2)
     (4 0 1 2 3)
     (4 0 2 3 1)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 4 2 0 1)
     (3 1 4 0 2)
     (3 1 0 2 4)
     (3 1 2 4 0)
     (3 0 4 2 1)
     (3 0 1 4 2)
     (3 0 2 1 4)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (1 4 3 0 2)
     (1 4 0 2 3)
     (1 4 2 3 0)
     (1 3 4 2 0)
     (1 3 0 4 2)
     (1 3 2 0 4)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (0 4 3 2 1)
     (0 4 1 3 2)
     (0 4 2 1 3)
     (0 3 4 1 2)
     (0 3 1 2 4)
     (0 3 2 4 1)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 1 2 3 4)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 0 1 3 4))
    ((4 3 2 1 0)
     (4 3 1 0 2)
     (4 3 0 2 1)
     (4 2 3 0 1)
     (4 2 1 3 0)
     (4 2 0 1 3)
     (4 1 3 2 0)
     (4 1 2 0 3)
     (4 1 0 3 2)
     (4 0 3 1 2)
     (4 0 2 3 1)
     (4 0 1 2 3)
     (3 4 2 0 1)
     (3 4 1 2 0)
     (3 4 0 1 2)
     (3 2 4 1 0)
     (3 2 1 0 4)
     (3 2 0 4 1)
     (3 1 4 0 2)
     (3 1 2 4 0)
     (3 1 0 2 4)
     (3 0 4 2 1)
     (3 0 2 1 4)
     (3 0 1 4 2)
     (2 4 3 1 0)
     (2 4 1 0 3)
     (2 4 0 3 1)
     (2 3 4 0 1)
     (2 3 1 4 0)
     (2 3 0 1 4)
     (2 1 4 3 0)
     (2 1 3 0 4)
     (2 1 0 4 3)
     (2 0 4 1 3)
     (2 0 3 4 1)
     (2 0 1 3 4)
     (1 4 3 0 2)
     (1 4 2 3 0)
     (1 4 0 2 3)
     (1 3 4 2 0)
     (1 3 2 0 4)
     (1 3 0 4 2)
     (1 2 4 0 3)
     (1 2 3 4 0)
     (1 2 0 3 4)
     (1 0 4 3 2)
     (1 0 3 2 4)
     (1 0 2 4 3)
     (0 4 3 2 1)
     (0 4 2 1 3)
     (0 4 1 3 2)
     (0 3 4 1 2)
     (0 3 2 4 1)
     (0 3 1 2 4)
     (0 2 4 3 1)
     (0 2 3 1 4)
     (0 2 1 4 3)
     (0 1 4 2 3)
     (0 1 3 4 2)
     (0 1 2 3 4))))

(defthmd a5-rewrite
  (equal (alt 5) (a5)))

(in-theory (disable a5 (a5) alt (alt)))
