/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.engine.Block;
import sleep.engine.CallRequest;
import sleep.interfaces.Function;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class SleepClosure
implements Function,
Runnable {
    private static int ccount = -1;
    private int id;
    Block code;
    ScriptInstance owner;
    Stack context;
    HashMap metadata;
    Variable variables;

    public Iterator scalarIterator() {
        return new ClosureIterator();
    }

    public void putMetadata(Object object, Object object2) {
        this.metadata.put(object, object2);
    }

    public Object getAndRemoveMetadata(Object object, Object object2) {
        Object v = this.metadata.remove(object);
        if (v == null) {
            return object2;
        }
        return v;
    }

    private void saveToplevelContext(Stack stack, LinkedList linkedList) {
        if (!stack.isEmpty()) {
            stack.push(linkedList);
            this.context.push(stack);
        } else if (linkedList.size() != 1) {
            throw new RuntimeException(linkedList.size() - 1 + " unaccounted local stack frame(s) in " + this.toString() + " (perhaps you forgot to &popl?)");
        }
    }

    private Stack getToplevelContext() {
        if (this.context.isEmpty()) {
            return new Stack();
        }
        return (Stack)this.context.pop();
    }

    public String toStringGeneric() {
        return "&closure[" + this.code.getSourceLocation() + "]";
    }

    public String toString() {
        return this.toStringGeneric() + "#" + this.id;
    }

    private SleepClosure() {
    }

    public SleepClosure(ScriptInstance scriptInstance, Block block) {
        this(scriptInstance, block, scriptInstance.getScriptVariables().getGlobalVariables().createInternalVariableContainer());
    }

    public SleepClosure(ScriptInstance scriptInstance, Block block, Variable variable) {
        this.code = block;
        this.owner = scriptInstance;
        this.context = new Stack();
        this.metadata = new HashMap();
        variable.putScalar("$this", SleepUtils.getScalar(this));
        this.setVariables(variable);
        this.id = ccount = (ccount + 1) % Short.MAX_VALUE;
    }

    public ScriptInstance getOwner() {
        return this.owner;
    }

    public Block getRunnableCode() {
        return this.code;
    }

    public Variable getVariables() {
        return this.variables;
    }

    public void setVariables(Variable variable) {
        this.variables = variable;
    }

    public void run() {
        this.callClosure("run", null, null);
    }

    public Scalar callClosure(String string, ScriptInstance scriptInstance, Stack stack) {
        if (scriptInstance == null) {
            scriptInstance = this.getOwner();
        }
        if (stack == null) {
            stack = new Stack();
        }
        scriptInstance.getScriptEnvironment().pushSource("<internal>");
        scriptInstance.getScriptEnvironment().CreateFrame();
        scriptInstance.getScriptEnvironment().CreateFrame(stack);
        CallRequest.ClosureCallRequest closureCallRequest = new CallRequest.ClosureCallRequest(scriptInstance.getScriptEnvironment(), -1, SleepUtils.getScalar(this), string);
        closureCallRequest.CallFunction();
        Scalar scalar = scriptInstance.getScriptEnvironment().getCurrentFrame().isEmpty() ? SleepUtils.getEmptyScalar() : (Scalar)scriptInstance.getScriptEnvironment().getCurrentFrame().pop();
        scriptInstance.getScriptEnvironment().KillFrame();
        scriptInstance.getScriptEnvironment().clearReturn();
        scriptInstance.getScriptEnvironment().popSource();
        return scalar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        Scalar scalar;
        if (this.owner == null) {
            this.owner = scriptInstance;
        }
        ScriptVariables scriptVariables = scriptInstance.getScriptVariables();
        ScriptEnvironment scriptEnvironment = scriptInstance.getScriptEnvironment();
        ScriptVariables scriptVariables2 = scriptVariables;
        synchronized (scriptVariables2) {
            LinkedList linkedList;
            Stack stack2 = this.getToplevelContext();
            scriptEnvironment.loadContext(stack2, this.metadata);
            scriptVariables.pushClosureLevel(this.getVariables());
            if (stack2.isEmpty()) {
                scriptVariables.beginToplevel(new LinkedList());
                scriptVariables.pushLocalLevel();
            } else {
                linkedList = (LinkedList)stack2.pop();
                scriptVariables.beginToplevel(linkedList);
            }
            Variable variable = scriptVariables.getLocalVariables();
            scriptVariables.setScalarLevel("$0", SleepUtils.getScalar(string), variable);
            BridgeUtilities.initLocalScope(scriptVariables, variable, stack);
            scalar = stack2.isEmpty() ? this.code.evaluate(scriptEnvironment) : scriptEnvironment.evaluateOldContext();
            linkedList = scriptVariables.leaveToplevel();
            scriptVariables.popClosureLevel();
            if (scriptInstance.getScriptEnvironment().isCallCC()) {
                SleepClosure sleepClosure = SleepUtils.getFunctionFromScalar(scriptInstance.getScriptEnvironment().getReturnValue(), scriptInstance);
                sleepClosure.putMetadata("continuation", SleepUtils.getScalar(this));
                sleepClosure.putMetadata("sourceLine", scriptInstance.getScriptEnvironment().getCurrentFrame().pop());
                sleepClosure.putMetadata("sourceFile", scriptInstance.getScriptEnvironment().getCurrentFrame().pop());
                scriptInstance.getScriptEnvironment().flagReturn(scriptInstance.getScriptEnvironment().getReturnValue(), 128);
            }
            this.saveToplevelContext(scriptEnvironment.saveContext(), linkedList);
        }
        return scalar;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.id);
        objectOutputStream.writeObject(this.code);
        objectOutputStream.writeObject(this.context);
        objectOutputStream.writeObject(this.variables);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.id = objectInputStream.readInt();
        this.code = (Block)objectInputStream.readObject();
        this.context = (Stack)objectInputStream.readObject();
        this.metadata = new HashMap();
        this.variables = (Variable)objectInputStream.readObject();
        this.owner = null;
    }

    private class ClosureIterator
    implements Iterator {
        protected Scalar current;
        protected Stack locals = new Stack();

        private ClosureIterator() {
        }

        public boolean hasNext() {
            this.current = SleepClosure.this.callClosure("eval", null, this.locals);
            return !SleepUtils.isEmptyScalar(this.current);
        }

        public Object next() {
            return this.current;
        }

        public void remove() {
        }
    }
}

