/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import sleep.runtime.SleepUtils;

public class MyLinkedList
extends AbstractSequentialList
implements Cloneable,
Serializable,
List {
    private transient int size = 0;
    private transient ListEntry header;
    private transient MyLinkedList parentList;

    public int size() {
        return this.size;
    }

    private MyLinkedList(MyLinkedList myLinkedList, ListEntry listEntry, ListEntry listEntry2, int n) {
        this.parentList = myLinkedList;
        this.modCount = this.parentList.modCount;
        this.header = new SublistHeaderEntry(listEntry, listEntry2);
        this.size = n;
    }

    public MyLinkedList() {
        this.header = new NormalListEntry(SleepUtils.getScalar("[:HEADER:]"), null, null);
        this.header.setNext(this.header);
        this.header.setPrevious(this.header);
    }

    public List subList(int n, int n2) {
        this.checkSafety();
        ListEntry listEntry = this.getAt(n).next();
        ListEntry listEntry2 = this.getAt(n2);
        while (listEntry instanceof ListEntryWrapper) {
            listEntry = ((ListEntryWrapper)listEntry).parent;
        }
        while (listEntry2 instanceof ListEntryWrapper) {
            listEntry2 = ((ListEntryWrapper)listEntry2).parent;
        }
        return new MyLinkedList(this.parentList == null ? this : this.parentList, listEntry, listEntry2, n2 - n);
    }

    public boolean add(Object object) {
        ListEntry listEntry = this.header;
        this.header.previous().addAfter(object);
        return true;
    }

    public void add(int n, Object object) {
        ListEntry listEntry = this.getAt(n);
        listEntry.addAfter(object);
    }

    public Object get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getAt(n).next().element();
    }

    public Object remove(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        ListEntry listEntry = this.getAt(n).next();
        Object object = listEntry.element();
        listEntry.remove();
        return object;
    }

    private ListEntry getAt(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        ListEntry listEntry = this.header;
        if (n == this.size) {
            return this.header.previous();
        }
        if (n < this.size / 2) {
            for (int i = 0; i < n; ++i) {
                listEntry = listEntry.next();
            }
        } else {
            listEntry = listEntry.previous();
            for (int i = this.size; i > n; --i) {
                listEntry = listEntry.previous();
            }
        }
        return listEntry;
    }

    public ListIterator listIterator(int n) {
        return new MyListIterator(this.getAt(n), n);
    }

    public void checkSafety() {
        if (this.parentList != null && this.modCount != this.parentList.modCount) {
            throw new ConcurrentModificationException("parent @array changed after &sublist creation");
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.header = new NormalListEntry(SleepUtils.getScalar("[:HEADER:]"), null, null);
        this.header.setNext(this.header);
        this.header.setPrevious(this.header);
        for (int i = 0; i < n; ++i) {
            this.add(objectInputStream.readObject());
        }
    }

    private class NormalListEntry
    implements ListEntry {
        public Object element;
        public ListEntry previous;
        public ListEntry next;

        public NormalListEntry(Object object, ListEntry listEntry, ListEntry listEntry2) {
            this.element = object;
            this.previous = listEntry;
            this.next = listEntry2;
            if (this.previous != null) {
                this.previous.setNext(this);
            }
            if (this.next != null) {
                this.next.setPrevious(this);
            }
        }

        public void setNext(ListEntry listEntry) {
            this.next = listEntry;
        }

        public void setPrevious(ListEntry listEntry) {
            this.previous = listEntry;
        }

        public ListEntry next() {
            return this.next;
        }

        public ListEntry previous() {
            return this.previous;
        }

        public ListEntry remove() {
            ListEntry listEntry = this.previous();
            ListEntry listEntry2 = this.next();
            listEntry2.setPrevious(listEntry);
            listEntry.setNext(listEntry2);
            MyLinkedList.this.size--;
            MyLinkedList.this.modCount++;
            return listEntry2;
        }

        public void setElement(Object object) {
            this.element = object;
        }

        public Object element() {
            return this.element;
        }

        public ListEntry addBefore(Object object) {
            NormalListEntry normalListEntry = new NormalListEntry(object, this.previous, this);
            MyLinkedList.this.size++;
            MyLinkedList.this.modCount++;
            return normalListEntry;
        }

        public ListEntry addAfter(Object object) {
            NormalListEntry normalListEntry = new NormalListEntry(object, this, this.next);
            MyLinkedList.this.size++;
            MyLinkedList.this.modCount++;
            return normalListEntry;
        }

        public String toString() {
            ListEntry listEntry;
            StringBuffer stringBuffer = new StringBuffer(":[" + this.element() + "]:");
            if (this == MyLinkedList.this.header) {
                stringBuffer = new StringBuffer(":[HEADER]:");
            }
            for (listEntry = this.previous(); listEntry != MyLinkedList.this.header; listEntry = listEntry.previous()) {
                stringBuffer.insert(0, "[" + listEntry.element() + "]-> ");
            }
            for (listEntry = this.next(); listEntry != MyLinkedList.this.header; listEntry = listEntry.next()) {
                stringBuffer.append(" ->[" + listEntry.element() + "]");
            }
            return stringBuffer.toString();
        }
    }

    private class ListEntryWrapper
    implements ListEntry {
        public ListEntry parent;

        public ListEntryWrapper(ListEntry listEntry) {
            this.parent = listEntry;
        }

        public ListEntry remove() {
            MyLinkedList.this.checkSafety();
            ListEntry listEntry = this.parent.remove();
            MyLinkedList.this.size--;
            MyLinkedList.this.modCount++;
            if (MyLinkedList.this.size == 0) {
                return MyLinkedList.this.header;
            }
            if (this.parent == MyLinkedList.this.header.next()) {
                MyLinkedList.this.header.setNext(listEntry);
            }
            if (this.parent == MyLinkedList.this.header.previous()) {
                MyLinkedList.this.header.setPrevious(listEntry);
            }
            return new ListEntryWrapper(listEntry);
        }

        public ListEntry addBefore(Object object) {
            MyLinkedList.this.checkSafety();
            ListEntry listEntry = this.parent.addBefore(object);
            MyLinkedList.this.size++;
            MyLinkedList.this.modCount++;
            if (MyLinkedList.this.size == 1) {
                MyLinkedList.this.header.setNext(listEntry);
                MyLinkedList.this.header.setPrevious(listEntry);
            } else if (this.parent == MyLinkedList.this.header.next()) {
                MyLinkedList.this.header.setPrevious(listEntry);
            }
            return new ListEntryWrapper(listEntry);
        }

        public ListEntry addAfter(Object object) {
            MyLinkedList.this.checkSafety();
            ListEntry listEntry = this.parent.addAfter(object);
            MyLinkedList.this.size++;
            MyLinkedList.this.modCount++;
            if (MyLinkedList.this.size == 1) {
                MyLinkedList.this.header.setNext(listEntry);
                MyLinkedList.this.header.setPrevious(listEntry);
            } else if (this.parent == MyLinkedList.this.header.previous()) {
                MyLinkedList.this.header.setNext(listEntry);
            }
            return new ListEntryWrapper(listEntry);
        }

        public void setNext(ListEntry listEntry) {
            throw new UnsupportedOperationException("ListEntryWrapper::setNext");
        }

        public void setPrevious(ListEntry listEntry) {
            throw new UnsupportedOperationException("ListEntryWrapper::setPrevious");
        }

        public Object element() {
            return this.parent.element();
        }

        public void setElement(Object object) {
            this.parent.setElement(object);
        }

        public ListEntry next() {
            MyLinkedList.this.checkSafety();
            if (this.parent == MyLinkedList.this.header.next()) {
                return new ListEntryWrapper(MyLinkedList.this.header);
            }
            ListEntryWrapper listEntryWrapper = new ListEntryWrapper(this.parent.next());
            return listEntryWrapper;
        }

        public ListEntry previous() {
            MyLinkedList.this.checkSafety();
            if (this.parent == MyLinkedList.this.header.previous()) {
                return new ListEntryWrapper(MyLinkedList.this.header);
            }
            ListEntryWrapper listEntryWrapper = new ListEntryWrapper(this.parent.previous());
            return listEntryWrapper;
        }
    }

    private class SublistHeaderEntry
    implements ListEntry {
        private ListEntry anchorLeft;
        private ListEntry anchorRight;

        public SublistHeaderEntry(ListEntry listEntry, ListEntry listEntry2) {
            this.anchorLeft = listEntry.previous();
            this.anchorRight = listEntry2.next();
        }

        public ListEntry remove() {
            throw new UnsupportedOperationException("remove");
        }

        public ListEntry previous() {
            return new ListEntryWrapper(this.anchorRight.previous());
        }

        public ListEntry next() {
            return new ListEntryWrapper(this.anchorLeft.next());
        }

        public void setNext(ListEntry listEntry) {
            this.anchorRight.setPrevious(listEntry);
            listEntry.setNext(this.anchorRight);
        }

        public void setPrevious(ListEntry listEntry) {
            this.anchorLeft.setNext(listEntry);
            listEntry.setPrevious(this.anchorLeft);
        }

        public ListEntry addBefore(Object object) {
            return this.previous().addAfter(object);
        }

        public ListEntry addAfter(Object object) {
            return this.next().addBefore(object);
        }

        public Object element() {
            return SleepUtils.getScalar("[:header:]");
        }

        public void setElement(Object object) {
            throw new UnsupportedOperationException("setElement");
        }
    }

    private static interface ListEntry
    extends Serializable {
        public ListEntry remove();

        public ListEntry addBefore(Object var1);

        public ListEntry addAfter(Object var1);

        public ListEntry next();

        public ListEntry previous();

        public void setNext(ListEntry var1);

        public void setPrevious(ListEntry var1);

        public Object element();

        public void setElement(Object var1);
    }

    private class MyListIterator
    implements ListIterator,
    Serializable {
        protected int index;
        protected int start;
        protected ListEntry current;
        protected int modCountCheck;

        public void checkSafety() {
            if (this.modCountCheck != MyLinkedList.this.modCount) {
                throw new ConcurrentModificationException("@array changed during iteration");
            }
        }

        public MyListIterator(ListEntry listEntry, int n) {
            this.modCountCheck = MyLinkedList.this.modCount;
            this.index = n;
            this.start = n;
            this.current = listEntry;
        }

        public void add(Object object) {
            this.checkSafety();
            this.current = this.current.addAfter(object);
            ++this.index;
            ++this.modCountCheck;
        }

        public boolean hasNext() {
            return this.index != MyLinkedList.this.size;
        }

        public boolean hasPrevious() {
            return this.index != 0;
        }

        public Object next() {
            this.checkSafety();
            this.current = this.current.next();
            ++this.index;
            return this.current.element();
        }

        public Object previous() {
            this.checkSafety();
            this.current = this.current.previous();
            --this.index;
            return this.current.element();
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.current == MyLinkedList.this.header) {
                throw new IllegalStateException("list is empty");
            }
            this.checkSafety();
            this.current = this.current.remove().previous();
            --this.index;
            ++this.modCountCheck;
        }

        public void set(Object object) {
            if (this.current == MyLinkedList.this.header) {
                throw new IllegalStateException("list is empty");
            }
            this.checkSafety();
            this.current.setElement(object);
        }
    }
}

