/**
 * The MIT License (MIT)
 *
 * Copyright (c) 2018-2019 Erik Moqvist
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/**
 * This file was generated by asn1tools version 0.162.0 Fri May  6 17:18:21 2022.
 */

#include <string.h>

#include "oer.h"

struct encoder_t {
    uint8_t *buf_p;
    ssize_t size;
    ssize_t pos;
};

struct decoder_t {
    const uint8_t *buf_p;
    ssize_t size;
    ssize_t pos;
};


static uint8_t enumerated_value_length(int32_t value)
{
    uint8_t length;

    if ((value >=0) && (value < 128)) {
        length = 0;
    } else if ((value >= -128) && (value < 128)) {
        length = 1;
    } else if ((value >= -32768) && (value < 32768)) {
        length = 2;
    } else if ((value >= -8388608) && (value < 8388608)) {
        length = 3;
    } else {
        length = 4;
    }

    return length;
}

static uint32_t length_determinant_length(uint32_t value)
{
    uint32_t length;

    if (value < 128u) {
        length = 1;
    } else if (value < 256u) {
        length = 2;
    } else if (value < 65536u) {
        length = 3;
    } else if (value < 16777216u) {
        length = 4;
    } else {
        length = 5;
    }

    return (length);
}

static uint8_t minimum_uint_length(uint32_t value)
{
    uint8_t length;

    if (value < 256u) {
        length = 1;
    } else if (value < 65536u) {
        length = 2;
    } else if (value < 16777216u) {
        length = 3;
    } else {
        length = 4;
    }

    return (length);
}
static void encoder_init(struct encoder_t *self_p,
                         uint8_t *buf_p,
                         size_t size)
{
    self_p->buf_p = buf_p;
    self_p->size = (ssize_t)size;
    self_p->pos = 0;
}

static ssize_t encoder_get_result(const struct encoder_t *self_p)
{
    return (self_p->pos);
}

static void encoder_abort(struct encoder_t *self_p,
                          ssize_t error)
{
    if (self_p->size >= 0) {
        self_p->size = -error;
        self_p->pos = -error;
    }
}

static ssize_t encoder_alloc(struct encoder_t *self_p,
                             size_t size)
{
    ssize_t pos;

    if ((self_p->pos + (ssize_t)size) <= self_p->size) {
        pos = self_p->pos;
        self_p->pos += (ssize_t)size;
    } else {
        pos = -ENOMEM;
        encoder_abort(self_p, ENOMEM);
    }

    return (pos);
}

static void encoder_append_bytes(struct encoder_t *self_p,
                                 const uint8_t *buf_p,
                                 size_t size)
{
    ssize_t pos;

    pos = encoder_alloc(self_p, size);

    if (pos < 0) {
        return;
    }

    (void)memcpy(&self_p->buf_p[pos], buf_p, size);
}

static void encoder_append_uint8(struct encoder_t *self_p,
                                 uint8_t value)
{
    encoder_append_bytes(self_p, &value, sizeof(value));
}

static void encoder_append_uint16(struct encoder_t *self_p,
                                  uint16_t value)
{
    uint8_t buf[2];

    buf[0] = (uint8_t)(value >> 8);
    buf[1] = (uint8_t)value;

    encoder_append_bytes(self_p, &buf[0], sizeof(buf));
}

static void encoder_append_uint32(struct encoder_t *self_p,
                                  uint32_t value)
{
    uint8_t buf[4];

    buf[0] = (uint8_t)(value >> 24);
    buf[1] = (uint8_t)(value >> 16);
    buf[2] = (uint8_t)(value >> 8);
    buf[3] = (uint8_t)value;

    encoder_append_bytes(self_p, &buf[0], sizeof(buf));
}

static void encoder_append_uint64(struct encoder_t *self_p,
                                  uint64_t value)
{
    uint8_t buf[8];

    buf[0] = (uint8_t)(value >> 56);
    buf[1] = (uint8_t)(value >> 48);
    buf[2] = (uint8_t)(value >> 40);
    buf[3] = (uint8_t)(value >> 32);
    buf[4] = (uint8_t)(value >> 24);
    buf[5] = (uint8_t)(value >> 16);
    buf[6] = (uint8_t)(value >> 8);
    buf[7] = (uint8_t)value;

    encoder_append_bytes(self_p, &buf[0], sizeof(buf));
}

static void encoder_append_int8(struct encoder_t *self_p,
                                int8_t value)
{
    encoder_append_uint8(self_p, (uint8_t)value);
}

static void encoder_append_int16(struct encoder_t *self_p,
                                 int16_t value)
{
    encoder_append_uint16(self_p, (uint16_t)value);
}

static void encoder_append_int32(struct encoder_t *self_p,
                                 int32_t value)
{
    encoder_append_uint32(self_p, (uint32_t)value);
}

static void encoder_append_int64(struct encoder_t *self_p,
                                 int64_t value)
{
    encoder_append_uint64(self_p, (uint64_t)value);
}

static void encoder_append_long_uint(struct encoder_t *self_p,
                                     uint64_t value,
                                     uint8_t number_of_bytes)
{
    const uint8_t *value_p = (const uint8_t*)&value;
    uint8_t buf[8];
    for(uint32_t byte = 0; byte < number_of_bytes; byte++) {
        buf[number_of_bytes - byte - 1] = *value_p++;
    }
    encoder_append_bytes(self_p, buf, number_of_bytes);
}

static void encoder_append_uint(struct encoder_t *self_p,
                                uint32_t value,
                                uint8_t number_of_bytes)
{
    switch (number_of_bytes) {

    case 1:
        encoder_append_uint8(self_p, (uint8_t)value);
        break;

    case 2:
        encoder_append_uint16(self_p, (uint16_t)value);
        break;

    case 3:
        encoder_append_uint8(self_p, (uint8_t)(value >> 16));
        encoder_append_uint16(self_p, (uint16_t)value);
        break;

    default:
        encoder_append_uint32(self_p, value);
        break;
    }
}

static void encoder_append_int(struct encoder_t *self_p,
                               int32_t value,
                               uint8_t number_of_bytes)
{
    switch (number_of_bytes) {

    case 1:
        encoder_append_int8(self_p, (int8_t)value);
        break;

    case 2:
        encoder_append_int16(self_p, (int16_t)value);
        break;

    case 3:
        encoder_append_uint8(self_p, (uint8_t)((uint32_t)value >> 16));
        encoder_append_int16(self_p, (int16_t)value);
        break;

    default:
        encoder_append_int32(self_p, value);
        break;
    }
}

static void encoder_append_float(struct encoder_t *self_p,
                                 float value)
{
    uint32_t i32;

    (void)memcpy(&i32, &value, sizeof(i32));

    encoder_append_uint32(self_p, i32);
}

static void encoder_append_double(struct encoder_t *self_p,
                                  double value)
{
    uint64_t i64;

    (void)memcpy(&i64, &value, sizeof(i64));

    encoder_append_uint64(self_p, i64);
}

static void encoder_append_bool(struct encoder_t *self_p, bool value)
{
    encoder_append_uint8(self_p, value ? 255u : 0u);
}

static void encoder_append_length_determinant(struct encoder_t *self_p,
                                              uint32_t length)
{
    if (length < 128u) {
        encoder_append_int8(self_p, (int8_t)length);
    } else if (length < 256u) {
        encoder_append_uint8(self_p, 0x81u);
        encoder_append_uint8(self_p, (uint8_t)length);
    } else if (length < 65536u) {
        encoder_append_uint8(self_p, 0x82u);
        encoder_append_uint16(self_p, (uint16_t)length);
    } else if (length < 16777216u) {
        encoder_append_uint32(self_p, length | (0x83u << 24u));
    } else {
        encoder_append_uint8(self_p, 0x84u);
        encoder_append_uint32(self_p, length);
    }
}

static void decoder_init(struct decoder_t *self_p,
                         const uint8_t *buf_p,
                         size_t size)
{
    self_p->buf_p = buf_p;
    self_p->size = (ssize_t)size;
    self_p->pos = 0;
}

static ssize_t decoder_get_result(const struct decoder_t *self_p)
{
    return (self_p->pos);
}

static void decoder_abort(struct decoder_t *self_p,
                          ssize_t error)
{
    if (self_p->size >= 0) {
        self_p->size = -error;
        self_p->pos = -error;
    }
}

static ssize_t decoder_free(struct decoder_t *self_p,
                            size_t size)
{
    ssize_t pos;

    if ((self_p->pos + (ssize_t)size) <= self_p->size) {
        pos = self_p->pos;
        self_p->pos += (ssize_t)size;
    } else {
        pos = -EOUTOFDATA;
        decoder_abort(self_p, EOUTOFDATA);
    }

    return (pos);
}

static void decoder_read_bytes(struct decoder_t *self_p,
                               uint8_t *buf_p,
                               size_t size)
{
    ssize_t pos;

    pos = decoder_free(self_p, size);

    if (pos >= 0) {
        (void)memcpy(buf_p, &self_p->buf_p[pos], size);
    } else {
        (void)memset(buf_p, 0, size);
    }
}

static uint8_t decoder_read_uint8(struct decoder_t *self_p)
{
    uint8_t value;

    decoder_read_bytes(self_p, &value, sizeof(value));

    return (value);
}

static uint16_t decoder_read_uint16(struct decoder_t *self_p)
{
    uint8_t buf[2];

    decoder_read_bytes(self_p, &buf[0], sizeof(buf));

    return (uint16_t)(((uint16_t)buf[0] << 8) | (uint16_t)buf[1]);
}

static uint32_t decoder_read_uint32(struct decoder_t *self_p)
{
    uint8_t buf[4];

    decoder_read_bytes(self_p, &buf[0], sizeof(buf));

    return (((uint32_t)buf[0] << 24)
            | ((uint32_t)buf[1] << 16)
            | ((uint32_t)buf[2] << 8)
            | (uint32_t)buf[3]);
}

static uint64_t decoder_read_uint64(struct decoder_t *self_p)
{
    uint8_t buf[8];

    decoder_read_bytes(self_p, &buf[0], sizeof(buf));

    return (((uint64_t)buf[0] << 56)
            | ((uint64_t)buf[1] << 48)
            | ((uint64_t)buf[2] << 40)
            | ((uint64_t)buf[3] << 32)
            | ((uint64_t)buf[4] << 24)
            | ((uint64_t)buf[5] << 16)
            | ((uint64_t)buf[6] << 8)
            | (uint64_t)buf[7]);
}

static int8_t decoder_read_int8(struct decoder_t *self_p)
{
    return ((int8_t)decoder_read_uint8(self_p));
}

static int16_t decoder_read_int16(struct decoder_t *self_p)
{
    return ((int16_t)decoder_read_uint16(self_p));
}

static int32_t decoder_read_int32(struct decoder_t *self_p)
{
    return ((int32_t)decoder_read_uint32(self_p));
}

static int64_t decoder_read_int64(struct decoder_t *self_p)
{
    return ((int64_t)decoder_read_uint64(self_p));
}

static uint64_t decoder_read_long_uint(struct decoder_t *self_p,
                                       uint8_t number_of_bytes)
{
    uint64_t value = 0;

    for(uint8_t byte = 0; byte < number_of_bytes; byte++) {
        value = decoder_read_uint8(self_p) | (value << 8);
    }

    return (value);
}

static uint32_t decoder_read_uint(struct decoder_t *self_p,
                                  uint8_t number_of_bytes)
{
    uint32_t value;

    switch (number_of_bytes) {

    case 1:
        value = decoder_read_uint8(self_p);
        break;

    case 2:
        value = decoder_read_uint16(self_p);
        break;

    case 3:
        value = ((uint32_t)decoder_read_uint8(self_p) << 16u);
        value |= decoder_read_uint16(self_p);
        break;

    case 4:
        value = decoder_read_uint32(self_p);
        break;

    default:
        value = 0xffffffffu;
        break;
    }

    return (value);
}

static int32_t decoder_read_int(struct decoder_t *self_p,
                                uint8_t number_of_bytes)
{
    int32_t value;
    uint32_t tmp;

    switch (number_of_bytes) {

    case 1:
        value = decoder_read_int8(self_p);
        break;

    case 2:
        value = decoder_read_int16(self_p);
        break;

    case 3:
        tmp = ((uint32_t)decoder_read_uint8(self_p) << 16u);
        tmp |= decoder_read_uint16(self_p);
        if((tmp & 0x800000u) == 0x800000u) {
            tmp += 0xff000000u;
        }
        value = (int32_t)tmp;
        break;

    case 4:
        value = decoder_read_int32(self_p);
        break;

    default:
        value = 2147483647;
        break;
    }

    return (value);
}

static float decoder_read_float(struct decoder_t *self_p)
{
    float value;
    uint32_t i32;

    i32 = decoder_read_uint32(self_p);

    (void)memcpy(&value, &i32, sizeof(value));

    return (value);
}

static double decoder_read_double(struct decoder_t *self_p)
{
    double value;
    uint64_t i64;

    i64 = decoder_read_uint64(self_p);

    (void)memcpy(&value, &i64, sizeof(value));

    return (value);
}

static bool decoder_read_bool(struct decoder_t *self_p)
{
    return (decoder_read_uint8(self_p) != 0u);
}

static uint32_t decoder_read_length_determinant(struct decoder_t *self_p)
{
    uint32_t length;

    length = decoder_read_uint8(self_p);

    if ((length & 0x80u) != 0u) {
        switch (length & 0x7fu) {

        case 1:
            length = decoder_read_uint8(self_p);
            break;

        case 2:
            length = decoder_read_uint16(self_p);
            break;

        case 3:
            length = (((uint32_t)decoder_read_uint8(self_p) << 16)
                      | decoder_read_uint16(self_p));
            break;

        case 4:
            length = decoder_read_uint32(self_p);
            break;

        default:
            length = 0xffffffffu;
            break;
        }
    }

    return (length);
}

static uint32_t decoder_read_tag(struct decoder_t *self_p)
{
    uint32_t tag;

    tag = decoder_read_uint8(self_p);

    if ((tag & 0x3fu) == 0x3fu) {
        do {
            tag <<= 8;
            tag |= (uint32_t)decoder_read_uint8(self_p);
        } while ((tag & 0x80u) == 0x80u);
    }

    return (tag);
}
static uint32_t get_choice_j_length(const struct oer_c_source_ag_t *src_p) {
    uint32_t length;

    switch (src_p->j.choice) {

    case oer_c_source_ag_j_choice_k_e:
        length = 3u;
        break;

    case oer_c_source_ag_j_choice_l_e:
        length = 2u;
        break;

    default:
        length = 0;    break;
    }
    return length;
}


static void oer_c_source_a_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_a_t *src_p)
{
    encoder_append_int8(encoder_p, src_p->a);
    encoder_append_int16(encoder_p, src_p->b);
    encoder_append_int32(encoder_p, src_p->c);
    encoder_append_int64(encoder_p, src_p->d);
    encoder_append_uint8(encoder_p, src_p->e);
    encoder_append_uint16(encoder_p, src_p->f);
    encoder_append_uint32(encoder_p, src_p->g);
    encoder_append_uint64(encoder_p, src_p->h);
    encoder_append_bool(encoder_p, src_p->i);
    encoder_append_bytes(encoder_p,
                         &src_p->j.buf[0],
                         11);
}

static void oer_c_source_a_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_a_t *dst_p)
{
    dst_p->a = decoder_read_int8(decoder_p);
    dst_p->b = decoder_read_int16(decoder_p);
    dst_p->c = decoder_read_int32(decoder_p);
    dst_p->d = decoder_read_int64(decoder_p);
    dst_p->e = decoder_read_uint8(decoder_p);
    dst_p->f = decoder_read_uint16(decoder_p);
    dst_p->g = decoder_read_uint32(decoder_p);
    dst_p->h = decoder_read_uint64(decoder_p);
    dst_p->i = decoder_read_bool(decoder_p);
    decoder_read_bytes(decoder_p,
                       &dst_p->j.buf[0],
                       11);
}

static void oer_c_source_ab_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_ab_t *src_p)
{
    encoder_append_int8(encoder_p, src_p->a);
    encoder_append_uint16(encoder_p, src_p->b);
}

static void oer_c_source_ab_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_ab_t *dst_p)
{
    dst_p->a = decoder_read_int8(decoder_p);
    dst_p->b = decoder_read_uint16(decoder_p);
}

static void oer_c_source_q_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_q_t *src_p)
{
    switch (src_p->choice) {

    case oer_c_source_q_choice_c001_e:
        encoder_append_uint(encoder_p, 0x80, 1);
        encoder_append_bool(encoder_p, src_p->value.c001);
        break;

    case oer_c_source_q_choice_c002_e:
        encoder_append_uint(encoder_p, 0x81, 1);
        encoder_append_bool(encoder_p, src_p->value.c002);
        break;

    case oer_c_source_q_choice_c003_e:
        encoder_append_uint(encoder_p, 0x82, 1);
        encoder_append_bool(encoder_p, src_p->value.c003);
        break;

    case oer_c_source_q_choice_c004_e:
        encoder_append_uint(encoder_p, 0x83, 1);
        encoder_append_bool(encoder_p, src_p->value.c004);
        break;

    case oer_c_source_q_choice_c005_e:
        encoder_append_uint(encoder_p, 0x84, 1);
        encoder_append_bool(encoder_p, src_p->value.c005);
        break;

    case oer_c_source_q_choice_c006_e:
        encoder_append_uint(encoder_p, 0x85, 1);
        encoder_append_bool(encoder_p, src_p->value.c006);
        break;

    case oer_c_source_q_choice_c007_e:
        encoder_append_uint(encoder_p, 0x86, 1);
        encoder_append_bool(encoder_p, src_p->value.c007);
        break;

    case oer_c_source_q_choice_c008_e:
        encoder_append_uint(encoder_p, 0x87, 1);
        encoder_append_bool(encoder_p, src_p->value.c008);
        break;

    case oer_c_source_q_choice_c009_e:
        encoder_append_uint(encoder_p, 0x88, 1);
        encoder_append_bool(encoder_p, src_p->value.c009);
        break;

    case oer_c_source_q_choice_c010_e:
        encoder_append_uint(encoder_p, 0x89, 1);
        encoder_append_bool(encoder_p, src_p->value.c010);
        break;

    case oer_c_source_q_choice_c011_e:
        encoder_append_uint(encoder_p, 0x8a, 1);
        encoder_append_bool(encoder_p, src_p->value.c011);
        break;

    case oer_c_source_q_choice_c012_e:
        encoder_append_uint(encoder_p, 0x8b, 1);
        encoder_append_bool(encoder_p, src_p->value.c012);
        break;

    case oer_c_source_q_choice_c013_e:
        encoder_append_uint(encoder_p, 0x8c, 1);
        encoder_append_bool(encoder_p, src_p->value.c013);
        break;

    case oer_c_source_q_choice_c014_e:
        encoder_append_uint(encoder_p, 0x8d, 1);
        encoder_append_bool(encoder_p, src_p->value.c014);
        break;

    case oer_c_source_q_choice_c015_e:
        encoder_append_uint(encoder_p, 0x8e, 1);
        encoder_append_bool(encoder_p, src_p->value.c015);
        break;

    case oer_c_source_q_choice_c016_e:
        encoder_append_uint(encoder_p, 0x8f, 1);
        encoder_append_bool(encoder_p, src_p->value.c016);
        break;

    case oer_c_source_q_choice_c017_e:
        encoder_append_uint(encoder_p, 0x90, 1);
        encoder_append_bool(encoder_p, src_p->value.c017);
        break;

    case oer_c_source_q_choice_c018_e:
        encoder_append_uint(encoder_p, 0x91, 1);
        encoder_append_bool(encoder_p, src_p->value.c018);
        break;

    case oer_c_source_q_choice_c019_e:
        encoder_append_uint(encoder_p, 0x92, 1);
        encoder_append_bool(encoder_p, src_p->value.c019);
        break;

    case oer_c_source_q_choice_c020_e:
        encoder_append_uint(encoder_p, 0x93, 1);
        encoder_append_bool(encoder_p, src_p->value.c020);
        break;

    case oer_c_source_q_choice_c021_e:
        encoder_append_uint(encoder_p, 0x94, 1);
        encoder_append_bool(encoder_p, src_p->value.c021);
        break;

    case oer_c_source_q_choice_c022_e:
        encoder_append_uint(encoder_p, 0x95, 1);
        encoder_append_bool(encoder_p, src_p->value.c022);
        break;

    case oer_c_source_q_choice_c023_e:
        encoder_append_uint(encoder_p, 0x96, 1);
        encoder_append_bool(encoder_p, src_p->value.c023);
        break;

    case oer_c_source_q_choice_c024_e:
        encoder_append_uint(encoder_p, 0x97, 1);
        encoder_append_bool(encoder_p, src_p->value.c024);
        break;

    case oer_c_source_q_choice_c025_e:
        encoder_append_uint(encoder_p, 0x98, 1);
        encoder_append_bool(encoder_p, src_p->value.c025);
        break;

    case oer_c_source_q_choice_c026_e:
        encoder_append_uint(encoder_p, 0x99, 1);
        encoder_append_bool(encoder_p, src_p->value.c026);
        break;

    case oer_c_source_q_choice_c027_e:
        encoder_append_uint(encoder_p, 0x9a, 1);
        encoder_append_bool(encoder_p, src_p->value.c027);
        break;

    case oer_c_source_q_choice_c028_e:
        encoder_append_uint(encoder_p, 0x9b, 1);
        encoder_append_bool(encoder_p, src_p->value.c028);
        break;

    case oer_c_source_q_choice_c029_e:
        encoder_append_uint(encoder_p, 0x9c, 1);
        encoder_append_bool(encoder_p, src_p->value.c029);
        break;

    case oer_c_source_q_choice_c030_e:
        encoder_append_uint(encoder_p, 0x9d, 1);
        encoder_append_bool(encoder_p, src_p->value.c030);
        break;

    case oer_c_source_q_choice_c031_e:
        encoder_append_uint(encoder_p, 0x9e, 1);
        encoder_append_bool(encoder_p, src_p->value.c031);
        break;

    case oer_c_source_q_choice_c032_e:
        encoder_append_uint(encoder_p, 0x9f, 1);
        encoder_append_bool(encoder_p, src_p->value.c032);
        break;

    case oer_c_source_q_choice_c033_e:
        encoder_append_uint(encoder_p, 0xa0, 1);
        encoder_append_bool(encoder_p, src_p->value.c033);
        break;

    case oer_c_source_q_choice_c034_e:
        encoder_append_uint(encoder_p, 0xa1, 1);
        encoder_append_bool(encoder_p, src_p->value.c034);
        break;

    case oer_c_source_q_choice_c035_e:
        encoder_append_uint(encoder_p, 0xa2, 1);
        encoder_append_bool(encoder_p, src_p->value.c035);
        break;

    case oer_c_source_q_choice_c036_e:
        encoder_append_uint(encoder_p, 0xa3, 1);
        encoder_append_bool(encoder_p, src_p->value.c036);
        break;

    case oer_c_source_q_choice_c037_e:
        encoder_append_uint(encoder_p, 0xa4, 1);
        encoder_append_bool(encoder_p, src_p->value.c037);
        break;

    case oer_c_source_q_choice_c038_e:
        encoder_append_uint(encoder_p, 0xa5, 1);
        encoder_append_bool(encoder_p, src_p->value.c038);
        break;

    case oer_c_source_q_choice_c039_e:
        encoder_append_uint(encoder_p, 0xa6, 1);
        encoder_append_bool(encoder_p, src_p->value.c039);
        break;

    case oer_c_source_q_choice_c040_e:
        encoder_append_uint(encoder_p, 0xa7, 1);
        encoder_append_bool(encoder_p, src_p->value.c040);
        break;

    case oer_c_source_q_choice_c041_e:
        encoder_append_uint(encoder_p, 0xa8, 1);
        encoder_append_bool(encoder_p, src_p->value.c041);
        break;

    case oer_c_source_q_choice_c042_e:
        encoder_append_uint(encoder_p, 0xa9, 1);
        encoder_append_bool(encoder_p, src_p->value.c042);
        break;

    case oer_c_source_q_choice_c043_e:
        encoder_append_uint(encoder_p, 0xaa, 1);
        encoder_append_bool(encoder_p, src_p->value.c043);
        break;

    case oer_c_source_q_choice_c044_e:
        encoder_append_uint(encoder_p, 0xab, 1);
        encoder_append_bool(encoder_p, src_p->value.c044);
        break;

    case oer_c_source_q_choice_c045_e:
        encoder_append_uint(encoder_p, 0xac, 1);
        encoder_append_bool(encoder_p, src_p->value.c045);
        break;

    case oer_c_source_q_choice_c046_e:
        encoder_append_uint(encoder_p, 0xad, 1);
        encoder_append_bool(encoder_p, src_p->value.c046);
        break;

    case oer_c_source_q_choice_c047_e:
        encoder_append_uint(encoder_p, 0xae, 1);
        encoder_append_bool(encoder_p, src_p->value.c047);
        break;

    case oer_c_source_q_choice_c048_e:
        encoder_append_uint(encoder_p, 0xaf, 1);
        encoder_append_bool(encoder_p, src_p->value.c048);
        break;

    case oer_c_source_q_choice_c049_e:
        encoder_append_uint(encoder_p, 0xb0, 1);
        encoder_append_bool(encoder_p, src_p->value.c049);
        break;

    case oer_c_source_q_choice_c050_e:
        encoder_append_uint(encoder_p, 0xb1, 1);
        encoder_append_bool(encoder_p, src_p->value.c050);
        break;

    case oer_c_source_q_choice_c051_e:
        encoder_append_uint(encoder_p, 0xb2, 1);
        encoder_append_bool(encoder_p, src_p->value.c051);
        break;

    case oer_c_source_q_choice_c052_e:
        encoder_append_uint(encoder_p, 0xb3, 1);
        encoder_append_bool(encoder_p, src_p->value.c052);
        break;

    case oer_c_source_q_choice_c053_e:
        encoder_append_uint(encoder_p, 0xb4, 1);
        encoder_append_bool(encoder_p, src_p->value.c053);
        break;

    case oer_c_source_q_choice_c054_e:
        encoder_append_uint(encoder_p, 0xb5, 1);
        encoder_append_bool(encoder_p, src_p->value.c054);
        break;

    case oer_c_source_q_choice_c055_e:
        encoder_append_uint(encoder_p, 0xb6, 1);
        encoder_append_bool(encoder_p, src_p->value.c055);
        break;

    case oer_c_source_q_choice_c056_e:
        encoder_append_uint(encoder_p, 0xb7, 1);
        encoder_append_bool(encoder_p, src_p->value.c056);
        break;

    case oer_c_source_q_choice_c057_e:
        encoder_append_uint(encoder_p, 0xb8, 1);
        encoder_append_bool(encoder_p, src_p->value.c057);
        break;

    case oer_c_source_q_choice_c058_e:
        encoder_append_uint(encoder_p, 0xb9, 1);
        encoder_append_bool(encoder_p, src_p->value.c058);
        break;

    case oer_c_source_q_choice_c059_e:
        encoder_append_uint(encoder_p, 0xba, 1);
        encoder_append_bool(encoder_p, src_p->value.c059);
        break;

    case oer_c_source_q_choice_c060_e:
        encoder_append_uint(encoder_p, 0xbb, 1);
        encoder_append_bool(encoder_p, src_p->value.c060);
        break;

    case oer_c_source_q_choice_c061_e:
        encoder_append_uint(encoder_p, 0xbc, 1);
        encoder_append_bool(encoder_p, src_p->value.c061);
        break;

    case oer_c_source_q_choice_c062_e:
        encoder_append_uint(encoder_p, 0xbd, 1);
        encoder_append_bool(encoder_p, src_p->value.c062);
        break;

    case oer_c_source_q_choice_c063_e:
        encoder_append_uint(encoder_p, 0xbe, 1);
        encoder_append_bool(encoder_p, src_p->value.c063);
        break;

    case oer_c_source_q_choice_c064_e:
        encoder_append_uint(encoder_p, 0xbf3f, 2);
        encoder_append_bool(encoder_p, src_p->value.c064);
        break;

    case oer_c_source_q_choice_c065_e:
        encoder_append_uint(encoder_p, 0xbf40, 2);
        encoder_append_bool(encoder_p, src_p->value.c065);
        break;

    case oer_c_source_q_choice_c066_e:
        encoder_append_uint(encoder_p, 0xbf41, 2);
        encoder_append_bool(encoder_p, src_p->value.c066);
        break;

    case oer_c_source_q_choice_c067_e:
        encoder_append_uint(encoder_p, 0xbf42, 2);
        encoder_append_bool(encoder_p, src_p->value.c067);
        break;

    case oer_c_source_q_choice_c068_e:
        encoder_append_uint(encoder_p, 0xbf43, 2);
        encoder_append_bool(encoder_p, src_p->value.c068);
        break;

    case oer_c_source_q_choice_c069_e:
        encoder_append_uint(encoder_p, 0xbf44, 2);
        encoder_append_bool(encoder_p, src_p->value.c069);
        break;

    case oer_c_source_q_choice_c070_e:
        encoder_append_uint(encoder_p, 0xbf45, 2);
        encoder_append_bool(encoder_p, src_p->value.c070);
        break;

    case oer_c_source_q_choice_c071_e:
        encoder_append_uint(encoder_p, 0xbf46, 2);
        encoder_append_bool(encoder_p, src_p->value.c071);
        break;

    case oer_c_source_q_choice_c072_e:
        encoder_append_uint(encoder_p, 0xbf47, 2);
        encoder_append_bool(encoder_p, src_p->value.c072);
        break;

    case oer_c_source_q_choice_c073_e:
        encoder_append_uint(encoder_p, 0xbf48, 2);
        encoder_append_bool(encoder_p, src_p->value.c073);
        break;

    case oer_c_source_q_choice_c074_e:
        encoder_append_uint(encoder_p, 0xbf49, 2);
        encoder_append_bool(encoder_p, src_p->value.c074);
        break;

    case oer_c_source_q_choice_c075_e:
        encoder_append_uint(encoder_p, 0xbf4a, 2);
        encoder_append_bool(encoder_p, src_p->value.c075);
        break;

    case oer_c_source_q_choice_c076_e:
        encoder_append_uint(encoder_p, 0xbf4b, 2);
        encoder_append_bool(encoder_p, src_p->value.c076);
        break;

    case oer_c_source_q_choice_c077_e:
        encoder_append_uint(encoder_p, 0xbf4c, 2);
        encoder_append_bool(encoder_p, src_p->value.c077);
        break;

    case oer_c_source_q_choice_c078_e:
        encoder_append_uint(encoder_p, 0xbf4d, 2);
        encoder_append_bool(encoder_p, src_p->value.c078);
        break;

    case oer_c_source_q_choice_c079_e:
        encoder_append_uint(encoder_p, 0xbf4e, 2);
        encoder_append_bool(encoder_p, src_p->value.c079);
        break;

    case oer_c_source_q_choice_c080_e:
        encoder_append_uint(encoder_p, 0xbf4f, 2);
        encoder_append_bool(encoder_p, src_p->value.c080);
        break;

    case oer_c_source_q_choice_c081_e:
        encoder_append_uint(encoder_p, 0xbf50, 2);
        encoder_append_bool(encoder_p, src_p->value.c081);
        break;

    case oer_c_source_q_choice_c082_e:
        encoder_append_uint(encoder_p, 0xbf51, 2);
        encoder_append_bool(encoder_p, src_p->value.c082);
        break;

    case oer_c_source_q_choice_c083_e:
        encoder_append_uint(encoder_p, 0xbf52, 2);
        encoder_append_bool(encoder_p, src_p->value.c083);
        break;

    case oer_c_source_q_choice_c084_e:
        encoder_append_uint(encoder_p, 0xbf53, 2);
        encoder_append_bool(encoder_p, src_p->value.c084);
        break;

    case oer_c_source_q_choice_c085_e:
        encoder_append_uint(encoder_p, 0xbf54, 2);
        encoder_append_bool(encoder_p, src_p->value.c085);
        break;

    case oer_c_source_q_choice_c086_e:
        encoder_append_uint(encoder_p, 0xbf55, 2);
        encoder_append_bool(encoder_p, src_p->value.c086);
        break;

    case oer_c_source_q_choice_c087_e:
        encoder_append_uint(encoder_p, 0xbf56, 2);
        encoder_append_bool(encoder_p, src_p->value.c087);
        break;

    case oer_c_source_q_choice_c088_e:
        encoder_append_uint(encoder_p, 0xbf57, 2);
        encoder_append_bool(encoder_p, src_p->value.c088);
        break;

    case oer_c_source_q_choice_c089_e:
        encoder_append_uint(encoder_p, 0xbf58, 2);
        encoder_append_bool(encoder_p, src_p->value.c089);
        break;

    case oer_c_source_q_choice_c090_e:
        encoder_append_uint(encoder_p, 0xbf59, 2);
        encoder_append_bool(encoder_p, src_p->value.c090);
        break;

    case oer_c_source_q_choice_c091_e:
        encoder_append_uint(encoder_p, 0xbf5a, 2);
        encoder_append_bool(encoder_p, src_p->value.c091);
        break;

    case oer_c_source_q_choice_c092_e:
        encoder_append_uint(encoder_p, 0xbf5b, 2);
        encoder_append_bool(encoder_p, src_p->value.c092);
        break;

    case oer_c_source_q_choice_c093_e:
        encoder_append_uint(encoder_p, 0xbf5c, 2);
        encoder_append_bool(encoder_p, src_p->value.c093);
        break;

    case oer_c_source_q_choice_c094_e:
        encoder_append_uint(encoder_p, 0xbf5d, 2);
        encoder_append_bool(encoder_p, src_p->value.c094);
        break;

    case oer_c_source_q_choice_c095_e:
        encoder_append_uint(encoder_p, 0xbf5e, 2);
        encoder_append_bool(encoder_p, src_p->value.c095);
        break;

    case oer_c_source_q_choice_c096_e:
        encoder_append_uint(encoder_p, 0xbf5f, 2);
        encoder_append_bool(encoder_p, src_p->value.c096);
        break;

    case oer_c_source_q_choice_c097_e:
        encoder_append_uint(encoder_p, 0xbf60, 2);
        encoder_append_bool(encoder_p, src_p->value.c097);
        break;

    case oer_c_source_q_choice_c098_e:
        encoder_append_uint(encoder_p, 0xbf61, 2);
        encoder_append_bool(encoder_p, src_p->value.c098);
        break;

    case oer_c_source_q_choice_c099_e:
        encoder_append_uint(encoder_p, 0xbf62, 2);
        encoder_append_bool(encoder_p, src_p->value.c099);
        break;

    case oer_c_source_q_choice_c100_e:
        encoder_append_uint(encoder_p, 0xbf63, 2);
        encoder_append_bool(encoder_p, src_p->value.c100);
        break;

    case oer_c_source_q_choice_c101_e:
        encoder_append_uint(encoder_p, 0xbf64, 2);
        encoder_append_bool(encoder_p, src_p->value.c101);
        break;

    case oer_c_source_q_choice_c102_e:
        encoder_append_uint(encoder_p, 0xbf65, 2);
        encoder_append_bool(encoder_p, src_p->value.c102);
        break;

    case oer_c_source_q_choice_c103_e:
        encoder_append_uint(encoder_p, 0xbf66, 2);
        encoder_append_bool(encoder_p, src_p->value.c103);
        break;

    case oer_c_source_q_choice_c104_e:
        encoder_append_uint(encoder_p, 0xbf67, 2);
        encoder_append_bool(encoder_p, src_p->value.c104);
        break;

    case oer_c_source_q_choice_c105_e:
        encoder_append_uint(encoder_p, 0xbf68, 2);
        encoder_append_bool(encoder_p, src_p->value.c105);
        break;

    case oer_c_source_q_choice_c106_e:
        encoder_append_uint(encoder_p, 0xbf69, 2);
        encoder_append_bool(encoder_p, src_p->value.c106);
        break;

    case oer_c_source_q_choice_c107_e:
        encoder_append_uint(encoder_p, 0xbf6a, 2);
        encoder_append_bool(encoder_p, src_p->value.c107);
        break;

    case oer_c_source_q_choice_c108_e:
        encoder_append_uint(encoder_p, 0xbf6b, 2);
        encoder_append_bool(encoder_p, src_p->value.c108);
        break;

    case oer_c_source_q_choice_c109_e:
        encoder_append_uint(encoder_p, 0xbf6c, 2);
        encoder_append_bool(encoder_p, src_p->value.c109);
        break;

    case oer_c_source_q_choice_c110_e:
        encoder_append_uint(encoder_p, 0xbf6d, 2);
        encoder_append_bool(encoder_p, src_p->value.c110);
        break;

    case oer_c_source_q_choice_c111_e:
        encoder_append_uint(encoder_p, 0xbf6e, 2);
        encoder_append_bool(encoder_p, src_p->value.c111);
        break;

    case oer_c_source_q_choice_c112_e:
        encoder_append_uint(encoder_p, 0xbf6f, 2);
        encoder_append_bool(encoder_p, src_p->value.c112);
        break;

    case oer_c_source_q_choice_c113_e:
        encoder_append_uint(encoder_p, 0xbf70, 2);
        encoder_append_bool(encoder_p, src_p->value.c113);
        break;

    case oer_c_source_q_choice_c114_e:
        encoder_append_uint(encoder_p, 0xbf71, 2);
        encoder_append_bool(encoder_p, src_p->value.c114);
        break;

    case oer_c_source_q_choice_c115_e:
        encoder_append_uint(encoder_p, 0xbf72, 2);
        encoder_append_bool(encoder_p, src_p->value.c115);
        break;

    case oer_c_source_q_choice_c116_e:
        encoder_append_uint(encoder_p, 0xbf73, 2);
        encoder_append_bool(encoder_p, src_p->value.c116);
        break;

    case oer_c_source_q_choice_c117_e:
        encoder_append_uint(encoder_p, 0xbf74, 2);
        encoder_append_bool(encoder_p, src_p->value.c117);
        break;

    case oer_c_source_q_choice_c118_e:
        encoder_append_uint(encoder_p, 0xbf75, 2);
        encoder_append_bool(encoder_p, src_p->value.c118);
        break;

    case oer_c_source_q_choice_c119_e:
        encoder_append_uint(encoder_p, 0xbf76, 2);
        encoder_append_bool(encoder_p, src_p->value.c119);
        break;

    case oer_c_source_q_choice_c120_e:
        encoder_append_uint(encoder_p, 0xbf77, 2);
        encoder_append_bool(encoder_p, src_p->value.c120);
        break;

    case oer_c_source_q_choice_c121_e:
        encoder_append_uint(encoder_p, 0xbf78, 2);
        encoder_append_bool(encoder_p, src_p->value.c121);
        break;

    case oer_c_source_q_choice_c122_e:
        encoder_append_uint(encoder_p, 0xbf79, 2);
        encoder_append_bool(encoder_p, src_p->value.c122);
        break;

    case oer_c_source_q_choice_c123_e:
        encoder_append_uint(encoder_p, 0xbf7a, 2);
        encoder_append_bool(encoder_p, src_p->value.c123);
        break;

    case oer_c_source_q_choice_c124_e:
        encoder_append_uint(encoder_p, 0xbf7b, 2);
        encoder_append_bool(encoder_p, src_p->value.c124);
        break;

    case oer_c_source_q_choice_c125_e:
        encoder_append_uint(encoder_p, 0xbf7c, 2);
        encoder_append_bool(encoder_p, src_p->value.c125);
        break;

    case oer_c_source_q_choice_c126_e:
        encoder_append_uint(encoder_p, 0xbf7d, 2);
        encoder_append_bool(encoder_p, src_p->value.c126);
        break;

    case oer_c_source_q_choice_c127_e:
        encoder_append_uint(encoder_p, 0xbf7e, 2);
        encoder_append_bool(encoder_p, src_p->value.c127);
        break;

    case oer_c_source_q_choice_c128_e:
        encoder_append_uint(encoder_p, 0xbf7f, 2);
        encoder_append_bool(encoder_p, src_p->value.c128);
        break;

    case oer_c_source_q_choice_c129_e:
        encoder_append_uint(encoder_p, 0xbf8100, 3);
        encoder_append_bool(encoder_p, src_p->value.c129);
        break;

    case oer_c_source_q_choice_c130_e:
        encoder_append_uint(encoder_p, 0xbf8101, 3);
        encoder_append_bool(encoder_p, src_p->value.c130);
        break;

    case oer_c_source_q_choice_c131_e:
        encoder_append_uint(encoder_p, 0xbf8102, 3);
        encoder_append_bool(encoder_p, src_p->value.c131);
        break;

    case oer_c_source_q_choice_c132_e:
        encoder_append_uint(encoder_p, 0xbf8103, 3);
        encoder_append_bool(encoder_p, src_p->value.c132);
        break;

    case oer_c_source_q_choice_c133_e:
        encoder_append_uint(encoder_p, 0xbf8104, 3);
        encoder_append_bool(encoder_p, src_p->value.c133);
        break;

    case oer_c_source_q_choice_c134_e:
        encoder_append_uint(encoder_p, 0xbf8105, 3);
        encoder_append_bool(encoder_p, src_p->value.c134);
        break;

    case oer_c_source_q_choice_c135_e:
        encoder_append_uint(encoder_p, 0xbf8106, 3);
        encoder_append_bool(encoder_p, src_p->value.c135);
        break;

    case oer_c_source_q_choice_c136_e:
        encoder_append_uint(encoder_p, 0xbf8107, 3);
        encoder_append_bool(encoder_p, src_p->value.c136);
        break;

    case oer_c_source_q_choice_c137_e:
        encoder_append_uint(encoder_p, 0xbf8108, 3);
        encoder_append_bool(encoder_p, src_p->value.c137);
        break;

    case oer_c_source_q_choice_c138_e:
        encoder_append_uint(encoder_p, 0xbf8109, 3);
        encoder_append_bool(encoder_p, src_p->value.c138);
        break;

    case oer_c_source_q_choice_c139_e:
        encoder_append_uint(encoder_p, 0xbf810a, 3);
        encoder_append_bool(encoder_p, src_p->value.c139);
        break;

    case oer_c_source_q_choice_c140_e:
        encoder_append_uint(encoder_p, 0xbf810b, 3);
        encoder_append_bool(encoder_p, src_p->value.c140);
        break;

    case oer_c_source_q_choice_c141_e:
        encoder_append_uint(encoder_p, 0xbf810c, 3);
        encoder_append_bool(encoder_p, src_p->value.c141);
        break;

    case oer_c_source_q_choice_c142_e:
        encoder_append_uint(encoder_p, 0xbf810d, 3);
        encoder_append_bool(encoder_p, src_p->value.c142);
        break;

    case oer_c_source_q_choice_c143_e:
        encoder_append_uint(encoder_p, 0xbf810e, 3);
        encoder_append_bool(encoder_p, src_p->value.c143);
        break;

    case oer_c_source_q_choice_c144_e:
        encoder_append_uint(encoder_p, 0xbf810f, 3);
        encoder_append_bool(encoder_p, src_p->value.c144);
        break;

    case oer_c_source_q_choice_c145_e:
        encoder_append_uint(encoder_p, 0xbf8110, 3);
        encoder_append_bool(encoder_p, src_p->value.c145);
        break;

    case oer_c_source_q_choice_c146_e:
        encoder_append_uint(encoder_p, 0xbf8111, 3);
        encoder_append_bool(encoder_p, src_p->value.c146);
        break;

    case oer_c_source_q_choice_c147_e:
        encoder_append_uint(encoder_p, 0xbf8112, 3);
        encoder_append_bool(encoder_p, src_p->value.c147);
        break;

    case oer_c_source_q_choice_c148_e:
        encoder_append_uint(encoder_p, 0xbf8113, 3);
        encoder_append_bool(encoder_p, src_p->value.c148);
        break;

    case oer_c_source_q_choice_c149_e:
        encoder_append_uint(encoder_p, 0xbf8114, 3);
        encoder_append_bool(encoder_p, src_p->value.c149);
        break;

    case oer_c_source_q_choice_c150_e:
        encoder_append_uint(encoder_p, 0xbf8115, 3);
        encoder_append_bool(encoder_p, src_p->value.c150);
        break;

    case oer_c_source_q_choice_c151_e:
        encoder_append_uint(encoder_p, 0xbf8116, 3);
        encoder_append_bool(encoder_p, src_p->value.c151);
        break;

    case oer_c_source_q_choice_c152_e:
        encoder_append_uint(encoder_p, 0xbf8117, 3);
        encoder_append_bool(encoder_p, src_p->value.c152);
        break;

    case oer_c_source_q_choice_c153_e:
        encoder_append_uint(encoder_p, 0xbf8118, 3);
        encoder_append_bool(encoder_p, src_p->value.c153);
        break;

    case oer_c_source_q_choice_c154_e:
        encoder_append_uint(encoder_p, 0xbf8119, 3);
        encoder_append_bool(encoder_p, src_p->value.c154);
        break;

    case oer_c_source_q_choice_c155_e:
        encoder_append_uint(encoder_p, 0xbf811a, 3);
        encoder_append_bool(encoder_p, src_p->value.c155);
        break;

    case oer_c_source_q_choice_c156_e:
        encoder_append_uint(encoder_p, 0xbf811b, 3);
        encoder_append_bool(encoder_p, src_p->value.c156);
        break;

    case oer_c_source_q_choice_c157_e:
        encoder_append_uint(encoder_p, 0xbf811c, 3);
        encoder_append_bool(encoder_p, src_p->value.c157);
        break;

    case oer_c_source_q_choice_c158_e:
        encoder_append_uint(encoder_p, 0xbf811d, 3);
        encoder_append_bool(encoder_p, src_p->value.c158);
        break;

    case oer_c_source_q_choice_c159_e:
        encoder_append_uint(encoder_p, 0xbf811e, 3);
        encoder_append_bool(encoder_p, src_p->value.c159);
        break;

    case oer_c_source_q_choice_c160_e:
        encoder_append_uint(encoder_p, 0xbf811f, 3);
        encoder_append_bool(encoder_p, src_p->value.c160);
        break;

    case oer_c_source_q_choice_c161_e:
        encoder_append_uint(encoder_p, 0xbf8120, 3);
        encoder_append_bool(encoder_p, src_p->value.c161);
        break;

    case oer_c_source_q_choice_c162_e:
        encoder_append_uint(encoder_p, 0xbf8121, 3);
        encoder_append_bool(encoder_p, src_p->value.c162);
        break;

    case oer_c_source_q_choice_c163_e:
        encoder_append_uint(encoder_p, 0xbf8122, 3);
        encoder_append_bool(encoder_p, src_p->value.c163);
        break;

    case oer_c_source_q_choice_c164_e:
        encoder_append_uint(encoder_p, 0xbf8123, 3);
        encoder_append_bool(encoder_p, src_p->value.c164);
        break;

    case oer_c_source_q_choice_c165_e:
        encoder_append_uint(encoder_p, 0xbf8124, 3);
        encoder_append_bool(encoder_p, src_p->value.c165);
        break;

    case oer_c_source_q_choice_c166_e:
        encoder_append_uint(encoder_p, 0xbf8125, 3);
        encoder_append_bool(encoder_p, src_p->value.c166);
        break;

    case oer_c_source_q_choice_c167_e:
        encoder_append_uint(encoder_p, 0xbf8126, 3);
        encoder_append_bool(encoder_p, src_p->value.c167);
        break;

    case oer_c_source_q_choice_c168_e:
        encoder_append_uint(encoder_p, 0xbf8127, 3);
        encoder_append_bool(encoder_p, src_p->value.c168);
        break;

    case oer_c_source_q_choice_c169_e:
        encoder_append_uint(encoder_p, 0xbf8128, 3);
        encoder_append_bool(encoder_p, src_p->value.c169);
        break;

    case oer_c_source_q_choice_c170_e:
        encoder_append_uint(encoder_p, 0xbf8129, 3);
        encoder_append_bool(encoder_p, src_p->value.c170);
        break;

    case oer_c_source_q_choice_c171_e:
        encoder_append_uint(encoder_p, 0xbf812a, 3);
        encoder_append_bool(encoder_p, src_p->value.c171);
        break;

    case oer_c_source_q_choice_c172_e:
        encoder_append_uint(encoder_p, 0xbf812b, 3);
        encoder_append_bool(encoder_p, src_p->value.c172);
        break;

    case oer_c_source_q_choice_c173_e:
        encoder_append_uint(encoder_p, 0xbf812c, 3);
        encoder_append_bool(encoder_p, src_p->value.c173);
        break;

    case oer_c_source_q_choice_c174_e:
        encoder_append_uint(encoder_p, 0xbf812d, 3);
        encoder_append_bool(encoder_p, src_p->value.c174);
        break;

    case oer_c_source_q_choice_c175_e:
        encoder_append_uint(encoder_p, 0xbf812e, 3);
        encoder_append_bool(encoder_p, src_p->value.c175);
        break;

    case oer_c_source_q_choice_c176_e:
        encoder_append_uint(encoder_p, 0xbf812f, 3);
        encoder_append_bool(encoder_p, src_p->value.c176);
        break;

    case oer_c_source_q_choice_c177_e:
        encoder_append_uint(encoder_p, 0xbf8130, 3);
        encoder_append_bool(encoder_p, src_p->value.c177);
        break;

    case oer_c_source_q_choice_c178_e:
        encoder_append_uint(encoder_p, 0xbf8131, 3);
        encoder_append_bool(encoder_p, src_p->value.c178);
        break;

    case oer_c_source_q_choice_c179_e:
        encoder_append_uint(encoder_p, 0xbf8132, 3);
        encoder_append_bool(encoder_p, src_p->value.c179);
        break;

    case oer_c_source_q_choice_c180_e:
        encoder_append_uint(encoder_p, 0xbf8133, 3);
        encoder_append_bool(encoder_p, src_p->value.c180);
        break;

    case oer_c_source_q_choice_c181_e:
        encoder_append_uint(encoder_p, 0xbf8134, 3);
        encoder_append_bool(encoder_p, src_p->value.c181);
        break;

    case oer_c_source_q_choice_c182_e:
        encoder_append_uint(encoder_p, 0xbf8135, 3);
        encoder_append_bool(encoder_p, src_p->value.c182);
        break;

    case oer_c_source_q_choice_c183_e:
        encoder_append_uint(encoder_p, 0xbf8136, 3);
        encoder_append_bool(encoder_p, src_p->value.c183);
        break;

    case oer_c_source_q_choice_c184_e:
        encoder_append_uint(encoder_p, 0xbf8137, 3);
        encoder_append_bool(encoder_p, src_p->value.c184);
        break;

    case oer_c_source_q_choice_c185_e:
        encoder_append_uint(encoder_p, 0xbf8138, 3);
        encoder_append_bool(encoder_p, src_p->value.c185);
        break;

    case oer_c_source_q_choice_c186_e:
        encoder_append_uint(encoder_p, 0xbf8139, 3);
        encoder_append_bool(encoder_p, src_p->value.c186);
        break;

    case oer_c_source_q_choice_c187_e:
        encoder_append_uint(encoder_p, 0xbf813a, 3);
        encoder_append_bool(encoder_p, src_p->value.c187);
        break;

    case oer_c_source_q_choice_c188_e:
        encoder_append_uint(encoder_p, 0xbf813b, 3);
        encoder_append_bool(encoder_p, src_p->value.c188);
        break;

    case oer_c_source_q_choice_c189_e:
        encoder_append_uint(encoder_p, 0xbf813c, 3);
        encoder_append_bool(encoder_p, src_p->value.c189);
        break;

    case oer_c_source_q_choice_c190_e:
        encoder_append_uint(encoder_p, 0xbf813d, 3);
        encoder_append_bool(encoder_p, src_p->value.c190);
        break;

    case oer_c_source_q_choice_c191_e:
        encoder_append_uint(encoder_p, 0xbf813e, 3);
        encoder_append_bool(encoder_p, src_p->value.c191);
        break;

    case oer_c_source_q_choice_c192_e:
        encoder_append_uint(encoder_p, 0xbf813f, 3);
        encoder_append_bool(encoder_p, src_p->value.c192);
        break;

    case oer_c_source_q_choice_c193_e:
        encoder_append_uint(encoder_p, 0xbf8140, 3);
        encoder_append_bool(encoder_p, src_p->value.c193);
        break;

    case oer_c_source_q_choice_c194_e:
        encoder_append_uint(encoder_p, 0xbf8141, 3);
        encoder_append_bool(encoder_p, src_p->value.c194);
        break;

    case oer_c_source_q_choice_c195_e:
        encoder_append_uint(encoder_p, 0xbf8142, 3);
        encoder_append_bool(encoder_p, src_p->value.c195);
        break;

    case oer_c_source_q_choice_c196_e:
        encoder_append_uint(encoder_p, 0xbf8143, 3);
        encoder_append_bool(encoder_p, src_p->value.c196);
        break;

    case oer_c_source_q_choice_c197_e:
        encoder_append_uint(encoder_p, 0xbf8144, 3);
        encoder_append_bool(encoder_p, src_p->value.c197);
        break;

    case oer_c_source_q_choice_c198_e:
        encoder_append_uint(encoder_p, 0xbf8145, 3);
        encoder_append_bool(encoder_p, src_p->value.c198);
        break;

    case oer_c_source_q_choice_c199_e:
        encoder_append_uint(encoder_p, 0xbf8146, 3);
        encoder_append_bool(encoder_p, src_p->value.c199);
        break;

    case oer_c_source_q_choice_c200_e:
        encoder_append_uint(encoder_p, 0xbf8147, 3);
        encoder_append_bool(encoder_p, src_p->value.c200);
        break;

    case oer_c_source_q_choice_c201_e:
        encoder_append_uint(encoder_p, 0xbf8148, 3);
        encoder_append_bool(encoder_p, src_p->value.c201);
        break;

    case oer_c_source_q_choice_c202_e:
        encoder_append_uint(encoder_p, 0xbf8149, 3);
        encoder_append_bool(encoder_p, src_p->value.c202);
        break;

    case oer_c_source_q_choice_c203_e:
        encoder_append_uint(encoder_p, 0xbf814a, 3);
        encoder_append_bool(encoder_p, src_p->value.c203);
        break;

    case oer_c_source_q_choice_c204_e:
        encoder_append_uint(encoder_p, 0xbf814b, 3);
        encoder_append_bool(encoder_p, src_p->value.c204);
        break;

    case oer_c_source_q_choice_c205_e:
        encoder_append_uint(encoder_p, 0xbf814c, 3);
        encoder_append_bool(encoder_p, src_p->value.c205);
        break;

    case oer_c_source_q_choice_c206_e:
        encoder_append_uint(encoder_p, 0xbf814d, 3);
        encoder_append_bool(encoder_p, src_p->value.c206);
        break;

    case oer_c_source_q_choice_c207_e:
        encoder_append_uint(encoder_p, 0xbf814e, 3);
        encoder_append_bool(encoder_p, src_p->value.c207);
        break;

    case oer_c_source_q_choice_c208_e:
        encoder_append_uint(encoder_p, 0xbf814f, 3);
        encoder_append_bool(encoder_p, src_p->value.c208);
        break;

    case oer_c_source_q_choice_c209_e:
        encoder_append_uint(encoder_p, 0xbf8150, 3);
        encoder_append_bool(encoder_p, src_p->value.c209);
        break;

    case oer_c_source_q_choice_c210_e:
        encoder_append_uint(encoder_p, 0xbf8151, 3);
        encoder_append_bool(encoder_p, src_p->value.c210);
        break;

    case oer_c_source_q_choice_c211_e:
        encoder_append_uint(encoder_p, 0xbf8152, 3);
        encoder_append_bool(encoder_p, src_p->value.c211);
        break;

    case oer_c_source_q_choice_c212_e:
        encoder_append_uint(encoder_p, 0xbf8153, 3);
        encoder_append_bool(encoder_p, src_p->value.c212);
        break;

    case oer_c_source_q_choice_c213_e:
        encoder_append_uint(encoder_p, 0xbf8154, 3);
        encoder_append_bool(encoder_p, src_p->value.c213);
        break;

    case oer_c_source_q_choice_c214_e:
        encoder_append_uint(encoder_p, 0xbf8155, 3);
        encoder_append_bool(encoder_p, src_p->value.c214);
        break;

    case oer_c_source_q_choice_c215_e:
        encoder_append_uint(encoder_p, 0xbf8156, 3);
        encoder_append_bool(encoder_p, src_p->value.c215);
        break;

    case oer_c_source_q_choice_c216_e:
        encoder_append_uint(encoder_p, 0xbf8157, 3);
        encoder_append_bool(encoder_p, src_p->value.c216);
        break;

    case oer_c_source_q_choice_c217_e:
        encoder_append_uint(encoder_p, 0xbf8158, 3);
        encoder_append_bool(encoder_p, src_p->value.c217);
        break;

    case oer_c_source_q_choice_c218_e:
        encoder_append_uint(encoder_p, 0xbf8159, 3);
        encoder_append_bool(encoder_p, src_p->value.c218);
        break;

    case oer_c_source_q_choice_c219_e:
        encoder_append_uint(encoder_p, 0xbf815a, 3);
        encoder_append_bool(encoder_p, src_p->value.c219);
        break;

    case oer_c_source_q_choice_c220_e:
        encoder_append_uint(encoder_p, 0xbf815b, 3);
        encoder_append_bool(encoder_p, src_p->value.c220);
        break;

    case oer_c_source_q_choice_c221_e:
        encoder_append_uint(encoder_p, 0xbf815c, 3);
        encoder_append_bool(encoder_p, src_p->value.c221);
        break;

    case oer_c_source_q_choice_c222_e:
        encoder_append_uint(encoder_p, 0xbf815d, 3);
        encoder_append_bool(encoder_p, src_p->value.c222);
        break;

    case oer_c_source_q_choice_c223_e:
        encoder_append_uint(encoder_p, 0xbf815e, 3);
        encoder_append_bool(encoder_p, src_p->value.c223);
        break;

    case oer_c_source_q_choice_c224_e:
        encoder_append_uint(encoder_p, 0xbf815f, 3);
        encoder_append_bool(encoder_p, src_p->value.c224);
        break;

    case oer_c_source_q_choice_c225_e:
        encoder_append_uint(encoder_p, 0xbf8160, 3);
        encoder_append_bool(encoder_p, src_p->value.c225);
        break;

    case oer_c_source_q_choice_c226_e:
        encoder_append_uint(encoder_p, 0xbf8161, 3);
        encoder_append_bool(encoder_p, src_p->value.c226);
        break;

    case oer_c_source_q_choice_c227_e:
        encoder_append_uint(encoder_p, 0xbf8162, 3);
        encoder_append_bool(encoder_p, src_p->value.c227);
        break;

    case oer_c_source_q_choice_c228_e:
        encoder_append_uint(encoder_p, 0xbf8163, 3);
        encoder_append_bool(encoder_p, src_p->value.c228);
        break;

    case oer_c_source_q_choice_c229_e:
        encoder_append_uint(encoder_p, 0xbf8164, 3);
        encoder_append_bool(encoder_p, src_p->value.c229);
        break;

    case oer_c_source_q_choice_c230_e:
        encoder_append_uint(encoder_p, 0xbf8165, 3);
        encoder_append_bool(encoder_p, src_p->value.c230);
        break;

    case oer_c_source_q_choice_c231_e:
        encoder_append_uint(encoder_p, 0xbf8166, 3);
        encoder_append_bool(encoder_p, src_p->value.c231);
        break;

    case oer_c_source_q_choice_c232_e:
        encoder_append_uint(encoder_p, 0xbf8167, 3);
        encoder_append_bool(encoder_p, src_p->value.c232);
        break;

    case oer_c_source_q_choice_c233_e:
        encoder_append_uint(encoder_p, 0xbf8168, 3);
        encoder_append_bool(encoder_p, src_p->value.c233);
        break;

    case oer_c_source_q_choice_c234_e:
        encoder_append_uint(encoder_p, 0xbf8169, 3);
        encoder_append_bool(encoder_p, src_p->value.c234);
        break;

    case oer_c_source_q_choice_c235_e:
        encoder_append_uint(encoder_p, 0xbf816a, 3);
        encoder_append_bool(encoder_p, src_p->value.c235);
        break;

    case oer_c_source_q_choice_c236_e:
        encoder_append_uint(encoder_p, 0xbf816b, 3);
        encoder_append_bool(encoder_p, src_p->value.c236);
        break;

    case oer_c_source_q_choice_c237_e:
        encoder_append_uint(encoder_p, 0xbf816c, 3);
        encoder_append_bool(encoder_p, src_p->value.c237);
        break;

    case oer_c_source_q_choice_c238_e:
        encoder_append_uint(encoder_p, 0xbf816d, 3);
        encoder_append_bool(encoder_p, src_p->value.c238);
        break;

    case oer_c_source_q_choice_c239_e:
        encoder_append_uint(encoder_p, 0xbf816e, 3);
        encoder_append_bool(encoder_p, src_p->value.c239);
        break;

    case oer_c_source_q_choice_c240_e:
        encoder_append_uint(encoder_p, 0xbf816f, 3);
        encoder_append_bool(encoder_p, src_p->value.c240);
        break;

    case oer_c_source_q_choice_c241_e:
        encoder_append_uint(encoder_p, 0xbf8170, 3);
        encoder_append_bool(encoder_p, src_p->value.c241);
        break;

    case oer_c_source_q_choice_c242_e:
        encoder_append_uint(encoder_p, 0xbf8171, 3);
        encoder_append_bool(encoder_p, src_p->value.c242);
        break;

    case oer_c_source_q_choice_c243_e:
        encoder_append_uint(encoder_p, 0xbf8172, 3);
        encoder_append_bool(encoder_p, src_p->value.c243);
        break;

    case oer_c_source_q_choice_c244_e:
        encoder_append_uint(encoder_p, 0xbf8173, 3);
        encoder_append_bool(encoder_p, src_p->value.c244);
        break;

    case oer_c_source_q_choice_c245_e:
        encoder_append_uint(encoder_p, 0xbf8174, 3);
        encoder_append_bool(encoder_p, src_p->value.c245);
        break;

    case oer_c_source_q_choice_c246_e:
        encoder_append_uint(encoder_p, 0xbf8175, 3);
        encoder_append_bool(encoder_p, src_p->value.c246);
        break;

    case oer_c_source_q_choice_c247_e:
        encoder_append_uint(encoder_p, 0xbf8176, 3);
        encoder_append_bool(encoder_p, src_p->value.c247);
        break;

    case oer_c_source_q_choice_c248_e:
        encoder_append_uint(encoder_p, 0xbf8177, 3);
        encoder_append_bool(encoder_p, src_p->value.c248);
        break;

    case oer_c_source_q_choice_c249_e:
        encoder_append_uint(encoder_p, 0xbf8178, 3);
        encoder_append_bool(encoder_p, src_p->value.c249);
        break;

    case oer_c_source_q_choice_c250_e:
        encoder_append_uint(encoder_p, 0xbf8179, 3);
        encoder_append_bool(encoder_p, src_p->value.c250);
        break;

    case oer_c_source_q_choice_c251_e:
        encoder_append_uint(encoder_p, 0xbf817a, 3);
        encoder_append_bool(encoder_p, src_p->value.c251);
        break;

    case oer_c_source_q_choice_c252_e:
        encoder_append_uint(encoder_p, 0xbf817b, 3);
        encoder_append_bool(encoder_p, src_p->value.c252);
        break;

    case oer_c_source_q_choice_c253_e:
        encoder_append_uint(encoder_p, 0xbf817c, 3);
        encoder_append_bool(encoder_p, src_p->value.c253);
        break;

    case oer_c_source_q_choice_c254_e:
        encoder_append_uint(encoder_p, 0xbf817d, 3);
        encoder_append_bool(encoder_p, src_p->value.c254);
        break;

    case oer_c_source_q_choice_c255_e:
        encoder_append_uint(encoder_p, 0xbf817e, 3);
        encoder_append_bool(encoder_p, src_p->value.c255);
        break;

    case oer_c_source_q_choice_c256_e:
        encoder_append_uint(encoder_p, 0xbf817f, 3);
        encoder_append_bool(encoder_p, src_p->value.c256);
        break;

    case oer_c_source_q_choice_c257_e:
        encoder_append_uint(encoder_p, 0xbf8200, 3);
        encoder_append_bool(encoder_p, src_p->value.c257);
        break;

    default:
        encoder_abort(encoder_p, EBADCHOICE);
        break;
    }
}

static void oer_c_source_q_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_q_t *dst_p)
{
    uint32_t tag;

    tag = decoder_read_tag(decoder_p);

    switch (tag) {

    case 0x80:
        dst_p->choice = oer_c_source_q_choice_c001_e;
        dst_p->value.c001 = decoder_read_bool(decoder_p);
        break;

    case 0x81:
        dst_p->choice = oer_c_source_q_choice_c002_e;
        dst_p->value.c002 = decoder_read_bool(decoder_p);
        break;

    case 0x82:
        dst_p->choice = oer_c_source_q_choice_c003_e;
        dst_p->value.c003 = decoder_read_bool(decoder_p);
        break;

    case 0x83:
        dst_p->choice = oer_c_source_q_choice_c004_e;
        dst_p->value.c004 = decoder_read_bool(decoder_p);
        break;

    case 0x84:
        dst_p->choice = oer_c_source_q_choice_c005_e;
        dst_p->value.c005 = decoder_read_bool(decoder_p);
        break;

    case 0x85:
        dst_p->choice = oer_c_source_q_choice_c006_e;
        dst_p->value.c006 = decoder_read_bool(decoder_p);
        break;

    case 0x86:
        dst_p->choice = oer_c_source_q_choice_c007_e;
        dst_p->value.c007 = decoder_read_bool(decoder_p);
        break;

    case 0x87:
        dst_p->choice = oer_c_source_q_choice_c008_e;
        dst_p->value.c008 = decoder_read_bool(decoder_p);
        break;

    case 0x88:
        dst_p->choice = oer_c_source_q_choice_c009_e;
        dst_p->value.c009 = decoder_read_bool(decoder_p);
        break;

    case 0x89:
        dst_p->choice = oer_c_source_q_choice_c010_e;
        dst_p->value.c010 = decoder_read_bool(decoder_p);
        break;

    case 0x8a:
        dst_p->choice = oer_c_source_q_choice_c011_e;
        dst_p->value.c011 = decoder_read_bool(decoder_p);
        break;

    case 0x8b:
        dst_p->choice = oer_c_source_q_choice_c012_e;
        dst_p->value.c012 = decoder_read_bool(decoder_p);
        break;

    case 0x8c:
        dst_p->choice = oer_c_source_q_choice_c013_e;
        dst_p->value.c013 = decoder_read_bool(decoder_p);
        break;

    case 0x8d:
        dst_p->choice = oer_c_source_q_choice_c014_e;
        dst_p->value.c014 = decoder_read_bool(decoder_p);
        break;

    case 0x8e:
        dst_p->choice = oer_c_source_q_choice_c015_e;
        dst_p->value.c015 = decoder_read_bool(decoder_p);
        break;

    case 0x8f:
        dst_p->choice = oer_c_source_q_choice_c016_e;
        dst_p->value.c016 = decoder_read_bool(decoder_p);
        break;

    case 0x90:
        dst_p->choice = oer_c_source_q_choice_c017_e;
        dst_p->value.c017 = decoder_read_bool(decoder_p);
        break;

    case 0x91:
        dst_p->choice = oer_c_source_q_choice_c018_e;
        dst_p->value.c018 = decoder_read_bool(decoder_p);
        break;

    case 0x92:
        dst_p->choice = oer_c_source_q_choice_c019_e;
        dst_p->value.c019 = decoder_read_bool(decoder_p);
        break;

    case 0x93:
        dst_p->choice = oer_c_source_q_choice_c020_e;
        dst_p->value.c020 = decoder_read_bool(decoder_p);
        break;

    case 0x94:
        dst_p->choice = oer_c_source_q_choice_c021_e;
        dst_p->value.c021 = decoder_read_bool(decoder_p);
        break;

    case 0x95:
        dst_p->choice = oer_c_source_q_choice_c022_e;
        dst_p->value.c022 = decoder_read_bool(decoder_p);
        break;

    case 0x96:
        dst_p->choice = oer_c_source_q_choice_c023_e;
        dst_p->value.c023 = decoder_read_bool(decoder_p);
        break;

    case 0x97:
        dst_p->choice = oer_c_source_q_choice_c024_e;
        dst_p->value.c024 = decoder_read_bool(decoder_p);
        break;

    case 0x98:
        dst_p->choice = oer_c_source_q_choice_c025_e;
        dst_p->value.c025 = decoder_read_bool(decoder_p);
        break;

    case 0x99:
        dst_p->choice = oer_c_source_q_choice_c026_e;
        dst_p->value.c026 = decoder_read_bool(decoder_p);
        break;

    case 0x9a:
        dst_p->choice = oer_c_source_q_choice_c027_e;
        dst_p->value.c027 = decoder_read_bool(decoder_p);
        break;

    case 0x9b:
        dst_p->choice = oer_c_source_q_choice_c028_e;
        dst_p->value.c028 = decoder_read_bool(decoder_p);
        break;

    case 0x9c:
        dst_p->choice = oer_c_source_q_choice_c029_e;
        dst_p->value.c029 = decoder_read_bool(decoder_p);
        break;

    case 0x9d:
        dst_p->choice = oer_c_source_q_choice_c030_e;
        dst_p->value.c030 = decoder_read_bool(decoder_p);
        break;

    case 0x9e:
        dst_p->choice = oer_c_source_q_choice_c031_e;
        dst_p->value.c031 = decoder_read_bool(decoder_p);
        break;

    case 0x9f:
        dst_p->choice = oer_c_source_q_choice_c032_e;
        dst_p->value.c032 = decoder_read_bool(decoder_p);
        break;

    case 0xa0:
        dst_p->choice = oer_c_source_q_choice_c033_e;
        dst_p->value.c033 = decoder_read_bool(decoder_p);
        break;

    case 0xa1:
        dst_p->choice = oer_c_source_q_choice_c034_e;
        dst_p->value.c034 = decoder_read_bool(decoder_p);
        break;

    case 0xa2:
        dst_p->choice = oer_c_source_q_choice_c035_e;
        dst_p->value.c035 = decoder_read_bool(decoder_p);
        break;

    case 0xa3:
        dst_p->choice = oer_c_source_q_choice_c036_e;
        dst_p->value.c036 = decoder_read_bool(decoder_p);
        break;

    case 0xa4:
        dst_p->choice = oer_c_source_q_choice_c037_e;
        dst_p->value.c037 = decoder_read_bool(decoder_p);
        break;

    case 0xa5:
        dst_p->choice = oer_c_source_q_choice_c038_e;
        dst_p->value.c038 = decoder_read_bool(decoder_p);
        break;

    case 0xa6:
        dst_p->choice = oer_c_source_q_choice_c039_e;
        dst_p->value.c039 = decoder_read_bool(decoder_p);
        break;

    case 0xa7:
        dst_p->choice = oer_c_source_q_choice_c040_e;
        dst_p->value.c040 = decoder_read_bool(decoder_p);
        break;

    case 0xa8:
        dst_p->choice = oer_c_source_q_choice_c041_e;
        dst_p->value.c041 = decoder_read_bool(decoder_p);
        break;

    case 0xa9:
        dst_p->choice = oer_c_source_q_choice_c042_e;
        dst_p->value.c042 = decoder_read_bool(decoder_p);
        break;

    case 0xaa:
        dst_p->choice = oer_c_source_q_choice_c043_e;
        dst_p->value.c043 = decoder_read_bool(decoder_p);
        break;

    case 0xab:
        dst_p->choice = oer_c_source_q_choice_c044_e;
        dst_p->value.c044 = decoder_read_bool(decoder_p);
        break;

    case 0xac:
        dst_p->choice = oer_c_source_q_choice_c045_e;
        dst_p->value.c045 = decoder_read_bool(decoder_p);
        break;

    case 0xad:
        dst_p->choice = oer_c_source_q_choice_c046_e;
        dst_p->value.c046 = decoder_read_bool(decoder_p);
        break;

    case 0xae:
        dst_p->choice = oer_c_source_q_choice_c047_e;
        dst_p->value.c047 = decoder_read_bool(decoder_p);
        break;

    case 0xaf:
        dst_p->choice = oer_c_source_q_choice_c048_e;
        dst_p->value.c048 = decoder_read_bool(decoder_p);
        break;

    case 0xb0:
        dst_p->choice = oer_c_source_q_choice_c049_e;
        dst_p->value.c049 = decoder_read_bool(decoder_p);
        break;

    case 0xb1:
        dst_p->choice = oer_c_source_q_choice_c050_e;
        dst_p->value.c050 = decoder_read_bool(decoder_p);
        break;

    case 0xb2:
        dst_p->choice = oer_c_source_q_choice_c051_e;
        dst_p->value.c051 = decoder_read_bool(decoder_p);
        break;

    case 0xb3:
        dst_p->choice = oer_c_source_q_choice_c052_e;
        dst_p->value.c052 = decoder_read_bool(decoder_p);
        break;

    case 0xb4:
        dst_p->choice = oer_c_source_q_choice_c053_e;
        dst_p->value.c053 = decoder_read_bool(decoder_p);
        break;

    case 0xb5:
        dst_p->choice = oer_c_source_q_choice_c054_e;
        dst_p->value.c054 = decoder_read_bool(decoder_p);
        break;

    case 0xb6:
        dst_p->choice = oer_c_source_q_choice_c055_e;
        dst_p->value.c055 = decoder_read_bool(decoder_p);
        break;

    case 0xb7:
        dst_p->choice = oer_c_source_q_choice_c056_e;
        dst_p->value.c056 = decoder_read_bool(decoder_p);
        break;

    case 0xb8:
        dst_p->choice = oer_c_source_q_choice_c057_e;
        dst_p->value.c057 = decoder_read_bool(decoder_p);
        break;

    case 0xb9:
        dst_p->choice = oer_c_source_q_choice_c058_e;
        dst_p->value.c058 = decoder_read_bool(decoder_p);
        break;

    case 0xba:
        dst_p->choice = oer_c_source_q_choice_c059_e;
        dst_p->value.c059 = decoder_read_bool(decoder_p);
        break;

    case 0xbb:
        dst_p->choice = oer_c_source_q_choice_c060_e;
        dst_p->value.c060 = decoder_read_bool(decoder_p);
        break;

    case 0xbc:
        dst_p->choice = oer_c_source_q_choice_c061_e;
        dst_p->value.c061 = decoder_read_bool(decoder_p);
        break;

    case 0xbd:
        dst_p->choice = oer_c_source_q_choice_c062_e;
        dst_p->value.c062 = decoder_read_bool(decoder_p);
        break;

    case 0xbe:
        dst_p->choice = oer_c_source_q_choice_c063_e;
        dst_p->value.c063 = decoder_read_bool(decoder_p);
        break;

    case 0xbf3f:
        dst_p->choice = oer_c_source_q_choice_c064_e;
        dst_p->value.c064 = decoder_read_bool(decoder_p);
        break;

    case 0xbf40:
        dst_p->choice = oer_c_source_q_choice_c065_e;
        dst_p->value.c065 = decoder_read_bool(decoder_p);
        break;

    case 0xbf41:
        dst_p->choice = oer_c_source_q_choice_c066_e;
        dst_p->value.c066 = decoder_read_bool(decoder_p);
        break;

    case 0xbf42:
        dst_p->choice = oer_c_source_q_choice_c067_e;
        dst_p->value.c067 = decoder_read_bool(decoder_p);
        break;

    case 0xbf43:
        dst_p->choice = oer_c_source_q_choice_c068_e;
        dst_p->value.c068 = decoder_read_bool(decoder_p);
        break;

    case 0xbf44:
        dst_p->choice = oer_c_source_q_choice_c069_e;
        dst_p->value.c069 = decoder_read_bool(decoder_p);
        break;

    case 0xbf45:
        dst_p->choice = oer_c_source_q_choice_c070_e;
        dst_p->value.c070 = decoder_read_bool(decoder_p);
        break;

    case 0xbf46:
        dst_p->choice = oer_c_source_q_choice_c071_e;
        dst_p->value.c071 = decoder_read_bool(decoder_p);
        break;

    case 0xbf47:
        dst_p->choice = oer_c_source_q_choice_c072_e;
        dst_p->value.c072 = decoder_read_bool(decoder_p);
        break;

    case 0xbf48:
        dst_p->choice = oer_c_source_q_choice_c073_e;
        dst_p->value.c073 = decoder_read_bool(decoder_p);
        break;

    case 0xbf49:
        dst_p->choice = oer_c_source_q_choice_c074_e;
        dst_p->value.c074 = decoder_read_bool(decoder_p);
        break;

    case 0xbf4a:
        dst_p->choice = oer_c_source_q_choice_c075_e;
        dst_p->value.c075 = decoder_read_bool(decoder_p);
        break;

    case 0xbf4b:
        dst_p->choice = oer_c_source_q_choice_c076_e;
        dst_p->value.c076 = decoder_read_bool(decoder_p);
        break;

    case 0xbf4c:
        dst_p->choice = oer_c_source_q_choice_c077_e;
        dst_p->value.c077 = decoder_read_bool(decoder_p);
        break;

    case 0xbf4d:
        dst_p->choice = oer_c_source_q_choice_c078_e;
        dst_p->value.c078 = decoder_read_bool(decoder_p);
        break;

    case 0xbf4e:
        dst_p->choice = oer_c_source_q_choice_c079_e;
        dst_p->value.c079 = decoder_read_bool(decoder_p);
        break;

    case 0xbf4f:
        dst_p->choice = oer_c_source_q_choice_c080_e;
        dst_p->value.c080 = decoder_read_bool(decoder_p);
        break;

    case 0xbf50:
        dst_p->choice = oer_c_source_q_choice_c081_e;
        dst_p->value.c081 = decoder_read_bool(decoder_p);
        break;

    case 0xbf51:
        dst_p->choice = oer_c_source_q_choice_c082_e;
        dst_p->value.c082 = decoder_read_bool(decoder_p);
        break;

    case 0xbf52:
        dst_p->choice = oer_c_source_q_choice_c083_e;
        dst_p->value.c083 = decoder_read_bool(decoder_p);
        break;

    case 0xbf53:
        dst_p->choice = oer_c_source_q_choice_c084_e;
        dst_p->value.c084 = decoder_read_bool(decoder_p);
        break;

    case 0xbf54:
        dst_p->choice = oer_c_source_q_choice_c085_e;
        dst_p->value.c085 = decoder_read_bool(decoder_p);
        break;

    case 0xbf55:
        dst_p->choice = oer_c_source_q_choice_c086_e;
        dst_p->value.c086 = decoder_read_bool(decoder_p);
        break;

    case 0xbf56:
        dst_p->choice = oer_c_source_q_choice_c087_e;
        dst_p->value.c087 = decoder_read_bool(decoder_p);
        break;

    case 0xbf57:
        dst_p->choice = oer_c_source_q_choice_c088_e;
        dst_p->value.c088 = decoder_read_bool(decoder_p);
        break;

    case 0xbf58:
        dst_p->choice = oer_c_source_q_choice_c089_e;
        dst_p->value.c089 = decoder_read_bool(decoder_p);
        break;

    case 0xbf59:
        dst_p->choice = oer_c_source_q_choice_c090_e;
        dst_p->value.c090 = decoder_read_bool(decoder_p);
        break;

    case 0xbf5a:
        dst_p->choice = oer_c_source_q_choice_c091_e;
        dst_p->value.c091 = decoder_read_bool(decoder_p);
        break;

    case 0xbf5b:
        dst_p->choice = oer_c_source_q_choice_c092_e;
        dst_p->value.c092 = decoder_read_bool(decoder_p);
        break;

    case 0xbf5c:
        dst_p->choice = oer_c_source_q_choice_c093_e;
        dst_p->value.c093 = decoder_read_bool(decoder_p);
        break;

    case 0xbf5d:
        dst_p->choice = oer_c_source_q_choice_c094_e;
        dst_p->value.c094 = decoder_read_bool(decoder_p);
        break;

    case 0xbf5e:
        dst_p->choice = oer_c_source_q_choice_c095_e;
        dst_p->value.c095 = decoder_read_bool(decoder_p);
        break;

    case 0xbf5f:
        dst_p->choice = oer_c_source_q_choice_c096_e;
        dst_p->value.c096 = decoder_read_bool(decoder_p);
        break;

    case 0xbf60:
        dst_p->choice = oer_c_source_q_choice_c097_e;
        dst_p->value.c097 = decoder_read_bool(decoder_p);
        break;

    case 0xbf61:
        dst_p->choice = oer_c_source_q_choice_c098_e;
        dst_p->value.c098 = decoder_read_bool(decoder_p);
        break;

    case 0xbf62:
        dst_p->choice = oer_c_source_q_choice_c099_e;
        dst_p->value.c099 = decoder_read_bool(decoder_p);
        break;

    case 0xbf63:
        dst_p->choice = oer_c_source_q_choice_c100_e;
        dst_p->value.c100 = decoder_read_bool(decoder_p);
        break;

    case 0xbf64:
        dst_p->choice = oer_c_source_q_choice_c101_e;
        dst_p->value.c101 = decoder_read_bool(decoder_p);
        break;

    case 0xbf65:
        dst_p->choice = oer_c_source_q_choice_c102_e;
        dst_p->value.c102 = decoder_read_bool(decoder_p);
        break;

    case 0xbf66:
        dst_p->choice = oer_c_source_q_choice_c103_e;
        dst_p->value.c103 = decoder_read_bool(decoder_p);
        break;

    case 0xbf67:
        dst_p->choice = oer_c_source_q_choice_c104_e;
        dst_p->value.c104 = decoder_read_bool(decoder_p);
        break;

    case 0xbf68:
        dst_p->choice = oer_c_source_q_choice_c105_e;
        dst_p->value.c105 = decoder_read_bool(decoder_p);
        break;

    case 0xbf69:
        dst_p->choice = oer_c_source_q_choice_c106_e;
        dst_p->value.c106 = decoder_read_bool(decoder_p);
        break;

    case 0xbf6a:
        dst_p->choice = oer_c_source_q_choice_c107_e;
        dst_p->value.c107 = decoder_read_bool(decoder_p);
        break;

    case 0xbf6b:
        dst_p->choice = oer_c_source_q_choice_c108_e;
        dst_p->value.c108 = decoder_read_bool(decoder_p);
        break;

    case 0xbf6c:
        dst_p->choice = oer_c_source_q_choice_c109_e;
        dst_p->value.c109 = decoder_read_bool(decoder_p);
        break;

    case 0xbf6d:
        dst_p->choice = oer_c_source_q_choice_c110_e;
        dst_p->value.c110 = decoder_read_bool(decoder_p);
        break;

    case 0xbf6e:
        dst_p->choice = oer_c_source_q_choice_c111_e;
        dst_p->value.c111 = decoder_read_bool(decoder_p);
        break;

    case 0xbf6f:
        dst_p->choice = oer_c_source_q_choice_c112_e;
        dst_p->value.c112 = decoder_read_bool(decoder_p);
        break;

    case 0xbf70:
        dst_p->choice = oer_c_source_q_choice_c113_e;
        dst_p->value.c113 = decoder_read_bool(decoder_p);
        break;

    case 0xbf71:
        dst_p->choice = oer_c_source_q_choice_c114_e;
        dst_p->value.c114 = decoder_read_bool(decoder_p);
        break;

    case 0xbf72:
        dst_p->choice = oer_c_source_q_choice_c115_e;
        dst_p->value.c115 = decoder_read_bool(decoder_p);
        break;

    case 0xbf73:
        dst_p->choice = oer_c_source_q_choice_c116_e;
        dst_p->value.c116 = decoder_read_bool(decoder_p);
        break;

    case 0xbf74:
        dst_p->choice = oer_c_source_q_choice_c117_e;
        dst_p->value.c117 = decoder_read_bool(decoder_p);
        break;

    case 0xbf75:
        dst_p->choice = oer_c_source_q_choice_c118_e;
        dst_p->value.c118 = decoder_read_bool(decoder_p);
        break;

    case 0xbf76:
        dst_p->choice = oer_c_source_q_choice_c119_e;
        dst_p->value.c119 = decoder_read_bool(decoder_p);
        break;

    case 0xbf77:
        dst_p->choice = oer_c_source_q_choice_c120_e;
        dst_p->value.c120 = decoder_read_bool(decoder_p);
        break;

    case 0xbf78:
        dst_p->choice = oer_c_source_q_choice_c121_e;
        dst_p->value.c121 = decoder_read_bool(decoder_p);
        break;

    case 0xbf79:
        dst_p->choice = oer_c_source_q_choice_c122_e;
        dst_p->value.c122 = decoder_read_bool(decoder_p);
        break;

    case 0xbf7a:
        dst_p->choice = oer_c_source_q_choice_c123_e;
        dst_p->value.c123 = decoder_read_bool(decoder_p);
        break;

    case 0xbf7b:
        dst_p->choice = oer_c_source_q_choice_c124_e;
        dst_p->value.c124 = decoder_read_bool(decoder_p);
        break;

    case 0xbf7c:
        dst_p->choice = oer_c_source_q_choice_c125_e;
        dst_p->value.c125 = decoder_read_bool(decoder_p);
        break;

    case 0xbf7d:
        dst_p->choice = oer_c_source_q_choice_c126_e;
        dst_p->value.c126 = decoder_read_bool(decoder_p);
        break;

    case 0xbf7e:
        dst_p->choice = oer_c_source_q_choice_c127_e;
        dst_p->value.c127 = decoder_read_bool(decoder_p);
        break;

    case 0xbf7f:
        dst_p->choice = oer_c_source_q_choice_c128_e;
        dst_p->value.c128 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8100:
        dst_p->choice = oer_c_source_q_choice_c129_e;
        dst_p->value.c129 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8101:
        dst_p->choice = oer_c_source_q_choice_c130_e;
        dst_p->value.c130 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8102:
        dst_p->choice = oer_c_source_q_choice_c131_e;
        dst_p->value.c131 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8103:
        dst_p->choice = oer_c_source_q_choice_c132_e;
        dst_p->value.c132 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8104:
        dst_p->choice = oer_c_source_q_choice_c133_e;
        dst_p->value.c133 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8105:
        dst_p->choice = oer_c_source_q_choice_c134_e;
        dst_p->value.c134 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8106:
        dst_p->choice = oer_c_source_q_choice_c135_e;
        dst_p->value.c135 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8107:
        dst_p->choice = oer_c_source_q_choice_c136_e;
        dst_p->value.c136 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8108:
        dst_p->choice = oer_c_source_q_choice_c137_e;
        dst_p->value.c137 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8109:
        dst_p->choice = oer_c_source_q_choice_c138_e;
        dst_p->value.c138 = decoder_read_bool(decoder_p);
        break;

    case 0xbf810a:
        dst_p->choice = oer_c_source_q_choice_c139_e;
        dst_p->value.c139 = decoder_read_bool(decoder_p);
        break;

    case 0xbf810b:
        dst_p->choice = oer_c_source_q_choice_c140_e;
        dst_p->value.c140 = decoder_read_bool(decoder_p);
        break;

    case 0xbf810c:
        dst_p->choice = oer_c_source_q_choice_c141_e;
        dst_p->value.c141 = decoder_read_bool(decoder_p);
        break;

    case 0xbf810d:
        dst_p->choice = oer_c_source_q_choice_c142_e;
        dst_p->value.c142 = decoder_read_bool(decoder_p);
        break;

    case 0xbf810e:
        dst_p->choice = oer_c_source_q_choice_c143_e;
        dst_p->value.c143 = decoder_read_bool(decoder_p);
        break;

    case 0xbf810f:
        dst_p->choice = oer_c_source_q_choice_c144_e;
        dst_p->value.c144 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8110:
        dst_p->choice = oer_c_source_q_choice_c145_e;
        dst_p->value.c145 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8111:
        dst_p->choice = oer_c_source_q_choice_c146_e;
        dst_p->value.c146 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8112:
        dst_p->choice = oer_c_source_q_choice_c147_e;
        dst_p->value.c147 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8113:
        dst_p->choice = oer_c_source_q_choice_c148_e;
        dst_p->value.c148 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8114:
        dst_p->choice = oer_c_source_q_choice_c149_e;
        dst_p->value.c149 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8115:
        dst_p->choice = oer_c_source_q_choice_c150_e;
        dst_p->value.c150 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8116:
        dst_p->choice = oer_c_source_q_choice_c151_e;
        dst_p->value.c151 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8117:
        dst_p->choice = oer_c_source_q_choice_c152_e;
        dst_p->value.c152 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8118:
        dst_p->choice = oer_c_source_q_choice_c153_e;
        dst_p->value.c153 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8119:
        dst_p->choice = oer_c_source_q_choice_c154_e;
        dst_p->value.c154 = decoder_read_bool(decoder_p);
        break;

    case 0xbf811a:
        dst_p->choice = oer_c_source_q_choice_c155_e;
        dst_p->value.c155 = decoder_read_bool(decoder_p);
        break;

    case 0xbf811b:
        dst_p->choice = oer_c_source_q_choice_c156_e;
        dst_p->value.c156 = decoder_read_bool(decoder_p);
        break;

    case 0xbf811c:
        dst_p->choice = oer_c_source_q_choice_c157_e;
        dst_p->value.c157 = decoder_read_bool(decoder_p);
        break;

    case 0xbf811d:
        dst_p->choice = oer_c_source_q_choice_c158_e;
        dst_p->value.c158 = decoder_read_bool(decoder_p);
        break;

    case 0xbf811e:
        dst_p->choice = oer_c_source_q_choice_c159_e;
        dst_p->value.c159 = decoder_read_bool(decoder_p);
        break;

    case 0xbf811f:
        dst_p->choice = oer_c_source_q_choice_c160_e;
        dst_p->value.c160 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8120:
        dst_p->choice = oer_c_source_q_choice_c161_e;
        dst_p->value.c161 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8121:
        dst_p->choice = oer_c_source_q_choice_c162_e;
        dst_p->value.c162 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8122:
        dst_p->choice = oer_c_source_q_choice_c163_e;
        dst_p->value.c163 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8123:
        dst_p->choice = oer_c_source_q_choice_c164_e;
        dst_p->value.c164 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8124:
        dst_p->choice = oer_c_source_q_choice_c165_e;
        dst_p->value.c165 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8125:
        dst_p->choice = oer_c_source_q_choice_c166_e;
        dst_p->value.c166 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8126:
        dst_p->choice = oer_c_source_q_choice_c167_e;
        dst_p->value.c167 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8127:
        dst_p->choice = oer_c_source_q_choice_c168_e;
        dst_p->value.c168 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8128:
        dst_p->choice = oer_c_source_q_choice_c169_e;
        dst_p->value.c169 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8129:
        dst_p->choice = oer_c_source_q_choice_c170_e;
        dst_p->value.c170 = decoder_read_bool(decoder_p);
        break;

    case 0xbf812a:
        dst_p->choice = oer_c_source_q_choice_c171_e;
        dst_p->value.c171 = decoder_read_bool(decoder_p);
        break;

    case 0xbf812b:
        dst_p->choice = oer_c_source_q_choice_c172_e;
        dst_p->value.c172 = decoder_read_bool(decoder_p);
        break;

    case 0xbf812c:
        dst_p->choice = oer_c_source_q_choice_c173_e;
        dst_p->value.c173 = decoder_read_bool(decoder_p);
        break;

    case 0xbf812d:
        dst_p->choice = oer_c_source_q_choice_c174_e;
        dst_p->value.c174 = decoder_read_bool(decoder_p);
        break;

    case 0xbf812e:
        dst_p->choice = oer_c_source_q_choice_c175_e;
        dst_p->value.c175 = decoder_read_bool(decoder_p);
        break;

    case 0xbf812f:
        dst_p->choice = oer_c_source_q_choice_c176_e;
        dst_p->value.c176 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8130:
        dst_p->choice = oer_c_source_q_choice_c177_e;
        dst_p->value.c177 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8131:
        dst_p->choice = oer_c_source_q_choice_c178_e;
        dst_p->value.c178 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8132:
        dst_p->choice = oer_c_source_q_choice_c179_e;
        dst_p->value.c179 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8133:
        dst_p->choice = oer_c_source_q_choice_c180_e;
        dst_p->value.c180 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8134:
        dst_p->choice = oer_c_source_q_choice_c181_e;
        dst_p->value.c181 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8135:
        dst_p->choice = oer_c_source_q_choice_c182_e;
        dst_p->value.c182 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8136:
        dst_p->choice = oer_c_source_q_choice_c183_e;
        dst_p->value.c183 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8137:
        dst_p->choice = oer_c_source_q_choice_c184_e;
        dst_p->value.c184 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8138:
        dst_p->choice = oer_c_source_q_choice_c185_e;
        dst_p->value.c185 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8139:
        dst_p->choice = oer_c_source_q_choice_c186_e;
        dst_p->value.c186 = decoder_read_bool(decoder_p);
        break;

    case 0xbf813a:
        dst_p->choice = oer_c_source_q_choice_c187_e;
        dst_p->value.c187 = decoder_read_bool(decoder_p);
        break;

    case 0xbf813b:
        dst_p->choice = oer_c_source_q_choice_c188_e;
        dst_p->value.c188 = decoder_read_bool(decoder_p);
        break;

    case 0xbf813c:
        dst_p->choice = oer_c_source_q_choice_c189_e;
        dst_p->value.c189 = decoder_read_bool(decoder_p);
        break;

    case 0xbf813d:
        dst_p->choice = oer_c_source_q_choice_c190_e;
        dst_p->value.c190 = decoder_read_bool(decoder_p);
        break;

    case 0xbf813e:
        dst_p->choice = oer_c_source_q_choice_c191_e;
        dst_p->value.c191 = decoder_read_bool(decoder_p);
        break;

    case 0xbf813f:
        dst_p->choice = oer_c_source_q_choice_c192_e;
        dst_p->value.c192 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8140:
        dst_p->choice = oer_c_source_q_choice_c193_e;
        dst_p->value.c193 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8141:
        dst_p->choice = oer_c_source_q_choice_c194_e;
        dst_p->value.c194 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8142:
        dst_p->choice = oer_c_source_q_choice_c195_e;
        dst_p->value.c195 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8143:
        dst_p->choice = oer_c_source_q_choice_c196_e;
        dst_p->value.c196 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8144:
        dst_p->choice = oer_c_source_q_choice_c197_e;
        dst_p->value.c197 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8145:
        dst_p->choice = oer_c_source_q_choice_c198_e;
        dst_p->value.c198 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8146:
        dst_p->choice = oer_c_source_q_choice_c199_e;
        dst_p->value.c199 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8147:
        dst_p->choice = oer_c_source_q_choice_c200_e;
        dst_p->value.c200 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8148:
        dst_p->choice = oer_c_source_q_choice_c201_e;
        dst_p->value.c201 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8149:
        dst_p->choice = oer_c_source_q_choice_c202_e;
        dst_p->value.c202 = decoder_read_bool(decoder_p);
        break;

    case 0xbf814a:
        dst_p->choice = oer_c_source_q_choice_c203_e;
        dst_p->value.c203 = decoder_read_bool(decoder_p);
        break;

    case 0xbf814b:
        dst_p->choice = oer_c_source_q_choice_c204_e;
        dst_p->value.c204 = decoder_read_bool(decoder_p);
        break;

    case 0xbf814c:
        dst_p->choice = oer_c_source_q_choice_c205_e;
        dst_p->value.c205 = decoder_read_bool(decoder_p);
        break;

    case 0xbf814d:
        dst_p->choice = oer_c_source_q_choice_c206_e;
        dst_p->value.c206 = decoder_read_bool(decoder_p);
        break;

    case 0xbf814e:
        dst_p->choice = oer_c_source_q_choice_c207_e;
        dst_p->value.c207 = decoder_read_bool(decoder_p);
        break;

    case 0xbf814f:
        dst_p->choice = oer_c_source_q_choice_c208_e;
        dst_p->value.c208 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8150:
        dst_p->choice = oer_c_source_q_choice_c209_e;
        dst_p->value.c209 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8151:
        dst_p->choice = oer_c_source_q_choice_c210_e;
        dst_p->value.c210 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8152:
        dst_p->choice = oer_c_source_q_choice_c211_e;
        dst_p->value.c211 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8153:
        dst_p->choice = oer_c_source_q_choice_c212_e;
        dst_p->value.c212 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8154:
        dst_p->choice = oer_c_source_q_choice_c213_e;
        dst_p->value.c213 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8155:
        dst_p->choice = oer_c_source_q_choice_c214_e;
        dst_p->value.c214 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8156:
        dst_p->choice = oer_c_source_q_choice_c215_e;
        dst_p->value.c215 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8157:
        dst_p->choice = oer_c_source_q_choice_c216_e;
        dst_p->value.c216 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8158:
        dst_p->choice = oer_c_source_q_choice_c217_e;
        dst_p->value.c217 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8159:
        dst_p->choice = oer_c_source_q_choice_c218_e;
        dst_p->value.c218 = decoder_read_bool(decoder_p);
        break;

    case 0xbf815a:
        dst_p->choice = oer_c_source_q_choice_c219_e;
        dst_p->value.c219 = decoder_read_bool(decoder_p);
        break;

    case 0xbf815b:
        dst_p->choice = oer_c_source_q_choice_c220_e;
        dst_p->value.c220 = decoder_read_bool(decoder_p);
        break;

    case 0xbf815c:
        dst_p->choice = oer_c_source_q_choice_c221_e;
        dst_p->value.c221 = decoder_read_bool(decoder_p);
        break;

    case 0xbf815d:
        dst_p->choice = oer_c_source_q_choice_c222_e;
        dst_p->value.c222 = decoder_read_bool(decoder_p);
        break;

    case 0xbf815e:
        dst_p->choice = oer_c_source_q_choice_c223_e;
        dst_p->value.c223 = decoder_read_bool(decoder_p);
        break;

    case 0xbf815f:
        dst_p->choice = oer_c_source_q_choice_c224_e;
        dst_p->value.c224 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8160:
        dst_p->choice = oer_c_source_q_choice_c225_e;
        dst_p->value.c225 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8161:
        dst_p->choice = oer_c_source_q_choice_c226_e;
        dst_p->value.c226 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8162:
        dst_p->choice = oer_c_source_q_choice_c227_e;
        dst_p->value.c227 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8163:
        dst_p->choice = oer_c_source_q_choice_c228_e;
        dst_p->value.c228 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8164:
        dst_p->choice = oer_c_source_q_choice_c229_e;
        dst_p->value.c229 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8165:
        dst_p->choice = oer_c_source_q_choice_c230_e;
        dst_p->value.c230 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8166:
        dst_p->choice = oer_c_source_q_choice_c231_e;
        dst_p->value.c231 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8167:
        dst_p->choice = oer_c_source_q_choice_c232_e;
        dst_p->value.c232 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8168:
        dst_p->choice = oer_c_source_q_choice_c233_e;
        dst_p->value.c233 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8169:
        dst_p->choice = oer_c_source_q_choice_c234_e;
        dst_p->value.c234 = decoder_read_bool(decoder_p);
        break;

    case 0xbf816a:
        dst_p->choice = oer_c_source_q_choice_c235_e;
        dst_p->value.c235 = decoder_read_bool(decoder_p);
        break;

    case 0xbf816b:
        dst_p->choice = oer_c_source_q_choice_c236_e;
        dst_p->value.c236 = decoder_read_bool(decoder_p);
        break;

    case 0xbf816c:
        dst_p->choice = oer_c_source_q_choice_c237_e;
        dst_p->value.c237 = decoder_read_bool(decoder_p);
        break;

    case 0xbf816d:
        dst_p->choice = oer_c_source_q_choice_c238_e;
        dst_p->value.c238 = decoder_read_bool(decoder_p);
        break;

    case 0xbf816e:
        dst_p->choice = oer_c_source_q_choice_c239_e;
        dst_p->value.c239 = decoder_read_bool(decoder_p);
        break;

    case 0xbf816f:
        dst_p->choice = oer_c_source_q_choice_c240_e;
        dst_p->value.c240 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8170:
        dst_p->choice = oer_c_source_q_choice_c241_e;
        dst_p->value.c241 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8171:
        dst_p->choice = oer_c_source_q_choice_c242_e;
        dst_p->value.c242 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8172:
        dst_p->choice = oer_c_source_q_choice_c243_e;
        dst_p->value.c243 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8173:
        dst_p->choice = oer_c_source_q_choice_c244_e;
        dst_p->value.c244 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8174:
        dst_p->choice = oer_c_source_q_choice_c245_e;
        dst_p->value.c245 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8175:
        dst_p->choice = oer_c_source_q_choice_c246_e;
        dst_p->value.c246 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8176:
        dst_p->choice = oer_c_source_q_choice_c247_e;
        dst_p->value.c247 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8177:
        dst_p->choice = oer_c_source_q_choice_c248_e;
        dst_p->value.c248 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8178:
        dst_p->choice = oer_c_source_q_choice_c249_e;
        dst_p->value.c249 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8179:
        dst_p->choice = oer_c_source_q_choice_c250_e;
        dst_p->value.c250 = decoder_read_bool(decoder_p);
        break;

    case 0xbf817a:
        dst_p->choice = oer_c_source_q_choice_c251_e;
        dst_p->value.c251 = decoder_read_bool(decoder_p);
        break;

    case 0xbf817b:
        dst_p->choice = oer_c_source_q_choice_c252_e;
        dst_p->value.c252 = decoder_read_bool(decoder_p);
        break;

    case 0xbf817c:
        dst_p->choice = oer_c_source_q_choice_c253_e;
        dst_p->value.c253 = decoder_read_bool(decoder_p);
        break;

    case 0xbf817d:
        dst_p->choice = oer_c_source_q_choice_c254_e;
        dst_p->value.c254 = decoder_read_bool(decoder_p);
        break;

    case 0xbf817e:
        dst_p->choice = oer_c_source_q_choice_c255_e;
        dst_p->value.c255 = decoder_read_bool(decoder_p);
        break;

    case 0xbf817f:
        dst_p->choice = oer_c_source_q_choice_c256_e;
        dst_p->value.c256 = decoder_read_bool(decoder_p);
        break;

    case 0xbf8200:
        dst_p->choice = oer_c_source_q_choice_c257_e;
        dst_p->value.c257 = decoder_read_bool(decoder_p);
        break;

    default:
        decoder_abort(decoder_p, EBADCHOICE);
        break;
    }
}

static void oer_c_source_d_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_d_t *src_p)
{
    uint8_t number_of_length_bytes;
    uint8_t i;
    uint8_t number_of_length_bytes_2;
    uint8_t i_2;
    uint8_t present_mask[1];
    uint8_t enum_length;
    uint8_t present_mask_2[1];
    uint8_t present_mask_3[1];

    number_of_length_bytes = minimum_uint_length(src_p->length);
    encoder_append_uint8(encoder_p, number_of_length_bytes);
    encoder_append_uint(encoder_p,
                        src_p->length,
                        number_of_length_bytes);

    for (i = 0; i < src_p->length; i++) {
        switch (src_p->elements[i].a.b.choice) {

        case oer_c_source_d_a_b_choice_c_e:
            encoder_append_uint(encoder_p, 0x80, 1);
            encoder_append_uint8(encoder_p, src_p->elements[i].a.b.value.c);
            break;

        case oer_c_source_d_a_b_choice_d_e:
            encoder_append_uint(encoder_p, 0x81, 1);
            encoder_append_bool(encoder_p, src_p->elements[i].a.b.value.d);
            break;

        default:
            encoder_abort(encoder_p, EBADCHOICE);
            break;
        }

        number_of_length_bytes_2 = minimum_uint_length(src_p->elements[i].a.e.length);
        encoder_append_uint8(encoder_p, number_of_length_bytes_2);
        encoder_append_uint(encoder_p,
                            src_p->elements[i].a.e.length,
                            number_of_length_bytes_2);

        for (i_2 = 0; i_2 < src_p->elements[i].a.e.length; i_2++) {
        }

        present_mask[0] = 0;

        if (src_p->elements[i].g.h != oer_c_source_d_g_h_j_e) {
            present_mask[0] |= 0x80u;
        }

        encoder_append_bytes(encoder_p,
                             &present_mask[0],
                             sizeof(present_mask));

        if (src_p->elements[i].g.h != oer_c_source_d_g_h_j_e) {
            enum_length = enumerated_value_length(src_p->elements[i].g.h);

            if (enum_length != 0u) {
                encoder_append_uint8(encoder_p, 0x80u | enum_length);
                encoder_append_int(encoder_p, (int32_t)src_p->elements[i].g.h, enum_length);
            }
            else {
                encoder_append_uint8(encoder_p, (uint8_t)src_p->elements[i].g.h);
            }
        }

        encoder_append_uint8(encoder_p, src_p->elements[i].g.l.length);
        encoder_append_bytes(encoder_p,
                             &src_p->elements[i].g.l.buf[0],
                             src_p->elements[i].g.l.length);
        present_mask_2[0] = 0;

        if (src_p->elements[i].m.is_n_present) {
            present_mask_2[0] |= 0x80u;
        }

        if (src_p->elements[i].m.o != 3) {
            present_mask_2[0] |= 0x40u;
        }

        if (src_p->elements[i].m.is_p_present) {
            present_mask_2[0] |= 0x20u;
        }

        if (src_p->elements[i].m.s != false) {
            present_mask_2[0] |= 0x10u;
        }

        encoder_append_bytes(encoder_p,
                             &present_mask_2[0],
                             sizeof(present_mask_2));

        if (src_p->elements[i].m.is_n_present) {
            encoder_append_bool(encoder_p, src_p->elements[i].m.n);
        }

        if (src_p->elements[i].m.o != 3) {
            encoder_append_int8(encoder_p, src_p->elements[i].m.o);
        }

        if (src_p->elements[i].m.is_p_present) {
            present_mask_3[0] = 0;

            if (src_p->elements[i].m.p.is_r_present) {
                present_mask_3[0] |= 0x80u;
            }

            encoder_append_bytes(encoder_p,
                                 &present_mask_3[0],
                                 sizeof(present_mask_3));

            encoder_append_bytes(encoder_p,
                                 &src_p->elements[i].m.p.q.buf[0],
                                 5);

            if (src_p->elements[i].m.p.is_r_present) {
                encoder_append_bool(encoder_p, src_p->elements[i].m.p.r);
            }
        }

        if (src_p->elements[i].m.s != false) {
            encoder_append_bool(encoder_p, src_p->elements[i].m.s);
        }
    }
}

static void oer_c_source_d_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_d_t *dst_p)
{
    uint8_t number_of_length_bytes;
    uint8_t i;
    uint32_t tag;
    uint8_t number_of_length_bytes_2;
    uint8_t i_2;
    uint8_t present_mask[1];
    uint8_t enum_length;
    uint8_t present_mask_2[1];
    uint8_t present_mask_3[1];

    number_of_length_bytes = decoder_read_uint8(decoder_p);
    dst_p->length = (uint8_t)decoder_read_uint(
        decoder_p,
        number_of_length_bytes);

    if (dst_p->length > 10u) {
        decoder_abort(decoder_p, EBADLENGTH);

        return;
    }

    for (i = 0; i < dst_p->length; i++) {
        tag = decoder_read_tag(decoder_p);

        switch (tag) {

        case 0x80:
            dst_p->elements[i].a.b.choice = oer_c_source_d_a_b_choice_c_e;
            dst_p->elements[i].a.b.value.c = decoder_read_uint8(decoder_p);
            break;

        case 0x81:
            dst_p->elements[i].a.b.choice = oer_c_source_d_a_b_choice_d_e;
            dst_p->elements[i].a.b.value.d = decoder_read_bool(decoder_p);
            break;

        default:
            decoder_abort(decoder_p, EBADCHOICE);
            break;
        }

        number_of_length_bytes_2 = decoder_read_uint8(decoder_p);
        dst_p->elements[i].a.e.length = (uint8_t)decoder_read_uint(
            decoder_p,
            number_of_length_bytes_2);

        if (dst_p->elements[i].a.e.length > 4u) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }

        for (i_2 = 0; i_2 < dst_p->elements[i].a.e.length; i_2++) {
        }

        decoder_read_bytes(decoder_p,
                           &present_mask[0],
                           sizeof(present_mask));

        if ((present_mask[0] & 0x80u) == 0x80u) {
            enum_length = decoder_read_uint8(decoder_p);

            if ((enum_length & 0x80u) == 0x80u) {
                enum_length &= 0x7fu;

                if ((enum_length > 2u) || (enum_length == 0u)) {
                    decoder_abort(decoder_p, EBADLENGTH);

                    return;
                }
                dst_p->elements[i].g.h = (enum oer_c_source_d_g_h_e)decoder_read_int(decoder_p, enum_length);
            }
            else {
                dst_p->elements[i].g.h = (enum oer_c_source_d_g_h_e)enum_length;
            }
        } else {
            dst_p->elements[i].g.h = oer_c_source_d_g_h_j_e;
        }

        dst_p->elements[i].g.l.length = decoder_read_uint8(decoder_p);

        if (dst_p->elements[i].g.l.length > 2u) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }

        decoder_read_bytes(decoder_p,
                           &dst_p->elements[i].g.l.buf[0],
                           dst_p->elements[i].g.l.length);
        decoder_read_bytes(decoder_p,
                           &present_mask_2[0],
                           sizeof(present_mask_2));

        dst_p->elements[i].m.is_n_present = ((present_mask_2[0] & 0x80u) == 0x80u);
        dst_p->elements[i].m.is_p_present = ((present_mask_2[0] & 0x20u) == 0x20u);

        if (dst_p->elements[i].m.is_n_present) {
            dst_p->elements[i].m.n = decoder_read_bool(decoder_p);
        }

        if ((present_mask_2[0] & 0x40u) == 0x40u) {
            dst_p->elements[i].m.o = decoder_read_int8(decoder_p);
        } else {
            dst_p->elements[i].m.o = 3;
        }

        if (dst_p->elements[i].m.is_p_present) {
            decoder_read_bytes(decoder_p,
                               &present_mask_3[0],
                               sizeof(present_mask_3));

            dst_p->elements[i].m.p.is_r_present = ((present_mask_3[0] & 0x80u) == 0x80u);

            decoder_read_bytes(decoder_p,
                               &dst_p->elements[i].m.p.q.buf[0],
                               5);

            if (dst_p->elements[i].m.p.is_r_present) {
                dst_p->elements[i].m.p.r = decoder_read_bool(decoder_p);
            }
        }

        if ((present_mask_2[0] & 0x10u) == 0x10u) {
            dst_p->elements[i].m.s = decoder_read_bool(decoder_p);
        } else {
            dst_p->elements[i].m.s = false;
        }
    }
}

static void oer_c_source_ac_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_ac_t *src_p)
{
    oer_c_source_q_encode_inner(encoder_p, &src_p->a);
    oer_c_source_d_encode_inner(encoder_p, &src_p->b);
}

static void oer_c_source_ac_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_ac_t *dst_p)
{
    oer_c_source_q_decode_inner(decoder_p, &dst_p->a);
    oer_c_source_d_decode_inner(decoder_p, &dst_p->b);
}

static void oer_c_source_ad_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_ad_t *src_p)
{
    uint8_t enum_length;

    enum_length = enumerated_value_length(src_p->value);

    if (enum_length != 0u) {
        encoder_append_uint8(encoder_p, 0x80u | enum_length);
        encoder_append_int(encoder_p, (int32_t)src_p->value, enum_length);
    }
    else {
        encoder_append_uint8(encoder_p, (uint8_t)src_p->value);
    }
}

static void oer_c_source_ad_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_ad_t *dst_p)
{
    uint8_t enum_length;

    enum_length = decoder_read_uint8(decoder_p);

    if ((enum_length & 0x80u) == 0x80u) {
        enum_length &= 0x7fu;

        if ((enum_length > 1u) || (enum_length == 0u)) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }
        dst_p->value = (enum oer_c_source_ad_e)decoder_read_int(decoder_p, enum_length);
    }
    else {
        dst_p->value = (enum oer_c_source_ad_e)enum_length;
    }
}

static void oer_c_source_ae_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_ae_t *src_p)
{
    uint8_t present_mask[1];

    present_mask[0] = 0;

    if (src_p->is_a_present) {
        present_mask[0] |= 0x40u;
    }

    if (src_p->b != true) {
        present_mask[0] |= 0x20u;
    }

    encoder_append_bytes(encoder_p,
                         &present_mask[0],
                         sizeof(present_mask));

    if (src_p->is_a_present) {
        encoder_append_bool(encoder_p, src_p->a);
    }

    if (src_p->b != true) {
        encoder_append_bool(encoder_p, src_p->b);
    }

    encoder_append_bool(encoder_p, src_p->c);
}

static void oer_c_source_ae_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_ae_t *dst_p)
{
    uint8_t present_mask[1];

    decoder_read_bytes(decoder_p,
                       &present_mask[0],
                       sizeof(present_mask));

    dst_p->is_a_present = ((present_mask[0] & 0x40u) == 0x40u);

    if (dst_p->is_a_present) {
        dst_p->a = decoder_read_bool(decoder_p);
    }

    if ((present_mask[0] & 0x20u) == 0x20u) {
        dst_p->b = decoder_read_bool(decoder_p);
    } else {
        dst_p->b = true;
    }

    dst_p->c = decoder_read_bool(decoder_p);
}

static void oer_c_source_ah_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_ah_t *src_p)
{
    uint8_t present_mask[1];
    uint8_t addition_mask[1];
    uint8_t enum_length;

    if(src_p->is_d_addition_present || src_p->is_e_addition_present) {
        present_mask[0] = 0x80;
    }
    else {
        present_mask[0] = 0x0;
    }

    encoder_append_bytes(encoder_p,
                         &present_mask[0],
                         sizeof(present_mask));

    encoder_append_bool(encoder_p, src_p->c);

    if((present_mask[0] & 0x80u) == 0x80u) {
        encoder_append_length_determinant(encoder_p, 2);
        encoder_append_uint8(encoder_p, 6);
        addition_mask[0] = 0;

        if (src_p->is_d_addition_present) {
            addition_mask[0] |= 0x80u;
        }

        if (src_p->is_e_addition_present) {
            addition_mask[0] |= 0x40u;
        }
        encoder_append_bytes(encoder_p,
                             &addition_mask[0],
                             sizeof(addition_mask));

        if (src_p->is_d_addition_present) {
            encoder_append_length_determinant(encoder_p, 1u);
            encoder_append_uint8(encoder_p, src_p->d);
        }

        if (src_p->is_e_addition_present) {
            encoder_append_length_determinant(encoder_p, (uint32_t)enumerated_value_length((int32_t)src_p->e) +
                1u);
            enum_length = enumerated_value_length(src_p->e);

            if (enum_length != 0u) {
                encoder_append_uint8(encoder_p, 0x80u | enum_length);
                encoder_append_int(encoder_p, (int32_t)src_p->e, enum_length);
            }
            else {
                encoder_append_uint8(encoder_p, (uint8_t)src_p->e);
            }
        }
    }
}

static void oer_c_source_ah_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_ah_t *dst_p)
{
    uint8_t present_mask[1];
    uint32_t addition_length;
    uint8_t addition_unused_bits;
    uint32_t addition_bits;
    uint8_t addition_mask[1];
    uint32_t i;
    uint8_t tmp_addition_mask;
    uint32_t unknown_addition_bits;
    uint8_t mask;
    uint8_t enum_length;
    uint32_t tmp_length;

    decoder_read_bytes(decoder_p,
                       &present_mask[0],
                       sizeof(present_mask));

    dst_p->c = decoder_read_bool(decoder_p);

    if((present_mask[0] & 0x80u) == 0x80u) {
        addition_length = decoder_read_length_determinant(decoder_p);

        if(addition_length <= 1u) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }
        addition_length -= 1u;
        addition_unused_bits = decoder_read_uint8(decoder_p);

        if (addition_unused_bits > 7u) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }
        addition_bits = ((addition_length * 8u) - addition_unused_bits);
        decoder_read_bytes(decoder_p,
                           addition_mask,
                           (addition_length < 1u) ? addition_length : 1u);

        tmp_addition_mask = addition_mask[0];
        mask = 0x20;
        unknown_addition_bits = 0;

        for (i = 2; i < addition_bits; i++) {

            if (mask == 0u) {
                decoder_read_bytes(decoder_p, &tmp_addition_mask, 1);

                if (decoder_get_result(decoder_p) < 0) {

                    return;
                }
                mask = 0x80;
            }

            if( (tmp_addition_mask & mask) == mask) {
                unknown_addition_bits += 1u;
            };
            mask >>= 1;
        }
        dst_p->is_d_addition_present = ((addition_bits > 0u) && ((addition_mask[0] & 0x80u) == 0x80u));

        if (dst_p->is_d_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            dst_p->d = decoder_read_uint8(decoder_p);
        }

        dst_p->is_e_addition_present = ((addition_bits > 1u) && ((addition_mask[0] & 0x40u) == 0x40u));

        if (dst_p->is_e_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            enum_length = decoder_read_uint8(decoder_p);

            if ((enum_length & 0x80u) == 0x80u) {
                enum_length &= 0x7fu;

                if ((enum_length > 1u) || (enum_length == 0u)) {
                    decoder_abort(decoder_p, EBADLENGTH);

                    return;
                }
                dst_p->e = (enum oer_c_source_ah_e_e)decoder_read_int(decoder_p, enum_length);
            }
            else {
                dst_p->e = (enum oer_c_source_ah_e_e)enum_length;
            }
        }

        for (i = 0; i < unknown_addition_bits; i++) {
            tmp_length = decoder_read_length_determinant(decoder_p);

            if (decoder_free(decoder_p, tmp_length) < 0) {

                return;
            }
        }
    }
    else {
        dst_p->is_d_addition_present = false;
        dst_p->is_e_addition_present = false;
    }
}

static void oer_c_source_af_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_af_t *src_p)
{
    uint8_t present_mask[1];
    uint8_t addition_mask[2];

    if(src_p->is_b_addition_present || src_p->is_e_addition_present || src_p->is_f_addition_present ||
       src_p->is_g_addition_present || src_p->is_h_addition_present || src_p->is_i_addition_present ||
       src_p->is_j_addition_present || src_p->is_k_addition_present || src_p->is_l_addition_present) {
        present_mask[0] = 0x80;
    }
    else {
        present_mask[0] = 0x0;
    }

    encoder_append_bytes(encoder_p,
                         &present_mask[0],
                         sizeof(present_mask));

    encoder_append_bool(encoder_p, src_p->a);

    if((present_mask[0] & 0x80u) == 0x80u) {
        encoder_append_length_determinant(encoder_p, 3);
        encoder_append_uint8(encoder_p, 7);
        addition_mask[0] = 0;
        addition_mask[1] = 0;

        if (src_p->is_b_addition_present) {
            addition_mask[0] |= 0x80u;
        }

        if (src_p->is_e_addition_present) {
            addition_mask[0] |= 0x40u;
        }

        if (src_p->is_f_addition_present) {
            addition_mask[0] |= 0x20u;
        }

        if (src_p->is_g_addition_present) {
            addition_mask[0] |= 0x10u;
        }

        if (src_p->is_h_addition_present) {
            addition_mask[0] |= 0x08u;
        }

        if (src_p->is_i_addition_present) {
            addition_mask[0] |= 0x04u;
        }

        if (src_p->is_j_addition_present) {
            addition_mask[0] |= 0x02u;
        }

        if (src_p->is_k_addition_present) {
            addition_mask[0] |= 0x01u;
        }

        if (src_p->is_l_addition_present) {
            addition_mask[1] |= 0x80u;
        }
        encoder_append_bytes(encoder_p,
                             &addition_mask[0],
                             sizeof(addition_mask));

        if (src_p->is_b_addition_present) {
            encoder_append_length_determinant(encoder_p, length_determinant_length(7u) +
                (uint32_t)enumerated_value_length((int32_t)src_p->e) + 8u);
            oer_c_source_ah_encode_inner(encoder_p, &src_p->b);
        }

        if (src_p->is_e_addition_present) {
            encoder_append_length_determinant(encoder_p, 1u);
            encoder_append_uint8(encoder_p, src_p->e);
        }

        if (src_p->is_f_addition_present) {
            encoder_append_length_determinant(encoder_p, 1u);
            encoder_append_uint8(encoder_p, src_p->f);
        }

        if (src_p->is_g_addition_present) {
            encoder_append_length_determinant(encoder_p, 1u);
            encoder_append_uint8(encoder_p, src_p->g);
        }

        if (src_p->is_h_addition_present) {
            encoder_append_length_determinant(encoder_p, 1u);
            encoder_append_uint8(encoder_p, src_p->h);
        }

        if (src_p->is_i_addition_present) {
            encoder_append_length_determinant(encoder_p, 1u);
            encoder_append_uint8(encoder_p, src_p->i);
        }

        if (src_p->is_j_addition_present) {
            encoder_append_length_determinant(encoder_p, 1u);
            encoder_append_uint8(encoder_p, src_p->j);
        }

        if (src_p->is_k_addition_present) {
            encoder_append_length_determinant(encoder_p, 1u);
            encoder_append_uint8(encoder_p, src_p->k);
        }

        if (src_p->is_l_addition_present) {
            encoder_append_length_determinant(encoder_p, 1u);
            encoder_append_uint8(encoder_p, src_p->l);
        }
    }
}

static void oer_c_source_af_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_af_t *dst_p)
{
    uint8_t present_mask[1];
    uint32_t addition_length;
    uint8_t addition_unused_bits;
    uint32_t addition_bits;
    uint8_t addition_mask[2];
    uint32_t i;
    uint8_t tmp_addition_mask;
    uint32_t unknown_addition_bits;
    uint8_t mask;
    uint32_t tmp_length;

    decoder_read_bytes(decoder_p,
                       &present_mask[0],
                       sizeof(present_mask));

    dst_p->a = decoder_read_bool(decoder_p);

    if((present_mask[0] & 0x80u) == 0x80u) {
        addition_length = decoder_read_length_determinant(decoder_p);

        if(addition_length <= 1u) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }
        addition_length -= 1u;
        addition_unused_bits = decoder_read_uint8(decoder_p);

        if (addition_unused_bits > 7u) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }
        addition_bits = ((addition_length * 8u) - addition_unused_bits);
        decoder_read_bytes(decoder_p,
                           addition_mask,
                           (addition_length < 2u) ? addition_length : 2u);

        tmp_addition_mask = addition_mask[1];
        mask = 0x40;
        unknown_addition_bits = 0;

        for (i = 9; i < addition_bits; i++) {

            if (mask == 0u) {
                decoder_read_bytes(decoder_p, &tmp_addition_mask, 1);

                if (decoder_get_result(decoder_p) < 0) {

                    return;
                }
                mask = 0x80;
            }

            if( (tmp_addition_mask & mask) == mask) {
                unknown_addition_bits += 1u;
            };
            mask >>= 1;
        }
        dst_p->is_b_addition_present = ((addition_bits > 0u) && ((addition_mask[0] & 0x80u) == 0x80u));

        if (dst_p->is_b_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            oer_c_source_ah_decode_inner(decoder_p, &dst_p->b);
        }

        dst_p->is_e_addition_present = ((addition_bits > 1u) && ((addition_mask[0] & 0x40u) == 0x40u));

        if (dst_p->is_e_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            dst_p->e = decoder_read_uint8(decoder_p);
        }

        dst_p->is_f_addition_present = ((addition_bits > 2u) && ((addition_mask[0] & 0x20u) == 0x20u));

        if (dst_p->is_f_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            dst_p->f = decoder_read_uint8(decoder_p);
        }

        dst_p->is_g_addition_present = ((addition_bits > 3u) && ((addition_mask[0] & 0x10u) == 0x10u));

        if (dst_p->is_g_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            dst_p->g = decoder_read_uint8(decoder_p);
        }

        dst_p->is_h_addition_present = ((addition_bits > 4u) && ((addition_mask[0] & 0x08u) == 0x08u));

        if (dst_p->is_h_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            dst_p->h = decoder_read_uint8(decoder_p);
        }

        dst_p->is_i_addition_present = ((addition_bits > 5u) && ((addition_mask[0] & 0x04u) == 0x04u));

        if (dst_p->is_i_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            dst_p->i = decoder_read_uint8(decoder_p);
        }

        dst_p->is_j_addition_present = ((addition_bits > 6u) && ((addition_mask[0] & 0x02u) == 0x02u));

        if (dst_p->is_j_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            dst_p->j = decoder_read_uint8(decoder_p);
        }

        dst_p->is_k_addition_present = ((addition_bits > 7u) && ((addition_mask[0] & 0x01u) == 0x01u));

        if (dst_p->is_k_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            dst_p->k = decoder_read_uint8(decoder_p);
        }

        dst_p->is_l_addition_present = ((addition_bits > 8u) && ((addition_mask[1] & 0x80u) == 0x80u));

        if (dst_p->is_l_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            dst_p->l = decoder_read_uint8(decoder_p);
        }

        for (i = 0; i < unknown_addition_bits; i++) {
            tmp_length = decoder_read_length_determinant(decoder_p);

            if (decoder_free(decoder_p, tmp_length) < 0) {

                return;
            }
        }
    }
    else {
        dst_p->is_b_addition_present = false;
        dst_p->is_e_addition_present = false;
        dst_p->is_f_addition_present = false;
        dst_p->is_g_addition_present = false;
        dst_p->is_h_addition_present = false;
        dst_p->is_i_addition_present = false;
        dst_p->is_j_addition_present = false;
        dst_p->is_k_addition_present = false;
        dst_p->is_l_addition_present = false;
    }
}

static void oer_c_source_ag_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_ag_t *src_p)
{
    uint8_t present_mask[1];
    uint8_t addition_mask[1];
    uint8_t number_of_length_bytes;
    uint8_t i_2;
    uint8_t enum_length;

    if(src_p->is_b_addition_present || src_p->is_c_addition_present || src_p->is_d_addition_present ||
       src_p->is_h_addition_present || src_p->is_i_addition_present || src_p->is_j_addition_present ||
       src_p->is_m_addition_present) {
        present_mask[0] = 0x80;
    }
    else {
        present_mask[0] = 0x0;
    }

    encoder_append_bytes(encoder_p,
                         &present_mask[0],
                         sizeof(present_mask));

    encoder_append_bool(encoder_p, src_p->a);

    if((present_mask[0] & 0x80u) == 0x80u) {
        encoder_append_length_determinant(encoder_p, 2);
        encoder_append_uint8(encoder_p, 1);
        addition_mask[0] = 0;

        if (src_p->is_b_addition_present) {
            addition_mask[0] |= 0x80u;
        }

        if (src_p->is_c_addition_present) {
            addition_mask[0] |= 0x40u;
        }

        if (src_p->is_d_addition_present) {
            addition_mask[0] |= 0x20u;
        }

        if (src_p->is_h_addition_present) {
            addition_mask[0] |= 0x10u;
        }

        if (src_p->is_i_addition_present) {
            addition_mask[0] |= 0x08u;
        }

        if (src_p->is_j_addition_present) {
            addition_mask[0] |= 0x04u;
        }

        if (src_p->is_m_addition_present) {
            addition_mask[0] |= 0x02u;
        }
        encoder_append_bytes(encoder_p,
                             &addition_mask[0],
                             sizeof(addition_mask));

        if (src_p->is_b_addition_present) {
            encoder_append_length_determinant(encoder_p, length_determinant_length(src_p->b.length) +
                src_p->b.length);
            encoder_append_uint8(encoder_p, src_p->b.length);
            encoder_append_bytes(encoder_p,
                                 &src_p->b.buf[0],
                                 src_p->b.length);
        }

        if (src_p->is_c_addition_present) {
            encoder_append_length_determinant(encoder_p, (uint32_t)minimum_uint_length(src_p->c.length) +
                (uint32_t)(src_p->c.length * (1u)) + 1u);
            number_of_length_bytes = minimum_uint_length(src_p->c.length);
            encoder_append_uint8(encoder_p, number_of_length_bytes);
            encoder_append_uint(encoder_p,
                                src_p->c.length,
                                number_of_length_bytes);

            for (i_2 = 0; i_2 < src_p->c.length; i_2++) {
                encoder_append_bool(encoder_p, src_p->c.elements[i_2]);
            }
        }

        if (src_p->is_d_addition_present) {
            encoder_append_length_determinant(encoder_p, (uint32_t)enumerated_value_length((int32_t)src_p->d) +
                1u);
            enum_length = enumerated_value_length(src_p->d);

            if (enum_length != 0u) {
                encoder_append_uint8(encoder_p, 0x80u | enum_length);
                encoder_append_int(encoder_p, (int32_t)src_p->d, enum_length);
            }
            else {
                encoder_append_uint8(encoder_p, (uint8_t)src_p->d);
            }
        }

        if (src_p->is_h_addition_present) {
            encoder_append_length_determinant(encoder_p, 0u);
        }

        if (src_p->is_i_addition_present) {
            encoder_append_length_determinant(encoder_p, 4u);
            encoder_append_float(encoder_p, src_p->i);
        }

        if (src_p->is_j_addition_present) {
            encoder_append_length_determinant(encoder_p, get_choice_j_length(src_p));

            switch (src_p->j.choice) {

            case oer_c_source_ag_j_choice_k_e:
                encoder_append_uint(encoder_p, 0x80, 1);
                encoder_append_uint16(encoder_p, src_p->j.value.k);
                break;

            case oer_c_source_ag_j_choice_l_e:
                encoder_append_uint(encoder_p, 0x81, 1);
                encoder_append_bool(encoder_p, src_p->j.value.l);
                break;

            default:
                encoder_abort(encoder_p, EBADCHOICE);
                break;
            }
        }

        if (src_p->is_m_addition_present) {
            encoder_append_length_determinant(encoder_p, 5u);
            encoder_append_bytes(encoder_p,
                                 &src_p->m.buf[0],
                                 5);
        }
    }
}

static void oer_c_source_ag_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_ag_t *dst_p)
{
    uint8_t present_mask[1];
    uint32_t addition_length;
    uint8_t addition_unused_bits;
    uint32_t addition_bits;
    uint8_t addition_mask[1];
    uint32_t i;
    uint8_t tmp_addition_mask;
    uint32_t unknown_addition_bits;
    uint8_t mask;
    uint8_t number_of_length_bytes;
    uint8_t i_2;
    uint8_t enum_length;
    uint32_t tag;
    uint32_t tmp_length;

    decoder_read_bytes(decoder_p,
                       &present_mask[0],
                       sizeof(present_mask));

    dst_p->a = decoder_read_bool(decoder_p);

    if((present_mask[0] & 0x80u) == 0x80u) {
        addition_length = decoder_read_length_determinant(decoder_p);

        if(addition_length <= 1u) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }
        addition_length -= 1u;
        addition_unused_bits = decoder_read_uint8(decoder_p);

        if (addition_unused_bits > 7u) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }
        addition_bits = ((addition_length * 8u) - addition_unused_bits);
        decoder_read_bytes(decoder_p,
                           addition_mask,
                           (addition_length < 1u) ? addition_length : 1u);

        tmp_addition_mask = addition_mask[0];
        mask = 0x01;
        unknown_addition_bits = 0;

        for (i = 7; i < addition_bits; i++) {

            if (mask == 0u) {
                decoder_read_bytes(decoder_p, &tmp_addition_mask, 1);

                if (decoder_get_result(decoder_p) < 0) {

                    return;
                }
                mask = 0x80;
            }

            if( (tmp_addition_mask & mask) == mask) {
                unknown_addition_bits += 1u;
            };
            mask >>= 1;
        }
        dst_p->is_b_addition_present = ((addition_bits > 0u) && ((addition_mask[0] & 0x80u) == 0x80u));

        if (dst_p->is_b_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            dst_p->b.length = decoder_read_uint8(decoder_p);

            if (dst_p->b.length > 10u) {
                decoder_abort(decoder_p, EBADLENGTH);

                return;
            }

            decoder_read_bytes(decoder_p,
                               &dst_p->b.buf[0],
                               dst_p->b.length);
        }

        dst_p->is_c_addition_present = ((addition_bits > 1u) && ((addition_mask[0] & 0x40u) == 0x40u));

        if (dst_p->is_c_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            number_of_length_bytes = decoder_read_uint8(decoder_p);
            dst_p->c.length = (uint8_t)decoder_read_uint(
                decoder_p,
                number_of_length_bytes);

            if (dst_p->c.length > 10u) {
                decoder_abort(decoder_p, EBADLENGTH);

                return;
            }

            for (i_2 = 0; i_2 < dst_p->c.length; i_2++) {
                dst_p->c.elements[i_2] = decoder_read_bool(decoder_p);
            }
        }

        dst_p->is_d_addition_present = ((addition_bits > 2u) && ((addition_mask[0] & 0x20u) == 0x20u));

        if (dst_p->is_d_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            enum_length = decoder_read_uint8(decoder_p);

            if ((enum_length & 0x80u) == 0x80u) {
                enum_length &= 0x7fu;

                if ((enum_length > 3u) || (enum_length == 0u)) {
                    decoder_abort(decoder_p, EBADLENGTH);

                    return;
                }
                dst_p->d = (enum oer_c_source_ag_d_e)decoder_read_int(decoder_p, enum_length);
            }
            else {
                dst_p->d = (enum oer_c_source_ag_d_e)enum_length;
            }
        }

        dst_p->is_h_addition_present = ((addition_bits > 3u) && ((addition_mask[0] & 0x10u) == 0x10u));

        if (dst_p->is_h_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
        }

        dst_p->is_i_addition_present = ((addition_bits > 4u) && ((addition_mask[0] & 0x08u) == 0x08u));

        if (dst_p->is_i_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            dst_p->i = decoder_read_float(decoder_p);
        }

        dst_p->is_j_addition_present = ((addition_bits > 5u) && ((addition_mask[0] & 0x04u) == 0x04u));

        if (dst_p->is_j_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            tag = decoder_read_tag(decoder_p);

            switch (tag) {

            case 0x80:
                dst_p->j.choice = oer_c_source_ag_j_choice_k_e;
                dst_p->j.value.k = decoder_read_uint16(decoder_p);
                break;

            case 0x81:
                dst_p->j.choice = oer_c_source_ag_j_choice_l_e;
                dst_p->j.value.l = decoder_read_bool(decoder_p);
                break;

            default:
                decoder_abort(decoder_p, EBADCHOICE);
                break;
            }
        }

        dst_p->is_m_addition_present = ((addition_bits > 6u) && ((addition_mask[0] & 0x02u) == 0x02u));

        if (dst_p->is_m_addition_present) {
            (void)decoder_read_length_determinant(decoder_p);
            decoder_read_bytes(decoder_p,
                               &dst_p->m.buf[0],
                               5);
        }

        for (i = 0; i < unknown_addition_bits; i++) {
            tmp_length = decoder_read_length_determinant(decoder_p);

            if (decoder_free(decoder_p, tmp_length) < 0) {

                return;
            }
        }
    }
    else {
        dst_p->is_b_addition_present = false;
        dst_p->is_c_addition_present = false;
        dst_p->is_d_addition_present = false;
        dst_p->is_h_addition_present = false;
        dst_p->is_i_addition_present = false;
        dst_p->is_j_addition_present = false;
        dst_p->is_m_addition_present = false;
    }
}

static void oer_c_source_aj_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_aj_t *src_p)
{
    uint8_t enum_length;

    enum_length = enumerated_value_length(src_p->a);

    if (enum_length != 0u) {
        encoder_append_uint8(encoder_p, 0x80u | enum_length);
        encoder_append_int(encoder_p, (int32_t)src_p->a, enum_length);
    }
    else {
        encoder_append_uint8(encoder_p, (uint8_t)src_p->a);
    }
}

static void oer_c_source_aj_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_aj_t *dst_p)
{
    uint8_t enum_length;

    enum_length = decoder_read_uint8(decoder_p);

    if ((enum_length & 0x80u) == 0x80u) {
        enum_length &= 0x7fu;

        if ((enum_length > 1u) || (enum_length == 0u)) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }
        dst_p->a = (enum oer_c_source_aj_a_e)decoder_read_int(decoder_p, enum_length);
    }
    else {
        dst_p->a = (enum oer_c_source_aj_a_e)enum_length;
    }
}

static void oer_c_source_ak_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_ak_t *src_p)
{
    switch (src_p->choice) {

    case oer_c_source_ak_choice_a_e:
        encoder_append_uint(encoder_p, 0x80, 1);
        oer_c_source_aj_encode_inner(encoder_p, &src_p->value.a);
        break;

    default:
        encoder_abort(encoder_p, EBADCHOICE);
        break;
    }
}

static void oer_c_source_ak_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_ak_t *dst_p)
{
    uint32_t tag;

    tag = decoder_read_tag(decoder_p);

    switch (tag) {

    case 0x80:
        dst_p->choice = oer_c_source_ak_choice_a_e;
        oer_c_source_aj_decode_inner(decoder_p, &dst_p->value.a);
        break;

    default:
        decoder_abort(decoder_p, EBADCHOICE);
        break;
    }
}

static void oer_c_source_ai_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_ai_t *src_p)
{
    oer_c_source_ak_encode_inner(encoder_p, &src_p->a);
}

static void oer_c_source_ai_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_ai_t *dst_p)
{
    oer_c_source_ak_decode_inner(decoder_p, &dst_p->a);
}

static void oer_c_source_al_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_al_t *src_p)
{
    encoder_append_int16(encoder_p, src_p->value);
}

static void oer_c_source_al_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_al_t *dst_p)
{
    dst_p->value = decoder_read_int16(decoder_p);
}

static void oer_c_source_am_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_am_t *src_p)
{
    encoder_append_int8(encoder_p, src_p->value);
}

static void oer_c_source_am_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_am_t *dst_p)
{
    dst_p->value = decoder_read_int8(decoder_p);
}

static void oer_c_source_an_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_an_t *src_p)
{
    uint8_t enum_length;

    enum_length = enumerated_value_length(src_p->value);

    if (enum_length != 0u) {
        encoder_append_uint8(encoder_p, 0x80u | enum_length);
        encoder_append_int(encoder_p, (int32_t)src_p->value, enum_length);
    }
    else {
        encoder_append_uint8(encoder_p, (uint8_t)src_p->value);
    }
}

static void oer_c_source_an_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_an_t *dst_p)
{
    uint8_t enum_length;

    enum_length = decoder_read_uint8(decoder_p);

    if ((enum_length & 0x80u) == 0x80u) {
        enum_length &= 0x7fu;

        if ((enum_length > 4u) || (enum_length == 0u)) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }
        dst_p->value = (enum oer_c_source_an_e)decoder_read_int(decoder_p, enum_length);
    }
    else {
        dst_p->value = (enum oer_c_source_an_e)enum_length;
    }
}

static void oer_c_source_ao_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_ao_t *src_p)
{
    encoder_append_uint(encoder_p, (uint32_t)src_p->a, 1);
    encoder_append_uint(encoder_p, (uint32_t)src_p->b, 3);
    encoder_append_uint(encoder_p, (uint32_t)src_p->c, 1);
    encoder_append_uint(encoder_p, (uint32_t)src_p->d, 4);
    encoder_append_long_uint(encoder_p, (uint64_t)src_p->e, 8);
}

static void oer_c_source_ao_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_ao_t *dst_p)
{
    dst_p->a = (uint8_t)decoder_read_uint(decoder_p, 1);
    dst_p->b = (uint32_t)decoder_read_uint(decoder_p, 3);
    dst_p->b &= 0x00ffffffu;
    dst_p->c = (uint8_t)decoder_read_uint(decoder_p, 1);
    dst_p->d = (uint32_t)decoder_read_uint(decoder_p, 4);
    dst_p->e = (uint64_t)decoder_read_long_uint(decoder_p, 8);
}

static void oer_c_ref_referenced_sequence_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_ref_referenced_sequence_t *src_p)
{
    encoder_append_uint8(encoder_p, src_p->a);
}

static void oer_c_ref_referenced_sequence_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_ref_referenced_sequence_t *dst_p)
{
    dst_p->a = decoder_read_uint8(decoder_p);
}

static void oer_c_ref_referenced_enum_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_ref_referenced_enum_t *src_p)
{
    uint8_t enum_length;

    enum_length = enumerated_value_length(src_p->value);

    if (enum_length != 0u) {
        encoder_append_uint8(encoder_p, 0x80u | enum_length);
        encoder_append_int(encoder_p, (int32_t)src_p->value, enum_length);
    }
    else {
        encoder_append_uint8(encoder_p, (uint8_t)src_p->value);
    }
}

static void oer_c_ref_referenced_enum_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_ref_referenced_enum_t *dst_p)
{
    uint8_t enum_length;

    enum_length = decoder_read_uint8(decoder_p);

    if ((enum_length & 0x80u) == 0x80u) {
        enum_length &= 0x7fu;

        if ((enum_length > 1u) || (enum_length == 0u)) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }
        dst_p->value = (enum oer_c_ref_referenced_enum_e)decoder_read_int(decoder_p, enum_length);
    }
    else {
        dst_p->value = (enum oer_c_ref_referenced_enum_e)enum_length;
    }
}

static void oer_c_source_ap_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_ap_t *src_p)
{
    uint8_t present_mask[1];

    present_mask[0] = 0;

    if (src_p->c.value != oer_c_ref_referenced_enum_a_e) {
        present_mask[0] |= 0x80u;
    }

    if (src_p->d != 1) {
        present_mask[0] |= 0x40u;
    }

    encoder_append_bytes(encoder_p,
                         &present_mask[0],
                         sizeof(present_mask));

    oer_c_ref_referenced_sequence_encode_inner(encoder_p, &src_p->b);

    if (src_p->c.value != oer_c_ref_referenced_enum_a_e) {
        oer_c_ref_referenced_enum_encode_inner(encoder_p, &src_p->c);
    }

    if (src_p->d != 1) {
        encoder_append_uint8(encoder_p, src_p->d);
    }
}

static void oer_c_source_ap_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_ap_t *dst_p)
{
    uint8_t present_mask[1];

    decoder_read_bytes(decoder_p,
                       &present_mask[0],
                       sizeof(present_mask));

    oer_c_ref_referenced_sequence_decode_inner(decoder_p, &dst_p->b);

    if ((present_mask[0] & 0x80u) == 0x80u) {
        oer_c_ref_referenced_enum_decode_inner(decoder_p, &dst_p->c);
    } else {
        dst_p->c.value = oer_c_ref_referenced_enum_a_e;
    }

    if ((present_mask[0] & 0x40u) == 0x40u) {
        dst_p->d = decoder_read_uint8(decoder_p);
    } else {
        dst_p->d = 1;
    }
}

static void oer_c_source_aq_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_aq_t *src_p)
{
    encoder_append_uint32(encoder_p, src_p->value);
}

static void oer_c_source_aq_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_aq_t *dst_p)
{
    dst_p->value = decoder_read_uint32(decoder_p);
}

static void oer_c_source_ar_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_ar_t *src_p)
{
    uint8_t present_mask[1];
    static const uint8_t a_default[] = {0xAB, 0xCD};

    present_mask[0] = 0;

    if ((memcmp(src_p->a.buf, a_default, sizeof(a_default)) != 0) ||
        (src_p->a.length != sizeof(a_default))) {
        present_mask[0] |= 0x80u;
    }

    encoder_append_bytes(encoder_p,
                         &present_mask[0],
                         sizeof(present_mask));

    if ((memcmp(src_p->a.buf, a_default, sizeof(a_default)) != 0) ||
        (src_p->a.length != sizeof(a_default))) {
        encoder_append_uint8(encoder_p, src_p->a.length);
        encoder_append_bytes(encoder_p,
                             &src_p->a.buf[0],
                             src_p->a.length);
    }
}

static void oer_c_source_ar_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_ar_t *dst_p)
{
    uint8_t present_mask[1];
    static const uint8_t a_default[] = {0xAB, 0xCD};

    decoder_read_bytes(decoder_p,
                       &present_mask[0],
                       sizeof(present_mask));

    if ((present_mask[0] & 0x80u) == 0x80u) {
        dst_p->a.length = decoder_read_uint8(decoder_p);

        if (dst_p->a.length > 10u) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }

        decoder_read_bytes(decoder_p,
                           &dst_p->a.buf[0],
                           dst_p->a.length);
    } else {
        memcpy(dst_p->a.buf, a_default, sizeof(a_default));
        dst_p->a.length = sizeof(a_default);
    }
}

static void oer_c_source_as_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_as_t *src_p)
{
    uint8_t present_mask[1];

    present_mask[0] = 0;

    if (src_p->is_a_a_present) {
        present_mask[0] |= 0x80u;
    }

    if (src_p->a_c != true) {
        present_mask[0] |= 0x40u;
    }

    encoder_append_bytes(encoder_p,
                         &present_mask[0],
                         sizeof(present_mask));

    if (src_p->is_a_a_present) {
        encoder_append_bool(encoder_p, src_p->a_a);
    }

    switch (src_p->a_b.choice) {

    case oer_c_source_as_a_b_choice_b_a_e:
        encoder_append_uint(encoder_p, 0x80, 1);
        encoder_append_bool(encoder_p, src_p->a_b.value.b_a);
        break;

    case oer_c_source_as_a_b_choice_b_b_e:
        encoder_append_uint(encoder_p, 0x81, 1);
        encoder_append_bool(encoder_p, src_p->a_b.value.b_b);
        break;

    default:
        encoder_abort(encoder_p, EBADCHOICE);
        break;
    }

    if (src_p->a_c != true) {
        encoder_append_bool(encoder_p, src_p->a_c);
    }
}

static void oer_c_source_as_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_as_t *dst_p)
{
    uint8_t present_mask[1];
    uint32_t tag;

    decoder_read_bytes(decoder_p,
                       &present_mask[0],
                       sizeof(present_mask));

    dst_p->is_a_a_present = ((present_mask[0] & 0x80u) == 0x80u);

    if (dst_p->is_a_a_present) {
        dst_p->a_a = decoder_read_bool(decoder_p);
    }

    tag = decoder_read_tag(decoder_p);

    switch (tag) {

    case 0x80:
        dst_p->a_b.choice = oer_c_source_as_a_b_choice_b_a_e;
        dst_p->a_b.value.b_a = decoder_read_bool(decoder_p);
        break;

    case 0x81:
        dst_p->a_b.choice = oer_c_source_as_a_b_choice_b_b_e;
        dst_p->a_b.value.b_b = decoder_read_bool(decoder_p);
        break;

    default:
        decoder_abort(decoder_p, EBADCHOICE);
        break;
    }

    if ((present_mask[0] & 0x40u) == 0x40u) {
        dst_p->a_c = decoder_read_bool(decoder_p);
    } else {
        dst_p->a_c = true;
    }
}

static void oer_c_ref_at_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_ref_at_t *src_p)
{
    encoder_append_uint(encoder_p, (uint32_t)src_p->value, 1);
}

static void oer_c_ref_at_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_ref_at_t *dst_p)
{
    dst_p->value = (uint8_t)decoder_read_uint(decoder_p, 1);
}

static void oer_c_ref_au_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_ref_au_t *src_p)
{
    uint8_t enum_length;
    uint8_t enum_length_2;

    switch (src_p->a_a.choice) {

    case oer_c_ref_au_a_a_choice_b_a_e:
        encoder_append_uint(encoder_p, 0x80, 1);
        enum_length = enumerated_value_length(src_p->a_a.value.b_a);

        if (enum_length != 0u) {
            encoder_append_uint8(encoder_p, 0x80u | enum_length);
            encoder_append_int(encoder_p, (int32_t)src_p->a_a.value.b_a, enum_length);
        }
        else {
            encoder_append_uint8(encoder_p, (uint8_t)src_p->a_a.value.b_a);
        }
        break;

    case oer_c_ref_au_a_a_choice_b_b_e:
        encoder_append_uint(encoder_p, 0x81, 1);
        enum_length_2 = enumerated_value_length(src_p->a_a.value.b_b);

        if (enum_length_2 != 0u) {
            encoder_append_uint8(encoder_p, 0x80u | enum_length_2);
            encoder_append_int(encoder_p, (int32_t)src_p->a_a.value.b_b, enum_length_2);
        }
        else {
            encoder_append_uint8(encoder_p, (uint8_t)src_p->a_a.value.b_b);
        }
        break;

    default:
        encoder_abort(encoder_p, EBADCHOICE);
        break;
    }
}

static void oer_c_ref_au_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_ref_au_t *dst_p)
{
    uint32_t tag;
    uint8_t enum_length;
    uint8_t enum_length_2;

    tag = decoder_read_tag(decoder_p);

    switch (tag) {

    case 0x80:
        dst_p->a_a.choice = oer_c_ref_au_a_a_choice_b_a_e;
        enum_length = decoder_read_uint8(decoder_p);

        if ((enum_length & 0x80u) == 0x80u) {
            enum_length &= 0x7fu;

            if ((enum_length > 1u) || (enum_length == 0u)) {
                decoder_abort(decoder_p, EBADLENGTH);

                return;
            }
            dst_p->a_a.value.b_a = (enum oer_c_ref_au_a_a_b_a_e)decoder_read_int(decoder_p, enum_length);
        }
        else {
            dst_p->a_a.value.b_a = (enum oer_c_ref_au_a_a_b_a_e)enum_length;
        }
        break;

    case 0x81:
        dst_p->a_a.choice = oer_c_ref_au_a_a_choice_b_b_e;
        enum_length_2 = decoder_read_uint8(decoder_p);

        if ((enum_length_2 & 0x80u) == 0x80u) {
            enum_length_2 &= 0x7fu;

            if ((enum_length_2 > 1u) || (enum_length_2 == 0u)) {
                decoder_abort(decoder_p, EBADLENGTH);

                return;
            }
            dst_p->a_a.value.b_b = (enum oer_c_ref_au_a_a_b_b_e)decoder_read_int(decoder_p, enum_length_2);
        }
        else {
            dst_p->a_a.value.b_b = (enum oer_c_ref_au_a_a_b_b_e)enum_length_2;
        }
        break;

    default:
        decoder_abort(decoder_p, EBADCHOICE);
        break;
    }
}

static void oer_c_source_b_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_b_t *src_p)
{
    switch (src_p->choice) {

    case oer_c_source_b_choice_a_e:
        encoder_append_uint(encoder_p, 0x80, 1);
        encoder_append_int8(encoder_p, src_p->value.a);
        break;

    case oer_c_source_b_choice_b_e:
        encoder_append_uint(encoder_p, 0x81, 1);
        oer_c_source_a_encode_inner(encoder_p, &src_p->value.b);
        break;

    case oer_c_source_b_choice_c_e:
        encoder_append_uint(encoder_p, 0x82, 1);
        break;

    default:
        encoder_abort(encoder_p, EBADCHOICE);
        break;
    }
}

static void oer_c_source_b_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_b_t *dst_p)
{
    uint32_t tag;

    tag = decoder_read_tag(decoder_p);

    switch (tag) {

    case 0x80:
        dst_p->choice = oer_c_source_b_choice_a_e;
        dst_p->value.a = decoder_read_int8(decoder_p);
        break;

    case 0x81:
        dst_p->choice = oer_c_source_b_choice_b_e;
        oer_c_source_a_decode_inner(decoder_p, &dst_p->value.b);
        break;

    case 0x82:
        dst_p->choice = oer_c_source_b_choice_c_e;
        break;

    default:
        decoder_abort(decoder_p, EBADCHOICE);
        break;
    }
}

static void oer_programming_types_bool_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_programming_types_bool_t *src_p)
{
    encoder_append_bool(encoder_p, src_p->value);
}

static void oer_programming_types_bool_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_programming_types_bool_t *dst_p)
{
    dst_p->value = decoder_read_bool(decoder_p);
}

static void oer_c_source_c_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_c_t *src_p)
{
    uint8_t number_of_length_bytes;
    uint8_t i;

    number_of_length_bytes = minimum_uint_length(src_p->length);
    encoder_append_uint8(encoder_p, number_of_length_bytes);
    encoder_append_uint(encoder_p,
                        src_p->length,
                        number_of_length_bytes);

    for (i = 0; i < src_p->length; i++) {
        oer_c_source_b_encode_inner(encoder_p, &src_p->elements[i]);
    }
}

static void oer_c_source_c_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_c_t *dst_p)
{
    uint8_t number_of_length_bytes;
    uint8_t i;

    number_of_length_bytes = decoder_read_uint8(decoder_p);
    dst_p->length = (uint8_t)decoder_read_uint(
        decoder_p,
        number_of_length_bytes);

    if (dst_p->length > 2u) {
        decoder_abort(decoder_p, EBADLENGTH);

        return;
    }

    for (i = 0; i < dst_p->length; i++) {
        oer_c_source_b_decode_inner(decoder_p, &dst_p->elements[i]);
    }
}

static void oer_programming_types_double_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_programming_types_double_t *src_p)
{
    encoder_append_double(encoder_p, src_p->value);
}

static void oer_programming_types_double_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_programming_types_double_t *dst_p)
{
    dst_p->value = decoder_read_double(decoder_p);
}

static void oer_c_source_e_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_e_t *src_p)
{
    switch (src_p->a.choice) {

    case oer_c_source_e_a_choice_b_e:
        encoder_append_uint(encoder_p, 0x80, 1);

        switch (src_p->a.value.b.choice) {

        case oer_c_source_e_a_b_choice_c_e:
            encoder_append_uint(encoder_p, 0x80, 1);
            encoder_append_bool(encoder_p, src_p->a.value.b.value.c);
            break;

        default:
            encoder_abort(encoder_p, EBADCHOICE);
            break;
        }

        break;

    default:
        encoder_abort(encoder_p, EBADCHOICE);
        break;
    }
}

static void oer_c_source_e_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_e_t *dst_p)
{
    uint32_t tag;
    uint32_t tag_2;

    tag = decoder_read_tag(decoder_p);

    switch (tag) {

    case 0x80:
        dst_p->a.choice = oer_c_source_e_a_choice_b_e;
        tag_2 = decoder_read_tag(decoder_p);

        switch (tag_2) {

        case 0x80:
            dst_p->a.value.b.choice = oer_c_source_e_a_b_choice_c_e;
            dst_p->a.value.b.value.c = decoder_read_bool(decoder_p);
            break;

        default:
            decoder_abort(decoder_p, EBADCHOICE);
            break;
        }

        break;

    default:
        decoder_abort(decoder_p, EBADCHOICE);
        break;
    }
}

static void oer_c_source_f_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_f_t *src_p)
{
    uint8_t number_of_length_bytes;
    uint8_t i;
    uint8_t number_of_length_bytes_2;
    uint8_t i_2;

    number_of_length_bytes = minimum_uint_length(src_p->length);
    encoder_append_uint8(encoder_p, number_of_length_bytes);
    encoder_append_uint(encoder_p,
                        src_p->length,
                        number_of_length_bytes);

    for (i = 0; i < src_p->length; i++) {
        number_of_length_bytes_2 = minimum_uint_length(1);
        encoder_append_uint8(encoder_p, number_of_length_bytes_2);
        encoder_append_uint(encoder_p,
                            1,
                            number_of_length_bytes_2);

        for (i_2 = 0; i_2 < 1u; i_2++) {
            encoder_append_bool(encoder_p, src_p->elements[i].elements[i_2]);
        }
    }
}

static void oer_c_source_f_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_f_t *dst_p)
{
    uint8_t number_of_length_bytes;
    uint8_t i;
    uint8_t number_of_length_bytes_2;
    uint8_t i_2;
    uint8_t length;

    number_of_length_bytes = decoder_read_uint8(decoder_p);
    dst_p->length = (uint8_t)decoder_read_uint(
        decoder_p,
        number_of_length_bytes);

    if (dst_p->length > 2u) {
        decoder_abort(decoder_p, EBADLENGTH);

        return;
    }

    for (i = 0; i < dst_p->length; i++) {
        number_of_length_bytes_2 = decoder_read_uint8(decoder_p);
        length = decoder_read_uint8(decoder_p);

        if ((number_of_length_bytes_2 != 1u) || (length > 1u)) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }

        for (i_2 = 0; i_2 < 1u; i_2++) {
            dst_p->elements[i].elements[i_2] = decoder_read_bool(decoder_p);
        }
    }
}

static void oer_programming_types_float_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_programming_types_float_t *src_p)
{
    encoder_append_float(encoder_p, src_p->value);
}

static void oer_programming_types_float_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_programming_types_float_t *dst_p)
{
    dst_p->value = decoder_read_float(decoder_p);
}

static void oer_c_source_g_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_g_t *src_p)
{
    uint8_t present_mask[2];

    present_mask[0] = 0;
    present_mask[1] = 0;

    if (src_p->is_a_present) {
        present_mask[0] |= 0x80u;
    }

    if (src_p->is_b_present) {
        present_mask[0] |= 0x40u;
    }

    if (src_p->is_c_present) {
        present_mask[0] |= 0x20u;
    }

    if (src_p->is_d_present) {
        present_mask[0] |= 0x10u;
    }

    if (src_p->is_e_present) {
        present_mask[0] |= 0x08u;
    }

    if (src_p->is_f_present) {
        present_mask[0] |= 0x04u;
    }

    if (src_p->is_g_present) {
        present_mask[0] |= 0x02u;
    }

    if (src_p->is_h_present) {
        present_mask[0] |= 0x01u;
    }

    if (src_p->is_i_present) {
        present_mask[1] |= 0x80u;
    }

    encoder_append_bytes(encoder_p,
                         &present_mask[0],
                         sizeof(present_mask));

    if (src_p->is_a_present) {
        encoder_append_bool(encoder_p, src_p->a);
    }

    if (src_p->is_b_present) {
        encoder_append_bool(encoder_p, src_p->b);
    }

    if (src_p->is_c_present) {
        encoder_append_bool(encoder_p, src_p->c);
    }

    if (src_p->is_d_present) {
        encoder_append_bool(encoder_p, src_p->d);
    }

    if (src_p->is_e_present) {
        encoder_append_bool(encoder_p, src_p->e);
    }

    if (src_p->is_f_present) {
        encoder_append_bool(encoder_p, src_p->f);
    }

    if (src_p->is_g_present) {
        encoder_append_bool(encoder_p, src_p->g);
    }

    if (src_p->is_h_present) {
        encoder_append_bool(encoder_p, src_p->h);
    }

    if (src_p->is_i_present) {
        encoder_append_bool(encoder_p, src_p->i);
    }
}

static void oer_c_source_g_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_g_t *dst_p)
{
    uint8_t present_mask[2];

    decoder_read_bytes(decoder_p,
                       &present_mask[0],
                       sizeof(present_mask));

    dst_p->is_a_present = ((present_mask[0] & 0x80u) == 0x80u);
    dst_p->is_b_present = ((present_mask[0] & 0x40u) == 0x40u);
    dst_p->is_c_present = ((present_mask[0] & 0x20u) == 0x20u);
    dst_p->is_d_present = ((present_mask[0] & 0x10u) == 0x10u);
    dst_p->is_e_present = ((present_mask[0] & 0x08u) == 0x08u);
    dst_p->is_f_present = ((present_mask[0] & 0x04u) == 0x04u);
    dst_p->is_g_present = ((present_mask[0] & 0x02u) == 0x02u);
    dst_p->is_h_present = ((present_mask[0] & 0x01u) == 0x01u);
    dst_p->is_i_present = ((present_mask[1] & 0x80u) == 0x80u);

    if (dst_p->is_a_present) {
        dst_p->a = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_b_present) {
        dst_p->b = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_c_present) {
        dst_p->c = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_d_present) {
        dst_p->d = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_e_present) {
        dst_p->e = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_f_present) {
        dst_p->f = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_g_present) {
        dst_p->g = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_h_present) {
        dst_p->h = decoder_read_bool(decoder_p);
    }

    if (dst_p->is_i_present) {
        dst_p->i = decoder_read_bool(decoder_p);
    }
}

static void oer_c_source_h_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_h_t *src_p)
{
    (void)encoder_p;
    (void)src_p;
}

static void oer_c_source_h_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_h_t *dst_p)
{
    (void)decoder_p;
    (void)dst_p;
}

static void oer_c_source_i_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_i_t *src_p)
{
    encoder_append_bytes(encoder_p,
                         &src_p->buf[0],
                         24);
}

static void oer_c_source_i_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_i_t *dst_p)
{
    decoder_read_bytes(decoder_p,
                       &dst_p->buf[0],
                       24);
}

static void oer_programming_types_int16_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_programming_types_int16_t *src_p)
{
    encoder_append_int16(encoder_p, src_p->value);
}

static void oer_programming_types_int16_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_programming_types_int16_t *dst_p)
{
    dst_p->value = decoder_read_int16(decoder_p);
}

static void oer_programming_types_int32_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_programming_types_int32_t *src_p)
{
    encoder_append_int32(encoder_p, src_p->value);
}

static void oer_programming_types_int32_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_programming_types_int32_t *dst_p)
{
    dst_p->value = decoder_read_int32(decoder_p);
}

static void oer_programming_types_int64_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_programming_types_int64_t *src_p)
{
    encoder_append_int64(encoder_p, src_p->value);
}

static void oer_programming_types_int64_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_programming_types_int64_t *dst_p)
{
    dst_p->value = decoder_read_int64(decoder_p);
}

static void oer_programming_types_int8_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_programming_types_int8_t *src_p)
{
    encoder_append_int8(encoder_p, src_p->value);
}

static void oer_programming_types_int8_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_programming_types_int8_t *dst_p)
{
    dst_p->value = decoder_read_int8(decoder_p);
}

static void oer_c_source_j_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_j_t *src_p)
{
    encoder_append_uint8(encoder_p, src_p->length);
    encoder_append_bytes(encoder_p,
                         &src_p->buf[0],
                         src_p->length);
}

static void oer_c_source_j_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_j_t *dst_p)
{
    dst_p->length = decoder_read_uint8(decoder_p);

    if (dst_p->length > 23u) {
        decoder_abort(decoder_p, EBADLENGTH);

        return;
    }

    decoder_read_bytes(decoder_p,
                       &dst_p->buf[0],
                       dst_p->length);
}

static void oer_c_source_k_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_k_t *src_p)
{
    uint8_t enum_length;

    enum_length = enumerated_value_length(src_p->value);

    if (enum_length != 0u) {
        encoder_append_uint8(encoder_p, 0x80u | enum_length);
        encoder_append_int(encoder_p, (int32_t)src_p->value, enum_length);
    }
    else {
        encoder_append_uint8(encoder_p, (uint8_t)src_p->value);
    }
}

static void oer_c_source_k_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_k_t *dst_p)
{
    uint8_t enum_length;

    enum_length = decoder_read_uint8(decoder_p);

    if ((enum_length & 0x80u) == 0x80u) {
        enum_length &= 0x7fu;

        if ((enum_length > 1u) || (enum_length == 0u)) {
            decoder_abort(decoder_p, EBADLENGTH);

            return;
        }
        dst_p->value = (enum oer_c_source_k_e)decoder_read_int(decoder_p, enum_length);
    }
    else {
        dst_p->value = (enum oer_c_source_k_e)enum_length;
    }
}

static void oer_c_source_l_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_l_t *src_p)
{
    encoder_append_length_determinant(encoder_p, src_p->length);
    encoder_append_bytes(encoder_p,
                         &src_p->buf[0],
                         src_p->length);
}

static void oer_c_source_l_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_l_t *dst_p)
{
    dst_p->length = decoder_read_length_determinant(decoder_p);

    if (dst_p->length > 500u) {
        decoder_abort(decoder_p, EBADLENGTH);

        return;
    }

    decoder_read_bytes(decoder_p,
                       &dst_p->buf[0],
                       dst_p->length);
}

static void oer_c_source_o_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_o_t *src_p)
{
    uint8_t number_of_length_bytes;
    uint16_t i;

    number_of_length_bytes = minimum_uint_length(src_p->length);
    encoder_append_uint8(encoder_p, number_of_length_bytes);
    encoder_append_uint(encoder_p,
                        src_p->length,
                        number_of_length_bytes);

    for (i = 0; i < src_p->length; i++) {
        encoder_append_bool(encoder_p, src_p->elements[i]);
    }
}

static void oer_c_source_o_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_o_t *dst_p)
{
    uint8_t number_of_length_bytes;
    uint16_t i;

    number_of_length_bytes = decoder_read_uint8(decoder_p);
    dst_p->length = decoder_read_uint(
        decoder_p,
        number_of_length_bytes);

    if (dst_p->length > 260u) {
        decoder_abort(decoder_p, EBADLENGTH);

        return;
    }

    for (i = 0; i < dst_p->length; i++) {
        dst_p->elements[i] = decoder_read_bool(decoder_p);
    }
}

static void oer_c_source_n_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_n_t *src_p)
{
    oer_c_source_k_encode_inner(encoder_p, &src_p->a);
    oer_c_source_a_encode_inner(encoder_p, &src_p->b);
    oer_c_source_o_encode_inner(encoder_p, &src_p->c);
}

static void oer_c_source_n_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_n_t *dst_p)
{
    oer_c_source_k_decode_inner(decoder_p, &dst_p->a);
    oer_c_source_a_decode_inner(decoder_p, &dst_p->b);
    oer_c_source_o_decode_inner(decoder_p, &dst_p->c);
}

static void oer_c_source_m_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_m_t *src_p)
{
    oer_c_source_k_encode_inner(encoder_p, &src_p->a);
    oer_c_source_n_encode_inner(encoder_p, &src_p->b);
}

static void oer_c_source_m_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_m_t *dst_p)
{
    oer_c_source_k_decode_inner(decoder_p, &dst_p->a);
    oer_c_source_n_decode_inner(decoder_p, &dst_p->b);
}

static void oer_c_source_p_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_p_t *src_p)
{
    oer_c_source_a_encode_inner(encoder_p, &src_p->a);
    oer_c_source_m_encode_inner(encoder_p, &src_p->b);
    oer_c_source_f_encode_inner(encoder_p, &src_p->c);
}

static void oer_c_source_p_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_p_t *dst_p)
{
    oer_c_source_a_decode_inner(decoder_p, &dst_p->a);
    oer_c_source_m_decode_inner(decoder_p, &dst_p->b);
    oer_c_source_f_decode_inner(decoder_p, &dst_p->c);
}

static void oer_c_source_r_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_r_t *src_p)
{
    encoder_append_int8(encoder_p, src_p->value);
}

static void oer_c_source_r_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_r_t *dst_p)
{
    dst_p->value = decoder_read_int8(decoder_p);
}

static void oer_c_ref_referenced_int_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_ref_referenced_int_t *src_p)
{
    encoder_append_uint8(encoder_p, src_p->value);
}

static void oer_c_ref_referenced_int_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_ref_referenced_int_t *dst_p)
{
    dst_p->value = decoder_read_uint8(decoder_p);
}

static void oer_c_source_s_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_s_t *src_p)
{
    encoder_append_int8(encoder_p, src_p->value);
}

static void oer_c_source_s_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_s_t *dst_p)
{
    dst_p->value = decoder_read_int8(decoder_p);
}

static void oer_c_source_t_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_t_t *src_p)
{
    encoder_append_int8(encoder_p, src_p->value);
}

static void oer_c_source_t_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_t_t *dst_p)
{
    dst_p->value = decoder_read_int8(decoder_p);
}

static void oer_c_source_u_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_u_t *src_p)
{
    encoder_append_int8(encoder_p, src_p->value);
}

static void oer_c_source_u_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_u_t *dst_p)
{
    dst_p->value = decoder_read_int8(decoder_p);
}

static void oer_programming_types_uint16_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_programming_types_uint16_t *src_p)
{
    encoder_append_uint16(encoder_p, src_p->value);
}

static void oer_programming_types_uint16_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_programming_types_uint16_t *dst_p)
{
    dst_p->value = decoder_read_uint16(decoder_p);
}

static void oer_programming_types_uint32_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_programming_types_uint32_t *src_p)
{
    encoder_append_uint32(encoder_p, src_p->value);
}

static void oer_programming_types_uint32_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_programming_types_uint32_t *dst_p)
{
    dst_p->value = decoder_read_uint32(decoder_p);
}

static void oer_programming_types_uint64_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_programming_types_uint64_t *src_p)
{
    encoder_append_uint64(encoder_p, src_p->value);
}

static void oer_programming_types_uint64_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_programming_types_uint64_t *dst_p)
{
    dst_p->value = decoder_read_uint64(decoder_p);
}

static void oer_programming_types_uint8_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_programming_types_uint8_t *src_p)
{
    encoder_append_uint8(encoder_p, src_p->value);
}

static void oer_programming_types_uint8_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_programming_types_uint8_t *dst_p)
{
    dst_p->value = decoder_read_uint8(decoder_p);
}

static void oer_c_source_v_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_v_t *src_p)
{
    encoder_append_int8(encoder_p, src_p->value);
}

static void oer_c_source_v_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_v_t *dst_p)
{
    dst_p->value = decoder_read_int8(decoder_p);
}

static void oer_c_source_w_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_w_t *src_p)
{
    encoder_append_int16(encoder_p, src_p->value);
}

static void oer_c_source_w_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_w_t *dst_p)
{
    dst_p->value = decoder_read_int16(decoder_p);
}

static void oer_c_source_x_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_x_t *src_p)
{
    encoder_append_int16(encoder_p, src_p->value);
}

static void oer_c_source_x_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_x_t *dst_p)
{
    dst_p->value = decoder_read_int16(decoder_p);
}

static void oer_c_source_y_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_y_t *src_p)
{
    encoder_append_uint16(encoder_p, src_p->value);
}

static void oer_c_source_y_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_y_t *dst_p)
{
    dst_p->value = decoder_read_uint16(decoder_p);
}

static void oer_c_source_z_encode_inner(
    struct encoder_t *encoder_p,
    const struct oer_c_source_z_t *src_p)
{
    encoder_append_bool(encoder_p, src_p->value);
}

static void oer_c_source_z_decode_inner(
    struct decoder_t *decoder_p,
    struct oer_c_source_z_t *dst_p)
{
    dst_p->value = decoder_read_bool(decoder_p);
}

ssize_t oer_c_source_a_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_a_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_a_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_a_decode(
    struct oer_c_source_a_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_a_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_ab_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_ab_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_ab_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_ab_decode(
    struct oer_c_source_ab_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_ab_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_q_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_q_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_q_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_q_decode(
    struct oer_c_source_q_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_q_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_d_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_d_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_d_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_d_decode(
    struct oer_c_source_d_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_d_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_ac_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_ac_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_ac_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_ac_decode(
    struct oer_c_source_ac_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_ac_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_ad_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_ad_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_ad_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_ad_decode(
    struct oer_c_source_ad_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_ad_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_ae_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_ae_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_ae_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_ae_decode(
    struct oer_c_source_ae_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_ae_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_ah_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_ah_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_ah_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_ah_decode(
    struct oer_c_source_ah_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_ah_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_af_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_af_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_af_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_af_decode(
    struct oer_c_source_af_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_af_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_ag_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_ag_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_ag_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_ag_decode(
    struct oer_c_source_ag_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_ag_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_aj_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_aj_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_aj_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_aj_decode(
    struct oer_c_source_aj_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_aj_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_ak_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_ak_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_ak_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_ak_decode(
    struct oer_c_source_ak_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_ak_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_ai_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_ai_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_ai_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_ai_decode(
    struct oer_c_source_ai_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_ai_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_al_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_al_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_al_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_al_decode(
    struct oer_c_source_al_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_al_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_am_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_am_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_am_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_am_decode(
    struct oer_c_source_am_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_am_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_an_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_an_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_an_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_an_decode(
    struct oer_c_source_an_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_an_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_ao_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_ao_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_ao_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_ao_decode(
    struct oer_c_source_ao_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_ao_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_ref_referenced_sequence_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_ref_referenced_sequence_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_ref_referenced_sequence_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_ref_referenced_sequence_decode(
    struct oer_c_ref_referenced_sequence_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_ref_referenced_sequence_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_ref_referenced_enum_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_ref_referenced_enum_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_ref_referenced_enum_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_ref_referenced_enum_decode(
    struct oer_c_ref_referenced_enum_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_ref_referenced_enum_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_ap_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_ap_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_ap_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_ap_decode(
    struct oer_c_source_ap_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_ap_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_aq_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_aq_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_aq_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_aq_decode(
    struct oer_c_source_aq_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_aq_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_ar_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_ar_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_ar_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_ar_decode(
    struct oer_c_source_ar_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_ar_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_as_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_as_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_as_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_as_decode(
    struct oer_c_source_as_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_as_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_ref_at_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_ref_at_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_ref_at_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_ref_at_decode(
    struct oer_c_ref_at_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_ref_at_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_ref_au_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_ref_au_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_ref_au_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_ref_au_decode(
    struct oer_c_ref_au_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_ref_au_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_b_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_b_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_b_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_b_decode(
    struct oer_c_source_b_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_b_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_programming_types_bool_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_programming_types_bool_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_programming_types_bool_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_programming_types_bool_decode(
    struct oer_programming_types_bool_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_programming_types_bool_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_c_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_c_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_c_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_c_decode(
    struct oer_c_source_c_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_c_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_programming_types_double_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_programming_types_double_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_programming_types_double_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_programming_types_double_decode(
    struct oer_programming_types_double_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_programming_types_double_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_e_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_e_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_e_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_e_decode(
    struct oer_c_source_e_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_e_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_f_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_f_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_f_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_f_decode(
    struct oer_c_source_f_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_f_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_programming_types_float_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_programming_types_float_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_programming_types_float_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_programming_types_float_decode(
    struct oer_programming_types_float_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_programming_types_float_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_g_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_g_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_g_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_g_decode(
    struct oer_c_source_g_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_g_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_h_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_h_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_h_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_h_decode(
    struct oer_c_source_h_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_h_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_i_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_i_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_i_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_i_decode(
    struct oer_c_source_i_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_i_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_programming_types_int16_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_programming_types_int16_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_programming_types_int16_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_programming_types_int16_decode(
    struct oer_programming_types_int16_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_programming_types_int16_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_programming_types_int32_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_programming_types_int32_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_programming_types_int32_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_programming_types_int32_decode(
    struct oer_programming_types_int32_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_programming_types_int32_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_programming_types_int64_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_programming_types_int64_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_programming_types_int64_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_programming_types_int64_decode(
    struct oer_programming_types_int64_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_programming_types_int64_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_programming_types_int8_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_programming_types_int8_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_programming_types_int8_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_programming_types_int8_decode(
    struct oer_programming_types_int8_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_programming_types_int8_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_j_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_j_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_j_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_j_decode(
    struct oer_c_source_j_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_j_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_k_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_k_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_k_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_k_decode(
    struct oer_c_source_k_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_k_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_l_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_l_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_l_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_l_decode(
    struct oer_c_source_l_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_l_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_o_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_o_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_o_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_o_decode(
    struct oer_c_source_o_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_o_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_n_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_n_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_n_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_n_decode(
    struct oer_c_source_n_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_n_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_m_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_m_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_m_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_m_decode(
    struct oer_c_source_m_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_m_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_p_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_p_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_p_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_p_decode(
    struct oer_c_source_p_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_p_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_r_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_r_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_r_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_r_decode(
    struct oer_c_source_r_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_r_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_ref_referenced_int_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_ref_referenced_int_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_ref_referenced_int_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_ref_referenced_int_decode(
    struct oer_c_ref_referenced_int_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_ref_referenced_int_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_s_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_s_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_s_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_s_decode(
    struct oer_c_source_s_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_s_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_t_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_t_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_t_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_t_decode(
    struct oer_c_source_t_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_t_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_u_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_u_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_u_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_u_decode(
    struct oer_c_source_u_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_u_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_programming_types_uint16_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_programming_types_uint16_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_programming_types_uint16_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_programming_types_uint16_decode(
    struct oer_programming_types_uint16_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_programming_types_uint16_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_programming_types_uint32_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_programming_types_uint32_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_programming_types_uint32_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_programming_types_uint32_decode(
    struct oer_programming_types_uint32_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_programming_types_uint32_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_programming_types_uint64_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_programming_types_uint64_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_programming_types_uint64_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_programming_types_uint64_decode(
    struct oer_programming_types_uint64_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_programming_types_uint64_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_programming_types_uint8_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_programming_types_uint8_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_programming_types_uint8_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_programming_types_uint8_decode(
    struct oer_programming_types_uint8_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_programming_types_uint8_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_v_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_v_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_v_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_v_decode(
    struct oer_c_source_v_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_v_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_w_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_w_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_w_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_w_decode(
    struct oer_c_source_w_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_w_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_x_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_x_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_x_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_x_decode(
    struct oer_c_source_x_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_x_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_y_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_y_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_y_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_y_decode(
    struct oer_c_source_y_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_y_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}

ssize_t oer_c_source_z_encode(
    uint8_t *dst_p,
    size_t size,
    const struct oer_c_source_z_t *src_p)
{
    struct encoder_t encoder;

    encoder_init(&encoder, dst_p, size);
    oer_c_source_z_encode_inner(&encoder, src_p);

    return (encoder_get_result(&encoder));
}

ssize_t oer_c_source_z_decode(
    struct oer_c_source_z_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    struct decoder_t decoder;

    decoder_init(&decoder, src_p, size);
    oer_c_source_z_decode_inner(&decoder, dst_p);

    return (decoder_get_result(&decoder));
}
