#ifndef AVM_DEFAULT_H
#define AVM_DEFAULT_H

#ifndef	WIN32

#ifdef HAVE_CONFIG_H
#include "config.h"	/* to get the HAVE_xxx_H defines */
#else
/* we need something for int typedefs */
#include <inttypes.h>	/* for int64_t and __WORDSIZE */
#define AVMEXPORT
#define AVMPACKED
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_INTTYPES_H
#include <inttypes.h>	/* for int64_t and __WORDSIZE */
#elif HAVE_STDINT_H
#include <stdint.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifndef PRId64
#define PRId64 "lld"    /* pick some default */
#endif

#define PRIsz __PRIPTR_PREFIX "u"    /* pick some default */

#ifndef __WINE_WINDEF_H
typedef long HRESULT;
#endif /* __WINE_WINDEF_H */

#else /* WIN32 */

# define __attribute__()

/* '<Unknown'> has C-linkage specified, but returns UDT 'basic_string<char, struct ...' */
# pragma warning (disable: 4190)

/* 'std::_Tree(std::basic_string<... ': identifier was truncated to '255' characters in the debug information */
# pragma warning (disable: 4786)

/* 'unsigned char': forcing value to bool 'true' or 'false' */
# pragma warning (disable: 4800)
typedef __int64  int64_t;
typedef __int32  int32_t;
typedef __int16  int16_t;
typedef __int8   int8_t;

typedef __uint64 uint64_t;
typedef __uint32 uint32_t;
typedef __uint16 uint16_t;
typedef __uint8  uint8_t;
#endif /* WIN32 */

#define E_ERROR -2

typedef uint32_t fourcc_t;
typedef uint32_t framepos_t;
typedef unsigned int uint_t;    /* use as generic type */

//typedef unsigned streamid_t;	/* \obsolete use uint_t */
//typedef unsigned Unsigned; 	/* \obsolete use uint_t */

#ifdef X_DISPLAY_MISSING
typedef int Display;
#endif

#if defined(__GNUC__) && \
    ((__GNUC__ > 2) || ((__GNUC__ == 2) && (__GNUC_MINOR__ > 4)))
#   define _avm_printf_attr(a,b) __attribute((__format__(__printf__,a,b)))
#else
#   define _avm_printf_attr(a,b)
#endif

#if defined(__GNUC__) && (__GNUC__ > 3 || __GNUC__ == 3 && __GNUC_MINOR__ > 1)
#   define _avm_deprecated __attribute__((__deprecated__))
#else
#   define _avm_deprecated
#endif


#ifdef __cplusplus
#   define AVM_BEGIN_EXTERN_C  extern "C" {
#   define AVM_END_EXTERN_C    }
#   define AVM_BEGIN_NAMESPACE namespace avm {
#   define AVM_END_NAMESPACE   }
#else
#   define AVM_BEGIN_EXTERN_C
#   define AVM_END_EXTERN_C
#   define AVM_BEGIN_NAMESPACE
#   define AVM_END_NAMESPACE
#endif

/**
 * \namespace avm
 *
 * encupsulates functions & classes from the avifile library
 *
 * \author Zdenek Kabelac (kabi@users.sourceforge.net)
 * \author Eugene Kuznetsov (divx@euro.ru)
 */

#define AVM_COMPATIBLE  /* define & build backward compatible code */

#endif /* AVM_DEFAULT_H */
