//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _complex_eriroot_3.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot3(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[3] = {1.901635091934882e-01,1.784492748543252e+00,5.525343742263258e+00};
  static constexpr double aw[3] = {7.246295952243923e-01,1.570673203228564e-01,4.530009905508835e-03};
  static constexpr double xr[7980] = {   1.327781722192905e-01,  -1.017514457331557e-02,   5.390747801314956e-04,  -2.239961951207812e-05,   6.928949964468520e-07,
  -1.035517218627396e-08,  -4.769644305909750e-10,   4.670124652063590e-11,  -2.035835712403120e-12,   4.999466711086827e-14,   1.244513656046184e-16,  -9.100346306508073e-17,
   5.527561498386391e-18,  -1.874065141645784e-19,   1.328294842908646e-01,  -1.018147566803596e-02,   5.394603587688861e-04,  -2.240853159462740e-05,   6.921615738259517e-07,
  -1.026079414859219e-08,  -4.822712414892390e-10,   4.685629924971881e-11,  -2.034196740359122e-12,   4.947716760464390e-14,   1.590452939350042e-16,  -9.226196156541623e-17,
   5.537621213061339e-18,  -1.854548458437993e-19,   1.329200541242661e-01,  -1.019264888288785e-02,   5.401403681955490e-04,  -2.242418443225227e-05,   6.908613869423209e-07,
  -1.009402126583257e-08,  -4.916310185740234e-10,   4.712843720312445e-11,  -2.031185801192819e-12,   4.855887419884719e-14,   2.201253771121093e-16,  -9.447028983840042e-17,
   5.554285151389222e-18,  -1.819583088391625e-19,   1.330296213493970e-01,  -1.020616287938516e-02,   5.409620439459590e-04,  -2.244298797626519e-05,   6.892788731165679e-07,
  -9.891947815380606e-09,  -5.029416695165838e-10,   4.745501883867185e-11,  -2.027342053310717e-12,   4.743970668787789e-14,   2.940460273990205e-16,  -9.711941823256738e-17,
   5.572577444711920e-18,  -1.776405691803353e-19,   1.331360388255649e-01,  -1.021928539640142e-02,   5.417590829558892e-04,  -2.246111208803532e-05,   6.877318002508072e-07,
  -9.695351244128029e-09,  -5.139139958190455e-10,   4.776943848444855e-11,  -2.023398058682488e-12,   4.634411454321407e-14,   3.658669740056465e-16,  -9.966866929433592e-17,
   5.588383180723706e-18,  -1.733554734990383e-19,   1.332218042487767e-01,  -1.022985912470252e-02,   5.424007144241823e-04,  -2.247561935193865e-05,   6.864777667571596e-07,
  -9.536671011620341e-09,  -5.227473723676692e-10,   4.802084500363277e-11,  -2.020068477712231e-12,   4.545501597294154e-14,   4.237646168010797e-16,  -1.017060180888614e-16,
   5.599712904587103e-18,  -1.698367554022409e-19,   1.332784945664512e-01,  -1.023684722651804e-02,   5.428244706837766e-04,  -2.248515977477239e-05,   6.856453395347784e-07,
  -9.431669399722792e-09,  -5.285814135709437e-10,   4.818604315533338e-11,  -2.017793733126420e-12,   4.486434459486360e-14,   4.620403687109052e-16,  -1.030442070585730e-16,
   5.606510575329500e-18,  -1.674791133753680e-19,   1.333076133388056e-01,  -1.024043631226310e-02,   5.430420208786836e-04,  -2.249004509010448e-05,   6.852166783247341e-07,
  -9.377700237271667e-09,  -5.315765635707985e-10,   4.827059296059317e-11,  -2.016602462537334e-12,   4.456002885835546e-14,   4.817020775074525e-16,  -1.037289238308701e-16,
   5.609788110705971e-18,  -1.662583159292706e-19,   1.333177492826534e-01,  -1.024168558383116e-02,   5.431177302310772e-04,  -2.249174321558709e-05,   6.850672926267685e-07,
  -9.358908494264570e-09,  -5.326189069935111e-10,   4.829997548326782e-11,  -2.016184155084566e-12,   4.445395358421153e-14,   4.885463294693740e-16,  -1.039668451638185e-16,
   5.610894881444631e-18,  -1.658318109251503e-19,   1.333193577595231e-01,  -1.024188382874742e-02,   5.431297437408488e-04,  -2.249201257772793e-05,   6.850435783330951e-07,
  -9.355926157992778e-09,  -5.327843055856611e-10,   4.830463590883057e-11,  -2.016117600989738e-12,   4.443711352723166e-14,   4.896324561153914e-16,  -1.040045809551773e-16,
   5.611068895706428e-18,  -1.657640547705391e-19,   9.509468933444982e-01,  -3.849650755054115e-02,   4.910155817668096e-05,   3.831476115262514e-05,  -7.064643441610874e-08,
  -7.044338569582670e-08,   2.292216278700587e-10,   1.426405658061378e-10,  -5.941374805531948e-13,  -2.886076030544505e-13,   1.350055095862667e-15,   6.026537751551013e-16,
  -3.426676447449942e-18,  -1.281132278287986e-18,   9.509514203120252e-01,  -3.848595583569343e-02,   4.906353376785986e-05,   3.825094852695634e-05,  -7.034114786868515e-08,
  -7.017675776850329e-08,   2.277659975611108e-10,   1.417382262662232e-10,  -5.890197860298463e-13,  -2.858105355725285e-13,   1.331658182872883e-15,   5.944937779529360e-16,
  -3.364323900371198e-18,  -1.258583291186914e-18,   9.509594055196731e-01,  -3.846735137764986e-02,   4.899657475142728e-05,   3.813854905149904e-05,  -6.980408895657922e-08,
  -6.970769810436345e-08,   2.252080935084561e-10,   1.401534848014827e-10,  -5.800502213825825e-13,  -2.809080658800323e-13,   1.299496526147529e-15,   5.802233224265842e-16,
  -3.255552258981281e-18,  -1.219250062624661e-18,   9.509690567245480e-01,  -3.844487886545651e-02,   4.891583799707928e-05,   3.800297283936068e-05,  -6.915743258848891e-08,
  -6.914290149283525e-08,   2.221329995730401e-10,   1.382498422363514e-10,  -5.693069203544882e-13,  -2.750358566131651e-13,   1.261113629488332e-15,   5.631837725859080e-16,
  -3.126134542215244e-18,  -1.172455394152075e-18,   9.509784211450211e-01,  -3.842308824060228e-02,   4.883770122152789e-05,   3.787171129143127e-05,  -6.853255083728089e-08,
  -6.859710495137540e-08,   2.191664401228333e-10,   1.364149824670611e-10,  -5.589842835226887e-13,  -2.693933112311022e-13,   1.224378150383086e-15,   5.468664540779311e-16,
  -3.002680031683270e-18,  -1.127821534063773e-18,   9.509859615653784e-01,  -3.840555209781683e-02,   4.877492753440803e-05,   3.776622132907644e-05,  -6.803121130070715e-08,
  -6.815920120266569e-08,   2.167899318432373e-10,   1.349462209431913e-10,  -5.507443959410739e-13,  -2.648890560585980e-13,   1.195157686218334e-15,   5.338806168456922e-16,
  -2.904770722651849e-18,  -1.092426628377023e-18,   9.509909424612681e-01,  -3.839397337907779e-02,   4.873353197689355e-05,   3.769663887878773e-05,  -6.770093937245931e-08,
  -6.787071226911321e-08,   2.152260652663278e-10,   1.339802593674414e-10,  -5.453365407622119e-13,  -2.619328214609062e-13,   1.176030552338312e-15,   5.253771115983051e-16,
  -2.840822270154072e-18,  -1.069310435179887e-18,   9.509934998707086e-01,  -3.838802988824938e-02,   4.871229937199724e-05,   3.766094308038526e-05,  -6.753163891065467e-08,
  -6.772282786365115e-08,   2.144249447998193e-10,   1.334856005532443e-10,  -5.425707131167160e-13,  -2.604208416699547e-13,   1.166263586733210e-15,   5.210339273914113e-16,
  -2.808211456295357e-18,  -1.057522725948132e-18,   9.509943899179143e-01,  -3.838596163709086e-02,   4.870491330443272e-05,   3.764852489460132e-05,  -6.747276162854256e-08,
  -6.767139802800203e-08,   2.141464252821688e-10,   1.333136538773683e-10,  -5.416098461637585e-13,  -2.598955660153484e-13,   1.162872949847076e-15,   5.195260150580290e-16,
  -2.796897399833266e-18,  -1.053433156147764e-18,   9.509945311522290e-01,  -3.838563345477519e-02,   4.870374143346749e-05,   3.764655458731048e-05,  -6.746342095378872e-08,
  -6.766323884673702e-08,   2.141022431456850e-10,   1.332863789268473e-10,  -5.414574553933061e-13,  -2.598122586094805e-13,   1.162335321806988e-15,   5.192869089999884e-16,
  -2.795103741707396e-18,  -1.052784825714795e-18,   1.770457310337109e+00,  -1.471526561070790e-02,  -6.262060343670300e-04,  -1.899255490423131e-05,  -2.958361655917877e-07,
   8.653449772827943e-09,   9.663207453414977e-10,   3.944599502085844e-11,   5.247280376146027e-13,  -2.908391842531127e-14,  -2.191079709355928e-15,  -7.809825094317753e-17,
  -1.071178520960434e-18,   7.267780399521308e-20,   1.770398285341477e+00,  -1.472057630033577e-02,  -6.263646870615211e-04,  -1.898380574788466e-05,  -2.944635868140046e-07,
   8.729370637255099e-09,   9.675042371612182e-10,   3.933807302413819e-11,   5.153559249600000e-13,  -2.946225222276807e-14,  -2.195430216975562e-15,  -7.748471916719257e-17,
  -1.021901464098484e-18,   7.420148275905035e-20,   1.770294123642942e+00,  -1.472994498526620e-02,  -6.266440014270674e-04,  -1.896831040158722e-05,  -2.920403733232569e-07,
   8.863156693641572e-09,   9.695724538390184e-10,   3.914662305990590e-11,   4.988057614252980e-13,  -3.012717384162022e-14,  -2.202859834336851e-15,  -7.639341030775009e-17,
  -9.350340207299087e-19,   7.686528323050207e-20,   1.770168151200026e+00,  -1.474127009185176e-02,  -6.269806753903174e-04,  -1.894947561918868e-05,  -2.891080366557528e-07,
   9.024628462166462e-09,   9.720391201127388e-10,   3.891338578410276e-11,   4.787716700001484e-13,  -3.092665383059340e-14,  -2.211423111680173e-15,  -7.505901823191278e-17,
  -8.301410614392020e-19,   8.004391751711602e-20,   1.770045839474769e+00,  -1.475226052048209e-02,  -6.273063854517929e-04,  -1.893108900830085e-05,  -2.862591320964155e-07,
   9.181062961369904e-09,   9.743978366108371e-10,   3.868515383292347e-11,   4.593011892245086e-13,  -3.169797899522335e-14,  -2.219296075952492e-15,  -7.374827835087601e-17,
  -7.284768743149698e-19,   8.308489637922030e-20,   1.769947292541201e+00,  -1.476111154427893e-02,  -6.275679652831916e-04,  -1.891620390385925e-05,  -2.839624988050177e-07,
   9.306854652804368e-09,   9.762722652891481e-10,   3.850000144018533e-11,   4.436009722388884e-13,  -3.231589028398440e-14,  -2.225323405630776e-15,  -7.268146895816741e-17,
  -6.467014338771461e-19,   8.550235995720985e-20,   1.769882167543322e+00,  -1.476695880688662e-02,  -6.277404168465155e-04,  -1.890633234013839e-05,  -2.824441502784502e-07,
   9.389862595590766e-09,   9.774982541702526e-10,   3.837702545621408e-11,   4.332193888998267e-13,  -3.272249306402117e-14,  -2.229152042517980e-15,  -7.197124391109240e-17,
  -5.927289035260923e-19,   8.708386891909577e-20,   1.769848720597209e+00,  -1.476996124209140e-02,  -6.278288565649239e-04,  -1.890125177067518e-05,  -2.816641674649902e-07,
   9.432456125629281e-09,   9.781239602020959e-10,   3.831367679093792e-11,   4.278857795926210e-13,  -3.293077483339028e-14,  -2.231070597748574e-15,  -7.160487948218326e-17,
  -5.650315233221048e-19,   8.789111113646588e-20,   1.769837078740286e+00,  -1.477100620120185e-02,  -6.278596193283721e-04,  -1.889948167356982e-05,  -2.813926494917186e-07,
   9.447275611009604e-09,   9.783411222575560e-10,   3.829159676080452e-11,   4.260290266126685e-13,  -3.300318495352873e-14,  -2.231730787805554e-15,  -7.147710422835280e-17,
  -5.553944442868629e-19,   8.817129134942389e-20,   1.769835231321741e+00,  -1.477117201868879e-02,  -6.278645000299340e-04,  -1.889920070007488e-05,  -2.813495615358997e-07,
   9.449626994055902e-09,   9.783755534181331e-10,   3.828809149567711e-11,   4.257343693585311e-13,  -3.301467143906006e-14,  -2.231835191049054e-15,  -7.145681578575171e-17,
  -5.538653277288704e-19,   8.821571465628687e-20,   9.924278448633855e-02,  -6.767299961479447e-03,   3.288892144843975e-04,  -1.325937190162147e-05,   4.459518504564292e-07,
  -1.190094352791663e-08,   1.682600947120973e-10,   6.922524028496987e-12,  -6.165547028273916e-13,   2.465393014576452e-14,  -6.902930209242139e-16,   1.206133086316178e-17,
   1.798284271717016e-19,  -3.113935626910344e-20,   9.927412380914129e-02,  -6.771067974115814e-03,   3.291412740680010e-04,  -1.327040175687746e-05,   4.461685408609006e-07,
  -1.188596742053884e-08,   1.665829468383705e-10,   7.007053562792847e-12,  -6.194061480983318e-13,   2.470619975323139e-14,  -6.885090896194560e-16,   1.181000123346796e-17,
   1.942887816488127e-19,  -3.157095153374501e-20,   9.932944188941260e-02,  -6.777719191190803e-03,   3.295861315414862e-04,  -1.328985227926192e-05,   4.465489540182610e-07,
  -1.185940591197097e-08,   1.636175462335507e-10,   7.156343298658411e-12,  -6.244308585132204e-13,   2.479735267232649e-14,  -6.852883768456372e-16,   1.136399243038502e-17,
   2.198226481995480e-19,  -3.233017476508443e-20,   9.939636610425244e-02,  -6.785766173828393e-03,   3.301242182481952e-04,  -1.331335181508429e-05,   4.470056403022851e-07,
  -1.182705553461914e-08,   1.600214522540240e-10,   7.337095952590873e-12,  -6.304951799791877e-13,   2.490573109377060e-14,  -6.812694342026209e-16,   1.082036372393109e-17,
   2.507287283527909e-19,  -3.324417589090189e-20,   9.946136953720039e-02,  -6.793582503667181e-03,   3.306467505816713e-04,  -1.333614346770366e-05,   4.474455077098206e-07,
  -1.179540730559335e-08,   1.565196539551439e-10,   7.512805630788489e-12,  -6.363699391990808e-13,   2.500900207850395e-14,  -6.772375495401089e-16,   1.028811797809843e-17,
   2.807621849782297e-19,  -3.412711740818699e-20,   9.951376022582532e-02,  -6.799882429975158e-03,   3.310678149851598e-04,  -1.335448880827262e-05,   4.477973645952705e-07,
  -1.176973763797638e-08,   1.536909418920423e-10,   7.654523822853842e-12,  -6.410935447721294e-13,   2.509079871353445e-14,  -6.738960614653090e-16,   9.856132569734936e-18,
   3.049775709764892e-19,  -3.483521007962527e-20,   9.954839118828845e-02,  -6.804046871529415e-03,   3.313461049566811e-04,  -1.336660355629759e-05,   4.480286422401484e-07,
  -1.175269020294315e-08,   1.518180087795811e-10,   7.748250556309313e-12,  -6.442103383885879e-13,   2.514416179480687e-14,  -6.716422890712520e-16,   9.569113917368991e-18,
   3.209884818801346e-19,  -3.530151185322847e-20,   9.956617959577582e-02,  -6.806185994585721e-03,   3.314890380972932e-04,  -1.337282272599957e-05,   4.481470357535696e-07,
  -1.174390911530401e-08,   1.508550027645892e-10,   7.796408878929986e-12,  -6.458095620165502e-13,   2.517135337395791e-14,  -6.704707083350730e-16,   9.421231275033030e-18,
   3.292138045054176e-19,  -3.554048107872712e-20,   9.957237161113189e-02,  -6.806930612844550e-03,   3.315387901351669e-04,  -1.337498699304646e-05,   4.481881833904472e-07,
  -1.174084857122871e-08,   1.505196342686180e-10,   7.813174815363115e-12,  -6.463659625346118e-13,   2.518078370617286e-14,  -6.700606741720547e-16,   9.369682255443885e-18,
   3.320771663178263e-19,  -3.562357649412258e-20,   9.957335422704398e-02,  -6.807048777157093e-03,   3.315466852335621e-04,  -1.337533041475373e-05,   4.481947100899735e-07,
  -1.174036270533754e-08,   1.504664071054668e-10,   7.815835527757154e-12,  -6.464542449802319e-13,   2.518227855749765e-14,  -6.699955003497838e-16,   9.361498476740999e-18,
   3.325315642323250e-19,  -3.563675878231996e-20,   8.005001359146766e-01,  -3.638274008072134e-02,   4.599460070134404e-04,   2.742148355979601e-05,  -1.147827401610924e-06,
  -2.728231398470885e-08,   2.720057524050214e-09,   8.785469905481278e-12,  -5.434245571166817e-12,   7.452926620283711e-14,   9.307478312606788e-15,  -3.190036170844114e-16,
  -1.334810167512606e-17,   8.944393776411586e-19,   8.005420014941917e-01,  -3.637511723055423e-02,   4.593209660344722e-04,   2.739608313695294e-05,  -1.144160968157562e-06,
  -2.726167664843424e-08,   2.706545093305954e-09,   9.000521657555977e-12,  -5.397452110947142e-12,   7.309796496543226e-14,   9.229815489501489e-15,  -3.133761434920728e-16,
  -1.324202019033296e-17,   8.774234139383490e-19,   8.006158287487372e-01,  -3.636167236731569e-02,   4.582197111395361e-04,   2.735128041871780e-05,  -1.137706644180290e-06,
  -2.722493512089873e-08,   2.682779231849435e-09,   9.376210350254435e-12,  -5.332791500918304e-12,   7.059508860807350e-14,   9.093313999313319e-15,  -3.035431843354577e-16,
  -1.305462154502876e-17,   8.477242726978241e-19,   8.007050244304919e-01,  -3.634542454036341e-02,   4.568908532270685e-04,   2.729713317615209e-05,  -1.129927788790095e-06,
  -2.717995396354432e-08,   2.654172271073632e-09,   9.824104510805164e-12,  -5.255048721337098e-12,   6.760697910136056e-14,   8.929169031289733e-15,  -2.918168368051972e-16,
  -1.282768360037282e-17,   8.123625313611447e-19,   8.007915334972106e-01,  -3.632966173743356e-02,   4.556037380640674e-04,   2.724459821165830e-05,  -1.122403133885759e-06,
  -2.713571312504309e-08,   2.626537800154071e-09,   1.025227082667414e-11,  -5.180042312125424e-12,   6.474603732327632e-14,   8.770777786493378e-15,  -2.806029643813239e-16,
  -1.260707109717746e-17,   7.786047378861617e-19,   8.008611664284420e-01,  -3.631697081013115e-02,   4.545689407661270e-04,   2.720229853867860e-05,  -1.116360607048364e-06,
  -2.709966564703209e-08,   2.604373415327331e-09,   1.059247431147841e-11,  -5.119950113798778e-12,   6.246962075919870e-14,   8.643866541511908e-15,  -2.716897746247987e-16,
  -1.242916056816120e-17,   7.518146584263713e-19,   8.009071504316162e-01,  -3.630858848468849e-02,   4.538861848047563e-04,   2.717435840524984e-05,  -1.112377210654534e-06,
  -2.707564796149928e-08,   2.589775228613110e-09,   1.081497765998654e-11,  -5.080404352193496e-12,   6.097917525551284e-14,   8.560342207100225e-15,  -2.658586674185596e-16,
  -1.231152059959564e-17,   7.343087493375286e-19,   8.009307567033140e-01,  -3.630428487669447e-02,   4.535358719329005e-04,   2.716001314256424e-05,  -1.110334447779794e-06,
  -2.706325275424744e-08,   2.582293066509467e-09,   1.092853653868405e-11,  -5.060145742324416e-12,   6.021799816875555e-14,   8.517552512240438e-15,  -2.628821306539494e-16,
  -1.225108471299694e-17,   7.253790393691511e-19,   8.009389716955901e-01,  -3.630278714436048e-02,   4.534139924438476e-04,   2.715502067417416e-05,  -1.109623907015474e-06,
  -2.705892880834030e-08,   2.579691169985661e-09,   1.096794943266471e-11,  -5.053102503928035e-12,   5.995373638777266e-14,   8.502675733737387e-15,  -2.618489792680445e-16,
  -1.223004615187538e-17,   7.222805580468837e-19,   8.009402752359021e-01,  -3.630254948330842e-02,   4.533946542259268e-04,   2.715422846345951e-05,  -1.109511175885557e-06,
  -2.705824219865546e-08,   2.579278395806073e-09,   1.097419838987784e-11,  -5.051985216531008e-12,   5.991183358944266e-14,   8.500315780390464e-15,  -2.616851679469471e-16,
  -1.222670746999592e-17,   7.217893261743298e-19,   1.700049932828146e+00,  -2.069374607968017e-02,  -8.716573002802250e-04,  -2.069132192177624e-05,   2.015610922364055e-07,
   4.525431378739569e-08,   1.988598471090012e-09,   1.594855347313885e-11,  -2.871174750193210e-12,  -1.714056715451901e-13,  -3.449008385643582e-15,   1.434742224524892e-16,
   1.408920219937030e-17,   4.499532352772757e-19,   1.699968473601031e+00,  -2.069941539344857e-02,  -8.715287090133402e-04,  -2.064871468216598e-05,   2.042652711057017e-07,
   4.527691748175911e-08,   1.980824841291929e-09,   1.539241356991508e-11,  -2.883035298309386e-12,  -1.705632975456910e-13,  -3.364852700621326e-15,   1.461989334964098e-16,
   1.402812034783139e-17,   4.396859580988334e-19,   1.699824749104208e+00,  -2.070940921628812e-02,  -8.713005929160413e-04,  -2.057351899878039e-05,   2.090278601000760e-07,
   4.531592309921589e-08,   1.967084460271343e-09,   1.441348071258416e-11,  -2.903677565315809e-12,  -1.690660718766215e-13,  -3.216697112979144e-15,   1.509458499290655e-16,
   1.391749254092829e-17,   4.215791769966710e-19,   1.699650975729916e+00,  -2.072147719263021e-02,  -8.710226840322713e-04,  -2.048256723780996e-05,   2.147715093388236e-07,
   4.536159308809086e-08,   1.950429467946119e-09,   1.323383051480405e-11,  -2.928151844406793e-12,  -1.672372959743787e-13,  -3.038132405936531e-15,   1.565821316301346e-16,
   1.377891001044902e-17,   3.997043833561058e-19,   1.699482300380276e+00,  -2.073317512602295e-02,  -8.707507324606686e-04,  -2.039424793388679e-05,   2.203312750932882e-07,
   4.540436552914617e-08,   1.934219755098046e-09,   1.209295013073858e-11,  -2.951402601728528e-12,  -1.654429955756972e-13,  -2.865411259063222e-15,   1.619451885061328e-16,
   1.363939774972384e-17,   3.784936895198458e-19,   1.699346432693020e+00,  -2.074258632548536e-02,  -8.705301049965179e-04,  -2.032308161023178e-05,   2.247986209083619e-07,
   4.543770485185534e-08,   1.921132177284020e-09,   1.117697267605117e-11,  -2.969769580415822e-12,  -1.639841050517928e-13,  -2.726726598114930e-15,   1.661878907032868e-16,
   1.352348251916405e-17,   3.614272601545145e-19,   1.699256661102206e+00,  -2.074879895584939e-02,  -8.703835619730000e-04,  -2.027604779546822e-05,   2.277449122728586e-07,
   4.545918865745935e-08,   1.912469970416148e-09,   1.057323637846700e-11,  -2.981728474816416e-12,  -1.630135859554528e-13,  -2.635313511168333e-15,   1.689533746908974e-16,
   1.344517808072483e-17,   3.501612640841923e-19,   1.699210561374564e+00,  -2.075198754523040e-02,  -8.703080714388867e-04,  -2.025189112563545e-05,   2.292562248797095e-07,
   4.547005290424545e-08,   1.908017162888625e-09,   1.026366209025175e-11,  -2.987815058601013e-12,  -1.625131780843834e-13,  -2.588439518584122e-15,   1.703618321619300e-16,
   1.340443981921464e-17,   3.443793308252853e-19,   1.699194516305521e+00,  -2.075309706149556e-02,  -8.702817590847148e-04,  -2.024348277174610e-05,   2.297819725162107e-07,
   4.547380746381934e-08,   1.906466632793128e-09,   1.015598738761679e-11,  -2.989924818815742e-12,  -1.623386893576065e-13,  -2.572135963338485e-15,   1.708501885288646e-16,
   1.339017720110738e-17,   3.423674848080539e-19,   1.699191970191297e+00,  -2.075327311213441e-02,  -8.702775819117126e-04,  -2.024214846268173e-05,   2.298653881990777e-07,
   4.547440198686275e-08,   1.906220552338319e-09,   1.013890448036903e-11,  -2.990259194339145e-12,  -1.623109853661977e-13,  -2.569549354575302e-15,   1.709275951885721e-16,
   1.338790997225856e-17,   3.420482618699849e-19,   7.657753327112257e-02,  -4.667805510729711e-03,   2.055472885155675e-04,  -7.774250165859791e-06,   2.553641152554089e-07,
  -7.110508269777995e-09,   1.873844202382132e-10,  -2.896984953326840e-12,  -1.004776079485176e-13,   7.055945351308811e-15,  -2.364723060629494e-16,   6.928416463489080e-18,
  -1.111013712554442e-19,   3.448492439250388e-21,   7.659709462294113e-02,  -4.670015659619426e-03,   2.056923968629734e-04,  -7.780960480712120e-06,   2.556242217936197e-07,
  -7.115815634554799e-09,   1.870995221939540e-10,  -2.872219762681323e-12,  -1.014980511543037e-13,   7.092346118206950e-15,  -2.371795742327219e-16,   6.946853615177268e-18,
  -1.115914662772319e-19,   3.325610062712785e-21,   7.663162217061396e-02,  -4.673917044065459e-03,   2.059485609650236e-04,  -7.792804859345061e-06,   2.560828498085919e-07,
  -7.125140454117211e-09,   1.865946234491183e-10,  -2.828420841331022e-12,  -1.033010805927170e-13,   7.156646187532807e-15,  -2.384295556206827e-16,   6.978655850761475e-18,
  -1.124137468099596e-19,   3.108792707262453e-21,   7.667339241221575e-02,  -4.678637269572686e-03,   2.062585186651953e-04,  -7.807133875561185e-06,   2.566368563727939e-07,
  -7.136347625860796e-09,   1.859803539406311e-10,  -2.775287483937641e-12,  -1.054854897710826e-13,   7.234516363141751e-15,  -2.399443028376143e-16,   7.015866085297378e-18,
  -1.133356183902128e-19,   2.846632308495070e-21,   7.671396231370750e-02,  -4.683222337374364e-03,   2.065596309288631e-04,  -7.821051191035769e-06,   2.571740758587139e-07,
  -7.147155481023379e-09,   1.853801100906737e-10,  -2.723527070339035e-12,  -1.076104446623580e-13,   7.310232111713441e-15,  -2.414180166500959e-16,   7.050685047202952e-18,
  -1.141547329733063e-19,   2.592149112085436e-21,   7.674665928712139e-02,  -4.686917982539684e-03,   2.068023539164214e-04,  -7.832267763209255e-06,   2.576064210816612e-07,
  -7.155810552288923e-09,   1.848937483788430e-10,  -2.681700856597780e-12,  -1.093254138647091e-13,   7.371312350371585e-15,  -2.426073994036699e-16,   7.077800406920095e-18,
  -1.147602994710178e-19,   2.387152796346841e-21,   7.676827191179082e-02,  -4.689360965845000e-03,   2.069628147700911e-04,  -7.839681896978360e-06,   2.578918950499598e-07,
  -7.161504366119786e-09,   1.845709905652510e-10,  -2.653999782890871e-12,  -1.104601703346285e-13,   7.411713752863569e-15,  -2.433943357096770e-16,   7.095260286948184e-18,
  -1.151338697354575e-19,   2.251700529704891e-21,   7.677937320853502e-02,  -4.690615853705804e-03,   2.070452419196094e-04,  -7.843490157014399e-06,   2.580384338787816e-07,
  -7.164420578188341e-09,   1.844048123436689e-10,  -2.639754446151342e-12,  -1.110433971708626e-13,   7.432474221110010e-15,  -2.437987672416005e-16,   7.104085297588501e-18,
  -1.153174988649497e-19,   2.182140999816659e-21,   7.678323746360595e-02,  -4.691052676529357e-03,   2.070739350766071e-04,  -7.844815775665872e-06,   2.580894275865366e-07,
  -7.165434344595166e-09,   1.843469045452741e-10,  -2.634793119435298e-12,  -1.112464702706986e-13,   7.439702054229843e-15,  -2.439395804259246e-16,   7.107134400863757e-18,
  -1.153801046923250e-19,   2.157930432310902e-21,   7.678385068414398e-02,  -4.691121996555791e-03,   2.070784884578978e-04,  -7.845026138729358e-06,   2.580975190882038e-07,
  -7.165595156104339e-09,   1.843377121490424e-10,  -2.634005677707512e-12,  -1.112786987670870e-13,   7.440849104654419e-15,  -2.439619277539455e-16,   7.107617182348511e-18,
  -1.153899772851519e-19,   2.154088561101181e-21,   6.639449297387415e-01,  -3.171842463992144e-02,   6.717815364333572e-04,   8.018903102216879e-06,  -1.104946735252850e-06,
   2.555876478012356e-08,   1.261530244000172e-09,  -8.242550824284607e-11,   2.423856795291323e-14,   1.321895722521416e-13,  -4.362975427325880e-15,  -9.054727118363240e-17,
   1.201302322885511e-17,  -1.748898028025224e-19,   6.640066817422750e-01,  -3.171608978748125e-02,   6.711699956836062e-04,   8.041564431738151e-06,  -1.103176354905625e-06,
   2.540334641852846e-08,   1.261264453356496e-09,  -8.199256755258332e-11,   7.977033674242217e-15,   1.316882281009551e-13,  -4.295250552367579e-15,  -9.148469193175391e-17,
   1.186937718850991e-17,  -1.685044667792990e-19,   6.641155987056392e-01,  -3.171196494537352e-02,   6.700917309681659e-04,   8.081434347791918e-06,  -1.100052921672920e-06,
   2.512979467097151e-08,   1.260762040895867e-09,  -8.123003665237179e-11,  -2.049018736339701e-14,   1.308000092497450e-13,  -4.176463315184428e-15,  -9.310265784168182e-17,
   1.161664528230248e-17,  -1.573743780584069e-19,   6.642472248613939e-01,  -3.170696870562441e-02,   6.687892602272412e-04,   8.129447433690385e-06,  -1.096276792592199e-06,
   2.480018178445712e-08,   1.260097858536587e-09,  -8.031036918445929e-11,  -5.452849922649773e-14,   1.297199464906787e-13,  -4.034039951328919e-15,  -9.499806436796122e-17,
   1.131230731687557e-17,  -1.441476472774716e-19,   6.643749242558912e-01,  -3.170210963029305e-02,   6.675262874616512e-04,   8.175850770359563e-06,  -1.092611819611265e-06,
   2.448142127910952e-08,   1.259394161827112e-09,  -7.942008588291753e-11,  -8.717172230057230e-14,   1.286652650356998e-13,  -3.897047218393789e-15,  -9.677484858284944e-17,
   1.101821060896950e-17,  -1.315481648541011e-19,   6.644777392296395e-01,  -3.169818892424374e-02,   6.665098869611125e-04,   8.213084744452110e-06,  -1.089659980689779e-06,
   2.422550610195729e-08,   1.258785347513510e-09,  -7.870469202230033e-11,  -1.131831569022495e-13,   1.278112922989915e-13,  -3.787594766158617e-15,  -9.816137450130204e-17,
   1.078227167167898e-17,  -1.215692850319918e-19,   6.645456491506884e-01,  -3.169559511416059e-02,   6.658387737879827e-04,   8.237615979169408e-06,  -1.087709768620961e-06,
   2.405682934683815e-08,   1.258362642973245e-09,  -7.823285936549296e-11,  -1.302318524533983e-13,   1.272449156231842e-13,  -3.715713699431432e-15,  -9.905581192000149e-17,
   1.062685387704332e-17,  -1.150586167545319e-19,   6.645805153703604e-01,  -3.169426211822512e-02,   6.654942815847757e-04,   8.250191606148164e-06,  -1.086708339361893e-06,
   2.397033782929196e-08,   1.258139276562178e-09,  -7.799082545627205e-11,  -1.389442534880142e-13,   1.269534163701920e-13,  -3.678936174016609e-15,  -9.950846201796227e-17,
   1.054719107591306e-17,  -1.117406839296526e-19,   6.645926494808435e-01,  -3.169379800560649e-02,   6.653744028359508e-04,   8.254565114821543e-06,  -1.086359798502662e-06,
   2.394025467901452e-08,   1.258060533082258e-09,  -7.790662711730450e-11,  -1.419698629418284e-13,   1.268518565325907e-13,  -3.666157186041145e-15,  -9.966495023229072e-17,
   1.051948796379957e-17,  -1.105899127518063e-19,   6.645945749307695e-01,  -3.169372435015139e-02,   6.653553809123867e-04,   8.255258961769786e-06,  -1.086304490620367e-06,
   2.393548189478507e-08,   1.258047990206898e-09,  -7.789326807970118e-11,  -1.424496618834153e-13,   1.268357356108475e-13,  -3.664130369591839e-15,  -9.968973247132073e-17,
   1.051509301511161e-17,  -1.104074940072761e-19,   1.601944902375648e+00,  -2.852000565240380e-02,  -1.062541003076782e-03,  -7.745722850306460e-06,   1.540498560379943e-06,
   8.186890862587426e-08,   1.727078496083672e-10,  -1.745734657948177e-10,  -7.796745345384873e-12,   5.934118457781195e-14,   2.024947186464856e-14,   7.457274815137310e-16,
  -1.410577734133389e-17,  -2.342179047050957e-18,   1.601847028834859e+00,  -2.852192443177359e-02,  -1.061674459268895e-03,  -7.671816351508275e-06,   1.540521869719499e-06,
   8.152988997390830e-08,   1.539222436380212e-10,  -1.742909495125384e-10,  -7.714829769843578e-12,   6.258606556458705e-14,   2.014307497176524e-14,   7.300676131637758e-16,
  -1.454304325737613e-17,  -2.316022115536655e-18,   1.601674395424181e+00,  -2.852529374202064e-02,  -1.060145469174308e-03,  -7.541664057101667e-06,   1.540542178898562e-06,
   8.093217783839613e-08,   1.209473865761927e-10,  -1.737839774971745e-10,  -7.570669412511743e-12,   6.824758620224113e-14,   1.995332329686086e-14,   7.025950917242831e-16,
  -1.529755648296661e-17,  -2.269554897819829e-18,   1.601465757770040e+00,  -2.852934001390638e-02,  -1.058296672623251e-03,  -7.384720246011757e-06,   1.540531369921179e-06,
   8.021026509256760e-08,   8.136763056431009e-11,  -1.731566221982036e-10,  -7.397003208034120e-12,   7.498468649532330e-14,   1.972049914514038e-14,   6.696482234804295e-16,
  -1.618107764823172e-17,  -2.212852104357020e-18,   1.601263333752846e+00,  -2.853323886304984e-02,  -1.056501979024610e-03,  -7.232819945523118e-06,   1.540484011036685e-06,
   7.951034313858071e-08,   4.325121213582657e-11,  -1.725327523708371e-10,  -7.229101588708692e-12,   8.141153202812452e-14,   1.949101665359684e-14,   6.379514639139320e-16,
  -1.700886821029468e-17,  -2.157292101891724e-18,   1.601100347994516e+00,  -2.853635883813087e-02,  -1.055056264478764e-03,  -7.110778966100446e-06,   1.540419565042170e-06,
   7.894714676413144e-08,   1.276451063227157e-11,  -1.720196411461404e-10,  -7.094340892226857e-12,   8.650807376986769e-14,   1.930371984667678e-14,   6.126239050894277e-16,
  -1.765449428267829e-17,  -2.112182539857887e-18,   1.600992691228057e+00,  -2.853841024962727e-02,  -1.054100997254242e-03,  -7.030296920062665e-06,   1.540364154203389e-06,
   7.857531887345164e-08,  -7.273350658161703e-12,  -1.716754733577083e-10,  -7.005539139264266e-12,   8.983636559475754e-14,   1.917878875177225e-14,   5.959896004625789e-16,
  -1.807079942095398e-17,  -2.082209833526773e-18,   1.600937417104746e+00,  -2.853946059236163e-02,  -1.053610433189189e-03,  -6.989015139922766e-06,   1.540331741789080e-06,
   7.838446778961221e-08,  -1.753064127968494e-11,  -1.714971545427844e-10,  -6.960011507591456e-12,   9.153345042040309e-14,   1.911427356339053e-14,   5.874786166279613e-16,
  -1.828142016477280e-17,  -2.066767794204509e-18,   1.600918180474053e+00,  -2.853982567172618e-02,  -1.053439689725399e-03,  -6.974654532944616e-06,   1.540319831418234e-06,
   7.831805635443198e-08,  -2.109551809433571e-11,  -1.714348395572677e-10,  -6.944177377293534e-12,   9.212220491099687e-14,   1.909176199642623e-14,   5.845213167570167e-16,
  -1.835422524045468e-17,  -2.061385278997743e-18,   1.600915127982257e+00,  -2.853988358096527e-02,  -1.053412595177970e-03,  -6.972376077139682e-06,   1.540317911567377e-06,
   7.830751853661460e-08,  -2.166096498257964e-11,  -1.714249391994912e-10,  -6.941665297639615e-12,   9.221554051459315e-14,   1.908818704798130e-14,   5.840522727321374e-16,
  -1.836575453666854e-17,  -2.060530781574100e-18,   6.068984669923009e-02,  -3.336507315319764e-03,   1.327841962107344e-04,  -4.613400241776263e-06,   1.504796370482073e-07,
  -3.767269465662692e-09,   8.948983702924227e-11,  -3.355928490297723e-12,   4.487388641282866e-14,   2.386518195438116e-15,  -3.301631670629068e-17,   1.583085533437169e-18,
  -1.898132296165827e-19,  -3.832356233665537e-21,   6.070246657285008e-02,  -3.337817474923497e-03,   1.328695594977764e-04,  -4.616986362197897e-06,   1.506068249919229e-07,
  -3.773744855090052e-09,   8.960391844189364e-11,  -3.347682718183054e-12,   4.469929479231064e-14,   2.393959201419540e-15,  -3.412462553175487e-17,   1.563283863361721e-18,
  -1.883867298364418e-19,  -3.679307004869469e-21,   6.072474113113112e-02,  -3.340130101579311e-03,   1.330202428421363e-04,  -4.623319022960302e-06,   1.508313790447011e-07,
  -3.785157490584554e-09,   8.980482304990772e-11,  -3.333113007717700e-12,   4.438748199532571e-14,   2.407014197358275e-15,  -3.607306785505667e-17,   1.529215884760027e-18,
  -1.858684374594119e-19,  -3.412037319325769e-21,   6.075168700929105e-02,  -3.342927969432917e-03,   1.332025505076518e-04,  -4.630984883178350e-06,   1.511031317101508e-07,
  -3.798935087637795e-09,   9.004708210815398e-11,  -3.315461330645393e-12,   4.400406915606684e-14,   2.422675383890288e-15,  -3.841689094336645e-17,   1.489496734311391e-18,
  -1.828216965989599e-19,  -3.093594598513227e-21,   6.077785738026141e-02,  -3.345645573842997e-03,   1.333796361473006e-04,  -4.638435491350284e-06,   1.513671739436794e-07,
  -3.812286358912497e-09,   9.028154723072724e-11,  -3.298290128461283e-12,   4.362521429421963e-14,   2.437751140049652e-15,  -4.067940046531306e-17,   1.452469595883546e-18,
  -1.798628954974177e-19,  -2.789407598776737e-21,   6.079894833311980e-02,  -3.347835903663803e-03,   1.335223689551305e-04,  -4.644443848659516e-06,   1.515800470396187e-07,
  -3.823024910922500e-09,   9.046991158399131e-11,  -3.284432081662101e-12,   4.331526830489493e-14,   2.449806540431911e-15,  -4.249285370540013e-17,   1.423728252278205e-18,
  -1.774789631047591e-19,  -2.547895683454366e-21,   6.081288899377321e-02,  -3.349283755361153e-03,   1.336167209488072e-04,  -4.648417118947072e-06,   1.517207900207949e-07,
  -3.830112394775734e-09,   9.059412396009251e-11,  -3.275262662492512e-12,   4.310814415398135e-14,   2.457729617682261e-15,  -4.368664944984263e-17,   1.405264758046958e-18,
  -1.759036903734009e-19,  -2.390036392428479e-21,   6.082004946899840e-02,  -3.350027457596488e-03,   1.336651865640748e-04,  -4.650458527540608e-06,   1.517930930627562e-07,
  -3.833749569804341e-09,   9.065783354794381e-11,  -3.270549942310764e-12,   4.300106063268741e-14,   2.461785409626818e-15,  -4.429832854467870e-17,   1.395945378400554e-18,
  -1.750947431119723e-19,  -2.309501374929651e-21,   6.082254194160518e-02,  -3.350286335624485e-03,   1.336820572728197e-04,  -4.651169208763793e-06,   1.518182627424584e-07,
  -3.835015109872885e-09,   9.067999557419702e-11,  -3.268909035204881e-12,   4.296367546257673e-14,   2.463194998052100e-15,  -4.451100743558056e-17,   1.392727477532181e-18,
  -1.748131895475512e-19,  -2.281555237574922e-21,   6.082293747234842e-02,  -3.350327417220201e-03,   1.336847345077644e-04,  -4.651281991218962e-06,   1.518222570111642e-07,
  -3.835215914090115e-09,   9.068351177987143e-11,  -3.268648617298901e-12,   4.295773755227923e-14,   2.463418582521235e-15,  -4.454474612574290e-17,   1.392218063979695e-18,
  -1.747685113129155e-19,  -2.277124595056130e-21,   5.480649983595850e-01,  -2.621400486074224e-02,   6.820888259132414e-04,  -4.664873516101178e-06,  -4.633692026523894e-07,
   3.138712282803672e-08,  -5.641028437371668e-10,  -3.888537594018828e-11,   1.845361637517516e-12,  -5.908870267573473e-15,  -1.163804874219820e-15,   1.013119829451215e-16,
  -3.636710281762944e-18,  -1.772280565478056e-19,   5.481284124497490e-01,  -2.621521562015461e-02,   6.818240483170370e-04,  -4.636092665401613e-06,  -4.641067330860272e-07,
   3.131047116696270e-08,  -5.593741519250906e-10,  -3.889311618452035e-11,   1.839859963173388e-12,  -5.433663722670406e-15,  -1.182760427264716e-15,   1.000880394513820e-16,
  -3.559437133608951e-18,  -1.759319658157706e-19,   5.482402869508809e-01,  -2.621734555540222e-02,   6.813565198594321e-04,  -4.585366843182279e-06,  -4.654027570516647e-07,
   3.117521163979803e-08,  -5.510423917432993e-10,  -3.890550448754516e-11,   1.830090252784323e-12,  -4.600210863558131e-15,  -1.215824624652327e-15,   9.793616462699335e-17,
  -3.423581686049782e-18,  -1.736382467011881e-19,   5.483755315537976e-01,  -2.621991007520063e-02,   6.807906282843570e-04,  -4.524128285036801e-06,  -4.669607933816469e-07,
   3.101164471326968e-08,  -5.409882416880890e-10,  -3.891832939841886e-11,   1.818171928646935e-12,  -3.600990127804488e-15,  -1.255154630781959e-15,   9.534740612403291e-17,
  -3.260157833964502e-18,  -1.708535852981576e-19,   5.485067877525182e-01,  -2.622238813758077e-02,   6.802406954764565e-04,  -4.464783303243904e-06,  -4.684637599656308e-07,
   3.085284838882113e-08,  -5.312496379932095e-10,  -3.892853472667292e-11,   1.806493335572113e-12,  -2.639940358510719e-15,  -1.292655476540323e-15,   9.284825390808440e-17,
  -3.102417290885826e-18,  -1.681392335812954e-19,   5.486124995726850e-01,  -2.622437618011835e-02,   6.797972662181653e-04,  -4.417050524020735e-06,  -4.696676978885767e-07,
   3.072491934571582e-08,  -5.234200362998268e-10,  -3.893515599411582e-11,   1.797008278749866e-12,  -1.872142445332659e-15,  -1.322380044519102e-15,   9.084499907699057e-17,
  -2.976004345465242e-18,  -1.659450468763385e-19,   5.486823390962622e-01,  -2.622568580599443e-02,   6.795040556535755e-04,  -4.385546161179443e-06,  -4.704598968450692e-07,
   3.064038425793410e-08,  -5.182540886955017e-10,  -3.893875119787400e-11,   1.790703374941510e-12,  -1.367926194680940e-15,  -1.341784395387842e-15,   8.952620275562417e-17,
  -2.892800375188161e-18,  -1.644916257579580e-19,   5.487182010229615e-01,  -2.622635711370670e-02,   6.793534161484107e-04,  -4.369378484518570e-06,  -4.708656961989482e-07,
   3.059697097594055e-08,  -5.156035195477714e-10,  -3.894035700400268e-11,   1.787454023643678e-12,  -1.109953544190571e-15,  -1.351676270167239e-15,   8.885046057888156e-17,
  -2.850173247315209e-18,  -1.637441608746555e-19,   5.487306824564091e-01,  -2.622659056990908e-02,   6.793009748538102e-04,  -4.363752978922543e-06,  -4.710067740382301e-07,
   3.058186052007400e-08,  -5.146813460974732e-10,  -3.894087769539485e-11,   1.786321235382075e-12,  -1.020317516222436e-15,  -1.355107588849669e-15,   8.861550490855282e-17,
  -2.835352811090192e-18,  -1.634838323516106e-19,   5.487326630576838e-01,  -2.622662760676652e-02,   6.792926526759066e-04,  -4.362860374222328e-06,  -4.710291533478824e-07,
   3.057946269590999e-08,  -5.145350279901023e-10,  -3.894095850862138e-11,   1.786141391122826e-12,  -1.006100807297887e-15,  -1.355651539586964e-15,   8.857823219862618e-17,
  -2.833001788486134e-18,  -1.634425139512062e-19,   1.471020824552762e+00,  -3.685723641571718e-02,  -9.584165476586884e-04,   2.814696334027807e-05,   2.710127156690808e-06,
   7.807589161678425e-09,  -6.545090265245453e-09,  -2.012022310883691e-10,   1.145852833109843e-11,   8.532468794301312e-13,  -6.070594033262811e-15,  -2.452144977132827e-15,
  -5.465561974973620e-17,   5.016306555493460e-18,   1.470933932295942e+00,  -3.684930532364501e-02,  -9.569419161115319e-04,   2.815133249795210e-05,   2.701269327165781e-06,
   7.452011958775373e-09,  -6.515719613792090e-09,  -1.986134215306587e-10,   1.142530889104107e-11,   8.418940635235323e-13,  -6.320486792005559e-15,  -2.418486636500440e-15,
  -5.266946437957187e-17,   4.962260658136081e-18,   1.470780716077552e+00,  -3.683531028554941e-02,  -9.543438751674540e-04,   2.815878317209764e-05,   2.685672838589880e-06,
   6.828593061358109e-09,  -6.463969921895239e-09,  -1.940756388585210e-10,   1.136591068527925e-11,   8.219998056386479e-13,  -6.752047592090407e-15,  -2.359424265226881e-15,
  -4.922088721981846e-17,   4.866344897912394e-18,   1.470595626848694e+00,  -3.681838651819368e-02,  -9.512090545250280e-04,   2.816735339215036e-05,   2.666870100059342e-06,
   6.081540817810709e-09,  -6.401523076770174e-09,  -1.886397630088732e-10,   1.129277356941463e-11,   7.981777451162391e-13,  -7.258090594357409e-15,  -2.288567051572865e-15,
  -4.514532197558494e-17,   4.749475528091622e-18,   1.470416135206010e+00,  -3.680195640863942e-02,  -9.481728889177450e-04,   2.817521583468856e-05,   2.648676025573689e-06,
   5.363387406970960e-09,  -6.341037650675270e-09,  -1.834160622757023e-10,   1.122042600773387e-11,   7.752958282606370e-13,  -7.733034122658390e-15,  -2.220370491025182e-15,
  -4.128647052236316e-17,   4.635157508427553e-18,   1.470271674874212e+00,  -3.678871997943214e-02,  -9.457320454717886e-04,   2.818122380530071e-05,   2.634061546791865e-06,
   4.789890540781403e-09,  -6.292410395851669e-09,  -1.792459161753747e-10,   1.116119709617503e-11,   7.570365094926367e-13,  -8.104118542220681e-15,  -2.165856747714934e-15,
  -3.824686773828812e-17,   4.542491197261356e-18,   1.470176284482594e+00,  -3.677997332850431e-02,  -9.441216495067249e-04,   2.818503491439020e-05,   2.624425312095233e-06,
   4.413389248994408e-09,  -6.260327227176073e-09,  -1.765088715196526e-10,   1.112160365456767e-11,   7.450559513235510e-13,  -8.343748227631787e-15,  -2.130043467659667e-15,
  -3.627178696045445e-17,   4.480996250555194e-18,   1.470127317479047e+00,  -3.677548142892852e-02,  -9.432953971691484e-04,   2.818694312899118e-05,   2.619483057531170e-06,
   4.220794653912037e-09,  -6.243866172590650e-09,  -1.751089740977610e-10,   1.110113107797273e-11,   7.389295353669730e-13,  -8.465099019476573e-15,  -2.111716211049717e-15,
  -3.526775041484045e-17,   4.449338182418282e-18,   1.470110277331611e+00,  -3.677391797032795e-02,  -9.430079338835613e-04,   2.818759951777236e-05,   2.617763881097518e-06,
   4.153880611116622e-09,  -6.238139176657732e-09,  -1.746226336431388e-10,   1.109398334978041e-11,   7.368013404940526e-13,  -8.507065198021267e-15,  -2.105347532324017e-15,
  -3.491991309646570e-17,   4.438307300957072e-18,   1.470107573449942e+00,  -3.677366987042442e-02,  -9.429623231813131e-04,   2.818770330843368e-05,   2.617491119913337e-06,
   4.143267979254548e-09,  -6.237230496533149e-09,  -1.745455011181886e-10,   1.109284805930265e-11,   7.364638226471603e-13,  -8.513711808757216e-15,  -2.104337399459618e-15,
  -3.486479319428487e-17,   4.436556288952751e-18,   4.916876031149625e-02,  -2.459858066030024e-03,   8.968282991257600e-05,  -2.719890671786983e-06,   9.014447833913671e-08,
  -2.514366843192625e-09,   2.667252557479348e-11,  -8.343573928870289e-13,   9.829097606864801e-14,  -2.320724982122551e-16,  -1.427012538020557e-16,  -3.496924626138040e-18,
   1.897174517279066e-19,   1.668772093923512e-20,   4.917727031728156e-02,  -2.460631389032732e-03,   8.973376570836937e-05,  -2.722261875374135e-06,   9.018488271069917e-08,
  -2.516028324545130e-09,   2.691893866710500e-11,  -8.354945696426683e-13,   9.772416048180019e-14,  -2.462239031053098e-16,  -1.415955099421604e-16,  -3.394275853188579e-18,
   1.882878061132471e-19,   1.632571774287886e-20,   4.919229026700227e-02,  -2.461996474291292e-03,   8.982366187604709e-05,  -2.726447173939004e-06,   9.025645406168145e-08,
  -2.518962022111792e-09,   2.735254996084462e-11,  -8.375371812230657e-13,   9.672773682126669e-14,  -2.707833173417284e-16,  -1.396519087196298e-16,  -3.215202293244058e-18,
   1.857362684635109e-19,   1.569445744467353e-20,   4.921045921976614e-02,  -2.463648078854031e-03,   8.993239802787061e-05,  -2.731510252578642e-06,   9.034347063973607e-08,
  -2.522512906774961e-09,   2.787485629603565e-11,  -8.400678400274773e-13,   9.552919492750310e-14,  -2.997858333300800e-16,  -1.373145664882034e-16,  -3.002133350524225e-18,
   1.826031022844109e-19,   1.494381909769062e-20,   4.922810430983324e-02,  -2.465252400948339e-03,   9.003799160081378e-05,  -2.736427676466309e-06,   9.042843765752378e-08,
  -2.525963679101648e-09,   2.837979265972854e-11,  -8.425871856821285e-13,   9.437229170342641e-14,  -3.272204579770663e-16,  -1.350591173978714e-16,  -2.798884321983091e-18,
   1.795132471097318e-19,   1.422827247702646e-20,   4.924232397083313e-02,  -2.466545519278350e-03,   9.012308113301248e-05,  -2.740390720104851e-06,   9.049723827229613e-08,
  -2.528746213676486e-09,   2.878505614415950e-11,  -8.446609437986301e-13,   9.344503268495882e-14,  -3.488102767980455e-16,  -1.332519806881458e-16,  -2.637698606824849e-18,
   1.769908216599048e-19,   1.366117734337009e-20,   4.925172252094392e-02,  -2.467400330331741e-03,   9.017931891587448e-05,  -2.743010227693167e-06,   9.054287265286390e-08,
  -2.530586167352535e-09,   2.905211126688337e-11,  -8.460526238218624e-13,   9.283462434651583e-14,  -3.628282087305521e-16,  -1.320626975270555e-16,  -2.532427425136472e-18,
   1.753082628320466e-19,   1.329098814405190e-20,   4.925654988434659e-02,  -2.467839422335588e-03,   9.020820346790627e-05,  -2.744355717350956e-06,   9.056636126249910e-08,
  -2.531531477776922e-09,   2.918902972101231e-11,  -8.467738727283813e-13,   9.252186277606704e-14,  -3.699507510701984e-16,  -1.314534471134340e-16,  -2.478746081822800e-18,
   1.744394139271233e-19,   1.310227380226072e-20,   4.925823021310342e-02,  -2.467992269145917e-03,   9.021825759988151e-05,  -2.744824066706121e-06,   9.057454514693251e-08,
  -2.531860566636204e-09,   2.923664932028102e-11,  -8.470259484991987e-13,   9.241311652248710e-14,  -3.724177026819632e-16,  -1.312416318324147e-16,  -2.460122166241968e-18,
   1.741362524838088e-19,   1.303681153848566e-20,   4.925849686386624e-02,  -2.468016524628075e-03,   9.021985308061228e-05,  -2.744898389167192e-06,   9.057584421811975e-08,
  -2.531912791592292e-09,   2.924420418074389e-11,  -8.470659986512753e-13,   9.239586536469990e-14,  -3.728085995881705e-16,  -1.312080310648413e-16,  -2.457169669143680e-18,
   1.740881094940356e-19,   1.302643407999082e-20,   4.536451376625742e-01,  -2.106568037070658e-02,   5.992277193415340e-04,  -8.046978075740650e-06,  -2.622413793863310e-08,
   1.108555408277963e-08,  -8.900878924769791e-10,   1.273304201827778e-11,   1.295166710420715e-12,  -2.558767369128246e-14,  -1.100632328256891e-15,  -5.254927372267921e-17,
   1.687060994312330e-18,   2.887644416253981e-19,   4.537012716850377e-01,  -2.106790623648489e-02,   5.992061443298785e-04,  -8.036388405838542e-06,  -2.743680297361140e-08,
   1.110915779840860e-08,  -8.867769290974923e-10,   1.264164512947352e-11,   1.290821770940337e-12,  -2.579098376956749e-14,  -1.091194810407859e-15,  -5.076145286445926e-17,
   1.665924381210742e-18,   2.827324957070250e-19,   4.538003186033275e-01,  -2.107183135662648e-02,   5.991675294563206e-04,  -8.017685231361173e-06,  -2.957281874203114e-08,
   1.115065827657506e-08,  -8.809437764506818e-10,   1.247986461948207e-11,   1.283186531300230e-12,  -2.614255691942273e-14,  -1.074652070408036e-15,  -4.764114567532794e-17,
   1.628288211978193e-18,   2.722033461225465e-19,   4.539200829952859e-01,  -2.107657346517771e-02,   5.991199071026158e-04,  -7.995039332511815e-06,  -3.214932346984043e-08,
   1.120058712028777e-08,  -8.739057274449262e-10,   1.228338265215283e-11,   1.274007321658906e-12,  -2.655555250451995e-14,  -1.054836834824555e-15,  -4.392611928290658e-17,
   1.582224000493348e-18,   2.596648340815605e-19,   4.540363437615547e-01,  -2.108117263241933e-02,   5.990727049582168e-04,  -7.973023958918836e-06,  -3.464386874576390e-08,
   1.124879056073815e-08,  -8.670894451222944e-10,   1.209176235611591e-11,   1.265151891078205e-12,  -2.694390062973295e-14,  -1.035799112521209e-15,  -4.037988258296592e-17,
   1.536958077418717e-18,   2.476933722678361e-19,   4.541299987231251e-01,  -2.108487451422742e-02,   5.990339847144105e-04,  -7.955266428948288e-06,  -3.664866139784294e-08,
   1.128743114084729e-08,  -8.616098563249979e-10,   1.193677736139379e-11,   1.258057661239842e-12,  -2.724782016149389e-14,  -1.020605687226655e-15,  -3.756584295028420e-17,
   1.500122755103462e-18,   2.381918108739047e-19,   4.541918826769008e-01,  -2.108731910973161e-02,   5.990080592900841e-04,  -7.943521713176632e-06,  -3.797105449390211e-08,
   1.131287021054738e-08,  -8.579946657891632e-10,   1.183406802728691e-11,   1.253389208324805e-12,  -2.744430735284541e-14,  -1.010636543374796e-15,  -3.572715126032121e-17,
   1.475610621245566e-18,   2.319825869351249e-19,   4.542236625586087e-01,  -2.108857404939941e-02,   5.989946403546015e-04,  -7.937486888381272e-06,  -3.864944405824604e-08,
   1.132590530080658e-08,  -8.561398283443457e-10,   1.178123069684608e-11,   1.250997678687288e-12,  -2.754387881459767e-14,  -1.005538750699043e-15,  -3.478928574373611e-17,
   1.462971165631963e-18,   2.288151533149306e-19,   4.542347237593402e-01,  -2.108901076667146e-02,   5.989899530647019e-04,  -7.935385879363296e-06,  -3.888544877311889e-08,
   1.133043764891018e-08,  -8.554945112340683e-10,   1.176282575307460e-11,   1.250166229400786e-12,  -2.757832382673199e-14,  -1.003767900068880e-15,  -3.446386740928859e-17,
   1.458563887121283e-18,   2.277160800018215e-19,   4.542364790158461e-01,  -2.108908006408098e-02,   5.989892084633972e-04,  -7.935052452876336e-06,  -3.892289401328440e-08,
   1.133115665005375e-08,  -8.553921213948843e-10,   1.175990445884856e-11,   1.250034334651484e-12,  -2.758377973648001e-14,  -1.003487055919707e-15,  -3.441227609413831e-17,
   1.457864136285536e-18,   2.275418325067576e-19,   1.311376157309496e+00,  -4.248533136239523e-02,  -3.857350394242038e-04,   6.335740022774818e-05,   1.150184294417845e-06,
  -1.541001125841554e-07,  -3.996335307001823e-09,   4.034648782589223e-10,   1.399801005184580e-11,  -1.056442619188169e-12,  -4.801531880719660e-14,   2.700975117272389e-15,
   1.603510565832403e-16,  -6.646151379656910e-18,   1.311341233989225e+00,  -4.246799783334646e-02,  -3.851173957661583e-04,   6.321913182922305e-05,   1.144951378144456e-06,
  -1.533567950070150e-07,  -3.963160598397944e-09,   4.002149500638399e-10,   1.382143617777957e-11,  -1.044101765571452e-12,  -4.718294775227090e-14,   2.659179945135028e-15,
   1.567686948146213e-16,  -6.519125476715785e-18,   1.311279654911950e+00,  -4.243744310511310e-02,  -3.840298577375992e-04,   6.297570616263631e-05,   1.135754370738023e-06,
  -1.520502486549132e-07,  -3.904984777656169e-09,   3.945131201584784e-10,   1.351258735671123e-11,  -1.022494545581876e-12,  -4.573122284933311e-14,   2.586152406060237e-15,
   1.505405595358048e-16,  -6.297566833812291e-18,   1.311205267191063e+00,  -4.240054802059857e-02,  -3.827187126044543e-04,   6.268229035769318e-05,   1.124695308723750e-06,
  -1.504789332377110e-07,  -3.835250459549162e-09,   3.876738876646482e-10,   1.314372089525830e-11,  -9.966520023069572e-13,  -4.400447170725701e-14,   2.499065361119825e-15,
   1.431659168499333e-16,  -6.034016776572296e-18,   1.311133130611835e+00,  -4.236478528093287e-02,  -3.814499640658996e-04,   6.239842545629213e-05,   1.114024002275822e-06,
  -1.489624620643498e-07,  -3.768190133525104e-09,   3.810921870415958e-10,   1.279039669953682e-11,  -9.718605463016712e-13,  -4.235782637587995e-14,   2.415785958288018e-15,
   1.361679825145841e-16,  -5.782684193793529e-18,   1.311075073922765e+00,  -4.233601416521127e-02,  -3.804307963631875e-04,   6.217044609177960e-05,   1.105473407490154e-06,
  -1.477471830961679e-07,  -3.714619880187014e-09,   3.758311277945195e-10,   1.250914333203221e-11,  -9.520991923355651e-13,  -4.105228649681067e-14,   2.349593166608430e-15,
   1.306442380953221e-16,  -5.583415792711262e-18,   1.311036738282733e+00,  -4.231702173268923e-02,  -3.797587741029512e-04,   6.202014247797196e-05,   1.099845786660924e-06,
  -1.469472550436529e-07,  -3.679441885117497e-09,   3.723747139458109e-10,   1.232493741369493e-11,  -9.391435025147979e-13,  -4.019977106379060e-14,   2.306289227901077e-15,
   1.270491879857372e-16,  -5.453296554113040e-18,   1.311017059496700e+00,  -4.230727408200263e-02,  -3.794140985640334e-04,   6.194305966994291e-05,   1.096962659280118e-06,
  -1.465374118109578e-07,  -3.661444133329412e-09,   3.706058419755007e-10,   1.223084355669252e-11,  -9.325216087840802e-13,  -3.976508337843789e-14,   2.284184365420912e-15,
   1.252197951027717e-16,  -5.386951657917563e-18,   1.311010211451490e+00,  -4.230388225721220e-02,  -3.792942010682301e-04,   6.191624703755214e-05,   1.095960261049962e-06,
  -1.463949144147633e-07,  -3.655190624210117e-09,   3.699911487989914e-10,   1.219817342018522e-11,  -9.302217950540010e-13,  -3.961428099165396e-14,   2.276511795587423e-15,
   1.245857250758767e-16,  -5.363935474594351e-18,   1.311009124824461e+00,  -4.230334406567381e-02,  -3.792751783076787e-04,   6.191199303664332e-05,   1.095801246470738e-06,
  -1.463723092656275e-07,  -3.654198789358127e-09,   3.698936518878262e-10,   1.219299291652938e-11,  -9.298570832411954e-13,  -3.959037417113720e-14,   2.275295270901846e-15,
   1.244852332282833e-16,  -5.360286714813681e-18,   4.058738391902121e-02,  -1.852041835436310e-03,   6.414382713211974e-05,  -1.647161378659198e-06,   4.601563452238063e-08,
  -1.849237373809716e-09,   3.771296822495769e-11,   1.031073256698192e-12,  -9.488310173166872e-15,  -4.428649877277526e-15,   4.977122356945866e-17,   1.030823559480701e-17,
  -5.874528344983996e-20,  -2.654771015198742e-20,   4.059344995628203e-02,  -1.852511149065225e-03,   6.417000875388267e-05,  -1.648879994606547e-06,   4.606842805521875e-08,
  -1.847423489313531e-09,   3.769212544324655e-11,   1.017326137181076e-12,  -9.289841920582273e-15,  -4.381713072160064e-15,   4.941255707739706e-17,   1.014399359384108e-17,
  -5.866368232231078e-20,  -2.598666167554922e-20,   4.060415560564743e-02,  -1.853339650798915e-03,   6.421623072704868e-05,  -1.651911202556558e-06,   4.616156083109102e-08,
  -1.844244285367616e-09,   3.765576462146300e-11,   9.931934520506527e-13,  -8.940866803705776e-15,  -4.299551144958232e-15,   4.878026512005181e-17,   9.857340857440995e-18,
  -5.850390066498193e-20,  -2.501024978776476e-20,   4.061710445584241e-02,  -1.854342149513550e-03,   6.427216389945348e-05,  -1.655574337008201e-06,   4.627414037346725e-08,
  -1.840436354710369e-09,   3.761250527033628e-11,   9.642227306215157e-13,  -8.520969899013720e-15,  -4.201314600164824e-15,   4.801673172964186e-17,   9.516043459336911e-18,
  -5.828440005780853e-20,  -2.385241130526891e-20,   4.062967860515466e-02,  -1.855316054648161e-03,   6.432650585363462e-05,  -1.659128118332268e-06,   4.638339167404274e-08,
  -1.836777627325494e-09,   3.757124954379443e-11,   9.363176560148168e-13,  -8.115525198554416e-15,  -4.107104273108158e-15,   4.727666007106010e-17,   9.190228164526786e-18,
  -5.804458603735266e-20,  -2.275197139030987e-20,   4.063981077810548e-02,  -1.856101119000858e-03,   6.437031382799603e-05,  -1.661989341375678e-06,   4.647137546694614e-08,
  -1.833857273909950e-09,   3.753854285762685e-11,   9.139936784584667e-13,  -7.790467481128534e-15,  -4.032030161231926e-15,   4.668133812540164e-17,   8.931656842758406e-18,
  -5.783280276865923e-20,  -2.188210977531615e-20,   4.064650721185158e-02,  -1.856620119816376e-03,   6.439927643665299e-05,  -1.663879179210621e-06,   4.652950017560942e-08,
  -1.831940762960715e-09,   3.751718892917700e-11,   8.993183386940026e-13,  -7.576439911163297e-15,  -3.982821150550827e-15,   4.628840338565490e-17,   8.762688927013581e-18,
  -5.768397819948314e-20,  -2.131536795223694e-20,   4.064994654519665e-02,  -1.856886727098930e-03,   6.441415478504089e-05,  -1.664849452507464e-06,   4.655934587087276e-08,
  -1.830960617043268e-09,   3.750630233699151e-11,   8.918052458546278e-13,  -7.466762889916200e-15,  -3.957672587505449e-15,   4.608675336213074e-17,   8.676496786650403e-18,
  -5.760484939544455e-20,  -2.102678659314146e-20,   4.065114369943026e-02,  -1.856979534228426e-03,   6.441933407276792e-05,  -1.665187125469646e-06,   4.656973328410935e-08,
  -1.830620115995484e-09,   3.750252583048428e-11,   8.891939617425856e-13,  -7.428626417315198e-15,  -3.948938862349388e-15,   4.601658995603173e-17,   8.646588962641553e-18,
  -5.757688211386415e-20,  -2.092673420909176e-20,   4.065133367429954e-02,  -1.856994262012474e-03,   6.442015598963931e-05,  -1.665240707642434e-06,   4.657138159251385e-08,
  -1.830566113899694e-09,   3.750192715222697e-11,   8.887797631960062e-13,  -7.422576469982782e-15,  -3.947553863218808e-15,   4.600545707537283e-17,   8.641847369961360e-18,
  -5.757242396113749e-20,  -2.091087579832857e-20,   3.783622200414623e-01,  -1.665504195823727e-02,   5.042063428946808e-04,  -7.662511575893259e-06,   3.001865621388282e-08,
  -2.528980322242551e-09,  -1.639385956362466e-10,   2.954590801053287e-11,  -4.734494931988844e-13,  -5.752726836133276e-14,   1.095347507785946e-15,   1.303209634876853e-16,
  -1.102012163400472e-18,  -3.895337997198785e-19,   3.784095203736176e-01,  -1.665720365761835e-02,   5.042218437418841e-04,  -7.664419877256412e-06,   2.977463190099096e-08,
  -2.473631751681425e-09,  -1.650908102859400e-10,   2.936659407661867e-11,  -4.690333558356923e-13,  -5.694476322147173e-14,   1.088916346101532e-15,   1.279498391336983e-16,
  -1.093610095136809e-18,  -3.805506888613750e-19,   3.784929835679517e-01,  -1.666101836719051e-02,   5.042490805094145e-04,  -7.667745775294750e-06,   2.934276523135531e-08,
  -2.376248185877551e-09,  -1.671146098016989e-10,   2.905172602646474e-11,  -4.612627303357795e-13,  -5.592639023526165e-14,   1.077610438450360e-15,   1.238162622860762e-16,
  -1.078807558031321e-18,  -3.649326507890736e-19,   3.785939098769646e-01,  -1.666563175725950e-02,   5.042818195032216e-04,  -7.671697158443718e-06,   2.881836884137092e-08,
  -2.258966489037698e-09,  -1.695459816047932e-10,   2.867358293968924e-11,  -4.519033404505740e-13,  -5.471096421395070e-14,   1.064010683330564e-15,   1.189027697815755e-16,
  -1.060952227260804e-18,  -3.464388235990114e-19,   3.786918891863371e-01,  -1.667011097946840e-02,   5.043133962130582e-04,  -7.675459626903683e-06,   2.830702167037994e-08,
  -2.145607371904525e-09,  -1.718897801221402e-10,   2.830918769439641e-11,  -4.428559581325842e-13,  -5.354762942711495e-14,   1.050882972675100e-15,   1.142205661186987e-16,
  -1.043670636100772e-18,  -3.288888421442832e-19,   3.787708213244835e-01,  -1.667371982341074e-02,   5.043386862422376e-04,  -7.678438111885022e-06,   2.789346544923202e-08,
  -2.054640618689679e-09,  -1.737660944842185e-10,   2.801755453310653e-11,  -4.355950385174166e-13,  -5.262221783219820e-14,   1.040360869985565e-15,   1.105107014488751e-16,
  -1.029790162587109e-18,  -3.150352936029558e-19,   3.788229788999354e-01,  -1.667610469676452e-02,   5.043553249573758e-04,  -7.680380582366404e-06,   2.761940349455877e-08,
  -1.994704093859377e-09,  -1.750001539052472e-10,   2.782578195496261e-11,  -4.308105980543150e-13,  -5.201642880661314e-14,   1.033434156581312e-15,   1.080893542661312e-16,
  -1.020640033149987e-18,  -3.060185662780147e-19,   3.788497645032624e-01,  -1.667732950891138e-02,   5.043638472871988e-04,  -7.681370209426528e-06,   2.747841538274149e-08,
  -1.963977101301504e-09,  -1.756321186932323e-10,   2.772758492900928e-11,  -4.283577096579104e-13,  -5.170708145684192e-14,   1.029885020613457e-15,   1.068551069805659e-16,
  -1.015948090697787e-18,  -3.014301644824774e-19,   3.788590875084258e-01,  -1.667775582639140e-02,   5.043668099859814e-04,  -7.681713397570095e-06,   2.742930435403651e-08,
  -1.953290761546975e-09,  -1.758517960604922e-10,   2.769345218908882e-11,  -4.275046195155243e-13,  -5.159968863713431e-14,   1.028650994007454e-15,   1.064269794065011e-16,
  -1.014316174586263e-18,  -2.998398002566997e-19,   3.788605669423998e-01,  -1.667782347759680e-02,   5.043672799556499e-04,  -7.681767796975968e-06,   2.742150926798330e-08,
  -1.951595388545833e-09,  -1.758866423663280e-10,   2.768803795742687e-11,  -4.273692771836963e-13,  -5.158266007153079e-14,   1.028455231853699e-15,   1.063591108130330e-16,
  -1.014057267507124e-18,  -2.995877473602947e-19,   1.140193981855078e+00,  -4.246433539296895e-02,   3.779338325379842e-04,   5.612120442822170e-05,  -1.888491674356290e-06,
  -1.049683779589385e-07,   6.923379667454735e-09,   1.692183689131666e-10,  -2.229698092882053e-11,  -1.121876552126255e-13,   6.554203492678930e-14,  -7.259557358022621e-16,
  -1.773795584889876e-16,   4.896895013882701e-18,   1.140227384280014e+00,  -4.244888773815451e-02,   3.769226525684142e-04,   5.602552960766167e-05,  -1.879381090898165e-06,
  -1.046424588605795e-07,   6.869852462599243e-09,   1.687727197870575e-10,  -2.205045809971133e-11,  -1.149074275302136e-13,   6.458779521324221e-14,  -6.984204189027236e-16,
  -1.742003325724760e-16,   4.739430802911808e-18,   1.140286252255763e+00,  -4.242165151203388e-02,   3.751424314566067e-04,   5.585695600875812e-05,  -1.863364588967373e-06,
  -1.040681139794237e-07,   6.775911161946706e-09,   1.679796261193860e-10,  -2.161861429343162e-11,  -1.195991998307567e-13,   6.291935975961458e-14,  -6.506998942932895e-16,
  -1.686505126170008e-16,   4.466871534503829e-18,   1.140357314945938e+00,  -4.238875363382553e-02,   3.729966088618235e-04,   5.565353427476745e-05,  -1.844097930874544e-06,
  -1.033748862396245e-07,   6.663178541524731e-09,   1.670093106989588e-10,  -2.110175939012832e-11,  -1.250919499309119e-13,   6.092781649378334e-14,  -5.944517885132885e-16,
  -1.620410325202096e-16,   4.146167475857921e-18,   1.140426174801509e+00,  -4.235685507269647e-02,   3.709206213484405e-04,   5.545649450699934e-05,  -1.825499119532555e-06,
  -1.027032577677497e-07,   6.554636867504937e-09,   1.660557567368283e-10,  -2.060554808441244e-11,  -1.302381074676647e-13,   5.902137618651723e-14,  -5.413460292728613e-16,
  -1.557298052477426e-16,   3.843953292531890e-18,   1.140481556881649e+00,  -4.233118529236980e-02,   3.692533326144779e-04,   5.529807567162475e-05,  -1.810590994143352e-06,
  -1.021631722570295e-07,   6.467835960091534e-09,   1.652794521284309e-10,  -2.020974669688545e-11,  -1.342525314841906e-13,   5.750467844703372e-14,  -4.996207153455011e-16,
  -1.507201488838021e-16,   3.606905039719297e-18,   1.140518108117441e+00,  -4.231423650490203e-02,   3.681541085165043e-04,   5.519354884293257e-05,  -1.800776473208823e-06,
  -1.018067705105988e-07,   6.410790664357580e-09,   1.647625689031977e-10,  -1.995012479916258e-11,  -1.368417619650460e-13,   5.651175448841753e-14,  -4.725592430048128e-16,
  -1.474460764774156e-16,   3.453358183020776e-18,   1.140536865253519e+00,  -4.230553661604482e-02,   3.675903732235897e-04,   5.513991675938367e-05,  -1.795747506474439e-06,
  -1.016238892198601e-07,   6.381591076055051e-09,   1.644959281950213e-10,  -1.981738660601281e-11,  -1.381520162475938e-13,   5.600469611548141e-14,  -4.588180504487041e-16,
  -1.457758210688582e-16,   3.375449956425199e-18,   1.140543391671101e+00,  -4.230250919641931e-02,   3.673942822775871e-04,   5.512125717194431e-05,  -1.793998918441173e-06,
  -1.015602593272744e-07,   6.371443129246773e-09,   1.644029322461551e-10,  -1.977127956725061e-11,  -1.386049831000406e-13,   5.582866306784820e-14,  -4.540600308013403e-16,
  -1.451962408161241e-16,   3.348482887738039e-18,   1.140544427220440e+00,  -4.230202881777349e-02,   3.673631711479008e-04,   5.511829651078629e-05,  -1.793721526521506e-06,
  -1.015501632616388e-07,   6.369833512603126e-09,   1.643881661130115e-10,  -1.976396745892109e-11,  -1.386767168390782e-13,   5.580075053814751e-14,  -4.533061698442581e-16,
  -1.451043532040128e-16,   3.344210669133914e-18,   3.409474989884114e-02,  -1.407889535462751e-03,   4.775597597945335e-05,  -1.150011911185081e-06,   1.972910986148189e-08,
  -7.471168854954165e-10,   4.524537260675253e-11,  -7.714453595749040e-13,  -6.041562797584701e-14,   2.154948163250258e-15,   1.292158867081268e-16,  -7.756878201775647e-18,
  -1.893813912342006e-19,   2.225624356663784e-20,   3.409924999805267e-02,  -1.408215487002457e-03,   4.776742200244619e-05,  -1.150724168023055e-06,   1.979099981490452e-08,
  -7.485360251037190e-10,   4.509720286691994e-11,  -7.650593340346470e-13,  -5.990587953685511e-14,   2.120154575627962e-15,   1.281057359083551e-16,  -7.619348711527133e-18,
  -1.880831259000703e-19,   2.178369662154257e-20,   3.410719140757584e-02,  -1.408790798514784e-03,   4.778764659041020e-05,  -1.151982008141076e-06,   1.990004026831407e-08,
  -7.510303254299051e-10,   4.483682160300443e-11,  -7.538828237268226e-13,  -5.901017284525629e-14,   2.059312166864895e-15,   1.261536325002800e-16,  -7.379340739994950e-18,
  -1.857693764858699e-19,   2.096070417378148e-20,   3.411679580409252e-02,  -1.409486752654777e-03,   4.781214990048876e-05,  -1.153504790236737e-06,   2.003161204674293e-08,
  -7.540298582102116e-10,   4.452377896496009e-11,  -7.405234727908187e-13,  -5.793345674131223e-14,   1.986673671512001e-15,   1.238047514536190e-16,  -7.093621927426683e-18,
  -1.829338038791788e-19,   1.998379253093398e-20,   3.412612122060101e-02,  -1.410162667673786e-03,   4.783598699069744e-05,  -1.154984947304377e-06,   2.015904632860967e-08,
  -7.569244912446628e-10,   4.422177441020960e-11,  -7.277159079409261e-13,  -5.689486174062650e-14,   1.917124879727858e-15,   1.215367583111982e-16,  -6.820910917365811e-18,
  -1.801432320226770e-19,   1.905429655541735e-20,   3.413363482731679e-02,  -1.410707387377290e-03,   4.785522540621824e-05,  -1.156178675622118e-06,   2.026149629877992e-08,
  -7.592440890020748e-10,   4.397983408780600e-11,  -7.175130930840809e-13,  -5.606294193231120e-14,   1.861783834722667e-15,   1.197185369367030e-16,  -6.604519563363914e-18,
  -1.778692408683787e-19,   1.831885567706464e-20,   3.413860025935016e-02,  -1.411067431994693e-03,   4.786795520426752e-05,  -1.156968120966257e-06,   2.032909116744538e-08,
  -7.607708596585297e-10,   4.382062357298604e-11,  -7.108271017089002e-13,  -5.551554821443838e-14,   1.825548976437247e-15,   1.185214427035495e-16,  -6.463133222972695e-18,
  -1.763543919297323e-19,   1.783935608635717e-20,   3.414115042408333e-02,  -1.411252364166317e-03,   4.787449794062491e-05,  -1.157373739860477e-06,   2.036377280908625e-08,
  -7.615530880282728e-10,   4.373906484585620e-11,  -7.074107203096772e-13,  -5.523515281227669e-14,   1.807043227405956e-15,   1.179080289853553e-16,  -6.391016565852283e-18,
  -1.755727584506488e-19,   1.759509528518653e-20,   3.414203806058742e-02,  -1.411316736602988e-03,   4.787677605544865e-05,  -1.157514951187476e-06,   2.037583905363179e-08,
  -7.618250572772893e-10,   4.371070994283075e-11,  -7.062243482062351e-13,  -5.513767273212154e-14,   1.800618413984444e-15,   1.176947403067487e-16,  -6.365993745739931e-18,
  -1.753001255864013e-19,   1.751039281879536e-20,   3.414217891762029e-02,  -1.411326951864307e-03,   4.787713760150378e-05,  -1.157537360996680e-06,   2.037775356233373e-08,
  -7.618682011788943e-10,   4.370621194566228e-11,  -7.060362167927759e-13,  -5.512220940066470e-14,   1.799599656537792e-15,   1.176609045740088e-16,  -6.362026668043118e-18,
  -1.752568352319208e-19,   1.749696661952592e-20,   3.192331832490745e-01,  -1.298505905095917e-02,   4.134268862149599e-04,  -7.569818850120874e-06,  -8.019059944301970e-09,
   3.642818277341845e-10,   2.499110184845720e-10,  -2.390765017823554e-12,  -9.218802448275024e-13,   3.511197367787858e-14,   1.468547321864252e-15,  -1.154235211358184e-16,
  -1.634732777463321e-18,   3.259263888102743e-19,   3.192719365730085e-01,  -1.298718694444271e-02,   4.134241922740872e-04,  -7.569501491796165e-06,  -7.694633956291339e-09,
   3.612203924029459e-10,   2.476113245737355e-10,  -2.285503635837376e-12,  -9.160104365356323e-13,   3.459277644252613e-14,   1.458415235950744e-15,  -1.134147652995270e-16,
  -1.636366758846707e-18,   3.189090300308072e-19,   3.193403174284838e-01,  -1.299094157704117e-02,   4.134195808417944e-04,  -7.568943345638318e-06,  -7.124761499453029e-09,
   3.559805358206293e-10,   2.435658079628522e-10,  -2.101138349791440e-12,  -9.056877948333064e-13,   3.368469258955736e-14,   1.440538383705130e-15,  -1.099098716590510e-16,
  -1.638361432221363e-18,   3.066864885431658e-19,   3.194230043056466e-01,  -1.299548160151727e-02,   4.134142460976949e-04,  -7.568271481325668e-06,  -6.440059157313357e-09,
   3.499193723349178e-10,   2.386948981324387e-10,  -1.880523294608698e-12,  -8.932647429147640e-13,   3.260023976135930e-14,   1.418926706664370e-15,  -1.057385870513110e-16,
  -1.639292029190042e-18,   2.921764275691744e-19,   3.195032753195912e-01,  -1.299988885595865e-02,   4.134093190571150e-04,  -7.567622339781752e-06,  -5.779950702139553e-09,
   3.443213500588701e-10,   2.339882002651183e-10,  -1.668766366106457e-12,  -8.812666249150494e-13,   3.156158610602552e-14,   1.397955504537980e-15,  -1.017584042285439e-16,
  -1.638686379747323e-18,   2.783691371989144e-19,   3.195679406280518e-01,  -1.300343919501170e-02,   4.134055296291117e-04,  -7.567101543194422e-06,  -5.251455190189382e-09,
   3.400153123513433e-10,   2.302121892774854e-10,  -1.499893140162955e-12,  -8.716454753274749e-13,   3.073487532254874e-14,   1.381070336798712e-15,  -9.860106472774317e-17,
  -1.637146517615692e-18,   2.674435199221473e-19,   3.196106703257062e-01,  -1.300578515286568e-02,   4.134031133586257e-04,  -7.566758430398821e-06,  -4.903836953478851e-09,
   3.372691534595014e-10,   2.277247096189119e-10,  -1.389139396786807e-12,  -8.653097107612416e-13,   3.019346402095668e-14,   1.369918290491272e-15,  -9.653854092685930e-17,
  -1.635625573270613e-18,   2.603197272352347e-19,   3.196326140747430e-01,  -1.300698990120256e-02,   4.134018995543492e-04,  -7.566582534907376e-06,  -4.725813114238709e-09,
   3.358894354501232e-10,   2.264496289659333e-10,  -1.332519071979529e-12,  -8.620627074158786e-13,   2.991691948191934e-14,   1.364193049363309e-15,  -9.548664619248975e-17,
  -1.634691255359602e-18,   2.566906971107727e-19,   3.196402517983493e-01,  -1.300740922278206e-02,   4.134014813822324e-04,  -7.566521361568933e-06,  -4.663928987823869e-09,
   3.354140682767780e-10,   2.260062007027279e-10,  -1.312852669193392e-12,  -8.609336269935838e-13,   2.982090306215212e-14,   1.362200642445506e-15,  -9.512168415219764e-17,
  -1.634341877797217e-18,   2.554322387697146e-19,   3.196414637999359e-01,  -1.300747576324149e-02,   4.134014152282723e-04,  -7.566511656503366e-06,  -4.654112564130047e-09,
   3.353388643999259e-10,   2.259358525509356e-10,  -1.309733817783188e-12,  -8.607545082171814e-13,   2.980567783586307e-14,   1.361884490261550e-15,  -9.506382466598789e-17,
  -1.634285292858442e-18,   2.552327595646623e-19,   9.797902367008904e-01,  -3.735919921273850e-02,   8.311731891724639e-04,   1.840224211855395e-05,  -2.320176219587839e-06,
   4.821141216383610e-08,   3.797207352233379e-09,  -2.626870188171872e-10,  -5.909471372139195e-14,   6.801938803030078e-13,  -2.432247772049776e-14,  -9.045258661194239e-16,
   9.584039467747216e-17,  -1.033344837610960e-18,   9.798656000374446e-01,  -3.735387943043118e-02,   8.298980762240769e-04,   1.844341350161766e-05,  -2.314861367366403e-06,
   4.772849559700202e-08,   3.795316822890470e-09,  -2.605162679124402e-10,  -1.454611156464481e-13,   6.754165400795725e-13,  -2.380559986159825e-14,  -9.080408155397965e-16,
   9.416960076194228e-17,  -9.562794546919178e-19,   9.799984862152058e-01,  -3.734448386394372e-02,   8.276505430297342e-04,   1.851570342660635e-05,  -2.305486050762470e-06,
   4.687979449137684e-08,   3.791806291474696e-09,  -2.566991216482557e-10,  -2.961492527560294e-13,   6.669760727691520e-13,  -2.290175586484043e-14,  -9.138204321817720e-16,
   9.124034172050977e-17,  -8.229671540614913e-19,   9.801590141044778e-01,  -3.733310781748748e-02,   8.249369332813128e-04,   1.860250913886488e-05,  -2.294154262820604e-06,
   4.585934061689042e-08,   3.787265933025546e-09,  -2.521058725378102e-10,  -4.754717747376114e-13,   6.567525550387452e-13,  -2.182272559045878e-14,  -9.200991888397150e-16,
   8.773057828245669e-17,  -6.662671310943621e-19,   9.803146849366696e-01,  -3.732204868929288e-02,   8.223069327966637e-04,   1.868614411772548e-05,  -2.283158902952091e-06,
   4.487476164658829e-08,   3.782551989053374e-09,  -2.476703905289204e-10,  -6.465514469477910e-13,   6.468111757482492e-13,  -2.078970130696628e-14,  -9.254642495774570e-16,
   8.435737298012609e-17,  -5.187955209893347e-19,   9.804399718895563e-01,  -3.731312857046905e-02,   8.201913363146548e-04,   1.875306631569344e-05,  -2.274305128498244e-06,
   4.408592654298887e-08,   3.778537236906408e-09,  -2.441141202236269e-10,  -7.822359035257343e-13,   6.387916784775008e-13,  -1.996782544582416e-14,  -9.292723221485051e-16,
   8.166443832336573e-17,  -4.032804866119341e-19,   9.805227008379580e-01,  -3.730722893391424e-02,   8.187949041329983e-04,   1.879706611610579e-05,  -2.268456689794318e-06,
   4.356679263978330e-08,   3.775778852015104e-09,  -2.417724776701345e-10,  -8.708551750684405e-13,   6.334876304642487e-13,  -1.942977095713961e-14,  -9.315406935209980e-16,
   7.989701961400001e-17,  -3.285409188232952e-19,   9.805651680485141e-01,  -3.730419752822142e-02,   8.180782382228326e-04,   1.881959384639346e-05,  -2.265453858158110e-06,
   4.330084527835304e-08,   3.774329844321788e-09,  -2.405724930034510e-10,  -9.160456602871782e-13,   6.307623162341069e-13,  -1.915500356066598e-14,  -9.326297195624186e-16,
   7.899309253652650e-17,  -2.906466354177347e-19,   9.805799462752750e-01,  -3.730314215579147e-02,   8.178288707200819e-04,   1.882742397208562e-05,  -2.264408794921190e-06,
   4.320838368043353e-08,   3.773820354989029e-09,  -2.401552351180891e-10,  -9.317238461524110e-13,   6.298135253060515e-13,  -1.905961444885515e-14,  -9.329967526262930e-16,
   7.867906650042933e-17,  -2.775345386240370e-19,   9.805822912398752e-01,  -3.730297467019995e-02,   8.177893030745179e-04,   1.882866599001212e-05,  -2.264242962534428e-06,
   4.319371622474322e-08,   3.773739261942246e-09,  -2.400890413978671e-10,  -9.342093503994783e-13,   6.296629549448309e-13,  -1.904448918902592e-14,  -9.330544268524168e-16,
   7.862926310966254e-17,  -2.754574948173112e-19,   2.914638915903474e-02,  -1.076476821366291e-03,   3.552076828875829e-05,  -9.050286122871318e-07,   1.314536295670813e-08,
  -4.874901154732604e-11,   1.136803143360839e-11,  -1.141382963481337e-12,   3.011174793496726e-14,   1.243916965085242e-15,  -1.031392779452638e-16,   4.904305828339072e-19,
   2.186575169042165e-19,  -8.376378840439924e-21,   2.914973426197785e-02,  -1.076731589434930e-03,   3.552825788426897e-05,  -9.050925780739764e-07,   1.316217663755791e-08,
  -5.092915596420804e-11,   1.143903586066027e-11,  -1.137174321457607e-12,   2.971667963343229e-14,   1.244589634639308e-15,  -1.018791446311776e-16,   4.409397877741083e-19,
   2.166706566275336e-19,  -8.157042201926796e-21,   2.915563733126707e-02,  -1.077181149484101e-03,   3.554148127309489e-05,  -9.052070877634879e-07,   1.319192270829408e-08,
  -5.476931698971952e-11,   1.156350520884124e-11,  -1.129747583934398e-12,   2.902381536617090e-14,   1.245580860242780e-15,  -9.966573669189495e-17,   3.548589419304961e-19,
   2.131531328905108e-19,  -7.774308310226081e-21,   2.916277637941632e-02,  -1.077724792873430e-03,   3.555748459494941e-05,  -9.053483487182507e-07,   1.322802445935568e-08,
  -5.940139222492837e-11,   1.171262438729536e-11,  -1.120766556460863e-12,   2.819320206498646e-14,   1.246449246858973e-15,  -9.700654515445548e-17,   2.528771666667932e-19,
   2.088807722594265e-19,  -7.318777873512717e-21,   2.916970788493635e-02,  -1.078252584802823e-03,   3.557303446623554e-05,  -9.054884044145440e-07,   1.326320935569746e-08,
  -6.388610088705099e-11,   1.185593838118912e-11,  -1.112047815787492e-12,   2.739437208833870e-14,   1.246950889086553e-15,  -9.444319084700855e-17,   1.560607711925682e-19,
   2.047146432891755e-19,  -6.884127168669656e-21,   2.917529256202762e-02,  -1.078677790512735e-03,   3.558557138046099e-05,  -9.056033219074169e-07,   1.329165212663097e-08,
  -6.749030532495127e-11,   1.197035802254145e-11,  -1.105024342404169e-12,   2.675620796672536e-14,   1.247113511054795e-15,  -9.239121349499203e-17,   7.961749539129699e-20,
   2.013459963039227e-19,  -6.539367967792724e-21,   2.917898318277468e-02,  -1.078958770416993e-03,   3.559386052326412e-05,  -9.056802796007341e-07,   1.331049449683262e-08,
  -6.986767991474922e-11,   1.204546126946089e-11,  -1.100383594547774e-12,   2.633713758967023e-14,   1.247103969236234e-15,  -9.104169294729426e-17,   2.985826924175568e-20,
   1.991142907562205e-19,  -6.314182237401101e-21,   2.918087860622163e-02,  -1.079103070632271e-03,   3.559811893450105e-05,  -9.057201169302514e-07,   1.332018571935954e-08,
  -7.108727069011727e-11,   1.208387522529157e-11,  -1.098000448679324e-12,   2.612273240286449e-14,   1.247063149425346e-15,  -9.035062783430115e-17,   4.536128757637126e-21,
   1.979664926205518e-19,  -6.199347409870602e-21,   2.918153834371943e-02,  -1.079153296216923e-03,   3.559960135882297e-05,  -9.057340329406033e-07,   1.332356118429105e-08,
  -7.151155270594600e-11,   1.209722089515692e-11,  -1.097170991240353e-12,   2.604823510409545e-14,   1.247043246645174e-15,  -9.011041142924478e-17,  -4.240718874302319e-21,
   1.975667250020604e-19,  -6.159506595022335e-21,   2.918164303582930e-02,  -1.079161266352738e-03,   3.559983661079463e-05,  -9.057362436054510e-07,   1.332409693538319e-08,
  -7.157887055747064e-11,   1.209933749935102e-11,  -1.097039368684689e-12,   2.603641950051588e-14,   1.247039818456285e-15,  -9.007230735849767e-17,  -5.631741171976514e-21,
   1.975032748884453e-19,  -6.153190501247782e-21,   2.733324297555997e-01,  -1.004080326968252e-02,   3.229457166482240e-04,  -7.379685815903256e-06,   4.224593153533704e-08,
   3.558594912570860e-09,  -1.436852007780799e-11,  -9.579706850334008e-12,   3.210593312758717e-13,   1.432382604372219e-14,  -1.368065327321758e-15,   1.772404209952373e-17,
   2.534272273684354e-18,  -1.327045784284948e-19,   2.733627534377716e-01,  -1.004286761589321e-02,   3.229694184514235e-04,  -7.376500728129706e-06,   4.223425148093818e-08,
   3.540530311601796e-09,  -1.363363046013157e-11,  -9.529889756230143e-12,   3.157654890570785e-13,   1.438486051868125e-14,  -1.353094562247531e-15,   1.691869443352747e-17,
   2.519613741284941e-18,  -1.296416946190686e-19,   2.734162618541056e-01,  -1.004650948499247e-02,   3.230112372624275e-04,  -7.370894112917554e-06,   4.221444018328729e-08,
   3.508735447371701e-09,  -1.234791611674353e-11,  -9.441840973072266e-12,   3.064751236716234e-13,   1.448934646847835e-14,  -1.326757196588664e-15,   1.551518904343786e-17,
   2.493280682617683e-18,  -1.242866098243223e-19,   2.734809678757363e-01,  -1.005091207664514e-02,   3.230617994625089e-04,  -7.364137548197375e-06,   4.219183696378566e-08,
   3.470426002746587e-09,  -1.081191604342327e-11,  -9.335128784425127e-12,   2.953273746078118e-13,   1.461026741106517e-14,  -1.295045610792313e-15,   1.384776746345451e-17,
   2.460659096039961e-18,  -1.178953660759397e-19,   2.735437865795763e-01,  -1.005518478723692e-02,   3.231108788524799e-04,  -7.357602438454530e-06,   4.217130008089193e-08,
   3.433379756236782e-09,  -9.340282092663483e-12,  -9.231287722419204e-12,   2.845954165838987e-13,   1.472203740693993e-14,  -1.264404684373519e-15,   1.225992204026368e-17,
   2.428197643286253e-18,  -1.117788891900455e-19,   2.735943948163829e-01,  -1.005862593413146e-02,   3.231504128245633e-04,  -7.352355030036637e-06,   4.215575564657730e-08,
   3.403639007637435e-09,  -8.168650421987786e-12,  -9.147463114513893e-12,   2.760142600238605e-13,   1.480809649777905e-14,  -1.239825323884731e-15,   1.100270445857769e-17,
   2.401495092941838e-18,  -1.069145136285975e-19,   2.736278369668175e-01,  -1.006089934610644e-02,   3.231765344182913e-04,  -7.348896037813264e-06,   4.214597066369738e-08,
   3.384037441357851e-09,  -7.401235149766755e-12,  -9.091991361036370e-12,   2.703754301798328e-13,   1.486303105279068e-14,  -1.223635436702364e-15,   1.018262242151802e-17,
   2.383586682797397e-18,  -1.037310148284367e-19,   2.736450114604138e-01,  -1.006206671707204e-02,   3.231899485828351e-04,  -7.347122274845604e-06,   4.214109541746420e-08,
   3.373986754947817e-09,  -7.009221221797653e-12,  -9.063479058412605e-12,   2.674893307770279e-13,   1.489064890167880e-14,  -1.215337256992309e-15,   9.764753832147309e-18,
   2.374309624567710e-18,  -1.021056496399202e-19,   2.736509892557835e-01,  -1.006247300977083e-02,   3.231946174238467e-04,  -7.346505313243641e-06,   4.213942233613432e-08,
   3.370491014817754e-09,  -6.873109498031975e-12,  -9.053551164768286e-12,   2.664863418538982e-13,   1.490016736531177e-14,  -1.212451572556624e-15,   9.619832090455759e-18,
   2.371068006928792e-18,  -1.015414401260925e-19,   2.736519378522204e-01,  -1.006253748180825e-02,   3.231953583007633e-04,  -7.346407429527426e-06,   4.213915796953261e-08,
   3.369936407387157e-09,  -6.851526207914379e-12,  -9.051975559201246e-12,   2.663272546154411e-13,   1.490167334999469e-14,  -1.211993776519862e-15,   9.596859723489372e-18,
   2.370553008625848e-18,  -1.014519796899967e-19,   8.442827366204951e-01,  -3.036378902832255e-02,   8.707660488921117e-04,  -8.342526736747846e-06,  -9.723659660393023e-07,
   6.612706131303179e-08,  -1.362255596868311e-09,  -7.361336848085187e-11,   6.622188004368121e-12,  -1.624445595959589e-13,  -6.736674874906644e-15,   6.863762668447645e-16,
  -1.817446958746081e-17,  -6.516515337799863e-19,   8.443632533506755e-01,  -3.036592181315979e-02,   8.702094981067187e-04,  -8.281818295550229e-06,  -9.740847768888950e-07,
   6.597496825754684e-08,  -1.345522303546592e-09,  -7.407589288812981e-11,   6.591094665034074e-12,  -1.591224553320895e-13,  -6.823707591572809e-15,   6.809020080588267e-16,
  -1.761650355206477e-17,  -6.654463350482258e-19,   8.445052828744151e-01,  -3.036967149047907e-02,   8.692267154461668e-04,  -8.174815353137630e-06,  -9.770987738166618e-07,
   6.570589917942734e-08,  -1.316064056325695e-09,  -7.488307099711728e-11,   6.535953529365877e-12,  -1.532841800372197e-13,  -6.974541924293209e-15,   6.711693623089428e-16,
  -1.663830256357326e-17,  -6.891313906063064e-19,   8.446769522676966e-01,  -3.037418237638081e-02,   8.680370681191495e-04,  -8.045627891579308e-06,  -9.807112072036827e-07,
   6.537935666999781e-08,  -1.280559006652310e-09,  -7.584389814835316e-11,   6.468811234817220e-12,  -1.462649627758695e-13,  -7.152289072956824e-15,   6.592782910647052e-16,
  -1.546632518845991e-17,  -7.166609897690518e-19,   8.448435281773153e-01,  -3.037853712888277e-02,   8.668808711779587e-04,  -7.920426529486905e-06,  -9.841845244775424e-07,
   6.506113012376558e-08,  -1.246213461231762e-09,  -7.676077085191238e-11,   6.403151709595449e-12,  -1.394934730740844e-13,  -7.320008949012508e-15,   6.476099373841069e-16,
  -1.434005803309228e-17,  -7.422335492124527e-19,   8.449776638177682e-01,  -3.038202784036322e-02,   8.659485220524129e-04,  -7.819717847355329e-06,  -9.869585795204929e-07,
   6.480390210496663e-08,  -1.218632986868442e-09,  -7.748805337222884e-11,   6.349919731360748e-12,  -1.340691746416997e-13,  -7.451678538585131e-15,   6.381230321877675e-16,
  -1.344102447572295e-17,  -7.620158857947905e-19,   8.450662709537403e-01,  -3.038432591773103e-02,   8.653319881727218e-04,  -7.753245843857308e-06,  -9.887798924057896e-07,
   6.463350848877108e-08,  -1.200451448748221e-09,  -7.796309380398548e-11,   6.314582000847373e-12,  -1.305000066560599e-13,  -7.537005670390079e-15,   6.318125730677319e-16,
  -1.285103148663060e-17,  -7.746898676391151e-19,   8.451117665108938e-01,  -3.038550345620954e-02,   8.650152285109163e-04,  -7.719132355030961e-06,  -9.897115993282715e-07,
   6.454587347231457e-08,  -1.191127731236488e-09,  -7.820534162006075e-11,   6.296384462461624e-12,  -1.286717558139900e-13,  -7.580308111558861e-15,   6.285591577449870e-16,
  -1.254930583796484e-17,  -7.810761643336501e-19,   8.451276003112380e-01,  -3.038591289002292e-02,   8.649049551590790e-04,  -7.707262517201324e-06,  -9.900353118240622e-07,
   6.451535071326762e-08,  -1.187884657364634e-09,  -7.828938656298882e-11,   6.290042737644480e-12,  -1.280361639093498e-13,  -7.595297751796997e-15,   6.274247736069163e-16,
  -1.244448909077439e-17,  -7.832795438030786e-19,   8.451301128534322e-01,  -3.038597784163037e-02,   8.648874552413401e-04,  -7.705379111892024e-06,  -9.900866531719704e-07,
   6.451050619567787e-08,  -1.187370127440272e-09,  -7.830271044927241e-11,   6.289036018848220e-12,  -1.279353397412093e-13,  -7.597672503491137e-15,   6.272446677255878e-16,
  -1.242786569652706e-17,  -7.836282685385642e-19,   2.534504836825062e-02,  -8.321992368236975e-04,   2.591388932422658e-05,  -6.963099460368696e-07,   1.295540092411790e-08,
  -3.413819220295250e-11,  -5.178831968757087e-12,  -9.674368244945909e-14,   2.216519943435640e-14,  -9.306475304036176e-16,   2.429090954961538e-19,   1.751388692645892e-18,
  -7.636531048814508e-20,  -4.943637181835236e-23,   2.534749234490223e-02,  -8.323951939806498e-04,   2.592113984880545e-05,  -6.963439812585918e-07,   1.294880234818420e-08,
  -3.437442308122209e-11,  -5.120936052091866e-12,  -9.965347522090241e-14,   2.215315712452930e-14,  -9.217571543004720e-16,  -1.723574932314761e-19,   1.748210969815886e-18,
  -7.512306435670501e-20,  -1.022498688257460e-22,   2.535180532861818e-02,  -8.327409716250997e-04,   2.593393065708873e-05,  -6.964042309005326e-07,   1.293722511892844e-08,
  -3.479579999580114e-11,  -5.018811270352375e-12,  -1.047635692279371e-13,   2.213053409227894e-14,  -9.060860679516519e-16,  -8.989046641157783e-19,   1.742306345729710e-18,
  -7.293563534781528e-20,  -1.942132723613807e-22,   2.535702156967070e-02,  -8.331591035920987e-04,   2.594939258936109e-05,  -6.964774184366785e-07,   1.292333841907323e-08,
  -3.531305453000976e-11,  -4.895379926725506e-12,  -1.109013818055015e-13,   2.210084945461527e-14,  -8.871647406329763e-16,  -1.766903445600987e-18,   1.734664130848751e-18,
  -7.029854071511181e-20,  -3.033303381217762e-22,   2.536208638522575e-02,  -8.335650335147040e-04,   2.596439771325728e-05,  -6.965488193126200e-07,   1.290997533386202e-08,
  -3.582324789032509e-11,  -4.775619220730115e-12,  -1.168165879392455e-13,   2.206961206136114e-14,  -8.688269464874777e-16,  -2.598516141656545e-18,   1.726725522737298e-18,
  -6.774713824102476e-20,  -4.070823608261604e-22,   2.536616723614034e-02,  -8.338920559071328e-04,   2.597648204452612e-05,  -6.966065929771173e-07,   1.289929463921288e-08,
  -3.623999815927889e-11,  -4.679189371880102e-12,  -1.215508254436693e-13,   2.204272664820953e-14,  -8.540769897118029e-16,  -3.260568762631554e-18,   1.719962369244232e-18,
  -6.569816296227734e-20,  -4.891093347508353e-22,   2.536886413309327e-02,  -8.341081516446862e-04,   2.598446539949666e-05,  -6.966448940063006e-07,   1.289227835496808e-08,
  -3.651818267393654e-11,  -4.615494359222808e-12,  -1.246639717239469e-13,   2.202412384742076e-14,  -8.443419047769124e-16,  -3.694187822061332e-18,   1.715315042931704e-18,
  -6.434745405021813e-20,  -5.425525175993057e-22,   2.537024922490047e-02,  -8.342191287461595e-04,   2.598856469284376e-05,  -6.966646023202162e-07,   1.288868793588833e-08,
  -3.666190865131405e-11,  -4.582791528619855e-12,  -1.262580377335354e-13,   2.201431256074007e-14,  -8.393460679740500e-16,  -3.915681643165160e-18,   1.712873640445573e-18,
  -6.365481298665431e-20,  -5.697639761492758e-22,   2.537073133569145e-02,  -8.342577555976576e-04,   2.598999140338061e-05,  -6.966714681884747e-07,   1.288744029178141e-08,
  -3.671207130801482e-11,  -4.571410233050280e-12,  -1.268121216283370e-13,   2.201085670032741e-14,  -8.376077990880989e-16,  -3.992585224206115e-18,   1.712015200980591e-18,
  -6.341389568154744e-20,  -5.791979365863289e-22,   2.537080784083668e-02,  -8.342638851591245e-04,   2.599021779861148e-05,  -6.966725580022940e-07,   1.288724240440669e-08,
  -3.672003795534370e-11,  -4.569604236568128e-12,  -1.269000117310594e-13,   2.201030636074220e-14,  -8.373319873001057e-16,  -4.004779775881748e-18,   1.711878566743356e-18,
  -6.337567318126684e-20,  -5.806932093122349e-22,   2.377982545686460e-01,  -7.795041035757943e-03,   2.405409029323799e-04,  -6.220548774604940e-06,   9.508834384081867e-08,
   1.318074661229511e-09,  -1.212988798037629e-10,   1.106632008731253e-12,   1.995222939095774e-13,  -1.075210020696630e-14,   6.923975949372475e-17,   1.889852563384053e-17,
  -1.023957171939488e-18,   1.033979415339302e-20,   2.378209107299159e-01,  -7.796786159679153e-03,   2.405934656588142e-04,  -6.219299741859337e-06,   9.492398390305640e-08,
   1.319722789123521e-09,  -1.207733679369752e-10,   1.072914274753880e-12,   1.996339774919733e-13,  -1.065361390454097e-14,   6.353069553330062e-17,   1.893174296554462e-17,
  -1.010471730483583e-18,   9.551963922296466e-21,   2.378608917810515e-01,  -7.799865170619390e-03,   2.406861397193289e-04,  -6.217094708973235e-06,   9.463456948036451e-08,
   1.322578236347656e-09,  -1.198459633988206e-10,   1.013689652288050e-12,   1.998120158731248e-13,  -1.047973652943635e-14,   5.352509599622428e-17,   1.898585340519302e-17,
  -9.866471530559337e-19,   8.175272913801917e-21,   2.379092439383638e-01,  -7.803587852914873e-03,   2.407980767120533e-04,  -6.214426519483721e-06,   9.428563171912704e-08,
   1.325941512413267e-09,  -1.187243405180560e-10,   9.425365580421058e-13,   1.999950160471733e-13,  -1.026932982813918e-14,   4.154246873151614e-17,   1.904366291589793e-17,
  -9.577922924281191e-19,   6.533525433174078e-21,   2.379561903277334e-01,  -7.807201254505090e-03,   2.409066120549139e-04,  -6.211834394463475e-06,   9.394796264011414e-08,
   1.329113114417752e-09,  -1.176353184571211e-10,   8.739462713528704e-13,   2.001390649044287e-13,  -1.006492717245548e-14,   3.003176870427004e-17,   1.909187255104586e-17,
  -9.297375136639806e-19,   4.963829063315385e-21,   2.379940147063946e-01,  -7.810111795488321e-03,   2.409939529151711e-04,  -6.209744880043186e-06,   9.367671010426644e-08,
   1.331601456653480e-09,  -1.167579189728263e-10,   8.190376433237672e-13,   2.002311756619279e-13,  -9.900171490213235e-15,   2.084624506123756e-17,   1.912509107135794e-17,
  -9.071097296333147e-19,   3.716582362517563e-21,   2.380190108180180e-01,  -7.812034848724548e-03,   2.410516203409011e-04,  -6.208363523516505e-06,   9.349784792271115e-08,
   1.333213178823100e-09,  -1.161781110765682e-10,   7.829248458330390e-13,   2.002803808273232e-13,  -9.791263549831300e-15,   1.481940308244391e-17,   1.914431031116587e-17,
  -8.921457980631486e-19,   2.900893813622143e-21,   2.380318482704430e-01,  -7.813022372777707e-03,   2.410812211556176e-04,  -6.207653934164122e-06,   9.340611011999587e-08,
   1.334030838079687e-09,  -1.158803423214102e-10,   7.644317297981982e-13,   2.003020565086506e-13,  -9.735322598917493e-15,   1.173756822064864e-17,   1.915334000239842e-17,
  -8.844577279850592e-19,   2.484619859624368e-21,   2.380363165831891e-01,  -7.813366080683891e-03,   2.410915217360392e-04,  -6.207406923962772e-06,   9.337419848227093e-08,
   1.334313835986040e-09,  -1.157766998263679e-10,   7.580033953887032e-13,   2.003090299405788e-13,  -9.715850090794072e-15,   1.066701505089527e-17,   1.915634947100677e-17,
  -8.817813143481293e-19,   2.340149336316696e-21,   2.380370256485733e-01,  -7.813420621973207e-03,   2.410931561893014e-04,  -6.207367725371595e-06,   9.336913542523052e-08,
   1.334358668135772e-09,  -1.157602531292930e-10,   7.569837043275740e-13,   2.003101094439161e-13,  -9.712759990672260e-15,   1.049723307189981e-17,   1.915682070706701e-17,
  -8.813565806744513e-19,   2.317243674035684e-21,   7.358679223824316e-01,  -2.397561255905430e-02,   7.141509068712240e-04,  -1.544435707418296e-05,  -4.586464449106813e-08,
   2.653206947476093e-08,  -1.447558308327377e-09,   3.495210013870733e-11,   6.648229863570653e-13,  -1.001318824311707e-13,   4.258499994772621e-15,  -4.937911592015230e-17,
  -5.053289422890939e-18,   3.629248795941156e-19,   7.359347990898368e-01,  -2.397986669337060e-02,   7.141137745650385e-04,  -1.541895591618773e-05,  -4.787502914512662e-08,
   2.659543995930213e-08,  -1.445468764312904e-09,   3.461047018308994e-11,   6.816659054904093e-13,  -1.002881292601397e-13,   4.224061748694658e-15,  -4.683315644230460e-17,
  -5.124570106768889e-18,   3.611058235907192e-19,   7.360527999178522e-01,  -2.398736728261310e-02,   7.140473407938643e-04,  -1.537408855203686e-05,  -5.141986153897175e-08,
   2.670670973074241e-08,  -1.441746474970179e-09,   3.400730193450258e-11,   7.112646840009461e-13,  -1.005532735583719e-13,   4.162957858084430e-15,  -4.235285678818250e-17,
  -5.248401731002285e-18,   3.578009374978929e-19,   7.361954806158832e-01,  -2.399642701240810e-02,   7.139654520737759e-04,  -1.531975524982018e-05,  -5.570198176525758e-08,
   2.684032285097866e-08,  -1.437185507662275e-09,   3.327735572772875e-11,   7.468490788593338e-13,  -1.008559272150531e-13,   4.088502365101815e-15,  -3.695621508636782e-17,
  -5.394823708245904e-18,   3.536438052167183e-19,   7.363339850063682e-01,  -2.400521149486882e-02,   7.138843272671029e-04,  -1.526692684308409e-05,  -5.985442214825775e-08,
   2.696905212324952e-08,  -1.432695265295571e-09,   3.256814517254268e-11,   7.811763097320048e-13,  -1.011309762698445e-13,   4.015636000870635e-15,  -3.173970146390426e-17,
  -5.533493058239845e-18,   3.494414859874023e-19,   7.364455568827163e-01,  -2.401228059714760e-02,   7.138178080182380e-04,  -1.522431005751358e-05,  -6.319627701106276e-08,
   2.707205228144215e-08,  -1.429033341026835e-09,   3.199640827895995e-11,   8.086733829004607e-13,  -1.013391432732552e-13,   3.956521787397467e-15,  -2.755376765777065e-17,
  -5.642712917995100e-18,   3.459380050114147e-19,   7.365192789010908e-01,  -2.401694802872183e-02,   7.137732826113400e-04,  -1.519612090613055e-05,  -6.540289103712566e-08,
   2.713976889382191e-08,  -1.426591813737322e-09,   3.161842300455592e-11,   8.267660651879996e-13,  -1.014701447957294e-13,   3.917259890649905e-15,  -2.479595175270647e-17,
  -5.713663846152831e-18,   3.435656279893555e-19,   7.365571378495165e-01,  -2.401934383174979e-02,   7.137502402651693e-04,  -1.518163556263153e-05,  -6.653558856244132e-08,
   2.717443818873228e-08,  -1.425331246992038e-09,   3.142425170321976e-11,   8.360336863314022e-13,  -1.015353972055847e-13,   3.897035609751838e-15,  -2.338223781553977e-17,
  -5.749723325049777e-18,   3.423296750160642e-19,   7.365703148698889e-01,  -2.402017753037676e-02,   7.137421920853058e-04,  -1.517659239675972e-05,  -6.692975382930051e-08,
   2.718648820921314e-08,  -1.424891425707612e-09,   3.135665954011011e-11,   8.392555668415264e-13,  -1.015577870845747e-13,   3.889986631929266e-15,  -2.289059125011523e-17,
  -5.762214100384765e-18,   3.418966942300044e-19,   7.365724058752090e-01,  -2.402030981819946e-02,   7.137409136170608e-04,  -1.517579204892202e-05,  -6.699229860423989e-08,
   2.718839957702822e-08,  -1.424821581380422e-09,   3.134593316716610e-11,   8.397666544109175e-13,  -1.015613247775827e-13,   3.888867595170411e-15,  -2.281259320321749e-17,
  -5.764193363273478e-18,   3.418278536018888e-19,   2.238280514494955e-02,  -6.548829248129135e-04,   1.875761516068717e-05,  -5.010916043632829e-07,   1.110214748019369e-08,
  -1.390606714227996e-10,  -2.401177634519360e-12,   1.705968311311489e-13,  -1.216764932120929e-15,  -2.779638773909669e-16,   1.669496338574163e-17,  -3.872921338790527e-19,
  -7.605258537487947e-21,   9.880001528971386e-22,   2.238457616533249e-02,  -6.550243057520034e-04,   1.876384093186062e-05,  -5.012192974929809e-07,   1.109875188794410e-08,
  -1.387405212757150e-10,  -2.402963871448611e-12,   1.696150415030639e-13,  -1.148302157327913e-15,  -2.796813418564421e-16,   1.663560345587984e-17,  -3.801006460408550e-19,
  -7.876732048366431e-21,   9.877452062994284e-22,   2.238770163093711e-02,  -6.552738033855485e-04,   1.877482484670224e-05,  -5.014443748962762e-07,   1.109275882111240e-08,
  -1.381772037453298e-10,  -2.405970832192604e-12,   1.678781510585131e-13,  -1.027712739615757e-15,  -2.826817385140312e-16,   1.652954143151794e-17,  -3.674158971900367e-19,
  -8.351680407559320e-21,   9.870546388239420e-22,   2.239148178253208e-02,  -6.555755475619175e-04,   1.878810405996112e-05,  -5.017161339978893e-07,   1.108550951116130e-08,
  -1.374987541810733e-10,  -2.409360168422540e-12,   1.657702559019319e-13,  -8.822630361730574e-16,  -2.862585519903543e-16,   1.639905267265335e-17,  -3.520864176705760e-19,
  -8.919034360755091e-21,   9.858112614523779e-22,   2.239515233135129e-02,  -6.558685268224011e-04,   1.880099251087314e-05,  -5.019795280047380e-07,   1.107846960592622e-08,
  -1.368429815088815e-10,  -2.412392537746913e-12,   1.637160311546434e-13,  -7.414525277815118e-16,  -2.896771669820343e-16,   1.627005149493205e-17,  -3.372155317629201e-19,
  -9.462503007855488e-21,   9.841793012456767e-22,   2.239810988174169e-02,  -6.561045837836933e-04,   1.881137328766103e-05,  -5.021914110222339e-07,   1.107279673085513e-08,
  -1.363167489931661e-10,  -2.414650857118378e-12,   1.620555529610640e-13,  -6.282992257879101e-16,  -2.923927065629681e-16,   1.616447676249966e-17,  -3.252442716691901e-19,
  -9.895062711457909e-21,   9.825620831314312e-22,   2.240006447405581e-02,  -6.562605839645921e-04,   1.881823174479638e-05,  -5.023312711192676e-07,   1.106904744413601e-08,
  -1.359700290731634e-10,  -2.416052889202961e-12,   1.609556066290605e-13,  -5.536686085488979e-16,  -2.941682676722436e-16,   1.609391063574724e-17,  -3.173383997239611e-19,
  -1.017831329626231e-20,   9.813461051647775e-22,   2.240106834217553e-02,  -6.563407030690413e-04,   1.882175358908454e-05,  -5.024030501344345e-07,   1.106712178214737e-08,
  -1.357922830176938e-10,  -2.416745022448997e-12,   1.603898910509105e-13,  -5.153854546152231e-16,  -2.950742850974820e-16,   1.605742394028652e-17,  -3.132798286023363e-19,
  -1.032297779127936e-20,   9.806762401587922e-22,   2.240141776222497e-02,  -6.563685901399324e-04,   1.882297935122222e-05,  -5.024280261865617e-07,   1.106645150299064e-08,
  -1.357304664529566e-10,  -2.416981489946283e-12,   1.601928551420745e-13,  -5.020675564761880e-16,  -2.953887066654295e-16,   1.604468508955451e-17,  -3.118674466913996e-19,
  -1.037320240641174e-20,   9.804358743377355e-22,   2.240147321106559e-02,  -6.563730154759238e-04,   1.882317386051235e-05,  -5.024319891960280e-07,   1.106634513728007e-08,
  -1.357206593697432e-10,  -2.417018803544987e-12,   1.601615819308793e-13,  -4.999545176357792e-16,  -2.954385570766502e-16,   1.604266174461364e-17,  -3.116433327035595e-19,
  -1.038116632098348e-20,   9.803973894614648e-22,   2.100319533129610e-01,  -6.142369977265491e-03,   1.754312077836258e-04,  -4.627071144163895e-06,   9.721663151945294e-08,
  -8.121747361119094e-10,  -4.957136411759178e-11,   2.729443433747311e-12,  -4.378863271947494e-14,  -2.276344916062246e-15,   1.813088744273644e-16,  -5.241135928330841e-18,
  -3.438852574348734e-20,   1.028894850355927e-20,   2.100485089177878e-01,  -6.143673856150083e-03,   1.754854914432909e-04,  -4.627788632072517e-06,   9.714576977866712e-08,
  -8.069344626351961e-10,  -4.967082306820890e-11,   2.721147185302543e-12,  -4.303676344398050e-14,  -2.300345194372553e-15,   1.809293537241915e-16,  -5.163715653790602e-18,
  -3.804192312348299e-20,   1.033288429618979e-20,   2.100777256327595e-01,  -6.145974727459345e-03,   1.755812431475639e-04,  -4.629050698312965e-06,   9.702062548666027e-08,
  -7.977014932003446e-10,  -4.984472370092350e-11,   2.706444701198540e-12,  -4.171152486359560e-14,  -2.342367486478195e-15,   1.802417200400373e-16,  -5.026885856140566e-18,
  -4.445116144741764e-20,   1.040738526489138e-20,   2.101130617683867e-01,  -6.148757231878144e-03,   1.756969713999254e-04,  -4.630570070261082e-06,   9.686911738782405e-08,
  -7.865601032206939e-10,  -5.005228672460184e-11,   2.688558433423809e-12,  -4.011154035117848e-14,  -2.392623881855256e-15,   1.793797277147800e-16,  -4.861066052149142e-18,
  -5.213735697249368e-20,   1.049232700622500e-20,   2.101473727756699e-01,  -6.151458717041578e-03,   1.758092599829061e-04,  -4.632038009788217e-06,   9.672184664857797e-08,
  -7.757686317567775e-10,  -5.025094042129378e-11,   2.671082583759109e-12,  -3.856098248325605e-14,  -2.440827500705437e-15,   1.785111507092679e-16,  -4.699725719615873e-18,
  -5.953150104488419e-20,   1.056941328933705e-20,   2.101750185047137e-01,  -6.153635197027428e-03,   1.758996763330962e-04,  -4.633215524860098e-06,   9.660307274126106e-08,
  -7.670927035874312e-10,  -5.040893698317708e-11,   2.656924451729837e-12,  -3.731383016829415e-14,  -2.479240491774717e-15,   1.777887923359119e-16,  -4.569501243913024e-18,
  -6.543940040598630e-20,   1.062767345622383e-20,   2.101932888690006e-01,  -6.155073473283987e-03,   1.759594013337991e-04,  -4.633991141789758e-06,   9.652452364786722e-08,
  -7.613684176092539e-10,  -5.051234213423723e-11,   2.647530155036788e-12,  -3.649070725381723e-14,  -2.504417662819262e-15,   1.773004318973689e-16,  -4.483332847252238e-18,
  -6.931922672206881e-20,   1.066429521464563e-20,   2.102026723665339e-01,  -6.155812126928938e-03,   1.759900666332577e-04,  -4.634388696728907e-06,   9.648416479694819e-08,
  -7.584313916132110e-10,  -5.056513773757087e-11,   2.642693765641160e-12,  -3.606829837569448e-14,  -2.517283768400259e-15,   1.770462318816464e-16,  -4.439045581435265e-18,
  -7.130424662380972e-20,   1.068252317634397e-20,   2.102059385047406e-01,  -6.156069226861264e-03,   1.760007389610345e-04,  -4.634526948190082e-06,   9.647011433263014e-08,
  -7.574095581460263e-10,  -5.058346473075078e-11,   2.641008514869963e-12,  -3.592132379656963e-14,  -2.521751809366290e-15,   1.769572143068023e-16,  -4.423625397681906e-18,
  -7.199396107560495e-20,   1.068877548398606e-20,   2.102064568018714e-01,  -6.156110025305896e-03,   1.760024324644937e-04,  -4.634548881041332e-06,   9.646788456586588e-08,
  -7.572474274486445e-10,  -5.058637064630417e-11,   2.640740998614408e-12,  -3.589800327264412e-14,  -2.522460345201091e-15,   1.769430627824876e-16,  -4.421178162951375e-18,
  -7.210335271497181e-20,   1.068976326850411e-20,   6.502403126755536e-01,  -1.898643299083925e-02,   5.367535903647382e-04,  -1.347696674428254e-05,   2.187233969956987e-07,
   3.631206710802262e-09,  -5.148752727715365e-10,   2.500870727021314e-11,  -6.843863343953558e-13,   1.742113272443140e-15,   9.171703446530363e-16,  -5.356848477123373e-17,
   1.617006982302320e-18,  -1.110863551113686e-20,   6.502908716444386e-01,  -1.899020984167882e-02,   5.368724109313305e-04,  -1.347314891012176e-05,   2.179792734046118e-07,
   3.680405152050279e-09,  -5.165849749396796e-10,   2.500737584198825e-11,  -6.802254845576360e-13,   1.465496598503188e-15,   9.263659237356554e-16,  -5.358845436937464e-17,
   1.599885147978771e-18,  -9.998782161386656e-21,   6.503800922906045e-01,  -1.899687320960732e-02,   5.370817267136192e-04,  -1.346637480077518e-05,   2.166643354540839e-07,
   3.767210892250504e-09,  -5.195927168749653e-10,   2.500426743623494e-11,  -6.728527828325086e-13,   9.773811961190399e-16,   9.425028822339769e-16,  -5.361708913682205e-17,
   1.569431578083627e-18,  -8.040015174810120e-21,   6.504879934091987e-01,  -1.900492900848801e-02,   5.373342447928073e-04,  -1.345811957217110e-05,   2.150710315953048e-07,
   3.872166798224515e-09,  -5.232142276959862e-10,   2.499921446169479e-11,  -6.638853003477278e-13,   3.871301026932123e-16,   9.618636615785863e-16,  -5.364045775084033e-17,
   1.532197225383735e-18,  -5.670967094257006e-21,   6.505927571703858e-01,  -1.901274773800505e-02,   5.375787676380194e-04,  -1.345003862678245e-05,   2.135208680030286e-07,
   3.974044094137082e-09,  -5.267136578576612e-10,   2.499295385553036e-11,  -6.551252932187959e-13,  -1.858687780610626e-16,   9.804983484470074e-16,  -5.365135596174639e-17,
   1.495625405798921e-18,  -3.370906088454320e-21,   6.506771643843065e-01,  -1.901904518108735e-02,   5.377753092174745e-04,  -1.344348078452892e-05,   2.122696383509045e-07,
   4.056105714586628e-09,  -5.295210564047272e-10,   2.498693941242172e-11,  -6.480294671763434e-13,  -6.474474009698378e-16,   9.953945409800439e-16,  -5.365169031431755e-17,
   1.465861374040196e-18,  -1.518038542944130e-21,   6.507329444929504e-01,  -1.902320581798926e-02,   5.379049633512502e-04,  -1.343912400958318e-05,   2.114416570007149e-07,
   4.110325664833629e-09,  -5.313703923186974e-10,   2.498248978912386e-11,  -6.433217139755415e-13,  -9.524327650411192e-16,   1.005180753340366e-15,  -5.364777672608857e-17,
   1.446046864456771e-18,  -2.937915264914194e-22,   6.507615918931712e-01,  -1.902534231770586e-02,   5.379714797856850e-04,  -1.343687933942548e-05,   2.110160811679798e-07,
   4.138168621797020e-09,  -5.323183353250157e-10,   2.498005768462860e-11,  -6.408982112726337e-13,  -1.109050443060730e-15,   1.010188774736690e-15,  -5.364448838648427e-17,
   1.435825933415450e-18,   3.348716561632203e-22,   6.507715631449912e-01,  -1.902608591628033e-02,   5.379946207427394e-04,  -1.343609690601528e-05,   2.108678970992211e-07,
   4.147859360388212e-09,  -5.326479919739150e-10,   2.497918776492552e-11,  -6.400537597319480e-13,  -1.163561431225937e-15,   1.011929044354821e-15,  -5.364314031847151e-17,
   1.432261263261755e-18,   5.536747683911942e-22,   6.507731454577558e-01,  -1.902620391372149e-02,   5.379982923860143e-04,  -1.343597268975885e-05,   2.108443795520254e-07,
   4.149397134796562e-09,  -5.327002904747043e-10,   2.497904860962590e-11,  -6.399197128188921e-13,  -1.172211513329660e-15,   1.012205067280876e-15,  -5.364291673659567e-17,
   1.431695258667900e-18,   5.883953576039423e-22,   2.002928035434672e-02,  -5.260788814970003e-04,   1.371246639479918e-05,  -3.473731710825752e-07,   8.083594801548687e-09,
  -1.492669614988187e-10,   1.044440079917248e-12,   6.609228310652767e-14,  -3.361641198540715e-15,   5.854350313764541e-17,   1.936941372064419e-18,  -1.830492848847345e-19,
   6.788980978651521e-21,  -1.031620363345281e-22,   2.003057503895829e-02,  -5.261770687250051e-04,   1.371702106946911e-05,  -3.475119894362981e-07,   8.084961860406792e-09,
  -1.491341580784033e-10,   1.035814905114621e-12,   6.626462532940809e-14,  -3.352187734990816e-15,   5.757829425353756e-17,   1.977106987417923e-18,  -1.836261290143098e-19,
   6.750388047290215e-21,  -9.995531173414202e-23,   2.003285987839938e-02,  -5.263503531822405e-04,   1.372505846603054e-05,  -3.477568345821834e-07,   8.087364276254712e-09,
  -1.488995609758068e-10,   1.020616595888002e-12,   6.656606241111792e-14,  -3.335370841857227e-15,   5.587293221828207e-17,   2.047777082242737e-18,  -1.846248172099909e-19,
   6.681506446878040e-21,  -9.428940663380785e-23,   2.003562332419070e-02,  -5.265599443764973e-04,   1.373477839432797e-05,  -3.480527298600020e-07,   8.090252642647394e-09,
  -1.486154375030167e-10,   1.002274552259995e-12,   6.692601791364423e-14,  -3.314804088094244e-15,   5.380703319585852e-17,   2.132883719400374e-18,  -1.857997411029388e-19,
   6.596883636026334e-21,  -8.742569837618391e-23,   2.003830665109997e-02,  -5.267634681740603e-04,   1.374421539935583e-05,  -3.483397974038187e-07,   8.093039193693798e-09,
  -1.483391518940185e-10,   9.845062741608466e-13,   6.727069152755455e-14,  -3.294596351002306e-15,   5.179763029118741e-17,   2.215135543028765e-18,  -1.869060597123390e-19,
   6.513347684675633e-21,  -8.075015144053122e-23,   2.004046874974080e-02,  -5.269274646187225e-04,   1.375181848958579e-05,  -3.485709244285463e-07,   8.095271533344259e-09,
  -1.481162503741474e-10,   9.702196840260047e-13,   6.754493854026879e-14,  -3.278144393213068e-15,   5.017616265665177e-17,   2.281130329472744e-18,  -1.877727134280855e-19,
   6.445064860799573e-21,  -7.536400333246898e-23,   2.004189764408533e-02,  -5.270358502837773e-04,   1.375684284801911e-05,  -3.487235849321236e-07,   8.096740524375426e-09,
  -1.479688007916382e-10,   9.607927996151885e-13,   6.772448135525074e-14,  -3.267188772551347e-15,   4.910341460520724e-17,   2.324607206401596e-18,  -1.883333378533325e-19,
   6.399463559624512e-21,  -7.180099616524862e-23,   2.004263151714641e-02,  -5.270915176111063e-04,   1.375942321124676e-05,  -3.488019635665604e-07,   8.097493036641876e-09,
  -1.478930290510009e-10,   9.559558149748425e-13,   6.781616696306280e-14,  -3.261536455730477e-15,   4.855210595309004e-17,   2.346893853070023e-18,  -1.886175184941051e-19,
   6.375896757681758e-21,  -6.997004321555408e-23,   2.004288695912346e-02,  -5.271108941055453e-04,   1.376032134854840e-05,  -3.488292408088196e-07,   8.097754655464864e-09,
  -1.478666481704528e-10,   9.542729236426766e-13,   6.784799645138818e-14,  -3.259564966352860e-15,   4.836015443755521e-17,   2.354644409464521e-18,  -1.887158366934025e-19,
   6.367670540804691e-21,  -6.933257916942321e-23,   2.004292749475696e-02,  -5.271139689344672e-04,   1.376046387143478e-05,  -3.488335691815011e-07,   8.097796156531189e-09,
  -1.478624615166170e-10,   9.540059035846205e-13,   6.785304343446614e-14,  -3.259251921255727e-15,   4.832969136924393e-17,   2.355874006364891e-18,  -1.887314102601737e-19,
   6.366364035120813e-21,  -6.923141373491048e-23,   1.879530309344195e-01,  -4.936115951115171e-03,   1.285565763079815e-04,  -3.243624049968471e-06,   7.427370715037698e-08,
  -1.279693345526878e-09,   2.376735354346573e-12,   9.893890491333025e-13,  -4.624879094119485e-14,   9.915628482027612e-16,   1.038860051401827e-17,  -1.814987638421441e-18,
   7.813463667414239e-20,  -1.594444761205174e-21,   1.879651669786494e-01,  -4.937032381326222e-03,   1.285983652728732e-04,  -3.244806927161334e-06,   7.427563071047452e-08,
  -1.277696891934266e-09,   2.256594180229327e-12,   9.924805049205767e-13,  -4.618991131479980e-14,   9.818331945084381e-16,   1.085889878599219e-17,  -1.824814748095234e-18,
   7.786511878844510e-20,  -1.561540391073642e-21,   1.879865844059001e-01,  -4.938649704402087e-03,   1.286721031060536e-04,  -3.246892596175974e-06,   7.427888802258987e-08,
  -1.274169296284826e-09,   2.044737936945804e-12,   9.979084640937705e-13,  -4.608441625339566e-14,   9.646257633170501e-16,   1.168728232955546e-17,  -1.841956423935466e-18,
   7.737963612763187e-20,  -1.503269669679467e-21,   1.880124880206225e-01,  -4.940605844698778e-03,   1.287612685722136e-04,  -3.249411987292844e-06,   7.428259358736967e-08,
  -1.269895498005845e-09,   1.788791188685457e-12,   1.004425964279303e-12,  -4.595412419871053e-14,   9.437519106577732e-16,   1.268644042677608e-17,  -1.862345191306572e-18,
   7.677572001528238e-20,  -1.432454460516299e-21,   1.880376404905993e-01,  -4.942505308995255e-03,   1.288478297413651e-04,  -3.251855019582531e-06,   7.428594681187061e-08,
  -1.265738028149222e-09,   1.540568519879619e-12,   1.010704730982598e-12,  -4.582478860975951e-14,   9.234190910671887e-16,   1.365371097322756e-17,  -1.881782087820028e-18,
   7.617183816135596e-20,  -1.363344607306524e-21,   1.880579070695838e-01,  -4.944035834392469e-03,   1.289175628843657e-04,  -3.253821122788777e-06,   7.428847334995789e-08,
  -1.262382732134197e-09,   1.340781916224143e-12,   1.015728146622845e-12,  -4.571855860179785e-14,   9.069904272385840e-16,   1.443097030202951e-17,  -1.897184289023924e-18,
   7.567277714931057e-20,  -1.307414734945222e-21,   1.880713008597801e-01,  -4.945047345507384e-03,   1.289636415768325e-04,  -3.255119322417917e-06,   7.429005730781091e-08,
  -1.260162640167439e-09,   1.208854655166194e-12,   1.019030525887288e-12,  -4.564736673228281e-14,   8.961109703331463e-16,   1.494359689341012e-17,  -1.907236202480348e-18,
   7.533686105707199e-20,  -1.270333890626663e-21,   1.880781798291445e-01,  -4.945566856552405e-03,   1.289873052715861e-04,  -3.255785711005545e-06,   7.429084430281408e-08,
  -1.259021599870446e-09,   1.141131140187058e-12,   1.020721191521914e-12,  -4.561049826693488e-14,   8.905165674839141e-16,   1.520655180654205e-17,  -1.912359441674624e-18,
   7.516245472607362e-20,  -1.251253352172814e-21,   1.880805742156911e-01,  -4.945747685356348e-03,   1.289955416499144e-04,  -3.256017606032072e-06,   7.429111401464119e-08,
  -1.258624304589010e-09,   1.117563736017219e-12,   1.021308804643617e-12,  -4.559761684637009e-14,   8.885682291532528e-16,   1.529802714342900e-17,  -1.914136433817557e-18,
   7.510144923215498e-20,  -1.244606222266798e-21,   1.880809541765248e-01,  -4.945776380787654e-03,   1.289968486503171e-04,  -3.256054402317866e-06,   7.429115661439512e-08,
  -1.258561252384108e-09,   1.113824122063686e-12,   1.021402010935629e-12,  -4.559557041602173e-14,   8.882589999332231e-16,   1.531254071107333e-17,  -1.914418123642005e-18,
   7.509175418010289e-20,  -1.243551131434597e-21,   5.819453960940656e-01,  -1.527763921719673e-02,   3.967977492475524e-04,  -9.871758152887027e-06,   2.125755824611935e-07,
  -2.577496614025771e-09,  -8.193684420108735e-11,   7.799240247144024e-12,  -3.492727273233161e-13,   1.018838068094994e-14,  -1.395522683250107e-16,  -4.681704714026610e-18,
   4.201798934373820e-19,  -1.703112691369980e-20,   5.819828343848620e-01,  -1.528042365275439e-02,   3.969166044176000e-04,  -9.874040446656048e-06,   2.124493826636757e-07,
  -2.561609053187705e-09,  -8.286372819617897e-11,   7.832851143364625e-12,  -3.497723490144504e-13,   1.015939467462364e-14,  -1.368035795704305e-16,  -4.806273964653201e-18,
   4.234427901726579e-19,  -1.703511629980775e-20,   5.820489038094657e-01,  -1.528533733150576e-02,   3.971262659327671e-04,  -9.878055317100738e-06,   2.122256376010430e-07,
  -2.533521794946691e-09,  -8.450024142662708e-11,   7.892075001966155e-12,  -3.506443824711658e-13,   1.010772634412864e-14,  -1.319374459789549e-16,  -5.026070027830004e-18,
   4.291657032799300e-19,  -1.703978482477808e-20,   5.821288109572104e-01,  -1.529127985220814e-02,   3.973796877222522e-04,  -9.882889187504763e-06,   2.119532685106311e-07,
  -2.499467412527168e-09,  -8.648084188319463e-11,   7.963546457329304e-12,  -3.516825222821702e-13,   1.004435835516694e-14,  -1.260260559527092e-16,  -5.291825833216892e-18,
   4.360266078968678e-19,  -1.704137803843415e-20,   5.822063994437361e-01,  -1.529704963379327e-02,   3.976255967589453e-04,  -9.887559847290399e-06,   2.116869565737871e-07,
  -2.466312865688725e-09,  -8.840534842318057e-11,   8.032779057770398e-12,  -3.526731801783778e-13,   9.981909824588117e-15,  -1.202590435353670e-16,  -5.549779465453623e-18,
   4.426243876189671e-19,  -1.703866939112378e-20,   5.822689151878392e-01,  -1.530169832738382e-02,   3.978236198758991e-04,  -9.891306698116852e-06,   2.114710565979167e-07,
  -2.439535910627317e-09,  -8.995696412964688e-11,   8.088443117054618e-12,  -3.534589200653016e-13,   9.930934428240653e-15,  -1.155930203950213e-16,  -5.757547905974432e-18,
   4.478941736623620e-19,  -1.703343003119970e-20,   5.823102300917659e-01,  -1.530477041030592e-02,   3.979544317089597e-04,  -9.893774818003699e-06,   2.113277263340775e-07,
  -2.421808875051159e-09,  -9.098285508056472e-11,   8.125171296954319e-12,  -3.539720768574907e-13,   9.896923925637712e-15,  -1.124999533414376e-16,  -5.894816584253577e-18,
   4.513540140875753e-19,  -1.702846767338833e-20,   5.823314490076472e-01,  -1.530634816729179e-02,   3.980215979691655e-04,  -9.895039922212474e-06,   2.112539129270797e-07,
  -2.412694902956071e-09,  -9.150988700918288e-11,   8.144016310511642e-12,  -3.542337347708097e-13,   9.879356827569651e-15,  -1.109084812694940e-16,  -5.965303364644364e-18,
   4.531238645923096e-19,  -1.702545458426645e-20,   5.823388347219642e-01,  -1.530689733523541e-02,   3.980449739082659e-04,  -9.895479872087665e-06,   2.112281886212990e-07,
  -2.409521063807664e-09,  -9.169335510459766e-11,   8.150572830340297e-12,  -3.543245088231866e-13,   9.873226347410079e-15,  -1.103540726591037e-16,  -5.989835711720012e-18,
   4.537387688804645e-19,  -1.702433181087455e-20,   5.823400067462263e-01,  -1.530698448134498e-02,   3.980486832579557e-04,  -9.895549667971683e-06,   2.112241049675374e-07,
  -2.409017341512215e-09,  -9.172247037759567e-11,   8.151613133337155e-12,  -3.543388992449539e-13,   9.872252760774641e-15,  -1.102660727747170e-16,  -5.993728597942225e-18,
   4.538362930422318e-19,  -1.702415012601838e-20,   1.812085339932170e-02,  -4.310749907951318e-04,   1.022738673860866e-05,  -2.401258572163502e-07,   5.445401590477350e-09,
  -1.119643279937667e-10,   1.745397769023797e-12,  -3.697850343572457e-15,  -1.088404313690751e-15,   4.894653498800976e-17,   1.812231822379689e-02,  -4.311780689322681e-04,
   1.023205704272981e-05,  -2.402852466637711e-07,   5.449073995319935e-09,  -1.119713903018808e-10,   1.740923882041834e-12,  -3.448111177697697e-15,  -1.095066733973058e-15,
   4.891255659578152e-17,   1.812472345401219e-02,  -4.313473375761445e-04,   1.023972635235611e-05,  -2.405469158490269e-07,   5.455095867590189e-09,  -1.119824455362483e-10,
   1.733560442159325e-12,  -3.038280692924077e-15,  -1.105942019314962e-15,   4.885267695100855e-17,   1.812727624678794e-02,  -4.315270115574206e-04,   1.024786713761170e-05,
  -2.408245744022776e-07,   5.461476044679995e-09,  -1.119934440821018e-10,   1.725721770871789e-12,  -2.603640301308982e-15,  -1.117396691382980e-15,   4.878356536345601e-17,
   1.812928578435422e-02,  -4.316684643395161e-04,   1.025427618841773e-05,  -2.410430982069875e-07,   5.466490390767203e-09,  -1.120015702396979e-10,   1.719534316582580e-12,
  -2.261742916961563e-15,  -1.126349856762697e-15,   4.872513469103105e-17,   1.813044571871127e-02,  -4.317501189132551e-04,   1.025797586223543e-05,  -2.411692145193015e-07,
   5.469381503332174e-09,  -1.120060477086857e-10,   1.715956074489091e-12,  -2.064496310676009e-15,  -1.131492067000784e-15,   4.868979292518754e-17,   1.813088132168868e-02,
  -4.317807846858346e-04,   1.025936529379524e-05,  -2.412165728081748e-07,   5.470466621828139e-09,  -1.120076889236416e-10,   1.714611024522318e-12,  -1.990441559252339e-15,
  -1.133418312363893e-15,   4.867621536721821e-17,   1.813095353102142e-02,  -4.317858681700958e-04,   1.025959562078579e-05,  -2.412244231411693e-07,   5.470646468147587e-09,
  -1.120079588622166e-10,   1.714387990275639e-12,  -1.978166632683817e-15,  -1.133737366580722e-15,   4.867394852709796e-17,   1.700456443906473e-01,  -4.045090288057587e-03,
   9.595032623787264e-05,  -2.250129271343049e-06,   5.077238781794109e-08,  -1.024417787950411e-09,   1.466258655849541e-11,   5.854405229069048e-14,  -1.445912132501968e-14,
   6.202726170385787e-16,   1.700593863567183e-01,  -4.046056060852064e-03,   9.599385089096886e-05,  -2.251585138659626e-06,   5.080297645472029e-08,  -1.024191830004618e-09,
   1.460302722843277e-11,   6.173421178401718e-14,  -1.455340593176747e-14,   6.207781712175408e-16,   1.700819505231145e-01,  -4.047641982000437e-03,   9.606532230538634e-05,
  -2.253974926871614e-06,   5.085309973276188e-08,  -1.023813985499648e-09,   1.450498263635178e-11,   6.697291877772441e-14,  -1.470762837570404e-14,   6.215646947446691e-16,
   1.701058989715115e-01,  -4.049325376834403e-03,   9.614118431844542e-05,  -2.256510328300145e-06,   5.090615789367364e-08,  -1.023403686764143e-09,   1.440058598910576e-11,
   7.253360127523469e-14,  -1.487050334274074e-14,   6.223401410606425e-16,   1.701247509609528e-01,  -4.050650658979248e-03,   9.620090642763813e-05,  -2.258505447112814e-06,
   5.094782317102451e-08,  -1.023073989448373e-09,   1.431816262057679e-11,   7.691127273248595e-14,  -1.499812794714388e-14,   6.229075444593201e-16,   1.701356325906171e-01,
  -4.051415682208715e-03,   9.623538055449150e-05,  -2.259656765793422e-06,   5.097183217167947e-08,  -1.022880992508954e-09,   1.427048943153963e-11,   7.943824475028355e-14,
  -1.507155742149214e-14,   6.232177923178620e-16,   1.701397190868388e-01,  -4.051702989489894e-03,   9.624832731635862e-05,  -2.260089077742879e-06,   5.098084081905520e-08,
  -1.022808005676051e-09,   1.425256784729214e-11,   8.038724572443230e-14,  -1.509908821921535e-14,   6.233310373768684e-16,   1.701403964998111e-01,  -4.051750616548866e-03,
   9.625047350046581e-05,  -2.260160738596238e-06,   5.098233376337984e-08,  -1.022795879917222e-09,   1.424959604286410e-11,   8.054456131497533e-14,  -1.510364958700817e-14,
   6.233496375223076e-16,   5.265113403336859e-01,  -1.252374604420842e-02,   2.968597885407431e-04,  -6.934546434490391e-06,   1.538053217060791e-07,  -2.890815869387027e-09,
   2.635921864608821e-11,   1.262376082667317e-12,  -9.685143366357200e-14,   4.050996034749010e-15,   5.265538503403029e-01,  -1.252672095772599e-02,   2.969914034903894e-04,
  -6.938625244719904e-06,   1.538567914365574e-07,  -2.886703507351730e-09,   2.595733020043901e-11,   1.283583591296316e-12,  -9.762156544502864e-14,   4.068057687815429e-15,
   5.266236509805601e-01,  -1.253160601009093e-02,   2.972075009625434e-04,  -6.945316900014489e-06,   1.539406587669277e-07,  -2.879906298556797e-09,   2.529534949756040e-11,
   1.318461116447009e-12,  -9.888548250866724e-14,   4.095907404405648e-15,   5.266977333189337e-01,  -1.253679112679673e-02,   2.974368379537962e-04,  -6.952411295587969e-06,
   1.540287923383077e-07,  -2.872631206810122e-09,   2.458992606349744e-11,   1.355552754217338e-12,  -1.002260539391292e-13,   4.125239619978637e-15,   5.267560498783985e-01,
  -1.254087307010716e-02,   2.976173567929094e-04,  -6.957990280661683e-06,   1.540975325722276e-07,  -2.866860197738765e-09,   2.403257480922962e-11,   1.384804543986652e-12,
  -1.012806765965210e-13,   4.148164958095264e-15,   5.267897108649019e-01,  -1.254322933193983e-02,   2.977215494824805e-04,  -6.961208274953240e-06,   1.541369543521910e-07,
  -2.863511388787045e-09,   2.371004311786520e-11,   1.401710479246744e-12,  -1.018891468740216e-13,   4.161331420476973e-15,   5.268023519131380e-01,  -1.254411422475724e-02,
   2.977606770853262e-04,  -6.962416332782154e-06,   1.541517103966248e-07,  -2.862250426676000e-09,   2.358876420492178e-11,   1.408063381352182e-12,  -1.021175999546704e-13,
   4.166263381523238e-15,   5.268044474012700e-01,  -1.254426091331709e-02,   2.977671631620820e-04,  -6.962616568176265e-06,   1.541541539294146e-07,  -2.862041222044587e-09,
   2.356865178229106e-11,   1.409116705870649e-12,  -1.021554675317813e-13,   4.167080281264192e-15,   1.654382686238775e-02,  -3.594565864455416e-04,   7.801884070944871e-06,
  -1.687258003590075e-07,   3.602116800910193e-09,  -7.391785072456719e-11,   1.361463708695421e-12,  -1.824500036012350e-14,  -3.281294532477295e-17,   1.355856074237458e-17,
   1.654494334621872e-02,  -3.595289925135281e-04,   7.804976167022729e-06,  -1.688314403524420e-07,   3.605020424389078e-09,  -7.397121246314840e-11,   1.361256558608372e-12,
  -1.817261558533215e-14,  -3.648956434942028e-17,   1.366784544880528e-17,   1.654677655586432e-02,  -3.596478914984918e-04,   7.810054134398554e-06,  -1.690049199025879e-07,
   3.609786832024477e-09,  -7.405865614851113e-11,   1.360905868013202e-12,  -1.805338278941709e-14,  -4.253084622827599e-17,   1.384683279213514e-17,   1.654872216901259e-02,
  -3.597740969710967e-04,   7.815444684582054e-06,  -1.691890689633570e-07,   3.614843860321764e-09,  -7.415122511509095e-11,   1.360519316007151e-12,  -1.792632282241984e-14,
  -4.894851194756841e-17,   1.403617421900631e-17,   1.655025369256338e-02,  -3.598734535388837e-04,   7.819688838324926e-06,  -1.693340486405388e-07,   3.618823400085585e-09,
  -7.422392094793909e-11,   1.360204634464346e-12,  -1.782593223978409e-14,  -5.400452754834230e-17,   1.418476408729925e-17,   1.655113769135919e-02,  -3.599308070658151e-04,
   7.822138928873155e-06,  -1.694177406286721e-07,   3.621119920421791e-09,  -7.426581230729236e-11,   1.360018829337321e-12,  -1.776783727950363e-14,  -5.692454337474792e-17,
   1.427034727995200e-17,   1.655146966563055e-02,  -3.599523463256775e-04,   7.823059095756173e-06,  -1.694491718409669e-07,   3.621982258037667e-09,  -7.428153103972598e-11,
   1.359948264276217e-12,  -1.774599228532076e-14,  -5.802143038635331e-17,   1.430245214214902e-17,   1.655152469638049e-02,  -3.599559168950452e-04,   7.823211633631700e-06,
  -1.694543822272863e-07,   3.622125201324887e-09,  -7.428413601703863e-11,   1.359936525246382e-12,  -1.774236959561116e-14,  -5.820327571567362e-17,   1.430777226508672e-17,
   1.552470785381759e-01,  -3.373116942741937e-03,   7.320849936381726e-05,  -1.582715927089498e-06,   3.373883172319441e-08,  -6.883898061280108e-10,   1.241834511378690e-11,
  -1.507466758018094e-13,  -1.307120439718718e-15,   1.691103471708072e-16,   1.552575548806988e-01,  -3.373796113671680e-03,   7.323745679763074e-05,  -1.583699223978515e-06,
   3.376526585223000e-08,  -6.888257900827510e-10,   1.241221136797468e-11,  -1.498430366779427e-13,  -1.351619478655669e-15,   1.705014925421014e-16,   1.552747564955056e-01,
  -3.374911386976087e-03,   7.328501140255573e-05,  -1.585313907358954e-06,   3.380865179670249e-08,  -6.895395522343496e-10,   1.240201310166619e-11,  -1.483544377983525e-13,
  -1.424771743470742e-15,   1.727823580729797e-16,   1.552930128207043e-01,  -3.376095191805681e-03,   7.333549265107400e-05,  -1.587027811357744e-06,   3.385467399592664e-08,
  -6.902942173220794e-10,   1.239101684284916e-11,  -1.467679547795925e-13,  -1.502526749938151e-15,   1.751984978607253e-16,   1.553073836010916e-01,  -3.377027151985154e-03,
   7.337523768419303e-05,  -1.588377096439839e-06,   3.389088374597893e-08,  -6.908861890649174e-10,   1.238223582365910e-11,  -1.455143467051738e-13,  -1.563817190734925e-15,
   1.770970441901078e-16,   1.553156784448276e-01,  -3.377565124525566e-03,   7.339818174279867e-05,  -1.589155968772509e-06,   3.391177707894999e-08,  -6.912270428468783e-10,
   1.237711721599355e-11,  -1.447888472902418e-13,  -1.599227671937404e-15,   1.781915270239958e-16,   1.553187934652082e-01,  -3.377767161265892e-03,   7.340679867882530e-05,
  -1.589448475842051e-06,   3.391962196969409e-08,  -6.913548883308631e-10,   1.237518550072788e-11,  -1.445160338792616e-13,  -1.612531919943227e-15,   1.786022865352470e-16,
   1.553193098362456e-01,  -3.377800652945190e-03,   7.340822712334682e-05,  -1.589496964803283e-06,   3.392092233226195e-08,  -6.913760727111648e-10,   1.237486478328064e-11,
  -1.444707910479880e-13,  -1.614737671763631e-15,   1.786703636422069e-16,   4.806926848718836e-01,  -1.044402246375458e-02,   2.266347950133667e-04,  -4.894664555520633e-06,
   1.038345955891470e-07,  -2.077970955069038e-09,   3.471365509598476e-11,  -2.460896802583529e-13,  -1.524250171024833e-14,   1.015942746059717e-15,   4.807251157996428e-01,
  -1.044612257115136e-02,   2.267238684941728e-04,  -4.897627048376544e-06,   1.039079008665379e-07,  -2.078618663688590e-09,   3.464741309939406e-11,  -2.406324986678321e-13,
  -1.550682223162158e-14,   1.025330592456445e-15,   4.807783656461256e-01,  -1.044957115279431e-02,   2.268701420157960e-04,  -4.902491089362336e-06,   1.040281381968275e-07,
  -2.079670029875738e-09,   3.453789861236911e-11,  -2.316387761417091e-13,  -1.594184110158347e-14,   1.040757375012333e-15,   4.808348803958205e-01,  -1.045323160876405e-02,
   2.270254106326507e-04,  -4.907653061511605e-06,   1.041555757391985e-07,  -2.080769324888895e-09,   3.442065041297944e-11,  -2.220483125004181e-13,  -1.640491447353537e-14,
   1.057146690656753e-15,   4.808793668872154e-01,  -1.045611330784413e-02,   2.271476520630514e-04,  -4.911716169840588e-06,   1.042557652994400e-07,  -2.081622651871939e-09,
   3.432761759860904e-11,  -2.144662041704512e-13,  -1.677042900990289e-14,   1.070059687130685e-15,   4.809050445542489e-01,  -1.045777675392290e-02,   2.272182176961146e-04,
  -4.914061311499671e-06,   1.043135446131342e-07,  -2.082110373186287e-09,   3.427362230690428e-11,  -2.100766392103599e-13,  -1.698180431216231e-14,   1.077517789054751e-15,
   4.809146874621885e-01,  -1.045840146273827e-02,   2.272447191398707e-04,  -4.914941981115192e-06,   1.043352333536154e-07,  -2.082292618240071e-09,   3.425328898130168e-11,
  -2.084257080849610e-13,  -1.706125899619757e-14,   1.080319461776767e-15,   4.809162859485362e-01,  -1.045850502076807e-02,   2.272491123100421e-04,  -4.915087967110248e-06,
   1.043388281520427e-07,  -2.082322780500968e-09,   3.424991540387377e-11,  -2.081519051287371e-13,  -1.707443402713862e-14,   1.080783935998399e-15,   1.521925606892988e-02,
  -3.042622523444176e-04,   6.079472929599351e-06,  -1.213148001969362e-07,   2.409953157609491e-09,  -4.716933027099626e-11,   8.844659228382725e-13,  -1.478747892203377e-14,
   1.744596170846909e-16,   7.667470301802943e-19,   1.522012538242024e-02,  -3.043142828438986e-04,   6.081541400131355e-06,  -1.213822979402851e-07,   2.411849146263391e-09,
  -4.721343789887065e-11,   8.851416525509681e-13,  -1.478236795835658e-14,   1.735295855844497e-16,   8.106691299198457e-19,   1.522155271573656e-02,  -3.043997202473472e-04,
   6.084938302008941e-06,  -1.214931517449417e-07,   2.414962750716524e-09,  -4.728583589724530e-11,   8.862482578394072e-13,  -1.477381378538430e-14,   1.719965323679011e-16,
   8.829150974654062e-19,   1.522306751834124e-02,  -3.044904043730126e-04,   6.088544271653884e-06,  -1.216108378070820e-07,   2.418267926262997e-09,  -4.736263952170311e-11,
   8.874187525845982e-13,  -1.476451438262470e-14,   1.703613440191812e-16,   9.597641398115165e-19,   1.522425988716125e-02,  -3.045617938520137e-04,   6.091383343244929e-06,
  -1.217035019566955e-07,   2.420870129017560e-09,  -4.742307246088328e-11,   8.883372521530732e-13,  -1.475703419466721e-14,   1.690682893237701e-16,   1.020382042003748e-18,
   1.522494811120448e-02,  -3.046030023740639e-04,   6.093022289860549e-06,  -1.217569981256185e-07,   2.422372316261726e-09,  -4.745794466441680e-11,   8.888662569960311e-13,
  -1.475265241829853e-14,   1.683195763597045e-16,   1.055420652544374e-18,   1.522520656218406e-02,  -3.046184781449056e-04,   6.093637818112917e-06,  -1.217770898475781e-07,
   2.422936479015244e-09,  -4.747103860516029e-11,   8.890646992867652e-13,  -1.475099475860142e-14,   1.680379612003054e-16,   1.068588339067134e-18,   1.522524940497787e-02,
  -3.046210435577969e-04,   6.093739855347596e-06,  -1.217804205163106e-07,   2.423030001101204e-09,  -4.747320906466301e-11,   8.890975831523680e-13,  -1.475071933084631e-14,
   1.679912548749657e-16,   1.070771616465855e-18,   1.428173601911902e-01,  -2.855190763152180e-03,   5.704895321966353e-05,  -1.138307263117192e-06,   2.260325321337206e-08,
  -4.416416255673924e-10,   8.230183237090032e-12,  -1.346423236971306e-13,   1.426999625958227e-15,   1.650457529172651e-17,   1.428255176901692e-01,  -2.855678964625360e-03,
   5.706835280892915e-05,  -1.138939133818620e-06,   2.262088588235939e-08,  -4.420423980107162e-10,   8.235636164761397e-12,  -1.345439579140780e-13,   1.415838112661734e-15,
   1.701718195574318e-17,   1.428389115568485e-01,  -2.856480622149851e-03,   5.710021127758463e-05,  -1.139976863411500e-06,   2.264984105107686e-08,  -4.427001093470815e-10,
   8.244555451141252e-12,  -1.343805620721749e-13,   1.397439496983639e-15,   1.786061339947267e-17,   1.428531262195943e-01,  -2.857331508918156e-03,   5.713403039645852e-05,
  -1.141078533953325e-06,   2.268057596050098e-08,  -4.433976886037387e-10,   8.253975109428233e-12,  -1.342045833679232e-13,   1.377814940396158e-15,   1.875814120795319e-17,
   1.428643152146024e-01,  -2.858001354051021e-03,   5.716065695401558e-05,  -1.141945959263011e-06,   2.270477261007763e-08,  -4.439464657500126e-10,   8.261356193997575e-12,
  -1.340641994778174e-13,   1.362296297890014e-15,   1.946636434143748e-17,   1.428707733965551e-01,  -2.858388012067631e-03,   5.717602796420605e-05,  -1.142446729603229e-06,
   2.271874021509839e-08,  -4.442630864352628e-10,   8.265603009644116e-12,  -1.339824235045671e-13,   1.353310512772824e-15,   1.987583920056642e-17,   1.428731986582180e-01,
  -2.858533220608923e-03,   5.718180074480803e-05,  -1.142634804505122e-06,   2.272398580222765e-08,  -4.443819636949890e-10,   8.267195279306129e-12,  -1.339515724851515e-13,
   1.349930652025264e-15,   2.002974176788141e-17,   1.428736006879733e-01,  -2.858557291773982e-03,   5.718275770873713e-05,  -1.142665982229501e-06,   2.272485536567225e-08,
  -4.444016684061455e-10,   8.267459091358802e-12,  -1.339464509230070e-13,   1.349370095810137e-15,   2.005526073801535e-17,   4.422068183831101e-01,  -8.840523850868054e-03,
   1.766340826783596e-04,  -3.523511924123364e-06,   6.987381754759668e-08,  -1.357715591372004e-09,   2.478749654190439e-11,  -3.747333402627346e-13,   2.209923469905837e-15,
   1.522388099837124e-16,   4.422320752973198e-01,  -8.842034976595633e-03,   1.766940443471198e-04,  -3.525453378670815e-06,   6.992681643556887e-08,  -1.358821641973807e-09,
   2.479500036415433e-11,  -3.738779630402903e-13,   2.147614168268096e-15,   1.550351435676475e-16,   4.422735448266742e-01,  -8.844516335375932e-03,   1.767925138684283e-04,
  -3.528641722422342e-06,   7.001383356838372e-08,  -1.360635506003694e-09,   2.480713708144277e-11,  -3.724632596043529e-13,   2.044876168017173e-15,   1.596401784331093e-16,
   4.423175556540153e-01,  -8.847150066291887e-03,   1.768970421384274e-04,  -3.532026338836246e-06,   7.010618010386447e-08,  -1.362557565186446e-09,   2.481976698294905e-11,
  -3.709479000719396e-13,   1.935254662302351e-15,   1.645460479925480e-16,   4.423521985271086e-01,  -8.849223418387247e-03,   1.769793386563438e-04,  -3.534691161906290e-06,
   7.017886778386418e-08,  -1.364068350253647e-09,   2.482952659638049e-11,  -3.697449638368676e-13,   1.848540755413687e-15,   1.684211632696397e-16,   4.423721940605650e-01,
  -8.850420227787432e-03,   1.770268465024266e-04,  -3.536229528935548e-06,   7.022082142226563e-08,  -1.364939494769040e-09,   2.483508664880639e-11,  -3.690465733187796e-13,
   1.798319409642721e-15,   1.706632480444946e-16,   4.423797030460965e-01,  -8.850869686488136e-03,   1.770446886124722e-04,  -3.536807285227536e-06,   7.023657621153669e-08,
  -1.365266474334711e-09,   2.483716079535130e-11,  -3.687835349670666e-13,   1.779427306315658e-15,   1.715062467281422e-16,   4.423809477924037e-01,  -8.850944193068467e-03,
   1.770476463263991e-04,  -3.536903061042590e-06,   7.023918783444522e-08,  -1.365320668279207e-09,   2.483750389111368e-11,  -3.687398911204269e-13,   1.776293902527248e-15,
   1.716460424608033e-16,   1.409109823824177e-02,  -2.608589288492041e-04,   4.827297838506623e-06,  -8.927869298445300e-08,   1.648562363843579e-09,  -3.028270731955929e-11,
   5.473482479627113e-13,  -9.460507509477438e-15,   1.453827199877232e-16,  -1.553837269460328e-18,   1.409178804238008e-02,  -2.608971970351927e-04,   4.828712115830292e-06,
  -8.932202734977011e-08,   1.649737600362668e-09,  -3.031110199170539e-11,   5.479260489507221e-13,  -9.468199819323822e-15,   1.453127936695970e-16,  -1.543925618869878e-18,
   1.409292061408860e-02,  -2.609600338859193e-04,   4.831034608491425e-06,  -8.939319698268821e-08,   1.651667832018009e-09,  -3.035773288202522e-11,   5.488743895735322e-13,
  -9.480790705536594e-15,   1.451959366577113e-16,  -1.527576736098002e-18,   1.409412255946320e-02,  -2.610267268989854e-04,   4.833499941817847e-06,  -8.946875323882573e-08,
   1.653717167358290e-09,  -3.040723416032912e-11,   5.498803592206962e-13,  -9.494099777278016e-15,   1.450691352737829e-16,  -1.510124171785856e-18,   1.409506864109125e-02,
  -2.610792278739678e-04,   4.835440888486274e-06,  -8.952824521503159e-08,   1.655330881235790e-09,  -3.044620803693024e-11,   5.506718478644711e-13,  -9.504537159221839e-15,
   1.449673055168094e-16,  -1.496312733619223e-18,   1.409561470115338e-02,  -2.611095325150926e-04,   4.836561334004447e-06,  -8.956259074694117e-08,   1.656262538243700e-09,
  -3.046870706950385e-11,   5.511285445034244e-13,  -9.510545933275270e-15,   1.449077199635402e-16,  -1.488311327952532e-18,   1.409581976307310e-02,  -2.611209132114392e-04,
   4.836982126739197e-06,  -8.957549001888990e-08,   1.656612451084189e-09,  -3.047715689699431e-11,   5.513000220998607e-13,  -9.512799477309305e-15,   1.448851903021776e-16,
  -1.485300943217593e-18,   1.409585375559848e-02,  -2.611227997776368e-04,   4.837051882022968e-06,  -8.957762837303261e-08,   1.656670457647231e-09,  -3.047855764101985e-11,
   5.513284460913074e-13,  -9.513172886111265e-15,   1.448814475237166e-16,  -1.484801624023747e-18,   1.322307441751547e-01,  -2.447897343698630e-03,   4.529918842884062e-05,
  -8.377711969511245e-07,   1.546800170498749e-08,  -2.839918380928578e-10,   5.123389600460701e-12,  -8.799330449374678e-14,   1.323128804380363e-15,  -1.269214646295153e-17,
   1.322372172683950e-01,  -2.448256442802534e-03,   4.531245803849429e-05,  -8.381775675968123e-07,   1.547900043906019e-08,  -2.842557846453738e-10,   5.128636849916192e-12,
  -8.805519237722631e-14,   1.321951388042782e-15,  -1.257624265557894e-17,   1.322478452738080e-01,  -2.448846088035080e-03,   4.533424905860670e-05,  -8.388449626947289e-07,
   1.549706472388179e-08,  -2.846892272588492e-10,   5.137247533489650e-12,  -8.815635542726311e-14,   1.319995000369990e-15,  -1.238507428945084e-17,   1.322591242784880e-01,
  -2.449471918407128e-03,   4.535738027104644e-05,  -8.395534901088864e-07,   1.551624330845946e-08,  -2.851493217476686e-10,   5.146379305299724e-12,  -8.826310295576911e-14,
   1.317887163751645e-15,  -1.218101433027841e-17,   1.322680022683439e-01,  -2.449964574194983e-03,   4.537559136051297e-05,  -8.401113725907173e-07,   1.553134490434078e-08,
  -2.855115472664318e-10,   5.153562532016710e-12,  -8.834668210788625e-14,   1.316205097427461e-15,  -1.201953704748499e-17,   1.322731264727084e-01,  -2.450248945199803e-03,
   4.538610402425213e-05,  -8.404334448000943e-07,   1.554006351619776e-08,  -2.857206461655414e-10,   5.157706689665743e-12,  -8.839474374632834e-14,   1.315225033015700e-15,
  -1.192599188695571e-17,   1.322750507650118e-01,  -2.450355738738168e-03,   4.539005214214951e-05,  -8.405544064042557e-07,   1.554333804365793e-08,  -2.857991745934488e-10,
   5.159262591964796e-12,  -8.841275851525906e-14,   1.314855247269010e-15,  -1.189079790450907e-17,   1.322753697494184e-01,  -2.450373441791608e-03,   4.539070662601150e-05,
  -8.405744585918423e-07,   1.554388087521173e-08,  -2.858121923163711e-10,   5.159520490764155e-12,  -8.841574298648814e-14,   1.314793856997802e-15,  -1.188496047093254e-17,
   4.094274359029542e-01,  -7.579444776080338e-03,   1.402591353891802e-04,  -2.593821266379711e-06,   4.787412836235581e-08,  -8.776095706181113e-10,   1.573894803156131e-11,
  -2.647544226769108e-13,   3.684304382052858e-15,  -1.989517585714582e-17,   4.094474783992830e-01,  -7.580556572785664e-03,   1.403002038411469e-04,  -2.595076861848989e-06,
   4.790789669350133e-08,  -8.784021079328121e-10,   1.575343555543858e-11,  -2.648398159672541e-13,   3.675119642000363e-15,  -1.928408644221040e-17,   4.094803856567354e-01,
  -7.582382156081063e-03,   1.403676452481934e-04,  -2.597138940802362e-06,   4.796335512384842e-08,  -8.797033598153039e-10,   1.577719202741202e-11,  -2.649777035769450e-13,
   3.659921115497446e-15,  -1.827605482370908e-17,   4.095153085858926e-01,  -7.584319769979630e-03,   1.404392342015971e-04,  -2.599328074769473e-06,   4.802223102072600e-08,
  -8.810843218390050e-10,   1.580236239867600e-11,  -2.651208781598184e-13,   3.643630427858966e-15,  -1.719988026207732e-17,   4.095427973046145e-01,  -7.585845065368620e-03,
   1.404955956583819e-04,  -2.601051737599683e-06,   4.806858851975215e-08,  -8.821713128854728e-10,   1.582214461415222e-11,  -2.652312798324766e-13,   3.630690611319923e-15,
  -1.634815566416306e-17,   4.095586632615752e-01,  -7.586725496753282e-03,   1.405281312063569e-04,  -2.602046818988412e-06,   4.809535109492768e-08,  -8.827987027703113e-10,
   1.583355044526212e-11,  -2.652940793094376e-13,   3.623175003524611e-15,  -1.585469390513605e-17,   4.095646214037323e-01,  -7.587056136527477e-03,   1.405403501875606e-04,
  -2.602420542783434e-06,   4.810540236227690e-08,  -8.830343063183027e-10,   1.583783138735949e-11,  -2.653174877955809e-13,   3.620343773777928e-15,  -1.566903183074216e-17,
   4.095656090678313e-01,  -7.587110946334550e-03,   1.405423757408664e-04,  -2.602482496061433e-06,   4.810706859096272e-08,  -8.830733616312259e-10,   1.583854090592193e-11,
  -2.653213589352082e-13,   3.619873979499765e-15,  -1.563823656406026e-17,   1.311869180809619e-02,  -2.261193180753149e-04,   3.896316143255981e-06,  -6.711446096130994e-08,
   1.155310869573463e-09,  -1.985145631119725e-11,   3.391478265646863e-13,  -5.697024090806172e-15,   9.147622235168640e-17,  -1.306965621579168e-18,   1.311924827461845e-02,
  -2.261480710631481e-04,   3.897306727201100e-06,  -6.714285578505615e-08,   1.156039169834079e-09,  -1.986858825836162e-11,   3.395139808614399e-13,  -5.703700519001818e-15,
   9.155650717336518e-17,  -1.306269849798844e-18,   1.312016190705595e-02,  -2.261952825434210e-04,   3.898933381968028e-06,  -6.718948815106630e-08,   1.157235358422171e-09,
  -1.989672753130425e-11,   3.401153111909476e-13,  -5.714658214969720e-15,   9.168788230011426e-17,  -1.305105754427499e-18,   1.312113148113305e-02,  -2.262453895324494e-04,
   3.900660001414699e-06,  -6.723899271541554e-08,   1.158505376191486e-09,  -1.992660505459878e-11,   3.407536794179611e-13,  -5.726281406660998e-15,   9.182670127583768e-17,
  -1.303840763757928e-18,   1.312189464201236e-02,  -2.262848326576179e-04,   3.902019303988159e-06,  -6.727797046524155e-08,   1.159505443944105e-09,  -1.995013299618325e-11,
   3.412563026780602e-13,  -5.735426154307911e-15,   9.193553087100381e-17,  -1.302823583516353e-18,   1.312233511756593e-02,  -2.263075995291906e-04,   3.902803962109521e-06,
  -6.730047226277489e-08,   1.160082825961080e-09,  -1.996371711201319e-11,   3.415464660482889e-13,  -5.740702646906305e-15,   9.199816900702685e-17,  -1.302227862663344e-18,
   1.312250052816961e-02,  -2.263161493723380e-04,   3.903098642691389e-06,  -6.730892323027908e-08,   1.160299680873445e-09,  -1.996881915618690e-11,   3.416554422044793e-13,
  -5.742683809251964e-15,   9.202165814031199e-17,  -1.302002519684698e-18,   1.312252794774858e-02,  -2.263175666658548e-04,   3.903147491991408e-06,  -6.731032416868559e-08,
   1.160335629906809e-09,  -1.996966494967286e-11,   3.416735074546000e-13,  -5.743012203993181e-15,   9.202555010491443e-17,  -1.301965079087908e-18,   1.231056917963372e-01,
  -2.121901648357409e-03,   3.656297485736276e-05,  -6.297982213283699e-07,   1.084106395283938e-08,  -1.862540601224367e-10,   3.180248408161828e-12,  -5.331793334275241e-14,
   8.507508053330468e-16,  -1.190376814311518e-17,   1.231109136695343e-01,  -2.122171464563124e-03,   3.657227014799495e-05,  -6.300646289026701e-07,   1.084789298983441e-08,
  -1.864143673058483e-10,   3.183651710133147e-12,  -5.337860901206795e-14,   8.514009795914224e-16,  -1.189252586535391e-17,   1.231194871820901e-01,  -2.122614494070103e-03,
   3.658753409979176e-05,  -6.305021453567336e-07,   1.085910921753764e-08,  -1.866776683539343e-10,   3.189240625685898e-12,  -5.347817446977093e-14,   8.524634596123161e-16,
  -1.187382554888119e-17,   1.231285856500663e-01,  -2.123084694824460e-03,   3.660373608026748e-05,  -6.309666088695004e-07,   1.087101765004335e-08,  -1.869572289174220e-10,
   3.195173396193688e-12,  -5.358376153120717e-14,   8.535841693336027e-16,  -1.185365025688537e-17,   1.231357471397836e-01,  -2.123454826552409e-03,   3.661649128710747e-05,
  -6.313323068717045e-07,   1.088039482560921e-08,  -1.871773732417294e-10,   3.199844321072560e-12,  -5.366681556871738e-14,   8.544613310922387e-16,  -1.183753061208228e-17,
   1.231398805554514e-01,  -2.123668469392148e-03,   3.662385423562645e-05,  -6.315434236081413e-07,   1.088580865243700e-08,  -1.873044744083822e-10,   3.202540723987935e-12,
  -5.371473009709696e-14,   8.549656111848671e-16,  -1.182813060701252e-17,   1.231414327659522e-01,  -2.123748700562101e-03,   3.662661941156950e-05,  -6.316227123806917e-07,
   1.088784199057379e-08,  -1.873522119064013e-10,   3.203553386098180e-12,  -5.373271914053398e-14,   8.551546046439896e-16,  -1.182458244522852e-17,   1.231416900708494e-01,
  -2.123762000351878e-03,   3.662707779571061e-05,  -6.316358562806409e-07,   1.088817906617295e-08,  -1.873601255941098e-10,   3.203721256506820e-12,  -5.373570090547979e-14,
   8.551859135456510e-16,  -1.182399331712220e-17,   3.811734513078765e-01,  -6.570065554214944e-03,   1.132101221019574e-04,  -1.950020891515427e-06,   3.356397236201378e-08,
  -5.764054911583402e-10,   9.825347328720140e-12,  -1.637290973737593e-13,   2.560096058102046e-15,  -3.330371009240868e-17,   3.811896198138075e-01,  -6.570900974555712e-03,
   1.132389000807535e-04,  -1.950845315145243e-06,   3.358506708483985e-08,  -5.768974735187406e-10,   9.835567947715674e-12,  -1.638974373653258e-13,   2.561066323833314e-15,
  -3.322003725924421e-17,   3.812161660131279e-01,  -6.572272707663629e-03,   1.132861568490435e-04,  -1.952199247158897e-06,   3.361971326661117e-08,  -5.777055043180866e-10,
   9.852349400664256e-12,  -1.641734758753995e-13,   2.562634464709227e-15,  -3.308148379981892e-17,   3.812443376334055e-01,  -6.573728569731501e-03,   1.133363176859994e-04,
  -1.953636563207495e-06,   3.365649699228127e-08,  -5.785633792343180e-10,   9.870159385140846e-12,  -1.644659383076696e-13,   2.564264688524334e-15,  -3.293284488593177e-17,
   3.812665117803270e-01,  -6.574874592297321e-03,   1.133758073865239e-04,  -1.954768237898799e-06,   3.368546150914547e-08,  -5.792388870662848e-10,   9.884178487241263e-12,
  -1.646957903521668e-13,   2.565523196428529e-15,  -3.281468676234795e-17,   3.812793100902999e-01,  -6.575536085153472e-03,   1.133986028205217e-04,  -1.955421549733164e-06,
   3.370218372455758e-08,  -5.796288783533653e-10,   9.892270197401765e-12,  -1.648283145871680e-13,   2.566239660496375e-15,  -3.274602186016564e-17,   3.812841162052941e-01,
  -6.575784501358197e-03,   1.134071637072976e-04,  -1.955666912677367e-06,   3.370846425963983e-08,  -5.797753508832625e-10,   9.895308905123927e-12,  -1.648780545099861e-13,
   2.566506835417546e-15,  -3.272014786817275e-17,   3.812849128993778e-01,  -6.575825680905439e-03,   1.134085828482397e-04,  -1.955707587094557e-06,   3.370950541031681e-08,
  -5.797996322217142e-10,   9.895812624422673e-12,  -1.648862983332683e-13,   2.566551025039270e-15,  -3.271585415152956e-17,   1.227186206981121e-02,  -1.978835863716168e-04,
   3.190048046296026e-06,  -5.141227697682628e-08,   8.282946204014548e-10,  -1.333517694014994e-11,   2.142612452916900e-13,  -3.421797628896087e-15,   5.372119640873297e-17,
  -8.067291981003374e-19,   1.227231746460214e-02,  -1.979056027741645e-04,   3.190757887896846e-06,  -5.143134087234175e-08,   8.287545464937863e-10,  -1.334546924480763e-11,
   2.144767371519502e-13,  -3.425951306541026e-15,   5.379032884656322e-17,  -8.075060366583408e-19,   1.227306514230843e-02,  -1.979417521662491e-04,   3.191923492459940e-06,
  -5.146264795724599e-08,   8.295099228711876e-10,  -1.336237471456516e-11,   2.148307008747572e-13,  -3.432773086147215e-15,   5.390379419380063e-17,  -8.087772167348515e-19,
   1.227385858599339e-02,  -1.979801174913952e-04,   3.193160676031487e-06,  -5.149588162607667e-08,   8.303118886936723e-10,  -1.338032494069258e-11,   2.152065541019053e-13,
  -3.440015380392898e-15,   5.402415284424127e-17,  -8.101204073463381e-19,   1.227448310265225e-02,  -1.980103170165734e-04,   3.194134626324158e-06,  -5.152204715136631e-08,
   8.309433682043329e-10,  -1.339446071045979e-11,   2.155025482807788e-13,  -3.445717891251337e-15,   5.411884864820732e-17,  -8.111734121218093e-19,   1.227484355241770e-02,
  -1.980277480835779e-04,   3.194696824479221e-06,  -5.153715197918454e-08,   8.313079389785690e-10,  -1.340262228699055e-11,   2.156734507498825e-13,  -3.449010036831697e-15,
   5.417348845753821e-17,  -8.117794752925708e-19,   1.227497891036875e-02,  -1.980342940631146e-04,   3.194907956724469e-06,  -5.154282478463078e-08,   8.314448638086341e-10,
  -1.340568771073172e-11,   2.157376411511703e-13,  -3.450246480727790e-15,   5.419400415599610e-17,  -8.120067461615975e-19,   1.227500134817572e-02,  -1.980353791761626e-04,
   3.194942956037209e-06,  -5.154376517513923e-08,   8.314675623717393e-10,  -1.340619588397408e-11,   2.157482824110265e-13,  -3.450451450099815e-15,   5.419740481585471e-17,
  -8.120444030917420e-19,   1.151590489661695e-01,  -1.856937869763982e-03,   2.993537990043710e-05,  -4.824518131748862e-07,   7.772647996035050e-09,  -1.251317224722895e-10,
   2.010223753734580e-12,  -3.208491261850204e-14,   5.027451625914891e-16,  -7.504389966797472e-18,   1.151633223863521e-01,  -1.857144471230510e-03,   2.994204099002284e-05,
  -4.826307001410745e-07,   7.776963010120722e-09,  -1.252282241981838e-10,   2.012240046797047e-12,  -3.212352822068607e-14,   5.033745291593036e-16,  -7.510771057330893e-18,
   1.151703385864947e-01,  -1.857483696376081e-03,   2.995297891758435e-05,  -4.829244715733275e-07,   7.784049922124227e-09,  -1.253867309240464e-10,   2.015551928387660e-12,
  -3.218694525709549e-14,   5.044073068567574e-16,  -7.521199811064694e-18,   1.151777842541158e-01,  -1.857843715787850e-03,   2.996458853529164e-05,  -4.832363210812337e-07,
   7.791573922745329e-09,  -1.255550323566163e-10,   2.019068550275116e-12,  -3.225426717187227e-14,   5.055025745942389e-16,  -7.532201624406102e-18,   1.151836447122032e-01,
  -1.858127107500182e-03,   2.997372799536954e-05,  -4.834818462909054e-07,   7.797498421325779e-09,  -1.256875687005026e-10,   2.021837930417752e-12,  -3.230727263096989e-14,
   5.063641249946843e-16,  -7.540813653301168e-18,   1.151870271691983e-01,  -1.858290680267119e-03,   2.997900361098385e-05,  -4.836235829894110e-07,   7.800918796536544e-09,
  -1.257640909860373e-10,   2.023436907278008e-12,  -3.233787221557092e-14,   5.068611683176426e-16,  -7.545765138961827e-18,   1.151882973668571e-01,  -1.858352107601504e-03,
   2.998098485644927e-05,  -4.836768139584881e-07,   7.802203414202922e-09,  -1.257928320976703e-10,   2.024037473812445e-12,  -3.234936438043556e-14,   5.070477799158922e-16,
  -7.547620931998214e-18,   1.151885079230133e-01,  -1.858362290279527e-03,   2.998131328676126e-05,  -4.836856381455172e-07,   7.802416370249298e-09,  -1.257975966771294e-10,
   2.024137033423905e-12,  -3.235126946174182e-14,   5.070787117083336e-16,  -7.547928369373241e-18,   3.565681790757596e-01,  -5.749656185243285e-03,   9.268919965277706e-05,
  -1.493815692723628e-06,   2.406597780141850e-08,  -3.873970873787185e-10,   6.220591187641625e-12,  -9.911100502822389e-14,   1.543741183100430e-15,  -2.260702190226118e-17,
   3.565814109060158e-01,  -5.750295885158753e-03,   9.270982393286518e-05,  -1.494369505336924e-06,   2.407932989337890e-08,  -3.876951319572663e-10,   6.226778854655228e-12,
  -9.922710491150526e-14,   1.545501500923003e-15,  -2.261776845670363e-17,   3.566031352310539e-01,  -5.751346227615170e-03,   9.274369029115399e-05,  -1.495278985734777e-06,
   2.410125908005051e-08,  -3.881846713401625e-10,   6.236941963431782e-12,  -9.941773971992187e-14,   1.548388205678581e-15,  -2.263518092594968e-17,   3.566261893201130e-01,
  -5.752460955302192e-03,   9.277963635058753e-05,  -1.496244432609212e-06,   2.412454064847485e-08,  -3.887044515992523e-10,   6.247732668366030e-12,  -9.962006924069999e-14,
   1.551446925945544e-15,  -2.265334350817313e-17,   3.566443351102689e-01,  -5.753338420707874e-03,   9.280793422591120e-05,  -1.497004547042793e-06,   2.414287278563066e-08,
  -3.891137684233236e-10,   6.256229973459975e-12,  -9.977934037494523e-14,   1.553851023117923e-15,  -2.266740973910408e-17,   3.566548082428787e-01,  -5.753844890852423e-03,
   9.282426874593872e-05,  -1.497443345308273e-06,   2.415345639776003e-08,  -3.893500921992583e-10,   6.261135922734268e-12,  -9.987127346465824e-14,   1.555237212351563e-15,
  -2.267543601539159e-17,   3.566587411675322e-01,  -5.754035088225757e-03,   9.283040313744829e-05,  -1.497608141363477e-06,   2.415743136343909e-08,  -3.894388528466912e-10,
   6.262978531131894e-12,  -9.990579799961966e-14,   1.555757500791386e-15,  -2.267843260887932e-17,   3.566593931144882e-01,  -5.754066616838009e-03,   9.283142003318929e-05,
  -1.497635459878943e-06,   2.415809030857143e-08,  -3.894535671820781e-10,   6.263283989662433e-12,  -9.991152107995082e-14,   1.555843733397999e-15,  -2.267892842081589e-17,
   1.152775460645129e-02,  -1.746242980499198e-04,   2.644639539990187e-06,  -4.004319145375652e-08,   6.061533651466207e-10,  -9.172446705590519e-12,   1.386956772506785e-13,
  -2.092759786719737e-15,   3.138270656463482e-17,  -4.626818003515194e-19,   1.152813200230816e-02,  -1.746414396846248e-04,   2.645158787114602e-06,  -4.005629768042533e-08,
   6.064509234192072e-10,  -9.178739015087637e-12,   1.388215992791891e-13,  -2.095147553046207e-15,   3.142480870405476e-17,  -4.633307021966393e-19,   1.152875161238445e-02,
  -1.746695845097944e-04,   2.646011399445083e-06,  -4.007782016135162e-08,   6.069396082428225e-10,  -9.189074028746915e-12,   1.390284421131302e-13,  -2.099069859354329e-15,
   3.149395817931647e-17,  -4.643957856608572e-19,   1.152940913955899e-02,  -1.746994538604032e-04,   2.646916337357518e-06,  -4.010066599882206e-08,   6.074584054143483e-10,
  -9.200047305399162e-12,   1.392480834519258e-13,  -2.103234992870350e-15,   3.156737451808568e-17,  -4.655256529168540e-19,   1.152992666976009e-02,  -1.747229651908233e-04,
   2.647628709551354e-06,  -4.011865218251205e-08,   6.078668933220555e-10,  -9.208688422794507e-12,   1.394210619206719e-13,  -2.106515337286176e-15,   3.162518491577151e-17,
  -4.664146659247293e-19,   1.153022536775073e-02,  -1.747365356408590e-04,   2.648039906166456e-06,  -4.012903492284270e-08,   6.081027165941821e-10,  -9.213677422085255e-12,
   1.395209391245395e-13,  -2.108409435073060e-15,   3.165856097145191e-17,  -4.669276518525746e-19,   1.153033753582220e-02,  -1.747416317825257e-04,   2.648194328325948e-06,
  -4.013293422942031e-08,   6.081912851184011e-10,  -9.215551226876498e-12,   1.395584530718138e-13,  -2.109120866583808e-15,   3.167109638056159e-17,  -4.671202677293041e-19,
   1.153035612949693e-02,  -1.747424765569235e-04,   2.648219926734230e-06,  -4.013358062085260e-08,   6.082059673861966e-10,  -9.215861857204475e-12,   1.395646720237481e-13,
  -2.109238805980450e-15,   3.167317442892198e-17,  -4.671521957495730e-19,   1.081763509106694e-01,  -1.638672920896907e-03,   2.481727427358972e-05,  -3.757648754139902e-07,
   5.688127743761475e-09,  -8.607324322018824e-11,   1.301450775109705e-12,  -1.963410742206637e-14,   2.942557362337702e-16,  -4.330144037192346e-18,   1.081798923900646e-01,
  -1.638833777806583e-03,   2.482214687451018e-05,  -3.758878627072404e-07,   5.690919870004904e-09,  -8.613227621505835e-11,   1.302631399600749e-12,  -1.965644994551838e-14,
   2.946473281486939e-16,  -4.336066091049968e-18,   1.081857068055594e-01,  -1.639097888532907e-03,   2.483014776537703e-05,  -3.760898271288128e-07,   5.695505423135719e-09,
  -8.622923679666633e-11,   1.304570715156041e-12,  -1.969315071765934e-14,   2.952904562713093e-16,  -4.345784705570254e-18,   1.081918770347685e-01,  -1.639378182186145e-03,
   2.483863967794467e-05,  -3.763042097527937e-07,   5.700373532120671e-09,  -8.633218522851777e-11,   1.306630014200564e-12,  -1.973212283585181e-14,   2.959732262690140e-16,
  -4.356092237194622e-18,   1.081967335336120e-01,  -1.639598812248333e-03,   2.484532455898952e-05,  -3.764729899491836e-07,   5.704206557782118e-09,  -8.641325381866963e-11,
   1.308251805341719e-12,  -1.976281564089522e-14,   2.965108306826074e-16,  -4.364200894593852e-18,   1.081995365129216e-01,  -1.639726157199789e-03,   2.484918321666019e-05,
  -3.765704203369175e-07,   5.706419392945353e-09,  -8.646005918785002e-11,   1.309188218564770e-12,  -1.978053769260174e-14,   2.968211969971792e-16,  -4.368879172487127e-18,
   1.082005890971150e-01,  -1.639773979336194e-03,   2.485063230992921e-05,  -3.766070109602573e-07,   5.707250470878828e-09,  -8.647763868041481e-11,   1.309539935323426e-12,
  -1.978719413088744e-14,   2.969377623161656e-16,  -4.370635648523853e-18,   1.082007635799946e-01,  -1.639781906689693e-03,   2.485087252468337e-05,  -3.766130766195581e-07,
   5.707388241134669e-09,  -8.648055292345288e-11,   1.309598241857125e-12,  -1.978829761688310e-14,   2.969570857238077e-16,  -4.370926795608805e-18,   3.349475776516682e-01,
  -5.073840245769333e-03,   7.684198303905030e-05,  -1.163483946577613e-06,   1.761211917642203e-08,  -2.665013005748317e-10,   4.029081462396026e-12,  -6.075393445531321e-14,
   9.089097493626916e-16,  -1.329915440817037e-17,   3.349585431707818e-01,  -5.074338308328401e-03,   7.685707003905691e-05,  -1.163864740692002e-06,   1.762076304184663e-08,
  -2.666839577848442e-10,   4.032727595831330e-12,  -6.082251550312322e-14,   9.100892593711977e-16,  -1.331588828249864e-17,   3.349765464053320e-01,  -5.075156076516513e-03,
   7.688184314036715e-05,  -1.164490064212766e-06,   1.763495898485604e-08,  -2.669839675933514e-10,   4.038716713995322e-12,  -6.093516416062146e-14,   9.120261129259958e-16,
  -1.334333344403638e-17,   3.349956513495349e-01,  -5.076023952027137e-03,   7.690813658745818e-05,  -1.165153836874853e-06,   1.765002964439237e-08,  -2.673025030006880e-10,
   4.045076253001579e-12,  -6.105477698722618e-14,   9.140819348571912e-16,  -1.337241902123215e-17,   3.350106885768759e-01,  -5.076707090673085e-03,   7.692883493511556e-05,
  -1.165676414921576e-06,   1.766189588593034e-08,  -2.675533382166526e-10,   4.050084590506360e-12,  -6.114897360959519e-14,   9.157003592561906e-16,  -1.339528336224779e-17,
   3.350193674705504e-01,  -5.077101389874571e-03,   7.694078246792268e-05,  -1.165978079300061e-06,   1.766874635274513e-08,  -2.676981587385742e-10,   4.052976341814675e-12,
  -6.120336063945133e-14,   9.166345754711373e-16,  -1.340846826884886e-17,   3.350226265978168e-01,  -5.077249461941370e-03,   7.694526928447691e-05,  -1.166091371333038e-06,
   1.767131919212979e-08,  -2.677525513655342e-10,   4.054062476824069e-12,  -6.122378810448127e-14,   9.169854190607388e-16,  -1.341341733024911e-17,   3.350231668509519e-01,
  -5.077274007469952e-03,   7.694601305960406e-05,  -1.166110151850888e-06,   1.767174569929536e-08,  -2.677615683066389e-10,   4.054242532629678e-12,  -6.122717449154319e-14,
   9.170435783089723e-16,  -1.341423760220477e-17,   1.086874411433295e-02,  -1.552372395482829e-04,   2.216794082247623e-06,  -3.164953210115825e-08,   4.517722104984733e-10,
  -6.447191369861680e-12,   9.197508198023100e-14,  -1.311084071974508e-15,   1.864856641811471e-17,  -2.635832170530324e-19,   1.086906035840277e-02,  -1.552507839691548e-04,
   2.217180943134666e-06,  -3.165874021259619e-08,   4.519694306763352e-10,  -6.451131250444731e-12,   9.204988073104032e-14,  -1.312444792172128e-15,   1.867223005973211e-17,
  -2.639689986381723e-19,   1.086957956421212e-02,  -1.552730221779354e-04,   2.217816159907288e-06,  -3.167386087979068e-08,   4.522933151932212e-10,  -6.457602148188386e-12,
   9.217274328941603e-14,  -1.314680065639234e-15,   1.871110352211010e-17,  -2.646026490985397e-19,   1.087013053606008e-02,  -1.552966225102259e-04,   2.218490339871261e-06,
  -3.168991059871208e-08,   4.526371389722909e-10,  -6.464472276602345e-12,   9.230320283138222e-14,  -1.317053809134077e-15,   1.875238628459239e-17,  -2.652754455813552e-19,
   1.087056419316091e-02,  -1.553151989012305e-04,   2.219021043174533e-06,  -3.170254581153572e-08,   4.529078440102670e-10,  -6.469882005414489e-12,   9.240594245045936e-14,
  -1.318923366922104e-15,   1.878490138509536e-17,  -2.658052610520764e-19,   1.087081448093356e-02,  -1.553259208244881e-04,   2.219327370592438e-06,  -3.170983944364315e-08,
   4.530641188599305e-10,  -6.473005229263818e-12,   9.246526247100545e-14,  -1.320002890322756e-15,   1.880367664608463e-17,  -2.661111564252902e-19,   1.087090846946380e-02,
  -1.553299472259021e-04,   2.219442408688682e-06,  -3.171257857819713e-08,   4.531228102555282e-10,  -6.474178250855482e-12,   9.248754282885928e-14,  -1.320408368913913e-15,
   1.881072886367947e-17,  -2.662260474435010e-19,   1.087092404956538e-02,  -1.553306146707863e-04,   2.219461478380109e-06,  -3.171303264495168e-08,   4.531325396500528e-10,
  -6.474372707580843e-12,   9.249123638618226e-14,  -1.320475588430035e-15,   1.881189797099709e-17,  -2.662450935537059e-19,   1.019922020783732e-01,  -1.456744931597585e-03,
   2.080237666329747e-05,  -2.969989244127378e-07,   4.239424888574821e-09,  -6.050023713313032e-11,   8.630820076175862e-13,  -1.230247274181047e-14,   1.749572840892276e-16,
  -2.471455902413108e-18,   1.019951697100100e-01,  -1.456872032320334e-03,   2.080600696097559e-05,  -2.970853330159945e-07,   4.241275574658438e-09,  -6.053720658150623e-11,
   8.637837434634631e-13,  -1.231523064262326e-14,   1.751787323063989e-16,  -2.475046363291784e-18,   1.020000419328684e-01,  -1.457080715469976e-03,   2.081196782713088e-05,
  -2.972272248381475e-07,   4.244314860613060e-09,  -6.059792553619198e-11,   8.649363955874662e-13,  -1.233618811823095e-14,   1.755425110783526e-16,  -2.480943468507295e-18,
   1.020052122479602e-01,  -1.457302180774185e-03,   2.081829432335824e-05,  -2.973778348465597e-07,   4.247541253393758e-09,  -6.066239059681311e-11,   8.661603176349549e-13,
  -1.235844372386536e-14,   1.759288287326305e-16,  -2.487204525691093e-18,   1.020092816824719e-01,  -1.457476501458848e-03,   2.082327443640580e-05,  -2.974964032452223e-07,
   4.250081510188719e-09,  -6.071315214303460e-11,   8.671241802351575e-13,  -1.237597211488897e-14,   1.762330945914885e-16,  -2.492134735070886e-18,   1.020116303807818e-01,
  -1.457577115889399e-03,   2.082614900899249e-05,  -2.975648464348542e-07,   4.251547970596944e-09,  -6.074245853310966e-11,   8.676806966282502e-13,  -1.238609334968291e-14,
   1.764087852848192e-16,  -2.494981145064821e-18,   1.020125123683427e-01,  -1.457614899603723e-03,   2.082722852502068e-05,  -2.975905503779133e-07,   4.252098722077717e-09,
  -6.075346543643459e-11,   8.678897217929085e-13,  -1.238989496790326e-14,   1.764747764476564e-16,  -2.496050206016160e-18,   1.020126585718822e-01,  -1.457621162900458e-03,
   2.082740747476180e-05,  -2.975948113244816e-07,   4.252190021293311e-09,  -6.075529009702553e-11,   8.679243732238845e-13,  -1.239052519297626e-14,   1.764857163538285e-16,
  -2.496227429015575e-18,   3.157995323640515e-01,  -4.510534711657699e-03,   6.441061768568383e-05,  -9.196007767334845e-07,   1.312656137275554e-08,  -1.873261900465338e-10,
   2.672269203617263e-12,  -3.808576899945368e-14,   5.413554928248484e-16,  -7.634143743951350e-18,   3.158087210730780e-01,  -4.510928254905184e-03,   6.442185820085253e-05,
  -9.198683225277001e-07,   1.313229143767312e-08,  -1.874406378636311e-10,   2.674440417003552e-12,  -3.812517040838563e-14,   5.420355343011401e-16,  -7.644983827105216e-18,
   3.158238069879193e-01,  -4.511574402641751e-03,   6.444031487075887e-05,  -9.203076602436950e-07,   1.314170162430907e-08,  -1.876286077809008e-10,   2.678006777667548e-12,
  -3.818989438321178e-14,   5.431526045319594e-16,  -7.662785395185151e-18,   3.158398158888731e-01,  -4.512260127891237e-03,   6.445990364331332e-05,  -9.207739919317650e-07,
   1.315169112476527e-08,  -1.878281743740851e-10,   2.681793630257373e-12,  -3.825862615020665e-14,   5.443388153315318e-16,  -7.681682098031320e-18,   3.158524161217159e-01,
  -4.512799878780257e-03,   6.447532360048400e-05,  -9.211411136049963e-07,   1.315955622073289e-08,  -1.879853183445068e-10,   2.684775835901599e-12,  -3.831275797296116e-14,
   5.452730300839392e-16,  -7.696559561916275e-18,   3.158596884209739e-01,  -4.513111412253155e-03,   6.448422415865541e-05,  -9.213530332865205e-07,   1.316409664730357e-08,
  -1.880760428916647e-10,   2.686497700115204e-12,  -3.834401436740556e-14,   5.458124483686684e-16,  -7.705147894678010e-18,   3.158624193283271e-01,  -4.513228402347647e-03,
   6.448756667128448e-05,  -9.214326200408091e-07,   1.316580187328935e-08,  -1.881101172303260e-10,   2.687144423769422e-12,  -3.835575445258689e-14,   5.460150553113038e-16,
  -7.708373324379320e-18,   3.158628720198827e-01,  -4.513247795456288e-03,   6.448812075455270e-05,  -9.214458131491420e-07,   1.316608455212936e-08,  -1.881157658757235e-10,
   2.687251635202552e-12,  -3.835770069793085e-14,   5.460486429501459e-16,  -7.708908007926869e-18,   1.028101996881584e-02,  -1.389082603095530e-04,   1.876471775773481e-06,
  -2.534416330418938e-08,   3.422435304187950e-10,  -4.620733491437989e-12,   6.237221138729823e-14,  -8.416280556030989e-16,   1.134758105128904e-17,  -1.526391433841649e-19,
   1.028128759372358e-02,  -1.389191036023009e-04,   1.876764756069820e-06,  -2.535076030095875e-08,   3.423772115329606e-10,  -4.623261257406644e-12,   6.241770081288398e-14,
  -8.424157386045437e-16,   1.136076047614927e-17,  -1.528513068265693e-19,   1.028172697359302e-02,  -1.389369066634537e-04,   1.877245813330372e-06,  -2.536159294441297e-08,
   3.425967410538365e-10,  -4.627412699593909e-12,   6.249241711223410e-14,  -8.437096352648662e-16,   1.138241159627328e-17,  -1.531998562199819e-19,   1.028219323074057e-02,
  -1.389557998620198e-04,   1.877756364670041e-06,  -2.537309075859797e-08,   3.428297744698670e-10,  -4.631820019157247e-12,   6.257174861135975e-14,  -8.450836304648429e-16,
   1.140540544959675e-17,  -1.535700321615402e-19,   1.028256020736177e-02,  -1.389706709179174e-04,   1.878158252661955e-06,  -2.538214216424159e-08,   3.430132422554917e-10,
  -4.635290282248737e-12,   6.263422039139659e-14,  -8.461657476263887e-16,   1.142351646693299e-17,  -1.538616073643970e-19,   1.028277200869090e-02,  -1.389792541006351e-04,
   1.878390222718148e-06,  -2.538736693605088e-08,   3.431191528745337e-10,  -4.637293712382878e-12,   6.267028910460248e-14,  -8.467905696787636e-16,   1.143397459729411e-17,
  -1.540299792401071e-19,   1.028285154445401e-02,  -1.389824773233701e-04,   1.878477335950493e-06,  -2.538932908426948e-08,   3.431589286154191e-10,  -4.638046147637381e-12,
   6.268383610613551e-14,  -8.470252553853162e-16,   1.143790284617244e-17,  -1.540932231002570e-19,   1.028286472876432e-02,  -1.389830116267084e-04,   1.878491776541163e-06,
  -2.538965434868128e-08,   3.431655222908117e-10,  -4.638170881268267e-12,   6.268608186544494e-14,  -8.470641610034322e-16,   1.143855406858115e-17,  -1.541037076537480e-19,
   9.647700370990070e-02,  -1.303513930053642e-03,   1.760879512527476e-05,  -2.378294099141231e-07,   3.211610098920448e-09,  -4.336089899062609e-11,   5.852984343375528e-13,
  -7.897709987588101e-15,   1.064788145217694e-16,  -1.432026381908192e-18,   9.647951509974981e-02,  -1.303615683419157e-03,   1.761154444962021e-05,  -2.378913160370922e-07,
   3.212864557023314e-09,  -4.338461913460017e-11,   5.857252774809418e-13,  -7.905099727194681e-15,   1.066023858236637e-16,  -1.434012187953656e-18,   9.648363823669301e-02,
  -1.303782747191273e-03,   1.761605868642630e-05,  -2.379929694073406e-07,   3.214924613016389e-09,  -4.342357558777707e-11,   5.864263662907789e-13,  -7.917238551531546e-15,
   1.068053874422199e-16,  -1.437274492499046e-18,   9.648801358978437e-02,  -1.303960040803444e-03,   1.762084969538957e-05,  -2.381008647296074e-07,   3.217111388946025e-09,
  -4.346493314703922e-11,   5.871707607271900e-13,  -7.930128804621085e-15,   1.070209772754443e-16,  -1.440739151665975e-18,   9.649145729526426e-02,  -1.304099590663541e-03,
   1.762462100851815e-05,  -2.381858029890556e-07,   3.218833043008024e-09,  -4.349749751921083e-11,   5.877569544056720e-13,  -7.940280761625174e-15,   1.071907848099819e-16,
  -1.443468102289601e-18,   9.649344483712829e-02,  -1.304180135176022e-03,   1.762679781333822e-05,  -2.382348321718728e-07,   3.219826903830177e-09,  -4.351629737312067e-11,
   5.880953991342959e-13,  -7.946142565937805e-15,   1.072888390737463e-16,  -1.445043933154118e-18,   9.649419120005015e-02,  -1.304210381870324e-03,   1.762761528308895e-05,
  -2.382532449422440e-07,   3.220200157716738e-09,  -4.352335809963873e-11,   5.882225151326538e-13,  -7.948344282177062e-15,   1.073256698253261e-16,  -1.445635843432554e-18,
   9.649431492150552e-02,  -1.304215395768235e-03,   1.762775079345559e-05,  -2.382562972187563e-07,   3.220262032490287e-09,  -4.352452857914298e-11,   5.882435878342951e-13,
  -7.948709277199778e-15,   1.073317755983105e-16,  -1.445733970007994e-18,   2.987227654208202e-01,  -4.036083946641724e-03,   5.452229816659420e-05,  -7.363936929434013e-07,
   9.944139920582187e-09,  -1.342585952663728e-10,   1.812249434132751e-12,  -2.445270315128340e-14,   3.296313213613523e-16,  -4.430978399093635e-18,   2.987305414637075e-01,
  -4.036399006651966e-03,   5.453081092638082e-05,  -7.365853731916305e-07,   9.948024074572108e-09,  -1.343320367616883e-10,   1.813570813622020e-12,  -2.447556733844321e-14,
   3.300129944880572e-16,  -4.437080236559292e-18,   2.987433079761274e-01,  -4.036916287957371e-03,   5.454478840180985e-05,  -7.369001230433460e-07,   9.954402585098833e-09,
  -1.344526523597200e-10,   1.815741173619870e-12,  -2.451312524724993e-14,   3.306399942333676e-16,  -4.447103972776013e-18,   2.987568554280676e-01,  -4.037465244023414e-03,
   5.455962284953478e-05,  -7.372341998783129e-07,   9.961173455519047e-09,  -1.345807021305018e-10,   1.818045591323363e-12,  -2.455300788168155e-14,   3.313058624844209e-16,
  -4.457748874324261e-18,   2.987675182096786e-01,  -4.037897333714961e-03,   5.457130000308976e-05,  -7.374971946394494e-07,   9.966504178047874e-09,  -1.346815267208124e-10,
   1.819860265290294e-12,  -2.458441802826232e-14,   3.318303193303146e-16,  -4.466132939786577e-18,   2.987736722565220e-01,  -4.038146724531432e-03,   5.457804006503654e-05,
  -7.376490039440922e-07,   9.969581448983611e-09,  -1.347397341110099e-10,   1.820907984267178e-12,  -2.460255438197104e-14,   3.321331600369367e-16,  -4.470974141294190e-18,
   2.987759832279116e-01,  -4.038240377687364e-03,   5.458057120457867e-05,  -7.377060154970683e-07,   9.970737147328663e-09,  -1.347615952603669e-10,   1.821301495429187e-12,
  -2.460936645404129e-14,   3.322469111907450e-16,  -4.472792550667594e-18,   2.987763663079592e-01,  -4.038255902271908e-03,   5.458099078664517e-05,  -7.377154662760828e-07,
   9.970928728917984e-09,  -1.347652192537645e-10,   1.821366729877418e-12,  -2.461049574170639e-14,   3.322657687323119e-16,  -4.473094003900072e-18,   9.753607101601199e-03,
  -1.250264477898628e-04,   1.602390724285016e-06,  -2.053358480740074e-08,   2.630817749308334e-10,  -3.370121721616213e-12,   4.316438456358545e-14,  -5.527324118538228e-16,
   7.075459884765315e-18,  -9.048549913746513e-20,   9.753835586362714e-03,  -1.250352310256758e-04,   1.602615879222705e-06,  -2.053839475438157e-08,   2.631742510274528e-10,
  -3.371781001056086e-12,   4.319273230952330e-14,  -5.531990847894357e-16,   7.082913237582195e-18,  -9.060119222001288e-20,   9.754210704331717e-03,  -1.250496516167052e-04,
   1.602985564682216e-06,  -2.054629277085125e-08,   2.633261093305062e-10,  -3.374505986928371e-12,   4.323929123583466e-14,  -5.539656334231733e-16,   7.095157185272937e-18,
  -9.079126173613566e-20,   9.754608765099201e-03,  -1.250649550009447e-04,   1.603377907269855e-06,  -2.055467550147044e-08,   2.634873023065745e-10,  -3.377398780929974e-12,
   4.328872310687970e-14,  -5.547795847641762e-16,   7.108159923728627e-18,  -9.099313134884845e-20,   9.754922063904648e-03,  -1.250770003094366e-04,   1.603686739248215e-06,
  -2.056127443814303e-08,   2.636142051777545e-10,  -3.379676419783665e-12,   4.332764743838819e-14,  -5.554205918025606e-16,   7.118401089595434e-18,  -9.115214226844782e-20,
   9.755102883947889e-03,  -1.250839524797008e-04,   1.603864994793818e-06,  -2.056508348856616e-08,   2.636874606084566e-10,  -3.380991288591741e-12,   4.335011992827106e-14,
  -5.557906991552119e-16,   7.124314651817860e-18,  -9.124396610764373e-20,   9.755170785406695e-03,  -1.250865631997619e-04,   1.603931935790535e-06,  -2.056651395248269e-08,
   2.637149720220020e-10,  -3.381485110313912e-12,   4.335856017810956e-14,  -5.559297102221287e-16,   7.126535855432957e-18,  -9.127845737024991e-20,   9.755182041136925e-03,
  -1.250869959698370e-04,   1.603943032444023e-06,  -2.056675107908441e-08,   2.637195326051564e-10,  -3.381566972311408e-12,   4.335995935508783e-14,  -5.559527549885959e-16,
   7.126904083498731e-18,  -9.128417534459940e-20,   9.152776586191778e-02,  -1.173247119814080e-03,   1.503682088887219e-05,  -1.926869843401979e-07,   2.468757088949524e-09,
  -3.162518952848269e-11,   4.050539149854315e-13,  -5.186816615487169e-15,   6.639494121838783e-17,  -8.490592253952001e-19,   9.152990996097086e-02,  -1.173329541623860e-03,
   1.503893374084624e-05,  -1.927321208354598e-07,   2.469624883150046e-09,  -3.164076012894900e-11,   4.053199251870642e-13,  -5.191195560297576e-15,   6.646486597190079e-17,
  -8.501440208487758e-19,   9.153343006479223e-02,  -1.173464864326795e-03,   1.504240286597770e-05,  -1.928062357444323e-07,   2.471049919011586e-09,  -3.166633126796358e-11,
   4.057568258158576e-13,  -5.198388333882473e-15,   6.657973424985851e-17,  -8.519261985286737e-19,   9.153716546363881e-02,  -1.173608471153664e-03,   1.504608460540152e-05,
  -1.928848992061336e-07,   2.472562551283901e-09,  -3.169347710967376e-11,   4.062206855786512e-13,  -5.206025898304399e-15,   6.670172100411636e-17,  -8.538190084276943e-19,
   9.154010545695668e-02,  -1.173721504225570e-03,   1.504898268199509e-05,  -1.929468235629155e-07,   2.473753405761025e-09,  -3.171485036401029e-11,   4.065859444382024e-13,
  -5.212040668335293e-15,   6.679779957057624e-17,  -8.553099502838394e-19,   9.154180227070005e-02,  -1.173786743331890e-03,   1.505065543048142e-05,  -1.929825676545673e-07,
   2.474440833527201e-09,  -3.172718902991461e-11,   4.067968221840127e-13,  -5.215513500478693e-15,   6.685327820641849e-17,  -8.561709194722330e-19,   9.154243945741029e-02,
  -1.173811242306623e-03,   1.505128360421114e-05,  -1.929959911138651e-07,   2.474699000182372e-09,  -3.173182302924934e-11,   4.068760239452929e-13,  -5.216817884231850e-15,
   6.687411662303913e-17,  -8.564943197966094e-19,   9.154254508108675e-02,  -1.173815303417308e-03,   1.505138773511075e-05,  -1.929982163075589e-07,   2.474741796620144e-09,
  -3.173259121830144e-11,   4.068891535660430e-13,  -5.217034120377508e-15,   6.687757118629587e-17,  -8.565479331911048e-19,   2.833983880074184e-01,  -3.632737446939197e-03,
   4.655866729174641e-05,  -5.966187412312286e-07,   7.644038274969345e-09,  -9.792137427988068e-11,   1.254170111828852e-12,  -1.605982471801737e-14,   2.055696240585001e-16,
  -2.628458922816347e-18,   2.834050268039552e-01,  -3.632992650457660e-03,   4.656520933727522e-05,  -5.967584977850264e-07,   7.646725229256950e-09,  -9.796958514138424e-11,
   1.254993719993122e-12,  -1.607338055920028e-14,   2.057859778849788e-16,  -2.631810017423014e-18,   2.834159261385849e-01,  -3.633411651569227e-03,   4.657595082547492e-05,
  -5.969879804725338e-07,   7.651137572829365e-09,  -9.804876041502801e-11,   1.256346430565507e-12,  -1.609564710580220e-14,   2.061413897579570e-16,  -2.637315356798143e-18,
   2.834274920934743e-01,  -3.633856302901030e-03,   4.658735063351260e-05,  -5.972315468857234e-07,   7.655821141390937e-09,  -9.813281139318084e-11,   1.257782610124875e-12,
  -1.611929054714237e-14,   2.065188247537149e-16,  -2.643162351830997e-18,   2.834365952258266e-01,  -3.634206288393046e-03,   4.659632397818154e-05,  -5.974232838510162e-07,
   7.659508388183734e-09,  -9.819898885044344e-11,   1.258913506044191e-12,  -1.613791031266873e-14,   2.068160966485007e-16,  -2.647767882002735e-18,   2.834418490881362e-01,
  -3.634408288925619e-03,   4.660150332669882e-05,  -5.975339586162067e-07,   7.661636873103166e-09,  -9.823719274181309e-11,   1.259566414835261e-12,  -1.614866105714873e-14,
   2.069877497327127e-16,  -2.650427393042556e-18,   2.834438220160749e-01,  -3.634484145359320e-03,   4.660344834754431e-05,  -5.975755217986972e-07,   7.662436235386679e-09,
  -9.825154087338918e-11,   1.259811635208096e-12,  -1.615269899759607e-14,   2.070522245021780e-16,  -2.651426362593125e-18,   2.834441490597796e-01,  -3.634496719819141e-03,
   4.660377076913058e-05,  -5.975824116867275e-07,   7.662568746140767e-09,  -9.825391939714221e-11,   1.259852286455107e-12,  -1.615336839303792e-14,   2.070629130324122e-16,
  -2.651591971749203e-18,   9.277673710138240e-03,  -1.131261570997760e-04,   1.379188255154089e-06,  -1.681204689074172e-08,   2.049057154388619e-10,  -2.497029900865868e-12,
   3.042486134313515e-14,  -3.706503120053544e-16,   4.514544886597821e-18,  -5.496078530345048e-20,   9.277870331342952e-03,  -1.131333471222324e-04,   1.379363581979075e-06,
  -1.681560974224120e-08,   2.049708755358494e-10,  -2.498142102929592e-12,   3.044293960739801e-14,  -3.709336014184623e-16,   4.518857703897130e-18,  -5.502484129320826e-20,
   9.278193134974903e-03,  -1.131451518097037e-04,   1.379651449627969e-06,  -1.682145988564870e-08,   2.050778743240381e-10,  -2.499968575705253e-12,   3.047263045065720e-14,
  -3.713989046047796e-16,   4.525942203361447e-18,  -5.513007382537736e-20,   9.278535679184644e-03,  -1.131576789933929e-04,   1.379956954221474e-06,  -1.682766889791489e-08,
   2.051914462966550e-10,  -2.501907438016817e-12,   3.050415165319553e-14,  -3.718929505475346e-16,   4.533465268152559e-18,  -5.524183465354169e-20,   9.278805281096330e-03,
  -1.131675390374891e-04,   1.380197427604291e-06,  -1.683255655148694e-08,   2.052808555492046e-10,  -2.503433936570202e-12,   3.052897126345074e-14,  -3.722820014985180e-16,
   4.539390207295807e-18,  -5.532986416678538e-20,   9.278960880774711e-03,  -1.131732298966009e-04,   1.380336225396999e-06,  -1.683537776430521e-08,   2.053324664086622e-10,
  -2.504315150812233e-12,   3.054330006134572e-14,  -3.725066243275276e-16,   4.542811308985955e-18,  -5.538069705823429e-20,   9.279019311351434e-03,  -1.131753669529854e-04,
   1.380388348354140e-06,  -1.683643724328523e-08,   2.053518488849940e-10,  -2.504646101286715e-12,   3.054868159672940e-14,  -3.725909901895353e-16,   4.544096288754593e-18,
  -5.539979086132382e-20,   9.279028997127120e-03,  -1.131757212050070e-04,   1.380396988638939e-06,  -1.683661287160277e-08,   2.053550619179042e-10,  -2.504700963479475e-12,
   3.054957371227872e-14,  -3.726049759755847e-16,   4.544309309536832e-18,  -5.540295622515384e-20,   8.706161097524698e-02,  -1.061574893474331e-03,   1.294229082415330e-05,
  -1.577641045884799e-07,   1.922833479363414e-09,  -2.343210666459940e-11,   2.855065911787403e-13,  -3.478176212383271e-15,   4.236427046620702e-17,  -5.157424274299465e-19,
   8.706345606695513e-02,  -1.061642364583716e-03,   1.294393608957727e-05,  -1.577975383555826e-07,   1.923444941045633e-09,  -2.344254354903681e-11,   2.856762366780468e-13,
  -3.480834547230871e-15,   4.240473903801278e-17,  -5.163433844200895e-19,   8.706648525348434e-02,  -1.061753139670227e-03,   1.294663743712878e-05,  -1.578524360498016e-07,
   1.924449016576039e-09,  -2.345968313705887e-11,   2.859548540117368e-13,  -3.485200864768697e-15,   4.247121518011609e-17,  -5.173306478955527e-19,   8.706969968542719e-02,
  -1.061870694655083e-03,   1.294950428961737e-05,  -1.579107013662158e-07,   1.925514774800052e-09,  -2.347787738634078e-11,   2.862506473312141e-13,  -3.489836898239271e-15,
   4.254180648420195e-17,  -5.183791562510298e-19,   8.707222962746718e-02,  -1.061963221224753e-03,   1.295176088978183e-05,  -1.579565670642729e-07,   1.926353790306063e-09,
  -2.349220202137995e-11,   2.864835532506307e-13,  -3.493487678113054e-15,   4.259740204071459e-17,  -5.192050228055201e-19,   8.707368977352208e-02,  -1.062016624198103e-03,
   1.295306336707963e-05,  -1.579830413004987e-07,   1.926838106079727e-09,  -2.350047131997554e-11,   2.866180139345514e-13,  -3.495595495671019e-15,   4.262950329647111e-17,
  -5.196819212436582e-19,   8.707423808555573e-02,  -1.062036678316981e-03,   1.295355248846294e-05,  -1.579929834419103e-07,   1.927019991037934e-09,  -2.350357695326678e-11,
   2.866685139782378e-13,  -3.496387168705750e-15,   4.264156065715786e-17,  -5.198610532861787e-19,   8.707432897679215e-02,  -1.062040002614929e-03,   1.295363356882148e-05,
  -1.579946315364943e-07,   1.927050142105656e-09,  -2.350409177909501e-11,   2.866768855433826e-13,  -3.496518408632094e-15,   4.264355949661485e-17,  -5.198907497265590e-19,
   2.695697854676479e-01,  -3.286965553300438e-03,   4.007335175123307e-05,  -4.884866625845456e-07,   5.953689549989833e-09,  -7.255307396326681e-11,   8.840166618042176e-13,
  -1.076948666095515e-14,   1.311713820575136e-16,  -1.596819574797904e-18,   2.695754984445881e-01,  -3.287174464808702e-03,   4.007844600388492e-05,  -4.885901839023298e-07,
   5.955582824294648e-09,  -7.258538971075113e-11,   8.845419302287541e-13,  -1.077771725131696e-14,   1.312966602089312e-16,  -1.598679055669506e-18,   2.695848777468270e-01,
  -3.287517458878489e-03,   4.008681021474502e-05,  -4.887601641988474e-07,   5.958691752377669e-09,  -7.263845905267786e-11,   8.854046049048485e-13,  -1.079123599945177e-14,
   1.315024494875706e-16,  -1.601733833739103e-18,   2.695948306263963e-01,  -3.287881445619091e-03,   4.009568688028316e-05,  -4.889405716985591e-07,   5.961991669124925e-09,
  -7.269479394318830e-11,   8.863204609872850e-13,  -1.080558982092347e-14,   1.317209776794678e-16,  -1.604978098330538e-18,   2.696026641126510e-01,  -3.288167936613537e-03,
   4.010267401512570e-05,  -4.890825861320674e-07,   5.964589520350717e-09,  -7.273914733844714e-11,   8.870416006092827e-13,  -1.081689315220543e-14,   1.318930835683983e-16,
  -1.607533458950403e-18,   2.696071851783001e-01,  -3.288333288803675e-03,   4.010670688929275e-05,  -4.891645585824559e-07,   5.966089111614324e-09,  -7.276475158336035e-11,
   8.874579271697125e-13,  -1.082341925197172e-14,   1.319924585908556e-16,  -1.609009052642588e-18,   2.696088829226401e-01,  -3.288395382583662e-03,   4.010822136098033e-05,
  -4.891953425373349e-07,   5.966652283637135e-09,  -7.277436756153574e-11,   8.876142889267107e-13,  -1.082587038275441e-14,   1.320297842300362e-16,  -1.609563312527503e-18,
   2.696091643501353e-01,  -3.288405675642491e-03,   4.010847241094790e-05,  -4.892004455495740e-07,   5.966745640657743e-09,  -7.277596161770808e-11,   8.876402095502459e-13,
  -1.082627671996088e-14,   1.320359719812698e-16,  -1.609655197467223e-18,   8.846032362669213e-03,  -1.028474490824704e-04,   1.195586133995289e-06,  -1.389666283354207e-08,
   1.615036785095615e-10,  -1.876706928235310e-12,   2.180481147403574e-14,  -2.533079849345469e-16,   2.942261893410841e-18,  -3.416437145379301e-20,   8.846202781207067e-03,
  -1.028533913333781e-04,   1.195724297532445e-06,  -1.389933994308305e-08,   1.615503632542324e-10,  -1.877466742106132e-12,   2.181658832733755e-14,  -2.534839863106031e-16,
   2.944818495031421e-18,  -3.420065157887769e-20,   8.846482565080005e-03,  -1.028631473278334e-04,   1.195951144202086e-06,  -1.390373563449711e-08,   1.616270220188972e-10,
  -1.878714480383773e-12,   2.183592931510904e-14,  -2.537730556980435e-16,   2.949017911659881e-18,  -3.426025027375307e-20,   8.846779456779820e-03,  -1.028735003173257e-04,
   1.196191885285518e-06,  -1.390840086700133e-08,   1.617083876360974e-10,  -1.880038944892129e-12,   2.185646162789125e-14,  -2.540799637342045e-16,   2.953477000912500e-18,
  -3.432354212642709e-20,   8.847013126145801e-03,  -1.028816489893633e-04,   1.196381378195199e-06,  -1.391207320016851e-08,   1.617724407241211e-10,  -1.881081680420979e-12,
   2.187262793084500e-14,  -2.543216345854851e-16,   2.956988633888327e-18,  -3.437339156619947e-20,   8.847147986933826e-03,  -1.028863520740292e-04,   1.196490749649379e-06,
  -1.391419288442993e-08,   1.618094141985000e-10,  -1.881683613845606e-12,   2.188196073350282e-14,  -2.544611607384936e-16,   2.959016190839208e-18,  -3.440217606055729e-20,
   8.847198629564514e-03,  -1.028881181908405e-04,   1.196531821871138e-06,  -1.391498890535532e-08,   1.618232994639803e-10,  -1.881909674256875e-12,   2.188546584442706e-14,
  -2.545135642502356e-16,   2.959777733499560e-18,  -3.441298783757549e-20,   8.847207024361555e-03,  -1.028884109532396e-04,   1.196538630293386e-06,  -1.391512086029918e-08,
   1.618256012171396e-10,  -1.881947148505476e-12,   2.188604689578997e-14,  -2.545222514128449e-16,   2.959903979322094e-18,  -3.441478019807773e-20,   8.301109225167039e-02,
  -9.651195850989947e-04,   1.121937008530387e-05,  -1.304061655088552e-07,   1.515549140743285e-09,  -1.761100171068759e-11,   2.046161572975430e-13,  -2.377039468945127e-15,
   2.761013170074901e-17,  -3.205967046352891e-19,   8.301269145777627e-02,  -9.651753471308321e-04,   1.122066661075726e-05,  -1.304312874818022e-07,   1.515987229971383e-09,
  -1.761813179594158e-11,   2.047266710639253e-13,  -2.378691056210840e-15,   2.763412236347783e-17,  -3.209371335279797e-19,   8.301531694725389e-02,  -9.652668972995937e-04,
   1.122279533796892e-05,  -1.304725366122887e-07,   1.516706595135886e-09,  -1.762984055860415e-11,   2.049081665223646e-13,  -2.381403667415094e-15,   2.767352888477019e-17,
  -3.214963683544455e-19,   8.301810297643301e-02,  -9.653640496646905e-04,   1.122505445024099e-05,  -1.305163151140486e-07,   1.517470129362380e-09,  -1.764226931937228e-11,
   2.051008413501031e-13,  -2.384283675403231e-15,   2.771537211793539e-17,  -3.220902570266131e-19,   8.302029572777062e-02,  -9.654405167335927e-04,   1.122683265008799e-05,
  -1.305507762569539e-07,   1.518071202969219e-09,  -1.765205433839554e-11,   2.052525456244107e-13,  -2.386551501184905e-15,   2.774832459963353e-17,  -3.225580108064723e-19,
   8.302156126025534e-02,  -9.654846504399857e-04,   1.122785899088046e-05,  -1.305706673558601e-07,   1.518418161723015e-09,  -1.765770287519187e-11,   2.053401244635666e-13,
  -2.387860806785303e-15,   2.776735079835938e-17,  -3.228281051461009e-19,   8.302203649026982e-02,  -9.655012236650798e-04,   1.122824441225887e-05,  -1.305781372093878e-07,
   1.518548460930421e-09,  -1.765982422366368e-11,   2.053730163564096e-13,  -2.388352558396400e-15,   2.777449696571153e-17,  -3.229295555743487e-19,   8.302211526697366e-02,
  -9.655039709449359e-04,   1.122830830243512e-05,  -1.305793754734478e-07,   1.518570060561535e-09,  -1.766017588161006e-11,   2.053784689311099e-13,  -2.388434078242106e-15,
   2.777568163179562e-17,  -3.229463738763184e-19,   2.570281215687881e-01,  -2.988309963384076e-03,   3.473865407560034e-05,  -4.037779873277076e-07,   4.692610800263709e-09,
  -5.452912974067441e-11,   6.335551041956405e-13,  -7.360048148507955e-15,   8.548929623970694e-17,  -9.926543759050101e-19,   2.570330732075419e-01,  -2.988482619952085e-03,
   3.474266852104493e-05,  -4.038557727565346e-07,   4.693967260416666e-09,  -5.455120668507667e-11,   6.338972880725518e-13,  -7.365161905575025e-15,   8.556357476093467e-17,
  -9.937082450936630e-19,   2.570412025383375e-01,  -2.988766087706365e-03,   3.474925972157645e-05,  -4.039834928727071e-07,   4.696194638123708e-09,  -5.458746062763942e-11,
   6.344592526169642e-13,  -7.373560876561651e-15,   8.568558294347056e-17,  -9.954394720292384e-19,   2.570498289499062e-01,  -2.989066901600314e-03,   3.475625463474642e-05,
  -4.041190447077125e-07,   4.698558776946343e-09,  -5.462594390632861e-11,   6.350558318369313e-13,  -7.382478151853308e-15,   8.581513547655316e-17,  -9.972779743607362e-19,
   2.570566183890291e-01,  -2.989303667393225e-03,   3.476176049369916e-05,  -4.042257471065792e-07,   4.700419887291694e-09,  -5.465624134460507e-11,   6.355255538891492e-13,
  -7.389499946526604e-15,   8.591716095288022e-17,  -9.987259986637156e-19,   2.570605368706260e-01,  -2.989440319054368e-03,   3.476493836352648e-05,  -4.042873361251158e-07,
   4.701494179222597e-09,  -5.467373095744627e-11,   6.357967243065301e-13,  -7.393553906276412e-15,   8.597606869989259e-17,  -9.995621282890618e-19,   2.570620083303384e-01,
  -2.989491634906236e-03,   3.476613174780803e-05,  -4.043104651110776e-07,   4.701897625988375e-09,  -5.468029930686982e-11,   6.358985674951664e-13,  -7.395076500517487e-15,
   8.599819422093477e-17,  -9.998761876938111e-19,   2.570622522474784e-01,  -2.989500141337865e-03,   3.476632957163504e-05,  -4.043142991610965e-07,   4.701964505146641e-09,
  -5.468138814837740e-11,   6.359154503056188e-13,  -7.395328907715328e-15,   8.600186211057756e-17,  -9.999282519894761e-19,   8.452774273572546e-03,  -9.390854993255816e-05,
   1.043177852079828e-06,  -1.158667724557465e-08,   1.286787234288560e-10,  -1.428899863556540e-12,   1.586514118930533e-14,  -1.761297964932321e-16,   1.955091756343474e-18,
  -2.169643487789273e-20,   8.452922946783601e-03,  -9.391350374101245e-05,   1.043287916097311e-06,  -1.158871513581233e-08,   1.287126822893679e-10,  -1.429428005837151e-12,
   1.587296367145205e-14,  -1.762415143588925e-16,   1.956642804245713e-18,  -2.171748183071716e-20,   8.453167029280355e-03,  -9.392163684945472e-05,   1.043468624987630e-06,
  -1.159206120653480e-08,   1.287684433427675e-10,  -1.430295278573453e-12,   1.588581001680135e-14,  -1.764249954130128e-16,   1.959190400590969e-18,  -2.175205461268401e-20,
   8.453426035114769e-03,  -9.393026756264263e-05,   1.043660399622820e-06,  -1.159561238579166e-08,   1.288276265627106e-10,  -1.431215850575278e-12,   1.589944706599988e-14,
  -1.766197891764463e-16,   1.961895365116123e-18,  -2.178876729408095e-20,   8.453629885248202e-03,  -9.393706059951491e-05,   1.043811347932726e-06,  -1.159840771813744e-08,
   1.288742159685506e-10,  -1.431940583567213e-12,   1.591018390194487e-14,  -1.767731698058115e-16,   1.964025467071797e-18,  -2.181768086008405e-20,   8.453747535628517e-03,
  -9.394098124257657e-05,   1.043898471438448e-06,  -1.160002117383054e-08,   1.289011083970993e-10,  -1.432358936570722e-12,   1.591638210682943e-14,  -1.768617196082590e-16,
   1.965255304128482e-18,  -2.183437566282042e-20,   8.453791715363443e-03,  -9.394245353003296e-05,   1.043931188747157e-06,  -1.160062708307887e-08,   1.289112076734002e-10,
  -1.432516050322276e-12,   1.591870992842612e-14,  -1.768949767703798e-16,   1.965717217267202e-18,  -2.184064628108509e-20,   8.453799038831580e-03,  -9.394269758523239e-05,
   1.043936612191999e-06,  -1.160072752335112e-08,   1.289128818205914e-10,  -1.432542095127178e-12,   1.591909581579873e-14,  -1.769004899286683e-16,   1.965793791104457e-18,
  -2.184168580780118e-20,   7.932076169732183e-02,  -8.812370317080395e-04,   9.789172067609966e-06,  -1.087292804589885e-07,   1.207520043107682e-09,  -1.340878411837884e-11,
   1.488783484271520e-13,  -1.652800429311932e-15,   1.834655981009151e-17,  -2.035989267715333e-19,   7.932215684546647e-02,  -8.812835182043275e-04,   9.790204907411234e-06,
  -1.087484040035754e-07,   1.207838712762337e-09,  -1.341374020077924e-11,   1.489517545131817e-13,  -1.653848787513716e-15,   1.836111475591226e-17,  -2.037964274124829e-19,
   7.932444731353445e-02,  -8.813598392245889e-04,   9.791900678096622e-06,  -1.087798035026595e-07,   1.208361974007301e-09,  -1.342187868031604e-11,   1.490723044757850e-13,
  -1.655570570017550e-15,   1.838502125522378e-17,  -2.041208518488719e-19,   7.932687782207577e-02,  -8.814408297635396e-04,   9.793700289637496e-06,  -1.088131277384784e-07,
   1.208917348833599e-09,  -1.343051731967614e-11,   1.492002743942760e-13,  -1.657398510738640e-15,   1.841040448756081e-17,  -2.044653566448953e-19,   7.932879074998946e-02,
  -8.815045755636166e-04,   9.795116787290134e-06,  -1.088393591133384e-07,   1.209354543416774e-09,  -1.343731820753148e-11,   1.493010287435427e-13,  -1.658837831437137e-15,
   1.843039324168762e-17,  -2.047366759931872e-19,   7.932989478015499e-02,  -8.815413668446711e-04,   9.795934353524705e-06,  -1.088544997677831e-07,   1.209606901734665e-09,
  -1.344124402833951e-11,   1.493591926292605e-13,  -1.659668780972394e-15,   1.844193396152707e-17,  -2.048933367995573e-19,   7.933030936241077e-02,  -8.815551827776059e-04,
   9.796241372470572e-06,  -1.088601856149948e-07,   1.209701673256491e-09,  -1.344271838236547e-11,   1.493810368812246e-13,  -1.659980865500587e-15,   1.844626852765916e-17,
  -2.049521790681312e-19,   7.933037808577331e-02,  -8.815574729895160e-04,   9.796292266030705e-06,  -1.088611281456518e-07,   1.209717383439315e-09,  -1.344296278657949e-11,
   1.493846580440350e-13,  -1.660032600864996e-15,   1.844698709210852e-17,  -2.049619337855604e-19,   2.456017121020138e-01,  -2.728583527488645e-03,   3.031031685038921e-05,
  -3.366596192973541e-07,   3.738857059972439e-09,  -4.151775973850296e-11,   4.609735924307529e-13,  -5.117582758552100e-15,   5.680660831604082e-17,  -6.304035253577034e-19,
   2.456060319139474e-01,  -2.728727464118012e-03,   3.031351484317176e-05,  -3.367188317302083e-07,   3.739843760166035e-09,  -4.153310530661215e-11,   4.612008803030771e-13,
  -5.120828790087888e-15,   5.685167431157324e-17,  -6.310150161286719e-19,   2.456131239144145e-01,  -2.728963777699017e-03,   3.031876547585075e-05,  -3.368160543304789e-07,
   3.741463939445998e-09,  -4.155830456316834e-11,   4.615741401492316e-13,  -5.126159945197451e-15,   5.692569520517403e-17,  -6.320194811427185e-19,   2.456206495236781e-01,
  -2.729214549560053e-03,   3.032433763206703e-05,  -3.369192365134037e-07,   3.743183552344259e-09,  -4.158505246961532e-11,   4.619703744637348e-13,  -5.131819797833893e-15,
   5.700428844888401e-17,  -6.330861174100560e-19,   2.456265725425785e-01,  -2.729411926354004e-03,   3.032872354870581e-05,  -3.370004569961121e-07,   3.744537242516258e-09,
  -4.160611012746249e-11,   4.622823409849266e-13,  -5.136276366226096e-15,   5.706617894568473e-17,  -6.339261607080184e-19,   2.456299909628391e-01,  -2.729525843586058e-03,
   3.033125498767066e-05,  -3.370473371641957e-07,   3.745318622221892e-09,  -4.161826568612481e-11,   4.624624343024540e-13,  -5.138849235060535e-15,   5.710191207980419e-17,
  -6.344112047191506e-19,   2.456312746382557e-01,  -2.729568622005104e-03,   3.033220561367458e-05,  -3.370649423128999e-07,   3.745612064278571e-09,  -4.162283074340093e-11,
   4.625300708392626e-13,  -5.139815542296974e-15,   5.711533304742077e-17,  -6.345933886792436e-19,   2.456314874271289e-01,  -2.729575713212427e-03,   3.033236319594221e-05,
  -3.370678606805163e-07,   3.745660707882364e-09,  -4.162358749463963e-11,   4.625412830754135e-13,  -5.139975730490710e-15,   5.711755791371608e-17,  -6.346235906584841e-19,
   8.092997040861461e-03,  -8.608633236751055e-05,   9.156105287862390e-07,  -9.737311703540113e-09,   1.035425964210842e-10,  -1.100907077238628e-12,   1.170398723296157e-14,
  -1.244137682083319e-16,   1.322373324793702e-18,  -1.405207006291194e-20,   8.093127517042623e-03,  -8.609049498714993e-05,   9.156990799584930e-07,  -9.738881525172270e-09,
   1.035676427287082e-10,  -1.101280038562536e-12,   1.170927633628553e-14,  -1.244860936371418e-16,   1.323334814108237e-18,  -1.406456483616304e-20,   8.093341723947975e-03,
  -8.609732908632466e-05,   9.158444665206810e-07,  -9.741459025624054e-09,   1.036087684684811e-10,  -1.101892471397818e-12,   1.171796202900486e-14,  -1.246048738897567e-16,
   1.324913993816791e-18,  -1.408508837609336e-20,   8.093569026450807e-03,  -8.610458125347852e-05,   9.159987539442680e-07,  -9.744194475049669e-09,   1.036524171663124e-10,
  -1.102542522672896e-12,   1.172718199108557e-14,  -1.247309719436540e-16,   1.326590630872845e-18,  -1.410688086805713e-20,   8.093747923708787e-03,  -8.611028922486383e-05,
   9.161201941965309e-07,  -9.746347666308719e-09,   1.036867769663013e-10,  -1.103054270489535e-12,   1.173444088079620e-14,  -1.248302574253645e-16,   1.327910881276538e-18,
  -1.412404285139275e-20,   8.093851172420031e-03,  -8.611358359828105e-05,   9.161902858501622e-07,  -9.747590466708311e-09,   1.037066099043891e-10,  -1.103349671925680e-12,
   1.173863122305980e-14,  -1.248875753234152e-16,   1.328673115623847e-18,  -1.413395185008967e-20,   8.093889944019293e-03,  -8.611482070445859e-05,   9.162166071179068e-07,
  -9.748057179277131e-09,   1.037140579796092e-10,  -1.103460609778201e-12,   1.174020494526396e-14,  -1.249091022246678e-16,   1.328959397409492e-18,  -1.413767362511216e-20,
   8.093896371002792e-03,  -8.611502577442496e-05,   9.162209703057164e-07,  -9.748134545077870e-09,   1.037152926368559e-10,  -1.103478999931189e-12,   1.174046582316711e-14,
  -1.249126707992598e-16,   1.329006855626064e-18,  -1.413829060730875e-20,   7.594461521376789e-02,  -8.078334087861167e-04,   8.592081393734458e-06,  -9.137484998528538e-08,
   9.716428417707823e-10,  -1.033090262179521e-11,   1.098301161960560e-13,  -1.167497727539923e-15,   1.240913928814092e-17,  -1.318644689296816e-19,   7.594583960113920e-02,
  -8.078724707733134e-04,   8.592912357179694e-06,  -9.138958117809024e-08,   9.718778761074959e-10,  -1.033440248763801e-11,   1.098797490934481e-13,  -1.168176428542689e-15,
   1.241816188387300e-17,  -1.319817191725231e-19,   7.594784971691225e-02,  -8.079366019016873e-04,   8.594276663439358e-06,  -9.141376842034246e-08,   9.722637996980854e-10,
  -1.034014955207512e-11,   1.099612555547399e-13,  -1.169291061082438e-15,   1.243298087329488e-17,  -1.321743108999683e-19,   7.594998272166037e-02,  -8.080046561764119e-04,
   8.595724495306480e-06,  -9.143943785441768e-08,   9.726733987055281e-10,  -1.034624962762580e-11,   1.100477755948028e-13,  -1.170474363783266e-15,   1.244871440026496e-17,
  -1.323788103925400e-19,   7.595166149200359e-02,  -8.080582197312135e-04,   8.596864089598029e-06,  -9.145964338282477e-08,   9.729958307749930e-10,  -1.035105186471662e-11,
   1.101158929496005e-13,  -1.171406057610099e-15,   1.246110360224272e-17,  -1.325398574521127e-19,   7.595263037702940e-02,  -8.080891341032659e-04,   8.597521829077940e-06,
  -9.147130581117278e-08,   9.731819428965190e-10,  -1.035382390924152e-11,   1.101552150831466e-13,  -1.171943928110151e-15,   1.246825639325303e-17,  -1.326328429206557e-19,
   7.595299420938624e-02,  -8.081007430970858e-04,   8.597768827629977e-06,  -9.147568543793730e-08,   9.732518355707337e-10,  -1.035486494909120e-11,   1.101699828779407e-13,
  -1.172145936305248e-15,   1.247094285547160e-17,  -1.326677678409514e-19,   7.595305452014457e-02,  -8.081026674719013e-04,   8.597809771747172e-06,  -9.147641143795145e-08,
   9.732634215837857e-10,  -1.035503752212796e-11,   1.101724309538016e-13,  -1.172179423768388e-15,   1.247138820237118e-17,  -1.326735575659667e-19,   2.351481140915450e-01,
  -2.501303114664514e-03,   2.660375235518388e-05,  -2.829249129621413e-07,   3.008507991694231e-09,  -3.198768286640347e-11,   3.400681470818299e-13,  -3.614935440066117e-15,
   3.842254302812376e-17,  -4.082930383947194e-19,   2.351519051750929e-01,  -2.501424062707981e-03,   2.660632527607446e-05,  -2.829705253099591e-07,   3.009235730989442e-09,
  -3.199851953763700e-11,   3.402218259201837e-13,  -3.617036907424561e-15,   3.845047968663787e-17,  -4.086560764284909e-19,   2.351581291177886e-01,  -2.501622632598013e-03,
   2.661054959195354e-05,  -2.830454165235200e-07,   3.010430670272521e-09,  -3.201631423339031e-11,   3.404741951940701e-13,  -3.620488153079063e-15,   3.849636371490119e-17,
  -4.092523917467994e-19,   2.351647335629156e-01,  -2.501833349767522e-03,   2.661503252905303e-05,  -2.831248970632714e-07,   3.011698915998405e-09,  -3.203520196114341e-11,
   3.407420880618258e-13,  -3.624152022677937e-15,   3.854507942381347e-17,  -4.098855766078059e-19,   2.351699315572578e-01,  -2.501999199167905e-03,   2.661856106689223e-05,
  -2.831874596542129e-07,   3.012697265815030e-09,  -3.205007117809021e-11,   3.409530005103558e-13,  -3.627036833693468e-15,   3.858344010047784e-17,  -4.103842211181965e-19,
   2.351729315261950e-01,  -2.502094919664558e-03,   2.662059763258970e-05,  -2.832235701542413e-07,   3.013273526739385e-09,  -3.205865428855320e-11,   3.410747540265431e-13,
  -3.628702246398771e-15,   3.860558728142773e-17,  -4.106721288277430e-19,   2.351740580641636e-01,  -2.502130864714717e-03,   2.662136241681472e-05,  -2.832371308388333e-07,
   3.013489936163543e-09,  -3.206187767113059e-11,   3.411204796975463e-13,  -3.629327725977798e-15,   3.861390537211692e-17,  -4.107802656538065e-19,   2.351742448050016e-01,
  -2.502136823176781e-03,   2.662148919251716e-05,  -2.832393787603424e-07,   3.013525810057925e-09,  -3.206241201082969e-11,   3.411280596993645e-13,  -3.629431413475836e-15,
   3.861528429934024e-17,  -4.107981921794589e-19  };
  static constexpr double xi[7980] = {  -1.022374041529717e-02,   1.079619026235534e-03,  -6.701732596128392e-05,   2.730700240542369e-06,  -4.781751776858518e-08,
  -3.082244846973738e-09,   3.327771403875304e-10,  -1.608105695834351e-11,   4.130869765769735e-13,   3.722154661402279e-15,  -1.092284635853769e-15,   6.664283967046501e-17,
  -2.231446271661390e-18,   1.723786429451426e-20,  -9.728458810420927e-03,   1.027347732736034e-03,  -6.376574461047031e-05,   2.596930909017914e-06,  -4.534197532236077e-08,
  -2.942340517458601e-09,   3.169260182534719e-10,  -1.529413356181326e-11,   3.914981660334972e-13,   3.650352449243985e-15,  -1.043438992670167e-15,   6.343187800139518e-17,
  -2.114498971892122e-18,   1.571048315863251e-20,  -8.785562779462019e-03,   9.278234489753315e-04,  -5.757751385427428e-05,   2.342867368758913e-06,  -4.069384867270079e-08,
  -2.672150665300108e-09,   2.866373667951215e-10,  -1.379907843555978e-11,   3.510340543654939e-13,   3.469431971404996e-15,  -9.487644569607136e-16,   5.730960315143380e-17,
  -1.895353599651518e-18,   1.308255927184343e-20,  -7.486198308807401e-03,   7.906494023883172e-04,  -4.905367557613508e-05,   1.993921397046210e-06,  -3.441401851097244e-08,
  -2.292367532622028e-09,   2.446827095484523e-10,  -1.174488775227819e-11,   2.965115581698424e-13,   3.134374654364167e-15,  -8.150576199975928e-16,   4.885677511763676e-17,
  -1.600241972107037e-18,   1.000595261262532e-20,  -5.956703904347939e-03,   6.291505143760634e-04,  -3.902516967885089e-05,   1.584656980474503e-06,  -2.718102675272758e-08,
  -1.835913489102774e-09,   1.950280937376512e-10,  -9.334814775098299e-12,   2.339115094967509e-13,   2.631482187782887e-15,  -6.536092532399275e-16,   3.889004744809540e-17,
  -1.261742025869621e-18,   7.077371288084263e-21,  -4.346633187248827e-03,   4.591158738843622e-04,  -2.847304297276695e-05,   1.155218859246005e-06,  -1.971538627182600e-08,
  -1.346658788869608e-09,   1.425091898954554e-10,  -6.805389696250556e-12,   1.694947069998090e-13,   2.000992826219376e-15,  -4.799071806156988e-16,   2.838570113077631e-17,
  -9.138375848306286e-19,   4.643375984292728e-21,  -2.814057178359019e-03,   2.972459238837395e-04,  -1.843212405795591e-05,   7.474247126977912e-07,  -1.271315011294991e-08,
  -8.748266975301773e-10,   9.234556796069851e-11,  -4.403170928605729e-12,   1.092216932079092e-13,   1.330014875422931e-15,  -3.119601580315119e-16,   1.837994647237442e-17,
  -5.886717782839759e-19,   2.782913297791186e-21,  -1.509706905448975e-03,   1.594713376341807e-04,  -9.888156324958801e-06,   4.008527668638649e-07,  -6.806449099603717e-09,
  -4.701557438410639e-10,   4.956521669140623e-11,  -2.361494518655860e-12,   5.845509148176530e-14,   7.230538170449399e-16,  -1.677098294988630e-16,   9.861292981879719e-18,
  -3.149970463052508e-19,   1.431427881829073e-21,  -5.618254913245728e-04,   5.934633057412941e-05,  -3.679740796543807e-06,   1.491571688059929e-07,  -2.531152883964374e-09,
  -1.750711923997902e-10,   1.844827362177933e-11,  -8.787137717831613e-13,   2.173532485857486e-14,   2.703114004113684e-16,  -6.245678568731807e-17,   3.669885687472295e-18,
  -1.171174870134830e-19,   5.247159337728395e-22,  -6.346296011965386e-05,   6.703677955686477e-06,  -4.156569228463218e-07,   1.684826371056970e-08,  -2.858827073759848e-10,
  -1.977768578472634e-11,   2.083942379525940e-12,  -9.925642858111678e-14,   2.454861861982861e-15,   3.055606247466775e-17,  -7.055828812902633e-18,   4.145462240255412e-19,
  -1.322751040794082e-20,   5.912808483783333e-23,  -3.807345622974055e-02,   9.679951543133224e-05,   1.125668087401428e-04,  -2.710885072049113e-07,  -3.398708215338470e-07,
   1.302135907267684e-09,   9.463934317831016e-10,  -4.431031628981905e-12,  -2.402921027608329e-12,   1.212908300348711e-14,   5.962108329365323e-15,  -3.569906201799776e-17,
  -1.450378327099565e-17,   1.026966674802166e-19,  -3.621829217286676e-02,   9.206770608998624e-05,   1.070319102530612e-04,  -2.575238712477696e-07,  -3.229248262688506e-07,
   1.236092300132603e-09,   8.984044673192749e-10,  -4.202907244761870e-12,  -2.278288526696533e-12,   1.148290639635153e-14,   5.644631421625712e-15,  -3.373531083268662e-17,
  -1.370945900870923e-17,   9.689646892698342e-20,  -3.269088720220516e-02,   8.307684567076027e-05,   9.652823697869975e-05,  -2.318774556484773e-07,  -2.908613143149909e-07,
   1.111580928793821e-09,   8.079278557336999e-10,  -3.774190585457402e-12,  -2.044424793207055e-12,   1.027715622260206e-14,   5.052158926912716e-15,  -3.009494207842299e-17,
  -1.223566486698457e-17,   8.620221682890360e-20,  -2.783840099882837e-02,   7.072051049515032e-05,   8.211824525521679e-05,  -1.968777594000402e-07,  -2.470575179244832e-07,
   9.423494312012365e-10,   6.849473815949700e-10,  -3.194117974655847e-12,  -1.728696893692731e-12,   8.662361417603922e-15,   4.258569264891103e-15,  -2.526593688864704e-17,
  -1.027811884956754e-17,   7.212780734970207e-20,  -2.213721154605419e-02,   5.621814734464035e-05,   6.523772479508479e-05,  -1.561107248153823e-07,  -1.959762939445591e-07,
   7.461035088879475e-10,   5.423239362135436e-10,  -2.524744415801423e-12,  -1.365256439334548e-12,   6.819981595779278e-15,   3.352988518679381e-15,  -1.981511632502727e-17,
  -8.065222734471028e-18,   5.638190592204408e-20,  -1.614565359666659e-02,   4.099119846750874e-05,   4.754378133706414e-05,  -1.135962853396488e-07,  -1.426499863161711e-07,
   5.422590203698059e-10,   3.941657853277281e-10,  -1.832506761149807e-12,  -9.902422881876704e-13,   4.934246415590152e-15,   2.425973576011092e-15,  -1.429110117763777e-17,
  -5.819467779181271e-18,   4.055596941412349e-20,  -1.044946385813036e-02,   2.652471317476377e-05,   3.075451956467291e-05,  -7.340754161831771e-08,  -9.220168403933584e-08,
   3.501360726241082e-10,   2.545174811260608e-10,  -1.182206119675448e-12,  -6.385416917046835e-13,   3.176486507404919e-15,   1.561789893062013e-15,  -9.180837190625218e-18,
  -3.739660848305605e-18,   2.600791077848675e-20,  -5.605070128507700e-03,   1.422648326339084e-05,   1.649230699994971e-05,  -3.934484056882448e-08,  -4.942338965410867e-08,
   1.875883643696411e-10,   1.363613236296786e-10,  -6.330907807981685e-13,  -3.418685262230425e-13,   1.699205061424697e-15,   8.354617368615784e-16,  -4.905827817329752e-18,
  -1.998622241285849e-18,   1.388484710921644e-20,  -2.085761052510137e-03,   5.293794508239445e-06,   6.136560725257859e-06,  -1.463703015920700e-08,  -1.838712892643775e-08,
   6.977648279403788e-11,   5.072195559248264e-11,  -2.354511864646779e-13,  -1.271329549237423e-13,   6.317068344275498e-16,   3.105976221409456e-16,  -1.823134306848053e-18,
  -7.427813589928087e-19,   5.158340761625614e-21,  -2.356022450232666e-04,   5.979704618754376e-07,   6.931601375935592e-07,  -1.653290086409081e-09,  -2.076885665026737e-09,
   7.881254077157766e-12,   5.729048504800472e-12,  -2.659354922982879e-14,  -1.435912136917622e-14,   7.134520469403107e-17,   3.507903361882962e-17,  -2.058931657019656e-19,
  -8.388572513355291e-20,   5.825208558347615e-22,  -1.471812623238532e-02,  -1.248035866384739e-03,  -5.639596077350775e-05,  -1.131866539556545e-06,   4.591008094158032e-08,
   5.814146713259812e-09,   2.687886096809151e-10,   3.625475284647328e-12,  -2.844618057006542e-13,  -2.206196564542131e-14,  -8.045923847238824e-16,  -8.578044535874720e-18,
   1.078147644938581e-18,   8.041945618597520e-20,  -1.400389589800535e-02,  -1.187428604807237e-03,  -5.364436226214312e-05,  -1.075077031644899e-06,   4.379593311987084e-08,
   5.533496481785570e-09,   2.554718005152129e-10,   3.425436611007047e-12,  -2.716839767249162e-13,  -2.100111045450234e-14,  -7.632743534842430e-16,  -7.975038268344464e-18,
   1.031753590119057e-18,   7.645821822155483e-20,  -1.264467228157610e-02,  -1.072106851361947e-03,  -4.841392852932558e-05,  -9.677613699897191e-07,   3.972609133278232e-08,
   4.998772843725498e-09,   2.302392176866615e-10,   3.054554432895278e-12,  -2.469447544326156e-13,  -1.897784580803807e-14,  -6.855536720884610e-16,  -6.903743254370716e-18,
   9.409932244903923e-19,   6.894009312283711e-20,  -1.077254960052449e-02,  -9.133029403053348e-04,  -4.122150937153329e-05,  -8.214206561536917e-07,   3.403055865665728e-08,
   4.261073406933977e-09,   1.956997707004912e-10,   2.562736489699247e-12,  -2.120559941880161e-13,  -1.618300755465334e-14,  -5.802848794379677e-16,  -5.575817962527112e-18,
   8.112528476153996e-19,   5.862796991100064e-20,  -8.570077258886033e-03,  -7.265204269986277e-04,  -3.277478270501009e-05,  -6.511181418198516e-07,   2.721645075393130e-08,
   3.391715165674096e-09,   1.553388522720453e-10,   2.008213812216688e-12,  -1.699870174730845e-13,  -1.288538757146646e-14,  -4.587162211657309e-16,  -4.200032092367565e-18,
   6.527170426449952e-19,   4.655591274861680e-20,  -6.252713365308642e-03,  -5.300352255963530e-04,  -2.390130592809556e-05,  -4.736669699910164e-07,   1.994129330843425e-08,
   2.475650415387771e-09,   1.131287810032605e-10,   1.447222672961454e-12,  -1.247753168141497e-13,  -9.407372842682368e-15,  -3.329483027156950e-16,  -2.925937880109726e-18,
   4.804899209320993e-19,   3.391467811621311e-20,  -4.047684832822594e-03,  -3.431034613461238e-04,  -1.546771554054577e-05,  -3.060340636768891e-07,   1.294494927989389e-08,
   1.603058254304115e-09,   7.314534897943459e-11,   9.291716796100184e-13,  -8.109431056565749e-14,  -6.092423389955997e-15,  -2.147905568035012e-16,  -1.834963141036358e-18,
   3.128584625865600e-19,   2.193148606115014e-20,  -2.171425680635908e-03,  -1.840577989342514e-04,  -8.296516565157960e-06,  -1.640118699186796e-07,   6.954368415211519e-09,
   8.601016381589190e-10,   3.921524921036480e-11,   4.963470175121428e-13,  -4.359227831208237e-14,  -3.269043660511619e-15,  -1.150216027191484e-16,  -9.681043504966719e-19,
   1.683341840217119e-19,   1.175890146758424e-20,  -8.080650157839890e-04,  -6.849397495353119e-05,  -3.087260026711303e-06,  -6.101349277306845e-08,   2.589251411798951e-09,
   3.200904352219435e-10,   1.459023314989084e-11,   1.844341719083410e-13,  -1.623367475591750e-14,  -1.216617060663187e-15,  -4.277703924235368e-17,  -3.581578718859464e-19,
   6.270751557392732e-20,   4.375059672495750e-21,  -9.127755648555029e-05,  -7.736945988195061e-06,  -3.487282382289634e-07,  -6.891593689919870e-09,   2.925001257763954e-10,
   3.615711914001547e-11,   1.648029563358023e-12,   2.082843273171335e-14,  -1.833931278086823e-15,  -1.374284480256855e-16,  -4.831539604519394e-18,  -4.041907462632576e-20,
   7.084480008816242e-21,   4.941835684380740e-22,  -6.791793596082903e-03,   6.590300333037036e-04,  -3.982241057002215e-05,   1.779722092347176e-06,  -5.855595059036990e-08,
   9.276481922174215e-10,   5.252366182883571e-11,  -5.067455983395293e-12,   2.238115400886328e-13,  -6.724767695882832e-15,   1.118213969289528e-16,   3.381778039981880e-18,
  -4.423771144856848e-19,   2.356794050681047e-20,  -6.462637753638434e-03,   6.271338406075806e-04,  -3.789582151596182e-05,   1.693421767020206e-06,  -5.568362996053759e-08,
   8.793296306743587e-10,   5.015601111849107e-11,  -4.828128283356094e-12,   2.130675923254028e-13,  -6.391617023265192e-15,   1.054948834742916e-16,   3.272097723730504e-18,
  -4.226093855407324e-19,   2.243367797135731e-20,  -5.836059131259128e-03,   5.663989828719715e-04,  -3.422700376228447e-05,   1.529159367412004e-06,  -5.022984670437994e-08,
   7.887156794596007e-10,   4.557657732339203e-11,  -4.369982305045065e-12,   1.925718732515424e-13,  -5.760263482067200e-15,   9.381711940141628e-17,   3.041230952641328e-18,
  -3.842923769181141e-19,   2.027076081103272e-20,  -4.972702959095124e-03,   4.826791549937230e-04,  -2.916911834346005e-05,   1.302860707482893e-06,  -4.274227058189082e-08,
   6.665101914400254e-10,   3.912621554991945e-11,  -3.733750529863117e-12,   1.642481713636986e-13,  -4.895932854863761e-15,   7.843893651274630e-17,   2.680307741526854e-18,
  -3.301693954902385e-19,   1.728374088423046e-20,  -3.956570373462691e-03,   3.841017155917457e-04,  -2.321285764024150e-05,   1.036565758617017e-06,  -3.396421465091966e-08,
   5.260407872188916e-10,   3.135663506104817e-11,  -2.978679747552197e-12,   1.308101719965461e-13,  -3.885930034680712e-15,   6.124762254912917e-17,   2.201323776665243e-18,
  -2.647999922911824e-19,   1.376037187336604e-20,  -2.887029073588693e-03,   2.803030752941420e-04,  -1.694042331845368e-05,   7.563215093973315e-07,  -2.475706968524034e-08,
   3.813271581993555e-10,   2.301288841077537e-11,  -2.178111372185488e-12,   9.552177105893076e-14,  -2.829790860501565e-15,   4.400504378026155e-17,   1.646645861677923e-18,
  -1.944480240584182e-19,   1.004528331844210e-20,  -1.869051961423853e-03,   1.814807925248021e-04,  -1.096822285899458e-05,   4.896225814908990e-07,  -1.601652536464079e-08,
   2.457935909886664e-10,   1.495517972926313e-11,  -1.412078516469664e-12,   6.187098958094301e-14,  -1.829536754335209e-15,   2.819440470319080e-17,   1.083305796711016e-18,
  -1.264091893356371e-19,   6.505148768750762e-21,  -1.002711783804550e-03,   9.736483623423369e-05,  -5.884538937302405e-06,   2.626686752669005e-07,  -8.589505429503821e-09,
   1.315670942744815e-10,   8.038804342708195e-12,  -7.580982285708920e-13,   3.320099755207449e-14,  -9.808310673718730e-16,   1.504456346933428e-17,   5.859320023357769e-19,
  -6.796038914435049e-20,   3.490389185423307e-21,  -3.731497755823061e-04,   3.623389525314296e-05,  -2.189913503252882e-06,   9.774905964267213e-08,  -3.196106747071479e-09,
   4.892303201365809e-11,   2.993589710867566e-12,  -2.821896011115119e-13,   1.235651841338235e-14,  -3.649185605884346e-16,   5.588166034173736e-18,   2.186654178129726e-19,
  -2.530948414865379e-20,   1.298978917361106e-21,  -4.215040915923473e-05,   4.092932271122261e-06,  -2.473698434369037e-07,   1.104156819957583e-08,  -3.610200509874539e-10,
   5.525579574591972e-12,   3.381874474389400e-13,  -3.187695443585748e-14,   1.395792120019325e-15,  -4.121903629205328e-17,   6.310416696859754e-19,   2.471114758681748e-20,
  -2.859253811016337e-21,   1.467317363728216e-22,  -3.602453149625223e-02,   9.010920774725239e-04,   8.109188857914685e-05,  -4.445695358671524e-06,  -1.347624129736721e-07,
   1.561773848049458e-08,   7.192540244280705e-11,  -4.108683605458675e-11,   5.758056110390864e-13,   8.698738372801389e-14,  -3.056521468827423e-15,  -1.501079226715503e-16,
   1.000810192317846e-17,   1.727834234050287e-19,  -3.426991087833694e-02,   8.568749392642432e-04,   7.712359623120655e-05,  -4.224889679129463e-06,  -1.281737074377542e-07,
   1.483286475103150e-08,   6.888384445909828e-11,  -3.899691490008003e-11,   5.438621470340125e-13,   8.251470427952160e-14,  -2.888955685370630e-15,  -1.424040949584350e-16,
   9.454121533904971e-18,   1.645322294523690e-19,  -3.093339063198027e-02,   7.729270805459386e-04,   6.958520142243137e-05,  -3.806758214556937e-06,  -1.156547185573461e-07,
   1.335027566041645e-08,   6.290831750980636e-11,  -3.505917089024842e-11,   4.847361406816604e-13,   7.410626912700364e-14,  -2.578085420778005e-15,  -1.279137927734670e-16,
   8.428403362059637e-18,   1.487572595338592e-19,  -2.634293750905901e-02,   6.576888428617099e-04,   5.922837886646137e-05,  -3.234857417245488e-06,  -9.845020155270782e-08,
   1.132961806155312e-08,   5.431941612960470e-11,  -2.971173482231316e-11,   4.064906602760648e-13,   6.272431446377023e-14,  -2.165270017213463e-15,  -1.082865255675261e-16,
   7.070241013558522e-18,   1.269073371608501e-19,  -2.094890584230415e-02,   5.226048117113448e-04,   4.707710075529091e-05,  -2.567099429005152e-06,  -7.825890017017634e-08,
   8.979331125660847e-09,   4.376808225726086e-11,  -2.351656701178801e-11,   3.184237992012936e-13,   4.958476460504470e-14,  -1.698771985175656e-15,  -8.561502780872753e-17,
   5.540429558492215e-18,   1.010743930847707e-19,  -1.527949347941386e-02,   3.809288171867898e-04,   3.432276082172747e-05,  -1.869207188677279e-06,  -5.706041765559940e-08,
   6.531425410993653e-09,   3.225606588492499e-11,  -1.708705576463201e-11,   2.294294131713381e-13,   3.599223070145476e-14,  -1.225547481310046e-15,  -6.215182556846657e-17,
   3.993210032088246e-18,   7.379953719561091e-20,  -9.889109155468222e-03,   2.464387128189338e-04,   2.220826776110276e-05,  -1.208429573384758e-06,  -3.692204419202599e-08,
   4.219623757119168e-09,   2.101814661432978e-11,  -1.103116571574647e-11,   1.472908324849474e-13,   2.322070989839985e-14,  -7.874587553225522e-16,  -4.010011158298588e-17,
   2.564150552933573e-18,   4.779450163619317e-20,  -5.304558722357188e-03,   1.321621219809460e-04,   1.191097536049978e-05,  -6.478354418570945e-07,  -1.980284501879743e-08,
   2.261329702381518e-09,   1.131307462075550e-11,  -5.909508687018424e-12,   7.867813507280088e-14,   1.243533225385068e-14,  -4.208223485572426e-16,  -2.147529596900504e-17,
   1.369847525235030e-18,   2.564497638412658e-20,  -1.973942606255819e-03,   4.917671797381766e-05,   4.432123896133425e-06,  -2.410257191983831e-07,  -7.368775552622708e-09,
   8.412193114061341e-10,   4.214867332543953e-12,  -2.198067057976693e-12,   2.923527505526190e-14,   4.624825471736495e-15,  -1.563937191801610e-16,  -7.986950536039122e-18,
   5.090297469509765e-19,   9.544036653382063e-21,  -2.229716618387887e-04,   5.554813701146063e-06,   5.006379390275583e-07,  -2.722480630078047e-08,  -8.323532820282325e-10,
   9.501718955222914e-11,   4.761909759074756e-13,  -2.482704495448991e-13,   3.301581201267267e-15,   5.223616060791311e-16,  -1.766220070491897e-17,  -9.021058567893197e-19,
   5.748582920059104e-20,   1.078088079693267e-21,  -2.066640369543040e-02,  -1.729874067141752e-03,  -6.057341964058703e-05,   8.879137833154762e-07,   2.257034848586251e-07,
   1.150756881732253e-08,   8.247841384228957e-11,  -2.349437445590327e-11,  -1.477431973032925e-12,  -2.827748077286402e-14,   1.775464043197874e-15,   1.624557180671926e-16,
   4.854323479180812e-18,  -9.734232026873478e-20,  -1.966292438062014e-02,  -1.645646732714153e-03,  -5.758676902851994e-05,   8.481009886633407e-07,   2.147573224896256e-07,
   1.093303568094177e-08,   7.725085657192014e-11,  -2.238005804760721e-11,  -1.403120728328299e-12,  -2.663886640611129e-14,   1.698161979179976e-15,   1.543034724584081e-16,
   4.576233264767694e-18,  -9.443850210842665e-20,  -1.775348384867219e-02,  -1.485471242570322e-03,  -5.192221130582228e-05,   7.709943808872086e-07,   1.939226803021692e-07,
   9.846201122724040e-09,   6.780448838129124e-11,  -2.024854708300110e-11,  -1.262751218873783e-12,  -2.362960731411066e-14,   1.547329332685574e-15,   1.388930100803257e-16,
   4.064365885289844e-18,  -8.814797969585835e-20,  -1.512399048748068e-02,  -1.265075733484107e-03,  -4.415740086473379e-05,   6.622000925982394e-07,   1.652202229245954e-07,
   8.361943886405398e-09,   5.576358066916350e-11,  -1.729197571184635e-11,  -1.071463297407137e-12,  -1.969571232945587e-14,   1.332479121238515e-15,   1.178741974543839e-16,
   3.392953835636220e-18,  -7.802486948506760e-20,  -1.203109888434808e-02,  -1.006070883769935e-03,  -3.506956517813415e-05,   5.309389161791559e-07,   1.314466320533068e-07,
   6.631868486448719e-09,   4.282070741786847e-11,  -1.378804448876564e-11,  -8.490386350086397e-13,  -1.533354128726927e-14,   1.070906169162933e-15,   9.341664313290973e-17,
   2.645532580016831e-18,  -6.430463386184279e-20,  -8.777423097449576e-03,  -7.338174574417708e-04,  -2.555158516785426e-05,   3.897928837766782e-07,   9.590632804531263e-08,
   4.826567070195118e-09,   3.033791459264548e-11,  -1.007796712149531e-11,  -6.174721811273136e-13,  -1.099070947827927e-14,   7.876367625660087e-16,   6.794282244807149e-17,
   1.898639327575565e-18,  -4.821332510413412e-20,  -5.681861212775036e-03,  -4.749457422326451e-04,  -1.652576750028574e-05,   2.533657813691186e-07,   6.208599731594581e-08,
   3.119321317814679e-09,   1.925322799696787e-11,  -6.531677084632249e-12,  -3.988677709736606e-13,  -7.030869843486318e-15,   5.125490249779970e-16,   4.389015293318608e-17,
   1.215604616837366e-18,  -3.176071915867262e-20,  -3.048045246655310e-03,  -2.547651634308559e-04,  -8.861296740110203e-06,   1.362054844279578e-07,   3.330702546769749e-08,
   1.671975495444728e-09,   1.022239170028590e-11,  -3.506104602934402e-12,  -2.137418820572373e-13,  -3.748686139263426e-15,   2.756952649542652e-16,   2.351969095394465e-17,
   6.484140820325579e-19,  -1.718908848616543e-20,  -1.134279639341088e-03,  -9.480400264684159e-05,  -3.297069243605968e-06,   5.072376872407685e-08,   1.239477060125059e-08,
   6.220179193791933e-10,   3.790366118643821e-12,  -1.305019668027554e-12,  -7.951049473092411e-14,  -1.392029117637505e-15,   1.026907109899915e-16,   8.749181059720223e-18,
   2.408175508637687e-19,  -6.416145145585801e-21,  -1.281260457364755e-04,  -1.070883040788989e-05,  -3.724213524903089e-07,   5.730325152789801e-09,   1.400091436304951e-09,
   7.025871871827836e-11,   4.279064286948979e-13,  -1.474175402687938e-13,  -8.980814385201479e-15,  -1.571874787195219e-16,   1.160145172996554e-17,   9.882317545677569e-19,
   2.719370136315066e-20,  -7.251048760234472e-22,  -4.677871238159012e-03,   4.116158690806440e-04,  -2.335536607301798e-05,   1.023521548530216e-06,  -3.553566369443618e-08,
   1.104454480809792e-09,  -1.887097107107538e-11,  -8.584681580739876e-13,   6.548317085171780e-14,  -2.401099627553719e-15,   7.710680631777636e-17,  -1.361461423074589e-18,
   3.305712547572688e-20,  -8.322164386627698e-22,  -4.451041765038655e-03,   3.916866535460982e-04,  -2.222571227251041e-05,   9.740637876027897e-07,  -3.381540149440752e-08,
   1.050185291644784e-09,  -1.789797613318154e-11,  -8.192972538092164e-13,   6.240167919435812e-14,  -2.286549770596970e-15,   7.341555365418884e-17,  -1.296801572680583e-18,
   3.094582478544865e-20,  -7.646895822666536e-22,  -4.019300706804156e-03,   3.537417141378092e-04,  -2.007440047084943e-05,   8.798565330760788e-07,  -3.053989933828332e-08,
   9.471797047402058e-10,  -1.606950666915271e-11,  -7.437423371945929e-13,   5.649831688440028e-14,  -2.067755467728861e-15,   6.636892136000060e-17,  -1.173089331603511e-18,
   2.713451518741968e-20,  -6.472525565307393e-22,  -3.424505786274622e-03,   3.014425873517814e-04,  -1.710836439431485e-05,   7.499337132341589e-07,  -2.602505884336651e-08,
   8.058345080423130e-10,  -1.359614570503828e-11,  -6.377157386501926e-13,   4.829146395504922e-14,  -1.764848129740390e-15,   5.662205928101225e-17,  -1.001499738542311e-18,
   2.228542652948582e-20,  -5.069428046333294e-22,  -2.724580275716908e-03,   2.398695652282538e-04,  -1.361523536575962e-05,   5.968744528788375e-07,  -2.070937093787587e-08,
   6.402208018812993e-10,  -1.074354609916424e-11,  -5.104938278850012e-13,   3.854030935301442e-14,  -1.406522950600922e-15,   4.510523897403270e-17,  -7.982518065252354e-19,
   1.708717676893091e-20,  -3.689788596498883e-22,  -1.987979969519593e-03,   1.750422882812982e-04,  -9.936423608667784e-06,   4.356349331580584e-07,  -1.511255140450707e-08,
   4.665979091076605e-10,  -7.795605576934411e-12,  -3.743143259929429e-13,   2.819076563353353e-14,  -1.027668383629462e-15,   3.294290459835552e-17,  -5.832358865324605e-19,
   1.208964927416537e-20,  -2.490533076196478e-22,  -1.286972002702876e-03,   1.133278637942964e-04,  -6.433515006086384e-06,   2.820744635427765e-07,  -9.784377198521518e-09,
   3.018346236886600e-10,  -5.028119275688592e-12,  -2.431074111616169e-13,   1.827998356113659e-14,  -6.658894827350206e-16,   2.133989164652964e-17,  -3.778955991228872e-19,
   7.664956117998353e-21,  -1.526093645962893e-22,  -6.904259478035526e-04,   6.079999097109335e-05,  -3.451657583035203e-06,   1.513403930336627e-07,  -5.249292274656222e-09,
   1.618627470106705e-10,  -2.692331031886539e-12,  -1.306369327248302e-13,   9.814969519547768e-15,  -3.573974192920042e-16,   1.145193020685704e-17,  -2.028167170435158e-19,
   4.067533592032298e-21,  -7.949653795697030e-23,  -2.569341465667144e-04,   2.262636461485984e-05,  -1.284527327089791e-06,   5.632154581676926e-08,  -1.953494834435095e-09,
   6.022715687353596e-11,  -1.001256964992480e-12,  -4.864306891734721e-14,   3.653597521626639e-15,  -1.330228246278724e-16,   4.262175414694098e-18,  -7.548687899980992e-20,
   1.507921816100461e-21,  -2.927626252473776e-23,  -2.902285043317076e-05,   2.555842325218199e-06,  -1.450986322851397e-07,   6.362022224505196e-09,  -2.206640485497938e-10,
   6.803011314966427e-12,  -1.130884169372674e-13,  -5.495141848116353e-15,   4.127234035322729e-16,  -1.502641973116119e-17,   4.814566012107650e-19,  -8.527066639741798e-21,
   1.702289968563143e-22,  -3.301486540110509e-24,  -3.148231961028485e-02,   1.322436007382304e-03,   2.450055535886765e-05,  -4.335656695956717e-06,   1.210677690400206e-07,
   7.508603806299861e-09,  -5.512264816652050e-10,  -7.348302918844756e-13,   1.149489872259776e-12,  -3.857820087094634e-14,  -1.059374494429877e-15,   1.310966988377593e-16,
  -1.680698134480374e-18,  -2.348142869356045e-19,  -2.995024976313500e-02,   1.257729877005150e-03,   2.332984378405779e-05,  -4.122538636400487e-06,   1.149368043632908e-07,
   7.142737119364312e-09,  -5.234660426260082e-10,  -7.389448230434418e-13,   1.092136815624755e-12,  -3.649253090183353e-14,  -1.010867170596425e-15,   1.241819507692153e-16,
  -1.573853589310984e-18,  -2.229335528437672e-19,  -2.703638762577022e-02,   1.134807206327473e-03,   2.109442242072109e-05,  -3.718070832532323e-06,   1.033740358887867e-07,
   6.447046167526308e-09,  -4.710497895603998e-10,  -7.302654948151543e-13,   9.836254054225923e-13,  -3.261159844424003e-14,  -9.173063159750512e-16,   1.112495962548403e-16,
  -1.381121997010814e-18,  -2.005129891864370e-19,  -2.302639820439858e-02,   9.659202930816518e-04,   1.800102034712293e-05,  -3.163126628725442e-06,   8.765066987925978e-08,
   5.489986613517714e-09,  -3.996541911973094e-10,  -6.866176821960532e-13,   8.354032784502254e-13,  -2.743598800541977e-14,  -7.860869542006547e-16,   9.387534724203677e-17,
  -1.135910544409650e-18,  -1.700075049620564e-19,  -1.831313080126899e-02,   7.677632411294055e-04,   1.434357192659016e-05,  -2.512975526325609e-06,   6.940818579896017e-08,
   4.365550154692082e-09,  -3.166694948007508e-10,  -5.956371752306052e-13,   6.625975111961342e-13,  -2.156004557327381e-14,  -6.288361943073772e-16,   7.398714633152195e-17,
  -8.725904599314854e-19,  -1.346072187805043e-19,  -1.335801593487802e-02,   5.597638560153984e-04,   1.047846270416026e-05,  -1.831440315775301e-06,   5.045122559645409e-08,
   3.183904188818569e-09,  -2.302938375745148e-10,  -4.634067115931930e-13,   4.822484758111122e-13,  -1.557431395593489e-14,  -4.607931901880848e-16,   5.357349188677000e-17,
  -6.185667498239049e-19,  -9.782685861164272e-20,  -8.645918445734552e-03,   3.621935253862530e-04,   6.788943520922115e-06,  -1.184715565412210e-06,   3.257888211399945e-08,
   2.060578752364831e-09,  -1.487610052946568e-10,  -3.122537328481096e-13,   3.116766124754117e-13,  -1.001560381249227e-14,  -2.991341041007917e-16,   3.450683297275851e-17,
  -3.927583041833270e-19,  -6.316294637424353e-20,  -4.637821050306522e-03,   1.942562761118499e-04,   3.643579766942446e-06,  -6.353157375490774e-07,   1.745511098271009e-08,
   1.105276977475657e-09,  -7.971658838152317e-11,  -1.708811576051496e-13,   1.670627926530336e-13,  -5.354731439568707e-15,  -1.607031444642852e-16,   1.846373273681687e-17,
  -2.085966190890029e-19,  -3.383871540858953e-20,  -1.725849782570658e-03,   7.228367601312883e-05,   1.356110014146369e-06,  -2.363928249853037e-07,   6.492796703092437e-09,
   4.112943748583978e-10,  -2.965400596589104e-11,  -6.402673867901483e-14,   6.215193914242425e-14,  -1.990325358995680e-15,  -5.983295039730021e-17,   6.864821023673484e-18,
  -7.735446103721920e-20,  -1.258665276597965e-20,  -1.949479784501963e-04,   8.164924863820789e-06,   1.531873783834364e-07,  -2.670195133188917e-08,   7.333630275936995e-10,
   4.645873096578564e-11,  -3.349458647152086e-12,  -7.240151671502956e-15,   7.020245850803369e-15,  -2.247812239485790e-16,  -6.759150807187281e-18,   7.753267238948824e-19,
  -8.732950850080121e-21,  -1.421658856558734e-21,  -2.837882226817455e-02,  -2.093779284371481e-03,  -2.116075454756253e-05,   6.124028674773914e-06,   3.938190694371628e-07,
   1.967875810864704e-10,  -1.199327906005899e-09,  -5.725471244336354e-11,   7.354840147543915e-13,   1.934082819890410e-13,   6.941021646364933e-15,  -2.034232584228064e-16,
  -2.777234437204402e-17,  -7.267070494653304e-19,  -2.699899428955053e-02,  -1.991391051043211e-03,  -2.006254135014199e-05,   5.826105511750973e-06,   3.741312963478336e-07,
   1.524326265394133e-10,  -1.140329646572883e-09,  -5.426522907758579e-11,   7.085629827092470e-13,   1.836537569595866e-13,   6.550142503598245e-15,  -1.950664726618562e-16,
  -2.631195251957442e-17,  -6.804183283034034e-19,  -2.437418852851299e-02,  -1.796859055099838e-03,  -1.800176994778983e-05,   5.259427693447435e-06,   3.368997076036916e-07,
   8.237768074996243e-11,  -1.028367694440162e-09,  -4.866257997880466e-11,   6.536602767839658e-13,   1.652373093228758e-13,   5.828597989001950e-15,  -1.785115236866734e-16,
  -2.357800586586992e-17,  -5.969327717264606e-19,  -2.076103524093480e-02,  -1.529539143596944e-03,  -1.521982211969374e-05,   4.479487416515498e-06,   2.860747228994784e-07,
   1.353487775275710e-11,  -8.747780479566178e-10,  -4.111294145638681e-11,   5.710232995803765e-13,   1.401596608305230e-13,   4.877744935047560e-15,  -1.544810733879623e-16,
  -1.990078939431398e-17,  -4.907564243137209e-19,  -1.651299355966738e-02,  -1.215830562882307e-03,  -1.201819135814096e-05,   3.562665158652448e-06,   2.268572723922702e-07,
  -3.274676457260900e-11,  -6.948866512868420e-10,  -3.244176732610887e-11,   4.650752304444030e-13,   1.110264453026378e-13,   3.813000871244198e-15,  -1.247080808169607e-16,
  -1.568746208908686e-17,  -3.768203042628773e-19,  -1.204585212498472e-02,  -8.864858091003702e-04,  -8.715716677764217e-06,   2.598729390688924e-06,   1.650867802740755e-07,
  -4.934587873168288e-11,  -5.063703829354646e-10,  -2.351379467075160e-11,   3.456013945911120e-13,   8.072231560536114e-14,   2.742508806853873e-15,  -9.202945338889882e-17,
  -1.136024931468959e-17,  -2.670096524447965e-19,  -7.797009505796824e-03,  -5.736164171534566e-04,  -5.619582525556622e-06,   1.682030832048806e-06,   1.066858056714960e-07,
  -4.279348250617376e-11,  -3.275320638155471e-10,  -1.515516550235406e-11,   2.263921323326990e-13,   5.213409433620943e-14,   1.758550940588997e-15,  -6.001427458470846e-17,
  -7.317455010507883e-18,  -1.694853814842285e-19,  -4.182557099379548e-03,  -3.076543783649491e-04,  -3.008488023839206e-06,   9.022741104444856e-07,   5.718243284364955e-08,
  -2.593967176424882e-11,  -1.756346266331845e-10,  -8.111871011984470e-12,   1.221821624101074e-13,   2.793438053403785e-14,   9.387747626013254e-16,  -3.231517700012025e-17,
  -3.915434854531678e-18,  -8.999981634330481e-20,  -1.556448293743085e-03,  -1.144802998403956e-04,  -1.118763109119713e-06,   3.357593030566821e-07,   2.127310358893960e-08,
  -1.003902556828852e-11,  -6.535036342732586e-11,  -3.016349510126285e-12,   4.556290496739162e-14,   1.039103082752361e-14,   3.487539191088492e-16,  -1.204108763004726e-17,
  -1.455764520279695e-18,  -3.337289209222954e-20,  -1.758130251854262e-04,  -1.293132761273768e-05,  -1.263590624550467e-07,   3.792659769051780e-08,   2.402854260995091e-09,
  -1.140906142491379e-12,  -7.381687053892876e-12,  -3.406789355187602e-13,   5.148396918013776e-15,   1.173673975451549e-15,   3.938389935052254e-17,  -1.360416087929671e-18,
  -1.644170550395675e-19,  -3.767604946102194e-21,  -3.338972104244753e-03,   2.657289265885142e-04,  -1.384922725159333e-05,   6.023088407744248e-07,  -1.896861807183318e-08,
   5.387327866432207e-10,  -2.292066879970776e-11,   3.463070423351214e-13,   2.182280398547293e-14,  -4.068752375119013e-16,   1.585167725075195e-17,  -2.141808100390702e-18,
  -3.557399911428066e-20,   2.324774743355273e-21,  -3.176980158963897e-03,   2.528578129990095e-04,  -1.317900471955612e-05,   5.731731633005042e-07,  -1.805612960419555e-08,
   5.127426772877050e-10,  -2.178751563719051e-11,   3.290034177982052e-13,   2.078203848374653e-14,  -3.905350429196047e-16,   1.501753156792759e-17,  -2.032228589248544e-18,
  -3.323841991740868e-20,   2.212673629334095e-21,  -2.868683923040924e-03,   2.283535603051886e-04,  -1.190278284993972e-05,   5.176885330173498e-07,  -1.631633603311942e-08,
   4.632191458571391e-10,  -1.963953825754974e-11,   2.962715040218859e-13,   1.879386055737988e-14,  -3.580394958990626e-16,   1.345815684043616e-17,  -1.825989957875306e-18,
  -2.904803826279258e-20,   1.998806739636828e-21,  -2.444022259518997e-03,   1.945837903396329e-04,  -1.014353042068682e-05,   4.411938342400756e-07,  -1.391370468532923e-08,
   3.948867810048553e-10,  -1.669748791176335e-11,   2.515768740082762e-13,   1.604095023908008e-14,  -3.105823357885027e-16,   1.136313137298370e-17,  -1.546382716600284e-18,
  -2.376332850446162e-20,   1.703448030621193e-21,  -1.944386714592866e-03,   1.548311372576123e-04,  -8.072003997960700e-06,   3.511084524922096e-07,  -1.107911812031176e-08,
   3.143438622274642e-10,  -1.325714860593691e-11,   1.994947777138712e-13,   1.278409171976406e-14,  -2.513545675846464e-16,   8.962747965698242e-18,  -1.223074310614838e-18,
  -1.815273438191028e-20,   1.355336098060599e-21,  -1.418650889694441e-03,   1.129824311747893e-04,  -5.890697416920744e-06,   2.562373280210211e-07,  -8.089233216054296e-09,
   2.294576163924737e-10,  -9.656809569606756e-12,   1.451679656303929e-13,   9.340550993513796e-15,  -1.858895836790648e-16,   6.494871302738041e-18,  -8.881541330547585e-19,
  -1.280619931375299e-20,   9.887999263892335e-22,  -9.183743411461522e-04,   7.314667291749849e-05,  -3.813923922608952e-06,   1.659044771422471e-07,  -5.239086000164371e-09,
   1.485872409594334e-10,  -6.244653510535583e-12,   9.380945392946141e-14,   6.052258809918667e-15,  -1.214026737266585e-16,   4.185802778923931e-18,  -5.731499151164827e-19,
  -8.104000015032729e-21,   6.400306944464876e-22,  -4.926756841526814e-04,   3.924245991040196e-05,  -2.046184524827909e-06,   8.900946906778512e-08,  -2.811263390382490e-09,
   7.972454269678994e-11,  -3.348176619900784e-12,   5.027956364623568e-14,   3.248359275360483e-15,  -6.542139923226631e-17,   2.240437689761337e-18,  -3.069781671935926e-19,
  -4.296430785630574e-21,   3.433254967887490e-22,  -1.833426675340613e-04,   1.460379378230264e-05,  -7.614793611349351e-07,   3.312465832806056e-08,  -1.046261753361791e-09,
   2.967006501895519e-11,  -1.245738035765204e-12,   1.870490953898925e-14,   1.209031975058207e-15,  -2.438363673513790e-17,   8.330916232807709e-19,  -1.141734925922722e-19,
  -1.592255553899864e-21,   1.277598493033521e-22,  -2.071006290967482e-05,   1.649622923083690e-06,  -8.601570289941763e-08,   3.741720191646954e-09,  -1.181854454880077e-10,
   3.351507417587154e-12,  -1.407120393595689e-13,   2.112766602001838e-15,   1.365736670309130e-16,  -2.755012289709930e-18,   9.409278858630598e-20,  -1.289568243226201e-20,
  -1.797400633946272e-22,   1.443144959592146e-23,  -2.607417364301465e-02,   1.350210938018444e-03,  -1.315458938389895e-05,  -1.865585309982068e-06,   1.530230521521675e-07,
  -3.152155839066839e-09,  -2.708287822545241e-10,   1.434668082160275e-11,  -2.246721099400292e-14,  -1.288586661185553e-14,   1.012334755498927e-15,  -3.683682148301626e-17,
  -2.167619555531296e-18,   1.263896125892639e-19,  -2.480626847776163e-02,   1.284368089142559e-03,  -1.248774519245758e-05,  -1.775752412084307e-06,   1.454591445036839e-07,
  -2.989943972110427e-09,  -2.576667533304662e-10,   1.363467030346833e-11,  -2.005419096561083e-14,  -1.231656615678408e-14,   9.589011656110241e-16,  -3.475625933344871e-17,
  -2.056824545998375e-18,   1.199325433515731e-19,  -2.239442570615666e-02,   1.159195782873082e-03,  -1.123033638095315e-05,  -1.604506666241722e-06,   1.311208393644649e-07,
  -2.685024505162538e-09,  -2.326250470455655e-10,   1.228602777459635e-11,  -1.600866776760402e-14,  -1.120968277965044e-14,   8.589834727906842e-16,  -3.091721928158585e-17,
  -1.848245295989568e-18,   1.077704379855711e-19,  -1.907453109149138e-02,   9.870432912773488e-04,  -9.520968742385999e-06,  -1.368086657066073e-06,   1.114810650394906e-07,
  -2.272356876273887e-09,  -1.981478624959138e-10,   1.044087949614337e-11,  -1.148827447908801e-14,  -9.640275422060915e-15,   7.247772789057626e-16,  -2.586184445787268e-17,
  -1.565373127542963e-18,   9.126915665310081e-20,  -1.517141081601967e-02,   7.848336790686423e-04,  -7.538414507892312e-06,  -1.089251724264737e-06,   8.851365823344123e-08,
  -1.796102277726843e-09,  -1.576068130421794e-10,   8.285953097857555e-12,  -7.488984572602584e-15,  -7.738186971737679e-15,   5.711874626965155e-16,  -2.020672551986759e-17,
  -1.238190381063547e-18,   7.218132425158803e-20,  -1.106710233873140e-02,   5.723745004297271e-04,  -5.478900740397901e-06,  -7.952270661070506e-07,   6.447668926377899e-08,
  -1.303587407944792e-09,  -1.149715280460295e-10,   6.033460464948670e-12,  -4.499149401972623e-15,  -5.685830862569756e-15,   4.135698703369618e-16,  -1.452750356546773e-17,
  -8.991798443337813e-19,   5.240863467762048e-20,  -7.163446064726065e-03,   3.704236748513880e-04,  -3.537736054896819e-06,  -5.150068340182846e-07,   4.169496589953231e-08,
  -8.409506449924338e-10,  -7.441860418692958e-11,   3.900622983113341e-12,  -2.501487976779438e-15,  -3.697716885314305e-15,   2.663723389907482e-16,  -9.312514347174140e-18,
  -5.802836539804079e-19,   3.381663299516156e-20,  -3.842682906836886e-03,   1.986897820704500e-04,  -1.895373835935922e-06,  -2.763410223529250e-07,   2.235563097551653e-08,
  -4.503321748951456e-10,  -3.992042536254572e-11,   2.091117360031185e-12,  -1.228989639724987e-15,  -1.988343359569700e-15,   1.425266392901356e-16,  -4.970540547833494e-18,
  -3.108036997137482e-19,   1.811082630342033e-20,  -1.429970010043309e-03,   7.393591774261461e-05,  -7.050145999535537e-07,  -1.028441056175880e-07,   8.317761459754853e-09,
  -1.674804228104590e-10,  -1.485551920506951e-11,   7.779959588620422e-13,  -4.427359278656105e-16,  -7.405360601166805e-16,   5.299113017568703e-17,  -1.846446009771070e-18,
  -1.155968987782611e-19,   6.735726405288824e-21,  -1.615262865839714e-04,   8.351601670970513e-06,  -7.963140326719042e-08,  -1.161722217510080e-08,   9.395311406928989e-10,
  -1.891641576476266e-11,  -1.678047141872473e-12,   8.787772110775689e-14,  -4.974876163629725e-17,  -8.366040120378823e-17,   5.984919440250443e-18,  -2.085125938091456e-19,
  -1.305646389627082e-20,   7.607844080471010e-22,  -3.649095096814968e-02,  -1.874039839693447e-03,   8.402971019641838e-05,   1.049014340588715e-05,   2.532979012830299e-08,
  -3.771439590480067e-08,  -1.268571604146527e-09,   8.910637133028106e-11,   6.907632552164107e-12,  -7.728349898426341e-14,  -2.420190488497372e-14,  -4.892391515956389e-16,
   5.968306717888095e-17,   3.284347680593420e-18,  -3.471351602251586e-02,  -1.781971564082371e-03,   7.994566366001683e-05,   9.968856756399697e-06,   2.355329751266459e-08,
  -3.582473963655540e-08,  -1.201296948962394e-09,   8.468453896261105e-11,   6.540195959286603e-12,  -7.425693223534629e-14,  -2.291013454331133e-14,  -4.583104844718345e-16,
   5.655454291169279e-17,   3.088507839679302e-18,  -3.133365125241027e-02,  -1.607220263925808e-03,   7.217592227767793e-05,   8.981821460832668e-06,   2.039884894088150e-08,
  -3.225292113030373e-08,  -1.075632826662839e-09,   7.630832172901245e-11,   5.854281498620027e-12,  -6.818673108829020e-14,  -2.050023333500398e-14,  -4.024916297382669e-16,
   5.069433097453696e-17,   2.731192988277930e-18,  -2.668363912918709e-02,  -1.367417586549077e-03,   6.147915755462157e-05,   7.632007934314893e-06,   1.648937948044448e-08,
  -2.738032507992853e-08,  -9.070951927492348e-10,   6.484757317018537e-11,   4.935183952508407e-12,  -5.923978768003303e-14,  -1.727418394910123e-14,  -3.313902221129999e-16,
   4.280521417478805e-17,   2.268330660873737e-18,  -2.121971917097060e-02,  -1.086424433271518e-03,   4.890121688178399e-05,   6.056216712667659e-06,   1.243565481325310e-08,
  -2.170730726556631e-08,  -7.145141875214682e-10,   5.146244601578273e-11,   3.886028791669661e-12,  -4.799613741506194e-14,  -1.359586299160302e-14,  -2.548853614120056e-16,
   3.375639267857014e-17,   1.760042003798612e-18,  -1.547694208537345e-02,  -7.918191057716741e-04,   3.567323640047912e-05,   4.409566384164182e-06,   8.674203004239680e-09,
  -1.579357481361208e-08,  -5.171456452546275e-10,   3.747174067631349e-11,   2.811786044597477e-12,  -3.551830152396400e-14,  -9.833801711224035e-15,  -1.808916039381015e-16,
   2.445342945251044e-17,   1.258291915416496e-18,  -1.001686874535776e-02,  -5.122264703954311e-04,   2.309085186332733e-05,   2.850665803490525e-06,   5.445349246874362e-09,
  -1.020513236626422e-08,  -3.330004865929763e-10,   2.422493807681376e-11,   1.810217932352970e-12,  -2.320369165619270e-14,  -6.329369162332232e-15,  -1.149526335881340e-16,
   1.575481098635328e-17,   8.036098737041900e-19,  -5.373080642698772e-03,  -2.746914628083312e-04,   1.238674448953900e-05,   1.528208866959658e-06,   2.874534605615675e-09,
  -5.469477317138631e-09,  -1.781546296692588e-10,   1.298679885601611e-11,   9.683674468102633e-13,  -1.250549365427467e-14,  -3.385420147989193e-15,  -6.107975049425648e-17,
   8.431135887651565e-18,   4.281080650571589e-19,  -1.999439967339077e-03,  -1.022097919079074e-04,   4.609471806369939e-06,   5.685635000160918e-07,   1.063677257102059e-09,
  -2.034717081424535e-09,  -6.623466817438777e-11,   4.831691822344749e-12,   3.600090995438946e-13,  -4.661173174966385e-15,  -1.258536547487561e-15,  -2.265402998206009e-17,
   3.134843055824857e-18,   1.589270883631567e-19,  -2.258517599333588e-04,  -1.154520468178138e-05,   5.206761631429784e-07,   6.422143453452344e-08,   1.200428277790636e-10,
  -2.298259249988111e-10,  -7.480618412800870e-12,   5.457583360324852e-13,   4.065961304045811e-14,  -5.266507227389494e-16,  -1.421387226439068e-16,  -2.557598288697476e-18,
   3.540580672141448e-19,   1.794518014936058e-20,  -2.458291352984529e-03,   1.793327177732400e-04,  -8.171698802649589e-06,   3.596682468869787e-07,  -1.255840773862106e-08,
   1.700439472656579e-10,  -5.865712346763582e-12,   7.488100282082008e-13,  -2.956361827051063e-15,  -1.339708139983286e-15,  -3.040186390642073e-17,   2.136971825893946e-18,
   1.827497725056359e-19,  -2.306770900437492e-21,  -2.338965506511715e-03,   1.706420937878294e-04,  -7.776471266314182e-06,   3.422258359632724e-07,  -1.195018877437873e-08,
   1.622338257607892e-10,  -5.583077706555509e-12,   7.109773932693390e-13,  -2.850462727109083e-15,  -1.271104207051582e-15,  -2.858024413039988e-17,   2.027430070959238e-18,
   1.724359562084583e-19,  -2.213604047604231e-21,  -2.111894262970361e-03,   1.540984725719486e-04,  -7.023791356882111e-06,   3.090274628395628e-07,  -1.079222194535308e-08,
   1.471895654261437e-10,  -5.044428816284776e-12,   6.395937017994309e-13,  -2.633007402550615e-15,  -1.142022986725425e-15,  -2.525845607829231e-17,   1.821289220927503e-18,
   1.534133647185134e-19,  -2.027899922561573e-21,  -1.799163531053832e-03,   1.313027788809863e-04,  -5.986046489333916e-06,   2.632930443287258e-07,  -9.196349467917523e-09,
   1.261185643131186e-10,  -4.300973002120061e-12,   5.424587026066903e-13,  -2.303250739067208e-15,  -9.670815120255529e-16,  -2.096019723025126e-17,   1.541921410503298e-18,
   1.283693835156701e-19,  -1.756592396281952e-21,  -1.431280804042699e-03,   1.044727291160748e-04,  -4.763862748411736e-06,   2.094771056016002e-07,  -7.317668413451942e-09,
   1.008886981899261e-10,  -3.424305908532732e-12,   4.296750674653462e-13,  -1.877980857749197e-15,  -7.648536549238601e-16,  -1.624816892537110e-17,   1.219109257500351e-18,
   1.003447958743087e-19,  -1.418905159989323e-21,  -1.044236782327044e-03,   7.623200047496635e-05,  -3.476691771761094e-06,   1.528430218311341e-07,  -5.339860387258874e-09,
   7.393373432136718e-11,  -2.499965719710228e-12,   3.123908058700211e-13,  -1.396598223176790e-15,  -5.553971122406419e-16,  -1.160631307538640e-17,   8.849843656156597e-19,
   7.217627113283154e-20,  -1.047379307559091e-21,  -6.759752675138982e-04,   4.935247341850427e-05,  -2.251053063053495e-06,   9.894654791679173e-08,  -3.457137075760006e-09,
   4.799985177466663e-11,  -1.619040571215848e-12,   2.017566301896755e-13,  -9.152654155827655e-16,  -3.584097907460956e-16,  -7.407880971331600e-18,   5.709694196623609e-19,
   4.628376607218554e-20,  -6.830723490008966e-22,  -3.626317558611812e-04,   2.647673186783140e-05,  -1.207718721094054e-06,   5.308204407589141e-08,  -1.854726219456521e-09,
   2.578829127543098e-11,  -8.687441503930177e-13,   1.081055511064470e-13,  -4.940637266119848e-16,  -1.919633023030791e-16,  -3.945117039938479e-18,   3.057713405679075e-19,
   2.470893019902476e-20,  -3.678102286291568e-22,  -1.349478707658365e-04,   9.853072769001752e-06,  -4.494503022702722e-07,   1.975386191018560e-08,  -6.902236337626776e-10,
   9.601693478891220e-12,  -3.233156283963748e-13,   4.021323191755756e-14,  -1.842538020553980e-16,  -7.139632319822561e-17,  -1.464380131730091e-18,   1.137194893828137e-19,
   9.179498259400825e-21,  -1.370511739179785e-22,  -1.524346007450014e-05,   1.112987634777453e-06,  -5.076935958410687e-08,   2.231362842828889e-09,  -7.796665527561290e-11,
   1.084678562806294e-12,  -3.652159316286100e-14,   4.542114298621737e-15,  -2.082004956047480e-17,  -8.064080816121930e-18,  -1.653467433929028e-19,   1.284431070074898e-20,
   1.036620413000776e-21,  -1.548419645445501e-23,  -2.097522942036259e-02,   1.190622048497974e-03,  -2.371401613451464e-05,  -1.431116204439675e-07,   5.598632390777659e-08,
  -5.159507367395178e-09,   8.383801438874420e-11,   1.004729499948298e-11,  -2.414033981804765e-13,  -1.027326406249393e-14,  -4.379951789100316e-16,   1.827432138408864e-17,
   3.181931508273042e-18,  -3.416410894089528e-20,  -1.995567751413310e-02,   1.132694120187956e-03,  -2.255048220173628e-05,  -1.376654020740769e-07,   5.329973575897854e-08,
  -4.902325169479387e-09,   7.955611733642771e-11,   9.547795052521362e-12,  -2.301990298363269e-13,  -9.744481280581162e-15,  -4.107106111943359e-16,   1.730329438571153e-17,
   3.003337481586887e-18,  -3.273037160139201e-20,  -1.801609360097257e-02,   1.022514842249856e-03,  -2.034139582452129e-05,  -1.266878569963833e-07,   4.817453556424193e-08,
  -4.415673715272604e-09,   7.149379240826286e-11,   8.602120214178044e-12,  -2.086577474546950e-13,  -8.750689153506975e-15,  -3.613063685789033e-16,   1.548905051446902e-17,
   2.673563856705693e-18,  -2.989714968502209e-20,  -1.534594105498395e-02,   8.708782571736558e-04,  -1.730878176909210e-05,  -1.103823708772004e-07,   4.109133248369257e-08,
  -3.750767695059203e-09,   6.055716302928942e-11,   7.309059086644584e-12,  -1.785748042612139e-13,  -7.405957757575211e-15,  -2.980804039696833e-16,   1.305612953909921e-17,
   2.238681061462253e-18,  -2.580530757974464e-20,  -1.220630006552064e-02,   6.926344578207877e-04,  -1.375378540034115e-05,  -8.970368571777498e-08,   3.272804715232557e-08,
  -2.975328365261060e-09,   4.790407755122582e-11,   5.799732293336185e-12,  -1.426772315228148e-13,  -5.854094644938177e-15,  -2.297004042283757e-16,   1.027825230362169e-17,
   1.751136090888116e-18,  -2.077196223868515e-20,  -8.904444860012149e-03,   5.052327262562177e-04,  -1.002522904674270e-05,  -6.655596717012991e-08,   2.390053007095306e-08,
  -2.165755835358340e-09,   3.479055872090168e-11,   4.222704663336766e-12,  -1.044501706346564e-13,  -4.249111385106123e-15,  -1.632592791607840e-16,   7.434885214126298e-18,
   1.260248841706998e-18,  -1.528966776123223e-20,  -5.763744707994313e-03,   3.270136725579487e-04,  -6.485749633878114e-06,  -4.355833303243401e-08,   1.548144248882219e-08,
  -1.399846169811191e-09,   2.245301425835503e-11,   2.729819966382303e-12,  -6.776454971965457e-14,  -2.741276104863348e-15,  -1.038465882000357e-16,   4.785439765185999e-18,
   8.084383368279703e-19,  -9.952737127635939e-21,  -3.091877889518286e-03,   1.754169082986943e-04,  -3.478232048489055e-06,  -2.349767157165910e-08,   8.307796572107440e-09,
  -7.503704540920265e-10,   1.202625547822631e-11,   1.463413135288593e-12,  -3.639370911118906e-14,  -1.468010930442461e-15,  -5.520514927619865e-17,   2.559604255033854e-18,
   4.316705231250797e-19,  -5.353991874454373e-21,  -1.150579071799662e-03,   6.527718096315653e-05,  -1.294229157717308e-06,  -8.761195405684911e-09,   3.091964702635046e-09,
  -2.791628977062531e-10,   4.472948245343579e-12,   5.444550539545549e-13,  -1.354864387492652e-14,  -5.459658723609438e-16,  -2.047858692851987e-17,   9.515350223054677e-19,
   1.603781927411601e-19,  -1.994295604507828e-21,  -1.299669803038624e-04,   7.373561091659218e-06,  -1.461911729275983e-07,  -9.899511310448358e-10,   3.492687561933675e-10,
  -3.153235851801896e-11,   5.052121753881467e-13,   6.149826658808071e-14,  -1.530524114843778e-15,  -6.166533928843752e-17,  -2.312055602903028e-18,   1.074660050815445e-19,
   1.811133894341980e-20,  -2.253056505056023e-22,  -4.191783788469614e-02,  -7.537413102008710e-04,   1.852866315949430e-04,   4.405483180099042e-06,  -7.374386094952948e-07,
  -2.236255703962359e-08,   2.641816861209867e-09,   1.012434463430051e-10,  -8.663773389096651e-12,  -4.192580392677664e-13,   2.632755918326884e-14,   1.618063793208049e-15,
  -7.433187676525891e-17,  -5.918052062332881e-18,  -3.987362200230696e-02,  -7.166986036237619e-04,   1.761455014181284e-04,   4.184738648178448e-06,  -7.004180489952942e-07,
  -2.121364885647794e-08,   2.506300158599658e-09,   9.588741317566418e-11,  -8.208279110775409e-12,  -3.963417627350319e-13,   2.490664940436481e-14,   1.526440870787624e-15,
  -7.021596924796136e-17,  -5.570120974396062e-18,  -3.598745890661800e-02,  -6.463945919876659e-04,   1.588106359609936e-04,   3.767507810378259e-06,  -6.304729434181144e-07,
  -1.905352729823931e-08,   2.251422944555501e-09,   8.587865594214461e-11,  -7.355985877176045e-12,  -3.538063996486532e-13,   2.226228386975437e-14,   1.357600312302840e-15,
  -6.259603573955944e-17,  -4.933801561824342e-18,  -3.064281029536935e-02,  -5.499299921391642e-04,   1.350529512474657e-04,   3.198353349671521e-06,  -5.351131203111636e-07,
  -1.612893920757407e-08,   1.906181777263566e-09,   7.244630012433759e-11,  -6.210008528647694e-12,  -2.972769705336180e-13,   1.873447764585391e-14,   1.135567928728133e-15,
  -5.250775321178969e-17,  -4.106331055616021e-18,  -2.436510341900782e-02,  -4.369084066325840e-04,   1.072524574833732e-04,   2.535709827845455e-06,  -4.241582175276680e-07,
  -1.275180967268138e-08,   1.507315929097264e-09,   5.708499064524150e-11,  -4.896757816727130e-12,  -2.333312268416981e-13,   1.472687731588254e-14,   8.873837586582555e-16,
  -4.114571896423049e-17,  -3.193172534509098e-18,  -1.776927097278267e-02,  -3.184231540786424e-04,   7.814057501252457e-05,   1.844934283585505e-06,  -3.085572601969182e-07,
  -9.257200263379646e-09,   1.094387871475608e-09,   4.132853523249663e-11,  -3.547209279980354e-12,  -1.683950506989593e-13,   1.064136882941017e-14,   6.381385781351716e-16,
  -2.965513021559048e-17,  -2.287136700230338e-18,  -1.149972022138511e-02,  -2.059836226108809e-04,   5.053693544700477e-05,   1.192133027480260e-06,  -1.993567297185529e-07,
  -5.972823257068953e-09,   7.061714338344973e-10,   2.661759397882447e-11,  -2.285444970502997e-12,  -1.082276850832531e-13,   6.844746358044485e-15,   4.091589897565565e-16,
  -1.904234040502346e-17,  -1.462563014318436e-18,  -6.168274368442229e-03,  -1.104617090549295e-04,   2.709809695958544e-05,   6.389327135925874e-07,  -1.068405850045323e-07,
  -3.198742442261581e-09,   3.782070760389199e-10,   1.424185943531600e-11,  -1.223076055590548e-12,  -5.784529193020741e-14,   3.659883674140135e-15,   2.184187800890766e-16,
  -1.017299989868408e-17,  -7.796805275581162e-19,  -2.295321292489606e-03,  -4.110150125378854e-05,   1.008248540398698e-05,   2.376919670787889e-07,  -3.974540365179187e-08,
  -1.189661726807320e-09,   1.406632933726867e-10,   5.295061528736775e-12,  -4.547652689131916e-13,  -2.149855077408763e-14,   1.360414381143336e-15,   8.114201112028202e-17,
  -3.780245886531231e-18,  -2.895107268157557e-19,  -2.592732843075164e-04,  -4.642656937846536e-06,   1.138869058701541e-06,   2.684786030557126e-08,  -4.489321432773091e-09,
  -1.343694032914334e-10,   1.588761754629154e-11,   5.980337655057388e-13,  -5.136256057758387e-14,  -2.427940177472169e-15,   1.536420071043547e-16,   9.163157128357365e-18,
  -4.269113514009505e-19,  -3.269121233027254e-20,  -1.848877359497185e-03,   1.280486032456639e-04,  -4.956135030708979e-06,   1.846266429903303e-07,  -9.120618339176219e-09,
   2.239744045150713e-10,   6.473898108226776e-12,  -6.399089221325379e-14,  -3.662590734121883e-14,   4.689853908607181e-16,   1.001528723423678e-16,  -6.916886580995081e-19,
  -2.923286689424043e-19,   1.197623924045847e-22,  -1.759097090116511e-03,   1.218368716186697e-04,  -4.716687135328623e-06,   1.757128141850159e-07,  -8.674215122554199e-09,
   2.130425883675928e-10,   6.129254708757336e-12,  -6.038415394502071e-14,  -3.471486864786818e-14,   4.450470084523055e-16,   9.473196917754263e-17,  -6.576305525774953e-19,
  -2.759161385053615e-19,   1.242696602448138e-22,  -1.588264076461069e-03,   1.100147193174688e-04,  -4.260571020319249e-06,   1.587306724426131e-07,  -7.826250987673893e-09,
   1.922647551210574e-10,   5.485942316863630e-12,  -5.372626558539059e-14,  -3.113350260011993e-14,   3.999725767687856e-16,   8.464991427983294e-17,  -5.929857193721757e-19,
  -2.456184795163760e-19,   1.283131024476013e-22,  -1.353014666037996e-03,   9.372985268600344e-05,  -3.631503632249222e-06,   1.353043610056916e-07,  -6.661331270083607e-09,
   1.636965783047137e-10,   4.624083748196831e-12,  -4.495353179102699e-14,  -2.630720733162020e-14,   3.388220345370602e-16,   7.121164489621455e-17,  -5.043074060938773e-19,
  -2.056736663522155e-19,   1.254266991259483e-22,  -1.076312996284372e-03,   7.456928583019221e-05,  -2.890374440406292e-06,   1.076987696161859e-07,  -5.294647308215440e-09,
   1.301500824355533e-10,   3.640543997139582e-12,  -3.513309625997275e-14,  -2.076248589535802e-14,   2.680591118291591e-16,   5.596033691914467e-17,  -4.004831484415917e-19,
  -1.608948786083706e-19,   1.118333693336603e-22,  -7.852322446441214e-04,   5.440722300456696e-05,  -2.109599057080418e-06,   7.861072270916264e-08,  -3.860180631302288e-09,
   9.491150776011479e-11,   2.633821537838853e-12,  -2.526422366637645e-14,  -1.505127632457589e-14,   1.947008812382564e-16,   4.042564264461807e-17,  -2.917519882311117e-19,
  -1.158036926402199e-19,   8.847493973426553e-23,  -5.083002220245865e-04,   3.522112369930606e-05,  -1.365982257503520e-06,   5.090302572905341e-08,  -2.497695080498725e-09,
   6.142134113079793e-11,   1.695487932225851e-12,  -1.619737814048076e-14,  -9.702138594580173e-15,   1.256656006877008e-16,   2.599831179262101e-17,  -1.886714479119430e-19,
  -7.429324991245958e-20,   6.015495460310710e-23,  -2.726781715492953e-04,   1.889495449112207e-05,  -7.328890620724488e-07,   2.731148674572198e-08,  -1.339589982129003e-09,
   3.294481090957012e-11,   9.069479974309504e-13,  -8.645970199459546e-15,  -5.193481428540677e-15,   6.731181462132344e-17,   1.390012299823234e-17,  -1.011605946038917e-19,
  -3.967124655162685e-20,   3.305415857130126e-23,  -1.014726151473918e-04,   7.031511720332813e-06,  -2.727461816322112e-07,   1.016409608020768e-08,  -4.984670173288884e-10,
   1.225924786146436e-11,   3.371692779773456e-13,  -3.211870297076645e-15,  -1.931213186257603e-15,   2.503580504980957e-17,   5.166660860271817e-18,  -3.763838006149617e-20,
  -1.473928613175945e-20,   1.240149092892609e-23,  -1.146215034483565e-05,   7.942672336382334e-07,  -3.080912832737883e-08,   1.148127096032097e-09,  -5.630517199654994e-11,
   1.384769965268830e-12,   3.807996422650721e-14,  -3.627066063543410e-16,  -2.181200549608271e-16,   2.827760250706189e-18,   5.835078636543059e-19,  -4.251435695209763e-21,
  -1.664496665590500e-21,   1.402654524612267e-24,  -1.659050520442851e-02,   1.002530473001694e-03,  -2.289512966901644e-05,   1.114386837807207e-07,  -1.045361657552007e-08,
  -1.028752771361923e-09,   1.964217413916825e-10,  -3.509073152561783e-12,  -4.776134991682779e-13,   1.042913812800327e-14,   1.244214380265440e-15,  -1.242860440095913e-17,
  -4.223583381309245e-18,   1.371253635888441e-20,  -1.578422069459925e-02,   9.537763991610077e-04,  -2.178315705807776e-05,   1.057058475515721e-07,  -9.859039931624521e-09,
  -9.808528425838804e-10,   1.864792497190898e-10,  -3.327365924096087e-12,  -4.527815455615832e-13,   9.901841374074532e-15,   1.175793232001240e-15,  -1.179247532917966e-17,
  -3.983143927129815e-18,   1.303306606303720e-20,  -1.425029880251802e-02,   8.610368039706470e-04,  -1.966736632184969e-05,   9.492746631204580e-08,  -8.763322434610576e-09,
  -8.888629320927245e-10,   1.677271995635821e-10,  -2.986248659599795e-12,  -4.062131989203982e-13,   8.907071821159320e-15,   1.048952623612894e-15,  -1.059538744141366e-17,
  -3.540528634189708e-18,   1.174322498106472e-20,  -1.213849811985628e-02,   7.333843035080796e-04,  -1.675390676408553e-05,   8.033768673477109e-08,  -7.323281970165944e-09,
  -7.605549925692258e-10,   1.422250728598325e-10,  -2.525457459772584e-12,  -3.433923322018898e-13,   7.553734500195085e-15,   8.806863858730426e-16,  -8.972700539336953e-18,
  -2.959378534980171e-18,   9.975457530285177e-21,  -9.655245990404005e-03,   5.833104841167653e-04,  -1.332728580662033e-05,   6.349831886973882e-08,  -5.716247274879301e-09,
  -6.075889275750030e-10,   1.126325269135067e-10,  -1.994754722516536e-12,  -2.711344421006876e-13,   5.982742286950847e-15,   6.907321156947939e-16,  -7.096630086470027e-18,
  -2.310957246862546e-18,   7.910632917312030e-21,  -7.043564642876246e-03,   4.255049115621221e-04,  -9.722819346086124e-06,   4.608441664049689e-08,  -4.106221003204978e-09,
  -4.447769082280242e-10,   8.187546584742665e-11,  -1.446947472215187e-12,  -1.966233574956424e-13,   4.349407885377338e-15,   4.982000439548440e-16,  -5.153305728275830e-18,
  -1.660897501664128e-18,   5.755263436347380e-21,  -4.559262507213530e-03,   2.754168821705624e-04,  -6.293730228783299e-06,   2.972823716124866e-08,  -2.630688849656764e-09,
  -2.885571379266104e-10,   5.287359238553063e-11,  -9.330837821680140e-13,  -1.267752549290665e-13,   2.808930396441255e-15,   3.200652248695608e-16,  -3.325573477962567e-18,
  -1.064511473368225e-18,   3.718235624456117e-21,  -2.445762924779787e-03,   1.477413414380950e-04,  -3.376252255004072e-06,   1.591924823222193e-08,  -1.403704426048769e-09,
  -1.549733154005191e-10,   2.832932814727933e-11,  -4.995738056805855e-13,  -6.787037158629835e-14,   1.505052042355660e-15,   1.710323719564989e-16,  -1.781175824999111e-18,
  -5.681464520945364e-19,   1.992570749560562e-21,  -9.101421901015563e-04,   5.497864668458063e-05,  -1.256412361198531e-06,   5.920389418444271e-09,  -5.213901308489017e-10,
  -5.769357089736213e-11,   1.053778596025609e-11,  -1.857811651036267e-13,  -2.523893165750249e-14,   5.598467255114723e-16,   6.356062750518114e-17,  -6.624681919048561e-19,
  -2.110499972325354e-19,   7.412280970158408e-22,  -1.028077665730433e-04,   6.210266905170273e-06,  -1.419218495175534e-07,   6.686895474855264e-10,  -5.887774740569860e-11,
  -6.517363600430746e-12,   1.190247294763278e-12,  -2.098320747214384e-14,  -2.850620369796787e-15,   6.323502425338939e-17,   7.178141286991263e-18,  -7.482455601771822e-20,
  -2.383306145510580e-20,   8.372276271918183e-23,  -4.193050309037703e-02,   7.299659226329737e-04,   1.648223086749187e-04,  -7.216672171291770e-06,  -5.091215315926930e-07,
   3.891166133690107e-08,   1.153799727186322e-09,  -1.631918250644729e-10,  -1.170121596827641e-12,   5.845365052768622e-13,  -5.872220859458391e-15,  -1.851495796188754e-15,
   4.924448960807224e-17,   5.232871413868298e-18,  -3.988622164485912e-02,   6.938381793775587e-04,   1.567157295509083e-04,  -6.854386818327970e-06,  -4.838470548949614e-07,
   3.691994217415459e-08,   1.096664271567699e-09,  -1.546484300802585e-10,  -1.120338525271702e-12,   5.531873784666081e-13,  -5.496591189479943e-15,  -1.749822275875670e-15,
   4.624491732962632e-17,   4.939829932364218e-18,  -3.599970869817462e-02,   6.253732486214305e-04,   1.413326293312162e-04,  -6.169897051564874e-06,  -4.359803383181167e-07,
   3.317223487042003e-08,   9.883907411573453e-10,  -1.386483375981203e-10,  -1.022586882620022e-12,   4.947691612635688e-13,  -4.820260821457905e-15,  -1.561269883771033e-15,
   4.079632765524120e-17,   4.398510616766095e-18,  -3.065414340251344e-02,   5.316307732111794e-04,   1.202303139008550e-04,  -5.236692456393267e-06,  -3.705004989161647e-07,
   2.809249902049369e-08,   8.401571055281015e-10,  -1.171074496884405e-10,  -8.822718630787395e-13,   4.166866853574091e-13,  -3.961789241791179e-15,  -1.311018788216265e-15,
   3.378387684527425e-17,   3.684203842285867e-18,  -2.437481014692950e-02,   4.220499741875290e-04,   9.551237294265868e-05,  -4.150870020923836e-06,  -2.940335733725001e-07,
   2.221956388632479e-08,   6.669123480972640e-10,  -9.238757495444394e-11,  -7.102570693212138e-13,   3.277974540398146e-13,  -3.041884406082920e-15,  -1.028382222436438e-15,
   2.613950387878782e-17,   2.882776791250891e-18,  -1.777675788552254e-02,   3.074062650945418e-04,   6.960550247403197e-05,  -3.019580959746009e-06,  -2.141054218420585e-07,
   1.613567718237585e-08,   4.857082346621319e-10,  -6.695197058040075e-11,  -5.230204740542580e-13,   2.370046370763359e-13,  -2.155747429531805e-15,  -7.418057948802312e-16,
   1.864513129853114e-17,   2.075226252203579e-18,  -1.150473972667404e-02,   1.987766216530542e-04,   4.502476922997581e-05,  -1.950929181904912e-06,  -1.384209571631705e-07,
   1.041314711341427e-08,   3.140491035222219e-10,  -4.314802086247813e-11,  -3.406061482712956e-13,   1.525077789663829e-13,  -1.368623490684040e-15,  -4.765957133527667e-16,
   1.188980414692807e-17,   1.331486678910243e-18,  -6.171014706011474e-03,   1.065747289697889e-04,   2.414460982804826e-05,  -1.045554511811128e-06,  -7.420794378141635e-08,
   5.577379879040393e-09,   1.683720527104042e-10,  -2.309414796654142e-11,  -1.832759499826080e-13,   8.156279709376147e-14,  -7.268547173147226e-16,  -2.546843056849710e-16,
   6.329167376797789e-18,   7.110247010193116e-19,  -2.296347227889394e-03,   3.965233685623876e-05,   8.983850238471239e-06,  -3.889531277429666e-07,  -2.760901256763085e-08,
   2.074394494080983e-09,   6.264388582362298e-11,  -8.587289285638760e-12,  -6.827497334840572e-14,   3.031987894120560e-14,  -2.695384896224639e-16,  -9.464903316172164e-17,
   2.348951454215164e-18,   2.641754766302226e-19,  -2.593892824700806e-04,   4.478913921985830e-06,   1.014777520352784e-06,  -4.393301888603036e-08,  -3.118548979111032e-09,
   2.342992682590894e-10,   7.075899910893798e-12,  -9.698815456672138e-13,  -7.713496070263164e-15,   3.424295284589601e-15,  -3.042956398558429e-17,  -1.068908818231621e-17,
   2.652194442727669e-19,   2.983321872949603e-20,  -1.404947414902117e-03,   9.516480437411064e-05,  -3.447513928137139e-06,   8.041496873204232e-08,  -3.766648968791817e-09,
   2.632119817335122e-10,  -5.044529312772858e-12,  -4.509957120014677e-13,   1.706713775124370e-14,   1.205290234044226e-15,  -7.430304291947139e-17,  -2.144930894315963e-18,
   2.447970932209823e-19,   2.097296669888631e-21,  -1.336713801578438e-03,   9.054327805070730e-05,  -3.280502983238076e-06,   7.658096359899290e-08,  -3.585635382317593e-09,
   2.501336472632757e-10,  -4.785499075989909e-12,  -4.277928608803781e-13,   1.614130233641602e-14,   1.143206162004497e-15,  -7.022900038313499e-17,  -2.035539301480433e-18,
   2.310379973709982e-19,   2.010476861467015e-21,  -1.206883721146794e-03,   8.174964635187524e-05,  -2.962554543275004e-06,   6.925668007618070e-08,  -3.240425759110165e-09,
   2.253702821357591e-10,  -4.298455061804221e-12,  -3.841781772725335e-13,   1.441998062369179e-14,   1.026532596427705e-15,  -6.267154767387098e-17,  -1.829477635032165e-18,
   2.056428492618482e-19,   1.838463708726203e-21,  -1.028106413770808e-03,   6.964049006034046e-05,  -2.524402825436589e-06,   5.911456129652655e-08,  -2.763545939336519e-09,
   1.915046729704550e-10,  -3.638966014791708e-12,  -3.251504907345320e-13,   1.212697997404159e-14,   8.686819424697538e-16,  -5.263670399574536e-17,  -1.549806671926977e-18,
   1.721711839111474e-19,   1.589082946547878e-21,  -8.178378276501241e-04,   5.539801638602164e-05,  -2.008648757704749e-06,   4.711459655939459e-08,  -2.200750324218116e-09,
   1.519678996624128e-10,  -2.877287406868270e-12,  -2.570210230342172e-13,   9.526596720271993e-15,   6.865641372756471e-16,  -4.129734060526888e-17,  -1.226098354872880e-18,
   1.346632473897758e-19,   1.280988948469040e-21,  -5.966520325692758e-04,   4.041576732614886e-05,  -1.465721941246023e-06,   3.442526670064270e-08,  -1.606961414625080e-09,
   1.106510657751199e-10,  -2.088941853040371e-12,  -1.865549258294466e-13,   6.880020528401164e-15,   4.982716944290137e-16,  -2.979412139049987e-17,  -8.905115726877020e-19,
   9.690907050872618e-20,   9.440584113490811e-22,  -3.862242935256733e-04,   2.616200892538120e-05,  -9.489251497681442e-07,   2.230673578554182e-08,  -1.040817502236561e-09,
   7.153404399266829e-11,  -1.347880754567998e-12,  -1.203534979824492e-13,   4.423757867815140e-15,   3.214271035451970e-16,  -1.914430816459761e-17,  -5.747327605080386e-19,
   6.216505233112322e-20,   6.150460566956300e-22,  -2.071895055796604e-04,   1.403460476800918e-05,  -5.090868980830218e-07,   1.197264044823324e-08,  -5.585103236370163e-10,
   3.834889481039492e-11,  -7.218792249634466e-13,  -6.445150746039997e-14,   2.364934124862065e-15,   1.721227572122183e-16,  -1.023098183158943e-17,  -3.078416494145852e-19,
   3.319318698903105e-20,   3.310042726403588e-22,  -7.710198692760077e-05,   5.222739059615600e-06,  -1.894527021595575e-07,   4.456216447553606e-09,  -2.078613220683910e-10,
   1.426758341367675e-11,  -2.684809871915541e-13,  -2.397002101657410e-14,   8.790107958036407e-16,   6.401284565340746e-17,  -3.802246506045050e-18,  -1.144966075663656e-19,
   1.233221665546148e-20,   1.233140088090110e-22,  -8.709289204110074e-06,   5.899504296909061e-07,  -2.140029216166279e-08,   5.033799079752955e-10,  -2.347999028084126e-11,
   1.611579207821487e-12,  -3.032432878651638e-14,  -2.707346855286250e-15,   9.927237081489164e-17,   7.230054753339077e-18,  -4.294040846481169e-19,  -1.293221245662422e-20,
   1.392663796405031e-21,   1.393174852498085e-23,  -1.294253986611807e-02,   8.217076567140126e-04,  -2.256137098991175e-05,  -2.154181171425297e-08,   1.700591720155960e-09,
   1.387709129104866e-09,  -1.130884595680935e-11,  -6.990927417909834e-12,   2.810970632164897e-13,   1.386863959835825e-14,  -1.108594778454929e-15,  -1.952583719283724e-17,
   3.575951448513941e-18,  -3.409930510611561e-21,  -1.231368077327155e-02,   7.817383733391750e-04,  -2.146368534620980e-05,  -2.009465542267868e-08,   1.613693472845779e-09,
   1.315914641552786e-09,  -1.053291852368408e-11,  -6.636262578720367e-12,   2.659955982973731e-13,   1.316214932479725e-14,  -1.047959009045229e-15,  -1.857632698327586e-17,
   3.374505055361476e-18,  -2.663983064072594e-21,  -1.111724723978419e-02,   7.057127932421091e-04,  -1.937588308020935e-05,  -1.750606140609759e-08,   1.450238060950665e-09,
   1.181111975036276e-09,  -9.150425643330414e-12,  -5.967641147850974e-12,   2.378637699348117e-13,   1.183130538987379e-14,  -9.354244051972883e-16,  -1.676841842913174e-17,
   3.002859203652876e-18,  -1.498162655347803e-21,  -9.469969488129813e-03,   6.010735115015004e-04,  -1.650250149522041e-05,  -1.425955512004233e-08,   1.228684911490881e-09,
   9.989694382614019e-10,  -7.427112293704168e-12,  -5.058932697623241e-12,   2.002811511387205e-13,   1.002471844748716e-14,  -7.858934877931240e-16,  -1.427823873420719e-17,
   2.513341108525899e-18,  -3.668895050230775e-22,  -7.532809620702831e-03,   4.780637933668579e-04,  -1.312493102218102e-05,  -1.084094332564169e-08,   9.723630364379227e-10,
   7.891299696175155e-10,  -5.626069214352521e-12,  -4.005256929584979e-12,   1.575218098459754e-13,   7.932788816214033e-15,  -6.167841389600254e-16,  -1.135119587029458e-17,
   1.965215782019654e-18,   3.899048674165176e-22,  -5.495335666372895e-03,   3.487247158368796e-04,  -9.573814665254254e-06,  -7.614995899037558e-09,   7.065142963680513e-10,
   5.724670168053848e-10,  -3.939773476724539e-12,  -2.910881412194658e-12,   1.138709714767553e-13,   5.762876592140848e-15,  -4.450961302563450e-16,  -8.276177355554689e-18,
   1.413899913618678e-18,   6.746175758527217e-22,  -3.557145671205331e-03,   2.257166036185674e-04,  -6.196692012985491e-06,  -4.803954857629793e-09,   4.561390461392000e-10,
   3.691852494640876e-10,  -2.480167327042071e-12,  -1.879512164990392e-12,   7.326473039310617e-14,   3.719957478613539e-15,  -2.860475541078377e-16,  -5.354837794383626e-18,
   9.068359509130279e-19,   6.002954183810736e-22,  -1.908201124732044e-03,   1.210799756316839e-04,  -3.324035904848420e-06,  -2.542596523205654e-09,   2.443687227987207e-10,
   1.976682180895785e-10,  -1.311218705906920e-12,  -1.006952966787832e-12,   3.918026813921358e-14,   1.992684727707428e-15,  -1.528815042030998e-16,  -2.871856445056915e-18,
   4.841658291604123e-19,   3.665593972066717e-22,  -7.101007802117424e-04,   4.505711777098821e-05,  -1.236960227465369e-06,  -9.417211225494115e-10,   9.089556850673536e-11,
   7.350952014271649e-11,  -4.854554541356458e-13,  -3.745506898606292e-13,   1.456441591926395e-14,   7.411699545797258e-16,  -5.681873553368527e-17,  -1.068612791912865e-18,
   1.798760357879949e-19,   1.421448868790017e-22,  -8.021153338974773e-05,   5.089551119756936e-06,  -1.397242034191343e-07,  -1.062950069651398e-10,   1.026663332711292e-11,
   8.302607930069582e-12,  -5.479144648570392e-14,  -4.230547492894689e-14,   1.644884008366778e-15,   8.371441565287986e-17,  -6.416816752801236e-18,  -1.207066161492658e-19,
   2.031310805430381e-20,   1.615905748883911e-23,  -3.703605578548211e-02,   1.625309896122002e-03,   5.593890591086415e-05,  -9.052747695592661e-06,   2.211820877778865e-07,
   2.254743426687943e-08,  -1.716626229913159e-09,  -5.354548998279993e-12,   5.772858105753547e-12,  -2.055094408281622e-13,  -1.011645192660381e-14,   1.002735505963914e-15,
  -6.500703671214109e-18,  -2.739301019459232e-18,  -3.523289106234411e-02,   1.545459741251812e-03,   5.325564482990614e-05,  -8.605729167171883e-06,   2.096762700421866e-07,
   2.144639755681142e-08,  -1.628401407091107e-09,  -5.303257326447630e-12,   5.478457643601350e-12,  -1.939328018206436e-13,  -9.633909001988410e-15,   9.477732763414400e-16,
  -5.889475733296818e-18,  -2.594110980608977e-18,  -3.180376522130207e-02,   1.393899485401527e-03,   4.813630672498250e-05,  -7.758170663078958e-06,   1.880975864968558e-07,
   1.935368372062022e-08,  -1.462525094435354e-09,  -5.118392077653599e-12,   4.923990982806157e-12,  -1.725689941701290e-13,  -8.711417506986029e-15,   8.457833284997237e-16,
  -4.852539558643781e-18,  -2.322729698742834e-18,  -2.708533167350289e-02,   1.185921638600645e-03,   4.106031922629210e-05,  -6.596880731265757e-06,   1.589888753237350e-07,
   1.647655098033334e-08,  -1.237956712932146e-09,  -4.696937799874951e-12,   4.171543748990044e-12,  -1.444230440991722e-13,  -7.433486192872638e-15,   7.103209588354340e-16,
  -3.663286196279628e-18,  -1.958559567156500e-18,  -2.154019546365833e-02,   9.422214394031224e-04,   3.270451451944788e-05,  -5.238376059623151e-06,   1.255143429724001e-07,
   1.309864455641348e-08,  -9.786724299783278e-10,  -3.993533422811877e-12,   3.300569141496236e-12,  -1.129081216682224e-13,  -5.921930839765013e-15,   5.572381211298335e-16,
  -2.557754497322738e-18,  -1.542399608230684e-18,  -1.571129521971004e-02,   6.867176273272632e-04,   2.388399897744894e-05,  -3.816179225638901e-06,   9.100764193183431e-08,
   9.551213304922114e-09,  -7.104162848288295e-10,  -3.063173466146454e-12,   2.397452693031554e-12,  -8.121869270223999e-14,  -4.325001484922040e-15,   4.019694313338759e-16,
  -1.660202778990373e-18,  -1.116053925967277e-18,  -1.016880506587246e-02,   4.442355943194212e-04,   1.547100419930347e-05,  -2.467947975667485e-06,   5.867160781558735e-08,
   6.180563262296565e-09,  -4.583415455761867e-10,  -2.046418955068065e-12,   1.547436873326388e-12,  -5.208398110513613e-14,  -2.801505603540299e-15,   2.582592449533899e-16,
  -9.877862977652014e-19,  -7.184969119962380e-19,  -5.454651378478618e-03,   2.382297660141564e-04,   8.302267680382594e-06,  -1.323283456045995e-06,   3.140846090430344e-08,
   3.314965256576660e-09,  -2.454572920967230e-10,  -1.115234556165360e-12,   8.288859908110971e-13,  -2.780574048305206e-14,  -1.503349115331944e-15,   1.380088518946770e-16,
  -5.061449231004470e-19,  -3.843478606863906e-19,  -2.029803481265496e-03,   8.864274536756277e-05,   3.089916284393692e-06,  -4.923536291940894e-07,   1.167959252524778e-08,
   1.233530219383025e-09,  -9.128839070404131e-11,  -4.172690603378788e-13,   3.082956670252781e-13,  -1.033001329249087e-14,  -5.595067528460169e-16,   5.128852379634655e-17,
  -1.852876960286586e-19,  -1.428872703222990e-19,  -2.292817130474780e-04,   1.001272536173058e-05,   3.490375328266827e-07,  -5.561380536887882e-08,   1.319151132252797e-09,
   1.393357773395735e-10,  -1.031078458285930e-11,  -4.717426993745544e-14,   3.482160752960843e-14,  -1.166546087325313e-15,  -6.320187841624597e-17,   5.792213217696946e-18,
  -2.087484739977660e-20,  -1.613773549484998e-20,  -1.074328929940184e-03,   7.076175020133784e-05,  -2.700089745399336e-06,   5.280147460954543e-08,  -3.257038113083046e-10,
   7.092705852338648e-11,  -7.723674777514191e-12,   2.167718672429721e-13,   1.115174262649637e-14,  -9.357202881718676e-16,   1.617240644495747e-18,   2.436673192425056e-18,
  -8.828311167627906e-20,  -3.229717591769665e-21,  -1.022153586922999e-03,   6.732462597408343e-05,  -2.568822927999260e-06,   5.025468175134692e-08,  -3.132702647833052e-10,
   6.760790326757950e-11,  -7.338705918404413e-12,   2.052533410445759e-13,   1.061016114011304e-14,  -8.862952127480260e-16,   1.374903978364067e-18,   2.310562503517791e-18,
  -8.312380698920096e-20,  -3.080481022436730e-21,  -9.228775246961917e-04,   6.078489906078935e-05,  -2.319112433305337e-06,   4.540171212354940e-08,  -2.882290140201206e-10,
   6.124052061855653e-11,  -6.610226270102569e-12,   1.837456949014588e-13,   9.579376018797429e-15,  -7.938902230313551e-16,   9.827771573974195e-19,   2.073749147707741e-18,
  -7.367128254038343e-20,  -2.792921181990085e-21,  -7.861724135334249e-04,   5.177999596131411e-05,  -1.975363861363632e-06,   3.870528774820223e-08,  -2.510708056376577e-10,
   5.237273332211551e-11,  -5.614879021339651e-12,   1.549165494367632e-13,   8.159680078146124e-15,  -6.698047230801243e-16,   5.742308818755580e-19,   1.753765651571186e-18,
  -6.135178212838310e-20,  -2.390465337641250e-21,  -6.253857350733961e-04,   4.118935723171503e-05,  -1.571196646544881e-06,   3.081171525610088e-08,  -2.039896856279941e-10,
   4.181782512963132e-11,  -4.454043302735532e-12,   1.219964812717063e-13,   6.489978365626503e-15,  -5.278304108998938e-16,   2.565293701445598e-19,   1.385182607891949e-18,
  -4.772959997425840e-20,  -1.909671903908139e-21,  -4.562498466485656e-04,   3.004927689241575e-05,  -1.146166899519464e-06,   2.249184631335293e-08,  -1.513242550355859e-10,
   3.059947470310833e-11,  -3.242107043093506e-12,   8.827940251091013e-14,   4.734052446678702e-15,  -3.821593677562668e-16,   7.091455353513181e-20,   1.004727324876183e-18,
  -3.419559058640677e-20,  -1.397655836403059e-21,  -2.953396377098656e-04,   1.945132742788321e-05,  -7.418946294578902e-07,   1.456506578240961e-08,  -9.902474638011169e-11,
   1.984653217215791e-11,  -2.095542746181611e-12,   5.683694218903991e-14,   3.064087098876342e-15,  -2.461345732203686e-16,  -3.354276995616929e-21,   6.478824622206704e-19,
  -2.186984360428165e-20,  -9.065408870613569e-22,  -1.584346547255662e-04,   1.043459859749303e-05,  -3.979770674722927e-07,   7.814971541799450e-09,  -5.341614519566964e-11,
   1.065733539717017e-11,  -1.123287499411768e-12,   3.040544756839134e-14,   1.643618043540173e-15,  -1.316963342359361e-16,  -1.529379698603927e-20,   3.468673429024525e-19,
  -1.165918882076714e-20,  -4.867959883293529e-22,  -5.895872646149823e-05,   3.883050013142949e-06,  -1.480988106905720e-07,   2.908408676727759e-09,  -1.991601864145451e-11,
   3.967325728958987e-12,  -4.179001434634926e-13,   1.130390788255366e-14,   6.116295329261243e-16,  -4.896422053569994e-17,  -7.434683234989460e-21,   1.289914906222396e-19,
  -4.329346854553460e-21,  -1.812143765085094e-22,  -6.659862324786977e-06,   4.386216199430804e-07,  -1.672892492239409e-08,   3.285317664715810e-10,  -2.250357715229453e-12,
   4.481661114818474e-13,  -4.720317563440504e-14,   1.276670994185334e-15,   6.908821010407533e-17,  -5.530108613453172e-18,  -8.710327376518464e-22,   1.456902697710515e-20,
  -4.888658052211582e-22,  -2.047072113514755e-23,  -1.001531624383592e-02,   6.424138708561519e-04,  -2.191950872008737e-05,   1.675976807110712e-07,   1.699314566821232e-08,
  -5.335046461020468e-11,  -6.406857502280669e-11,   2.248798237403510e-12,   1.317843250594932e-13,  -1.253096797310478e-14,   1.325232342965424e-16,   2.891453417351365e-17,
  -1.434707123462108e-18,  -2.351396118606935e-20,  -9.528815248261763e-03,   6.111815733263715e-04,  -2.085037421706888e-05,   1.594339353181602e-07,   1.613844595986754e-08,
  -4.941298461588687e-11,  -6.084168436113639e-11,   2.126324872770935e-12,   1.255299223190106e-13,  -1.187474761003306e-14,   1.233966428138716e-16,   2.744955483658572e-17,
  -1.352760635373880e-18,  -2.267585528914597e-20,  -8.603172163594287e-03,   5.517681463993061e-04,  -1.881797042291608e-05,   1.439108685828046e-07,   1.452421983967816e-08,
  -4.248024067354506e-11,  -5.474855318895844e-11,   1.898756354002071e-12,   1.135652581675626e-13,  -1.064566517745822e-14,   1.071588343511902e-16,   2.468588924175060e-17,
  -1.201941701416878e-18,  -2.094809350850654e-20,  -7.328623538162528e-03,   4.699808172644908e-04,  -1.602294768052436e-05,   1.225549539544319e-07,   1.232467651827197e-08,
  -3.400673973362990e-11,  -4.644906634880170e-11,   1.595917647491453e-12,   9.697008545557311e-14,  -8.990922651741525e-15,   8.695279716088848e-17,   2.092733255330226e-17,
  -1.004046303869497e-18,  -1.832034315155219e-20,  -5.829656039247208e-03,   3.738191559104951e-04,  -1.274015469929611e-05,   9.746111910668667e-08,   9.767018773103590e-09,
  -2.538147447069894e-11,  -3.680280149823812e-11,   1.252948736961633e-12,   7.730753085660647e-14,  -7.092216406117142e-15,   6.586344753539181e-17,   1.656761445061229e-17,
  -7.835064815273754e-19,  -1.492931374851973e-20,  -4.252946395239063e-03,   2.726949187208744e-04,  -9.291166222611970e-06,   7.108594193514766e-08,   7.103807380226118e-09,
  -1.754266337650384e-11,  -2.676324702632457e-11,   9.043931814180154e-13,   5.649633620001335e-14,  -5.139019764707524e-15,   4.612847247012570e-17,   1.203952620287644e-17,
  -5.627486081369109e-19,  -1.109500554712093e-20,  -2.752984514624000e-03,   1.765103218593722e-04,  -6.012901732297910e-06,   4.600828275828000e-08,   4.589163403703202e-09,
  -1.094123250201508e-11,  -1.728748344355120e-11,   5.812994778367748e-13,   3.661160565091359e-14,  -3.311606974312744e-15,   2.904424281416344e-17,   7.772999307897906e-18,
  -3.605121002733414e-19,  -7.267176157185013e-21,  -1.476826811489110e-03,   9.468588168047626e-05,  -3.225214385726320e-06,   2.467916795638631e-08,   2.459300135888979e-09,
  -5.755606039523231e-12,  -9.263683786401208e-12,   3.107015308965416e-13,   1.965123233053707e-14,  -1.772385815013248e-15,   1.535713528139063e-17,   4.164163362431446e-18,
  -1.923625213971916e-19,  -3.921630607898551e-21,  -5.495744829772608e-04,   3.523534292441181e-05,  -1.200156061335890e-06,   9.183678167102165e-09,   9.148557740518262e-10,
  -2.127131283249374e-12,  -3.446002872490849e-12,   1.154752246709726e-13,   7.314279464208789e-15,  -6.590291946352862e-16,   5.685993047212093e-18,   1.548887664082560e-18,
  -7.145071283335825e-20,  -1.462349539124621e-21,  -6.207883688115099e-05,   3.980108617075897e-06,  -1.355663492117165e-07,   1.037365852120086e-09,   1.033343959584591e-10,
  -2.400128820251761e-13,  -3.892301231389791e-13,   1.304122121255499e-14,   8.262319503721427e-16,  -7.443308392146922e-17,   6.417609539264265e-19,   1.749461536224558e-19,
  -8.068537562955226e-21,  -1.652375040136118e-22,  -3.021490106273313e-02,   1.719105668247566e-03,  -2.328322327696804e-05,  -3.920089536693124e-06,   3.227194281586878e-07,
  -7.375898516322700e-09,  -5.352982228121532e-10,   5.081896948904514e-11,  -1.239498044431061e-12,  -7.290829622599063e-14,   7.065358616175861e-15,  -1.699140320204952e-16,
  -9.620939370610860e-18,   9.147877833819913e-19,  -2.874584644622872e-02,   1.635134128253230e-03,  -2.209374615635272e-05,  -3.731511520963345e-06,   3.067798032310450e-07,
  -6.985781656371208e-09,  -5.102398710277793e-10,   4.826733558804370e-11,  -1.169915710202513e-12,  -6.962013900189470e-14,   6.702260807371833e-15,  -1.595829009004780e-16,
  -9.204383223788638e-18,   8.662894523511712e-19,  -2.595128907377795e-02,   1.475554278606248e-03,  -1.985444403585369e-05,  -3.371949953235050e-06,   2.765587980797016e-07,
  -6.256547948229230e-09,  -4.621676420716260e-10,   4.344590200187324e-11,  -1.041375959054221e-12,  -6.325615627580970e-14,   6.019376157767017e-15,  -1.407849681310172e-16,
  -8.389719256139511e-18,   7.756329108051947e-19,  -2.210442940702249e-02,   1.256189952271550e-03,  -1.681726701821678e-05,  -2.875391555877676e-06,   2.351536694392384e-07,
  -5.277618044710159e-09,  -3.952204575084101e-10,   3.687229835080834e-11,  -8.718148634851655e-13,  -5.428906100125075e-14,   5.094660504427794e-15,  -1.165530155942744e-16,
  -7.226555930929591e-18,   6.539778299675210e-19,  -1.758156862888263e-02,   9.986646321810053e-04,  -1.330367210786176e-05,  -2.289564525126210e-06,   1.867210743497185e-07,
  -4.158072882721502e-09,  -3.155461238462487e-10,   2.922427382026084e-11,  -6.817438624596854e-13,  -4.349150573161766e-14,   4.027025692188667e-15,  -9.012438163306155e-17,
  -5.808330234626543e-18,   5.149686902301052e-19,  -1.282538943627177e-02,   7.282158808477581e-04,  -9.662156603100447e-06,  -1.671660610551401e-06,   1.360225202469624e-07,
  -3.009959919618182e-09,  -2.308787603274335e-10,   2.125748575759042e-11,  -4.904746461666741e-13,  -3.190584452968629e-14,   2.922745792426023e-15,  -6.423605881878868e-17,
  -4.271673878434043e-18,   3.725855949798190e-19,  -8.301602080922940e-03,   4.712349411449448e-04,  -6.235903605006861e-06,  -1.082656950075430e-06,   8.796456109778011e-08,
  -1.938346063872282e-09,  -1.497378083826245e-10,   1.373335426417867e-11,  -3.145544943495006e-13,  -2.072791702637391e-14,   1.885440333323070e-15,  -4.093645046224770e-17,
  -2.779489123382562e-18,   2.398461784604553e-19,  -4.453240477761738e-03,   2.527511580273767e-04,  -3.340121924805766e-06,  -5.809434292491404e-07,   4.716492205530329e-08,
  -1.037054785908368e-09,  -8.040495793894546e-11,   7.359784146724306e-12,  -1.679339718356564e-13,  -1.113987593056555e-14,   1.009644960409425e-15,  -2.178314045461302e-17,
  -1.494960471021028e-18,   1.282962568014167e-19,  -1.657177826586870e-03,   9.405150139161892e-05,  -1.242305505668138e-06,  -2.162079008940013e-07,   1.754855795495861e-08,
  -3.855635720545997e-10,  -2.993143474497403e-11,   2.737849956230334e-12,  -6.238909657069365e-14,  -4.148146771331280e-15,   3.754889130795019e-16,  -8.083299348223909e-18,
  -5.568269687416537e-19,   4.769539250719943e-20,  -1.871912248889616e-04,   1.062377513977500e-05,  -1.403165091436079e-07,  -2.442277628332205e-08,   1.982195988509590e-09,
  -4.354608121282942e-11,  -3.381177476631868e-12,   3.092448368990611e-13,  -7.045475038326506e-15,  -4.686137029293310e-16,   4.241031380934262e-17,  -9.126629638812012e-19,
  -6.290708918660117e-20,   5.386720192708717e-21,  -8.305213156193709e-04,   5.166119427090124e-05,  -2.076968689839443e-06,   5.129287490368033e-08,  -1.789470024100171e-10,
  -2.828363475369162e-11,  -8.211653885376417e-13,   1.754148788831550e-13,  -7.748465098823779e-15,  -2.672183720171177e-17,   1.886291545864635e-17,  -8.052564243065096e-19,
  -5.412899609665694e-21,   2.029113571795140e-21,  -7.901862814248089e-04,   4.915293598764095e-05,  -1.975977123063761e-06,   4.878990027669044e-08,  -1.706332622198301e-10,
  -2.679857395093369e-11,  -7.875299433242955e-13,   1.668453493166756e-13,  -7.346450640260368e-15,  -2.669411948891438e-17,   1.793251748692427e-17,  -7.614224580746251e-19,
  -5.356402292692456e-21,   1.927636202999002e-21,  -7.134393718081138e-04,   4.438009121045641e-05,  -1.783866490000757e-06,   4.403228560976495e-08,  -1.546647804484430e-10,
  -2.401829739639158e-11,  -7.209594031873877e-13,   1.505584452653955e-13,  -6.592012800125711e-15,  -2.611384034141331e-17,   1.616749127205464e-17,  -6.799516535587481e-19,
  -5.162184742646806e-21,   1.735623611747295e-21,  -6.077576142731860e-04,   3.780724005473575e-05,  -1.519423080387432e-06,   3.749039546095901e-08,  -1.323821168621658e-10,
  -2.027777694203754e-11,  -6.243353897671182e-13,   1.281690769003645e-13,  -5.573445911740946e-15,  -2.430261821715136e-17,   1.374778867746843e-17,  -5.715036195164584e-19,
  -4.729321128007175e-21,   1.473417958317754e-21,  -4.834596061068869e-04,   3.007584190104076e-05,  -1.208518379820131e-06,   2.980798206050706e-08,  -1.057967298194746e-10,
  -1.598959901445340e-11,  -5.044643319004213e-13,   1.018865686497357e-13,  -4.401108984351070e-15,  -2.090754291583607e-17,   1.091629780245321e-17,  -4.486677268450495e-19,
  -4.014980878483130e-21,   1.167989464288655e-21,  -3.527074582434697e-04,   2.194232917105544e-05,  -8.815830763444001e-07,   2.173764875006490e-08,  -7.747376636160071e-11,
  -1.158238573602970e-11,  -3.726062443938784e-13,   7.428926225342132e-14,  -3.191770124606358e-15,  -1.617198121237134e-17,   7.951999306558538e-18,  -3.238343817527786e-19,
  -3.076014681630579e-21,   8.496305920620265e-22,  -2.283144733738989e-04,   1.420392744991386e-05,  -5.706274803130016e-07,   1.406748148048543e-08,  -5.027501269574605e-11,
  -7.462101222667635e-12,  -2.431459575552109e-13,   4.807058525153823e-14,  -2.057952819536570e-15,  -1.085930559333563e-17,   5.142258481725525e-18,  -2.081337361479374e-19,
  -2.053444394741939e-21,   5.489010187379278e-22,  -1.224790421017271e-04,   7.619743186452796e-06,  -3.061018453292606e-07,   7.545459737781025e-09,  -2.700445453679323e-11,
  -3.993284719671610e-12,  -1.309717232004904e-13,   2.578230631172710e-14,  -1.101744471190558e-15,  -5.932780050251252e-18,   2.757101420728815e-18,  -1.112428670050219e-19,
  -1.118634302755525e-21,   2.941555904410770e-22,  -4.557846096619419e-05,   2.835563942314118e-06,  -1.139091412566969e-07,   2.807779924350524e-09,  -1.005371477542504e-11,
  -1.484769124428098e-12,  -4.880827472262348e-14,   9.593775440689204e-15,  -4.097048654679319e-16,  -2.221660474986135e-18,   1.025817906927778e-18,  -4.134400091897094e-20,
  -4.184855548421886e-22,   1.094256186197299e-22,  -5.148453657818751e-06,   3.202998923530413e-07,  -1.286692877782120e-08,   3.171589423448143e-10,  -1.135728145514432e-12,
  -1.676939760433013e-13,  -5.514530915697082e-15,   1.083682144530058e-15,  -4.627425543026268e-17,  -2.512030758325431e-19,   1.158709736948153e-19,  -4.669185462393658e-21,
  -4.731080587088521e-23,   1.235979775676440e-23,  -7.777749022164369e-03,   4.792253723348626e-04,  -1.851396659525471e-05,   3.727485200883365e-07,   6.610521131611031e-09,
  -6.997044779287290e-10,   5.981539946791854e-12,   1.591267354329006e-12,  -8.976872595946435e-14,   2.858000126274925e-16,   2.086948900853707e-16,  -1.105687880956946e-17,
   6.171856491399970e-20,   2.196428473993287e-20,  -7.399985417166153e-03,   4.559485430608029e-04,  -1.761225612948539e-05,   3.544129472369146e-07,   6.291371162222638e-09,
  -6.646763470923078e-10,   5.617472345218931e-12,   1.514053126583442e-12,  -8.512249440747787e-14,   2.543103762995529e-16,   1.986304877591222e-16,  -1.046788344674950e-17,
   5.559432285217745e-20,   2.091632022461630e-20,  -6.681213285769169e-03,   4.116600059586893e-04,  -1.589758204567030e-05,   3.196203316743904e-07,   5.683296854139224e-09,
  -5.984529196642821e-10,   4.955019265905900e-12,   1.367081862777043e-12,  -7.639845916253045e-14,   2.016786660066183e-16,   1.794433387367972e-16,  -9.368301511590078e-18,
   4.524427788728409e-20,   1.891263421416302e-20,  -5.691475877865261e-03,   3.506761517238041e-04,  -1.353846904919365e-05,   2.718943227500336e-07,   4.844430109161133e-09,
  -5.080876905054646e-10,   4.101167718253258e-12,   1.164622613217411e-12,  -6.461129276559217e-14,   1.432097367556252e-16,   1.529583484595726e-16,  -7.895151374255381e-18,
   3.348791250978534e-20,   1.613678645475929e-20,  -4.527422410816224e-03,   2.789525655105548e-04,  -1.076634778345489e-05,   2.159933895126895e-07,   3.855914292399292e-09,
  -4.028489660248323e-10,   3.170258977165071e-12,   9.264402481420384e-13,  -5.103388941873142e-14,   9.198727171166190e-17,   1.217395679638640e-16,  -6.214445056976375e-18,
   2.277340613056561e-20,   1.285388600890065e-20,  -3.302953851771622e-03,   2.035074060560531e-04,  -7.852670176072537e-06,   1.574056493693794e-07,   2.814379713343532e-09,
  -2.931194591951012e-10,   2.258926730960238e-12,   6.758705242925792e-13,  -3.701828746130501e-14,   5.429615821207302e-17,   8.884747703317352e-17,  -4.494941249872773e-18,
   1.436209097213395e-20,   9.386483711947695e-21,  -2.138057338527861e-03,   1.317334207040890e-04,  -5.082371868720305e-06,   1.018182541054358e-07,   1.822351063397001e-09,
  -1.894090237596370e-10,   1.439248707154693e-12,   4.374936579738446e-13,  -2.387137406627897e-14,   2.969090753953675e-17,   5.752498777392072e-17,  -2.893063870585543e-18,
   8.339730750239680e-21,   6.079481855466511e-21,  -1.146955793979119e-03,   7.066798952577120e-05,  -2.726207889125651e-06,   5.460005038631268e-08,   9.777475932693345e-10,
  -1.015165390781719e-10,   7.657589075049420e-13,   2.346892164855739e-13,  -1.278062225730710e-14,   1.442862561606671e-17,   3.086232501599409e-17,  -1.547407189651561e-18,
   4.211189723840731e-21,   3.262209204152147e-21,  -4.268194527059841e-04,   2.629783908687015e-05,  -1.014482085873299e-06,   2.031584583926589e-08,   3.638711521329295e-10,
  -3.776574829212246e-11,   2.841454759136888e-13,   8.733500310259549e-14,  -4.752830494689099e-15,   5.175444842124810e-18,   1.148526831205282e-17,  -5.752484428511741e-19,
   1.533163308131119e-21,   1.214084663653473e-21,  -4.821268302230291e-05,   2.970551788409977e-06,  -1.145933870985871e-07,   2.294791182396465e-09,   4.110251735056450e-11,
  -4.265732012472519e-12,   3.208184879547317e-14,   9.865180961190085e-15,  -5.368120326324133e-16,   5.811334272498893e-19,   1.297360257074536e-18,  -6.496831780061754e-20,
   1.725747543342169e-22,   1.371425729045189e-22,  -2.390303663425837e-02,   1.418724724488421e-03,  -4.538017445187656e-05,  -2.468917716089163e-07,   1.342519053972514e-07,
  -8.535870628952577e-09,   2.255348660256775e-10,   6.255927713362940e-12,  -9.047897119830580e-13,   3.981745933397488e-14,  -3.412716627911378e-16,  -6.610609308321290e-17,
   4.505846783706971e-18,  -1.177537314984915e-19,  -2.274169856655574e-02,   1.349690608373830e-03,  -4.314868102778927e-05,  -2.374079280515218e-07,   1.278195316828160e-07,
  -8.116580566399394e-09,   2.138094536783738e-10,   5.993489825148573e-12,  -8.611657410584350e-13,   3.777020838871201e-14,  -3.159244246617030e-16,  -6.314691046302218e-17,
   4.278487904325859e-18,  -1.107901718004508e-19,  -2.053216738840767e-02,   1.218390530966648e-03,  -3.891393564144023e-05,  -2.183405127423117e-07,   1.155442581168277e-07,
  -7.320675146933534e-09,   1.918130034457440e-10,   5.477125994809166e-12,  -7.780152743187745e-13,   3.392046414485410e-14,  -2.712901381838421e-16,  -5.741007707750453e-17,
   3.849148631951053e-18,  -9.804617972873999e-20,  -1.748997248708890e-02,   1.037692363391756e-03,  -3.310434739909305e-05,  -1.901048293806835e-07,   9.857136299607733e-08,
  -6.228404247371989e-09,   1.621323785931810e-10,   4.733269254437895e-12,  -6.632494121340527e-13,   2.870831113511871e-14,  -2.167731126754831e-16,  -4.930824977131086e-17,
   3.264474181376821e-18,  -8.147894118727370e-20,  -1.391234778232032e-02,   8.252958346879366e-04,  -2.629890361133058e-05,  -1.543932157199287e-07,   7.852121573406430e-08,
  -4.948466481035944e-09,   1.279943853664587e-10,   3.817108636151015e-12,  -5.279545432891642e-13,   2.269149033862990e-14,  -1.614049947312144e-16,  -3.952953945903403e-17,
   2.585386226386240e-18,  -6.323650159554366e-20,  -1.014939038951416e-02,   6.019944258875642e-04,  -1.916577458504273e-05,  -1.144978707586567e-07,   5.734915488499705e-08,
  -3.606536012419714e-09,   9.280284067090677e-11,   2.815145042429201e-12,  -3.853655155313725e-13,   1.646876628999321e-14,  -1.112854927484453e-16,  -2.901586395092503e-17,
   1.879315838544246e-18,  -4.520639928199870e-20,  -6.569750675171455e-03,   3.896403014160803e-04,  -1.239758427602452e-05,  -7.491197591718122e-08,   3.715054625184243e-08,
  -2.333029662303535e-09,   5.982699706405729e-11,   1.835255719270549e-12,  -2.495356334775691e-13,   1.062376177215500e-14,  -6.927653746604329e-17,  -1.885748838057469e-17,
   1.213548398508369e-18,  -2.886617365018040e-20,  -3.524294188547333e-03,   2.090103758713191e-04,  -6.648245757674543e-06,  -4.040544207747108e-08,   1.993687595914052e-08,
  -1.251122445609021e-09,   3.202632235386438e-11,   9.880843366239122e-13,  -1.338848774355519e-13,   5.688951945352529e-15,  -3.640368720084268e-17,  -1.013659099679065e-17,
   6.501819899765396e-19,  -1.537590947760868e-20,  -1.311499903457904e-03,   7.777808370642559e-05,  -2.473715838945120e-06,  -1.506454782077272e-08,   7.420135575646353e-09,
  -4.655280260668280e-10,   1.190926069790772e-11,   3.681597229886772e-13,  -4.982573345167648e-14,   2.115729204045402e-15,  -1.344866820539776e-17,  -3.774806198476842e-18,
   2.418467990232465e-19,  -5.707720344867165e-21,  -1.481443641225898e-04,   8.785632725995964e-06,  -2.794204656203073e-07,  -1.702170132719188e-09,   8.381813845911251e-10,
  -5.258413697241378e-11,   1.345089335529250e-12,   4.159486600004825e-14,  -5.628267037763392e-15,   2.389650307890924e-16,  -1.517372858339700e-18,  -4.264421505404236e-19,
   2.731661693200954e-20,  -6.444791129728069e-22,  -6.533361732960098e-04,   3.741520513700030e-05,  -1.497366227931352e-06,   4.402595559005815e-08,  -6.787978859514098e-10,
  -1.438967492776280e-11,   1.135925078034060e-12,  -5.707792818929068e-15,  -2.594967160156546e-15,   1.615256382644079e-16,  -3.669709983252775e-18,  -1.133653683045070e-19,
   1.270825194737798e-20,  -4.458707394587108e-22,  -6.216023798342930e-04,   3.559923564322611e-05,  -1.424653705734245e-06,   4.188023219337668e-08,  -6.452827543632785e-10,
  -1.369251249472813e-11,   1.078486391566973e-12,  -5.258639204199654e-15,  -2.473453371414477e-15,   1.534741016640393e-16,  -3.466316453191931e-18,  -1.088499488852028e-19,
   1.208719494605700e-20,  -4.216015702751108e-22,  -5.612229570366576e-04,   3.214346324455848e-05,  -1.286297430373499e-06,   3.780056514612191e-08,  -5.817370365872973e-10,
  -1.236516275808869e-11,   9.701151041510010e-13,  -4.474312424717442e-15,  -2.240361367637737e-15,   1.382361527088184e-16,  -3.089569655127110e-18,  -9.984680801603051e-20,
   1.090653461880568e-20,  -3.764791941622398e-22,  -4.780825939993465e-04,   2.738391208180631e-05,  -1.095771776796116e-06,   3.218876245675180e-08,  -4.946677731045780e-10,
  -1.053590927007158e-11,   8.226732618019323e-13,  -3.530241681556220e-15,  -1.915784646671579e-15,   1.174143782136712e-16,  -2.590655090900968e-18,  -8.665994537958182e-20,
   9.283296332834804e-21,  -3.163998844160594e-22,  -3.803006460145177e-04,   2.178481510140659e-05,  -8.716758924688993e-07,   2.559596931819993e-08,  -3.928083109085316e-10,
  -8.382787795070601e-12,   6.515283697159210e-13,  -2.591453459439714e-15,  -1.529540540294630e-15,   9.313201555654606e-17,  -2.028982734117691e-18,  -7.016399339903008e-20,
   7.378143698583435e-21,  -2.483512735601002e-22,  -2.774450381401143e-04,   1.589393196985835e-05,  -6.359362336450418e-07,   1.866788504091482e-08,  -2.861680796767757e-10,
  -6.116543831045003e-12,   4.736190834992894e-13,  -1.763413243102132e-15,  -1.119118366917574e-15,   6.778500050607561e-17,  -1.461547055760193e-18,  -5.190404187456202e-20,
   5.378544139710212e-21,  -1.792174221940769e-22,  -1.795943864744815e-04,   1.028881488407243e-05,  -4.116565631832704e-07,   1.208168212353047e-08,  -1.850693817003102e-10,
  -3.959710051193501e-12,   3.058537338020761e-13,  -1.087166020025525e-15,  -7.258052059589806e-16,   4.380997545550360e-17,  -9.380961382842705e-19,  -3.390299720935256e-20,
   3.479748807731890e-21,  -1.151681468584105e-22,  -9.634286424667324e-05,   5.519522350925379e-06,  -2.208333936446994e-07,   6.480541735160004e-09,  -9.923269627936712e-11,
  -2.124273781060195e-12,   1.638738543451010e-13,  -5.682547553718200e-16,  -3.897353978845289e-16,   2.348284674535292e-17,  -5.010396649447597e-19,  -1.827081747719539e-20,
   1.866169898617113e-21,  -6.154939649998255e-23,  -3.585228930643930e-05,   2.054007796634520e-06,  -8.217942448157632e-08,   2.411535847681878e-09,  -3.692157695291776e-11,
  -7.905234108787578e-13,   6.095677802612591e-14,  -2.095299836319541e-16,  -1.450821677343932e-16,   8.736275414229099e-18,  -1.861682315347556e-19,  -6.809979278696216e-21,
   6.943922849833508e-22,  -2.287442655548150e-23,  -4.049803567658524e-06,   2.320169269483200e-07,  -9.282828396860210e-09,   2.724008256249293e-10,  -4.170478638872531e-12,
  -8.929618211255888e-14,   6.885091278311604e-15,  -2.363339394091920e-17,  -1.638907288764986e-17,   9.867884278255223e-19,  -2.102408984320664e-20,  -7.694355929693739e-22,
   7.843592076323400e-23,  -2.583310461372357e-24,  -6.127476616307310e-03,   3.498439266174304e-04,  -1.381449781671506e-05,   3.841895956250169e-07,  -3.835141988227148e-09,
  -2.999657841157953e-10,   1.855651184238577e-11,  -3.045174757726453e-13,  -2.188872325756224e-14,   1.772818480012903e-15,  -5.119142183209713e-17,  -7.173393035616906e-19,
   1.366301706511558e-19,  -5.986489363378442e-21,  -5.829845818455923e-03,   3.328614959173331e-04,  -1.314322012807702e-05,   3.654127510451513e-07,  -3.640395532686015e-09,
  -2.855565759523464e-10,   1.763531840913414e-11,  -2.878173615077019e-13,  -2.089032918895629e-14,   1.685285652102389e-15,  -4.843168828984453e-17,  -6.960074798200080e-19,
   1.301407704063583e-19,  -5.671801671724060e-21,  -5.263551095830352e-03,   3.005451248684506e-04,  -1.186610218260025e-05,   3.297334719725018e-07,  -3.273311910830773e-09,
  -2.580733439177541e-10,   1.589058885872525e-11,  -2.568214009342612e-13,  -1.896382839271548e-14,   1.519287279853194e-15,  -4.329162274879063e-17,  -6.498432890046293e-19,
   1.177269773452122e-19,  -5.082563745105035e-21,  -4.483788863320419e-03,   2.560385772869251e-04,  -1.010777489820733e-05,   2.806958082434257e-07,  -2.774541161925274e-09,
  -2.201015405879533e-10,   1.350376048278576e-11,  -2.156492328372886e-13,  -1.625951146079395e-14,   1.291807522089975e-15,  -3.642916936401063e-17,  -5.755430532726199e-19,
   1.005112741384210e-19,  -4.289862835080471e-21,  -3.566712660534598e-03,   2.036839832256500e-04,  -8.040075336214166e-06,   2.231381233160144e-07,  -2.196382038188443e-09,
  -1.752827004767415e-10,   1.071645313273492e-11,  -1.691316996931816e-13,  -1.301442217855570e-14,   1.025697586603502e-15,  -2.863113383821773e-17,  -4.746926273953315e-19,
   8.011905637406996e-20,  -3.381504150426306e-21,  -2.602058671575886e-03,   1.486034092669424e-04,  -5.865352982771219e-06,   1.627019853507873e-07,  -1.596081588412035e-09,
  -1.279915121290971e-10,   7.803130059997979e-12,  -1.219733756233627e-13,  -9.541513751758562e-15,   7.471550049911583e-16,  -2.068337485719907e-17,  -3.561673026140989e-19,
   5.854308280202955e-20,  -2.448625397746136e-21,  -1.684349686609498e-03,   9.619645912964554e-05,  -3.796640011510053e-06,   1.052824609128522e-07,  -1.030488904771978e-09,
  -8.289993301569129e-11,   5.044669907644120e-12,  -7.835044698619470e-14,  -6.196345885153335e-15,   4.831539192405465e-16,  -1.330125904180509e-17,  -2.347530638694667e-19,
   3.793423555756250e-20,  -1.577155268706615e-21,  -9.035636203210970e-04,   5.160518422296242e-05,  -2.036670601421637e-06,   5.646826130635729e-08,  -5.520651045899352e-10,
  -4.448488414279505e-11,   2.704428466268012e-12,  -4.186434297540535e-14,  -3.329497605435093e-15,   2.590502496666309e-16,  -7.111332852823320e-18,  -1.270870174187959e-19,
   2.036006569161839e-20,  -8.438834407649424e-22,  -3.362451001664970e-04,   1.920406927106600e-05,  -7.579075684315924e-07,   2.101234191656424e-08,  -2.053457423572921e-10,
  -1.655600208154417e-11,   1.006175805830067e-12,  -1.555751077273788e-14,  -1.239723138649535e-15,   9.638325912479985e-17,  -2.643236114057914e-18,  -4.744254543717283e-20,
   7.577966344860289e-21,  -3.137539355145085e-22,  -3.798157878737259e-05,   2.169255671415797e-06,  -8.561167820420557e-08,   2.373488839110572e-09,  -2.319373651905137e-11,
  -1.870164381573345e-12,   1.136515144177668e-13,  -1.756959118762918e-15,  -1.400493838212524e-16,   1.088694441500623e-17,  -2.985187798069439e-19,  -5.361692395455646e-21,
   8.560158122405390e-22,  -3.543596010893688e-23,  -1.893599129458674e-02,   1.069395890880333e-03,  -4.008093192256501e-05,   8.455022780284385e-07,   1.993496668245153e-08,
  -3.146460269266401e-09,   1.738593796997429e-10,  -5.196652417606825e-12,  -2.383119734535892e-15,   9.765439069468819e-15,  -5.864270402283746e-16,   1.779198320994735e-17,
  -3.963541500814614e-20,  -2.773296492205304e-20,  -1.801612453666592e-02,   1.017453715271578e-03,  -3.812763657405897e-05,   8.034315064274459e-07,   1.904282928496074e-08,
  -2.996609530609268e-09,   1.653963239399234e-10,  -4.933238938744405e-12,  -3.051887644605369e-15,   9.318896242449096e-15,  -5.579300481831008e-16,   1.686017361126915e-17,
  -3.315803440264459e-20,  -2.653900575432700e-20,  -1.626595172029074e-02,   9.186237952092059e-04,  -3.441375123176597e-05,   7.237910438315700e-07,   1.731437473208751e-08,
  -2.710268890376508e-09,   1.493003612972371e-10,  -4.436482331216626e-12,  -4.005020685418628e-15,   8.457804009940364e-15,  -5.037021719992063e-16,   1.511426649443286e-17,
  -2.268618400254873e-20,  -2.420359331003940e-20,  -1.385611058799651e-02,   7.825379689195106e-04,  -2.930496002866512e-05,   6.149190470982052e-07,   1.487427421522292e-08,
  -2.313628617431494e-09,   1.271504061684775e-10,  -3.761106096958104e-12,  -4.698482679813546e-15,   7.250042793232035e-15,  -4.290307458687154e-16,   1.276309647354446e-17,
  -1.185829755092795e-20,  -2.086570784334201e-20,  -1.102198918076415e-02,   6.224861014964100e-04,  -2.330295829588628e-05,   4.878757633484709e-07,   1.192844232709160e-08,
  -1.844166193955416e-09,   1.011183072054621e-10,  -2.977787899941594e-12,  -4.730844346565314e-15,   5.801895063092462e-15,  -3.412259895007068e-16,   1.006552617586229e-17,
  -3.668565364923979e-21,  -1.678756991852683e-20,  -8.040914529868666e-03,   4.541293485158388e-04,  -1.699559640768862e-05,   3.551760213415350e-07,   8.758923561342964e-09,
  -1.347588484360324e-09,   7.375407360527178e-11,  -2.164131450507977e-12,  -4.034952678518818e-15,   4.253011523670412e-15,  -2.488980999579237e-16,   7.291713319808500e-18,
   7.102149177280856e-22,  -1.235768674850068e-20,  -5.204970915118613e-03,   2.939648031770756e-04,  -1.099941907826450e-05,   2.295900454610011e-07,   5.694001240674199e-09,
  -8.732504420471496e-10,   4.773514584548224e-11,  -1.397322600226280e-12,  -2.861452460609536e-15,   2.761684394850340e-15,  -1.610957755063333e-16,   4.697915331638083e-18,
   1.907876765950070e-21,  -8.046273746361025e-21,  -2.792181171929344e-03,   1.576965177188615e-04,  -5.900029062350384e-06,   1.230744776516709e-07,   3.061200208476151e-09,
  -4.687100531720909e-10,   2.560541975739829e-11,  -7.486095290666376e-13,  -1.603760242390931e-15,   1.483873484589596e-15,  -8.641348969326242e-17,   2.514073075569339e-18,
   1.422352174983380e-21,  -4.329286293709969e-21,  -1.039059476550490e-03,   5.868396245465748e-05,  -2.195516605782237e-06,   4.578853277353833e-08,   1.140035326407092e-09,
  -1.744554706661995e-10,   9.528348187257866e-12,  -2.784547674019283e-13,  -6.057141510148524e-16,   5.525046743264280e-16,  -3.215646637646217e-17,   9.347755321118564e-19,
   5.809628745363912e-22,  -1.612733463765242e-21,  -1.173700773030972e-04,   6.628824102381177e-06,  -2.479998679102484e-07,   5.171976645683576e-09,   1.287916172201019e-10,
  -1.970674168848652e-11,   1.076298754008615e-12,  -3.145142197846421e-14,  -6.857985585108817e-17,   6.241534276220361e-17,  -3.632316580656898e-18,   1.055761871633872e-19,
   6.655038522709658e-23,  -1.822010296246332e-22,  -5.245655160619622e-04,   2.735189003173221e-05,  -1.039344878111170e-06,   3.217893250380917e-08,  -7.366228926297339e-10,
   5.841990025627694e-12,   4.684817157879990e-13,  -2.616599943132311e-14,   4.607542537155345e-16,   2.210978416358841e-17,  -2.044229715114544e-18,   7.757142764737843e-20,
  -1.031793719563783e-21,  -6.232650818333205e-23,  -4.990815690536390e-04,   2.602435836177300e-05,  -9.889216844331886e-07,   3.061542553784396e-08,  -7.005829902983185e-10,
   5.541613626784319e-12,   4.460623954871451e-13,  -2.486875251848585e-14,   4.355930704882184e-16,   2.115973249190396e-17,  -1.946674886638445e-18,   7.364701837527018e-20,
  -9.684111944733644e-22,  -5.979598326482907e-23,  -4.505955891738131e-04,   2.349807543649673e-05,  -8.929578208640488e-07,   2.764076627290445e-08,  -6.321162875410684e-10,
   4.976878174211780e-12,   4.032656390516052e-13,  -2.241102506686468e-14,   3.888480402484345e-16,   1.930131645169283e-17,  -1.760315558794871e-18,   6.624225645523065e-20,
  -8.531984812283328e-22,  -5.477602597024478e-23,  -3.838358648741261e-04,   2.001868112613876e-05,  -7.607716976161111e-07,   2.354516326630018e-08,  -5.380454962622816e-10,
   4.212390135125472e-12,   3.440680581296144e-13,  -1.904740355988896e-14,   3.266730560791794e-16,   1.664428133502014e-17,  -1.502300051119978e-18,   5.616820297576541e-20,
  -7.050069848079513e-22,  -4.746891505356740e-23,  -3.053240811642567e-04,   1.592554123874855e-05,  -6.052470305670879e-07,   1.872881223188981e-08,  -4.276685419854745e-10,
   3.329855957185191e-12,   2.741111642343703e-13,  -1.511775148813976e-14,   2.563264936418612e-16,   1.339577168043331e-17,  -1.197122653903922e-18,   4.447688166734830e-20,
  -5.439674800141398e-22,  -3.837986892346962e-23,  -2.227429740787978e-04,   1.161908611456330e-05,  -4.415970528691589e-07,   1.366304287914843e-08,  -3.118073568457543e-10,
   2.416956708884501e-12,   2.002173157649380e-13,  -1.100899130943615e-14,   1.849233310693863e-16,   9.864044729993508e-18,  -8.745539099510518e-19,   3.232729557152974e-20,
  -3.869408666703951e-22,  -2.836191718272782e-23,  -1.441833869668766e-04,   7.521529751846312e-06,  -2.858714243528760e-07,   8.844122854956582e-09,  -2.017544072471853e-10,
   1.559272507311559e-12,   1.297065127783063e-13,  -7.117683255945485e-15,   1.188146312372253e-16,   6.424107680428037e-18,  -5.666194436001973e-19,   2.087413426628522e-20,
  -2.462337942545832e-22,  -1.851339100562358e-23,  -7.734632149715327e-05,   4.034989669540603e-06,  -1.533600758822354e-07,   4.744355211692696e-09,  -1.082076065652760e-10,
   8.350187632683650e-13,   6.960887727607434e-14,  -3.815883462418744e-15,   6.349274856146671e-17,   3.456913393171859e-18,  -3.040998532756195e-19,   1.118354115282396e-20,
  -1.309233012196038e-22,  -9.973851600309213e-24,  -2.878300830879624e-05,   1.501561263461469e-06,  -5.707090956493409e-08,   1.765521511371920e-09,  -4.026457213679163e-11,
   3.105499038216107e-13,   2.590735747783722e-14,  -1.419705283708778e-15,   2.359596316821810e-17,   1.287816794098629e-18,  -1.131832463834152e-19,   4.159898222996301e-21,
  -4.856947583078330e-23,  -3.717077456980648e-24,  -3.251270618603694e-06,   1.696135892578572e-07,  -6.446628980889586e-09,   1.994297009636174e-10,  -4.548153042956835e-12,
   3.507574071888616e-14,   2.926509119195999e-15,  -1.603615713288796e-16,   2.664784329373349e-18,   1.454941045283380e-19,  -1.278527530477814e-20,   4.698605340057255e-22,
  -5.483599454915233e-24,  -4.199719955647784e-25,  -4.921832118429744e-03,   2.564091660970437e-04,  -9.701975203599149e-06,   2.953226440140598e-07,  -6.282101100210726e-09,
   8.785233201649195e-12,   7.040374518753182e-12,  -3.641518554634116e-13,   8.233551189123305e-15,   1.368252534357681e-16,  -2.059077365913135e-17,   9.075707528394510e-19,
  -1.749282125118679e-20,  -4.318352686612724e-22,  -4.682722661800638e-03,   2.439636832129663e-04,  -9.231180785254012e-06,   2.809599678313504e-07,  -5.973372400029967e-09,
   8.131310251285019e-12,   6.704622756533473e-12,  -3.462828274320379e-13,   7.805256027233287e-15,   1.316434361350561e-16,  -1.962202861300448e-17,   8.623390501319725e-19,
  -1.650552244214093e-20,  -4.171533944450440e-22,  -4.227791590941287e-03,   2.202802608982244e-04,  -8.335223479370095e-06,   2.536396628692742e-07,  -5.387417950615136e-09,
   6.979720468314449e-12,   6.063231694165065e-12,  -3.123553709054086e-13,   7.001835318998604e-15,   1.211855973083614e-16,  -1.776566136341077e-17,   7.767248981664838e-19,
  -1.468257332407924e-20,  -3.866376996019925e-22,  -3.601404128120365e-03,   1.876620660714885e-04,  -7.101166272077777e-06,   2.160348909832005e-07,  -4.583411400989005e-09,
   5.573413215300983e-12,   5.175125939567641e-12,  -2.657795315044523e-13,   5.917883746052724e-15,   1.056279621350354e-16,  -1.518438514216111e-17,   6.597245853459586e-19,
  -1.228060020851344e-20,  -3.396348348394236e-22,  -2.864752092550318e-03,   1.492907969251844e-04,  -5.649335025338328e-06,   1.718259482370451e-07,  -3.641404014924904e-09,
   4.146230607692207e-12,   4.124426068668160e-12,  -2.111831980343840e-13,   4.671387554572626e-15,   8.586966245675630e-17,  -1.211730452484746e-17,   5.232731888135540e-19,
  -9.593175889670929e-21,  -2.780771244801456e-22,  -2.089920387024388e-03,   1.089203511473513e-04,  -4.121755415224080e-06,   1.253402889850632e-07,  -2.653869986015995e-09,
   2.856161370708194e-12,   3.013481361568391e-12,  -1.539264787733251e-13,   3.386714256491178e-15,   6.372824316600032e-17,  -8.862499622466024e-18,   3.808446188715921e-19,
  -6.895122024589197e-21,  -2.075021083063545e-22,  -1.352822384610909e-03,   7.050859595332607e-05,  -2.668216697210090e-06,   8.112873414225006e-08,  -1.716741406991820e-09,
   1.776727954612354e-12,   1.952608145357167e-12,  -9.957847352127292e-14,   2.183169910969746e-15,   4.171476993102708e-17,  -5.746345098186418e-18,   2.461355491254188e-19,
  -4.418970927476664e-21,  -1.362966168988454e-22,  -7.257133857621505e-04,   3.782489341049500e-05,  -1.431395797223968e-06,   4.351962458922850e-08,  -9.206241055017156e-10,
   9.332623061222046e-13,   1.048002896391532e-12,  -5.340184014694521e-14,   1.168645849689887e-15,   2.250507437788031e-17,  -3.085217701341317e-18,   1.319303110865154e-19,
  -2.358313831777843e-21,  -7.365989840213204e-23,  -2.700608449987999e-04,   1.407596349020147e-05,  -5.326736296012865e-07,   1.619484447368455e-08,  -3.425529278829135e-10,
   3.447253668878449e-13,   3.900645641718719e-13,  -1.987037718389850e-14,   4.345657646642960e-16,   8.391348329293117e-18,  -1.148446157378546e-18,   4.908145322705737e-20,
  -8.760198989952505e-22,  -2.748164086697084e-23,  -3.050552851687450e-05,   1.589994737266700e-06,  -6.016984842737161e-08,   1.829333736491643e-09,  -3.869336482271408e-11,
   3.889340009561855e-14,   4.406215432330973e-14,  -2.244479499331572e-15,   4.908186035905374e-17,   9.481655183831789e-19,  -1.297322404890720e-19,   5.543891237990819e-21,
  -9.892506092198264e-23,  -3.105533649248455e-24,  -1.523252757039844e-02,   7.912093033692043e-04,  -2.949256599535801e-05,   8.409686754959950e-07,  -1.219480696727447e-08,
  -5.302851164465408e-10,   5.598393734081445e-11,  -2.805255537916967e-12,   8.919899753094879e-14,  -1.188077472673424e-15,  -6.096524055642844e-17,   5.285333241752653e-18,
  -2.200884836088683e-19,   5.347498975988854e-21,  -1.449249234139702e-02,   7.527993146662393e-04,  -2.806015139553488e-05,   7.999006203750394e-07,  -1.157639920628206e-08,
  -5.062489442515707e-10,   5.333462214459256e-11,  -2.670018167396175e-12,   8.477524102812310e-14,  -1.121531243026106e-15,  -5.843164153460093e-17,   5.040354380531142e-18,
  -2.093810069527329e-19,   5.065623685350111e-21,  -1.308450412029948e-02,   6.797087946165492e-04,  -2.533467153550356e-05,   7.218500853552774e-07,  -1.041033440636028e-08,
  -4.598162838457408e-10,   4.826524374096371e-11,  -2.412275995222996e-12,   7.639453776303747e-14,  -9.984852472020631e-16,  -5.343692032186508e-17,   4.569386495162563e-18,
  -1.890098210281786e-19,   4.538089663883405e-21,  -1.114588121024187e-02,   5.790494403647256e-04,  -2.158169862780009e-05,   6.145505471844403e-07,  -8.825237985792871e-09,
  -3.945234678761208e-10,   4.122961552688533e-11,  -2.056557228272712e-12,   6.492577692509979e-14,  -8.360028913858528e-16,  -4.622196202922798e-17,   3.911548651400656e-18,
  -1.609680238588427e-19,   3.828944556229913e-21,  -8.866015414473925e-03,   4.606427623200572e-04,  -1.716770771493045e-05,   4.885752694636369e-07,  -6.987047821315737e-09,
  -3.160139205353759e-10,   3.288518004129762e-11,  -1.637180310002541e-12,   5.152856763901646e-14,  -6.537387953451238e-16,  -3.730951589151627e-17,   3.126161794519053e-18,
  -1.280067797243974e-19,   3.017082195334827e-21,  -6.468003977179684e-03,   3.360731671664341e-04,  -1.252460748496544e-05,   3.562699198087424e-07,  -5.077822682617964e-09,
  -2.318279340790136e-10,   2.404287410109988e-11,  -1.195116488134101e-12,   3.752239382880987e-14,  -4.702867587335787e-16,  -2.753683643793713e-17,   2.289219649964252e-18,
  -9.336022202326440e-20,   2.184064547223417e-21,  -4.186785583192390e-03,   2.175517743963391e-04,  -8.107390914488377e-06,   2.305478220175115e-07,  -3.278596024808839e-09,
  -1.506144920185316e-10,   1.558543877337124e-11,  -7.739247833093723e-13,   2.425879366073911e-14,  -3.015776598789294e-16,  -1.796099140948699e-17,   1.485490634662511e-18,
  -6.042129691531100e-20,   1.406454299134828e-21,  -2.245974216584689e-03,   1.167067821735894e-04,  -4.349191202447943e-06,   1.236570687591236e-07,  -1.756489745109781e-09,
  -8.094787768059308e-11,   8.366851406242138e-12,  -4.152539307394316e-13,   1.300525994837644e-14,  -1.609955540866957e-16,  -9.672573332382929e-18,   7.978882632372269e-19,
  -3.240928572502596e-20,   7.524633458483181e-22,  -8.357976544410072e-04,   4.343059249414467e-05,  -1.618475172930819e-06,   4.601424491340331e-08,  -6.533481391226051e-10,
  -3.014290150004638e-11,   3.114364008209159e-12,  -1.545402857943529e-13,   4.838600877778515e-15,  -5.980993586104724e-17,  -3.604327484229532e-18,   2.970495167536192e-19,
  -1.206007278159942e-20,   2.797532140487894e-22,  -9.441001410953358e-05,   4.905837840690282e-06,  -1.828197623719075e-07,   5.197632377007990e-09,  -7.379556241099202e-11,
  -3.405233470572469e-12,   3.518065214521109e-13,  -1.745675965945345e-14,   5.465394715307623e-16,  -6.754188536682699e-18,  -4.072246385360324e-19,   3.355644608331938e-20,
  -1.362273473959159e-21,   3.159565796684117e-23,  -4.281190239022958e-04,   2.032243650399613e-05,  -7.161874588376048e-07,   2.164930247099447e-08,  -5.546084284062851e-10,
   1.024020384412552e-11,  -1.725110286206095e-14,  -8.874116347961738e-15,   4.346379602846853e-16,  -1.036283109833723e-17,  -3.958781591762998e-04,   1.879334670278269e-05,
  -6.623457488960346e-07,   2.002179915322788e-08,  -5.128101807069347e-10,   9.460025832143858e-12,  -1.541757576145352e-14,  -8.221216124261946e-15,   4.017630055980091e-16,
  -9.540934218534290e-18,  -3.362857121174376e-04,   1.596623193864444e-05,  -5.627710684455441e-07,   1.701186333135321e-08,  -4.355710676725093e-10,   8.023411037737264e-12,
  -1.235186287343318e-14,  -7.005041563448637e-15,   3.410793429440493e-16,  -8.046638812750852e-18,  -2.583925408906096e-04,   1.226954782178038e-05,  -4.325232982869973e-07,
   1.307468868939845e-08,  -3.346438158698439e-10,   6.154696440833941e-12,  -8.883893056033671e-15,  -5.399825979371345e-15,   2.619024384860989e-16,  -6.135237414066081e-18,
  -1.740499776239647e-04,   8.265430808045182e-06,  -2.913983091705266e-07,   8.808665663347892e-09,  -2.253921504327386e-10,   4.140275431408351e-12,  -5.662512160644653e-15,
  -3.646409189031328e-15,   1.763193708041518e-16,  -4.107289482516934e-18,  -9.610753146088522e-05,   4.564295177201786e-06,  -1.609232005096732e-07,   4.864547357926733e-09,
  -1.244514989853183e-10,   2.284453153995896e-12,  -3.024310354003679e-15,  -2.016394901855866e-15,   9.732978868755716e-17,  -2.259881572167642e-18,  -3.644540787355123e-05,
   1.730885816068848e-06,  -6.102701720291404e-08,   1.844786717457105e-09,  -4.719295721443645e-11,   8.660509562457790e-13,  -1.132279710042803e-15,  -7.650603830272719e-16,
   3.690446479210852e-17,  -8.558261689706576e-19,  -4.155280592279006e-06,   1.973456245615559e-07,  -6.957972095191278e-09,   2.103326735842600e-10,  -5.380632739023423e-12,
   9.873710537692584e-14,  -1.288199393886648e-16,  -8.723527443626049e-17,   4.207535215892060e-18,  -9.755418908767392e-20,  -4.017335450157491e-03,   1.906551077026960e-04,
  -6.710474644085470e-06,   2.017788434522346e-07,  -5.067061051477953e-09,   8.537826105715962e-11,   5.130978640653784e-13,  -1.181190899909635e-13,   5.548994823332530e-15,
  -1.463464444858026e-16,  -3.714796733239831e-03,   1.763097554626596e-04,  -6.205957812701741e-06,   1.866054435010413e-07,  -4.684731467886688e-09,   7.883238439343456e-11,
   4.812409186521416e-13,  -1.094432781396002e-13,   5.131901388428788e-15,  -1.349478006938175e-16,  -3.155599172344734e-03,   1.497869256926280e-04,  -5.272927217302921e-06,
   1.585461853075170e-07,  -3.978493080214660e-09,   6.680330978207884e-11,   4.182580380114967e-13,  -9.327389009111486e-14,   4.360426623039768e-15,  -1.141046130232454e-16,
  -2.424673629486172e-03,   1.151063383459786e-04,  -4.052520384876871e-06,   1.218475678225867e-07,  -3.056113547055583e-09,   5.119728360971820e-11,   3.290895298956975e-13,
  -7.191720090116573e-14,   3.351215466410673e-15,  -8.724057149521094e-17,  -1.633229472619869e-03,   7.754174146964216e-05,  -2.730230577605586e-06,   8.208827168652697e-08,
  -2.058106880502067e-09,   3.441549207871849e-11,   2.257584186968925e-13,  -4.857367825380704e-14,   2.257721881425041e-15,  -5.853261496111570e-17,  -9.018423234150530e-04,
   4.281967995081689e-05,  -1.507748803238076e-06,   4.533201513082718e-08,  -1.136307805943524e-09,   1.898122281868517e-11,   1.259627061322859e-13,  -2.686329256346362e-14,
   1.246792647293469e-15,  -3.224666099386235e-17,  -3.419920322501974e-04,   1.623820340128650e-05,  -5.717836530192646e-07,   1.719117639722116e-08,  -4.308841713392060e-10,
   7.194764599998418e-12,   4.795242216796739e-14,  -1.019289355003003e-14,   4.728183416643463e-16,  -1.221784328326469e-17,  -3.899182168083031e-05,   1.851386264690215e-06,
  -6.519167675251530e-08,   1.960043241261262e-09,  -4.912636423245972e-11,   8.202422298792554e-13,   5.470744951074871e-15,  -1.162242935507544e-15,   5.390813001277939e-17,
  -1.392803210658113e-18,  -1.243764416945140e-02,   5.898241155812605e-04,  -2.067360757693867e-05,   6.103804546100899e-07,  -1.421107856924866e-08,   1.448024222872383e-10,
   9.466231053927508e-12,  -7.965826165367925e-13,   3.684399849982680e-14,  -1.191353819917490e-15,  -1.150098122394524e-02,   5.454423931830642e-04,  -1.911891248713613e-05,
   5.644299148814543e-07,  -1.313341329000085e-08,   1.331442074444095e-10,   8.798163336444774e-12,  -7.384138360824852e-13,   3.411280249762527e-14,  -1.101316441840858e-15,
  -9.769702925321578e-03,   4.633870872739722e-04,  -1.624395900483648e-05,   4.794870302295929e-07,  -1.114598042226759e-08,   1.120492002430897e-10,   7.536308159361505e-12,
  -6.297962702081788e-13,   2.903808861291957e-14,  -9.350717597607412e-16,  -7.506759083279237e-03,   3.560955685792140e-04,  -1.248389581328206e-05,   3.684419754332764e-07,
  -8.555720593055615e-09,   8.523543569182251e-11,   5.841743476409573e-12,  -4.859855972107927e-13,   2.236101923341091e-14,  -7.180898225910692e-16,  -5.056454834984009e-03,
   2.398837097599116e-04,  -8.410315136130467e-06,   2.481869892192432e-07,  -5.758482058518774e-09,   5.695666096495360e-11,   3.962017362695920e-12,  -3.284493948388394e-13,
   1.508793556673456e-14,  -4.834794074551847e-16,  -2.792089809202766e-03,   1.324669064599347e-04,  -4.644457614741507e-06,   1.370476193016920e-07,  -3.178287020693989e-09,
   3.130473188513576e-11,   2.196400331480773e-12,  -1.817133579638304e-13,   8.339514610085184e-15,  -2.668983696193464e-16,  -1.058801873147727e-03,   5.023443158332583e-05,
  -1.761307322843441e-06,   5.197090180523172e-08,  -1.205046762064711e-09,   1.185044431681688e-11,   8.341384261265124e-13,  -6.895810243004523e-14,   3.163634618616117e-15,
  -1.012015937550525e-16,  -1.207180548991943e-04,   5.727439048774876e-06,  -2.008145262815299e-07,   5.925409231039647e-09,  -1.373880840624712e-10,   1.350721809271858e-12,
   9.512657996485519e-14,  -7.863116522216014e-15,   3.607201372573828e-16,  -1.153818703012456e-17,  -3.568359550240710e-04,   1.549634912066289e-05,  -5.031248102211664e-07,
   1.433097406589018e-08,  -3.673730027381510e-10,   8.083943703812999e-12,  -1.240431679383400e-13,  -3.997291554937733e-16,   1.255897231567100e-16,  -5.680554955861894e-18,
  -3.299591371059646e-04,   1.433009498136293e-05,  -4.652951052152059e-07,   1.325422009585809e-08,  -3.397606709930667e-10,   7.474148068032632e-12,  -1.145365644660854e-13,
  -3.785943049159356e-16,   1.164209136716184e-16,  -5.256050628252963e-18,  -2.802838422469503e-04,   1.217399570515827e-05,  -3.953364312875892e-07,   1.126249700775441e-08,
  -2.886906826393712e-10,   6.347631193912802e-12,  -9.706443178822030e-14,  -3.341139515185822e-16,   9.929831237021185e-17,  -4.469369084629137e-18,  -2.153575494078935e-04,
   9.355008239922446e-06,  -3.038333477002548e-07,   8.656611659856346e-09,  -2.218828165525368e-10,   4.876177512720579e-12,  -7.439311546368243e-14,  -2.669276747174406e-16,
   7.662548788985346e-17,  -3.437762353337288e-18,  -1.450596444003592e-04,   6.301867081548734e-06,  -2.046943218725352e-07,   5.832481445593132e-09,  -1.494897292190085e-10,
   3.283909579621249e-12,  -5.001015597066912e-14,  -1.852103671659087e-16,   5.178719516297247e-17,  -2.317523452894627e-18,  -8.009874944960198e-05,   3.479930878589720e-06,
  -1.130403014920348e-07,   3.221076905387180e-09,  -8.255602572084197e-11,   1.813121317518436e-12,  -2.758283686449272e-14,  -1.039949784069154e-16,   2.865116058531852e-17,
  -1.280293565601181e-18,  -3.037452566366242e-05,   1.319662094484541e-06,  -4.286819954508287e-08,   1.221548225921226e-09,  -3.130793467030396e-11,   6.875341340937020e-13,
  -1.045527025750089e-14,  -3.968209493193869e-17,   1.087279093488987e-17,  -4.855906634587055e-19,  -3.463113904904537e-06,   1.504601182972900e-07,  -4.887598542142036e-09,
   1.392746762692242e-10,  -3.569565168169484e-12,   7.838786211115529e-14,  -1.191959363969069e-15,  -4.528950507132907e-18,   1.239796765659990e-18,  -5.536564168987609e-20,
  -3.348521901831826e-03,   1.454082542574638e-04,  -4.719381517380921e-06,   1.342133870203888e-07,  -3.419769407550429e-09,   7.361102831442609e-11,  -1.014564061688963e-12,
  -1.204914288973174e-14,   1.567747489393692e-15,  -6.872184590308823e-17,  -3.096311758938081e-03,   1.344648032015860e-04,  -4.364526408863561e-06,   1.241283553744037e-07,
  -3.162640055789103e-09,   6.805045661231842e-11,  -9.361365932979005e-13,  -1.124987089337772e-14,   1.453376521081299e-15,  -6.360799933217653e-17,  -2.630162390824347e-03,
   1.142332423334741e-04,  -3.708295275516296e-06,   1.054741601523898e-07,  -2.687126808673565e-09,   5.778275908312475e-11,  -7.923923597751249e-13,  -9.707280070380871e-15,
   1.239741452542397e-15,  -5.411806107684382e-17,  -2.020898857851688e-03,   8.778156702084134e-05,  -2.849979012132303e-06,   8.106876121088809e-08,  -2.065172954043565e-09,
   4.437904415325742e-11,  -6.065433338513808e-13,  -7.581907863712628e-15,   9.567718137992979e-16,  -4.165157179136257e-17,  -1.361228608342870e-03,   5.913277119578428e-05,
  -1.920043349103486e-06,   5.462034019159664e-08,  -1.391317504135220e-09,   2.988271153886065e-11,  -4.073335127746782e-13,  -5.172383758898116e-15,   6.466874726336949e-16,
  -2.809212199272864e-17,  -7.516405201655356e-04,   3.265348339995686e-05,  -1.060322496686915e-06,   3.016473317858367e-08,  -7.683398191002602e-10,   1.649739581996686e-11,
  -2.245314479385609e-13,  -2.876926466012668e-15,   3.577963700159891e-16,  -1.552345717050625e-17,  -2.850322160607282e-04,   1.238287837106563e-05,  -4.021052081562693e-07,
   1.143952571259515e-08,  -2.913768870919624e-10,   6.255580971455457e-12,  -8.508989383401609e-14,  -1.093939030011960e-15,   1.357822318340588e-16,  -5.888351796445816e-18,
  -3.249759486643442e-05,   1.411823016937970e-06,  -4.584584119146503e-08,   1.304275674646804e-09,  -3.322120273756817e-11,   7.132137279830630e-13,  -9.700370430403776e-15,
  -1.247802335957923e-16,   1.548295195444800e-17,  -6.713842418161677e-19,  -1.036783851772448e-02,   4.501389176521158e-04,  -1.459368077429385e-05,   4.128848364857792e-07,
  -1.030601215717862e-08,   2.043194161746207e-10,  -1.521608139114175e-12,  -1.308414467845522e-13,   9.464536034120731e-15,  -4.077285271339081e-16,  -9.586933619013803e-03,
   4.162610203441613e-04,  -1.349629359287685e-05,   3.818499570802970e-07,  -9.530078986551157e-09,   1.887937690889048e-10,  -1.395131974739965e-12,  -1.216276785372830e-13,
   8.776935182434700e-15,  -3.777159557199676e-16,  -8.143620594905846e-03,   3.536299218171124e-04,  -1.146694708383042e-05,   3.244510125232378e-07,  -8.095755077584757e-09,
   1.601800728039475e-10,  -1.168508650127718e-12,  -1.042119875101663e-13,   7.490817295739609e-15,  -3.218220867239802e-16,  -6.257191877933788e-03,   2.717435016399549e-04,
  -8.812741239374501e-06,   2.493656890148154e-07,  -6.220754433513652e-09,   1.229188971304056e-10,  -8.842703873661936e-13,  -8.080302511433206e-14,   5.784360545667757e-15,
  -2.480639964704450e-16,  -4.214692590999383e-03,   1.830558221715426e-04,  -5.937137656043955e-06,   1.680048627318624e-07,  -4.190324696572950e-09,   8.271199590462091e-11,
  -5.884173963910884e-13,  -5.481518995658347e-14,   3.911454341243228e-15,  -1.675081401676132e-16,  -2.327260435733716e-03,   1.010844910154711e-04,  -3.278703674556572e-06,
   9.278074455476561e-08,  -2.313859858242309e-09,   4.564515453888600e-11,  -3.226109171349823e-13,  -3.039159454110428e-14,   2.164680087784034e-15,  -9.262742883026340e-17,
  -8.825284987749721e-04,   3.833332614597186e-05,  -1.243377998026036e-06,   3.518543853903661e-08,  -8.774545502424911e-10,   1.730546561909331e-11,  -1.220105741323812e-13,
  -1.154254814201992e-14,   8.215681696549901e-16,  -3.514451314744615e-17,  -1.006203925579386e-04,   4.370540369675974e-06,  -1.417631346041658e-07,   4.011656854431068e-09,
  -1.000420382487482e-10,   1.972989511547320e-12,  -1.390468682413547e-14,  -1.316342875796105e-15,   9.368316147601818e-17,  -4.007316064638853e-18,  -3.019375882957362e-04,
   1.207055569209309e-05,  -3.616047263616609e-07,   9.587008869715966e-09,  -2.346865078458894e-10,   5.275532007747723e-12,  -1.023408692779062e-13,   1.346735620709402e-15,
   8.750418330483657e-18,  -1.432315955754915e-18,  -2.791928634310804e-04,   1.116191832216983e-05,  -3.344081446829626e-07,   8.866638101977142e-09,  -2.170626414684594e-10,
   4.879080966130811e-12,  -9.461474926293343e-14,   1.242922682337642e-15,   8.212063692102198e-18,  -1.328471968693296e-18,  -2.371564597002686e-04,   9.482211062050126e-06,
  -2.841180291200017e-07,   7.534167138288348e-09,  -1.844573296766739e-10,   4.145789789554347e-12,  -8.034548151596069e-14,   1.052478825594749e-15,   7.144256675399565e-18,
  -1.134099262411347e-18,  -1.822171690151342e-04,   7.286291467958667e-06,  -2.183483949203855e-07,   5.790873281420586e-09,  -1.417885919119931e-10,   3.186458292629516e-12,
  -6.171327677053191e-14,   8.059616448797292e-16,   5.626888704532778e-18,  -8.759775892498574e-19,  -1.227353712972341e-04,   4.908180238102414e-06,  -1.470979725574406e-07,
   3.901629710816500e-09,  -9.553708092362202e-11,   2.146860143846215e-12,  -4.155756713119069e-14,   5.414328902598578e-16,   3.863142468484162e-18,  -5.924675329285829e-19,
  -6.777123019517714e-05,   2.710288202503445e-06,  -8.123184402869783e-08,   2.154724801304634e-09,  -5.276357968437480e-11,   1.185620391912369e-12,  -2.294364869944908e-14,
   2.985065625615752e-16,   2.156425899103353e-18,  -3.279217296021684e-19,  -2.569968641444477e-05,   1.027791906964962e-06,  -3.080528905687000e-08,   8.171477678006099e-10,
  -2.001009906544064e-11,   4.496276173539058e-13,  -8.700037235164131e-15,   1.131320394043139e-16,   8.210626217568600e-19,  -1.244625626307808e-19,  -2.930116431269237e-06,
   1.171826868106645e-07,  -3.512247245602111e-09,   9.316697984384478e-11,  -2.281453831212125e-12,   5.126419627363625e-14,  -9.919144370284205e-16,   1.289736774432528e-17,
   9.367513180038081e-20,  -1.419252786306220e-20,  -2.833375577458470e-03,   1.132683184528037e-04,  -3.392943159062279e-06,   8.991458752176220e-08,  -2.197037385228342e-09,
   4.906552601565246e-11,  -9.300747728089268e-13,   1.087988056491546e-14,   1.694862732101501e-16,  -1.718954971394607e-17,  -2.619939570529715e-03,   1.047417923149249e-04,
  -3.137755807227011e-06,   8.315819192854985e-08,  -2.032031240133451e-09,   4.537675460351394e-11,  -8.597474032360634e-13,   1.003221071227114e-14,   1.581265027477292e-16,
  -1.594333281805670e-17,  -2.225470876155270e-03,   8.897965810825438e-05,  -2.665881101663171e-06,   7.066098806255318e-08,  -1.726770360198333e-09,   3.855478987051972e-11,
  -7.299280081026034e-13,   8.482452089230002e-15,   1.362834316911893e-16,  -1.361069661845261e-17,  -1.709921789928926e-03,   6.837346753916825e-05,  -2.048762672628019e-06,
   5.431087676780409e-08,  -1.327311636696417e-09,   2.963148287899231e-11,  -5.605283320534945e-13,   6.485314537153277e-15,   1.063167605942888e-16,  -1.051298756458672e-17,
  -1.151745935811869e-03,   4.605762391356439e-05,  -1.380219226146846e-06,   3.659211037835042e-08,  -8.943304350273463e-10,   1.996312120547131e-11,  -3.773899800760553e-13,
   4.351226117651052e-15,   7.246315925034883e-17,  -7.110523497351568e-18,  -6.359636810672234e-04,   2.543293485759798e-05,  -7.621975451345815e-07,   2.020842376270437e-08,
  -4.939205256151720e-10,   1.102449028943218e-11,  -2.083325737756084e-13,   2.397184400607539e-15,   4.028393537165795e-17,  -3.935589303631615e-18,  -2.411652716744888e-04,
   9.644643726071935e-06,  -2.890456677520504e-07,   7.663743064181343e-09,  -1.873142640378285e-10,   4.180819235207671e-12,  -7.899483119512001e-14,   9.082654376401304e-16,
   1.531487254603585e-17,  -1.493754873213064e-18,  -2.749614581108328e-05,   1.099624597007618e-06,  -3.295537420021882e-08,   8.737804152622676e-10,  -2.135664828009293e-11,
   4.766743981948753e-13,  -9.006352366535250e-15,   1.035400276573035e-16,   1.746836999763780e-18,  -1.703336780829463e-19,  -8.772971943109853e-03,   3.506981907871000e-04,
  -1.050225444062858e-05,   2.779225586342191e-07,  -6.751049396548515e-09,   1.475109656596324e-10,  -2.568855734068082e-12,   1.512789310676672e-14,   1.479196927438598e-15,
  -9.593604912089680e-17,  -8.112110536336124e-03,   3.242985342218250e-04,  -9.712353663925637e-06,   2.570369238933079e-07,  -6.243824201823318e-09,   1.364044809995807e-10,
  -2.373348258695633e-12,   1.383378096474860e-14,   1.375436313945860e-15,  -8.899855948109447e-17,  -6.890718144121534e-03,   2.754961746031526e-04,  -8.251732205841930e-06,
   2.184062039141368e-07,  -5.305576269445350e-09,   1.158742317192470e-10,  -2.013210752135186e-12,   1.153488220706437e-14,   1.179053944025696e-15,  -7.600240900383537e-17,
  -5.294425016515883e-03,   2.116958243829622e-04,  -6.341542980201293e-06,   1.678674631277448e-07,  -4.077999071673017e-09,   8.903680864657108e-11,  -1.544541981157674e-12,
   8.686058765102816e-15,   9.146661342572386e-16,  -5.872546801332595e-17,  -3.566146918709783e-03,   1.426021567249060e-04,  -4.272189627189872e-06,   1.131000474399936e-07,
  -2.747599789598149e-09,   5.997520244630766e-11,  -1.039131264227470e-12,   5.756716520835132e-15,   6.207362092627492e-16,  -3.973046284676877e-17,  -1.969132092353363e-03,
   7.874463480337710e-05,  -2.359225799459402e-06,   6.246046804933282e-08,  -1.517405622735048e-09,   3.311765754659296e-11,  -5.733906849614628e-13,   3.148717572003224e-15,
   3.442373381828484e-16,  -2.199391167315211e-17,  -7.467191715869128e-04,   2.986143384580104e-05,  -8.946810632080118e-07,   2.368714817403526e-08,  -5.754550244980089e-10,
   1.255875594615232e-11,  -2.173811736621310e-13,   1.189757878619276e-15,   1.307503987781491e-16,  -8.348311591376981e-18,  -8.513621823872392e-05,   3.404622063776151e-06,
  -1.020065355165211e-07,   2.700685351854917e-09,  -6.561044073912134e-11,   1.431872759738489e-12,  -2.478338049110586e-14,   1.355678880428103e-16,   1.491133258770897e-17,
  -9.519721749146799e-19,  -2.587929897258861e-04,   9.581275630150960e-06,  -2.660056081594594e-07,   6.555576309036049e-09,  -1.506712015979050e-10,   3.269458419088464e-12,
  -6.584454771858680e-14,   1.149156608773316e-15,  -1.341590513595896e-17,  -1.061707169512523e-19,  -2.392963676915606e-04,   8.859884731502680e-06,  -2.459933161206969e-07,
   6.062840764545475e-09,  -1.393566790591452e-10,   3.024057501920919e-12,  -6.089736483188352e-14,   1.062352760131747e-15,  -1.237702334383394e-17,  -9.952332330717583e-20,
  -2.032642267827577e-04,   7.526405666132663e-06,  -2.089914202057001e-07,   5.151516564985358e-09,  -1.184239751188603e-10,   2.569976699161024e-12,  -5.174626721257548e-14,
   9.020651446628209e-16,  -1.047396122193229e-17,  -8.642459804274090e-20,  -1.561741438495180e-04,   5.783258856819167e-06,  -1.606060311377946e-07,   3.959365126291740e-09,
  -9.103034211336739e-11,   1.975625141796544e-12,  -3.977331928561335e-14,   6.928179857232655e-16,  -8.015247146394626e-18,  -6.794410045864208e-20,  -1.051924898845832e-04,
   3.895625660975410e-06,  -1.081943331194648e-07,   2.667553354100681e-09,  -6.133633736603041e-11,   1.331247438969226e-12,  -2.679764282342522e-14,   4.665112559249474e-16,
  -5.381609671674643e-18,  -4.658292337714558e-20,  -5.808414046402228e-05,   2.151130602588303e-06,  -5.974699272697954e-08,   1.473162169029720e-09,  -3.387511042379814e-11,
   7.352493579445229e-13,  -1.479938955677223e-14,   2.575478410715600e-16,  -2.966092605166846e-18,  -2.598286938714059e-20,  -2.202616924672528e-05,   8.157450846947706e-07,
  -2.265750004375228e-08,   5.586711232135175e-10,  -1.284682875528327e-11,   2.788397847406187e-13,  -5.612458012070733e-15,   9.765855460646569e-17,  -1.123996291001510e-18,
  -9.890214646398703e-21,  -2.511284126956813e-06,   9.300630408467596e-08,  -2.583278790980486e-09,   6.369672820161717e-11,  -1.464732841442387e-12,   3.179201316369443e-14,
  -6.399036796126401e-16,   1.113428555679239e-17,  -1.281361841941380e-19,  -1.128323009851251e-21,  -2.428510489980643e-03,   8.991031781405357e-05,  -2.496132223426381e-06,
   6.150855140325818e-08,  -1.412938402163520e-09,   3.059862141142158e-11,  -6.121005600952283e-13,   1.043776941086105e-14,  -1.080540148996828e-16,  -1.798480989206631e-18,
  -2.245554406137469e-03,   8.314081246339206e-05,  -2.308341467518143e-06,   5.688536076643920e-08,  -1.306831408491941e-09,   2.830163396015636e-11,  -5.660899745155787e-13,
   9.647990547147421e-15,  -9.958640937708152e-17,  -1.678339962979045e-18,  -1.907429199341374e-03,   7.062749526249001e-05,  -1.961124319414139e-06,   4.833469866947371e-08,
  -1.110527793525013e-09,   2.405155264173713e-11,  -4.809940028834202e-13,   8.190427160914873e-15,  -8.413372824616190e-17,  -1.447064929741324e-18,  -1.465536391516585e-03,
   5.426987264838468e-05,  -1.507087385286367e-06,   3.714916013863602e-08,  -8.536382486494725e-10,   1.848887373669504e-11,  -3.696787079798012e-13,   6.289002179436168e-15,
  -6.426836139533805e-17,  -1.129342025116563e-18,  -9.871251280582163e-04,   3.655639656512463e-05,  -1.015268783586718e-06,   2.502857885997256e-08,  -5.751801204367441e-10,
   1.245828803064503e-11,  -2.490617655790315e-13,   4.233902720281385e-15,  -4.308957732526010e-17,  -7.699825113034938e-19,  -5.450609125564435e-04,   2.018612394772962e-05,
  -5.606509098597125e-07,   1.382208055616473e-08,  -3.176623806174836e-10,   6.880667556378887e-12,  -1.375439425217894e-13,   2.337158272335934e-15,  -2.372923878623588e-17,
  -4.281301921631431e-19,  -2.066933212553733e-04,   7.654919369720319e-06,  -2.126123343736573e-07,   5.241782609486145e-09,  -1.204704798731845e-10,   2.609451827746538e-12,
  -5.216100604384897e-14,   8.861806178634207e-16,  -8.989341443341032e-18,  -1.627749118875629e-19,  -2.356586163334497e-05,   8.727674508611324e-07,  -2.424084431301441e-08,
   5.976403254715133e-10,  -1.373545544175273e-11,   2.975173838484797e-13,  -5.947119478843130e-15,   1.010348689776138e-16,  -1.024736473807891e-18,  -1.856656033568632e-20,
  -7.519416140079603e-03,   2.783875969384471e-04,  -7.728224355200885e-06,   1.903658231155043e-07,  -4.365766696919433e-09,   9.395008675921578e-11,  -1.838270303585888e-12,
   2.883815715373331e-14,  -1.505588141135951e-16,  -1.408979526503638e-17,  -6.952927749337405e-03,   2.574272955603991e-04,  -7.146806793008805e-06,   1.760569447796127e-07,
  -4.037876299316820e-09,   8.689438775200508e-11,  -1.699872661452194e-12,   2.664142258205044e-14,  -1.375097232927007e-16,  -1.310672752487736e-17,  -5.905987975037795e-03,
   2.186825365827797e-04,  -6.071791811061462e-06,   1.495926584877072e-07,  -3.431283033699653e-09,   7.384115222224931e-11,  -1.444038963958837e-12,   2.259604150921067e-14,
  -1.144180346702189e-16,  -1.124274507907133e-17,  -4.537751778999930e-03,   1.680347354560016e-04,  -4.666055759929281e-06,   1.149737761137927e-07,  -2.637510695129059e-09,
   5.675959923468019e-11,  -1.109598913905262e-12,   1.733349191306727e-14,  -8.595881878884166e-17,  -8.727707913187467e-18,  -3.056443228736631e-03,   1.131888421062406e-04,
  -3.143346952444697e-06,   7.746130791613234e-08,  -1.777128789772893e-09,   3.824426509673262e-11,  -7.474316799463233e-13,   1.166034867929885e-14,  -5.686024272027893e-17,
  -5.926216807314829e-18,  -1.687676346759900e-03,   6.250189102869729e-05,  -1.735816052234391e-06,   4.277808934431384e-08,  -9.814716044862786e-10,   2.112158143424954e-11,
  -4.127254704098315e-13,   6.433768737081200e-15,  -3.106498395324486e-17,  -3.287470561149237e-18,  -6.399861388803446e-04,   2.370177311315883e-05,  -6.582632059585525e-07,
   1.622283371403217e-08,  -3.722129119514926e-10,   8.010148977902064e-12,  -1.565124820119941e-13,   2.439084352997461e-15,  -1.173293381674481e-17,  -1.248811393443032e-18,
  -7.296716072584032e-05,   2.702332324561782e-06,  -7.505141068280639e-08,   1.849641507216093e-09,  -4.243787864364008e-11,   9.132778022647503e-13,  -1.784460339375625e-14,
   2.780761798745208e-16,  -1.336821148980646e-18,  -1.424224836603131e-19,  -2.242776996483105e-04,   7.731378305697748e-06,  -1.998956609326662e-07,   4.592140202429490e-09,
  -9.873357719665793e-11,   2.026069505477004e-12,  -3.972025126758462e-14,   7.278102227270949e-16,  -1.161851010566096e-17,   1.245705450235594e-19,  -2.073799913195877e-04,
   7.149177065586705e-06,  -1.848531623061127e-07,   4.246865955803709e-09,  -9.131702447895334e-11,   1.874011507657714e-12,  -3.674031368264561e-14,   6.731409354911111e-16,
  -1.074067694898407e-17,   1.149010499482502e-19,  -1.761517797662271e-04,   6.073043560800453e-06,  -1.570425235161233e-07,   3.608344648760182e-09,  -7.759721475491434e-11,
   1.592639686618328e-12,  -3.122549225879426e-14,   5.720072179173994e-16,  -9.119833708388994e-18,   9.720150991229545e-20,  -1.353412767771687e-04,   4.666396454344459e-06,
  -1.206799126474110e-07,   2.773178376241877e-09,  -5.964501908354799e-11,   1.224332912878689e-12,  -2.400565525254889e-14,   4.396733222970011e-16,  -7.004112591712931e-18,
   7.435696723035134e-20,  -9.115950867828406e-05,   3.143247135938550e-06,  -8.129527765440018e-08,   1.868310754845528e-09,  -4.018753075671339e-11,   8.250097300154697e-13,
  -1.617672214933896e-14,   2.962424104316566e-16,  -4.716110966994310e-18,   4.991041635959880e-20,  -5.033528826539558e-05,   1.735655985017824e-06,  -4.489208096872704e-08,
   1.031756420523472e-09,  -2.219452390258741e-11,   4.556569881575905e-13,  -8.934690096854464e-15,   1.636068733169713e-16,  -2.603590866759008e-18,   2.750365016511012e-20,
  -1.908767892012794e-05,   6.581875606472911e-07,  -1.702405461238468e-08,   3.912725006950596e-10,  -8.417011260519631e-12,   1.728061876350405e-13,  -3.388476627568547e-15,
   6.204596023703903e-17,  -9.872393290486020e-19,   1.042180169998499e-20,  -2.176255394736238e-06,   7.504250360701166e-08,  -1.940983527308123e-09,   4.461076222875226e-11,
  -9.596654769014834e-13,   1.970256523087353e-14,  -3.863390432379411e-16,   7.074169373649803e-18,  -1.125574039290158e-19,   1.188078438060550e-21,  -2.104619899768833e-03,
   7.255113863008067e-05,  -1.875808500855712e-06,   4.309105223773626e-08,  -9.263457904015607e-10,   1.899791499365493e-11,  -3.716769063673740e-13,   6.765112400808015e-15,
  -1.056055169467629e-16,   1.010188699355757e-18,  -1.946051957507305e-03,   6.708777066901720e-05,  -1.734650580551532e-06,   3.985111202571136e-08,  -8.567609693519669e-10,
   1.757205167915602e-11,  -3.437886411715244e-13,   6.256714692190814e-15,  -9.761281509385168e-17,   9.308323461886308e-19,  -1.653006702801202e-03,   5.698934965510864e-05,
  -1.473677212623912e-06,   3.385944144753153e-08,  -7.280370777003626e-10,   1.493363312339610e-11,  -2.921795714868539e-13,   5.316363517950775e-15,  -8.286317782237389e-17,
   7.861237023085003e-19,  -1.270041312485586e-03,   4.378939406901810e-05,  -1.132452696423106e-06,   2.602252661457848e-08,  -5.596041842858144e-10,   1.148008350610699e-11,
  -2.246184810426603e-13,   4.086150153392694e-15,  -6.362394206766743e-17,   6.002810251919588e-19,  -8.554400014565920e-04,   2.949618366800323e-05,  -7.628697358286496e-07,
   1.753156451986683e-08,  -3.770488542011069e-10,   7.735754550649916e-12,  -1.513615730219853e-13,   2.753014998273197e-15,  -4.283183624812155e-17,   4.023448444959898e-19,
  -4.723458877951679e-04,   1.628736951752026e-05,  -4.212644353531614e-07,   9.681634547122039e-09,  -2.082341071112996e-10,   4.272484938206367e-12,  -8.359891838676539e-14,
   1.520371308757320e-15,  -2.364320398958715e-17,   2.215303541129629e-19,  -1.791186055634634e-04,   6.176422110341741e-06,  -1.597526455207622e-07,   3.671561526646443e-09,
  -7.897030910944351e-11,   1.620322186306349e-12,  -3.170473867818253e-14,   5.765761302968740e-16,  -8.964737434715786e-18,   8.391667735276701e-20,  -2.042196085133906e-05,
   7.041977182980616e-07,  -1.821406592366284e-08,   4.186114707278682e-10,  -9.003798861393513e-12,   1.847416399893796e-13,  -3.614831331146567e-15,   6.573819543284277e-17,
  -1.022082921480508e-18,   9.565942685386526e-21,  -6.516555739116779e-03,   2.246404114545707e-04,  -5.807988682560432e-06,   1.334090345193174e-07,  -2.866683066728134e-09,
   5.868518690855080e-11,  -1.140737965125705e-12,   2.031990178930841e-14,  -2.931651117507961e-16,   1.524107398672452e-18,  -6.025580221639393e-03,   2.077241591104497e-04,
  -5.370926804113228e-06,   1.233781848069784e-07,  -2.651338487179314e-09,   5.428010354368977e-11,  -1.055105443958699e-12,   1.879042756424515e-14,  -2.708307078877409e-16,
   1.393004446501192e-18,  -5.118221249445444e-03,   1.764563710085603e-04,  -4.562885180913564e-06,   1.048280181351561e-07,  -2.252979695066718e-09,   4.612926142342559e-11,
  -8.966601826309268e-13,   1.596291847402571e-14,  -2.297023939599829e-16,   1.160480589571592e-18,  -3.932441661028740e-03,   1.355852889144001e-04,  -3.506365489653577e-06,
   8.056504945994033e-08,  -1.731740835770254e-09,   3.546079211726915e-11,  -6.892797387850808e-13,   1.226628916861300e-14,  -1.762020792885061e-16,   8.729975350268027e-19,
  -2.648707458105388e-03,   9.132915896979971e-05,  -2.362041111951606e-06,   5.427722049623126e-08,  -1.166804568791993e-09,   2.389461490557678e-11,  -4.644548925078917e-13,
   8.262841925743515e-15,  -1.185304030054447e-16,   5.781023727530687e-19,  -1.462529309910213e-03,   5.043065114227315e-05,  -1.304343069939445e-06,   2.997405100131002e-08,
  -6.443940506928721e-10,   1.319697535705183e-11,  -2.565167770256396e-13,   4.562736546322581e-15,  -6.540028760827365e-17,   3.160442432864965e-19,  -5.546067347933420e-04,
   1.912408185564121e-05,  -4.946352782516039e-07,   1.136704301864964e-08,  -2.443786041534393e-10,   5.004883034644144e-12,  -9.728244662547848e-14,   1.730276121314597e-15,
  -2.479359502182135e-17,   1.193961270806915e-19,  -6.323272219406099e-05,   2.180410367091317e-06,  -5.639543246251100e-08,   1.296008373039916e-09,  -2.786282031537913e-11,
   5.706333249842489e-13,  -1.109168549861522e-14,   1.972757571250383e-16,  -2.826677206728665e-18,   1.360425361073787e-20,  -1.962357531808174e-04,   6.328554847899729e-06,
  -1.530817441108951e-07,   3.291005867569365e-09,  -6.629358012703107e-11,   1.279534657303296e-12,  -2.386210365861883e-14,   4.282634821377194e-16,  -7.224419684988927e-18,
   1.069421481378697e-19,  -1.814498385347812e-04,   5.851929486742032e-06,  -1.415596120846616e-07,   3.043485512679005e-09,  -6.131196714769215e-11,   1.183475968506331e-12,
  -2.207221370755536e-14,   3.961488234200897e-16,  -6.681944360883291e-18,   9.886335549580613e-20,  -1.541249603569018e-04,   4.970978515882811e-06,  -1.202589315851290e-07,
   2.585788003245121e-09,  -5.209764987100269e-11,   1.005744082428406e-12,  -1.875956475667941e-14,   3.367067207319278e-16,  -5.678296501424106e-18,   8.394581410453051e-20,
  -1.184164910511953e-04,   3.819522922672928e-06,  -9.241062361611561e-08,   1.987210367160533e-09,  -4.004270284869177e-11,   7.731277073769382e-13,  -1.442242332151433e-14,
   2.588717405753183e-16,  -4.364831697675012e-18,   6.447242231912008e-20,  -7.975918861248625e-05,   2.572762619205557e-06,  -6.225036087589552e-08,   1.338752539743712e-09,
  -2.697879788220176e-11,   5.209505095383246e-13,  -9.719056870608902e-15,   1.744552620357523e-16,  -2.941040179226894e-18,   4.341218200417014e-20,  -4.404022038598923e-05,
   1.420630725311839e-06,  -3.437481057746337e-08,   7.392984698860535e-10,  -1.489933076316053e-11,   2.877181004140020e-13,  -5.368071371018804e-15,   9.635760471888550e-17,
  -1.624294134500473e-18,   2.396647506633967e-20,  -1.670049554817962e-05,   5.387234224222941e-07,  -1.303560928226053e-08,   2.803617334137351e-10,  -5.650344832926585e-12,
   1.091152228761615e-13,  -2.035847481871805e-15,   3.654398121881049e-17,  -6.159992297620108e-19,   9.087727524364907e-21,  -1.904083475042364e-06,   6.142190421322538e-08,
  -1.486242953252052e-09,   3.196528058873418e-11,  -6.442230697138814e-13,   1.244080022593760e-14,  -2.321184540931280e-16,   4.166590031626773e-18,  -7.023323894480587e-20,
   1.036113070528255e-21,  -1.841474614293609e-03,   5.938709647554058e-05,  -1.436515984739172e-06,   3.088250709244554e-08,  -6.220692788744520e-10,   1.200457998670375e-11,
  -2.237347335320984e-13,   4.007191855763329e-15,  -6.716618501348194e-17,   9.737547137560762e-19,  -1.702723718770855e-03,   5.491444873582968e-05,  -1.328392523518318e-06,
   2.855979692860003e-08,  -5.753239335415342e-10,   1.110334828224448e-11,  -2.069517355435495e-13,   3.706656853351594e-15,  -6.212038745045890e-17,   9.000718769549689e-19,
  -1.446307297656762e-03,   4.664761344061475e-05,  -1.128507359639423e-06,   2.426480271578435e-08,  -4.888607562208641e-10,   9.435857018519774e-12,  -1.758909380286790e-13,
   3.150412604705714e-15,  -5.278643648723310e-17,   7.640889514159351e-19,  -1.111219329807307e-03,   3.584236545133942e-05,  -8.671793971101755e-07,   1.864780258704746e-08,
  -3.757424553546256e-10,   7.253446417387005e-12,  -1.352247888953263e-13,   2.422096231023548e-15,  -4.057354951580264e-17,   5.866990964205098e-19,  -7.484595373724581e-04,
   2.414277903266276e-05,  -5.841561052613328e-07,   1.256273222898481e-08,  -2.531566584517589e-10,   4.887526069165513e-12,  -9.112554059128190e-14,   1.632239174124704e-15,
  -2.733718131886652e-17,   3.949764814892754e-19,  -4.132730478820382e-04,   1.333118470158129e-05,  -3.225725134636800e-07,   6.937509471241628e-09,  -1.398084591883670e-10,
   2.699351783041174e-12,  -5.033071188630359e-14,   9.015330555164453e-16,  -1.509747454446438e-17,   2.180300778789254e-19,  -1.567173060383286e-04,   5.055375276615324e-06,
  -1.223258884237432e-07,   2.630888926859611e-09,  -5.302023078739689e-11,   1.023711368637670e-12,  -1.908796275555405e-14,   3.419085733562809e-16,  -5.725518957774927e-18,
   8.267033983714092e-20,  -1.786790289061065e-05,   5.763825426332776e-07,  -1.394687319021361e-08,   2.999592760286455e-10,  -6.045092200747535e-12,   1.167187099035380e-13,
  -2.176325918967181e-15,   3.898294534484367e-17,  -6.527946185535840e-19,   9.425374659052997e-21,  -5.701777118459751e-03,   1.838808209037322e-04,  -4.447883575382915e-06,
   9.561945654227512e-08,  -1.925855033381334e-09,   3.714636704330039e-11,  -6.910134555006400e-13,   1.229797281292713e-14,  -2.019662099237326e-16,   2.725404562791334e-18,
  -5.272161267881237e-03,   1.700321196488613e-04,  -4.113100897040088e-06,   8.842779301686001e-08,  -1.781135703177463e-09,   3.435754521668405e-11,  -6.391716361573337e-13,
   1.137521380217584e-14,  -1.867701111311997e-16,   2.517904619238082e-18,  -4.478216418895907e-03,   1.444354399840392e-04,  -3.494196496600520e-06,   7.512947477188986e-08,
  -1.513454250713769e-09,   2.919762455998033e-11,  -5.432305631416429e-13,   9.667583687860399e-15,  -1.586738245738754e-16,   2.135718855024837e-18,  -3.440680036992262e-03,
   1.109790496156828e-04,  -2.685046839927774e-06,   5.773792375832346e-08,  -1.163252289974761e-09,   2.244442325796538e-11,  -4.176272740869749e-13,   7.432133199813632e-15,
  -1.219353867070350e-16,   1.638434187530140e-18,  -2.317463095818213e-03,   7.475351113706802e-05,  -1.808722015611554e-06,   3.889712773089939e-08,  -7.837411077519105e-10,
   1.512347006416953e-11,  -2.814272793791757e-13,   5.008220622064416e-15,  -8.214185385395699e-17,   1.102246463651287e-18,  -1.279621661590059e-03,   4.127747104696397e-05,
  -9.987809652625452e-07,   2.148013362346906e-08,  -4.328291523505884e-10,   8.352584521216098e-12,  -1.554373584007906e-13,   2.766102905850054e-15,  -4.535979688236921e-17,
   6.082000845900960e-19,  -4.852454341534368e-04,   1.565300542760703e-05,  -3.787575294936883e-07,   8.145840226452463e-09,  -1.641438391348606e-10,   3.167659953243954e-12,
  -5.894955166023759e-14,   1.049039375783385e-15,  -1.720145241062329e-17,   2.305754297760806e-19,  -5.532457464129059e-05,   1.784658620513765e-06,  -4.318368987306640e-08,
   9.287432463845340e-10,  -1.871483009566128e-11,   3.611614981866399e-13,  -6.721166105733422e-15,   1.196067359995493e-16,  -1.961209936492642e-18,   2.628759480579525e-20,
  -1.731438498695935e-04,   5.245598537567310e-06,  -1.192000560497854e-07,   2.407567600005810e-09,  -4.557951034026794e-11,   8.278711706203267e-13,  -1.458887570647455e-14,
   2.502487642577534e-16,  -4.152342011316004e-18,   6.508253001615298e-20,  -1.600971562565807e-04,   4.850492023267756e-06,  -1.102265291330761e-07,   2.226444027038090e-09,
  -4.215325100631530e-11,   7.656955268222931e-13,  -1.349424605940111e-14,   2.314874226008294e-16,  -3.841111753456976e-18,   6.019763932221101e-20,  -1.359868417434469e-04,
   4.120238657470004e-06,  -9.363835675025372e-08,   1.891551657711321e-09,  -3.581654362842443e-11,   6.506705034218657e-13,  -1.146855025710623e-14,   1.967588517157456e-16,
  -3.264956636337329e-18,   5.115869965958406e-20,  -1.044799086652967e-04,   3.165796555541592e-06,  -7.195274816946289e-08,   1.453626896241953e-09,  -2.752754029407299e-11,
   5.001502059976016e-13,  -8.816699909822303e-15,   1.512800236528960e-16,  -2.510377042743462e-18,   3.932739889173517e-20,  -7.037180911225836e-05,   2.132398654965477e-06,
  -4.846840567422987e-08,   9.792569817510284e-10,  -1.854597568456335e-11,   3.369973438864026e-13,  -5.941250538724395e-15,   1.019512363516125e-16,  -1.691846391532244e-18,
   2.650021092840658e-20,  -3.885670473290724e-05,   1.177461961016719e-06,  -2.676407245461629e-08,   5.407653118826083e-10,  -1.024198376589025e-11,   1.861170320175122e-13,
  -3.281435848216971e-15,   5.631201815481003e-17,  -9.344925702137155e-19,   1.463608600309963e-20,  -1.473483498021169e-05,   4.465092021522822e-07,  -1.014942290281720e-08,
   2.050713518092585e-10,  -3.884083932576855e-12,   7.058300104203791e-14,  -1.244479753396797e-15,   2.135666670879546e-17,  -3.544137775397528e-19,   5.550663669363510e-21,
  -1.679971091856841e-06,   5.090818870818284e-08,  -1.157176253169113e-09,   2.338106672116083e-11,  -4.428425245792646e-13,   8.047526262324027e-15,  -1.418899912431582e-16,
   2.434999065464306e-18,  -4.040883378398571e-20,   6.328607788997804e-22,  -1.624780407324490e-03,   4.922465058855895e-05,  -1.118572012394177e-06,   2.259254981517374e-08,
  -4.277128344549223e-10,   7.768299917676696e-12,  -1.368696693883982e-13,   2.346302264456092e-15,  -3.885428893020984e-17,   6.053619373824036e-19,  -1.502350345954503e-03,
   4.551697452369844e-05,  -1.034364533381754e-06,   2.089289087151654e-08,  -3.955611938600531e-10,   7.184875168337893e-12,  -1.265999632539494e-13,   2.170390368255924e-15,
  -3.594162708875294e-17,   5.599050321270816e-19,  -1.276099360614279e-03,   3.866428334747129e-05,  -8.787013049010122e-07,   1.775026961766836e-08,  -3.360982414903989e-10,
   6.105539684557980e-12,  -1.075951643826534e-13,   1.844769707519417e-15,  -3.054990649657116e-17,   4.758043825573038e-19,  -9.804385698877636e-04,   2.970780704492028e-05,
  -6.752037921312040e-07,   1.364079527694621e-08,  -2.583151833862493e-10,   4.693136665500165e-12,  -8.271599917259491e-14,   1.418360805572687e-15,  -2.348889363371716e-17,
   3.657434071735066e-19,  -6.603684552071525e-04,   2.001041022737359e-05,  -4.548269813827320e-07,   9.189320779012209e-09,  -1.740332304030410e-10,   3.162198127741979e-12,
  -5.573919849853589e-14,   9.558626025701696e-16,  -1.582987701679873e-17,   2.464386227579516e-19,  -3.646309850834273e-04,   1.104929268721571e-05,  -2.511537588721429e-07,
   5.074526884432131e-09,  -9.610955368392195e-11,   1.746419737017714e-12,  -3.078551472164149e-14,   5.279621809184179e-16,  -8.743562495559547e-18,   1.361042731296558e-19,
  -1.382715655069452e-04,   4.190038426087349e-06,  -9.524207183977771e-08,   1.924383946696888e-09,  -3.644777963628932e-11,   6.623119632235286e-13,  -1.167535794462201e-14,
   2.002325699822598e-16,  -3.316054359861760e-18,   5.161631197912871e-20,  -1.576483436626886e-05,   4.777219951126852e-07,  -1.085892911192155e-08,   2.194072894011751e-10,
  -4.155581338449158e-12,   7.551354820365121e-14,  -1.331171799567376e-15,   2.282968778942052e-17,  -3.780829644035217e-19,   5.885040438801360e-21,  -5.030824705114284e-03,
   1.524147936248934e-04,  -3.463443721921481e-06,   6.995316062120685e-08,  -1.324287982062499e-09,   2.404913920035274e-11,  -4.234978333737992e-13,   7.246206153972147e-15,
  -1.192691101413790e-16,   1.823695100983639e-18,  -4.651743215193708e-03,   1.409346779073290e-04,  -3.202711400324431e-06,   6.469051630218281e-08,  -1.224739620354217e-09,
   2.224295363674018e-11,  -3.917204352686117e-13,   6.702854299927523e-15,  -1.103242172595535e-16,   1.686552318493555e-18,  -3.951199903776560e-03,   1.197166194298364e-04,
  -2.720730051017543e-06,   5.496003702155106e-08,  -1.040629704359106e-09,   1.890152119189523e-11,  -3.329148894613422e-13,   5.697130692138978e-15,  -9.376847279067559e-17,
   1.432942552803772e-18,  -3.035742280242380e-03,   9.198458938794468e-05,  -2.090639021167868e-06,   4.223589807825293e-08,  -7.997970445616300e-10,   1.452898700080371e-11,
  -2.559338094166702e-13,   4.380183758588076e-15,  -7.209110082660750e-17,   1.101250628261259e-18,  -2.044705809729117e-03,   6.195843956055442e-05,  -1.408284493360987e-06,
   2.845282797929318e-08,  -5.388426331278584e-10,   9.789505727753191e-12,  -1.724634319047568e-13,   2.951851021049854e-15,  -4.858191583971024e-17,   7.419024379221955e-19,
  -1.129010763175411e-03,   3.421203889164795e-05,  -7.776494304520216e-07,   1.571222083863908e-08,  -2.975748852837046e-10,   5.406547964490950e-12,  -9.525365772056735e-14,
   1.630414148198729e-15,  -2.683321989463161e-17,   4.097022343845763e-19,  -4.281317059805079e-04,   1.297365918635162e-05,  -2.948988029157239e-07,   5.958456028458041e-09,
  -1.128497940542093e-10,   2.050377993336024e-12,  -3.612476636438525e-14,   6.183415038098698e-16,  -1.017656541004607e-17,   1.553702826260200e-19,  -4.881282284593971e-05,
   1.479175539706032e-06,  -3.362259066403772e-08,   6.793491946987295e-10,  -1.286653122038082e-11,   2.337739921538423e-13,  -4.118782751256450e-15,   7.050069672714349e-17,
  -1.160288273923044e-18,   1.771445729241194e-20,  -1.539016674288394e-04,   4.396309294270230e-06,  -9.419419123953877e-08,   1.793868592988130e-09,  -3.202511071231521e-11,
   5.487417015302731e-13,  -9.135177965282526e-15,   1.486543234826769e-16,  -2.366248958618298e-18,   3.657246305466181e-20,  -1.423043870595873e-04,   4.065142961864436e-06,
  -8.710208198158855e-08,   1.658884194824755e-09,  -2.961701336325543e-11,   5.075136206096522e-13,  -8.449461601443160e-15,   1.375063316911140e-16,  -2.188937480238259e-18,
   3.383254778920530e-20,  -1.208729045025765e-04,   3.453084547894045e-06,  -7.399247498393918e-08,   1.409319982432485e-09,  -2.516379476765032e-11,   4.312512506923768e-13,
  -7.180665465050635e-15,   1.168726005358199e-16,  -1.860668010102932e-18,   2.875957894182686e-20,  -9.286714514417109e-05,   2.653153244230590e-06,  -5.685543617696886e-08,
   1.083005548379290e-09,  -1.933931384856035e-11,   3.314713511454059e-13,  -5.519967697920283e-15,   8.985498630813572e-17,  -1.430693411413864e-18,   2.211429244491259e-20,
  -6.254978978370869e-05,   1.787077548953753e-06,  -3.829800340604669e-08,   7.295644233577729e-10,  -1.302892368321120e-11,   2.233332451861462e-13,  -3.719530634870276e-15,
   6.055348089880781e-17,  -9.642316550804157e-19,   1.490451394008845e-20,  -3.453757587228601e-05,   9.867778290276183e-07,  -2.114781169345216e-08,   4.028743209303448e-10,
  -7.195059606320153e-12,   1.233395208763620e-13,  -2.054293721645804e-15,   3.344565147212033e-17,  -5.326031911000520e-19,   8.232768210093325e-21,  -1.309696570806822e-05,
   3.741984392888914e-07,  -8.019605849663638e-09,   1.527789156596267e-10,  -2.728573845690711e-12,   4.677483007098887e-14,  -7.790800468064109e-16,   1.268437342253021e-17,
  -2.019953243742833e-19,   3.122378639470486e-21,  -1.493231505905158e-06,   4.266375214582508e-08,  -9.143467567112892e-10,   1.741896568958491e-11,  -3.110970494287972e-13,
   5.333027604662763e-15,  -8.882705899381201e-17,   1.446218282927865e-18,  -2.303071936276536e-20,   3.560017276650863e-22,  -1.444211934141354e-03,   4.125492870640770e-05,
  -8.839174389138342e-07,   1.683364035668165e-08,  -3.005225549471080e-10,   5.149314663937225e-12,  -8.571900200219584e-14,   1.394624973193743e-15,  -2.218566848417148e-17,
   3.422562265005424e-19,  -1.335383154095963e-03,   3.814726668281550e-05,  -8.173651495440272e-07,   1.556694842691860e-08,  -2.779250474184265e-10,   4.762435864845930e-12,
  -7.928463077135095e-14,   1.290036876137825e-15,  -2.052314290354907e-17,   3.166117068576587e-19,  -1.134270304620458e-03,   3.240371577503067e-05,  -6.943447157390992e-07,
   1.322504095088127e-08,  -2.361361904593454e-10,   4.046800166758935e-12,  -6.737898495823292e-14,   1.096456412125113e-15,  -1.744523465886484e-17,   2.691328755927439e-19,
  -8.714644977305751e-04,   2.489716728254253e-05,  -5.335308983864357e-07,   1.016291037822128e-08,  -1.814794564617896e-10,   3.110479482350069e-12,  -5.179598445729817e-14,
   8.429853597469494e-16,  -1.341379755055226e-17,   2.069420374710343e-19,  -5.869666936810753e-04,   1.676992038748874e-05,  -3.593881171268265e-07,   6.846223308541190e-09,
  -1.222629698946603e-10,   2.095726862256527e-12,  -3.490177594431925e-14,   5.680889221361945e-16,  -9.040332017790421e-18,   1.394719058110946e-19,  -3.241003173245721e-04,
   9.259914681526161e-06,  -1.984508733693602e-07,   3.780567518797548e-09,  -6.751819018208996e-11,   1.157400159872905e-12,  -1.927621790408845e-14,   3.137736682433167e-16,
  -4.993505153014218e-18,   7.703904662068990e-20,  -1.229018144663045e-04,   3.511474943820286e-06,  -7.525590864364467e-08,   1.433675406285069e-09,  -2.560484238023701e-11,
   4.389282069742999e-13,  -7.310403237233442e-15,   1.189996583062685e-16,  -1.893836935249811e-18,   2.921790752506685e-20,  -1.401247171174340e-05,   4.003562840986808e-07,
  -8.580221681797913e-09,   1.634593530245342e-10,  -2.919323925618023e-12,   5.004435576019637e-14,  -8.334979353519431e-16,   1.356783394697918e-17,  -2.159278648478151e-19,
   3.331312735182704e-21,  -4.471728658609299e-03,   1.277380695313104e-04,  -2.736882480494703e-06,   5.212211529992495e-08,  -9.305040256500381e-10,   1.594323209234104e-11,
  -2.653641101914029e-13,   4.315071577567393e-15,  -6.851886844990335e-17,   1.051077717915064e-18,  -4.134760957999344e-03,   1.181157829231789e-04,  -2.530815953812287e-06,
   4.820004816592368e-08,  -8.605356295021722e-10,   1.474538088249220e-11,  -2.454447384568155e-13,   3.991455619371628e-15,  -6.338358022795921e-17,   9.722888587429914e-19,
  -3.512053118940314e-03,   1.003319658455097e-04,  -2.149906541550347e-06,   4.094878374136650e-08,  -7.311453032377604e-10,   1.252963671926150e-11,  -2.085876489172421e-13,
   3.392487597506714e-15,  -5.387680929900000e-17,   8.264378171472520e-19,  -2.698324724543485e-03,   7.708936081463545e-05,  -1.651977095857629e-06,   3.146748781377992e-08,
  -5.619123585198666e-10,   9.630612690444757e-12,  -1.603465366951159e-13,   2.608221663615942e-15,  -4.142556550971257e-17,   6.354269422509701e-19,  -1.817431170353391e-03,
   5.192488080188250e-05,  -1.112777046627859e-06,   2.119800714109243e-08,  -3.785611420129197e-10,   6.488751510509709e-12,  -1.080464541207820e-13,   1.757676175083294e-15,
  -2.791865442172153e-17,   4.282355281520754e-19,  -1.003515234110915e-03,   2.867157117835026e-05,  -6.144654375314594e-07,   1.170579650562811e-08,  -2.090556319221509e-10,
   3.583520846586281e-12,  -5.967391488293954e-14,   9.708182451719115e-16,  -1.542097344219572e-17,   2.365346363745190e-19,  -3.805421856255238e-04,   1.087261678461637e-05,
  -2.330156276756087e-07,   4.439098745838311e-09,  -7.927991598367330e-11,   1.359001272781590e-12,  -2.263100954365607e-14,   3.681855428278576e-16,  -5.848539599428133e-18,
   8.970742705895718e-20,  -4.338696409289575e-05,   1.239627371387711e-06,  -2.656702678551430e-08,   5.061202874874917e-10,  -9.039061896638054e-12,   1.549463931720755e-13,
  -2.580281597953384e-15,   4.197893995097602e-17,  -6.668271977614292e-19,   1.022807585553376e-20,  -1.376984908720666e-04,   3.720913771647580e-06,  -7.541506871339980e-08,
   1.358628712285096e-09,  -2.294512278600573e-11,   3.719714906929112e-13,  -5.861284571021380e-15,   9.040926135607583e-17,  -1.369791394244475e-18,   2.036840435791033e-20,
  -1.273218120833712e-04,   3.440602723583689e-06,  -6.973617351211706e-08,   1.256375892460806e-09,  -2.121933493596144e-11,   3.440149416617572e-13,  -5.421134508454444e-15,
   8.362626187976461e-17,  -1.267117632521910e-18,   1.884285278458155e-20,  -1.081462066976670e-04,   2.922547293864151e-06,  -5.923929150149352e-08,   1.067338656235060e-09,
  -1.802816287080920e-11,   2.923076165258003e-13,  -4.606825903494116e-15,   7.107345933304331e-17,  -1.077048885291216e-18,   1.601804949372616e-20,  -8.308872689769071e-05,
   2.245494698178952e-06,  -4.551835681033182e-08,   8.201848602054535e-10,  -1.385480141794297e-11,   2.246646349158056e-13,  -3.541181148806002e-15,   5.463993518144292e-17,
  -8.281234505142314e-19,   1.231732544972940e-20,  -5.596339277764674e-05,   1.512479329060854e-06,  -3.066088149410733e-08,   5.525042393414060e-10,  -9.333727508944178e-12,
   1.513650222465922e-13,  -2.386050807190524e-15,   3.682019403448820e-17,  -5.581048085580404e-19,   8.301835264539289e-21,  -3.090074697566269e-05,   8.351477700733245e-07,
  -1.693052519627402e-08,   3.050958508361216e-10,  -5.154347131907125e-12,   8.359202601760022e-14,  -1.317778785390167e-15,   2.033641934559447e-17,  -3.082691129274000e-19,
   4.585742804876700e-21,  -1.171783612439276e-05,   3.166978561445492e-07,  -6.420320414309683e-09,   1.156986165940847e-10,  -1.954664541251341e-12,   3.170087310242508e-14,
  -4.997556454572634e-16,   7.712573118118143e-18,  -1.169134607601362e-19,   1.739210716277274e-21,  -1.335991849207409e-06,   3.610788646249774e-08,  -7.320055756805091e-10,
   1.319127516397191e-11,  -2.228599146272800e-13,   3.614366946880883e-15,  -5.697970414501492e-17,   8.793532401348110e-19,  -1.333000147670372e-20,   1.982984003169559e-22,
  -1.292161463956841e-03,   3.491702306589852e-05,  -7.076943538807731e-07,   1.274935908094218e-08,  -2.153167044179168e-10,   3.490565346646182e-12,  -5.500134548556838e-14,
   8.483419460015848e-16,  -1.285087221048584e-17,   1.909766287077766e-19,  -1.194786798702724e-03,   3.228658658385555e-05,  -6.544036502922125e-07,   1.178981957441514e-08,
  -1.991219353036099e-10,   3.228222175283182e-12,  -5.087104475519767e-14,   7.846944347009028e-16,  -1.188761230654107e-17,   1.766722491625100e-19,  -1.014843081305425e-03,
   2.742515885405438e-05,  -5.559010000611273e-07,   1.001589591781663e-08,  -1.691760215041577e-10,   2.743002673599656e-12,  -4.322969989054718e-14,   6.669067694686644e-16,
  -1.010444200100303e-17,   1.501857726630654e-19,  -7.797039045694766e-04,   2.107170307636857e-05,  -4.271438673256792e-07,   7.696607012917500e-09,  -1.300132568872095e-10,
   2.108243651698873e-12,  -3.322985965845132e-14,   5.127050747575123e-16,  -7.769108266802367e-18,   1.154869454280916e-19,  -5.251600005304598e-04,   1.419309311072473e-05,
  -2.877214472083924e-07,   5.184694581508841e-09,  -8.758756410736377e-11,   1.420403083290318e-12,  -2.239030479233887e-14,   3.454962445530859e-16,  -5.235898273743171e-18,
   7.783742685285870e-20,  -2.899723460763472e-04,   7.837019544046885e-06,  -1.588759022532672e-07,   2.863016591489398e-09,  -4.836831891115421e-11,   7.844240908690357e-13,
  -1.236581668595618e-14,   1.908234051697700e-16,  -2.892045156997746e-18,   4.299548251807501e-20,  -1.099600742533550e-04,   2.971889978154273e-06,  -6.024823132989435e-08,
   1.085714728563825e-09,  -1.834254375814812e-11,   2.974796715358765e-13,  -4.689623652106386e-15,   7.236963919694657e-17,  -1.096830278975246e-18,   1.630665473667585e-20,
  -1.253693611868413e-05,   3.388360982817130e-07,  -6.869134001467623e-09,   1.237868019112846e-10,  -2.091314212294273e-12,   3.391706871388183e-14,  -5.346880414032000e-16,
   8.251263848877652e-18,  -1.250561599027329e-19,   1.859224388281862e-21,  -4.000933185872840e-03,   1.081139469573402e-04,  -2.191241434645766e-06,   3.947596507050978e-08,
  -6.666862380733267e-10,   1.080776987297104e-11,  -1.702933321235673e-13,   2.626217374817785e-15,  -3.976131527735196e-17,   5.898754618444006e-19,  -3.699430981581882e-03,
   9.996929872067429e-05,  -2.026236871074465e-06,   3.650493347661513e-08,  -6.165422846046644e-10,   9.995481332817447e-12,  -1.575051986333758e-13,   2.429181230384899e-15,
  -3.678081697713041e-17,   5.456873087204373e-19,  -3.142269349222849e-03,   8.491680874218998e-05,  -1.721242083848703e-06,   3.101231627165636e-08,  -5.238205886384241e-10,
   8.493105013329617e-12,  -1.338462788566602e-13,   2.064542541885621e-15,  -3.126344062773560e-17,   4.638704938151717e-19,  -2.414205433260232e-03,   6.524453657629388e-05,
  -1.322570025994644e-06,   2.383107934947522e-08,  -4.025607124926947e-10,   6.527712660692323e-12,  -1.028850855994104e-13,   1.587178060536777e-15,  -2.403771367092526e-17,
   3.566915325434114e-19,  -1.626058455241455e-03,   4.394622395822661e-05,  -8.908749274928758e-07,   1.605342036440770e-08,  -2.711978197266632e-10,   4.397965382525545e-12,
  -6.932402838678334e-14,   1.069549362978435e-15,  -1.619985949805791e-17,   2.404041828372964e-19,  -8.978444372134757e-04,   2.426584630685936e-05,  -4.919291184446390e-07,
   8.864786167098145e-09,  -1.497630705697154e-10,   2.428796381798659e-12,  -3.828657475368496e-14,   5.907297392800018e-16,  -8.947959245151768e-18,   1.327922409481609e-19,
  -3.404705390697299e-04,   9.201894297336616e-06,  -1.865472290275128e-07,   3.361709091076341e-09,  -5.679411090111878e-11,   9.210802527058559e-13,  -1.451983474818521e-14,
   2.240337690187334e-16,  -3.393578794752384e-18,   5.036320578191236e-20,  -3.881824769212290e-05,   1.049141786347190e-06,  -2.126897147845078e-08,   3.832822806636699e-10,
  -6.475346757704188e-12,   1.050167293406910e-13,  -1.655480800789610e-15,   2.554333112442416e-17,  -3.869220902199610e-19,   5.742223194184813e-21,  -1.239263443385923e-04,
   3.177086005653575e-06,  -6.109135818294002e-08,   1.044158596756300e-09,  -1.673034695148731e-11,   2.573291452827896e-13,  -3.847647308129484e-15,   5.634305547925630e-17,
  -8.115828401987180e-19,   1.151931928229386e-20,  -1.145872076194013e-04,   2.937728337588868e-06,  -5.649057498108668e-08,   9.655608008579064e-10,  -1.547171424100834e-11,
   2.379831278322218e-13,  -3.558602288831503e-15,   5.211402940956418e-17,  -7.507224964389808e-19,   1.065628233569138e-20,  -9.732911085962476e-05,   2.495369932163012e-06,
  -4.798677365889536e-08,   8.202627649620838e-10,  -1.314453361699749e-11,   2.022049687986610e-13,  -3.023914032572489e-15,   4.428880682656475e-17,  -6.380750889614968e-19,
   9.058392068673825e-21,  -7.477761266370352e-05,   1.917262080914406e-06,  -3.687157656014929e-08,   6.303077797279214e-10,  -1.010136963320856e-11,   1.554061449950733e-13,
  -2.324303502306796e-15,   3.404628392434001e-17,  -4.905731477609475e-19,   6.965291935653514e-21,  -5.036536356320540e-05,   1.291385171096367e-06,  -2.483616875244918e-08,
   4.245890499205262e-10,  -6.804939271378041e-12,   1.046995138204110e-13,  -1.566052523277167e-15,   2.294163605358835e-17,  -3.305998789587192e-19,   4.694425555018766e-21,
  -2.780968174568554e-05,   7.130629685878394e-07,  -1.371410322976819e-08,   2.344579734798676e-10,  -3.757825024849224e-12,   5.781968393489939e-14,  -8.648857243467636e-16,
   1.267069841922133e-17,  -1.826015197613907e-19,   2.593042632682303e-21,  -1.054566871711972e-05,   2.704014450855238e-07,  -5.200589403111198e-09,   8.891093823253122e-11,
  -1.425058785219487e-12,   2.192698799137450e-14,  -3.279971072868416e-16,   4.805302824235897e-18,  -6.925229656869313e-20,   9.834426154517877e-22,  -1.202348751956984e-06,
   3.082945458498722e-08,  -5.929390695939208e-10,   1.013709527819342e-11,  -1.624770840304216e-13,   2.499996968637970e-15,  -3.739657649806868e-17,   5.478782667719499e-19,
  -7.895853478028390e-21,   1.121283705215467e-22,  -1.162923758407142e-03,   2.981374797708835e-05,  -5.732807829598107e-07,   9.798375180436135e-09,  -1.569974118619495e-10,
   2.414772570150294e-12,  -3.610614295842422e-14,   5.287132567432964e-16,  -7.615349844891485e-18,   1.080703865559271e-19,  -1.075285379080033e-03,   2.756761766162040e-05,
  -5.301070727168692e-07,   9.060814147223084e-09,  -1.451864147435855e-10,   2.233229844263512e-12,  -3.339375733775513e-14,   4.890287847019632e-16,  -7.044274926645800e-18,
   9.997355621850209e-20,  -9.133355462663723e-04,   2.341653015830823e-05,  -4.503074737955177e-07,   7.697338642421976e-09,  -1.233481744508164e-10,   1.897488163302121e-12,
  -2.837626687519693e-14,   4.155982312886689e-16,  -5.987264333448994e-18,   8.498255192256511e-20,  -7.017124795190508e-04,   1.799157101332966e-05,  -3.460025592336250e-07,
   5.914802714393323e-09,  -9.479115338513409e-11,   1.458328746318295e-12,  -2.181115387816522e-14,   3.194841847250140e-16,  -4.603203516925482e-18,   6.534572186787183e-20,
  -4.726281421520587e-04,   1.211834743022174e-05,  -2.330623952506513e-07,   3.984339945361495e-09,  -6.385748320090684e-11,   9.824985358364217e-13,  -1.469576224953420e-14,
   2.152801484189505e-16,  -3.102122223442116e-18,   4.404125100404810e-20,  -2.609658163354329e-04,   6.691376814889361e-06,  -1.286930274662997e-07,   2.200151580329826e-09,
  -3.526339305896793e-11,   5.425789725357725e-13,  -8.116046298016960e-15,   1.188995261802251e-16,  -1.713406828221890e-18,   2.432688342326271e-20,  -9.896046530604752e-05,
   2.537444854190950e-06,  -4.880228649880557e-08,   8.343394696795001e-10,  -1.337273761630915e-11,   2.057624980237919e-13,  -3.077909159721830e-15,   4.509208536886789e-17,
  -6.498157668445900e-19,   9.226260232509733e-21,  -1.128283043451283e-05,   2.893033388539893e-07,  -5.564135160012992e-09,   9.512641376405827e-11,  -1.524683357532747e-12,
   2.345993081322655e-14,  -3.509276840525473e-16,   5.141189718773474e-18,  -7.408923972902121e-20,   1.051942893413400e-21,  -3.600773113979286e-03,   9.231262265951993e-05,
  -1.775055331830719e-06,   3.033881094947177e-08,  -4.861125617752458e-10,   7.476869100137183e-12,  -1.117945580553552e-13,   1.636977377533728e-15,  -2.357476028556094e-17,
   3.343814456497098e-19,  -3.329417474580688e-03,   8.535790564702341e-05,  -1.641376117616868e-06,   2.805509304616679e-08,  -4.495420595670920e-10,   6.914757622075661e-12,
  -1.033962598937482e-13,   1.514107804924503e-15,  -2.180686968306981e-17,   3.093280045949892e-19,  -2.827970497000336e-03,   7.250484957964526e-05,  -1.394291778163941e-06,
   2.383334965471270e-08,  -3.819241098763483e-10,   5.875199339341595e-12,  -8.786072118480482e-14,   1.286755096681816e-15,  -1.853466805230235e-17,   2.629430019086474e-19,
  -2.172719760627293e-03,   5.570749129773021e-05,  -1.071331371587845e-06,   1.831406512226564e-08,  -2.935027366563658e-10,   4.515428390800472e-12,  -6.753332056548312e-14,
   9.891710354469921e-16,  -1.425003277483071e-17,   2.021839195823755e-19,  -1.463403507638823e-03,   3.752216710310310e-05,  -7.216335512431769e-07,   1.233675318101407e-08,
  -1.977225232302725e-10,   3.042113602358363e-12,  -4.550211116340520e-14,   6.665394653170885e-16,  -9.603157337338329e-18,   1.362659052765015e-19,  -8.080312129957423e-04,
   2.071858068464268e-05,  -3.984735775525498e-07,   6.812352202323987e-09,  -1.091863739909162e-10,   1.679989127847145e-12,  -2.512950458287998e-14,   3.681306065059385e-16,
  -5.304144120900062e-18,   7.526844401605567e-20,  -3.064123337789344e-04,   7.856717294318798e-06,  -1.511070341308029e-07,   2.583373970284161e-09,  -4.140613262589482e-11,
   6.371031240873169e-13,  -9.530050498714695e-15,   1.396117889394410e-16,  -2.011615383736390e-18,   2.854642666527603e-20,  -3.493514702441246e-05,   8.957729827798514e-07,
  -1.722829034971122e-08,   2.945409034714596e-10,  -4.720891347754853e-12,   7.263906371380440e-14,  -1.086568305885245e-15,   1.591788624482947e-17,  -2.293558501277946e-19,
   3.254753842483781e-21,  -1.121220528109816e-04,   2.734285105870719e-06,  -5.001263516394573e-08,   8.131164705026688e-10,  -1.239310182678770e-11,   1.813252810456874e-13,
  -2.579150642385613e-15,   3.593322744832015e-17,  -4.926836705063437e-19,   6.665893668758778e-21,  -1.036722602610404e-04,   2.528276215172917e-06,  -4.624584543372453e-08,
   7.519017112525733e-10,  -1.146058350350230e-11,   1.676897556756600e-13,  -2.385335046901587e-15,   3.323505385204024e-17,  -4.557204578280617e-19,   6.166246166814857e-21,
  -8.805775172652130e-05,   2.147556712527367e-06,  -3.928375354517637e-08,   6.387435005439383e-10,  -9.736488411174094e-12,   1.424745792130389e-13,  -2.026844679236336e-15,
   2.824311362506908e-17,  -3.873149597570915e-19,   5.241303572888828e-21,  -6.765419665176646e-05,   1.650014684266430e-06,  -3.018404972238845e-08,   4.908148876249609e-10,
  -7.482136534201174e-12,   1.094959458254080e-13,  -1.557843427428823e-15,   2.171019689959185e-17,  -2.977611489516901e-19,   4.029943662121664e-21,  -4.556735157714978e-05,
   1.111372031061428e-06,  -2.033133863400661e-08,   3.306185445324898e-10,  -5.040345760917540e-12,   7.376700570043846e-14,  -1.049594408283022e-15,   1.462847713156393e-17,
  -2.006525799727443e-19,   2.715936832410594e-21,  -2.516037240430615e-05,   6.136631098579718e-07,  -1.122654781530093e-08,   1.825658715930010e-10,  -2.783346456325313e-12,
   4.073672108531005e-14,  -5.796486174042025e-16,   8.079121520538980e-18,  -1.108239531559912e-19,   1.500147366521331e-21,  -9.541021660469319e-06,   2.327075993063900e-07,
  -4.257262440474090e-09,   6.923223342572258e-11,  -1.055507881848042e-12,   1.544851205573618e-14,  -2.198227661892787e-16,   3.063939342266042e-18,  -4.202992560842256e-20,
   5.689425731666467e-22,  -1.087805290521177e-06,   2.653183596891882e-08,  -4.853865802788611e-10,   7.893442303461738e-12,  -1.203429029077713e-13,   1.761354265120696e-15,
  -2.506305079196019e-17,   3.493355479484037e-19,  -4.792065269491748e-21,   6.486853872063342e-23,  -1.052152387391048e-03,   2.565850811443690e-05,  -4.693181416721848e-07,
   7.630277995312570e-09,  -1.162967584728746e-10,   1.701554581524471e-12,  -2.420270404605290e-14,   3.371955617563979e-16,  -4.623251811549634e-18,   6.254828139733332e-20,
  -9.728596061629997e-04,   2.372532244104907e-05,  -4.339706189810082e-07,   7.055839218642241e-09,  -1.075460147186262e-10,   1.573598949613146e-12,  -2.238394181906199e-14,
   3.118760325757106e-16,  -4.276395536942432e-18,   5.785990571892473e-20,  -8.263331912370287e-04,   2.015265387514305e-05,  -3.686384080980838e-07,   5.993963538317123e-09,
  -9.136712152635903e-11,   1.336979990015317e-12,  -1.901987441424702e-14,   2.650319134202839e-16,  -3.634490619284594e-18,   4.918084122229033e-20,  -6.348664044189217e-04,
   1.548372372517306e-05,  -2.832468650628646e-07,   4.605802701524689e-09,  -7.021230334334277e-11,   1.027508830959046e-12,  -1.461877489077121e-14,   2.037273540618842e-16,
  -2.794134104332253e-18,   3.781423979963670e-20,  -4.276036385973732e-04,   1.042910566125411e-05,  -1.907891082728210e-07,   3.102521589981387e-09,  -4.729856022173251e-11,
   6.922288229580050e-13,  -9.849375111735146e-15,   1.372728614797209e-16,  -1.882885498977959e-18,   2.548448578466145e-20,  -2.361047200720176e-04,   5.758609389341328e-06,
  -1.053498289127517e-07,   1.713196575234841e-09,  -2.611889862556810e-11,   3.822729715029451e-13,  -5.439412214276063e-15,   7.581405093529938e-17,  -1.039950744076710e-18,
   1.407634896248252e-20,  -8.953286589512548e-05,   2.183726127267023e-06,  -3.995011441799308e-08,   6.496746854446365e-10,  -9.904876664069664e-12,   1.449686781343381e-13,
  -2.062812886638421e-15,   2.875184526803553e-17,  -3.944007592565142e-19,   5.338564477252468e-21,  -1.020795556934620e-05,   2.489745224581480e-07,  -4.554863527966440e-09,
   7.407199496277644e-11,  -1.129296740638256e-12,   1.652853029523193e-14,  -2.351912180722376e-16,   3.278146362738990e-18,  -4.496782102633069e-20,   6.086815917866577e-22,
  -3.257790548206750e-03,   7.944670963142583e-05,  -1.453154716602642e-06,   2.362571008538299e-08,  -3.600908526547379e-10,   5.268538775364224e-12,  -7.493888547954785e-14,
   1.044048887187048e-15,  -1.431426216272955e-17,   1.936303209531919e-19,  -3.012275472328448e-03,   7.346096641622479e-05,  -1.343707808926017e-06,   2.184706925254384e-08,
  -3.329958343869237e-10,   4.872348587821128e-12,  -6.930744710969791e-14,   9.656527012541965e-16,  -1.324034125681807e-17,   1.791163839726118e-19,  -2.558584186418602e-03,
   6.239887500778951e-05,  -1.141418994654088e-06,   1.855917240308579e-08,  -2.829009603727575e-10,   4.139703157107261e-12,  -5.889127671096010e-14,   8.206105339617445e-16,
  -1.125290588656809e-17,   1.522484563312882e-19,  -1.965743552431835e-03,   4.794241727999471e-05,  -8.770202584795752e-07,   1.426099538939130e-08,  -2.173990785748515e-10,
   3.181484812603349e-12,  -4.526414206077558e-14,   6.307949593618936e-16,  -8.651037455408191e-18,   1.170608384636826e-19,  -1.323993661845267e-03,   3.229174999136589e-05,
  -5.907423300661472e-07,   9.606370258165990e-09,  -1.464510194763350e-10,   2.143354308172765e-12,  -3.049663938975109e-14,   4.250338508355433e-16,  -5.829679889777301e-18,
   7.889174962704599e-20,  -7.310535381141532e-04,   1.783044306371615e-05,  -3.261957874173055e-07,   5.304588589862168e-09,  -8.087221497128950e-11,   1.183635225182422e-12,
  -1.684206248254890e-14,   2.347407645287616e-16,  -3.219833994709154e-18,   4.357580541376504e-20,  -2.772215581720099e-04,   6.761494268225061e-06,  -1.236979610167024e-07,
   2.011594567309633e-09,  -3.066857168164884e-11,   4.488678160661027e-13,  -6.387091476161953e-15,   8.902347168389477e-17,  -1.221120216327423e-18,   1.652645754354168e-20,
  -3.160700062923892e-05,   7.709024430832165e-07,  -1.410327202629655e-08,   2.293498977176991e-10,  -3.496653135021720e-12,   5.117743633288868e-14,  -7.282230167176254e-16,
   1.015002572166468e-17,  -1.392266961262880e-19,   1.884279954428938e-21,  -1.019277388716928e-04,   2.370098032659873e-06,  -4.133533165735035e-08,   6.407883231164364e-10,
  -9.312444144493895e-12,   1.299171440130965e-13,  -1.762037953102563e-15,   2.340907777714132e-17,  -3.061047066509920e-19,   3.951691851683928e-21,  -9.424603288539343e-05,
   2.191519593902787e-06,  -3.822184287563421e-08,   5.925414304076265e-10,  -8.611613661717652e-12,   1.201453136475379e-13,  -1.629588412304908e-15,   2.165070475683652e-17,
  -2.831297417017293e-19,   3.655348021188040e-21,  -8.005099383580239e-05,   1.861498677040172e-06,  -3.246738407469487e-08,   5.033583481506238e-10,  -7.315946958022067e-12,
   1.020762903386667e-13,  -1.384626293346512e-15,   1.839788184273085e-17,  -2.406172901495264e-19,   3.106845049693804e-21,  -6.150244995066351e-05,   1.430220448729808e-06,
  -2.494634761706286e-08,   3.867775186128723e-10,  -5.621906613843960e-12,   7.844620615789520e-14,  -1.064188289915257e-15,   1.414156171508068e-17,  -1.849714497982711e-19,
   2.388636102478042e-21,  -4.142383594232570e-05,   9.633239138886237e-07,  -1.680318512253165e-08,   2.605343378450464e-10,  -3.787130767499253e-12,   5.284761173802452e-14,
  -7.169724312808716e-16,   9.528306060994883e-18,  -1.246410350061960e-19,   1.609710085614473e-21,  -2.287246264517971e-05,   5.319141826042918e-07,  -9.278326724596926e-09,
   1.438646342744720e-10,  -2.091282041213088e-12,   2.918388516252619e-14,  -3.959477089519589e-16,   5.262242954406755e-18,  -6.883957527290746e-20,   8.890959781157932e-22,
  -8.673422350436506e-06,   2.017073027353426e-07,  -3.518463302065298e-09,   5.455587811845079e-11,  -7.930582380808169e-13,   1.106729220456973e-14,  -1.501560120131673e-16,
   1.995644723071936e-18,  -2.610710720475632e-20,   3.371927040699670e-22,  -9.888871609791082e-07,   2.299737554614054e-08,  -4.011531714743795e-10,   6.220129709176033e-12,
  -9.041985268149369e-14,   1.261830590080850e-15,  -1.711998966317194e-17,   2.275334408190474e-19,  -2.976611287709783e-21,   3.844527970644549e-23,  -9.564890323243658e-04,
   2.224097972597421e-05,  -3.878903997314003e-07,   6.013152154799151e-09,  -8.738789590232435e-11,   1.219141322498054e-12,  -1.653494537212002e-14,   2.196703400788531e-16,
  -2.872469859684430e-18,   3.708192815172916e-20,  -8.844039688591107e-04,   2.056520117961734e-05,  -3.586734475579846e-07,   5.560403725399958e-09,  -8.081130866628117e-11,
   1.127442553142332e-12,  -1.529204027602694e-14,   2.031698000533858e-16,  -2.656873981568128e-18,   3.430109073035320e-20,  -7.511978434741317e-04,   1.746828771023931e-05,
  -3.046736552484729e-07,   4.723510442678060e-09,  -6.865278343932850e-11,   9.578829990377138e-13,  -1.299331834141738e-14,   1.726453704120717e-16,  -2.257939380318974e-18,
   2.915403891731368e-20,  -5.771384658393968e-04,   1.342117649377159e-05,  -2.340963132754520e-07,   3.629516933335406e-09,  -5.275592339176363e-11,   7.361384993725136e-13,
  -9.986331521867726e-15,   1.327041427066723e-16,  -1.735761813456977e-18,   2.241450024364851e-20,  -3.887209232171204e-04,   9.039823392576849e-06,  -1.576809458783014e-07,
   2.444852002541658e-09,  -3.553840260247348e-11,   4.959215173670874e-13,  -6.728061610604482e-15,   8.941343985597597e-17,  -1.169624513946247e-18,   1.510520696826498e-20,
  -2.146349944042427e-04,   4.991478153323910e-06,  -8.706773885030346e-08,   1.350024500067813e-09,  -1.962457271661677e-11,   2.738613181216195e-13,  -3.715569053727177e-15,
   4.938078593165287e-17,  -6.459867192313508e-19,   8.343103478811067e-21,  -8.139132136888207e-05,   1.892819608681781e-06,  -3.301722961818515e-08,   5.119518945984897e-10,
  -7.442051695981273e-12,   1.038553713502949e-13,  -1.409062405633832e-15,   1.872709138673761e-17,  -2.449876302710879e-19,   3.164150571890085e-21,  -9.279708685322046e-06,
   2.158071760003087e-07,  -3.764417939745989e-09,   5.836964409859678e-11,  -8.484991211062635e-13,   1.184100700427812e-14,  -1.606537993015234e-16,   2.135169396312226e-18,
  -2.793235340311818e-20,   3.607630051463967e-22,  -2.961587091685536e-03,   6.886498039794544e-05,  -1.201029140709945e-06,   1.861858647925936e-08,  -2.705800604457518e-10,
   3.774839736825270e-12,  -5.119729404852695e-14,   6.801654894786691e-16,  -8.893937590767234e-18,   1.148109887217927e-19,  -2.738389348431490e-03,   6.367624958805620e-05,
  -1.110564383170772e-06,   1.721673673885323e-08,  -2.502169042521005e-10,   3.490911898164142e-12,  -4.734887612817475e-14,   6.290748417970091e-16,  -8.226394359501295e-18,
   1.062010891478077e-19,  -2.325941815692996e-03,   5.408724370834056e-05,  -9.433642560175632e-07,   1.462545523482213e-08,  -2.125703347911067e-10,   2.965902915447029e-12,
  -4.023132338299823e-14,   5.345620085911924e-16,  -6.991185104808896e-18,   9.026504250161382e-20,  -1.786999926587213e-03,   4.155613050989883e-05,  -7.248348867873829e-07,
   1.123811158580382e-08,  -1.633487199518325e-10,   2.279313153640629e-12,  -3.092076405300298e-14,   4.108919401696671e-16,  -5.374382884336003e-18,   6.939844377570434e-20,
  -1.203600699602659e-03,   2.799010063407252e-05,  -4.882291777896048e-07,   7.570021057783217e-09,  -1.100379293991349e-10,   1.535526857798888e-12,  -2.083215485624600e-14,
   2.768508975501249e-16,  -3.621470040923701e-18,   4.676782807122568e-20,  -6.645765998036208e-04,   1.545516651785776e-05,  -2.695887592128901e-07,   4.180095107321054e-09,
  -6.076377070428573e-11,   8.479595951692820e-13,  -1.150454829270212e-14,   1.528977608363859e-16,  -2.000147398877772e-18,   2.583140712748079e-20,  -2.520128078787610e-04,
   5.860757343185387e-06,  -1.022315967193587e-07,   1.585162054229722e-09,  -2.304290286176024e-11,   3.215684465252718e-13,  -4.362891994095364e-15,   5.798470544874313e-17,
  -7.585471145191034e-19,   9.796648895553406e-21,  -2.873285999972770e-05,   6.682060380475173e-07,  -1.165580701801968e-08,   1.807305450378397e-10,  -2.627216744062151e-12,
   3.666343086591773e-14,  -4.974337345765399e-16,   6.611126409264664e-18,  -8.648602373807125e-20,   1.116972271545390e-21,  -9.306334530490931e-05,   2.067823811163072e-06,
  -3.446099955519912e-08,   5.104827597239620e-10,  -7.089107876316979e-12,   9.450559013741570e-14,  -1.224819447381067e-15,   1.554938544739266e-17,  -1.943080922758020e-19,
   2.397541628752935e-21,  -8.604955316190527e-05,   1.912014249184683e-06,  -3.186512609785180e-08,   4.720430142683664e-10,  -6.555523083030677e-12,   8.739590449058522e-14,
  -1.132729002415080e-15,   1.438103299215298e-17,  -1.797186588047823e-19,   2.217666823860907e-21,  -7.308884058824865e-05,   1.624075103261804e-06,  -2.706744954483777e-08,
   4.009905688499069e-10,  -5.569099824897781e-12,   7.425026047513691e-14,  -9.624237876011671e-16,   1.221991010526596e-17,  -1.527259495694601e-19,   1.884784466837733e-21,
  -5.615332682850563e-05,   1.247796675331024e-06,  -2.079710011597977e-08,   3.081142394684074e-10,  -4.279462377795623e-12,   5.706019148655520e-14,  -7.396683880221940e-16,
   9.392443933380114e-18,  -1.173998955903876e-19,   1.448988967246491e-21,  -3.782094612967327e-05,   8.404486553722980e-07,  -1.400825696733049e-08,   2.075441663959958e-10,
  -2.882762784142688e-12,   3.843946555231282e-14,  -4.983208789129139e-16,   6.328226670735472e-18,  -7.910536979783075e-20,   9.764308649718244e-22,  -2.088307394045620e-05,
   4.640654793279137e-07,  -7.734998438679045e-09,   1.146031958293037e-10,  -1.591868485753328e-12,   2.122705342475916e-14,  -2.751931137509775e-16,   3.494850632622908e-18,
  -4.368905599899427e-20,   5.392997474993649e-22,  -7.919026156223844e-06,   1.759782046800644e-07,  -2.933208087918142e-09,   4.345934257887410e-11,  -6.036679866599551e-13,
   8.049816219784618e-15,  -1.043613918234971e-16,   1.325371785036645e-18,  -1.656873345273844e-20,   2.045291135863579e-22,  -9.028757426610835e-07,   2.006390516316617e-08,
  -3.344259417837179e-10,   4.954968112270633e-12,  -6.882664637502895e-14,   9.177941943955776e-16,  -1.189871892960622e-17,   1.511120828517347e-19,  -1.889087321831719e-21,
   2.331949970171455e-23,  -8.733056386901427e-04,   1.940444100937934e-05,  -3.233817259353292e-07,   4.790365863094237e-09,  -6.652412777180205e-11,   8.868396442187206e-13,
  -1.149369465761938e-14,   1.459152614592229e-16,  -1.823383236824501e-18,   2.249839580703339e-20,  -8.074882730343333e-04,   1.794232540853105e-05,  -2.990220715497148e-07,
   4.429647619606765e-09,  -6.151697262791978e-11,   8.201224152829477e-13,  -1.062951874916485e-14,   1.349514547361561e-16,  -1.686476276134548e-18,   2.081046025910579e-20,
  -6.858650567730595e-04,   1.524030691875982e-05,  -2.540007156917985e-07,   3.762892077836482e-09,  -5.226038519696912e-11,   6.967638049727979e-13,  -9.031376144560808e-15,
   1.146715011934695e-16,  -1.433177222218341e-18,   1.768671032355723e-20,  -5.269423400789510e-04,   1.170931335999132e-05,  -1.951598101262410e-07,   2.891341395105674e-09,
  -4.015843840636257e-11,   5.354523455567983e-13,  -6.941041480424132e-15,   8.813858972632369e-17,  -1.101678234709400e-18,   1.359722955445000e-20,  -3.549114359410134e-04,
   7.886763014596750e-06,  -1.314533639160072e-07,   1.947592687206289e-09,  -2.705182134718521e-11,   3.607156137137062e-13,  -4.676238630562574e-15,   5.938400880307515e-17,
  -7.423231767510903e-19,   9.162771061417202e-21,  -1.959665877648338e-04,   4.354786500423643e-06,  -7.258515938283280e-08,   1.075435412150374e-09,  -1.493808027544661e-11,
   1.991944865299414e-13,  -2.582409695398608e-15,   3.279563949193778e-17,  -4.099772084804391e-19,   5.060757707309299e-21,  -7.431207391596070e-05,   1.651377971960768e-06,
  -2.752519968199338e-08,   4.078221000721353e-10,  -5.664815231365590e-12,   7.553940608021677e-14,  -9.793263587746037e-16,   1.243727409465346e-17,  -1.554806557762236e-19,
   1.919289384664468e-21,  -8.472578269340145e-06,   1.882795149444775e-07,  -3.138250185641920e-09,   4.649737850196781e-11,  -6.458686617890463e-13,   8.612572816006101e-15,
  -1.116574710212099e-16,   1.418034105250573e-18,  -1.772715677806072e-20,   2.188288375926370e-22,  -2.704025471528623e-03,   6.008217561573578e-05,  -1.001290253013289e-06,
   1.483246040405053e-08,  -2.059793586458196e-10,   2.745930891293581e-12,  -3.558804316164895e-14,   4.517986349373509e-16,  -5.645741677378764e-18,   6.966104221009032e-20,
  -2.500234467191172e-03,   5.555501164032270e-05,  -9.258651978942899e-07,   1.371556469783646e-08,  -1.904756513453042e-10,   2.539353635328340e-12,  -3.291228652203647e-14,
   4.178513076973857e-16,  -5.221836557607213e-18,   6.443473865941249e-20,  -2.123651218292205e-03,   4.718872325608375e-05,  -7.864650983133203e-07,   1.165108247345096e-08,
  -1.618143820222338e-10,   2.157397076101057e-12,  -2.796394136272885e-14,   3.550583173751826e-16,  -4.437546567999728e-18,   5.476276922228081e-20,  -1.631577132305603e-03,
   3.625567061141201e-05,  -6.042753810344633e-07,   8.952490891666412e-09,  -1.243429964975249e-10,   1.657926712337733e-12,  -2.149161695954803e-14,   2.729042424760344e-16,
  -3.411126170249641e-18,   4.210064187199878e-20,  -1.098916027109041e-03,   2.441986760935849e-05,  -4.070204388762317e-07,   6.030351802230658e-09,  -8.376083982416453e-11,
   1.116887537046197e-12,  -1.447908496806869e-14,   1.838711954342291e-16,  -2.298455100462783e-18,   2.837037544232502e-20,  -6.067734151807880e-04,   1.348377142948842e-05,
  -2.247461955159553e-07,   3.329882022269996e-09,  -4.625293554753517e-11,   6.167679772490453e-13,  -7.995941254293162e-15,   1.015454083105797e-16,  -1.269412330187497e-18,
   1.566945060120212e-20,  -2.300932592308276e-04,   5.113179053771034e-06,  -8.522656644889472e-08,   1.262743874686407e-09,  -1.754002716228167e-11,   2.338934550882373e-13,
  -3.032298107399815e-15,   3.850963403696990e-17,  -4.814147140192092e-19,   5.942629807292901e-21,  -2.623373356912933e-05,   5.829718504269496e-07,  -9.716997190572056e-09,
   1.439703240259510e-10,  -1.999809951136859e-12,   2.666719951416528e-14,  -3.457261565658794e-16,   4.390670658194948e-18,  -5.488859087390048e-20,   6.775522123117949e-22,
  -8.530717442401854e-05,   1.814844708580131e-06,  -2.895818462233640e-08,   4.107171005206338e-10,  -5.461006673514464e-12,   6.970427280590203e-14,  -8.649607517556887e-16,
   1.051387076875469e-17,  -1.257974646921473e-19,   1.486291901999344e-21,  -7.887781640575993e-05,   1.678092083395091e-06,  -2.677669563519120e-08,   3.797870033029497e-10,
  -5.049914418501928e-12,   6.445951654246609e-14,  -7.999129214178536e-16,   9.723664102638357e-18,  -1.163489677995883e-19,   1.374739436074207e-21,  -6.699714343323517e-05,
   1.425373505616839e-06,  -2.274496082686445e-08,   3.226171555311475e-10,  -4.289970998684654e-12,   5.476261686324792e-14,  -6.796268137421633e-16,   8.262133659325333e-18,
  -9.886967397973453e-20,   1.168323281770630e-21,  -5.147301339880094e-05,   1.095126224063837e-06,  -1.747579507613037e-08,   2.478902957337266e-10,  -3.296482739029479e-12,
   4.208323233284758e-14,  -5.223094869728875e-16,   6.350182428301346e-18,  -7.599722209264935e-20,   8.981363587148120e-22,  -3.466854518792006e-05,   7.376150939053203e-07,
  -1.177105398970473e-08,   1.669759503086667e-10,  -2.220569613773608e-12,   2.834947777726426e-14,  -3.518758594601517e-16,   4.278352291685072e-18,  -5.120590303051669e-20,
   6.052010964038573e-22,  -1.914243364208478e-05,   4.072835450595281e-07,  -6.499647490012201e-09,   9.220141869799849e-11,  -1.226193885597375e-12,   1.565498789760826e-14,
  -1.943174984271213e-16,   2.362738129515083e-18,  -2.827987759071152e-20,   3.342546557244406e-22,  -7.258958475793234e-06,   1.544458008470024e-07,  -2.464743989317455e-09,
   3.496415862101325e-11,  -4.649955350371395e-13,   5.936728991481915e-15,  -7.369057460227566e-17,   8.960285725574934e-19,  -1.072483751635068e-20,   1.267646814672212e-22,
  -8.276190685040221e-07,   1.760891616703267e-08,  -2.810145433997943e-10,   3.986397819992682e-12,  -5.301600845967967e-14,   6.768715686852783e-16,  -8.401791702234429e-18,
   1.021604647121869e-19,  -1.222792793755839e-21,   1.445312238030976e-23,  -8.005217972891030e-04,   1.703048726818314e-05,  -2.717433575377442e-07,   3.854165768548625e-09,
  -5.124604003951468e-11,   6.541043003729792e-13,  -8.116784225692947e-15,   9.866206751781172e-17,  -1.180481982208869e-18,   1.394733241446824e-20,  -7.401887564758044e-04,
   1.574720179968343e-05,  -2.512722834863239e-07,   3.563918000039874e-09,  -4.738835382521036e-11,   6.048875524088317e-13,  -7.506375947051497e-15,   9.124677533346644e-17,
  -1.091817392920821e-18,   1.290052630552510e-20,  -6.287006226208891e-04,   1.337569282101542e-05,  -2.134385184280142e-07,   3.027436636112784e-09,  -4.025705125621420e-11,
   5.138919286740826e-13,  -6.377612150737595e-15,   7.753178693237214e-17,  -9.277918959346949e-19,   1.096352129033306e-20,  -4.830223187686862e-04,   1.027665514729581e-05,
  -1.639927119590897e-07,   2.326200421069869e-09,  -3.093416590245560e-11,   3.949086925852912e-13,  -4.901347714474053e-15,   5.959005397990133e-17,  -7.131570657904642e-19,
   8.428092752218002e-21,  -3.253293323875266e-04,   6.921773750770227e-06,  -1.104594702546685e-07,   1.566900893666710e-09,  -2.083780631307809e-11,   2.660312571953420e-13,
  -3.302000025698759e-15,   4.014801886038781e-17,  -4.805156093493065e-19,   5.679194346081203e-21,  -1.796324340492349e-04,   3.821945313493738e-06,  -6.099263661663269e-08,
   8.652173267356835e-10,  -1.150659296238449e-11,   1.469062726470250e-13,  -1.823473726657726e-15,   2.217191303927562e-17,  -2.653780480905928e-19,   3.136638635960484e-21,
  -6.811800443190943e-05,   1.449318078022801e-06,  -2.312913657617243e-08,   3.281033663128529e-10,  -4.363514134136963e-12,   5.571021412191195e-14,  -6.915117154909408e-16,
   8.408323944767045e-18,  -1.006417526313059e-19,   1.189557093708679e-21,  -7.766370280845170e-06,   1.652419191412657e-07,  -2.637038078743614e-09,   3.740832314539771e-11,
  -4.975017711317273e-13,   6.351757016124295e-15,  -7.884234075457557e-17,   9.586728681910782e-19,  -1.147467359500199e-20,   1.356277951351454e-22,  -2.478664094772794e-03,
   5.273167757712642e-05,  -8.414018276554065e-07,   1.193369416975034e-08,  -1.586736548458646e-10,   2.025310042891903e-12,  -2.513208394217108e-14,   3.054883502303378e-16,
  -3.655135845418731e-18,   4.318511915525483e-20,  -2.291854263361823e-03,   4.875822722901082e-05,  -7.780170248877814e-07,   1.103499693905042e-08,  -1.467290602893603e-10,
   1.872919707123996e-12,  -2.324207039733111e-14,   2.825283063532979e-16,  -3.380602951751661e-18,   3.994389318102058e-20,  -1.946652377148095e-03,   4.141529893429235e-05,
  -6.608719385990194e-07,   9.373884026590313e-09,  -1.246483328498437e-10,   1.591168997730091e-12,  -1.974706723750225e-14,   2.400624497718432e-16,  -2.872729470757125e-18,
   3.394634455816702e-20,  -1.495587106510058e-03,   3.181971585809622e-05,  -5.077723658630973e-07,   7.202638928786061e-09,  -9.578178449477811e-11,   1.222759949099329e-12,
  -1.517609421176614e-14,   1.845092817465337e-16,  -2.208153913345723e-18,   2.609589787383595e-20,  -1.007320647477818e-03,   2.143196116116564e-05,  -3.420168242426927e-07,
   4.851611783767368e-09,  -6.452031969787386e-11,   8.237153868812100e-13,  -1.022401722662356e-14,   1.243107132839052e-16,  -1.487824307174628e-18,   1.758448518500241e-20,
  -5.561978025361397e-04,   1.183392963541778e-05,  -1.888521448610425e-07,   2.678981545594842e-09,  -3.562798527877305e-11,   4.548674410744873e-13,  -5.646040777171747e-15,
   6.865111657219387e-17,  -8.216921606469251e-19,   9.711971717312654e-21,  -2.109144964755679e-04,   4.487538870351460e-06,  -7.161498983309982e-08,   1.015909917934516e-09,
  -1.351079488453284e-11,   1.724961234299367e-13,  -2.141134959222499e-15,   2.603477770007582e-17,  -3.116178586208379e-19,   3.683224665422610e-21,  -2.404709431652030e-05,
   5.116402992568185e-07,  -8.165088851318164e-09,   1.158277859925126e-10,  -1.540419986695157e-12,   1.966701222600432e-14,  -2.441203645196261e-16,   2.968348409665519e-18,
  -3.552912305124801e-20,   4.199442318256721e-22  };
  static constexpr double wr[7980] = {   1.071631024208966e+00,  -7.496968944010209e-02,   5.575033109186595e-03,  -3.854829365948318e-04,   2.448407500055940e-05,
  -1.440489446874601e-06,   7.920251967329513e-08,  -4.109115240012935e-09,   2.024307016931588e-10,  -9.489707469407095e-12,   4.242487167110085e-13,  -1.811044067326274e-14,
   7.374619993857272e-16,  -2.855324269614936e-17,   1.072182694703008e+00,  -7.508313777804863e-02,   5.589476438959255e-03,  -3.869066721056911e-04,   2.460228535457446e-05,
  -1.449137954549161e-06,   7.977476011924456e-08,  -4.143851853461556e-09,   2.043846045782478e-10,  -9.592216723503089e-12,   4.292789756631436e-13,  -1.834149994344117e-14,
   7.473913310534018e-16,  -2.895076674990788e-17,   1.073157308673282e+00,  -7.528365767034419e-02,   5.615017615389945e-03,  -3.894256422431517e-04,   2.481153991564084e-05,
  -1.464455334246760e-06,   8.078875809822171e-08,  -4.205433223525702e-09,   2.078499657725038e-10,  -9.774087629156166e-12,   4.382060569806760e-13,  -1.875162618364010e-14,
   7.650163408735562e-16,  -2.965628244979292e-17,   1.074337842118213e+00,  -7.552670677409939e-02,   5.645997458167276e-03,  -3.924831756380983e-04,   2.506571949243087e-05,
  -1.483074702631358e-06,   8.202220345631199e-08,  -4.280391148044466e-09,   2.120705660900998e-10,  -9.995705858097482e-12,   4.490882905257138e-13,  -1.925169577022084e-14,
   7.865076275300303e-16,  -3.051637581773855e-17,   1.075486002788343e+00,  -7.576326165544306e-02,   5.676172101382989e-03,  -3.954635287861315e-04,   2.531367783393218e-05,
  -1.501252501639768e-06,   8.322729750808156e-08,  -4.353677768015802e-09,   2.161996836473587e-10,  -1.021263611505741e-11,   4.597446817163942e-13,  -1.974151207465952e-14,
   8.075592382704820e-16,  -3.135867373014584e-17,   1.076412467416873e+00,  -7.595426312211230e-02,   5.700552209970182e-03,  -3.978731974141479e-04,   2.551429646566887e-05,
  -1.515969988044905e-06,   8.420363683494761e-08,  -4.413089922475113e-09,   2.195489647094867e-10,  -1.038867913931026e-11,   4.683956560382680e-13,  -2.013923895389180e-14,
   8.246536248495186e-16,  -3.204249311545705e-17,   1.077025404791669e+00,  -7.608068733794157e-02,   5.716697389999024e-03,  -3.994697515027822e-04,   2.564728725239611e-05,
  -1.525731238296590e-06,   8.485150233279296e-08,  -4.452531939405281e-09,   2.217733757140188e-10,  -1.050563787831043e-11,   4.741446732798976e-13,  -2.040359200152907e-14,
   8.360158728607978e-16,  -3.249693980545119e-17,   1.077340408435403e+00,  -7.614567844347150e-02,   5.724999627249184e-03,  -4.002909869003455e-04,   2.571571626289144e-05,
  -1.530755326921737e-06,   8.518505484613071e-08,  -4.472844206978460e-09,   2.229192107745977e-10,  -1.056589798912090e-11,   4.771071813973210e-13,  -2.053982819402518e-14,
   8.418715744281633e-16,  -3.273112296498944e-17,   1.077450085131944e+00,  -7.616830974320075e-02,   5.727891036110884e-03,  -4.005770371092817e-04,   2.573955462562908e-05,
  -1.532505795390598e-06,   8.530128517634168e-08,  -4.479923150235875e-09,   2.233185861931329e-10,  -1.058690335727396e-11,   4.781399219712160e-13,  -2.058732270387606e-14,
   8.439129961402619e-16,  -3.281276055835640e-17,   1.077467491060357e+00,  -7.617190151979676e-02,   5.728349945470080e-03,  -4.006224393926634e-04,   2.574333844380948e-05,
  -1.532783655576005e-06,   8.531973570947423e-08,  -4.481046912007379e-09,   2.233819880331268e-10,  -1.059023810609165e-11,   4.783038802789176e-13,  -2.059486305094221e-14,
   8.442370979875874e-16,  -3.282572139981147e-17,   1.163692312145209e+00,  -2.668744959610359e-01,   3.962466450145222e-02,  -4.434042361086897e-03,   4.045194752450723e-04,
  -3.136002941744207e-05,   2.120281405732959e-06,  -1.272928065820129e-07,   6.878764558349036e-09,  -3.382686343511842e-10,   1.527530565253711e-11,  -6.382438157118403e-13,
   2.482745163809296e-14,  -9.022929933633065e-16,   1.167901085321531e+00,  -2.682337274023676e-01,   3.987048249792788e-02,  -4.465736553249293e-03,   4.077342298458129e-04,
  -3.163051075904441e-05,   2.139798161966861e-06,  -1.285287706202761e-07,   6.948646256993547e-09,  -3.418428592340274e-10,   1.544235564169151e-11,  -6.454313647245817e-13,
   2.511354258341603e-14,  -9.128413346634473e-16,   1.175348508729398e+00,  -2.706397666342874e-01,   4.030575817630940e-02,  -4.521873821352180e-03,   4.134296098833210e-04,
  -3.210980464252615e-05,   2.174388258236261e-06,  -1.307196664096084e-07,   7.072538501346228e-09,  -3.481803765381002e-10,   1.573858547040044e-11,  -6.581778762113229e-13,
   2.562090591553023e-14,  -9.315469308876082e-16,   1.184389870047383e+00,  -2.735622607145898e-01,   4.083470747023517e-02,  -4.590118792570166e-03,   4.203556837845947e-04,
  -3.269283639433057e-05,   2.216475818264126e-06,  -1.333860607065571e-07,   7.223351097243949e-09,  -3.558963722527344e-10,   1.609930082265535e-11,  -6.737005471105702e-13,
   2.623878009894482e-14,  -9.543248163145164e-16,   1.193204731642667e+00,  -2.764131155005720e-01,   4.135094419434423e-02,  -4.656751540181598e-03,   4.271205595746074e-04,
  -3.326247576251005e-05,   2.257607958027892e-06,  -1.359925735440956e-07,   7.370809815231101e-09,  -3.634422492801055e-10,   1.645211797824288e-11,  -6.888847940963787e-13,
   2.684319152629056e-14,  -9.766042177155994e-16,   1.200332937330067e+00,  -2.787196092357640e-01,   4.176878905247031e-02,  -4.710704488847923e-03,   4.325998588458086e-04,
  -3.372398957521011e-05,   2.290940769414114e-06,  -1.381053130488444e-07,   7.490357881230418e-09,  -3.695609156460873e-10,   1.673824314247924e-11,  -7.011998450229314e-13,
   2.733339946247728e-14,  -9.946723444050182e-16,   1.205056414683091e+00,  -2.802485506227291e-01,   4.204586138693692e-02,  -4.746490422069701e-03,   4.362350213037472e-04,
  -3.403023646437754e-05,   2.313063415554240e-06,  -1.395077439292942e-07,   7.569725156104166e-09,  -3.736235794268178e-10,   1.692824321786410e-11,  -7.093781014576877e-13,
   2.765894224882118e-14,  -1.006670445151157e-15,   1.207486262161268e+00,  -2.810352382667084e-01,   4.218845119779685e-02,  -4.764909979469404e-03,   4.381063570285153e-04,
  -3.418790771765957e-05,   2.324454493540562e-06,  -1.402299339272590e-07,   7.610599379779761e-09,  -3.757160146968766e-10,   1.702610678607343e-11,  -7.135906411097224e-13,
   2.782662685154700e-14,  -1.012850331227392e-15,   1.208332648702170e+00,  -2.813092916426868e-01,   4.223812868488483e-02,  -4.771327732229652e-03,   4.387584107524929e-04,
  -3.424285021210446e-05,   2.328424051108995e-06,  -1.404816135425273e-07,   7.624844412726229e-09,  -3.764452724909051e-10,   1.706021523803078e-11,  -7.150588648841209e-13,
   2.788507116300531e-14,  -1.015004212051194e-15,   1.208466989738736e+00,  -2.813527915156824e-01,   4.224601408806900e-02,  -4.772346457394044e-03,   4.388619168101294e-04,
  -3.425157184878102e-05,   2.329054192676298e-06,  -1.405215665828324e-07,   7.627105776560932e-09,  -3.765610415701370e-10,   1.706562997131486e-11,  -7.152919472881016e-13,
   2.789434927737711e-14,  -1.015346141724456e-15,   7.888213537952754e-01,  -2.847747770816923e-01,   5.636086455706071e-02,  -7.763036725383668e-03,   8.243892375349011e-04,
  -7.143845710881010e-05,   5.237348718435551e-06,  -3.330481940754765e-07,   1.870824465876936e-08,  -9.412344000710592e-10,   4.287472620830552e-11,  -1.783715551413731e-12,
   6.826776728141169e-14,  -2.416368791088123e-15,   7.951286973515079e-01,  -2.872166576558425e-01,   5.687009795420409e-02,  -7.836043826951066e-03,   8.323898243681713e-04,
  -7.214944402463458e-05,   5.290546292920314e-06,  -3.364872757168570e-07,   1.890398998689100e-08,  -9.511852984627157e-10,   4.333170040576038e-11,  -1.802852743823786e-12,
   6.900468111221995e-14,  -2.442636672807523e-15,   8.063025124324181e-01,  -2.915431591292057e-01,   5.777245928128201e-02,  -7.965425189947200e-03,   8.465694342614993e-04,
  -7.340962697673087e-05,   5.384841109812803e-06,  -3.425834532263037e-07,   1.925098374379564e-08,  -9.688255590295163e-10,   4.414181431567446e-11,  -1.836779819915471e-12,
   7.031116742055432e-14,  -2.489210799712885e-15,   8.198899556538060e-01,  -2.968051940064540e-01,   5.887012251766317e-02,  -8.122830983773364e-03,   8.638223905279355e-04,
  -7.494309343301875e-05,   5.499593608616858e-06,  -3.500026818639399e-07,   1.967330607204614e-08,  -9.902961924788057e-10,   4.512787222307353e-11,  -1.878077172800560e-12,
   7.190157625252390e-14,  -2.545912105326827e-15,   8.331602313671913e-01,  -3.019454217375671e-01,   5.994256674423827e-02,  -8.276643261047162e-03,   8.806835588022737e-04,
  -7.644189047907009e-05,   5.611761033740764e-06,  -3.572552545336199e-07,   2.008616353017575e-08,  -1.011286543854412e-09,   4.609191207765365e-11,  -1.918454331727689e-12,
   7.345665606168479e-14,  -2.601359974044009e-15,   8.439079897087639e-01,  -3.061092876925874e-01,   6.081144142105328e-02,  -8.401275562538344e-03,   8.943474650348980e-04,
  -7.765659117323161e-05,   5.702673837950836e-06,  -3.631338798509091e-07,   2.042082363382248e-08,  -1.028301863779064e-09,   4.687341591802898e-11,  -1.951187687762308e-12,
   7.471742202494068e-14,  -2.646318206701699e-15,   8.510381030301302e-01,  -3.088719744768268e-01,   6.138799839361159e-02,  -8.483985533875443e-03,   9.034160018047585e-04,
  -7.846282413385805e-05,   5.763018630454961e-06,  -3.670360772625449e-07,   2.064297665686546e-08,  -1.039597238940294e-09,   4.739221987536872e-11,  -1.972918527761118e-12,
   7.555445098245061e-14,  -2.676168374666274e-15,   8.547084919266928e-01,  -3.102942414984756e-01,   6.168483799440028e-02,  -8.526571135719399e-03,   9.080854245676831e-04,
  -7.887797302638811e-05,   5.794092634539664e-06,  -3.690455304072912e-07,   2.075737764505484e-08,  -1.045414058190202e-09,   4.765939448231346e-11,  -1.984109729718752e-12,
   7.598552591313329e-14,  -2.691542062391235e-15,   8.559873965263309e-01,  -3.107898316406191e-01,   6.178827527901657e-02,  -8.541410989344968e-03,   9.097126197085315e-04,
  -7.902264628053578e-05,   5.804921626098690e-06,  -3.697458137661563e-07,   2.079724613273157e-08,  -1.047441222339162e-09,   4.775250563915527e-11,  -1.988009931553628e-12,
   7.613576005353029e-14,  -2.696900061187069e-15,   8.561904071939542e-01,  -3.108685014302799e-01,   6.180469502947922e-02,  -8.543766703076517e-03,   9.099709262527537e-04,
  -7.904561233495261e-05,   5.806640674389035e-06,  -3.698569806417924e-07,   2.080357509593497e-08,  -1.047763027297201e-09,   4.776728673020519e-11,  -1.988629077438408e-12,
   7.615960938428226e-14,  -2.697750636494699e-15,   8.388301957314230e-01,  -4.388341423090000e-02,   2.601383816246038e-03,  -1.500224717040498e-04,   8.135766154651041e-06,
  -4.164556938831690e-07,   2.013860768046205e-08,  -9.219268782722638e-10,   4.054489658669073e-11,  -1.716645384409720e-12,   6.973623945498561e-14,  -2.731369663306166e-15,
   1.034052044710846e-16,  -3.777510973248983e-18,   8.390836038543934e-01,  -4.392704388039912e-02,   2.606128384924599e-03,  -1.504290952784127e-04,   8.165433357712329e-06,
  -4.183702196326310e-07,   2.025165430029062e-08,  -9.281237231121887e-10,   4.086186045539193e-11,  -1.731927128808775e-12,   7.043496307558731e-14,  -2.761729495073504e-15,
   1.046574506561267e-16,  -3.826340918788776e-18,   8.395311285250739e-01,  -4.400412491809065e-02,   2.614514139776415e-03,  -1.511480792331944e-04,   8.217913483095381e-06,
  -4.217585501056409e-07,   2.045181725326696e-08,  -9.391009760791664e-10,   4.142359711514783e-11,  -1.759022118809008e-12,   7.167431461440446e-14,  -2.815597313948627e-15,
   1.068799571543073e-16,  -3.913027510580484e-18,   8.400729323514994e-01,  -4.409749578117336e-02,   2.624678008052528e-03,  -1.520200287237101e-04,   8.281598426071747e-06,
  -4.258730580935633e-07,   2.069503728100077e-08,  -9.524480520164508e-10,   4.210704605170562e-11,  -1.792008386568760e-12,   7.318398211064797e-14,  -2.881244146044875e-15,
   1.095895238525373e-16,  -4.018749478343834e-18,   8.405995901207091e-01,  -4.418831028009249e-02,   2.634569813086327e-03,  -1.528691756671169e-04,   8.343659422172367e-06,
  -4.298855313489039e-07,   2.093239229441048e-08,  -9.654822014622782e-10,   4.277493482729460e-11,  -1.824265218558589e-12,   7.466114970668921e-14,  -2.945509052688117e-15,
   1.122431766625024e-16,  -4.122329453400950e-18,   8.410243495570020e-01,  -4.426159248739067e-02,   2.642556399953779e-03,  -1.535551578077452e-04,   8.393825085804330e-06,
  -4.331309967694058e-07,   2.112449502506080e-08,  -9.760377655716940e-10,   4.331614982092615e-11,  -1.850419586414133e-12,   7.585949494982606e-14,  -2.997666101590674e-15,
   1.143976713417637e-16,  -4.206454029067599e-18,   8.413052636137857e-01,  -4.431007648870366e-02,   2.647842563002163e-03,  -1.540093848388151e-04,   8.427057165237121e-06,
  -4.352819589690501e-07,   2.125187146815434e-08,  -9.830399216840942e-10,   4.367533400464899e-11,  -1.867784836124951e-12,   7.665544906643705e-14,  -3.032320378398741e-15,
   1.158295574927937e-16,  -4.262377312719772e-18,   8.414496008883089e-01,  -4.433499404888529e-02,   2.650559975774975e-03,  -1.542429439744528e-04,   8.444149295048332e-06,
  -4.363885690593647e-07,   2.131742122407896e-08,  -9.866443036301650e-10,   4.386027559329408e-11,  -1.876728431060027e-12,   7.706548384256481e-14,  -3.050175883635868e-15,
   1.165674535850554e-16,  -4.291200574466070e-18,   8.414998506588909e-01,  -4.434366981353933e-02,   2.651506228720146e-03,  -1.543242828663087e-04,   8.450102489234044e-06,
  -4.367740516729232e-07,   2.134025807098028e-08,  -9.879001871237645e-10,   4.392472325985155e-11,  -1.879845430025201e-12,   7.720840337863330e-14,  -3.056400044024862e-15,
   1.168246923492597e-16,  -4.301249354835441e-18,   8.415078251685919e-01,  -4.434504667939279e-02,   2.651656406570779e-03,  -1.543371924362957e-04,   8.451047374919164e-06,
  -4.368352375027816e-07,   2.134388299257125e-08,  -9.880995424410416e-10,   4.393495387707162e-11,  -1.880340249540892e-12,   7.723109239254087e-14,  -3.057388178556619e-15,
   1.168655319463729e-16,  -4.302844745535580e-18,   5.026797908791540e-01,  -8.698323013746295e-02,   1.102705526348777e-02,  -1.090195379530040e-03,   9.017204843239719e-05,
  -6.458891766922977e-06,   4.094954928908554e-07,  -2.332067538738367e-08,   1.205450958575882e-09,  -5.704672868925290e-11,   2.489966850815131e-12,  -1.008769060308326e-13,
   3.815715267927839e-15,  -1.353367457246364e-16,   5.038225219433993e-01,  -8.731274034852331e-02,   1.108127918146315e-02,  -1.096667978684282e-03,   9.078849483780136e-05,
  -6.508136403023749e-06,   4.128965072647691e-07,  -2.352804164859201e-08,   1.216788116899637e-09,  -5.760925449221630e-11,   2.515551857128894e-12,  -1.019525262462234e-13,
   3.857795523661574e-15,  -1.368745413406046e-16,   5.058434501534493e-01,  -8.789572021979612e-02,   1.117724975495956e-02,  -1.108127555709725e-03,   9.188020680361752e-05,
  -6.595368639917478e-06,   4.189223561149130e-07,  -2.389551767430877e-08,   1.236882218632603e-09,  -5.860643825549383e-11,   2.560912831701171e-12,  -1.038598048845321e-13,
   3.932420090806970e-15,  -1.396018522903489e-16,   5.082949724934255e-01,  -8.860332161732540e-02,   1.129379691552773e-02,  -1.122050551676150e-03,   9.320712691197155e-05,
  -6.701431083792802e-06,   4.262511344590685e-07,  -2.434256785943504e-08,   1.261333351878576e-09,  -5.982011080315769e-11,   2.616133111941383e-12,  -1.061820717622409e-13,
   4.023295704664399e-15,  -1.429234394981347e-16,   5.106830518714269e-01,  -8.929303816184030e-02,   1.140746256946142e-02,  -1.135636052163278e-03,   9.450243489589845e-05,
  -6.805004586474876e-06,   4.334102069837917e-07,  -2.477938902788278e-08,   1.285231102223491e-09,  -6.100659631040313e-11,   2.670128400107788e-12,  -1.084532797677896e-13,
   4.112188045955528e-15,  -1.461728986398611e-16,   5.126127366873586e-01,  -8.985066913940232e-02,   1.149940652524328e-02,  -1.146630169506038e-03,   9.555106387523406e-05,
  -6.888880643200728e-06,   4.392094104389718e-07,  -2.513332393574009e-08,   1.304598648843638e-09,  -6.196836583838343e-11,   2.713905762560447e-12,  -1.102950180489959e-13,
   4.184282025836540e-15,  -1.488085519478353e-16,   5.138907228303338e-01,  -9.022012543325347e-02,   1.156034621083773e-02,  -1.153919343311521e-03,   9.624650590833591e-05,
  -6.944519834242601e-06,   4.430571117845036e-07,  -2.536819861398067e-08,   1.317453279809585e-09,  -6.260681030136449e-11,   2.742970371158223e-12,  -1.115179427606330e-13,
   4.232158000683116e-15,  -1.505589552288244e-16,   5.145479233400294e-01,  -9.041016362463886e-02,   1.159169889364260e-02,  -1.157670260509926e-03,   9.660443160731696e-05,
  -6.973159968517109e-06,   4.450379534906320e-07,  -2.548912818937659e-08,   1.324072385223202e-09,  -6.293558856487712e-11,   2.757939003615995e-12,  -1.121478136046787e-13,
   4.256818250633106e-15,  -1.514606024020677e-16,   5.147768103566969e-01,  -9.047635671130586e-02,   1.160262060339000e-02,  -1.158977009227477e-03,   9.672913570676331e-05,
  -6.983139068023978e-06,   4.457281787002920e-07,  -2.553126827915245e-08,   1.326379036943196e-09,  -6.305016735258468e-11,   2.763155758730372e-12,  -1.123673393260735e-13,
   4.265413216997423e-15,  -1.517748643779065e-16,   5.148131383346820e-01,  -9.048686294843558e-02,   1.160435416151327e-02,  -1.159184429608080e-03,   9.674893045648212e-05,
  -6.984723118972440e-06,   4.458377447510103e-07,  -2.553795767952111e-08,   1.326745204345209e-09,  -6.306835629200311e-11,   2.763983908234342e-12,  -1.124021889716816e-13,
   4.266777677472632e-15,  -1.518247541080982e-16,   1.761946710075818e-01,  -5.839896560763928e-02,   1.089847665945845e-02,  -1.436090381167439e-03,   1.473583477727058e-04,
  -1.242440370728066e-05,   8.907798624249233e-07,  -5.561594961032089e-08,   3.077268988186811e-09,  -1.529286851678838e-10,   6.898254954715016e-12,  -2.848189885628756e-13,
   1.083785507843222e-14,  -3.818392712957548e-16,   1.773985030975470e-01,  -5.884766200074501e-02,   1.098908354441590e-02,  -1.448743318438865e-03,   1.487153412410991e-04,
  -1.254286816389481e-05,   8.995146875838960e-07,  -5.617394423119965e-08,   3.108729137951356e-09,  -1.545162408403046e-10,   6.970743852147361e-12,  -2.878402105463844e-13,
   1.095362989620298e-14,  -3.859400958218457e-16,   1.795305375557821e-01,  -5.964246537333431e-02,   1.114960636843408e-02,  -1.471162719764829e-03,   1.511200256251906e-04,
  -1.275281454390846e-05,   9.149960094471729e-07,  -5.716297893174886e-08,   3.164494513557262e-09,  -1.573304100243898e-10,   7.099244667200890e-12,  -2.931960448781006e-13,
   1.115887249327579e-14,  -3.932101014033393e-16,   1.821220460885213e-01,  -6.060880271431229e-02,   1.134481631633122e-02,  -1.498431721581477e-03,   1.540453241666610e-04,
  -1.300824731310289e-05,   9.338335085485789e-07,  -5.836653289063267e-08,   3.232360157125591e-09,  -1.607554048887984e-10,   7.255643692158608e-12,  -2.997148723253648e-13,
   1.140868971129981e-14,  -4.020593000419853e-16,   1.846519501525173e-01,  -6.155242645996607e-02,   1.153548313207026e-02,  -1.525071357258560e-03,   1.569035789919552e-04,
  -1.325786049153283e-05,   9.522439624844962e-07,  -5.954291503413951e-08,   3.298698766140891e-09,  -1.641035357771162e-10,   7.408539753478222e-12,  -3.060879170636652e-13,
   1.165292775504060e-14,  -4.107111774147722e-16,   1.867001541154878e-01,  -6.231656659379829e-02,   1.168991624543004e-02,  -1.546652256381903e-03,   1.592194032787490e-04,
  -1.346012763479049e-05,   9.671638940030202e-07,  -6.049634219186552e-08,   3.352468151959006e-09,  -1.668174380683005e-10,   7.532478052596505e-12,  -3.112540986931947e-13,
   1.185091989936162e-14,  -4.177250643928636e-16,   1.880585526447623e-01,  -6.282344580016667e-02,   1.179237265684200e-02,  -1.560971637829328e-03,   1.607561669515640e-04,
  -1.359436271516243e-05,   9.770662907594712e-07,  -6.112917371757158e-08,   3.388159051196641e-09,  -1.686189353754713e-10,   7.614751141930562e-12,  -3.146836071849748e-13,
   1.198235731224557e-14,  -4.223813542511299e-16,   1.887576989581204e-01,  -6.308435648093588e-02,   1.184511590809458e-02,  -1.568343643143288e-03,   1.615473856363274e-04,
  -1.366347878057505e-05,   9.821651496272237e-07,  -6.145503820376522e-08,   3.406537951044797e-09,  -1.695466316960614e-10,   7.657119120228365e-12,  -3.164497173334617e-13,
   1.205004508388337e-14,  -4.247792890378164e-16,   1.890012892563115e-01,  -6.317526509038425e-02,   1.186349391844604e-02,  -1.570912456720465e-03,   1.618230980365256e-04,
  -1.368756393943913e-05,   9.839420066709783e-07,  -6.156859782914570e-08,   3.412942851846495e-09,  -1.698699299691940e-10,   7.671884302601530e-12,  -3.170652081625677e-13,
   1.207363445944323e-14,  -4.256149813515311e-16,   1.890399553666796e-01,  -6.318969560652406e-02,   1.186641121684932e-02,  -1.571320230729437e-03,   1.618668650672076e-04,
  -1.369138728464417e-05,   9.842240716526444e-07,  -6.158662480402545e-08,   3.413959599308801e-09,  -1.699212521929052e-10,   7.674228218093617e-12,  -3.171629151302310e-13,
   1.207737919470121e-14,  -4.257476449960979e-16,   6.959786455406480e-01,  -2.855782033428151e-02,   1.373434859403610e-03,  -6.694112037065640e-05,   3.119517499781551e-06,
  -1.386814915479697e-07,   6.007592172792998e-09,  -2.445791578454100e-10,   9.470254217183183e-12,  -3.638000381466903e-13,   1.344636688985071e-14,  -4.773823517600731e-16,
   1.669243471806302e-17,  -5.527768540474633e-19,   6.961110281936489e-01,  -2.857712133939515e-02,   1.375239198124448e-03,  -6.707537817417008e-05,   3.128276498309820e-06,
  -1.391837971967622e-07,   6.033708969436128e-09,  -2.458763738518538e-10,   9.530598615436521e-12,  -3.664352982985026e-13,   1.355762460860544e-14,  -4.817903510799597e-16,
   1.686215955167130e-17,  -5.593186042486723e-19,   6.963447629959878e-01,  -2.861120971243262e-02,   1.378427061839085e-03,  -6.731266750570832e-05,   3.143762247753672e-06,
  -1.400722342784700e-07,   6.079923467603533e-09,  -2.481726919248412e-10,   9.637465940768142e-12,  -3.711041139966780e-13,   1.375481214641911e-14,  -4.896080412439625e-16,
   1.716323879269949e-17,  -5.709217225561568e-19,   6.966276425708995e-01,  -2.865248341802372e-02,   1.382288826571125e-03,  -6.760026525306557e-05,   3.162539649723654e-06,
  -1.411501492637316e-07,   6.136030473223607e-09,  -2.509620096263778e-10,   9.767355866086539e-12,  -3.767819650733787e-13,   1.399474504858148e-14,  -4.991292259642192e-16,
   1.753004188100942e-17,  -5.850552767272381e-19,   6.969025139690170e-01,  -2.869260751119163e-02,   1.386045067930520e-03,  -6.788015793209733e-05,   3.180822875591979e-06,
  -1.422003585385165e-07,   6.190733427619649e-09,  -2.536830561712210e-10,   9.894149596714554e-12,  -3.823278642167027e-13,   1.422923690527273e-14,  -5.084437019506424e-16,
   1.788900681235959e-17,  -5.988842843274223e-19,   6.971241309958816e-01,  -2.872497135019429e-02,   1.389076291334362e-03,  -6.810613679209782e-05,   3.195590711210004e-06,
  -1.430491150007086e-07,   6.234970488512924e-09,  -2.558846041828543e-10,   9.996795569637259e-12,  -3.868199903996567e-13,   1.441926983234931e-14,  -5.159987589609345e-16,
   1.818025753761527e-17,  -6.101028448093860e-19,   6.972706618525845e-01,  -2.874637659806756e-02,   1.391081841011732e-03,  -6.825570528852627e-05,   3.205368219589950e-06,
  -1.436112936737129e-07,   6.264284543086312e-09,  -2.573440165573593e-10,   1.006486904217000e-11,  -3.898003072357199e-13,   1.454539520265694e-14,  -5.210162817326502e-16,
   1.837373022244879e-17,  -6.175542777759208e-19,   6.973459403942136e-01,  -2.875737534515467e-02,   1.392112582672865e-03,  -6.833259193770727e-05,   3.210395379449562e-06,
  -1.439004129827881e-07,   6.279364423979217e-09,  -2.580949412793902e-10,   1.009990452799723e-11,  -3.913345626298892e-13,   1.461033869003889e-14,  -5.236008559679857e-16,
   1.847340387462976e-17,  -6.213928599997940e-19,   6.973721462289403e-01,  -2.876120453583932e-02,   1.392471468529343e-03,  -6.835936515823683e-05,   3.212146075089544e-06,
  -1.440011095183015e-07,   6.284617211892333e-09,  -2.583565380626331e-10,   1.011211114312810e-11,  -3.918691673186231e-13,   1.463297029904556e-14,  -5.245016899712472e-16,
   1.850814661843713e-17,  -6.227308138395497e-19,   6.973763049452356e-01,  -2.876181222200898e-02,   1.392528424792230e-03,  -6.836361427505469e-05,   3.212423931330098e-06,
  -1.440170918018956e-07,   6.285450951583440e-09,  -2.583980608197216e-10,   1.011404874399232e-11,  -3.919540298902498e-13,   1.463656292685259e-14,  -5.246446992632272e-16,
   1.851366220847405e-17,  -6.229432189597959e-19,   2.733333128087914e-01,  -3.376899937348961e-02,   3.608176986933887e-03,  -3.094075471985131e-04,   2.280788125298857e-05,
  -1.485675818845806e-06,   8.692565249395514e-08,  -4.635894206435345e-09,   2.270112763523496e-10,  -1.025641820607922e-11,   4.303362045538731e-13,  -1.684390160131937e-14,
   6.171573020585818e-16,  -2.125669026348168e-17,   2.736988324747441e-01,  -3.386123471295453e-02,   3.621743470202989e-03,  -3.108827082658360e-04,   2.293771259612649e-05,
  -1.495398094732533e-06,   8.756223005348873e-08,  -4.672972768449454e-09,   2.289607113212322e-10,  -1.034989178314958e-11,   4.344552090523549e-13,  -1.701208813773260e-14,
   6.235592242949541e-16,  -2.148478205057267e-17,   2.743449216124649e-01,  -3.402433728438625e-02,   3.645742930624784e-03,  -3.134932491039274e-04,   2.316754601803382e-05,
  -1.512613778039114e-06,   8.868972360911026e-08,  -4.738659873343261e-09,   2.324149142760033e-10,  -1.051554563144307e-11,   4.417560656372578e-13,  -1.731023902076838e-14,
   6.349098848000202e-16,  -2.188925221211234e-17,   2.751280994342549e-01,  -3.422216385754120e-02,   3.674867903640592e-03,  -3.166629269511099e-04,   2.344673496399779e-05,
  -1.533534741606692e-06,   9.006035588451171e-08,  -4.818536495229422e-09,   2.366163947866878e-10,  -1.071708472655007e-11,   4.506404696582935e-13,  -1.767313277302298e-14,
   6.487282567636478e-16,  -2.238176196572399e-17,   2.758904099519954e-01,  -3.441484163276624e-02,   3.703251733471691e-03,  -3.197536333187798e-04,   2.371910301955918e-05,
  -1.553953285899003e-06,   9.139856662476423e-08,  -4.896549254964263e-09,   2.407210023440325e-10,  -1.091402720193838e-11,   4.593243165298655e-13,  -1.802791247260966e-14,
   6.622407376437348e-16,  -2.286347916895966e-17,   2.765059643502545e-01,  -3.457051369213979e-02,   3.726196272845717e-03,  -3.222532669206057e-04,   2.393947966234348e-05,
  -1.570480442404822e-06,   9.248209410524354e-08,  -4.959733249653093e-09,   2.440462364026013e-10,  -1.107361070847672e-11,   4.663623704157910e-13,  -1.831550899569148e-14,
   6.731966204930684e-16,  -2.325413284574348e-17,   2.769134214886417e-01,  -3.467360144212646e-02,   3.741396332499556e-03,  -3.239097907849214e-04,   2.408557213373961e-05,
  -1.581439709092839e-06,   9.320076184621542e-08,  -5.001650067215457e-09,   2.462526350532698e-10,  -1.117951708233986e-11,   4.710338498020882e-13,  -1.850642739982887e-14,
   6.804706652694266e-16,  -2.351354177366774e-17,   2.771228899994031e-01,  -3.472661081872190e-02,   3.749214282649380e-03,  -3.247619852656438e-04,   2.416074369122223e-05,
  -1.587079720158901e-06,   9.357066633550111e-08,  -5.023227789941117e-09,   2.473885600524068e-10,  -1.123404654363140e-11,   4.734393435585432e-13,  -1.860474584858861e-14,
   6.842169592062710e-16,  -2.364715499186887e-17,   2.771958324456555e-01,  -3.474507219282470e-02,   3.751937302637666e-03,  -3.250588368275550e-04,   2.418693112034634e-05,
  -1.589044674695703e-06,   9.369954793741562e-08,  -5.030746311379893e-09,   2.477843808259627e-10,  -1.125304857233570e-11,   4.742776283363913e-13,  -1.863900995873706e-14,
   6.855226006787235e-16,  -2.369372315839883e-17,   2.772074090699644e-01,  -3.474800227984082e-02,   3.752369499155467e-03,  -3.251059543600822e-04,   2.419108781034904e-05,
  -1.589356576018312e-06,   9.372000598755546e-08,  -5.031939786537268e-09,   2.478472135848744e-10,  -1.125606500369509e-11,   4.744107015404720e-13,  -1.864444926612347e-14,
   6.857298692037933e-16,  -2.370111587109727e-17,   4.657661351525062e-02,  -1.339598239182688e-02,   2.297696136723227e-03,  -2.842948564163361e-04,   2.782039553383293e-05,
  -2.260256436691713e-06,   1.572889179520975e-07,  -9.583710222871275e-09,   5.196286281126966e-10,  -2.538890091884579e-11,   1.129188027798665e-12,  -4.608801935826805e-14,
   1.737877893617228e-15,  -6.081672297238465e-17,   4.682619895847284e-02,  -1.348405126768827e-02,   2.314702577753748e-03,  -2.865864729703671e-04,   2.805915276324998e-05,
  -2.280610262680448e-06,   1.587602911165353e-07,  -9.676161834196150e-09,   5.247701268440549e-10,  -2.564547396172883e-11,   1.140801165623035e-12,  -4.656888468381425e-14,
   1.756217375961732e-15,  -6.146395971946421e-17,   4.726805912405853e-02,  -1.364000478970592e-02,   2.344824101867531e-03,  -2.906460439024742e-04,   2.848216859455154e-05,
  -2.316676256503791e-06,   1.613677563470663e-07,  -9.840012222261978e-09,   5.338829770269761e-10,  -2.610025436030341e-11,   1.161386655053394e-12,  -4.742129910309178e-14,
   1.788728024225840e-15,  -6.261134508705000e-17,   4.780486191898353e-02,  -1.382953374060042e-02,   2.381441270221317e-03,  -2.955822441947606e-04,   2.899663396208831e-05,
  -2.360546500998398e-06,   1.645398952619515e-07,  -1.003937012778750e-08,   5.449717733633854e-10,  -2.665369197122060e-11,   1.186439521802581e-12,  -4.845875353948649e-14,
   1.828297437927059e-15,  -6.400788689275530e-17,   4.832860811599747e-02,  -1.401452157527925e-02,   2.417192346716202e-03,  -3.004029385528366e-04,   2.949916878246414e-05,
  -2.403407072267197e-06,   1.676394981790783e-07,  -1.023419455440920e-08,   5.558095877017567e-10,  -2.719465220961964e-11,   1.210929335457427e-12,  -4.947294663998956e-14,
   1.866981145556758e-15,  -6.537320498062182e-17,   4.875241976960202e-02,  -1.416426167827870e-02,   2.446139449067480e-03,  -3.043070756387156e-04,   2.990623404976013e-05,
  -2.438130670495406e-06,   1.701509864358027e-07,  -1.039207126668049e-08,   5.645928979748781e-10,  -2.763309875063735e-11,   1.230779517535132e-12,  -5.029503873831435e-14,
   1.898338744543726e-15,  -6.647997825809115e-17,   4.903339408225376e-02,  -1.426355895964703e-02,   2.465339113013654e-03,  -3.068969994544290e-04,   3.017631054045823e-05,
  -2.461171507870344e-06,   1.718176490694965e-07,  -1.049684952484475e-08,   5.704225438733994e-10,  -2.792412102771706e-11,   1.243955848554138e-12,  -5.084075362696734e-14,
   1.919154831764421e-15,  -6.721469920822832e-17,   4.917797507963172e-02,  -1.431466183386173e-02,   2.475221349066134e-03,  -3.082301913301823e-04,   3.031534708208558e-05,
  -2.473033863274095e-06,   1.726757654453918e-07,  -1.055079954426532e-08,   5.734243394998497e-10,  -2.807397924431384e-11,   1.250741023802668e-12,  -5.112177643433011e-14,
   1.929874502451863e-15,  -6.759306272199605e-17,   4.922834359596338e-02,  -1.433246602359271e-02,   2.478664504295279e-03,  -3.086947217565332e-04,   3.036379410938873e-05,
  -2.477167411754660e-06,   1.729747922244533e-07,  -1.056959987613644e-08,   5.744704160899312e-10,  -2.812620322160750e-11,   1.253105614862669e-12,  -5.121971206803360e-14,
   1.933610302445318e-15,  -6.772492284301962e-17,   4.923633855990471e-02,  -1.433529212810958e-02,   2.479211054336246e-03,  -3.087684601228606e-04,   3.037148455428287e-05,
  -2.477823574440915e-06,   1.730222603521113e-07,  -1.057258430017349e-08,   5.746364745566468e-10,  -2.813449350894358e-11,   1.253480982955291e-12,  -5.123525895003180e-14,
   1.934203346667648e-15,  -6.774585517164182e-17,   5.996072479768513e-01,  -2.010440900363757e-02,   7.983051563486534e-04,  -3.322143953900577e-05,   1.369494886699150e-06,
  -5.163000925089343e-08,   1.990180110080901e-09,  -7.753436358890074e-11,   2.566953193216887e-12,  -8.460584727558542e-14,   3.186394959217212e-15,  -9.443495295549351e-17,
   2.746422784609835e-18,  -1.201209028926973e-19,   5.996836685197303e-01,  -2.011392798246117e-02,   7.990918113572962e-04,  -3.327117108119073e-05,   1.372377165888697e-06,
  -5.178744668657485e-08,   1.997210040198943e-09,  -7.783366250159626e-11,   2.580988382167612e-12,  -8.512810003169639e-14,   3.204629648093392e-15,  -9.533869471004237e-17,
   2.772714736785614e-18,  -1.205630310756860e-19,   5.998185756983536e-01,  -2.013073597502673e-02,   8.004812144952586e-04,  -3.335904465738507e-05,   1.377471145720415e-06,
  -5.206573342516421e-08,   2.009644778478450e-09,  -7.836323922432327e-11,   2.605817343651488e-12,  -8.605343860186726e-14,   3.236941047130060e-15,  -9.693615137583540e-17,
   2.819446444310579e-18,  -1.213550671802741e-19,   5.999818125668772e-01,  -2.015108018563115e-02,   8.021635796167446e-04,  -3.346550972851731e-05,   1.383644765849092e-06,
  -5.240307085542471e-08,   2.024732782330520e-09,  -7.900610411653984e-11,   2.635949642158521e-12,  -8.717888167464812e-14,   3.276245395009835e-15,  -9.887261989285024e-17,
   2.876532002795972e-18,  -1.223332254013423e-19,   6.001403908402247e-01,  -2.017085075906553e-02,   8.037991856632747e-04,  -3.356908169696107e-05,   1.389652622487696e-06,
  -5.273142357406111e-08,   2.039434304994184e-09,  -7.963280823143039e-11,   2.665315961848264e-12,  -8.827827413952098e-14,   3.314646912569321e-15,  -1.007576071268928e-16,
   2.932552487417142e-18,  -1.233043638241473e-19,   6.002682188511295e-01,  -2.018679257218980e-02,   8.051185270580019e-04,  -3.365267401269666e-05,   1.394502965537093e-06,
  -5.299656606103972e-08,   2.051316686980825e-09,  -8.013955806908265e-11,   2.689055353069610e-12,  -8.916883294468331e-14,   3.345759643785045e-15,  -1.022798253570396e-16,
   2.978112734810233e-18,  -1.241022701012038e-19,   6.003527242345881e-01,  -2.019733393901129e-02,   8.059911666880528e-04,  -3.370798684301125e-05,   1.397713131667837e-06,
  -5.317207449775250e-08,   2.059187496189695e-09,  -8.047533497967955e-11,   2.704782318838040e-12,  -8.975970182542235e-14,   3.366405450452935e-15,  -1.032875084464699e-16,
   3.008428688257454e-18,  -1.246371846711968e-19,   6.003961338317320e-01,  -2.020274969458186e-02,   8.064395695960636e-04,  -3.373641631169743e-05,   1.399363298845337e-06,
  -5.326230154839564e-08,   2.063235460787529e-09,  -8.064805931376956e-11,   2.712871387526045e-12,  -9.006388522797069e-14,   3.377035076054839e-15,  -1.038055712798968e-16,
   3.024062409444509e-18,  -1.249142719706140e-19,   6.004112448567327e-01,  -2.020463505772593e-02,   8.065956818569543e-04,  -3.374631522088464e-05,   1.399937908460044e-06,
  -5.329372104629764e-08,   2.064645336251788e-09,  -8.070822331265742e-11,   2.715688857317910e-12,  -9.016987754527728e-14,   3.380739123524640e-15,  -1.039859787829061e-16,
   3.029514214207799e-18,  -1.250110950460248e-19,   6.004136428593129e-01,  -2.020493425597588e-02,   8.066204566943124e-04,  -3.374788622056028e-05,   1.400029103145118e-06,
  -5.329870760718736e-08,   2.064869108913858e-09,  -8.071777268182542e-11,   2.716136045743219e-12,  -9.018670269298520e-14,   3.381327109565049e-15,  -1.040146112956379e-16,
   3.030379831493231e-18,  -1.250264776073076e-19,   1.789716299164464e-01,  -1.524458353620360e-02,   1.378808896566524e-03,  -1.016385453719674e-04,   6.576765130072016e-06,
  -3.868093567305132e-07,   2.061267495631099e-08,  -1.010942196229216e-09,   4.646332085570188e-11,  -1.988027475331357e-12,   7.915226660610708e-14,  -2.982703067096220e-15,
   1.058427642497038e-16,  -3.498017122997819e-18,   1.791086716134021e-01,  -1.527451339522413e-02,   1.382681498935921e-03,  -1.020189912408791e-04,   6.607293717708603e-06,
  -3.889142501582534e-07,   2.074207948517922e-08,  -1.018085342673708e-09,   4.682008627094866e-11,  -2.004492727938906e-12,   7.985515223180375e-14,  -3.010290043027587e-15,
   1.068663948028584e-16,  -3.533981481161565e-18,   1.793508000739844e-01,  -1.532741523790420e-02,   1.389529095786228e-03,  -1.026919340039986e-04,   6.661312795062226e-06,
  -3.926400168082914e-07,   2.097119118574844e-08,  -1.030735521748458e-09,   4.745205783736173e-11,  -2.033663649196465e-12,   8.110064438366351e-14,  -3.059185413681780e-15,
   1.086807177665206e-16,  -3.597729625375050e-18,   1.796441244101571e-01,  -1.539153866724946e-02,   1.397833763756426e-03,  -1.035084661895283e-04,   6.726891161500752e-06,
  -3.971651673972084e-07,   2.124956120813849e-08,  -1.046110885128733e-09,   4.822044026009780e-11,  -2.069138799375197e-12,   8.261566866819691e-14,  -3.118682632228835e-15,
   1.108884961190585e-16,  -3.675308134486368e-18,   1.799294451386063e-01,  -1.545395014531448e-02,   1.405921489596492e-03,  -1.043040842881433e-04,   6.790824385481666e-06,
  -4.015790240873285e-07,   2.152119091645696e-08,  -1.061119650350655e-09,   4.897078217298498e-11,  -2.103789131501783e-12,   8.409584893949693e-14,  -3.176833009555773e-15,
   1.130463678834632e-16,  -3.751139061764577e-18,   1.801597024673212e-01,  -1.550434402096658e-02,   1.412455312621109e-03,  -1.049471379779644e-04,   6.842522801941658e-06,
  -4.051498040855924e-07,   2.174101357293647e-08,  -1.073269921891145e-09,   4.957841854029142e-11,  -2.131855220480808e-12,   8.529503853107169e-14,  -3.223959785235477e-15,
   1.147952266005817e-16,  -3.812600920836215e-18,   1.803120518175816e-01,  -1.553770029080810e-02,   1.416781800866409e-03,  -1.053730937831153e-04,   6.876779722231679e-06,
  -4.075166918455525e-07,   2.188676005698660e-08,  -1.081327773248775e-09,   4.998149082765845e-11,  -2.150475559972471e-12,   8.609076951618996e-14,  -3.255238626777744e-15,
   1.159560032925957e-16,  -3.853397301662951e-18,   1.803903522312742e-01,  -1.555484794740133e-02,   1.419006463527584e-03,  -1.055921637738666e-04,   6.894401880878614e-06,
  -4.087344882675430e-07,   2.196176016204296e-08,  -1.085474903548057e-09,   5.018897022216519e-11,  -2.160061167241066e-12,   8.650044683424725e-14,  -3.271344674341278e-15,
   1.165537179790305e-16,  -3.874405072170437e-18,   1.804176152408971e-01,  -1.556081915265694e-02,   1.419781224466197e-03,  -1.056684642853649e-04,   6.900540149781405e-06,
  -4.091587178028452e-07,   2.198788890893792e-08,  -1.086919790658555e-09,   5.026126222491330e-11,  -2.163401219041647e-12,   8.664320317100097e-14,  -3.276957364258954e-15,
   1.167620131704272e-16,  -3.881726085934001e-18,   1.804219419719986e-01,  -1.556176683395809e-02,   1.419904189571350e-03,  -1.056805745569785e-04,   6.901514432451667e-06,
  -4.092260544910353e-07,   2.199203633407243e-08,  -1.087149142757192e-09,   5.027273762254790e-11,  -2.163931414689558e-12,   8.666586444389960e-14,  -3.277848345381447e-15,
   1.167950788671033e-16,  -3.882888260667165e-18,   1.555743943811106e-02,  -3.542098638699200e-03,   5.429874910306595e-04,  -6.152264436055566e-05,   5.638651207315193e-06,
  -4.358807589514023e-07,   2.914568127013964e-08,  -1.719578958359846e-09,   9.082470372094571e-11,  -4.340211083684975e-12,   1.894382509000904e-13,  -7.612185837095366e-15,
   2.831723128723632e-16,  -9.799472424246476e-18,   1.561522086724209e-02,  -3.560956870979004e-03,   5.464095574744496e-04,  -6.196213045160155e-05,   5.682697550437876e-06,
  -4.395194366913126e-07,   2.940205961273714e-08,  -1.735341951105174e-09,   9.168534243057848e-11,  -4.382508061977475e-12,   1.913277505972179e-13,  -7.689583059742234e-15,
   2.861020655673546e-16,  -9.902242494994258e-18,   1.571746859384181e-02,  -3.594338475454303e-03,   5.524687224376740e-04,  -6.274046298704043e-05,   5.760718280047342e-06,
  -4.459657262649174e-07,   2.985631759938648e-08,  -1.763274319983589e-09,   9.321055561178265e-11,  -4.457472139169473e-12,   1.946768042662847e-13,  -7.826774051280840e-15,
   2.912954165073964e-16,  -1.008442377002133e-17,   1.584160586952996e-02,  -3.634885003486877e-03,   5.598312198543959e-04,  -6.368650836870441e-05,   5.855575248887006e-06,
  -4.538047464645811e-07,   3.040881693908082e-08,  -1.797252812814019e-09,   9.506615335489772e-11,  -4.548684655819318e-12,   1.987521775745273e-13,  -7.993731526959056e-15,
   2.976159110512829e-16,  -1.030615943327908e-17,   1.596263949789090e-02,  -3.674437154994260e-03,   5.670161035921774e-04,  -6.461003797868546e-05,   5.948200362413926e-06,
  -4.614610789212798e-07,   3.094854324803819e-08,  -1.830451273123910e-09,   9.687940771366131e-11,  -4.637826320691069e-12,   2.027354579765227e-13,  -8.156930288704128e-15,
   3.037944644848071e-16,  -1.052293062206678e-17,   1.606051867128627e-02,  -3.706436616337259e-03,   5.728311078460759e-04,  -6.535770600053656e-05,   6.023205928457746e-06,
  -4.676622475048255e-07,   3.138576282867066e-08,  -1.857348507712936e-09,   9.834868044226264e-11,  -4.710065013130144e-12,   2.059637416366757e-13,  -8.289206219571500e-15,
   3.088025604332561e-16,  -1.069864769915491e-17,   1.612538006025449e-02,  -3.727648424663429e-03,   5.766867925912203e-04,  -6.585356081094523e-05,   6.072958781583625e-06,
  -4.717762350418166e-07,   3.167585972272527e-08,  -1.875196857402558e-09,   9.932374344777806e-11,  -4.758008945245971e-12,   2.081064653058294e-13,  -8.377007278925331e-15,
   3.121269176332244e-16,  -1.081529333687047e-17,   1.615874666403339e-02,  -3.738562501772124e-03,   5.786709713580825e-04,  -6.610876653771291e-05,   6.098568286278849e-06,
  -4.738940360490866e-07,   3.182520713582724e-08,  -1.884386124642188e-09,   9.982578469918474e-11,  -4.782695500242217e-12,   2.092098105482869e-13,  -8.422219900689535e-15,
   3.138388132660870e-16,  -1.087536224773801e-17,   1.617036932721774e-02,  -3.742364560688849e-03,   5.793622363746398e-04,  -6.619768256503206e-05,   6.107491317605791e-06,
  -4.746319643994559e-07,   3.187724764856703e-08,  -1.887588244741150e-09,   1.000007319232243e-10,  -4.791298250692060e-12,   2.095943108384211e-13,  -8.437976106225928e-15,
   3.144354000695179e-16,  -1.089629620947918e-17,   1.617221411650471e-02,  -3.742968052489089e-03,   5.794719616464355e-04,  -6.621179655705322e-05,   6.108907726659077e-06,
  -4.747491018576618e-07,   3.188550855298249e-08,  -1.888096553385281e-09,   1.000285034782718e-10,  -4.792663881209861e-12,   2.096553481046307e-13,  -8.440477327090245e-15,
   3.145301056056080e-16,  -1.089961939614409e-17,   5.298775424361660e-01,  -1.500480000510223e-02,   5.037714336533651e-04,  -1.757504257883698e-05,   6.773677125009439e-07,
  -2.273956730504623e-08,   6.477796858135757e-10,  -2.607238647187608e-11,   1.038536191771822e-12,  -1.801637110694209e-14,   4.346466443946291e-16,  -4.739019429567750e-17,
   6.813088571483859e-19,   4.490312121235994e-20,   5.299255466560272e-01,  -1.500981972020355e-02,   5.041577972870918e-04,  -1.759680260046754e-05,   6.783114493347491e-07,
  -2.279197454466261e-08,   6.505475363528359e-10,  -2.613926575503619e-11,   1.040530944237815e-12,  -1.825083383580646e-14,   4.395526644570539e-16,  -4.712604152089698e-17,
   6.967510562630312e-19,   4.372505473570147e-20,   5.300102809528914e-01,  -1.501868213944632e-02,   5.048399813456787e-04,  -1.763523878314298e-05,   6.799798689164375e-07,
  -2.288455796730355e-08,   6.554358088047151e-10,  -2.625791159934711e-11,   1.044068133610357e-12,  -1.866350476483795e-14,   4.482829846024969e-16,  -4.666680818829392e-17,
   7.236214813879706e-19,   4.165630990669869e-20,   5.301127939100786e-01,  -1.502940729364201e-02,   5.056656357275385e-04,  -1.768178496940798e-05,   6.820027672076461e-07,
  -2.299669912282675e-08,   6.613542145468177e-10,  -2.640246248143219e-11,   1.048375205777800e-12,  -1.916075324971821e-14,   4.589639790343000e-16,  -4.612316821189159e-17,
   7.554789758777081e-19,   3.917186201816084e-20,   5.302123655083386e-01,  -1.503982812490550e-02,   5.064679535185964e-04,  -1.772704326437278e-05,   6.839722499383634e-07,
  -2.310576187437762e-08,   6.671075400086724e-10,  -2.654392176637437e-11,   1.052587922850753e-12,  -1.964165773821255e-14,   4.694613902636235e-16,  -4.560757960184862e-17,
   7.857529760357451e-19,   3.677802872994590e-20,   5.302926176581468e-01,  -1.504822949196930e-02,   5.071148549472283e-04,  -1.776355444458048e-05,   6.855629182578937e-07,
  -2.319376393805184e-08,   6.717479848711534e-10,  -2.665868879012380e-11,   1.056004340506870e-12,  -2.002778461885983e-14,   4.780089337874135e-16,  -4.520090876946936e-17,
   8.096818563349937e-19,   3.486258195939199e-20,   5.303456657404909e-01,  -1.505378414122242e-02,   5.075425927197801e-04,  -1.778770571066937e-05,   6.866160018341258e-07,
  -2.325198417046258e-08,   6.748170795792599e-10,  -2.673492036725001e-11,   1.058273025946401e-12,  -2.028230895948232e-14,   4.837011005106673e-16,  -4.493642303674529e-17,
   8.252719495091755e-19,   3.360328133035066e-20,   5.303729143132617e-01,  -1.505663770196361e-02,   5.077623422233630e-04,  -1.780011637913217e-05,   6.871574288998583e-07,
  -2.328190475824835e-08,   6.763940656942721e-10,  -2.677419112337621e-11,   1.059441573783816e-12,  -2.041282869953683e-14,   4.866378472018320e-16,  -4.480190346361494e-17,
   8.332103442422769e-19,   3.295855329524683e-20,   5.303823993591272e-01,  -1.505763106638238e-02,   5.078388416995215e-04,  -1.780443727413292e-05,   6.873459760006028e-07,
  -2.329232235426428e-08,   6.769430871107276e-10,  -2.678787911061820e-11,   1.059848850992819e-12,  -2.045822706538279e-14,   4.876621572693915e-16,  -4.475529040288534e-17,
   8.359626326506924e-19,   3.273446604242857e-20,   5.303839045494568e-01,  -1.505778870706386e-02,   5.078509817609237e-04,  -1.780512299992510e-05,   6.873759005031193e-07,
  -2.329397564769980e-08,   6.770302157537861e-10,  -2.679005212835313e-11,   1.059913506572517e-12,  -2.046542972861028e-14,   4.878248030012114e-16,  -4.474790340687503e-17,
   8.363988741703581e-19,   3.269892150533465e-20,   1.342535357557551e-01,  -7.755107862600949e-03,   6.017752126416135e-04,  -3.869598102648509e-05,   2.145530955225956e-06,
  -1.130729073797404e-07,   5.580335454701395e-09,  -2.462531220835906e-10,   1.023416577915728e-11,  -4.232441470600333e-13,   1.609217566892770e-14,  -5.416147966644396e-16,
   1.893527529042103e-17,  -6.741731736166859e-19,   1.343124691049652e-01,  -7.766380598909281e-03,   6.030284607841837e-04,  -3.880629020170119e-05,   2.153716067098227e-06,
  -1.135818732044761e-07,   5.608698465513230e-09,  -2.477604981973581e-10,   1.030611211291162e-11,  -4.262407439996586e-13,   1.621714251502888e-14,  -5.468126618891102e-16,
   1.910134269640615e-17,  -6.789410293447610e-19,   1.344165590718974e-01,  -7.786297500732934e-03,   6.052436605326312e-04,  -3.900132792287314e-05,   2.168191847945204e-06,
  -1.144824034087294e-07,   5.658901470502066e-09,  -2.504286603666837e-10,   1.043349810912266e-11,  -4.315503550791575e-13,   1.643850181452170e-14,  -5.560135443815081e-16,
   1.939599320740106e-17,  -6.874148060958773e-19,   1.345425984472701e-01,  -7.810425595564615e-03,   6.079288340249928e-04,  -3.923784518902226e-05,   2.185752546252655e-06,
  -1.155755243232889e-07,   5.719874161954741e-09,  -2.536693495626479e-10,   1.058827931042377e-11,  -4.380085074374744e-13,   1.670763243411267e-14,  -5.671893319735112e-16,
   1.975505274080722e-17,  -6.977652900871697e-19,   1.346651363888300e-01,  -7.833895272230123e-03,   6.105424059590428e-04,  -3.946816117051424e-05,   2.202859418934015e-06,
  -1.166411069938667e-07,   5.779345484857581e-09,  -2.568304027048995e-10,   1.073932065578673e-11,  -4.443175725445718e-13,   1.697043642286746e-14,  -5.780912523294611e-16,
   2.010651636399546e-17,  -7.079224182964847e-19,   1.347639813102708e-01,  -7.852835542065258e-03,   6.126527845063393e-04,  -3.965420998254274e-05,   2.216683057939003e-06,
  -1.175026873964146e-07,   5.827456074101191e-09,  -2.593877257282056e-10,   1.086156004870919e-11,  -4.494285255945883e-13,   1.718325392127730e-14,  -5.869116525366993e-16,
   2.039172469296968e-17,  -7.161831838975611e-19,   1.348293599782855e-01,  -7.865367313615432e-03,   6.140496973869406e-04,  -3.977739754188537e-05,   2.225838358461634e-06,
  -1.180735554228665e-07,   5.859345474400476e-09,  -2.610828721168388e-10,   1.094260979607405e-11,  -4.528197145497934e-13,   1.732442349916245e-14,  -5.927586904853990e-16,
   2.058120056476783e-17,  -7.216801662765453e-19,   1.348629547705348e-01,  -7.871808048171549e-03,   6.147678258517277e-04,  -3.984073760805759e-05,   2.230546512231192e-06,
  -1.183672038711451e-07,   5.875752806169659e-09,  -2.619550572169701e-10,   1.098431827539453e-11,  -4.545655769691308e-13,   1.739708936721678e-14,  -5.957672189311613e-16,
   2.067881946289232e-17,  -7.245150250561924e-19,   1.348746508862415e-01,  -7.874050612450308e-03,   6.150178960150497e-04,  -3.986279602301192e-05,   2.232186258982525e-06,
  -1.184694874480660e-07,   5.881468404102652e-09,  -2.622588916149556e-10,   1.099884892836742e-11,  -4.551739294547206e-13,   1.742240825753411e-14,  -5.968152890572356e-16,
   2.071284659805722e-17,  -7.255036186869228e-19,   1.348765070478477e-01,  -7.874406514866256e-03,   6.150575843555508e-04,  -3.986629697495631e-05,   2.232446513157849e-06,
  -1.184857220782182e-07,   5.882375622341516e-09,  -2.623071184116635e-10,   1.100115539044945e-11,  -4.552704993408658e-13,   1.742642729309012e-14,  -5.969816472640431e-16,
   2.071824860865116e-17,  -7.256605848729164e-19,   6.927335558210138e-03,  -1.095609836287233e-03,   1.477518490766018e-04,  -1.494081400601336e-05,   1.249331163223301e-06,
  -9.050815309112143e-08,   5.750547773474666e-09,  -3.245360727992414e-10,   1.656322323944469e-11,  -7.712510170510565e-13,   3.280964341909012e-14,  -1.288875141514742e-15,
   4.738792975846360e-17,  -1.615297267166595e-18,   6.942697874984747e-03,  -1.100132528291401e-03,   1.485036894151432e-04,  -1.503145928397376e-05,   1.257973611224082e-06,
  -9.119190877246915e-08,   5.797128048088525e-09,  -3.273273513648626e-10,   1.671188728371312e-11,  -7.783978506203885e-13,   3.312491910578868e-14,  -1.301608064253797e-15,
   4.785837929002421e-17,  -1.631801209061174e-18,   6.969868230436474e-03,  -1.108134641625441e-03,   1.498344086515575e-04,  -1.519193943862060e-05,   1.273277835507640e-06,
  -9.240296791099212e-08,   5.879643221696240e-09,  -3.322725883644206e-10,   1.697530826440447e-11,  -7.910628809985223e-13,   3.368363765004333e-14,  -1.324175369788521e-15,
   4.869237482060280e-17,  -1.661051497137719e-18,   7.002831093936611e-03,  -1.117848059673812e-03,   1.514505116323028e-04,  -1.538690863898566e-05,   1.291877032653472e-06,
  -9.387519348685104e-08,   5.979974753790089e-09,  -3.382865961191152e-10,   1.729572263835712e-11,  -8.064704979078273e-13,   3.436336819549649e-14,  -1.351634802799685e-15,
   4.970748632526396e-17,  -1.696641815433568e-18,   7.034944459559198e-03,  -1.127316721678170e-03,   1.530267315005237e-04,  -1.557714253040063e-05,   1.310030702974079e-06,
  -9.531260102061021e-08,   6.077956365528792e-09,  -3.441608098802717e-10,   1.760875445204714e-11,  -8.215256281343645e-13,   3.502757272541528e-14,  -1.378471491527537e-15,
   5.069991239283835e-17,  -1.731424398513540e-18,   7.060896169660229e-03,  -1.134972606895564e-03,   1.543017851620983e-04,  -1.573108335007473e-05,   1.324725435668399e-06,
  -9.647645063895983e-08,   6.157307191477078e-09,  -3.489188294077930e-10,   1.786235199417901e-11,  -8.337240961623587e-13,   3.556576465824816e-14,  -1.400219904477454e-15,
   5.150441207029648e-17,  -1.759611919099863e-18,   7.078084637945477e-03,  -1.140045247690969e-03,   1.551469053662211e-04,  -1.583314385924518e-05,   1.334470003471933e-06,
  -9.724839513416573e-08,   6.209946119299362e-09,  -3.520755284522681e-10,   1.803062365550598e-11,  -8.418191291602401e-13,   3.592292359408316e-14,  -1.414654286398223e-15,
   5.203847336223765e-17,  -1.778319886603056e-18,   7.086924140301077e-03,  -1.142654556266185e-03,   1.555817165956955e-04,  -1.588566189168287e-05,   1.339485010392571e-06,
  -9.764572211503720e-08,   6.237042350431926e-09,  -3.537005753214325e-10,   1.811725580083110e-11,  -8.459870088138317e-13,   3.610681641690003e-14,  -1.422086686417919e-15,
   5.231350239244232e-17,  -1.787952800396322e-18,   7.090002786025461e-03,  -1.143563429585637e-03,   1.557331843587791e-04,  -1.590395801922521e-05,   1.341232235535439e-06,
  -9.778415829539136e-08,   6.246483582028106e-09,  -3.542668142843342e-10,   1.814744343455941e-11,  -8.474393818314714e-13,   3.617089765186968e-14,  -1.424676734000736e-15,
   5.240935037282087e-17,  -1.791309686497478e-18,   7.090491418541735e-03,  -1.143707687538207e-03,   1.557572262730968e-04,  -1.590686215798915e-05,   1.341509577130851e-06,
  -9.780613299703548e-08,   6.247982257073997e-09,  -3.543566983667942e-10,   1.815223543596900e-11,  -8.476699343781326e-13,   3.618107005475638e-14,  -1.425087887675607e-15,
   5.242456590315093e-17,  -1.791842571063339e-18,   4.768032291027455e-01,  -1.166404561504338e-02,   3.450950735027682e-04,  -9.718625243997282e-06,   3.359343183079764e-07,
  -1.276174563647831e-08,   2.903523678762909e-10,  -2.967868726584722e-12,   3.583035785200328e-13,  -2.345482916298934e-14,  -8.435246673359992e-17,   3.119051923369695e-17,
   1.221252622367848e-18,  -9.277809016390436e-20,   4.768359658589298e-01,  -1.166682134142617e-02,   3.452864095881713e-04,  -9.730649707791163e-06,   3.363537160572654e-07,
  -1.276878403968416e-08,   2.912904051722208e-10,  -3.043505560746704e-12,   3.581526759373554e-13,  -2.331635470289123e-14,  -7.782360174542677e-17,   3.060239943839368e-17,
   1.198185188603163e-18,  -9.108694347392035e-20,   4.768937452505893e-01,  -1.167172191480570e-02,   3.456242195352050e-04,  -9.751872793665683e-06,   3.370948217110870e-07,
  -1.278132278212708e-08,   2.929453864196125e-10,  -3.176604107065782e-12,   3.579079231437265e-13,  -2.307438979264389e-14,  -6.641260657861825e-17,   2.957420118303619e-17,
   1.158101048702761e-18,  -8.814080756191984e-20,   4.769636380741694e-01,  -1.167765244839818e-02,   3.460330347606099e-04,  -9.777545808008322e-06,   3.379928018946346e-07,
  -1.279668791245247e-08,   2.949462964490481e-10,  -3.336932274935183e-12,   3.576484067564830e-13,  -2.278582694984625e-14,  -5.279860458160484e-17,   2.834702440645455e-17,
   1.110672513727956e-18,  -8.464226702047952e-20,   4.770315153938842e-01,  -1.168341463910481e-02,   3.464302534202488e-04,  -9.802479100345815e-06,   3.388664589690588e-07,
  -1.281181636128325e-08,   2.968884584473791e-10,  -3.491936530928657e-12,   3.574343207882858e-13,  -2.250987497763336e-14,  -3.977276462790884e-17,   2.717240633911109e-17,
   1.065703709999544e-18,  -8.131204073625957e-20,   4.770862155314418e-01,  -1.168806011921135e-02,   3.467504971890220e-04,  -9.822572524752328e-06,   3.395716366831593e-07,
  -1.282415537371413e-08,   2.984528606116441e-10,  -3.616351584332678e-12,   3.572887553449156e-13,  -2.229054288773350e-14,  -2.941392670265418e-17,   2.623798563333658e-17,
   1.030235256800674e-18,  -7.867599750337578e-20,   4.771223697398898e-01,  -1.169113150052076e-02,   3.469622308904953e-04,  -9.835853590358574e-06,   3.400382767854840e-07,
  -1.283238292706138e-08,   2.994865133332785e-10,  -3.698341926726506e-12,   3.572056514857753e-13,  -2.214705747919055e-14,  -2.263417595401907e-17,   2.562627963424763e-17,
   1.007164727913493e-18,  -7.695678863465000e-20,   4.771409395426749e-01,  -1.169270933713156e-02,   3.470710041330978e-04,  -9.842675198520557e-06,   3.402781263876059e-07,
  -1.283663107288732e-08,   3.000173221704634e-10,  -3.740379903408538e-12,   3.571670012527075e-13,  -2.207381583163208e-14,  -1.917245550737311e-17,   2.531390408649831e-17,
   9.954292337228075e-19,  -7.608084280857701e-20,   4.771474033922523e-01,  -1.169325860284852e-02,   3.471088696853094e-04,  -9.845049704497167e-06,   3.403616412851726e-07,
  -1.283811332262104e-08,   3.002020718632976e-10,  -3.755000811871612e-12,   3.571541882389396e-13,  -2.204839406821228e-14,  -1.797074342579311e-17,   2.520545887580726e-17,
   9.913623829266395e-19,  -7.577706372375490e-20,   4.771484291379817e-01,  -1.169334576779973e-02,   3.471148787132157e-04,  -9.845426514579331e-06,   3.403748955180786e-07,
  -1.283834870816475e-08,   3.002313889481423e-10,  -3.757320436834569e-12,   3.571521853187213e-13,  -2.204436333547358e-14,  -1.778019855315663e-17,   2.518826338499061e-17,
   9.907178727676461e-19,  -7.572891038393375e-20,   1.105658767019270e-01,  -4.348771903763191e-03,   2.872149392434677e-04,  -1.700517277360957e-05,   8.095132301172228e-07,
  -3.543739737158841e-08,   1.655776073128964e-09,  -7.306068986404307e-11,   2.554188424285968e-12,  -8.238938653738088e-14,   3.620131169496008e-15,  -1.489697558164383e-16,
   2.959818470876888e-18,  -3.145714782025583e-20,   1.105937449174825e-01,  -4.353676318745860e-03,   2.876839516743978e-04,  -1.703964977363693e-05,   8.119253893100166e-07,
  -3.558603030305626e-08,   1.662812130170735e-09,  -7.335924171561032e-11,   2.570130621219331e-12,  -8.317288136820885e-14,   3.640625146056851e-15,  -1.493428063311730e-16,
   3.007146424856146e-18,  -3.409153344244945e-20,   1.106429562224124e-01,  -4.362338339770135e-03,   2.885126545407142e-04,  -1.710059976583024e-05,   8.161898577059323e-07,
  -3.584878344157914e-08,   1.675261798540415e-09,  -7.388820279966418e-11,   2.598333078899895e-12,  -8.455707873342789e-14,   3.677023051114116e-15,  -1.500163256300171e-16,
   3.090459285355706e-18,  -3.871011845333506e-20,   1.107025268908018e-01,  -4.372826383924131e-03,   2.895166484151562e-04,  -1.717449712280999e-05,   8.213604656991680e-07,
  -3.616734179217285e-08,   1.690374892610118e-09,  -7.453151736383569e-11,   2.632559451155465e-12,  -8.623382118275296e-14,   3.721437496416362e-15,  -1.508566660829036e-16,
   3.190874330192548e-18,  -4.424487170151758e-20,   1.107604239890092e-01,  -4.383022507861333e-03,   2.904933196330242e-04,  -1.724644095388694e-05,   8.263946636214111e-07,
  -3.647746959018839e-08,   1.705108158221445e-09,  -7.515990363485863e-11,   2.665916018453642e-12,  -8.786472441848421e-14,   3.764974160753032e-15,  -1.516994446849474e-16,
   3.288024868626898e-18,  -4.956643845718983e-20,   1.108071131457430e-01,  -4.391246787271811e-03,   2.912815567456985e-04,  -1.730454548400782e-05,   8.304606772786509e-07,
  -3.672793492704086e-08,   1.717021416042250e-09,  -7.566889769818085e-11,   2.692881416408312e-12,  -8.918085493582631e-14,   3.800347047895603e-15,  -1.523976133036144e-16,
   3.366059939350679e-18,  -5.381722220702445e-20,   1.108379880371436e-01,  -4.396686350553244e-03,   2.918031175083937e-04,  -1.734301224501735e-05,   8.331525920248585e-07,
  -3.689374749453059e-08,   1.724915229482515e-09,  -7.600659152666208e-11,   2.710745788353248e-12,  -9.005167029659821e-14,   3.823867654728814e-15,  -1.528683291939723e-16,
   3.417515925776851e-18,  -5.660861144777664e-20,   1.108538510523933e-01,  -4.399481407067585e-03,   2.920711829885002e-04,  -1.736278915410585e-05,   8.345366186051079e-07,
  -3.697899609303999e-08,   1.728975813627353e-09,  -7.618043421309495e-11,   2.719934302853190e-12,  -9.049923143656987e-14,   3.835991977426912e-15,  -1.531129561619319e-16,
   3.443908316971368e-18,  -5.803678345263527e-20,   1.108593734797290e-01,  -4.400454503828278e-03,   2.921645205285223e-04,  -1.736967625423506e-05,   8.350185965710760e-07,
  -3.700868293408933e-08,   1.730390209816608e-09,  -7.624100876007635e-11,   2.723134730584552e-12,  -9.065506612502769e-14,   3.840219177397811e-15,  -1.531985604457459e-16,
   3.453089287023655e-18,  -5.853302676893071e-20,   1.108602498679502e-01,  -4.400608932836200e-03,   2.921793335675948e-04,  -1.737076931149209e-05,   8.350950919382808e-07,
  -3.701339455290256e-08,   1.730614705951850e-09,  -7.625062428801773e-11,   2.723642702756858e-12,  -9.067979765271708e-14,   3.840890318420153e-15,  -1.532121664713946e-16,
   3.454545937678388e-18,  -5.861173373529812e-20,   4.118587184592163e-03,  -3.916712009859792e-04,   4.653344066790854e-05,  -4.203504162231593e-06,   3.098092370838995e-07,
  -2.039843955280879e-08,   1.227653399319780e-09,  -6.597527473734174e-11,   3.168338933201552e-12,  -1.416998674623049e-13,   6.007638196411149e-15,  -2.300433610885684e-16,
   7.799418282001020e-18,  -2.656418052747814e-19,   4.123320677466822e-03,  -3.929251769609260e-04,   4.671810959153865e-05,  -4.223797073494959e-06,   3.116415334183035e-07,
  -2.053654220907552e-08,   1.236534083828762e-09,  -6.648691474595712e-11,   3.195384484598896e-12,  -1.429685879852189e-13,   6.059909284104320e-15,  -2.321408242107913e-16,
   7.885392162945772e-18,  -2.684197938664641e-19,   4.131688343910520e-03,  -3.951426840653410e-04,   4.704482404372541e-05,  -4.259712056681516e-06,   3.148850264276279e-07,
  -2.078106207027035e-08,   1.252262952893948e-09,  -6.739325411444981e-11,   3.243289616319341e-12,  -1.452162182524614e-13,   6.152579565222308e-15,  -2.358586270718448e-16,
   8.037508539909925e-18,  -2.733423599093012e-19,   4.141832827745186e-03,  -3.978323991280088e-04,   4.744136587346246e-05,  -4.303325128750921e-06,   3.188248337194066e-07,
  -2.107816671929283e-08,   1.271382933596157e-09,  -6.849526668196487e-11,   3.301529788782087e-12,  -1.479493909714880e-13,   6.265384266215934e-15,  -2.403829580466706e-16,
   8.222163234833538e-18,  -2.793302603525799e-19,   4.151708429728536e-03,  -4.004522230966462e-04,   4.782787093115587e-05,  -4.345857500871351e-06,   3.226681682834472e-07,
  -2.136809183999812e-08,   1.290049831542190e-09,  -6.957144634732668e-11,   3.358397196508635e-12,  -1.506188068533384e-13,   6.375677061509485e-15,  -2.448052886226497e-16,
   8.402180412662497e-18,  -2.851804709561249e-19,   4.159683843890961e-03,  -4.025689651857894e-04,   4.814034733373587e-05,  -4.380260111744527e-06,   3.257777048025432e-07,
  -2.160273081535132e-08,   1.305163514155270e-09,  -7.044297854091809e-11,   3.404445398140837e-12,  -1.527808325323996e-13,   6.465090544310047e-15,  -2.483895673947927e-16,
   8.547749698294218e-18,  -2.899200971002208e-19,   4.164963547508877e-03,  -4.039707352844856e-04,   4.834737232759079e-05,  -4.403061006606701e-06,   3.278390073437350e-07,
  -2.175830584978588e-08,   1.315187614665868e-09,  -7.102111817525126e-11,   3.434989431516828e-12,  -1.542151477529289e-13,   6.524449609245835e-15,  -2.507686542679034e-16,
   8.644211277475554e-18,  -2.930650971820298e-19,   4.167677929161365e-03,  -4.046915604439248e-04,   4.845385873152149e-05,  -4.414791502639649e-06,   3.288996222264117e-07,
  -2.183836522034147e-08,   1.320347010461207e-09,  -7.131871667908112e-11,   3.450711271189686e-12,  -1.549534998576989e-13,   6.555018873074686e-15,  -2.519937323414535e-16,
   8.693833622285816e-18,  -2.946842754273317e-19,   4.168623172696538e-03,  -4.049426014688933e-04,   4.849094925392167e-05,  -4.418877778702489e-06,   3.292691036305560e-07,
  -2.186625677712222e-08,   1.322144624573766e-09,  -7.142240950840389e-11,   3.456189142598476e-12,  -1.552107710178846e-13,   6.565672414484175e-15,  -2.524206584379171e-16,
   8.711118672171183e-18,  -2.952484938284827e-19,   4.168773192533474e-03,  -4.049824454038840e-04,   4.849683628908795e-05,  -4.419526374460046e-06,   3.293277506610711e-07,
  -2.187068402549447e-08,   1.322429968525278e-09,  -7.143886940164351e-11,   3.457058678044001e-12,  -1.552516097522037e-13,   6.567363632017898e-15,  -2.524884307341598e-16,
   8.713862215306678e-18,  -2.953380583208333e-19,   4.350363772917339e-01,  -9.295422294275489e-03,   2.534827195307618e-04,  -6.021512692126011e-06,   1.471922857026745e-07,
  -6.224273483936531e-09,   2.534189219540168e-10,  -2.734718925884701e-12,  -1.997486866087092e-13,  -8.997932744927583e-16,   8.032724045638023e-16,  -1.675221608830020e-17,
  -1.609919230232233e-18,   6.085688752779492e-20,   4.350603114757758e-01,  -9.297136567426192e-03,   2.535674935956351e-04,  -6.027393979292022e-06,   1.475433018129446e-07,
  -6.229739196912965e-09,   2.529580134843032e-10,  -2.739605613798570e-12,  -1.966373370342837e-13,  -9.727309336534941e-16,   7.944670175107691e-16,  -1.639378103707399e-17,
  -1.584407381789194e-18,   5.922165990792351e-20,   4.351025504168738e-01,  -9.300162782256122e-03,   2.537172380685973e-04,  -6.037775795854334e-06,   1.481621729319967e-07,
  -6.239392242614700e-09,   2.521512079642904e-10,  -2.748418802263992e-12,  -1.911765140564315e-13,  -1.100013586238136e-15,   7.790538329300294e-16,  -1.577042224906731e-17,
  -1.539780490963652e-18,   5.638261090845161e-20,   4.351536376225204e-01,  -9.303824421012678e-03,   2.538985821606748e-04,  -6.050336753507973e-06,   1.489096669471265e-07,
  -6.251079859540421e-09,   2.511866083758991e-10,  -2.759398147410773e-12,  -1.846227355563213e-13,  -1.251534233968492e-15,   7.606262594133280e-16,  -1.503199499496681e-17,
  -1.486476849295268e-18,   5.302754298719263e-20,   4.352032441737928e-01,  -9.307381493723968e-03,   2.540749119652287e-04,  -6.062538211963874e-06,   1.496344357696265e-07,
  -6.262442011990366e-09,   2.502616561114918e-10,  -2.770391017764072e-12,  -1.783119216434524e-13,  -1.396156004147815e-15,   7.429555500818068e-16,  -1.433098325309729e-17,
  -1.435416432448581e-18,   4.985077514649802e-20,   4.352432151547072e-01,  -9.310248757750324e-03,   2.542171643872744e-04,  -6.072372925246055e-06,   1.502176701369358e-07,
  -6.271606868477441e-09,   2.495247035851565e-10,  -2.779483998578197e-12,  -1.732646436789715e-13,  -1.510912596608157e-15,   7.288756081190036e-16,  -1.377744794845788e-17,
  -1.394770722996120e-18,   4.734819277393600e-20,   4.352696314748552e-01,  -9.312144243265022e-03,   2.543112618029118e-04,  -6.078874163187829e-06,   1.506027543518183e-07,
  -6.277668620282433e-09,   2.490417272225638e-10,  -2.785607743328139e-12,  -1.699473260366943e-13,  -1.585894338141251e-15,   7.196474257858093e-16,  -1.341709734332220e-17,
  -1.368150237355707e-18,   4.572186104084364e-20,   4.352831988212214e-01,  -9.313117928238185e-03,   2.543596161035580e-04,  -6.082213675120413e-06,   1.508004190624311e-07,
  -6.280783421955931e-09,   2.487949261331157e-10,  -2.788788033836476e-12,  -1.682492182606671e-13,  -1.624140876907827e-15,   7.149315900780908e-16,  -1.323370146952028e-17,
  -1.354552484511446e-18,   4.489503516014687e-20,   4.352879212677054e-01,  -9.313456869999327e-03,   2.543764511591898e-04,  -6.083376152643941e-06,   1.508692030708094e-07,
  -6.281867845445467e-09,   2.487092203506359e-10,  -2.789900590450032e-12,  -1.676590489556114e-13,  -1.637411681956801e-15,   7.132938971810019e-16,  -1.317013216403470e-17,
  -1.349831279345647e-18,   4.460857690598804e-20,   4.352886706647677e-01,  -9.313510657372811e-03,   2.543791228831889e-04,  -6.083560627980391e-06,   1.508801174340077e-07,
  -6.282039942229379e-09,   2.486956293032508e-10,  -2.790077404668591e-12,  -1.675654386038732e-13,  -1.639515620899662e-15,   7.130341931975606e-16,  -1.316005706684574e-17,
  -1.349082640073967e-18,   4.456318273839591e-20,   9.672781973767403e-02,  -2.689826542155472e-03,   1.429099827763973e-04,  -8.120687074336167e-06,   3.713014901903134e-07,
  -1.302456519036827e-08,   4.455942379270088e-10,  -2.118060165709275e-11,   9.929527265153843e-13,  -2.699246073562892e-14,   1.855591302920707e-16,  -1.065414313906985e-17,
   2.102848010170326e-18,  -7.935763054423023e-20,   9.674164437610439e-02,  -2.692154855969781e-03,   1.431225694767853e-04,  -8.133262153256522e-06,   3.719592747128733e-07,
  -1.306775036123920e-08,   4.482262933997562e-10,  -2.127372263262737e-11,   9.941322395292847e-13,  -2.706707173841619e-14,   1.979850486381773e-16,  -1.116952066715088e-17,
   2.089791526292862e-18,  -7.812532759047485e-20,   9.676605482465195e-02,  -2.696266141759632e-03,   1.434979902349060e-04,  -8.155484453297613e-06,   3.731229656272517e-07,
  -1.314410135755485e-08,   4.528733531249146e-10,  -2.143825502947130e-11,   9.962556263922043e-13,  -2.720082063265965e-14,   2.198482924549041e-16,  -1.207210476235863e-17,
   2.067042945842851e-18,  -7.598984110744916e-20,   9.679560061807389e-02,  -2.701242569807353e-03,   1.439524794513516e-04,  -8.182412882797647e-06,   3.745352644042695e-07,
  -1.323668195381240e-08,   4.584973884099113e-10,  -2.163758658924778e-11,   9.988949202635866e-13,  -2.736610736528566e-14,   2.461800091750823e-16,  -1.315206411271394e-17,
   2.040027854402283e-18,  -7.347317632164647e-20,   9.682431294443324e-02,  -2.706078860975204e-03,   1.443942421954800e-04,  -8.208614312906269e-06,   3.759116969786629e-07,
  -1.332682616165874e-08,   4.639621680107177e-10,  -2.183149415875857e-11,   1.001531974888930e-12,  -2.753026513776435e-14,   2.716331124822390e-16,  -1.418866743930235e-17,
   2.014316273780307e-18,  -7.109772383421807e-20,   9.684746457525108e-02,  -2.709978688541386e-03,   1.447505172231556e-04,  -8.229764745328421e-06,   3.770244024846591e-07,
  -1.339963782107241e-08,   4.683682061382880e-10,  -2.198799358054980e-11,   1.003709872633340e-12,  -2.766514322889320e-14,   2.920603955344367e-16,  -1.501541985116115e-17,
   1.993970509200709e-18,  -6.923188665237071e-20,   9.686277322234971e-02,  -2.712557475073022e-03,   1.449861319980377e-04,  -8.243761608531457e-06,   3.777615538514458e-07,
  -1.344784489249242e-08,   4.712814628902117e-10,  -2.209154899162134e-11,   1.005175143396936e-12,  -2.775555170397365e-14,   3.055208373753827e-16,  -1.555770244949028e-17,
   1.980705637159267e-18,  -6.802209855302780e-20,   9.687063818191681e-02,  -2.713882377877863e-03,   1.451071917090947e-04,  -8.250956178673381e-06,   3.781407027027148e-07,
  -1.347263075182815e-08,   4.727781288013637e-10,  -2.214477428674669e-11,   1.005935707937431e-12,  -2.780237630139147e-14,   3.124218838109758e-16,  -1.583495848475688e-17,
   1.973948812675254e-18,  -6.740790688008363e-20,   9.687337616854130e-02,  -2.714343613616905e-03,   1.451493372486644e-04,  -8.253461351828648e-06,   3.782727622973610e-07,
  -1.348126235105147e-08,   4.732991481092156e-10,  -2.216330697051991e-11,   1.006201714453482e-12,  -2.781873687509989e-14,   3.148220266663339e-16,  -1.593126485675691e-17,
   1.971605835381651e-18,  -6.719525575293857e-20,   9.687381067378163e-02,  -2.714416809706033e-03,   1.451560256211611e-04,  -8.253858937553623e-06,   3.782937227689466e-07,
  -1.348263228794394e-08,   4.733818310277799e-10,  -2.216624819132446e-11,   1.006243987011068e-12,  -2.782133605373604e-14,   3.152028095636883e-16,  -1.594653810854437e-17,
   1.971234454589378e-18,  -6.716156419836066e-20,   3.065157165292838e-03,  -1.599586935888393e-04,   1.623073088589858e-05,  -1.378709036009069e-06,   9.080458406571240e-08,
  -5.092759368030040e-09,   2.745450635631877e-10,  -1.455705774783580e-11,   6.924162608437894e-13,  -2.766853592348152e-14,   1.010230301732598e-15,  -4.147088296863178e-17,
   1.773113168210177e-18,  -5.251825643158670e-20,   3.066786048839332e-03,  -1.603642312783564e-04,   1.628412891469215e-05,  -1.383739465509591e-06,   9.121345341477139e-08,
  -5.123013693613373e-09,   2.764593374272150e-10,  -1.465648120413286e-11,   6.970435357131006e-13,  -2.789794506271069e-14,   1.021539152151265e-15,  -4.186886578887448e-17,
   1.780053463840259e-18,  -5.275354884946514e-20,   3.069664592216426e-03,  -1.610810043135194e-04,   1.637854298776763e-05,  -1.392639294141386e-06,   9.193713690783072e-08,
  -5.176560071899765e-09,   2.798472016238489e-10,  -1.483255644035616e-11,   7.052475307898622e-13,  -2.830442458303660e-14,   1.041531345111193e-15,  -4.257267348477783e-17,
   1.792539129566339e-18,  -5.318088255755412e-20,   3.073152790434969e-03,  -1.619497760204324e-04,   1.649303828425019e-05,  -1.403441314313986e-06,   9.281602815975230e-08,
  -5.241586107448712e-09,   2.839611183461516e-10,  -1.504656461017916e-11,   7.152346427910981e-13,  -2.879881917424530e-14,   1.065770956008382e-15,  -4.342643414645633e-17,
   1.808043354007819e-18,  -5.371809922746860e-20,   3.076546870561279e-03,  -1.627953079177733e-04,   1.660453355436852e-05,  -1.413969990645473e-06,   9.367323590357475e-08,
  -5.305003431434354e-09,   2.879730012636664e-10,  -1.525547194291397e-11,   7.249999802872618e-13,  -2.928178589212782e-14,   1.089371283728058e-15,  -4.425814721651316e-17,
   1.823517939473972e-18,  -5.426075559753670e-20,   3.079286694346858e-03,  -1.634779965924387e-04,   1.669460068579343e-05,  -1.422482113990770e-06,   9.436666124380365e-08,
  -5.356300872212640e-09,   2.912179880753779e-10,  -1.542459318164326e-11,   7.329170640616740e-13,  -2.967302364207123e-14,   1.108433518733166e-15,  -4.493028222525784e-17,
   1.836285826029464e-18,  -5.471284097610827e-20,   3.081099865553221e-03,  -1.639298601272649e-04,   1.675423712554657e-05,  -1.428121669368710e-06,   9.482627249928387e-08,
  -5.390300031564596e-09,   2.933686360090919e-10,  -1.553675215690268e-11,   7.381731724559097e-13,  -2.993260891428767e-14,   1.121054335867913e-15,  -4.537547082184856e-17,
   1.844869741652228e-18,  -5.501879488805195e-20,   3.082031865333394e-03,  -1.641621474689936e-04,   1.678490097827553e-05,  -1.431022464325147e-06,   9.506274098192434e-08,
  -5.407792050755128e-09,   2.944750860621583e-10,  -1.559447717249680e-11,   7.408800632774741e-13,  -3.006624729358202e-14,   1.127543471065078e-15,  -4.560442591546980e-17,
   1.849323359834588e-18,  -5.517813296308459e-20,   3.082356391727328e-03,  -1.642430344527105e-04,   1.679557981786760e-05,  -1.432032847637796e-06,   9.514511548847893e-08,
  -5.413885379611353e-09,   2.948605132542034e-10,  -1.561458897665026e-11,   7.418234364105839e-13,  -3.011281375440672e-14,   1.129803312018579e-15,  -4.568416859681912e-17,
   1.850880693144622e-18,  -5.523394325985895e-20,   3.082407896022958e-03,  -1.642558718718170e-04,   1.679727468780888e-05,  -1.432193216462273e-06,   9.515819048803574e-08,
  -5.414852547837829e-09,   2.949216903040880e-10,  -1.561778139687700e-11,   7.419731944275388e-13,  -3.012020569866879e-14,   1.130161976539541e-15,  -4.569682517337729e-17,
   1.851128162572692e-18,  -5.524281622700363e-20,   4.014993140291885e-01,  -7.524048561007401e-03,   1.922178299145507e-04,  -4.369501326438344e-06,   7.410595752939442e-08,
  -1.644309717857853e-09,   1.140799214469224e-10,  -5.681252654591972e-12,   6.342532592250634e-14,   7.529558570870651e-15,  -3.000963268546529e-16,  -9.908386654594258e-18,
   1.059704685051302e-18,  -1.213564596812631e-20,   4.015174199558741e-01,  -7.525283248944807e-03,   1.922604303222915e-04,  -4.371133345818883e-06,   7.426806030574899e-08,
  -1.655115576507346e-09,   1.142246063307622e-10,  -5.657224095649990e-12,   6.234294053961209e-14,   7.476715355200286e-15,  -2.942722328349512e-16,  -9.959126992756498e-18,
   1.043652499110112e-18,  -1.141512072775080e-20,   4.015493715055039e-01,  -7.527462264034454e-03,   1.923356739281503e-04,  -4.374021190243985e-06,   7.455425027599041e-08,
  -1.674144908972390e-09,   1.144777046156059e-10,  -5.614971477848009e-12,   6.045239332894779e-14,   7.383297390620031e-15,  -2.840744840767429e-16,  -1.004467174511804e-17,
   1.015489609880550e-18,  -1.016594221753870e-20,   4.015880133888932e-01,  -7.530097816538863e-03,   1.924267864026020e-04,  -4.377527029448842e-06,   7.490058041548770e-08,
  -1.697091132469866e-09,   1.147800294063656e-10,  -5.564128648265401e-12,   5.819911487674838e-14,   7.270047514228527e-15,  -2.718773226632819e-16,  -1.014140211472614e-17,
   9.817111058682874e-19,  -8.692890893021477e-21,   4.016255322639525e-01,  -7.532657062387480e-03,   1.925153699742972e-04,  -4.380944892181754e-06,   7.523706835667857e-08,
  -1.719299854214196e-09,   1.150696560697921e-10,  -5.515032922720888e-12,   5.604577740487744e-14,   7.159818920055934e-15,  -2.601762016356533e-16,  -1.022838916554480e-17,
   9.492102503561687e-19,  -7.301628029439216e-21,   4.016557612868827e-01,  -7.534719258143282e-03,   1.925868271963433e-04,  -4.383708617372070e-06,   7.550833540890741e-08,
  -1.737142997899023e-09,   1.153002309079221e-10,  -5.475669729642824e-12,   5.433535033937919e-14,   7.070823833677431e-15,  -2.508494964632857e-16,  -1.029358618196513e-17,
   9.232371841249700e-19,  -6.208267519011592e-21,   4.016757381960561e-01,  -7.536082165909088e-03,   1.926340916063731e-04,  -4.385539893214626e-06,   7.568767958637694e-08,
  -1.748910028173098e-09,   1.154512567072597e-10,  -5.449751222093247e-12,   5.321694985716161e-14,   7.011925189657774e-15,  -2.447351199659612e-16,  -1.033430953169044e-17,
   9.061774190062991e-19,  -5.499084187218752e-21,   4.016859979474136e-01,  -7.536782160292823e-03,   1.926583786040117e-04,  -4.386481902947768e-06,   7.577981088694182e-08,
  -1.754945736713390e-09,   1.155284052494901e-10,  -5.436469296265443e-12,   5.264623893184155e-14,   6.981650198588442e-15,  -2.416100638253430e-16,  -1.035450035866970e-17,
   8.974482680558612e-19,  -5.138965509135710e-21,   4.016895690517576e-01,  -7.537025811861532e-03,   1.926668342185651e-04,  -4.386810026596770e-06,   7.581188271264445e-08,
  -1.757045371301280e-09,   1.155551923515649e-10,  -5.431850934185950e-12,   5.244817621556453e-14,   6.971108370212389e-15,  -2.405247385449036e-16,  -1.036141351067956e-17,
   8.944150845948753e-19,  -5.014270006111212e-21,   4.016901357417692e-01,  -7.537064476585080e-03,   1.926681761174607e-04,  -4.386862107096958e-06,   7.581697229176824e-08,
  -1.757378499867402e-09,   1.155594400064176e-10,  -5.431118278999229e-12,   5.241677382597774e-14,   6.969435322637119e-15,  -2.403526252359751e-16,  -1.036250511111895e-17,
   8.939340013200467e-19,  -4.994513214955977e-21,   8.775818159872520e-02,  -1.852145128173682e-03,   7.397309216193209e-05,  -3.830791454319609e-06,   1.846455681702661e-07,
  -6.702257654532605e-09,   1.622018650757395e-10,  -3.294006636746800e-12,   1.993256124781239e-13,  -1.431997897226860e-14,   5.003765511391541e-16,   1.134691580774439e-18,
  -7.076705882479644e-19,   6.619356219800714e-21,   8.776532776376056e-02,  -1.853244899834262e-03,   7.407828437376396e-05,  -3.837136531411227e-06,   1.848803976432294e-07,
  -6.709508516711746e-09,   1.627659330638285e-10,  -3.342174069288453e-12,   2.013197717036263e-13,  -1.431377453410442e-14,   4.966443292346855e-16,   1.148921700130054e-18,
  -6.935570493596569e-19,   5.975241576382556e-21,   8.777794546258706e-02,  -1.855186926139446e-03,   7.426400669051814e-05,  -3.848338282336140e-06,   1.852954187649298e-07,
  -6.722379793782056e-09,   1.637654265653928e-10,  -3.427149098128913e-12,   2.048262594995318e-13,  -1.430280089233524e-14,   4.901285399066023e-16,   1.170432310701118e-18,
  -6.687634017370657e-19,   4.855968975732220e-21,   8.779321686932318e-02,  -1.857537738743983e-03,   7.448877017477690e-05,  -3.861893425075584e-06,   1.857983967291324e-07,
  -6.738075180566742e-09,   1.649811460787384e-10,  -3.529872537109192e-12,   2.090456381265596e-13,  -1.428949740910526e-14,   4.823681653489227e-16,   1.190375396938282e-18,
  -6.389710797836483e-19,   3.531708432505831e-21,   8.780805670311308e-02,  -1.859822479492489e-03,   7.470716180290593e-05,  -3.875062905662783e-06,   1.862878664620860e-07,
  -6.753449463515733e-09,   1.661687809200738e-10,  -3.629564017929124e-12,   2.131202633438364e-13,  -1.427655959431422e-14,   4.749582191681304e-16,   1.203468123246763e-18,
  -6.102477672757812e-19,   2.276330739346516e-21,   8.782002195828828e-02,  -1.861664909700087e-03,   7.488323526004683e-05,  -3.885679543226259e-06,   1.866830306019316e-07,
  -6.765933268061027e-09,   1.671308361472344e-10,  -3.709852221530249e-12,   2.163874871088969e-13,  -1.426612937640927e-14,   4.690771385253486e-16,   1.209585119942533e-18,
  -5.872517503372870e-19,   1.286393608263164e-21,   8.782793351827388e-02,  -1.862883272074667e-03,   7.499965009041191e-05,  -3.892698502870896e-06,   1.869445671819798e-07,
  -6.774230556373146e-09,   1.677691398493821e-10,  -3.762894491530690e-12,   2.185390062355324e-13,  -1.425923703976548e-14,   4.652341060912804e-16,   1.211482125500628e-18,
  -5.721267910290489e-19,   6.426266475999261e-22,   8.783199807062511e-02,  -1.863509243214674e-03,   7.505945591608749e-05,  -3.896304214027062e-06,   1.870790086062772e-07,
  -6.778506519691847e-09,   1.680977404823463e-10,  -3.790130914032952e-12,   2.196416368840232e-13,  -1.425569816931663e-14,   4.632738180405774e-16,   1.211798098740797e-18,
  -5.643812402999922e-19,   3.152056356298925e-22,   8.783341302810548e-02,  -1.863727163384834e-03,   7.508027526432538e-05,  -3.897559396506968e-06,   1.871258228737739e-07,
  -6.779997181248704e-09,   1.682122403683305e-10,  -3.799610271765734e-12,   2.200250561231934e-13,  -1.425446660655247e-14,   4.625936354039032e-16,   1.211803739896759e-18,
  -5.616888132676601e-19,   2.017487520333990e-22,   8.783363757437317e-02,  -1.863761746459685e-03,   7.508357916879041e-05,  -3.897758585310965e-06,   1.871332526363652e-07,
  -6.780233841376872e-09,   1.682304159703235e-10,  -3.801114490198381e-12,   2.200858823387457e-13,  -1.425427118407447e-14,   4.624858000708036e-16,   1.211799691064952e-18,
  -5.612617276385734e-19,   1.837686423269509e-22,   2.607164071730208e-03,  -7.754626538655879e-05,   5.910451653346666e-06,  -4.858044696483310e-07,   3.165610608413964e-08,
  -1.598643400260547e-09,   6.813760954768554e-11,  -2.968445269852565e-12,   1.482944868263472e-13,  -7.132614893557235e-15,   2.604574456686157e-16,  -6.029670299715829e-18,
   1.075470568213110e-19,  -8.211674562486071e-21,   2.607755083103524e-03,  -7.768837491180094e-05,   5.928829524215168e-06,  -4.873560864588013e-07,   3.175684169396721e-08,
  -1.604886685657817e-09,   6.855030987603338e-11,  -2.993412376400428e-12,   1.494241234943069e-13,  -7.166498594678764e-15,   2.613771055594567e-16,  -6.099913866589258e-18,
   1.130729003052174e-19,  -8.402313678533981e-21,   2.608799402167985e-03,  -7.793949355200231e-05,   5.961304807328636e-06,  -4.900988211562024e-07,   3.193507236036539e-08,
  -1.615943469644851e-09,   6.928095627876098e-11,  -3.037562292481248e-12,   1.514207618052120e-13,  -7.226591553661142e-15,   2.630273573634526e-16,  -6.224938492656104e-18,
   1.227961695511721e-19,  -8.734585466118618e-21,   2.610064713430847e-03,  -7.824377059679467e-05,   6.000654970694624e-06,  -4.934237115349471e-07,   3.215141301527489e-08,
  -1.629382457145112e-09,   7.016861053690059e-11,  -3.091111519014886e-12,   1.538409397958445e-13,  -7.299779043934156e-15,   2.650696516379316e-16,  -6.377942976106400e-18,
   1.345073720153965e-19,  -9.129460826967749e-21,   2.611295687044633e-03,  -7.853980954873851e-05,   6.038940138099213e-06,  -4.966602249631185e-07,   3.236229625647412e-08,
  -1.642501191814499e-09,   7.103468117018935e-11,  -3.143267283452631e-12,   1.561965847911497e-13,  -7.371379109846520e-15,   2.671011569449550e-16,  -6.528366331691874e-18,
   1.458280144672602e-19,  -9.505692727436679e-21,   2.612289231147506e-03,  -7.877876260338103e-05,   6.069843004972105e-06,  -4.992738191503506e-07,   3.253280146034681e-08,
  -1.653121442871954e-09,   7.173549878363073e-11,  -3.185406413844810e-12,   1.580987458939092e-13,  -7.429456596447483e-15,   2.687726508330469e-16,  -6.650885039424046e-18,
   1.549131667689616e-19,  -9.803780452408539e-21,   2.612946672671054e-03,  -7.893688792604426e-05,   6.090292911189027e-06,  -5.010039285738242e-07,   3.264577272773713e-08,
  -1.660164599817589e-09,   7.220011729671836e-11,  -3.213311700811854e-12,   1.593578788074802e-13,  -7.468028817344144e-15,   2.698942178504822e-16,  -6.732493528419298e-18,
   1.608995561044960e-19,  -9.998340308123346e-21,   2.613284586710882e-03,  -7.901816385205254e-05,   6.100804157570538e-06,  -5.018933807263295e-07,   3.270388318691704e-08,
  -1.663789487442479e-09,   7.243919493529088e-11,  -3.227661157152753e-12,   1.600051949102887e-13,  -7.487898233120443e-15,   2.704754691753690e-16,  -6.774603324250292e-18,
   1.639686282817490e-19,  -1.009751822914215e-20,   2.613402246394471e-03,  -7.904646399234368e-05,   6.104464165392414e-06,  -5.022031153848328e-07,   3.272412409160245e-08,
  -1.665052419539238e-09,   7.252248356336684e-11,  -3.232658606965278e-12,   1.602306096717179e-13,  -7.494823654467536e-15,   2.706786178513799e-16,  -6.789291749149859e-18,
   1.650360157335866e-19,  -1.013192123536131e-20,   2.613420919531333e-03,  -7.905095537188425e-05,   6.105045028141948e-06,  -5.022522732611520e-07,   3.272733675807258e-08,
  -1.665252889147219e-09,   7.253570390496291e-11,  -3.233451775458517e-12,   1.602663851428498e-13,  -7.495923083843322e-15,   2.707108945575259e-16,  -6.791624103862859e-18,
   1.652053559740487e-19,  -1.013737498882351e-20,   3.741726043525985e-01,  -6.177661352889317e-03,   1.461619843935570e-04,  -3.345770922718186e-06,   5.763424318045446e-08,
  -4.252706345617684e-10,   6.391438627344703e-12,  -1.761968436535920e-12,   1.172883039167041e-13,  -2.789080910999272e-15,  -8.531027908346249e-17,   8.618970991102016e-18,
  -1.905831999887552e-19,  -9.076905232115093e-21,   3.741863722398009e-01,  -6.178603867259565e-03,   1.461944761766156e-04,  -3.346199999158914e-06,   5.764676367956151e-08,
  -4.288697736211677e-10,   6.691231882874700e-12,  -1.770307885100870e-12,   1.169005889219032e-13,  -2.747459784818713e-15,  -8.621703734230115e-17,   8.547253812882861e-18,
  -1.845971152467241e-19,  -9.182061299140145e-21,   3.742106683797745e-01,  -6.180267052164453e-03,   1.462518149933645e-04,  -3.346959893752646e-06,   5.766919583013912e-08,
  -4.352333355587293e-10,   7.219378209276839e-12,  -1.784910861662100e-12,   1.162135859348801e-13,  -2.674324371855047e-15,  -8.778771376204267e-17,   8.420160068754405e-18,
  -1.741067045151383e-19,  -9.361815937685605e-21,   3.742400517718565e-01,  -6.182278369995698e-03,   1.463211609840243e-04,  -3.347883517164498e-06,   5.769689928722332e-08,
  -4.429499682721902e-10,   7.856576037703296e-12,  -1.802378357605116e-12,   1.153780222502141e-13,  -2.586410977324861e-15,  -8.963726208817414e-17,   8.265566175040488e-18,
  -1.615448969834581e-19,  -9.569374004531232e-21,   3.742685811010149e-01,  -6.184231108321676e-03,   1.463884928184433e-04,  -3.348785137878725e-06,   5.772439801506709e-08,
  -4.504637593311916e-10,   8.473641240461030e-12,  -1.819136669523030e-12,   1.145618971811050e-13,  -2.501615387687837e-15,  -9.138101450910605e-17,   8.114564532536321e-18,
  -1.494796345781944e-19,  -9.760701195232481e-21,   3.742915671398103e-01,  -6.185804342444634e-03,   1.464427431229906e-04,  -3.349515047892844e-06,   5.774698328573771e-08,
  -4.565328686924074e-10,   8.969651667177294e-12,  -1.832495010325643e-12,   1.139009337770115e-13,  -2.433699923757872e-15,  -9.274890109819498e-17,   7.992277565617516e-18,
  -1.398530849735652e-19,  -9.907617587524193e-21,   3.743067574630555e-01,  -6.186843973065720e-03,   1.464785950332468e-04,  -3.349999112676897e-06,   5.776211882361347e-08,
  -4.605510658921176e-10,   9.296871792117085e-12,  -1.841252679674668e-12,   1.134624897390738e-13,  -2.389016375133610e-15,  -9.363482110157141e-17,   7.911166372481336e-18,
  -1.335377045106566e-19,  -1.000119330487994e-20,   3.743145589028268e-01,  -6.187377893437335e-03,   1.464970080349369e-04,  -3.350248245802344e-06,   5.776995703140377e-08,
  -4.626170170558087e-10,   9.464749319539915e-12,  -1.845728780372869e-12,   1.132368098905020e-13,  -2.366129266930823e-15,  -9.408425014503068e-17,   7.869418955183290e-18,
  -1.303086001912161e-19,  -1.004817129971628e-20,   3.743172743421139e-01,  -6.187563732547554e-03,   1.465034170613061e-04,  -3.350335045309662e-06,   5.777269559610593e-08,
  -4.633364738655085e-10,   9.523154230460684e-12,  -1.847283328271355e-12,   1.131581779675409e-13,  -2.358172765646377e-15,  -9.423979887336032e-17,   7.854873742637415e-18,
  -1.291869347284364e-19,  -1.006435140105244e-20,   3.743177052485739e-01,  -6.187593222808583e-03,   1.465044340956274e-04,  -3.350348823300589e-06,   5.777313066245895e-08,
  -4.634506599461639e-10,   9.532421031645339e-12,  -1.847529852288489e-12,   1.131456962814686e-13,  -2.356910632799450e-15,  -9.426444061255046e-17,   7.852564925753759e-18,
  -1.290090489026702e-19,  -1.006691085229001e-20,   8.130108674477347e-02,  -1.402948218897875e-03,   4.192609508473648e-05,  -1.760493599488330e-06,   8.424456931034718e-08,
  -3.540658399629097e-09,   1.074354491808452e-10,  -1.680315550964697e-12,  -1.210087533719223e-14,  -5.061373597767735e-17,   1.406158861701532e-16,  -9.231623217673444e-18,
   2.137870839937506e-19,   6.284336781608313e-21,   8.130511416620649e-02,  -1.403455153607228e-03,   4.197433414549653e-05,  -1.763841005369098e-06,   8.439544957543428e-08,
  -3.543990655014194e-09,   1.074167512673940e-10,  -1.681667891326579e-12,  -1.147311891367709e-14,  -9.624172122655063e-17,   1.417229668486129e-16,  -9.181522416364416e-18,
   2.090435337567372e-19,   6.366308231954385e-21,   8.131222439310706e-02,  -1.404350418187924e-03,   4.205952168853254e-05,  -1.769750104073432e-06,   8.466166398900258e-08,
  -3.549873215222084e-09,   1.073851186080021e-10,  -1.684177850990794e-12,  -1.036182262199517e-14,  -1.765390704406325e-16,   1.436532310084348e-16,  -9.092694861927322e-18,
   2.007334378724363e-19,   6.506207400216519e-21,   8.132082860156827e-02,  -1.405434295531029e-03,   4.216264895782967e-05,  -1.776899796281344e-06,   8.498354677918927e-08,
  -3.556991281586815e-09,   1.073491922359448e-10,  -1.687423490979005e-12,  -9.011929098898509e-15,  -2.732695644522188e-16,   1.459479821961797e-16,  -8.984579690069565e-18,
   1.907873039309043e-19,   6.667353094382269e-21,   8.132918817311126e-02,  -1.406487881254598e-03,   4.226288625298343e-05,  -1.783845148026792e-06,   8.529599862389778e-08,
  -3.563906587236430e-09,   1.073167558427084e-10,  -1.690794288980647e-12,  -7.695153731923560e-15,  -3.667892701022937e-16,   1.481347514898022e-16,  -8.878910096570859e-18,
   1.812394543442649e-19,   6.815468672035745e-21,   8.133592737834024e-02,  -1.407337622732294e-03,   4.234372433235482e-05,  -1.789443497845857e-06,   8.554768782746882e-08,
  -3.569481321051143e-09,   1.072923784915981e-10,  -1.693667012500070e-12,  -6.629894602901612e-15,  -4.418510143727123e-16,   1.498672422515645e-16,  -8.793289744108125e-18,
   1.736252060610710e-19,   6.928881499761996e-21,   8.134038289772168e-02,  -1.407899599936018e-03,   4.239718388809094e-05,  -1.793144386862857e-06,   8.571399117959308e-08,
  -3.573166941214324e-09,   1.072771304903327e-10,  -1.695642103425835e-12,  -5.923815026480218e-15,  -4.913147093587083e-16,   1.509978485141647e-16,  -8.736478035096571e-18,
   1.686318164354346e-19,   7.000952773475129e-21,   8.134267175414621e-02,  -1.408188351576616e-03,   4.242465128555152e-05,  -1.795045465161674e-06,   8.579939339756497e-08,
  -3.575060292392620e-09,   1.072695662952551e-10,  -1.696680140858674e-12,  -5.560540719022388e-15,  -5.166746163271962e-16,   1.515740959007713e-16,  -8.707231158958689e-18,
   1.660792320751211e-19,   7.037082053896444e-21,   8.134346852846937e-02,  -1.408288878025944e-03,   4.243421369131603e-05,  -1.795707231644159e-06,   8.582911802939972e-08,
  -3.575719388462504e-09,   1.072669759504806e-10,  -1.697045214910157e-12,  -5.433993680101783e-15,  -5.254946600428060e-16,   1.517739693337004e-16,  -8.697040284083002e-18,
   1.651926554732391e-19,   7.049517068406666e-21,   8.134359497113046e-02,  -1.408304831318733e-03,   4.243573121436866e-05,  -1.795812248610708e-06,   8.583383490062867e-08,
  -3.575823982595586e-09,   1.072665669140154e-10,  -1.697103326317973e-12,  -5.413907378760606e-15,  -5.268939611005885e-16,   1.518056535421020e-16,  -8.695422601933135e-18,
   1.650520569608042e-19,   7.051483690956959e-21,   2.364169943947122e-03,  -4.693325578086916e-05,   2.293116648948362e-06,  -1.672769581531130e-07,   1.129222018057911e-08,
  -6.015609700557301e-10,   2.448794952763073e-11,  -7.798198435282304e-13,   2.390169968111271e-14,  -1.088935913213856e-15,   6.296261824548553e-17,  -2.888008131420698e-18,
   7.811906836093690e-20,  -5.981127050375005e-23,   2.364398079671938e-03,  -4.698233946767161e-05,   2.299667978644263e-06,  -1.678544459021789e-07,   1.132747643806846e-08,
  -6.031617506889448e-10,   2.455652439161689e-11,  -7.838837156421563e-13,   2.418198646200528e-14,  -1.103844953179593e-15,   6.342222349657982e-17,  -2.888450574105991e-18,
   7.758204143352360e-20,  -5.818019412015322e-23,   2.364801152103890e-03,  -4.706908283163092e-05,   2.311244223028726e-06,  -1.688746727655079e-07,   1.138976737487258e-08,
  -6.059930495681832e-10,   2.467813282431057e-11,  -7.910954041858650e-13,   2.467811315914744e-14,  -1.130154131035740e-15,   6.423068675901456e-17,  -2.889237589193051e-18,
   7.665104109818226e-20,  -5.649909739971124e-23,   2.365289444850138e-03,  -4.717420324273345e-05,   2.325270194736932e-06,  -1.701104609908341e-07,   1.146522834965199e-08,
  -6.094281489903459e-10,   2.482622029170205e-11,  -7.998856347300697e-13,   2.528068277226083e-14,  -1.161970824787261e-15,   6.520405436273439e-17,  -2.890204787643401e-18,
   7.555363539194313e-20,  -5.649178950201511e-23,   2.365764407538395e-03,  -4.727649280867109e-05,   2.338915566561838e-06,  -1.713123664117147e-07,   1.153862979874222e-08,
  -6.127749448034124e-10,   2.497107011427560e-11,  -8.084921159718159e-13,   2.586841265781989e-14,  -1.192861495991368e-15,   6.614462181026471e-17,  -2.891166028549291e-18,
   7.451809875949575e-20,  -5.858603007169442e-23,   2.366147703133719e-03,  -4.735906844415902e-05,   2.349929047003223e-06,  -1.722822022501157e-07,   1.159786555074804e-08,
  -6.154797618533331e-10,   2.508854158665619e-11,  -8.154777487390019e-13,   2.634385688435939e-14,  -1.217749230939500e-15,   6.689925814113708e-17,  -2.891960598720791e-18,
   7.370530555130766e-20,  -6.176476947392205e-23,   2.366401307304464e-03,  -4.741371748251424e-05,   2.357216824177139e-06,  -1.729238354839353e-07,   1.163705882167602e-08,
  -6.172713239478372e-10,   2.516654851198579e-11,  -8.201193704014743e-13,   2.665898780908089e-14,  -1.234195904056063e-15,   6.739642502040046e-17,  -2.892497226901147e-18,
   7.317874049160402e-20,  -6.458992864495050e-23,   2.366531647079292e-03,  -4.744180853567774e-05,   2.360962623214300e-06,  -1.732535872787496e-07,   1.165720235687236e-08,
  -6.181926999432416e-10,   2.520672768920904e-11,  -8.225109949328437e-13,   2.682112089639619e-14,  -1.242642465178406e-15,   6.765128974957593e-17,  -2.892776755458138e-18,
   7.291158105402918e-20,  -6.626369958106791e-23,   2.366577029260081e-03,  -4.745159004961697e-05,   2.362266888798058e-06,  -1.733683990307209e-07,   1.166421603583454e-08,
  -6.185136042505517e-10,   2.522073136244531e-11,  -8.233446842023526e-13,   2.687760025155742e-14,  -1.245582433484149e-15,   6.773992583522924e-17,  -2.892874707804268e-18,
   7.281911273292030e-20,  -6.688165212024459e-23,   2.366584231557705e-03,  -4.745314243895029e-05,   2.362473881805208e-06,  -1.733866199084709e-07,   1.166532913060229e-08,
  -6.185645373655010e-10,   2.522295445210772e-11,  -8.234770391408486e-13,   2.688656499920365e-14,  -1.246048969076848e-15,   6.775398775524938e-17,  -2.892890283463343e-18,
   7.280446393019787e-20,  -6.698139016889370e-23,   3.515675497074112e-01,  -5.153935012008104e-03,   1.112616503488213e-04,  -2.493772263136170e-06,   4.842812960868023e-08,
  -5.412241900128504e-10,  -6.824412270748634e-12,   2.775377744729758e-13,   1.787659374716414e-14,  -1.771482214748267e-15,   6.621913717976211e-17,  -4.978756943482483e-19,
  -8.079236354895137e-20,   4.687935319725501e-21,   3.515780350489667e-01,  -5.154638157552913e-03,   1.112888408369880e-04,  -2.494275964801983e-06,   4.841915943786504e-08,
  -5.407734150216863e-10,  -6.772121316558399e-12,   2.715293100069425e-13,   1.813889839976996e-14,  -1.772809282622747e-15,   6.569259102031609e-17,  -4.656712335330928e-19,
  -8.140043566325838e-20,   4.651426703164126e-21,   3.515965386659693e-01,  -5.155878983516369e-03,   1.113368149304108e-04,  -2.495164440244714e-06,   4.840339330279221e-08,
  -5.399876449571789e-10,  -6.679303724074697e-12,   2.609245426225262e-13,   1.859991071832509e-14,  -1.775018092305655e-15,   6.476068317026702e-17,  -4.090733599941886e-19,
  -8.245073572678871e-20,   4.586228978713026e-21,   3.516189169613707e-01,  -5.157379598870524e-03,   1.113948190007057e-04,  -2.496238263758193e-06,   4.838443464451738e-08,
  -5.390539047445818e-10,  -6.566133652984288e-12,   2.480967241459126e-13,   1.915424798021591e-14,  -1.777463204006408e-15,   6.362909850439664e-17,  -3.410254000465457e-19,
  -8.368221555886607e-20,   4.506080769217617e-21,   3.516406451132729e-01,  -5.158836574789072e-03,   1.114511213409882e-04,  -2.497280163940740e-06,   4.836614136505767e-08,
  -5.381646448986929e-10,  -6.455295425695488e-12,   2.356393853307260e-13,   1.968910996686166e-14,  -1.779601274145767e-15,   6.252574052382401e-17,  -2.753787102002757e-19,
  -8.483743354593351e-20,   4.426921949117579e-21,   3.516581516736684e-01,  -5.160010442135804e-03,   1.114964727718748e-04,  -2.498119116280601e-06,   4.835148477499323e-08,
  -5.374605935464405e-10,  -6.365309666532284e-12,   2.256010447758129e-13,   2.011763295057546e-14,  -1.781155476497362e-15,   6.163349491101869e-17,  -2.227932602139563e-19,
  -8.573926746220341e-20,   4.362197761723734e-21,   3.516697209913165e-01,  -5.160786184479984e-03,   1.115264377476704e-04,  -2.498673292454596e-06,   4.834183940059986e-08,
  -5.370014041950777e-10,  -6.305508919447535e-12,   2.189665717593564e-13,   2.039963811832996e-14,  -1.782100358093083e-15,   6.104228079192871e-17,  -1.881930441093783e-19,
  -8.632111217797332e-20,   4.318967322269899e-21,   3.516756627897943e-01,  -5.161184587466553e-03,   1.115418254429375e-04,  -2.498957830503690e-06,   4.833689826874267e-08,
  -5.367674550838993e-10,  -6.274693510082510e-12,   2.155590642470873e-13,   2.054410355461137e-14,  -1.782560260359671e-15,   6.073816466165645e-17,  -1.704699629232544e-19,
  -8.661557164833051e-20,   4.296624803205079e-21,   3.516777309508941e-01,  -5.161323258804500e-03,   1.115471811513623e-04,  -2.499056857389124e-06,   4.833518041237474e-08,
  -5.366863241292157e-10,  -6.263951248780075e-12,   2.143729899389189e-13,   2.059432908407794e-14,  -1.782716304171034e-15,   6.063223528489679e-17,  -1.643085914604188e-19,
  -8.671736967105973e-20,   4.288825846596642e-21,   3.516780591426026e-01,  -5.161345264203594e-03,   1.115480310228434e-04,  -2.499072571156525e-06,   4.833490790485074e-08,
  -5.366734638722112e-10,  -6.262245808575674e-12,   2.141847734613354e-13,   2.060229647763399e-14,  -1.782740874982354e-15,   6.061542201333513e-17,  -1.633312140654475e-19,
  -8.673349080830017e-20,   4.287587196555509e-21,   7.625261506101734e-02,  -1.133682127935188e-03,   2.695948993314195e-05,  -8.555461408917337e-07,   3.526022958311395e-08,
  -1.549454643601613e-09,   5.879881648567258e-11,  -1.608689654984326e-12,   1.920871509203918e-14,   6.665580164920039e-16,  -3.560473947736533e-17,  -1.127013504856062e-19,
   8.284402426878056e-20,  -4.326737076437572e-21,   7.625518327895668e-02,  -1.133927964784521e-03,   2.697979396943487e-05,  -8.570250524441027e-07,   3.534347567736219e-08,
  -1.552586877935237e-09,   5.884655047831126e-11,  -1.606489847971374e-12,   1.907593654527859e-14,   6.648211420111179e-16,  -3.506650695924996e-17,  -1.426728010337961e-19,
   8.342454289033373e-20,  -4.297414959370023e-21,   7.625971654378712e-02,  -1.134362090504563e-03,   2.701565896161958e-05,  -8.596369918459341e-07,   3.549041826058987e-08,
  -1.558110260451537e-09,   5.893050513043228e-11,  -1.602613863299557e-12,   1.884351445896813e-14,   6.616325096038228e-16,  -3.411407314205095e-17,  -1.953751879083604e-19,
   8.443019052309051e-20,  -4.245045701264385e-21,   7.626520095281231e-02,  -1.134887624719406e-03,   2.705909244515989e-05,  -8.627994275446256e-07,   3.566819388670226e-08,
  -1.564783242486651e-09,   5.903156171859527e-11,  -1.597936776371195e-12,   1.856565793590249e-14,   6.575660757845286e-16,  -3.295781627519100e-17,  -2.587894744632533e-19,
   8.561443123454339e-20,  -4.180659116847164e-21,   7.627052799063876e-02,  -1.135398417059726e-03,   2.710132516632145e-05,  -8.658737048928459e-07,   3.584087050800994e-08,
  -1.571255034872050e-09,   5.912918513197833e-11,  -1.593406892489829e-12,   1.829926862745201e-14,   6.533984933350609e-16,  -3.183064458834844e-17,  -3.200190252482490e-19,
   8.673085411086820e-20,  -4.117059076379830e-21,   7.627482144010925e-02,  -1.135810344143099e-03,   2.713539621082604e-05,  -8.683533387197318e-07,   3.598004451856756e-08,
  -1.576464174227760e-09,   5.920748743765336e-11,  -1.589765443448145e-12,   1.808707375306709e-14,   6.498840326279289e-16,  -3.091930135380359e-17,  -3.691047440926581e-19,
   8.760648897221914e-20,  -4.065051051504358e-21,   7.627765948296565e-02,  -1.136082753505651e-03,   2.715793370537660e-05,  -8.699933224191742e-07,   3.607204143157117e-08,
  -1.579904103304542e-09,   5.925906183258507e-11,  -1.587363124726439e-12,   1.794803879093917e-14,   6.474850127524147e-16,  -3.031550523443346e-17,  -4.014213268823912e-19,
   8.817349316917141e-20,  -4.030311468647907e-21,   7.627911726563616e-02,  -1.136222715354769e-03,   2.716951519686391e-05,  -8.708359918894770e-07,   3.611929650191564e-08,
  -1.581669998659165e-09,   5.928549651359769e-11,  -1.586130638592981e-12,   1.787700294776577e-14,   6.462293152857387e-16,  -3.000493815121977e-17,  -4.179806425164897e-19,
   8.846109492642223e-20,  -4.012356492998016e-21,   7.627962470990839e-02,  -1.136271440964574e-03,   2.717354742077543e-05,  -8.711293638355231e-07,   3.613574569289726e-08,
  -1.582284527645504e-09,   5.929468920823080e-11,  -1.585701856225009e-12,   1.785233646218789e-14,   6.457884912389753e-16,  -2.989676504039802e-17,  -4.237383897116551e-19,
   8.856062756390605e-20,  -4.006088954090102e-21,   7.627970523668373e-02,  -1.136279173551365e-03,   2.717418733518581e-05,  -8.711759213939679e-07,   3.613835603036475e-08,
  -1.582382039850576e-09,   5.929614757630496e-11,  -1.585633823691682e-12,   1.784842499392078e-14,   6.457183597767907e-16,  -2.987959579222295e-17,  -4.246517856957223e-19,
   8.857639498266078e-20,  -4.005093522377238e-21,   2.203766921492599e-03,  -3.428478937998626e-05,   1.058965326418241e-06,  -5.712207917668498e-08,   3.709312909473172e-09,
  -2.132768543721573e-10,   9.800218016844899e-12,  -3.431206977560471e-13,   8.570515456413924e-15,  -1.423267523495226e-16,   3.369120376215777e-18,  -3.085859585199959e-19,
   2.250811778862532e-20,  -1.006026536838294e-21,   2.203870549327358e-03,  -3.430158077500096e-05,   1.061131284457564e-06,  -5.732778596842389e-08,   3.723365969250509e-09,
  -2.139609200370537e-10,   9.823122377443955e-12,  -3.436508932880137e-13,   8.589502662254502e-15,  -1.441965745483291e-16,   3.516375427147759e-18,  -3.157756477564084e-19,
   2.268501136991551e-20,  -1.003175791058346e-21,   2.204053576914939e-03,  -3.433125749776188e-05,   1.064959642453132e-06,  -5.769128291153905e-08,   3.748189167203427e-09,
  -2.151688383939758e-10,   9.863580920345849e-12,  -3.445917665353450e-13,   8.623517831069394e-15,  -1.475258656082824e-16,   3.777064796387490e-18,  -3.284434073385274e-19,
   2.299403016322155e-20,  -9.980243184206518e-22,   2.204275193960555e-03,  -3.436722490665000e-05,   1.069600009799373e-06,  -5.813172135688101e-08,   3.778250613287314e-09,
  -2.166309619782941e-10,   9.912578643749791e-12,  -3.457386330262667e-13,   8.665524206723948e-15,  -1.516027091109989e-16,   4.093741236090067e-18,  -3.437292778053716e-19,
   2.336240283052556e-20,  -9.915910824560029e-22,   2.204490648599808e-03,  -3.440222741858353e-05,   1.074116407357178e-06,  -5.856022822595034e-08,   3.807480883118130e-09,
  -2.180519403497470e-10,   9.960224102666021e-12,  -3.468616470835365e-13,   8.707221912466501e-15,  -1.556138035740425e-16,   4.402668070807009e-18,  -3.585343034477144e-19,
   2.371448139201767e-20,  -9.851357208264011e-22,   2.204664440381965e-03,  -3.443048666170172e-05,   1.077763083995407e-06,  -5.890609946285215e-08,   3.831062215737133e-09,
  -2.191977953551820e-10,   9.998664177031340e-12,  -3.477733013989325e-13,   8.741472989861071e-15,  -1.588832739480157e-16,   4.652602731824659e-18,  -3.704360958296801e-19,
   2.399415898801335e-20,  -9.797873541068113e-22,   2.204779388859461e-03,  -3.444919009384595e-05,   1.080176822371153e-06,  -5.913497405738057e-08,   3.846660906616049e-09,
  -2.199555130451794e-10,   1.002409312859150e-11,  -3.483791387492943e-13,   8.764429319298251e-15,  -1.610623571365371e-16,   4.818273794441753e-18,  -3.782882090001535e-19,
   2.417703429088163e-20,  -9.761817958545096e-22,   2.204838454437263e-03,  -3.445880455580368e-05,   1.081417654763690e-06,  -5.925261390922363e-08,   3.854676706923876e-09,
  -2.203448101016103e-10,   1.003716096462783e-11,  -3.486913310506367e-13,   8.776318788030142e-15,  -1.621871916723148e-16,   4.903513403101941e-18,  -3.823167813432474e-19,
   2.427035340886140e-20,  -9.743082889169581e-22,   2.204859018173286e-03,  -3.446215244717572e-05,   1.081849738849513e-06,  -5.929357574636275e-08,   3.857467495977163e-09,
  -2.204803360542396e-10,   1.004171075923098e-11,  -3.488001625071490e-13,   8.780473006800197e-15,  -1.625796189912919e-16,   4.933207163758634e-18,  -3.837183446629000e-19,
   2.430273917068099e-20,  -9.736527336528375e-22,   2.204862281612375e-03,  -3.446268378216772e-05,   1.081918314186862e-06,  -5.930007659536010e-08,   3.857910394524505e-09,
  -2.205018434650325e-10,   1.004243281623531e-11,  -3.488174406418648e-13,   8.781132983009103e-15,  -1.626419353915283e-16,   4.937920355854227e-18,  -3.839407240495993e-19,
   2.430787384582763e-20,  -9.735485420039846e-22,   3.325599274729035e-01,  -4.371235173525140e-03,   8.560815692508176e-05,  -1.811201396641513e-06,   3.673991907983481e-08,
  -5.896512315299160e-10,   2.555890206678845e-12,   2.581037069302719e-13,  -8.879286370170083e-15,  -5.512103546346731e-17,   1.808702039951697e-17,  -9.040340728310875e-19,
   2.240831312185893e-20,   6.062330856099786e-23,   3.325679947459931e-01,  -4.371746504249388e-03,   8.562884181262861e-05,  -1.811749969975075e-06,   3.674326001826230e-08,
  -5.891482252557788e-10,   2.534251184647592e-12,   2.577977861557382e-13,  -8.799041795711354e-15,  -5.972892016248348e-17,   1.821174773239640e-17,  -9.027835307116443e-19,
   2.211079303870610e-20,   7.534945318348448e-23,   3.325822311552414e-01,  -4.372648880072783e-03,   8.566534209181798e-05,  -1.812717554566631e-06,   3.674913107896572e-08,
  -5.882612113857612e-10,   2.496242394872687e-12,   2.572453828956124e-13,  -8.657033519101362e-15,  -6.785354045675867e-17,   1.843031191858107e-17,  -9.004902787936716e-19,
   2.158375356917844e-20,   1.012688080271244e-22,   3.325994486657577e-01,  -4.373740255152558e-03,   8.570948111810577e-05,  -1.813886917705350e-06,   3.675618951129880e-08,
  -5.871895739443227e-10,   2.450578365762210e-12,   2.565559371986207e-13,  -8.484610795247359e-15,  -7.766732994216841e-17,   1.869200493120825e-17,  -8.975697891671308e-19,
   2.094298007280655e-20,   1.324974539595940e-22,   3.326161659464145e-01,  -4.374799965737823e-03,   8.575233312814863e-05,  -1.815021434424304e-06,   3.676299904308416e-08,
  -5.861502584391801e-10,   2.406559875048920e-12,   2.558641642023566e-13,  -8.316492344545749e-15,  -8.718298394491499e-17,   1.894332362069124e-17,  -8.945805691911584e-19,
   2.031734608702897e-20,   1.626922051242006e-22,   3.326296351905257e-01,  -4.375653814207316e-03,   8.578685601184833e-05,  -1.815934898858973e-06,   3.676845426298657e-08,
  -5.853137365539858e-10,   2.371322769029904e-12,   2.552907919809448e-13,  -8.180536040840128e-15,  -9.484027911267136e-17,   1.914382178781625e-17,  -8.920623705277990e-19,
   1.981081460472234e-20,   1.869276879384716e-22,   3.326385364162650e-01,  -4.376218100091801e-03,   8.580966902730800e-05,  -1.816538261320456e-06,   3.677204411598312e-08,
  -5.847613437280009e-10,   2.348148419541839e-12,   2.549040450140129e-13,  -8.090444137150018e-15,  -9.989588504240906e-17,   1.927534488016545e-17,  -8.903445778759262e-19,
   1.947488467919325e-20,   2.028976829640116e-22,   3.326431079275073e-01,  -4.376507912019453e-03,   8.582138488284275e-05,  -1.816848043061656e-06,   3.677388309264509e-08,
  -5.844777778135760e-10,   2.336281254040892e-12,   2.547029982207478e-13,  -8.044099238995032e-15,  -1.024908631953809e-16,   1.934259010060803e-17,  -8.894457903468228e-19,
   1.930199363918177e-20,   2.110851453974623e-22,   3.326446991325628e-01,  -4.376608787555355e-03,   8.582546273826399e-05,  -1.816955853694347e-06,   3.677452243638890e-08,
  -5.843790983809641e-10,   2.332156190796113e-12,   2.546326346831966e-13,  -8.027956017220020e-15,  -1.033938576824269e-16,   1.936594789938479e-17,  -8.891303154403961e-19,
   1.924175792716494e-20,   2.139326396805994e-22,   3.326449516372028e-01,  -4.376624795295933e-03,   8.582610983987504e-05,  -1.816972961199709e-06,   3.677462385685072e-08,
  -5.843634401838049e-10,   2.331501857095377e-12,   2.546214505714608e-13,  -8.025393719452276e-15,  -1.035371404001227e-16,   1.936965220370862e-17,  -8.890801284553920e-19,
   1.923219653509907e-20,   2.143843917806923e-22,   7.209519336047304e-02,  -9.514089242114144e-04,   1.926524014436120e-05,  -4.764948408606757e-07,   1.515351475796478e-08,
  -5.963495481649944e-10,   2.417919592897767e-11,  -8.513204316171842e-13,   2.238146534918171e-14,  -2.876989305559982e-16,  -8.133223961478111e-18,   6.115977061104276e-19,
  -1.534431637736946e-20,  -1.493850879515336e-22,   7.209701698301763e-02,  -9.515449606131127e-04,   1.927396014430101e-05,  -4.770681404050832e-07,   1.518820115831183e-08,
  -5.980395764508207e-10,   2.423717771476646e-11,  -8.522114632431588e-13,   2.234457901315117e-14,  -2.846199697181642e-16,  -8.215307031440485e-18,   6.097916227702976e-19,
  -1.506936803651599e-20,  -1.624025515393033e-22,   7.210023548194708e-02,  -9.517851325560691e-04,   1.928936274505304e-05,  -4.780810288531999e-07,   1.524947184208489e-08,
  -6.010230449278510e-10,   2.433940724181519e-11,  -8.537753116942880e-13,   2.227922234731071e-14,  -2.791953933466326e-16,  -8.358741270647159e-18,   6.065281411062186e-19,
  -1.458243039095867e-20,  -1.853160714952892e-22,   7.210412849964835e-02,  -9.520757789907370e-04,   1.930801507669967e-05,  -4.793080287108292e-07,   1.532367345309885e-08,
  -6.046330426559293e-10,   2.446288706871265e-11,  -8.556520432927009e-13,   2.219973506986220e-14,  -2.726503059072531e-16,  -8.529785939164232e-18,   6.024515036895099e-19,
  -1.399060855066403e-20,  -2.129260284675614e-22,   7.210790900477798e-02,  -9.523581724907144e-04,   1.932615109613220e-05,  -4.805014881746660e-07,   1.539582476289330e-08,
  -6.081400212362851e-10,   2.458261497657543e-11,  -8.574589980627775e-13,   2.212209556531275e-14,  -2.663117733232434e-16,  -8.693314935851834e-18,   5.983577330310368e-19,
  -1.341296953026363e-20,  -2.396250575174117e-22,   7.211095541328669e-02,  -9.525858364280773e-04,   1.934078178989807e-05,  -4.814645787910455e-07,   1.545403317244716e-08,
  -6.109669485571464e-10,   2.467896258376709e-11,  -8.589039653267103e-13,   2.205921311846803e-14,  -2.612167103737688e-16,  -8.823242234954980e-18,   5.949624515442521e-19,
  -1.294543561162001e-20,  -2.610571243339680e-22,   7.211296885828755e-02,  -9.527363567012507e-04,   1.935045956213789e-05,  -4.821017825930680e-07,   1.549253748156586e-08,
  -6.128357857865213e-10,   2.474257648542631e-11,  -8.598535450544239e-13,   2.201749769184926e-14,  -2.578555349034167e-16,  -8.908207785250011e-18,   5.926713152232987e-19,
  -1.263543547573174e-20,  -2.751810238154089e-22,   7.211400299246579e-02,  -9.528136820569163e-04,   1.935543267721054e-05,  -4.824292679984624e-07,   1.551232403214170e-08,
  -6.137957865311161e-10,   2.477522950337784e-11,  -8.603395839248612e-13,   2.199602441853737e-14,  -2.561311441148127e-16,  -8.951566565416869e-18,   5.914800076509989e-19,
  -1.247590987540874e-20,  -2.824224214280295e-22,   7.211436295364880e-02,  -9.528405999946465e-04,   1.935716411166082e-05,  -4.825432922195774e-07,   1.551921295092335e-08,
  -6.141299654536353e-10,   2.478659217302096e-11,  -8.605084970932740e-13,   2.198854244752352e-14,  -2.555312316044597e-16,  -8.966614151043024e-18,   5.910630237329929e-19,
  -1.242033392295082e-20,  -2.849409491637015e-22,   7.211442007554295e-02,  -9.528448716971913e-04,   1.935743889002177e-05,  -4.825613881886503e-07,   1.552030622375608e-08,
  -6.141829970327789e-10,   2.478839515288578e-11,  -8.605352890832798e-13,   2.198735478237193e-14,  -2.554360469550541e-16,  -8.968999913864912e-18,   5.909967431519086e-19,
  -1.241151233973487e-20,  -2.853405140461632e-22,   2.080314184438764e-03,  -2.780129206262487e-05,   6.225242589335526e-07,  -2.188175208485833e-08,   1.159746242118628e-09,
  -6.657252521128677e-11,   3.360328826990075e-12,  -1.384872696052940e-13,   4.430492895246583e-15,  -9.883467383433038e-17,   9.443106973141857e-19,   2.386825071112706e-20,
  -4.775910248513608e-22,  -7.127532695516740e-23,   2.080373911511398e-03,  -2.780767489594266e-05,   6.232041468234522e-07,  -2.194650550906605e-08,   1.164610334283350e-09,
  -6.685043403963550e-11,   3.372041269101913e-12,  -1.388184370952472e-13,   4.434481003582587e-15,  -9.873844079949899e-17,   9.440251227398629e-19,   2.320122878424987e-20,
  -4.206311858092296e-22,  -7.392410754956241e-23,   2.080479356013301e-03,  -2.781895272162928e-05,   6.244060768587592e-07,  -2.206097738593511e-08,   1.173206524691041e-09,
  -6.734133748311300e-11,   3.392716578692889e-12,  -1.394025435624272e-13,   4.441519471916791e-15,  -9.857158141336457e-17,   9.438126818766218e-19,   2.200856721016939e-20,
  -3.196756056391648e-22,  -7.859396842482750e-23,   2.080606954778119e-03,  -2.783261596718863e-05,   6.258633163589507e-07,  -2.219976221304625e-08,   1.183624024443834e-09,
  -6.793584481568884e-11,   3.417731917821201e-12,  -1.401084413963702e-13,   4.450033522004767e-15,  -9.837488022081012e-17,   9.440542724910203e-19,   2.053965257499578e-20,
  -1.968391250465776e-22,  -8.423371353596601e-23,   2.080730924197582e-03,  -2.784590725690531e-05,   6.272820193016208e-07,  -2.233487387016605e-08,   1.193761136274130e-09,
  -6.851392612071518e-11,   3.442031602029037e-12,  -1.407932928446694e-13,   4.458302902382726e-15,  -9.818928950964652e-17,   9.448127234782964e-19,   1.908568326653822e-20,
  -7.680318355759551e-23,  -8.970078854237759e-23,   2.080830863213378e-03,  -2.785663410028348e-05,   6.284278064292356e-07,  -2.244399183403759e-08,   1.201944651781593e-09,
  -6.898029696833236e-11,   3.461618025876706e-12,  -1.413447031535064e-13,   4.464968161829641e-15,  -9.804366329595742e-17,   9.458004522397394e-19,   1.789436046093380e-20,
   2.045589579573840e-23,  -9.409901772184145e-23,   2.080896935876449e-03,  -2.786373179340958e-05,   6.291863428608890e-07,  -2.251622918579447e-08,   1.207360592180814e-09,
  -6.928879744886586e-11,   3.474565731882068e-12,  -1.417089219071398e-13,   4.469374439669210e-15,  -9.794935372528584e-17,   9.466381225047766e-19,   1.709735881068253e-20,
   8.499489049123933e-23,  -9.700223434277021e-23,   2.080930878104223e-03,  -2.786737976566579e-05,   6.295763273074304e-07,  -2.255336802928217e-08,   1.210144540933216e-09,
  -6.944732953231975e-11,   3.481216652237652e-12,  -1.418959217841309e-13,   4.471637944568718e-15,  -9.790151776657597e-17,   9.471256326370234e-19,   1.668503223419156e-20,
   1.182223977840606e-22,  -9.849220276603114e-23,   2.080942693720311e-03,  -2.786864994843684e-05,   6.297121349944290e-07,  -2.256630115372206e-08,   1.211113934431701e-09,
  -6.950252436448381e-11,   3.483531829305935e-12,  -1.419610018585381e-13,   4.472425889717340e-15,  -9.788496329848856e-17,   9.473044515925710e-19,   1.654103626532395e-20,
   1.298008122735105e-22,  -9.901064269826427e-23,   2.080944568777190e-03,  -2.786885153139092e-05,   6.297336891290752e-07,  -2.256835377628257e-08,   1.211267783514477e-09,
  -6.951128379743841e-11,   3.483899228523628e-12,  -1.419713288411543e-13,   4.472550931153157e-15,  -9.788234086167401e-17,   9.473332616468328e-19,   1.651816321254369e-20,
   1.316387766482649e-22,  -9.909290446223636e-23,   3.163204930312958e-01,  -3.764206136938346e-03,   6.702881594952725e-05,  -1.312514280338546e-06,   2.598555714841031e-08,
  -4.721198504818327e-10,   6.140014129006193e-12,   2.208064417004034e-14,  -4.740352905381071e-15,   1.587092746837575e-16,   3.163300764906558e-01,  -3.764768849311819e-03,
   6.705107642653141e-05,  -1.313185467749291e-06,   2.599843729108846e-08,  -4.720413828191880e-10,   6.120972730167378e-12,   2.286531985110157e-14,  -4.748074250545032e-15,
   1.576677422839166e-16,   3.163458115919647e-01,  -3.765692839716977e-03,   6.708762848009781e-05,  -1.314287244667888e-06,   2.601955267536541e-08,  -4.719108894152462e-10,
   6.089693067856553e-12,   2.414950596606942e-14,  -4.760382314393444e-15,   1.559407541551796e-16,   3.163625108794038e-01,  -3.766673546234524e-03,   6.712642373088601e-05,
  -1.315456197534774e-06,   2.604191768340146e-08,  -4.717701527826672e-10,   6.056476162868224e-12,   2.550667462627542e-14,  -4.772941356461658e-15,   1.540850192957756e-16,
   3.163756555720799e-01,  -3.767445571063621e-03,   6.715696353417085e-05,  -1.316376083706367e-06,   2.605949005533991e-08,  -4.716577503767100e-10,   6.030315365096874e-12,
   2.657079880108328e-14,  -4.782462097027767e-15,   1.526077268686517e-16,   3.163832425395843e-01,  -3.767891203316625e-03,   6.717459175064918e-05,  -1.316906933338800e-06,
   2.606961978349854e-08,  -4.715922238405585e-10,   6.015210025114922e-12,   2.718332345692382e-14,  -4.787810840841972e-15,   1.517484193749276e-16,   3.163860916930227e-01,
  -3.768058558086958e-03,   6.718121190663115e-05,  -1.317106266073758e-06,   2.607342139825458e-08,  -4.715674939623090e-10,   6.009536433085582e-12,   2.741302865496877e-14,
  -4.789791749939220e-15,   1.514244692993693e-16,   3.163865639900453e-01,  -3.768086300349504e-03,   6.718230932311962e-05,  -1.317139307979920e-06,   2.607405145430314e-08,
  -4.715633880924850e-10,   6.008595881284885e-12,   2.745108952135253e-14,  -4.790118657409661e-15,   1.513707028827956e-16,   6.856652847279499e-02,  -8.167797139840240e-04,
   1.469195908092280e-05,  -3.047255293829282e-07,   7.472622806810796e-09,  -2.319595577134322e-10,   8.608051311639959e-12,  -3.238209982893605e-13,   1.074139958062614e-14,
  -2.792656110345955e-16,   6.856863229523923e-02,  -8.169110055294040e-04,   1.469844682400711e-05,  -3.050640073121283e-07,   7.491513139596064e-09,  -2.329499323401917e-10,
   8.651384164433035e-12,  -3.252399371687793e-13,   1.076731682113153e-14,  -2.788401921646638e-16,   6.857208674510409e-02,  -8.171266482791874e-04,   1.470910932714411e-05,
  -3.056207017301543e-07,   7.522591816204731e-09,  -2.345788496043544e-10,   8.722595183269927e-12,  -3.275676808441622e-13,   1.080960038138276e-14,  -2.781286846162241e-16,
   6.857575311486955e-02,  -8.173556067289095e-04,   1.472043915833800e-05,  -3.062127965622623e-07,   7.555660001775124e-09,  -2.363114094331028e-10,   8.798254545928927e-12,
  -3.300352949792346e-13,   1.085410734481062e-14,  -2.773559321876718e-16,   6.857863924210771e-02,  -8.175359032295103e-04,   1.472936746357996e-05,  -3.066797925978227e-07,
   7.581750994739687e-09,  -2.376779481760161e-10,   8.857870187628004e-12,  -3.319756328976367e-13,   1.088887400514568e-14,  -2.767349205328157e-16,   6.858030515331584e-02,
  -8.176399979998178e-04,   1.473452484639059e-05,  -3.069497121659548e-07,   7.596835151739218e-09,  -2.384678084405147e-10,   8.892304022383026e-12,  -3.330947566335671e-13,
   1.090883391534854e-14,  -2.763713802387718e-16,   6.858093077073503e-02,  -8.176790945904641e-04,   1.473646238081357e-05,  -3.070511466327471e-07,   7.602504419901189e-09,
  -2.387646363344800e-10,   8.905239640217145e-12,  -3.335148687762618e-13,   1.091630926817686e-14,  -2.762338963913342e-16,   6.858103447847849e-02,  -8.176855758305328e-04,
   1.473678360162967e-05,  -3.070679649101212e-07,   7.603444446973553e-09,  -2.388138518072374e-10,   8.907384187031104e-12,  -3.335845015021069e-13,   1.091754737031769e-14,
  -2.762110552859355e-16,   1.977750471744068e-03,  -2.363442897809225e-05,   4.385571021597218e-07,  -1.066631966444717e-08,   3.907165797021833e-10,  -1.943031750438634e-11,
   9.936536145634442e-13,  -4.497450507820836e-14,   1.702412957302160e-15,  -5.158063289641728e-17,   1.977813577962383e-03,  -2.363908474029267e-05,   4.389032401369324e-07,
  -1.069514510922708e-08,   3.929202010628943e-10,  -1.956898446091529e-11,   1.000585698536798e-12,  -4.524097623566285e-14,   1.709590437627537e-15,  -5.166441680364792e-17,
   1.977917214680578e-03,  -2.364673710019028e-05,   4.394728680103525e-07,  -1.074261115201687e-08,   3.965485765397350e-10,  -1.979720572161881e-11,   1.011986419308270e-12,
  -4.567873335267655e-14,   1.721358024503080e-15,  -5.180081082444473e-17,   1.978027232498938e-03,  -2.365486933713457e-05,   4.400791750926629e-07,  -1.079317288519248e-08,
   4.004132240871977e-10,  -2.004015067713378e-11,   1.024111414877548e-12,  -4.614363506419768e-14,   1.733823361098938e-15,  -5.194397866106868e-17,   1.978113854272737e-03,
  -2.366127851436415e-05,   4.405577117348831e-07,  -1.083310783105129e-08,   4.034653504687747e-10,  -2.023191795240985e-11,   1.033674067231360e-12,  -4.650980844676883e-14,
   1.743618423316607e-15,  -5.205553116265530e-17,   1.978163860314549e-03,  -2.366498101567446e-05,   4.408344346212896e-07,  -1.085621231349141e-08,   4.052310571941872e-10,
  -2.034281849761788e-11,   1.039200958584791e-12,  -4.672125124037575e-14,   1.749265233053322e-15,  -5.211946273394004e-17,   1.978182640903563e-03,  -2.366637203046857e-05,
   4.409384508926593e-07,  -1.086489910624769e-08,   4.058949042750073e-10,  -2.038450584149280e-11,   1.041277891039309e-12,  -4.680067215098939e-14,   1.751384509824829e-15,
  -5.214338531290813e-17,   1.978185754204005e-03,  -2.366660264743411e-05,   4.409556985717493e-07,  -1.086633963805702e-08,   4.060049889981251e-10,  -2.039141838870339e-11,
   1.041622253007342e-12,  -4.681383846468218e-14,   1.751735749249332e-15,  -5.214734637800919e-17,   3.022454763421237e-01,  -3.284573818428276e-03,   5.348756249699774e-05,
  -9.643142470861614e-07,   1.799851137250389e-08,  -3.298015408511306e-10,   5.371416722171770e-12,  -5.577305278187000e-14,  -7.126938325697759e-16,   6.365514293344345e-17,
   3.022531190509888e-01,  -3.284987168601716e-03,   5.350299515196064e-05,  -9.647849362187649e-07,   1.800993987464203e-08,  -3.299628824679260e-10,   5.368303127410168e-12,
  -5.544013674255489e-14,  -7.259088503516172e-16,   6.391202941244924e-17,   3.022656673926348e-01,  -3.285665895386743e-03,   5.352833739443928e-05,  -9.655578123522664e-07,
   1.802869666164766e-08,  -3.302270273917774e-10,   5.363153726051788e-12,  -5.489267671229184e-14,  -7.475813491008008e-16,   6.433021530514767e-17,   3.022789843254239e-01,
  -3.286386274847090e-03,   5.355523704105672e-05,  -9.663781158007963e-07,   1.804859230442558e-08,  -3.305063212621971e-10,   5.357638297479304e-12,  -5.431053015860946e-14,
  -7.705470112305069e-16,   6.476911735440741e-17,   3.022894663947606e-01,  -3.286953360563631e-03,   5.357641413096992e-05,  -9.670238594364685e-07,   1.806424536176878e-08,
  -3.307254134967523e-10,   5.353260356481508e-12,  -5.385147908474407e-14,  -7.885985998563817e-16,   6.511102502525205e-17,   3.022955164326888e-01,  -3.287280694266922e-03,
   5.358863861977430e-05,  -9.673965949503294e-07,   1.807327706756178e-08,  -3.308515696236551e-10,   5.350718831253249e-12,  -5.358619339483913e-14,  -7.990073702579142e-16,
   6.530693392021907e-17,   3.022977884013214e-01,  -3.287403622186465e-03,   5.359322956154021e-05,  -9.675365729705775e-07,   1.807666818773061e-08,  -3.308988883599969e-10,
   5.349761642518057e-12,  -5.348650847673422e-14,  -8.029142210458536e-16,   6.538023198695869e-17,   3.022981650189329e-01,  -3.287423999821573e-03,   5.359399060352853e-05,
  -9.675597769705632e-07,   1.807723029462256e-08,  -3.309067292607300e-10,   5.349602826006107e-12,  -5.346998071910244e-14,  -8.035617449924002e-16,   6.539236805385777e-17,
   6.551380260257801e-02,  -7.121308080138090e-04,   1.162891518370419e-05,  -2.135431392142864e-07,   4.330702565897847e-09,  -1.033995256649638e-10,   3.083943372426157e-12,
  -1.072979166565168e-13,   3.761209154212636e-15,  -1.182886435231717e-16,   6.551546499671929e-02,  -7.122225045941958e-04,   1.163265135853331e-05,  -2.136930841414574e-07,
   4.337469014863798e-09,  -1.037300622799571e-10,   3.099336148973577e-12,  -1.079149044145206e-13,   3.780766212504171e-15,  -1.187003048489636e-16,   6.551819447636258e-02,
  -7.123730863066682e-04,   1.163878912895740e-05,  -2.139395871275539e-07,   4.348601201470873e-09,  -1.042740314481838e-10,   3.124662209049397e-12,  -1.089292947026136e-13,
   3.812872574690290e-15,  -1.193735607798055e-16,   6.552109119636627e-02,  -7.125329289915870e-04,   1.164530754143894e-05,  -2.142016143008356e-07,   4.360445930944425e-09,
  -1.048530474854325e-10,   3.151611667619190e-12,  -1.100076813967215e-13,   3.846939889058764e-15,  -1.200844507704094e-16,   6.552337131499637e-02,  -7.126587723007586e-04,
   1.165044174586260e-05,  -2.144081708356529e-07,   4.369791449981302e-09,  -1.053100572314748e-10,   3.172876457615804e-12,  -1.108578504000073e-13,   3.873750712824858e-15,
  -1.206413870814299e-16,   6.552468737034293e-02,  -7.127314175005739e-04,   1.165340647313521e-05,  -2.145275150460091e-07,   4.375194426101569e-09,  -1.055743365046595e-10,
   3.185171000249465e-12,  -1.113490886398372e-13,   3.889223525415039e-15,  -1.209617841982026e-16,   6.552518159138418e-02,  -7.127587000063645e-04,   1.165452007502690e-05,
  -2.145723557873378e-07,   4.377225093362368e-09,  -1.056736762318913e-10,   3.189791922363950e-12,  -1.115336646629911e-13,   3.895033662878888e-15,  -1.210819028599080e-16,
   6.552526351713507e-02,  -7.127632226574748e-04,   1.165470468722654e-05,  -2.145797901438821e-07,   4.377561800310359e-09,  -1.056901485026273e-10,   3.190558127867176e-12,
  -1.115642666420128e-13,   3.895996772988125e-15,  -1.211018040191469e-16,   1.889538594662677e-03,  -2.055453983926118e-05,   3.384978136183083e-07,  -6.564503305159160e-09,
   1.641699743332560e-10,  -5.968634712155212e-12,   2.737621964340465e-13,  -1.259827036494295e-14,   5.187705939596540e-16,  -1.826398870271476e-17,   1.889587054321281e-03,
  -2.055737361968618e-05,   3.386414575934444e-07,  -6.573329404967596e-09,   1.647798607905861e-10,  -6.007824089531021e-12,   2.759010734158089e-13,  -1.269432595511038e-14,
   5.222236174348052e-16,  -1.835676996206846e-17,   1.889666624037176e-03,  -2.056202853127196e-05,   3.388776569987121e-07,  -6.587859830706143e-09,   1.657844264673398e-10,
  -6.072368896442428e-12,   2.794223674279287e-13,  -1.285235939238566e-14,   5.278986701743640e-16,  -1.850896411928278e-17,   1.889751074532448e-03,  -2.056697156810475e-05,
   3.391288066413187e-07,  -6.603333515395145e-09,   1.668548939016287e-10,  -6.141140518817264e-12,   2.831723079203252e-13,  -1.302051050654122e-14,   5.339289382358268e-16,
  -1.867028704270512e-17,   1.889817552649946e-03,  -2.057086453249457e-05,   3.393268428932697e-07,  -6.615551866536485e-09,   1.677006552239092e-10,  -6.195470519939598e-12,
   2.861333675441646e-13,  -1.315318309442405e-14,   5.386809852301802e-16,  -1.879712667553683e-17,   1.889855924544004e-03,  -2.057311234994670e-05,   3.394412861731626e-07,
  -6.622619573167276e-09,   1.681900847525986e-10,  -6.226908255482789e-12,   2.878461985675559e-13,  -1.322988596933622e-14,   5.414259571905112e-16,  -1.887027874973785e-17,
   1.889870334720280e-03,  -2.057395663807303e-05,   3.394842896576225e-07,  -6.625276643760263e-09,   1.683741209440214e-10,  -6.238729105934021e-12,   2.884901297146377e-13,
  -1.325871415677271e-14,   5.424571876013423e-16,  -1.889773865314456e-17,   1.889872723473868e-03,  -2.057409660201569e-05,   3.394914196259136e-07,  -6.625717253631273e-09,
   1.684046408003188e-10,  -6.240689407966739e-12,   2.885969098850429e-13,  -1.326349418626891e-14,   5.426281533640056e-16,  -1.890229002634309e-17,   2.898959986693450e-01,
  -2.898523344637090e-03,   4.344715505267024e-05,  -7.226572174429274e-07,   1.255895040654881e-08,  -2.205845413778960e-10,   3.738313833234871e-12,  -5.491863645251883e-14,
   4.525771184076854e-16,   1.039319987284409e-17,   2.899022031751004e-01,  -2.898832977077043e-03,   4.345792377456791e-05,  -7.229725023713236e-07,   1.256695040424445e-08,
  -2.207477282676736e-10,   3.740022115577713e-12,  -5.486072181364415e-14,   4.480141476433742e-16,   1.056700647863775e-17,   2.899123899906914e-01,  -2.899341386464932e-03,
   4.347560731843156e-05,  -7.234902610783406e-07,   1.258008628036385e-08,  -2.210154978247133e-10,   3.742813288393072e-12,  -5.476500108295331e-14,   4.405045037468860e-16,
   1.085245813759966e-17,   2.899232005054025e-01,  -2.899880980833050e-03,   4.349437764553085e-05,  -7.240398706191731e-07,   1.259402796240176e-08,  -2.212994471117503e-10,
   3.745756902231115e-12,  -5.466255786619269e-14,   4.325107149625718e-16,   1.115550238540969e-17,   2.899317095351837e-01,  -2.900305740547530e-03,   4.350915485800047e-05,
  -7.244725809009012e-07,   1.260500266626513e-08,  -2.215227894528777e-10,   3.748060459874085e-12,  -5.458130000833318e-14,   4.262011627378147e-16,   1.139411016653035e-17,
   2.899366207028257e-01,  -2.900550916218313e-03,   4.351768502720017e-05,  -7.247223724607107e-07,   1.261133739242451e-08,  -2.216516334832067e-10,   3.749384636538469e-12,
  -5.453415011271534e-14,   4.225524373260012e-16,   1.153185829864890e-17,   2.899384649783164e-01,  -2.900642989404839e-03,   4.352088855932965e-05,  -7.248161841467563e-07,
   1.261371633563275e-08,  -2.217000059965021e-10,   3.749880884550079e-12,  -5.451639676799542e-14,   4.211809155002445e-16,   1.158359204559066e-17,   2.899387706977671e-01,
  -2.900658252237714e-03,   4.352141961008977e-05,  -7.248317354343860e-07,   1.261411068956469e-08,  -2.217080239206114e-10,   3.749963092327887e-12,  -5.451345135987088e-14,
   4.209534928875544e-16,   1.159216807037953e-17,   6.283659624473631e-02,  -6.283068760793686e-04,   9.424630830873222e-06,  -1.575941802252118e-07,   2.815799091913006e-09,
  -5.504181387796985e-11,   1.266351341991436e-12,  -3.593456159401381e-14,   1.169443120056726e-15,  -3.829049156433120e-17,   6.283794230563416e-02,  -6.283744367359010e-04,
   9.427050754377644e-06,  -1.576734458553342e-07,   2.818559693734660e-09,  -5.515244892286623e-11,   1.271167426899599e-12,  -3.613691712850322e-14,   1.176952852781709e-15,
  -3.852078978069108e-17,   6.284015233395933e-02,  -6.284853731718446e-04,   9.431025172674255e-06,  -1.578036883765153e-07,   2.823099182699405e-09,  -5.533451539012803e-11,
   1.279095576758802e-12,  -3.646997148458958e-14,   1.189305451243167e-15,  -3.889915724061553e-17,   6.284249768676108e-02,  -6.286031188728544e-04,   9.435244680916223e-06,
  -1.579420425238168e-07,   2.827926162510071e-09,  -5.552830254356131e-11,   1.287537577976070e-12,  -3.682453049782243e-14,   1.202445303636620e-15,  -3.930103208507204e-17,
   6.284434373939679e-02,  -6.286958096786066e-04,   9.438567154697306e-06,  -1.580510416660777e-07,   2.831732443244656e-09,  -5.568124967366257e-11,   1.294202954001070e-12,
  -3.710441251546341e-14,   1.212810145888203e-15,  -3.961759442779988e-17,   6.284540923177094e-02,  -6.287493131091164e-04,   9.440485300848972e-06,  -1.581139928449186e-07,
   2.833932102306315e-09,  -5.576969333544758e-11,   1.298058291615915e-12,  -3.726627564970376e-14,   1.218801392310276e-15,  -3.980040181119094e-17,   6.284580935352442e-02,
  -6.287694060235327e-04,   9.441205712705461e-06,  -1.581376402732319e-07,   2.834758659985305e-09,  -5.580293789584782e-11,   1.299507639437094e-12,  -3.732712072188288e-14,
   1.221052957977914e-15,  -3.986906904457853e-17,   6.284587568042269e-02,  -6.287727368090090e-04,   9.441325138084635e-06,  -1.581415606286667e-07,   2.834895703510206e-09,
  -5.580845040378512e-11,   1.299747975613518e-12,  -3.733721003262310e-14,   1.221426281776584e-15,  -3.988045273895634e-17,   1.812290909775591e-03,  -1.812423379020011e-05,
   2.724402692737595e-07,  -4.628493990596889e-09,   8.950272146933095e-11,  -2.239438217042918e-12,   7.852503756167498e-14,  -3.306514039624537e-15,   1.381993670111931e-16,
  -5.224889379210533e-18,   1.812329835723131e-03,  -1.812622138261336e-05,   2.725176826817580e-07,  -4.631768486080846e-09,   8.967719951226951e-11,  -2.249766077335584e-12,
   7.909944947509203e-14,  -3.334322093533233e-15,   1.393388984216066e-16,  -5.263545988901701e-18,   1.812393747092157e-03,  -1.812948536854200e-05,   2.726448792036296e-07,
  -4.637154910849383e-09,   8.996453241639670e-11,  -2.266781677995334e-12,   8.004574909027955e-14,  -3.380117455104062e-15,   1.412144289637118e-16,  -5.327112940979861e-18,
   1.812461573045604e-03,  -1.813295011342515e-05,   2.727799941971909e-07,  -4.642885050993686e-09,   9.027063942735180e-11,  -2.284919276887125e-12,   8.105435162845311e-14,
  -3.428905715104831e-15,   1.432110429726077e-16,  -5.394705909931010e-18,   1.812514960434160e-03,  -1.813567790355469e-05,   2.728864390046874e-07,  -4.647405391611604e-09,
   9.051243611658956e-11,  -2.299253697363063e-12,   8.185139522122283e-14,  -3.467444294986270e-15,   1.447871176435924e-16,  -5.448005553748791e-18,   1.812545774551307e-03,
  -1.813725257301515e-05,   2.729479139964419e-07,  -4.650018462753072e-09,   9.065233874739494e-11,  -2.307550481104131e-12,   8.231269664754595e-14,  -3.489742623946652e-15,
   1.456985968192612e-16,  -5.478807261381780e-18,   1.812557346165875e-03,  -1.813784395431327e-05,   2.729710067198560e-07,  -4.651000509669385e-09,   9.070494114679170e-11,
  -2.310670568121442e-12,   8.248616813321355e-14,  -3.498126640969107e-15,   1.460412246206500e-16,  -5.490381430206438e-18,   1.812559264358660e-03,  -1.813794198830544e-05,
   2.729748351049078e-07,  -4.651163340903326e-09,   9.071366431420099e-11,  -2.311188008011538e-12,   8.251493661505744e-14,  -3.499516980268946e-15,   1.460980389854978e-16,
  -5.492300426688820e-18,   2.789465552937908e-01,  -2.582523699155974e-03,   3.584978138172430e-05,  -5.526232683048610e-07,   8.929264126147062e-09,  -1.474852113824885e-10,
   2.430898320413865e-12,  -3.822760448043070e-14,   5.113550085496578e-16,  -3.387178806788870e-18,   2.789516723730518e-01,  -2.582760371312802e-03,   3.585743512895310e-05,
  -5.528341174948585e-07,   8.934477131492361e-09,  -1.475997050273794e-10,   2.432919474889591e-12,  -3.824356370813766e-14,   5.105733552505505e-16,  -3.335534413693683e-18,
   2.789600736790728e-01,  -2.583148972262719e-03,   3.587000321891104e-05,  -5.531803784438963e-07,   8.943038233233238e-09,  -1.477876984394168e-10,   2.436235225647021e-12,
  -3.826957009608606e-14,   5.092813823722019e-16,  -3.250482233607927e-18,   2.789689891910556e-01,  -2.583561396676704e-03,   3.588334331814831e-05,  -5.535479483015048e-07,
   8.952126448380057e-09,  -1.479872193657041e-10,   2.439750351741575e-12,  -3.829690166919748e-14,   5.078985789091522e-16,  -3.159869194471995e-18,   2.789760065257498e-01,
  -2.583886041147349e-03,   3.589384522164183e-05,  -5.538373437361645e-07,   8.959281978584193e-09,  -1.481442760627609e-10,   2.442514488821209e-12,  -3.831822075622920e-14,
   5.068016657036334e-16,  -3.088291379356385e-18,   2.789800566794994e-01,  -2.584073425595342e-03,   3.589990734859749e-05,  -5.540044060139939e-07,   8.963412799921792e-09,
  -1.482349295935535e-10,   2.444108806587227e-12,  -3.833044771263443e-14,   5.061651495332332e-16,  -3.046876310509135e-18,   2.789815776116119e-01,  -2.584143795191411e-03,
   3.590218397821084e-05,  -5.540671483526910e-07,   8.964964195874713e-09,  -1.482689733533356e-10,   2.444707314482551e-12,  -3.833502454134785e-14,   5.059254759036475e-16,
  -3.031304491709768e-18,   2.789818297309981e-01,  -2.584155460216276e-03,   3.590256137485312e-05,  -5.540775492572476e-07,   8.965221374169517e-09,  -1.482746167232853e-10,
   2.444806516528614e-12,  -3.833578245007683e-14,   5.058857119810527e-16,  -3.028722182386276e-18,   6.046316839371201e-02,  -5.597828256024759e-04,   7.772057076250238e-06,
  -1.199764358464071e-07,   1.954809154371387e-09,  -3.350691193076809e-11,   6.274244420119269e-13,  -1.381149629724581e-14,   3.705842649176734e-16,  -1.126474523234157e-17,
   6.046427778667584e-02,  -5.598342159811559e-04,   7.773733878923919e-06,  -1.200244761270510e-07,   1.956166638635521e-09,  -3.354914764059556e-11,   6.289488712383786e-13,
  -1.387134131626941e-14,   3.728771909982933e-16,  -1.134396532995098e-17,   6.046609920854287e-02,  -5.599185965157158e-04,   7.776487465562598e-06,  -1.201033858706447e-07,
   1.958397546412705e-09,  -3.361861505962283e-11,   6.314581348739879e-13,  -1.396988230665310e-14,   3.766522956120010e-16,  -1.147433056829012e-17,   6.046803211414595e-02,
  -5.600081510576468e-04,   7.779410381263854e-06,  -1.201871748757564e-07,   1.960767949146760e-09,  -3.369250329997700e-11,   6.341297349868183e-13,  -1.407484444065537e-14,
   3.806727954546220e-16,  -1.161308294947446e-17,   6.046955349208904e-02,  -5.600786456371356e-04,   7.781711562719542e-06,  -1.202531605235383e-07,   1.962635816836443e-09,
  -3.375078284457656e-11,   6.362388842546852e-13,  -1.415774213238859e-14,   3.838476927771785e-16,  -1.172258928006030e-17,   6.047043157763858e-02,  -5.601193353256546e-04,
   7.783039953030897e-06,  -1.202912594915181e-07,   1.963714742591734e-09,  -3.378446895507656e-11,   6.374587599928828e-13,  -1.420570120009184e-14,   3.856842980433883e-16,
  -1.178591074973086e-17,   6.047076132045960e-02,  -5.601346158214779e-04,   7.783538839861604e-06,  -1.203055693164432e-07,   1.964120068314314e-09,  -3.379712823482486e-11,
   6.379173358258890e-13,  -1.422373247640182e-14,   3.863747766449405e-16,  -1.180971187875175e-17,   6.047081598073608e-02,  -5.601371488411127e-04,   7.783621540822033e-06,
  -1.203079415480330e-07,   1.964187266268836e-09,  -3.379922720944787e-11,   6.379933777435760e-13,  -1.422672258856318e-14,   3.864892763652867e-16,  -1.181365848500891e-17,
   1.743831817892487e-03,  -1.614539956001965e-05,   2.242758434047000e-07,  -3.476682583543126e-09,   5.805009643021280e-11,  -1.101184340002000e-12,   2.704559369356031e-14,
  -8.997788445725104e-16,   3.480268633607432e-17,  -1.330195164500888e-18,   1.743863834353719e-03,  -1.614688945757359e-05,   2.243257469373451e-07,  -3.478273426141142e-09,
   5.810956201560594e-11,  -1.103987892067277e-12,   2.719075755185198e-14,  -9.069100885927011e-16,   3.511370434574597e-17,  -1.341931550436279e-18,   1.743916399745868e-03,
  -1.614933586213919e-05,   2.244077089211308e-07,  -3.480887983620154e-09,   5.820741184872090e-11,  -1.108605987711647e-12,   2.742997337351274e-14,  -9.186610679539855e-16,
   3.562604991884523e-17,  -1.361255561535527e-18,   1.743972182745004e-03,  -1.615193236191358e-05,   2.244947276372631e-07,  -3.483666224834634e-09,   5.831154798584192e-11,
  -1.113527413587663e-12,   2.768503378321866e-14,  -9.311895291173149e-16,   3.617208250508573e-17,  -1.381837122523442e-18,   1.744016089368561e-03,  -1.615397631033316e-05,
   2.245632486064500e-07,  -3.485855613832063e-09,   5.839372866083560e-11,  -1.117416042586786e-12,   2.788666326918160e-14,  -9.410928557245977e-16,   3.660354930294529e-17,
  -1.398090918857668e-18,   1.744041430788554e-03,  -1.615515610926489e-05,   2.246028081622774e-07,  -3.487120317244429e-09,   5.844124712289450e-11,  -1.119666449534700e-12,
   2.800338731536201e-14,  -9.468256707481595e-16,   3.685325411131925e-17,  -1.407493762546771e-18,   1.744050947131101e-03,  -1.615559917262000e-05,   2.246176659619719e-07,
  -3.487595446276502e-09,   5.845910788609148e-11,  -1.120512673796090e-12,   2.804728643395029e-14,  -9.489816943420077e-16,   3.694715257430574e-17,  -1.411028870512646e-18,
   1.744052524621529e-03,  -1.615567261867188e-05,   2.246201290023507e-07,  -3.487674217344329e-09,   5.846206946636480e-11,  -1.120653009557355e-12,   2.805456693477522e-14,
  -9.493392600027925e-16,   3.696272454550862e-17,  -1.411615089325189e-18,   2.691512148016318e-01,  -2.320027865456067e-03,   2.998752151158384e-05,  -4.305151003841930e-07,
   6.485277055414863e-09,  -1.002716660972861e-10,   1.567602513733042e-12,  -2.427003926165100e-14,   3.559115055456557e-16,  -4.385455092360372e-18,   2.691554934205095e-01,
  -2.320212168263771e-03,   2.999307799019628e-05,  -4.306584100237401e-07,   6.488640159330305e-09,  -1.003445508803866e-10,   1.569023499332797e-12,  -2.429227613173859e-14,
   3.560495588202635e-16,  -4.376979654161826e-18,   2.691625180406645e-01,  -2.320514775525754e-03,   3.000220193028689e-05,  -4.308937511129016e-07,   6.494163432727547e-09,
  -1.004642509311176e-10,   1.571356661388674e-12,  -2.432874942038107e-14,   3.562738570585410e-16,  -4.362966625224782e-18,   2.691699724869377e-01,  -2.320835925542863e-03,
   3.001188596519142e-05,  -4.311435683236867e-07,   6.500027034909743e-09,  -1.005913269760626e-10,   1.573832845126704e-12,  -2.436740652505204e-14,   3.565086687123321e-16,
  -4.347962660466755e-18,   2.691758397411618e-01,  -2.321088715980794e-03,   3.001950940063809e-05,  -4.313402497450760e-07,   6.504643880110586e-09,  -1.006913835514745e-10,
   1.575781987198378e-12,  -2.439779794441444e-14,   3.566911537437649e-16,  -4.336056517167414e-18,   2.691792260751523e-01,  -2.321234623800947e-03,   3.002390985587809e-05,
  -4.314537880947493e-07,   6.507309217462139e-09,  -1.007491470117571e-10,   1.576907023535544e-12,  -2.441532457707497e-14,   3.567955402477334e-16,  -4.329145936095621e-18,
   2.691804977201194e-01,  -2.321289416949275e-03,   3.002556242588733e-05,  -4.314964284800860e-07,   6.508310241778936e-09,  -1.007708413279058e-10,   1.577329513788737e-12,
  -2.442190356692441e-14,   3.568345625532691e-16,  -4.326543507432450e-18,   2.691807085157369e-01,  -2.321298499872585e-03,   3.002583637121469e-05,  -4.315034970300636e-07,
   6.508476184520731e-09,  -1.007744376592392e-10,   1.577399549065796e-12,  -2.442299400005224e-14,   3.568410217754437e-16,  -4.326111725157989e-18,   5.833996129407161e-02,
  -5.028797138761043e-04,   6.500227112751855e-06,  -9.335381918138914e-08,   1.409552489815090e-09,  -2.204650148526289e-11,   3.607235011466740e-13,  -6.448322040166035e-15,
   1.351208940587841e-16,  -3.412393167802019e-18,   5.834088875335926e-02,  -5.029196801373786e-04,   6.501435054074682e-06,  -9.338535839393419e-08,   1.410329069100054e-09,
  -2.206606241806399e-11,   3.612753812191339e-13,  -6.466417270403024e-15,   1.357670481405592e-16,  -3.435122908811228e-18,   5.834241145288351e-02,  -5.029853009965610e-04,
   6.503418566677859e-06,  -9.343715535895221e-08,   1.411604808418278e-09,  -2.209821434409622e-11,   3.621832623752815e-13,  -6.496208583800468e-15,   1.368312482731321e-16,
  -3.472556268588950e-18,   5.834402732468930e-02,  -5.030549430861641e-04,   6.505523881457375e-06,  -9.349214347733126e-08,   1.412959635152300e-09,  -2.213238379359143e-11,
   3.631491559574733e-13,  -6.527935322835024e-15,   1.379651220832925e-16,  -3.512437651791168e-18,   5.834529914734497e-02,  -5.031097613991107e-04,   6.507181249439287e-06,
  -9.353543936954048e-08,   1.414026738364391e-09,  -2.215931434172258e-11,   3.639111781865854e-13,  -6.552988505038252e-15,   1.388608784859908e-16,  -3.543941754783867e-18,
   5.834603319040268e-02,  -5.031414019775316e-04,   6.508137939065225e-06,  -9.356043428001728e-08,   1.414642924613804e-09,  -2.217487215193329e-11,   3.643517026744508e-13,
  -6.567480949499317e-15,   1.393791988336339e-16,  -3.562170443064099e-18,   5.834630884019551e-02,  -5.031532840586856e-04,   6.508497221483379e-06,  -9.356982163107350e-08,
   1.414874373013641e-09,  -2.218071722823076e-11,   3.645172652764836e-13,  -6.572929395586061e-15,   1.395740909402589e-16,  -3.569024397315094e-18,   5.834635453358623e-02,
  -5.031552537221923e-04,   6.508556779583644e-06,  -9.357137779874708e-08,   1.414912742294036e-09,  -2.218168628972577e-11,   3.645447171046780e-13,  -6.573832890748387e-15,
   1.396064106958693e-16,  -3.570161008046285e-18,   1.682594735530877e-03,  -1.450376359433386e-05,   1.874969430857756e-07,  -2.695566641535542e-09,   4.097756392357523e-11,
  -6.625540070499531e-13,   1.221877689113600e-14,  -2.904785708618997e-16,   9.087122627264710e-18,  -3.233432259755265e-19,   1.682621488389681e-03,  -1.450491775054617e-05,
   1.875320821005763e-07,  -2.696517095639612e-09,   4.100409767644863e-11,  -6.634500396331155e-13,   1.225658418004589e-14,  -2.922171615651684e-16,   9.163687101380365e-18,
  -3.263827106333426e-19,   1.682665411177134e-03,  -1.450681277989664e-05,   1.875897850022468e-07,  -2.698078353307670e-09,   4.104771631701194e-11,  -6.649248314367433e-13,
   1.231887433815152e-14,  -2.950827345735973e-16,   9.289878515147726e-18,  -3.313910431520372e-19,   1.682712021597594e-03,  -1.450882395379002e-05,   1.876510347161581e-07,
  -2.699736239170659e-09,   4.109407970331335e-11,  -6.664948903535773e-13,   1.238527339036564e-14,  -2.981388537366121e-16,   9.424456251046627e-18,  -3.367304946889370e-19,
   1.682748707826919e-03,  -1.451040704888721e-05,   1.876992548519315e-07,  -2.701041925881222e-09,   4.113062646655851e-11,  -6.677343040172983e-13,   1.243775079813900e-14,
  -3.005553057439305e-16,   9.530862330555068e-18,  -3.409509686570192e-19,   1.682769881603940e-03,  -1.451132080058360e-05,   1.877270901699939e-07,  -2.701795833294362e-09,
   4.115174183156865e-11,  -6.684511082399308e-13,   1.246812533201830e-14,  -3.019544149216539e-16,   9.592469237052004e-18,  -3.433940327728789e-19,   1.682777832839344e-03,
  -1.451166394546784e-05,   1.877375438444964e-07,  -2.702079003041531e-09,   4.115967531128497e-11,  -6.687205620055950e-13,   1.247954807940185e-14,  -3.024806512415507e-16,
   9.615640689330202e-18,  -3.443128174927016e-19,   1.682779150884752e-03,  -1.451172082780673e-05,   1.877392767558851e-07,  -2.702125946175703e-09,   4.116099063401798e-11,
  -6.687652429566497e-13,   1.248144245057327e-14,  -3.025679276784941e-16,   9.619483665782866e-18,  -3.444651925655258e-19,   2.603204893737344e-01,  -2.099168614341548e-03,
   2.538378966341257e-05,  -3.409596670727598e-07,   4.807085412003825e-09,  -6.965468217727591e-11,   1.025415080776208e-12,  -1.516787440565260e-14,   2.211368342647753e-16,
  -3.040759959319136e-18,   2.603241099528147e-01,  -2.099314529170466e-03,   2.538790663145188e-05,  -3.410591758473500e-07,   4.809284801425236e-09,  -6.970026016862622e-11,
   1.026300804269044e-12,  -1.518348307018781e-14,   2.213579106235606e-16,  -3.041924689159957e-18,   2.603300541449843e-01,  -2.099554102780668e-03,   2.539466666168922e-05,
  -3.412225825949524e-07,   4.812896824211067e-09,  -6.977511755447304e-11,   1.027755497360107e-12,  -1.520911135046314e-14,   2.217204755410975e-16,  -3.043812679347156e-18,
   2.603363619708933e-01,  -2.099808350771072e-03,   2.540184142632901e-05,  -3.413960336662753e-07,   4.816731320832984e-09,  -6.985459288263660e-11,   1.029299901096127e-12,
  -1.523631050206730e-14,   2.221046827343650e-16,  -3.045783134407977e-18,   2.603413266820223e-01,  -2.100008475599956e-03,   2.540748934369396e-05,  -3.415325868389982e-07,
   4.819750437870551e-09,  -6.991717358855786e-11,   1.030515978555186e-12,  -1.525772036797476e-14,   2.224066902647127e-16,  -3.047310037961826e-18,   2.603441920818709e-01,
  -2.100123983709684e-03,   2.541074940446425e-05,  -3.416114128967497e-07,   4.821493369853989e-09,  -6.995330344914493e-11,   1.031218050454596e-12,  -1.527007800707599e-14,
   2.225808375466848e-16,  -3.048181657989151e-18,   2.603452680997587e-01,  -2.100167360451664e-03,   2.541197369125545e-05,  -3.416410163723060e-07,   4.822147960322888e-09,
  -6.996687308722230e-11,   1.031481732634128e-12,  -1.527471872183917e-14,   2.226462036900698e-16,  -3.048507145331634e-18,   2.603454464668006e-01,  -2.100174550888778e-03,
   2.541217663967306e-05,  -3.416459237571431e-07,   4.822256473453500e-09,  -6.996912258170841e-11,   1.031525444219237e-12,  -1.527548800244177e-14,   2.226570375906484e-16,
  -3.048561003718246e-18,   5.642585178449294e-02,  -4.550062100836616e-04,   5.502122033033160e-06,  -7.391186576688588e-08,   1.042695785332054e-09,  -1.515892201868363e-11,
   2.264369552541282e-13,  -3.530235690084175e-15,   6.011124209455435e-17,  -1.193884970850266e-18,   5.642663657283958e-02,  -4.550378412370281e-04,   5.503015089130665e-06,
  -7.393352804328701e-08,   1.043182037487549e-09,  -1.516957269842629e-11,   2.266803997648645e-13,  -3.536518003825012e-15,   6.029948786726403e-17,  -1.200033211273238e-18,
   5.642792502226271e-02,  -4.550897756016541e-04,   5.504481486306833e-06,  -7.396910117416242e-08,   1.043980676826067e-09,  -1.518707119223614e-11,   2.270806008758484e-13,
  -3.546854467202444e-15,   6.060946017794461e-17,  -1.210161209724788e-18,   5.642929229220521e-02,  -4.551448910941603e-04,   5.506037856347228e-06,  -7.400686197104385e-08,
   1.044828608729490e-09,  -1.520565706559878e-11,   2.275059908446713e-13,  -3.557853622734894e-15,   6.093964030836912e-17,  -1.220955011760354e-18,   5.643036843173183e-02,
  -4.551882738794228e-04,   5.507263024196778e-06,  -7.403659075110914e-08,   1.045496307997535e-09,  -1.522029774799852e-11,   2.278413160388546e-13,  -3.566532783867079e-15,
   6.120041961355676e-17,  -1.229484050973043e-18,   5.643098952933671e-02,  -4.552133135804467e-04,   5.507970211385617e-06,  -7.405375215644837e-08,   1.045881799701458e-09,
  -1.522875259168831e-11,   2.280350560338770e-13,  -3.571550842409644e-15,   6.135129230833672e-17,  -1.234420084811877e-18,   5.643122276455172e-02,  -4.552227167376045e-04,
   5.508235789678060e-06,  -7.406019725630366e-08,   1.046026583922218e-09,  -1.523192849477959e-11,   2.281078484407065e-13,  -3.573436903975977e-15,   6.140801687984498e-17,
  -1.236276218122219e-18,   5.643126142699049e-02,  -4.552242754718996e-04,   5.508279814266997e-06,  -7.406126566720207e-08,   1.046050585470026e-09,  -1.523245500028147e-11,
   2.281199169940508e-13,  -3.573749637032220e-15,   6.141742350425578e-17,  -1.236584036207612e-18,   1.627389292852951e-03,  -1.312294464309628e-05,   1.586919345073155e-07,
  -2.132287441407831e-09,   3.013365258355804e-11,  -4.423124431288920e-13,   6.884654920917269e-15,  -1.226348765512142e-16,   2.793497589510679e-18,  -8.170654235086860e-20,
   1.627411927792910e-03,  -1.312385719916559e-05,   1.587177480604856e-07,  -2.132920044736109e-09,   3.014848590113949e-11,  -4.426859725541176e-13,   6.896163960662618e-15,
  -1.230729701942252e-16,   2.811597849864876e-18,  -8.242832863674641e-20,   1.627449089379941e-03,  -1.312535550363772e-05,   1.587601343853243e-07,  -2.133958952674110e-09,
   3.017285515322711e-11,  -4.433001406801624e-13,   6.915110752408888e-15,  -1.237948818034249e-16,   2.841435948353645e-18,  -8.361818755215391e-20,   1.627488524325154e-03,
  -1.312694558693206e-05,   1.588051220614028e-07,  -2.135061841075979e-09,   3.019873726867615e-11,  -4.439531273121653e-13,   6.935286774787144e-15,  -1.245645790456849e-16,
   2.873264886955230e-18,  -8.488743592021964e-20,   1.627519562462383e-03,  -1.312819718381073e-05,   1.588405366610076e-07,  -2.135930201884646e-09,   3.021912437175166e-11,
  -4.444679799276934e-13,   6.951217704327034e-15,  -1.251730167772916e-16,   2.898436706908247e-18,  -8.589121621094503e-20,   1.627537476231936e-03,  -1.312891958221337e-05,
   1.588609787531168e-07,  -2.136431503091364e-09,   3.023089729132821e-11,  -4.447654925710725e-13,   6.960432768455701e-15,  -1.255252357741256e-16,   2.913012985059394e-18,
  -8.647247577212736e-20,   1.627544203229700e-03,  -1.312919086462280e-05,   1.588686556490656e-07,  -2.136619775653530e-09,   3.023531948756214e-11,  -4.448772836654591e-13,
   6.963897094480660e-15,  -1.256577015161271e-16,   2.918495821809249e-18,  -8.669111515293201e-20,   1.627545318336375e-03,  -1.312923583433687e-05,   1.588699282407061e-07,
  -2.136650986054533e-09,   3.023605260102639e-11,  -4.448958184475834e-13,   6.964471566103212e-15,  -1.256796703788261e-16,   2.919405171393836e-18,  -8.672737732453429e-20,
   2.523057590828217e-01,  -1.911254684308278e-03,   2.171175056352342e-05,  -2.739851245163101e-07,   3.629427690677981e-09,  -4.943345715713448e-11,   6.851419904725085e-13,
  -9.592303279318082e-15,   1.344135316423565e-16,  -1.850810423814514e-18,   2.523088550732552e-01,  -1.911371904036351e-03,   2.171485785469158e-05,  -2.740557154139033e-07,
   3.630896606457588e-09,  -4.946227580994471e-11,   6.856807723715799e-13,  -9.601839005851218e-15,   1.345675498234417e-16,  -1.852821503740861e-18,   2.523139379637149e-01,
  -1.911564361036487e-03,   2.171995988476459e-05,  -2.741716315061900e-07,   3.633308902486773e-09,  -4.950960692635752e-11,   6.865657139064962e-13,  -9.617500864624048e-15,
   1.348204390713656e-16,  -1.856119469978425e-18,   2.523193317398241e-01,  -1.911768602484211e-03,   2.172537476835340e-05,  -2.742946678289277e-07,   3.635869667586322e-09,
  -4.955985695114329e-11,   6.875053085735955e-13,  -9.634129384967407e-15,   1.350888326440019e-16,  -1.859614020879043e-18,   2.523235769860391e-01,  -1.911929363081747e-03,
   2.172963720485372e-05,  -2.743915273142299e-07,   3.637885823489029e-09,  -4.959942430222854e-11,   6.882452113763550e-13,  -9.647223408650772e-15,   1.353001017405857e-16,
  -1.862360721911401e-18,   2.523260271273556e-01,  -1.912022149787758e-03,   2.173209749900696e-05,  -2.744474385462514e-07,   3.639049715405667e-09,  -4.962226754081821e-11,
   6.886723988857954e-13,  -9.654783146373416e-15,   1.354220459368702e-16,  -1.863944475597782e-18,   2.523269472037356e-01,  -1.912056993748259e-03,   2.173302143173326e-05,
  -2.744684359871234e-07,   3.639486830575094e-09,  -4.963084694411753e-11,   6.888328451476563e-13,  -9.657622454860065e-15,   1.354678403286885e-16,  -1.864538921445049e-18,
   2.523270997208290e-01,  -1.912062769719440e-03,   2.173317459038494e-05,  -2.744719167304806e-07,   3.639559291951812e-09,  -4.963226918426965e-11,   6.888594431585943e-13,
  -9.658093139987242e-15,   1.354754315695103e-16,  -1.864637445121067e-18,   5.468861584175397e-02,  -4.142746658438472e-04,   4.706146629498578e-06,  -5.938902712254160e-08,
   7.868345039716377e-10,  -1.072647791029195e-11,   1.493106941282090e-13,  -2.126738534631754e-15,   3.157651258646476e-17,  -5.111661101394484e-19,   5.468928691571474e-02,
  -4.143000744585666e-04,   4.706820278618833e-06,  -5.940434574934248e-08,   7.871547362559641e-10,  -1.073287626478945e-11,   1.494378318912654e-13,  -2.129404187382468e-15,
   3.163978334600681e-17,  -5.129048618294397e-19,   5.469038866184465e-02,  -4.143417915526842e-04,   4.707926380820203e-06,  -5.942950035424132e-08,   7.876806462552818e-10,
  -1.074338598814228e-11,   1.496467327407774e-13,  -2.133786794637165e-15,   3.174389742298657e-17,  -5.157683392235201e-19,   5.469155779427087e-02,  -4.143860630583907e-04,
   4.709100310114936e-06,  -5.945620030733719e-08,   7.882389451447064e-10,  -1.075454549239095e-11,   1.498686426556695e-13,  -2.138445941590960e-15,   3.185470411904286e-17,
  -5.188190192333781e-19,   5.469247797615927e-02,  -4.144209096330400e-04,   4.710024393724816e-06,  -5.947721981016292e-08,   7.886785232752294e-10,  -1.076333378909641e-11,
   1.500434682162743e-13,  -2.142119145603539e-15,   3.194215174037724e-17,  -5.212288559816435e-19,   5.469300905859219e-02,  -4.144410221437480e-04,   4.710557778663857e-06,
  -5.948935318242411e-08,   7.889322902039794e-10,  -1.076840797713562e-11,   1.501444362379225e-13,  -2.144241606090292e-15,   3.199271675168001e-17,  -5.226232094016739e-19,
   5.469320849051956e-02,  -4.144485749452039e-04,   4.710758084798490e-06,  -5.949390987705447e-08,   7.890275969178883e-10,  -1.077031381830691e-11,   1.501823645008255e-13,
  -2.145039099824830e-15,   3.201172282750140e-17,  -5.231474823485854e-19,   5.469324154949010e-02,  -4.144498269488138e-04,   4.710791289187527e-06,  -5.949466524040723e-08,
   7.890433961459877e-10,  -1.077062976161496e-11,   1.501886523798516e-13,  -2.145171321622443e-15,   3.201487432849241e-17,  -5.232344239561943e-19,   1.577285283480001e-03,
  -1.194818175916675e-05,   1.357316542308645e-07,  -1.712955947735706e-09,   2.270444971763711e-11,  -3.103149920284160e-13,   4.373145889232314e-15,  -6.533820876072498e-17,
   1.118392499683033e-18,  -2.421629585185989e-20,   1.577304638184354e-03,  -1.194891462417684e-05,   1.357510935152601e-07,  -1.713399216680018e-09,   2.271383885200173e-11,
  -3.105123157845150e-13,   4.377694985129414e-15,  -6.546676252612620e-17,   1.122834543701419e-18,  -2.438248367013409e-20,   1.577336414072960e-03,  -1.195011787790864e-05,
   1.357830120594337e-07,  -1.714127118241659e-09,   2.272925970449948e-11,  -3.108365353051759e-13,   4.385176019453659e-15,  -6.567842860024462e-17,   1.130155355730232e-18,
  -2.465648221875302e-20,   1.577370133477588e-03,  -1.195139480963618e-05,   1.358168880043492e-07,  -1.714899755271110e-09,   2.274563203927252e-11,  -3.111809394392784e-13,
   4.393131630514562e-15,  -6.590387350396513e-17,   1.137962117713153e-18,  -2.494881628587292e-20,   1.577396672803781e-03,  -1.195239989669114e-05,   1.358435542746789e-07,
  -1.715508025511660e-09,   2.275852412554969e-11,  -3.114522645900649e-13,   4.399405557067886e-15,  -6.608191775751230e-17,   1.144134270375478e-18,  -2.518004694048265e-20,
   1.577411989960685e-03,  -1.195298000623864e-05,   1.358589461956955e-07,  -1.715859150709619e-09,   2.276596719856063e-11,  -3.116089629851963e-13,   4.403031512999722e-15,
  -6.618491890044185e-17,   1.147707669019939e-18,  -2.531396168104880e-20,   1.577417741855273e-03,  -1.195319785337910e-05,   1.358647264489412e-07,  -1.715991016942360e-09,
   2.276876267567049e-11,  -3.116678258593167e-13,   4.404394070364379e-15,  -6.622364386404051e-17,   1.149051660401439e-18,  -2.536433640282691e-20,   1.577418695322038e-03,
  -1.195323396520090e-05,   1.358656846315432e-07,  -1.716012876461479e-09,   2.276922609394036e-11,  -3.116775843352789e-13,   4.404619985213314e-15,  -6.623006556287774e-17,
   1.149274559434366e-18,  -2.537269140108810e-20,   2.449886069190491e-01,  -1.749794516185179e-03,   1.874239202319746e-05,  -2.230135115307527e-07,   2.785710320127826e-09,
  -3.578250424298975e-11,   4.679544408706300e-13,  -6.193084185244833e-15,   8.249908393084233e-17,  -1.097021427904804e-18,   2.449912788938772e-01,  -1.749889906054567e-03,
   1.874477626928944e-05,  -2.230645897713456e-07,   2.786713150848554e-09,  -3.580110247086343e-11,   4.682850828467362e-13,  -6.198741376587779e-15,   8.259132362702780e-17,
  -1.098402028814246e-18,   2.449956656192802e-01,  -1.750046519766237e-03,   1.874869101538404e-05,  -2.231484621398740e-07,   2.788359970984195e-09,  -3.583164671658405e-11,
   4.688281512772991e-13,  -6.208033687618723e-15,   8.274282784729424e-17,  -1.100668960121123e-18,   2.450003206087557e-01,  -1.750212720500437e-03,   1.875284570674115e-05,
  -2.232374832663121e-07,   2.790108069438570e-09,  -3.586407316985818e-11,   4.694047506545468e-13,  -6.217900501671571e-15,   8.290369123778702e-17,  -1.103074957676512e-18,
   2.450039843523582e-01,  -1.750343536907759e-03,   1.875611608130479e-05,  -2.233075622351491e-07,   2.791484335495760e-09,  -3.588960501732493e-11,   4.698587994450800e-13,
  -6.225670771689395e-15,   8.303036804371190e-17,  -1.104968926545807e-18,   2.450060988676191e-01,  -1.750419039851018e-03,   1.875800372323389e-05,  -2.233480137460902e-07,
   2.792278807391232e-09,  -3.590434478092509e-11,   4.701209449556904e-13,  -6.230157165175033e-15,   8.310350633958497e-17,  -1.106062146451471e-18,   2.450068929074963e-01,
  -1.750447393135885e-03,   1.875871259782746e-05,  -2.233632051212802e-07,   2.792577177645370e-09,  -3.590988062281336e-11,   4.702194030657450e-13,  -6.231842232127072e-15,
   8.313097628476217e-17,  -1.106472694011726e-18,   2.450070245319408e-01,  -1.750452093160887e-03,   1.875883010637955e-05,  -2.233657233846389e-07,   2.792626638798935e-09,
  -3.591079831607185e-11,   4.702357249548054e-13,  -6.232121576225079e-15,   8.313553012664829e-17,  -1.106540749862837e-18,   5.310258408698582e-02,  -3.792772792717812e-04,
   4.062514824933795e-06,  -4.833959762421822e-08,   6.038423878738745e-10,  -7.758167836217206e-12,   1.015814858327727e-13,  -1.351407261161287e-15,   1.835375478239229e-17,
  -2.594656216746533e-19,   5.310316325202540e-02,  -3.792979556443082e-04,   4.063031646142473e-06,  -4.835067236660652e-08,   6.040601006962818e-10,  -7.762227974026858e-12,
   1.016551601335690e-13,  -1.352751895504480e-15,   1.837980043004633e-17,  -2.600360787949065e-19,   5.310411409855736e-02,  -3.793319026825629e-04,   4.063880226465302e-06,
  -4.836885753429473e-08,   6.044176254992065e-10,  -7.768896262037184e-12,   1.017761838260570e-13,  -1.354961460161368e-15,   1.842262616445186e-17,  -2.609748723859510e-19,
   5.310512309278619e-02,  -3.793679277715882e-04,   4.064780818838452e-06,  -4.838815909319461e-08,   6.047971419087735e-10,  -7.775975794901890e-12,   1.019047019066904e-13,
  -1.357308878293484e-15,   1.846815963646119e-17,  -2.619741330061210e-19,   5.310591722909577e-02,  -3.793962830788912e-04,   4.065489722344770e-06,  -4.840335364287341e-08,
   6.050959355647686e-10,  -7.781550296459353e-12,   1.020059206739147e-13,  -1.359158411553019e-15,   1.850406152733743e-17,  -2.627628272484459e-19,   5.310637556175546e-02,
  -3.794126488334388e-04,   4.065898897573832e-06,  -4.841212436710801e-08,   6.052684202374533e-10,  -7.784768602212570e-12,   1.020643658398879e-13,  -1.360226657514859e-15,
   1.852480804266119e-17,  -2.632189104047613e-19,   5.310654767420885e-02,  -3.794187945926195e-04,   4.066052556988905e-06,  -4.841541817366364e-08,   6.053331984567767e-10,
  -7.785977325825087e-12,   1.020863182235609e-13,  -1.360627954195263e-15,   1.853260364316324e-17,  -2.633903468358145e-19,   5.310657620452165e-02,  -3.794198133536578e-04,
   4.066078028766494e-06,  -4.841596418572829e-08,   6.053439368228165e-10,  -7.786177700557093e-12,   1.020899574431341e-13,  -1.360694483292518e-15,   1.853389614355250e-17,
  -2.634187739931450e-19,   1.531542218116468e-03,  -1.093881225380280e-05,   1.171679304195748e-07,  -1.394190646367016e-09,   1.741754815365155e-11,  -2.239274217188656e-13,
   2.942024918788122e-15,  -3.972250948201997e-17,   5.687134112718080e-19,  -9.311629953161233e-21,   1.531558921953179e-03,  -1.093940859410095e-05,   1.171828380399328e-07,
  -1.394510321121197e-09,   1.742385550115752e-11,  -2.240469123982001e-13,   2.944317467075856e-15,  -3.977129274500492e-17,   5.699818792218357e-19,  -9.351572750735091e-21,
   1.531586345544465e-03,  -1.094038768212300e-05,   1.172073152134227e-07,  -1.395035242215291e-09,   1.743421358446203e-11,  -2.242431817741422e-13,   2.948084746329093e-15,
  -3.985152826327455e-17,   5.720706878152503e-19,  -9.417408516303064e-21,   1.531615446187622e-03,  -1.094142670463948e-05,   1.172332926907840e-07,  -1.395592391634789e-09,
   1.744520914152683e-11,  -2.244515831138321e-13,   2.952087146362234e-15,  -3.993686861354510e-17,   5.742958167172805e-19,  -9.487624121828047e-21,   1.531638350062511e-03,
  -1.094224451818551e-05,   1.172537409435628e-07,  -1.396030992528230e-09,   1.745386620236057e-11,  -2.246157007275037e-13,   2.955240702949447e-15,  -4.000418023635313e-17,
   5.760533540411719e-19,  -9.543144765545687e-21,   1.531651568944255e-03,  -1.094271653340944e-05,   1.172655435703141e-07,  -1.396284166348369e-09,   1.745886376510455e-11,
  -2.247104582128820e-13,   2.957062146572351e-15,  -4.004308668400929e-17,   5.770702148830406e-19,  -9.575291548307810e-21,   1.531656532880660e-03,  -1.094289378719832e-05,
   1.172699758651789e-07,  -1.396379244836000e-09,   1.746074066501327e-11,  -2.247460485351532e-13,   2.957746393878706e-15,  -4.005770772259782e-17,   5.774525393247299e-19,
  -9.587382813423705e-21,   1.531657355730232e-03,  -1.094292316994027e-05,   1.172707105968563e-07,  -1.396395005941678e-09,   1.746105180204226e-11,  -2.247519485597324e-13,
   2.957859832290632e-15,  -4.006013196453777e-17,   5.775159405775554e-19,  -9.589388160532160e-21,   2.382733607657092e-01,  -1.609853012667334e-03,   1.631186914077283e-05,
  -1.836111569923592e-07,   2.169723517799972e-09,  -2.636705008889792e-11,   3.262772445427274e-13,  -4.088245505128230e-15,   5.166285316582858e-17,  -6.555148810344103e-19,
   2.382756857980965e-01,  -1.609931533266604e-03,   1.631372570762420e-05,  -1.836487829006469e-07,   2.170422452657797e-09,  -2.637932168166962e-11,   3.264842113933136e-13,
  -4.091625524576668e-15,   5.171632926157180e-17,  -6.563251591655426e-19,   2.382795029067627e-01,  -1.610060449176802e-03,   1.631677399480184e-05,  -1.837105645652496e-07,
   2.171570187293050e-09,  -2.639947480295712e-11,   3.268241352985288e-13,  -4.097177379653680e-15,   5.180417146875179e-17,  -6.576561028828226e-19,   2.382835534146762e-01,
  -1.610197254741863e-03,   1.632000905064462e-05,  -1.837761368788304e-07,   2.172788457423614e-09,  -2.642086876859498e-11,   3.271850306590884e-13,  -4.103072414104847e-15,
   5.189745025969789e-17,  -6.590693434884138e-19,   2.382867413743957e-01,  -1.610304932896921e-03,   1.632255548208556e-05,  -1.838277550853527e-07,   2.173747557458067e-09,
  -2.643771313625665e-11,   3.274692091895269e-13,  -4.107714797579354e-15,   5.197091287731926e-17,  -6.601822994443107e-19,   2.382885812839386e-01,  -1.610367080658693e-03,
   1.632402524805172e-05,  -1.838575499538344e-07,   2.174301199160513e-09,  -2.644743723898231e-11,   3.276332751212808e-13,  -4.110395194921935e-15,   5.201333032490792e-17,
  -6.608248998024155e-19,   2.382892722025673e-01,  -1.610390418629406e-03,   1.632457719203351e-05,  -1.838687391669218e-07,   2.174509121004632e-09,  -2.645108928236936e-11,
   3.276948950319121e-13,  -4.111401935191106e-15,   5.202926241764331e-17,  -6.610662577426859e-19,   2.382893867329741e-01,  -1.610394287277907e-03,   1.632466868635011e-05,
  -1.838705939889382e-07,   2.174543588286291e-09,  -2.645169468964818e-11,   3.277051100220024e-13,  -4.111568828640924e-15,   5.203190359683535e-17,  -6.611062691831253e-19,
   5.164701873734159e-02,  -3.489442074229765e-04,   3.535684712169032e-06,  -3.979873619255440e-08,   4.703035422890145e-10,  -5.715579959241776e-12,   7.074963359799756e-14,
  -8.878148842114524e-16,   1.128656747568827e-17,  -1.462157985693067e-19,   5.164752270053128e-02,  -3.489612272002339e-04,   3.536087137048965e-06,  -3.980689239681039e-08,
   4.704551029348565e-10,  -5.718245235179526e-12,   7.079487153033711e-14,  -8.885701368269639e-16,   1.129933669282136e-17,  -1.464453644119336e-19,   5.164835007922518e-02,
  -3.489891704420305e-04,   3.536747876344957e-06,  -3.982028487300095e-08,   4.707039842091256e-10,  -5.722622352511526e-12,   7.086917382042580e-14,  -8.898108610268910e-16,
   1.132032116951404e-17,  -1.468228565015914e-19,   5.164922804845339e-02,  -3.490188238107344e-04,   3.537449099214946e-06,  -3.983449905957970e-08,   4.709681615711609e-10,
  -5.727269036167128e-12,   7.094806448198283e-14,  -8.911285283274404e-16,   1.134261691744007e-17,  -1.472242528389606e-19,   5.164991905575325e-02,  -3.490421636511686e-04,
   3.538001057566190e-06,  -3.984568840356847e-08,   4.711761394194199e-10,  -5.730927611572335e-12,   7.101018821283497e-14,  -8.921663824906774e-16,   1.136018525567775e-17,
  -1.475407693589187e-19,   5.165031786597600e-02,  -3.490556345250935e-04,   3.538319640515729e-06,  -3.985214707711024e-08,   4.712961951197128e-10,  -5.733039692994464e-12,
   7.104605561885621e-14,  -8.927656867001780e-16,   1.137033290526076e-17,  -1.477236844393559e-19,   5.165046762627990e-02,  -3.490606931604016e-04,   3.538439278573830e-06,
  -3.985457257822730e-08,   4.713412824499072e-10,  -5.733832922705920e-12,   7.105952694448670e-14,  -8.929907953677289e-16,   1.137414507901650e-17,  -1.477924176538444e-19,
   5.165049245135743e-02,  -3.490615317115407e-04,   3.538459110663341e-06,  -3.985497465056973e-08,   4.713487565957072e-10,  -5.733964418328653e-12,   7.106176015505889e-14,
  -8.930281137275928e-16,   1.137477708743293e-17,  -1.478038136374034e-19,   1.489561966359232e-03,  -1.006396957279836e-05,   1.019734103538475e-07,  -1.147846544011318e-09,
   1.356447202843712e-11,  -1.648748679687731e-13,   2.042714553156601e-15,  -2.574145767833997e-17,   3.327785456508113e-19,  -4.559226958226326e-21,   1.489576501265952e-03,
  -1.006446044514688e-05,   1.019850171011564e-07,  -1.148081826104193e-09,   1.356884830849641e-11,  -1.649521738341515e-13,   2.044050265035581e-15,  -2.576511679916255e-17,
   3.332455279087970e-19,  -4.570415942235681e-21,   1.489600363866245e-03,  -1.006526636433011e-05,   1.020040741617637e-07,  -1.148468159423045e-09,   1.357603474671857e-11,
  -1.650791352292898e-13,   2.046244405954683e-15,  -2.580399894754641e-17,   3.340136698603949e-19,  -4.588842616322103e-21,   1.489625685558669e-03,  -1.006612160580288e-05,
   1.020242988550480e-07,  -1.148878197263269e-09,   1.358366292249234e-11,  -1.652139208619820e-13,   2.048574401271919e-15,  -2.584531294020131e-17,   3.348307924367905e-19,
  -4.608474003863985e-21,   1.489645615043417e-03,  -1.006679475697690e-05,   1.020402184592872e-07,  -1.149200977655584e-09,   1.358966837191011e-11,  -1.653200484253656e-13,
   2.050409455556985e-15,  -2.587786865356218e-17,   3.354753714175576e-19,  -4.623981583315238e-21,   1.489657117211722e-03,  -1.006718327440337e-05,   1.020494070423814e-07,
  -1.149387291989031e-09,   1.359313505023218e-11,  -1.653813169983214e-13,   2.051469037322282e-15,  -2.589667381216039e-17,   3.358479729619975e-19,  -4.632954450722928e-21,
   1.489661436479694e-03,  -1.006732917198937e-05,   1.020528576486247e-07,  -1.149457260820593e-09,   1.359443697668853e-11,  -1.654043277915640e-13,   2.051867022206264e-15,
  -2.590373848122901e-17,   3.359880025816618e-19,  -4.636328232699531e-21,   1.489662152464901e-03,  -1.006735335688901e-05,   1.020534296466536e-07,  -1.149468859469678e-09,
   1.359465279777368e-11,  -1.654081423622587e-13,   2.051932999248306e-15,  -2.590490971725339e-17,   3.360112205155294e-19,  -4.636887716652063e-21,   2.320817677692388e-01,
  -1.487618724457792e-03,   1.430070583671906e-05,  -1.527246607530827e-07,   1.712297526469932e-09,  -1.974295497083428e-11,   2.318129393028331e-13,  -2.756567818334477e-15,
   3.308035998137206e-17,  -3.994190833848467e-19,   2.320838058105578e-01,  -1.487684025501699e-03,   1.430217068515233e-05,  -1.527528262891917e-07,   1.712793931136507e-09,
  -1.975122577001796e-11,   2.319453992437317e-13,  -2.758626425056495e-15,   3.311154566956282e-17,  -3.998788530115473e-19,   2.320871517364480e-01,  -1.487791236444485e-03,
   1.430457577785783e-05,  -1.527990730973649e-07,   1.713609064473788e-09,  -1.976480808052731e-11,   2.321629436698998e-13,  -2.762007667410368e-15,   3.316277227201233e-17,
  -4.006341261600466e-19,   2.320907022279800e-01,  -1.487905007381616e-03,   1.430712818432840e-05,  -1.528481561204701e-07,   1.714474262282529e-09,  -1.977922601868639e-11,
   2.323938974807386e-13,  -2.765597746832755e-15,   3.321716878296640e-17,  -4.014361912116206e-19,   2.320934966323234e-01,  -1.487994554281263e-03,   1.430913724377368e-05,
  -1.528867931077119e-07,   1.715155379090164e-09,  -1.979057739880553e-11,   2.325757479744077e-13,  -2.768424838701636e-15,   3.326000891268396e-17,  -4.020678999345187e-19,
   2.320951093973848e-01,  -1.488046236985479e-03,   1.431029683239702e-05,  -1.529090946324209e-07,   1.715548545744275e-09,  -1.979713026130867e-11,   2.326807329904458e-13,
  -2.770057082586394e-15,   3.328474473472978e-17,  -4.024326635567912e-19,   2.320957150179817e-01,  -1.488065645004591e-03,   1.431073229235324e-05,  -1.529174697125949e-07,
   1.715696199011769e-09,  -1.979959125888471e-11,   2.327201626268785e-13,  -2.770670133798050e-15,   3.329403554020498e-17,  -4.025696722493909e-19,   2.320958154088593e-01,
  -1.488068862195839e-03,   1.431080447728206e-05,  -1.529188580355603e-07,   1.715720675460440e-09,  -1.979999922200389e-11,   2.327266990079952e-13,  -2.770771762533238e-15,
   3.329557574334819e-17,  -4.025923853177175e-19,   5.030495800882167e-02,  -3.224492739708851e-04,   3.099754129295452e-06,  -3.310388992834025e-08,   3.711503735050040e-10,
  -4.279457903759002e-12,   5.025155874287020e-14,  -5.978012821848752e-16,   7.186485049574474e-18,  -8.734083958764227e-20,   5.030539976512987e-02,  -3.224634283230034e-04,
   3.100071643712287e-06,  -3.310999506223824e-08,   3.712579830808139e-10,  -4.281251609288590e-12,   5.028033910309151e-14,  -5.982516934636418e-16,   7.193466748406404e-18,
  -8.745084032749410e-20,   5.030612501238326e-02,  -3.224866668709116e-04,   3.100592961550221e-06,  -3.312001947587116e-08,   3.714346861022032e-10,  -4.284197242126836e-12,
   5.032760688041736e-14,  -5.989915253120001e-16,   7.204936919744029e-18,  -8.763162238353254e-20,   5.030689460032892e-02,  -3.225113273328881e-04,   3.101146210513483e-06,
  -3.313065866607439e-08,   3.716222421447030e-10,  -4.287324111727928e-12,   5.037778905599134e-14,  -5.997771001405139e-16,   7.217119336061508e-18,  -8.782371572768188e-20,
   5.030750030235043e-02,  -3.225307371046040e-04,   3.101581685852493e-06,  -3.313903358429155e-08,   3.717698935385066e-10,  -4.289785934619797e-12,   5.041730254870913e-14,
  -6.003957545797517e-16,   7.226715427353933e-18,  -8.797508976462577e-20,   5.030784987776541e-02,  -3.225419396084949e-04,   3.101833033444866e-06,  -3.314386764290099e-08,
   3.718551236079245e-10,  -4.291207085726793e-12,   5.044011452117754e-14,  -6.007529537702072e-16,   7.232256916163930e-18,  -8.806252919254708e-20,   5.030798114925471e-02,
  -3.225461464009420e-04,   3.101927421928838e-06,  -3.314568301788619e-08,   3.718871316666007e-10,  -4.291740814878984e-12,   5.044868214922243e-14,  -6.008871161778743e-16,
   7.234338442771028e-18,  -8.809537842081015e-20,   5.030800290951203e-02,  -3.225468437444353e-04,   3.101943068432979e-06,  -3.314598394955054e-08,   3.718924376356451e-10,
  -4.291829291965465e-12,   5.045010243564044e-14,  -6.009093571297831e-16,   7.234683519503024e-18,  -8.810082443453026e-20,   1.450855325058149e-03,  -9.299823826542905e-06,
   8.940063079385400e-08,  -9.547564501169956e-10,   1.070448319842093e-11,  -1.234300593587251e-13,   1.449705001588633e-15,  -1.726550416441644e-17,   2.085751407961886e-19,
  -2.581442189481169e-21,   1.450868065840585e-03,  -9.300232055303136e-06,   8.940978834790444e-08,  -9.549325377920801e-10,   1.070758768670700e-11,  -1.234818698235096e-13,
   1.450540657810838e-15,  -1.727883767978949e-17,   2.087947994788311e-19,  -2.585474789594155e-21,   1.450888982842333e-03,  -9.300902283340478e-06,   8.942482387449613e-08,
  -9.552216675979061e-10,   1.071268549856248e-11,  -1.235669539607485e-13,   1.451913157807862e-15,  -1.730074183874523e-17,   2.091558225489059e-19,  -2.592108526969529e-21,
   1.450911178682904e-03,  -9.301613521115777e-06,   8.944078033962191e-08,  -9.555285292461682e-10,   1.071809642731138e-11,  -1.236572740673094e-13,   1.453370350163630e-15,
  -1.732400430694073e-17,   2.095394649605931e-19,  -2.599165930832999e-21,   1.450928647856615e-03,  -9.302173322587990e-06,   8.945334005112839e-08,  -9.557700835376288e-10,
   1.072235612876399e-11,  -1.237283849060703e-13,   1.454517794132715e-15,  -1.734232682912507e-17,   2.098418065048240e-19,  -2.604733576166611e-21,   1.450938730031404e-03,
  -9.302496416454481e-06,   8.946058926380093e-08,  -9.559095103163651e-10,   1.072481499582803e-11,  -1.237694357666031e-13,   1.455180257560968e-15,  -1.735290706980054e-17,
   2.100164595681501e-19,  -2.607952170305449e-21,   1.450942516058805e-03,  -9.302617745476344e-06,   8.946331155844644e-08,  -9.559618704418860e-10,   1.072573842128478e-11,
  -1.237848529291514e-13,   1.455429066642397e-15,  -1.735688118177281e-17,   2.100820749143724e-19,  -2.609161806097412e-21,   1.450943143650759e-03,  -9.302637857712699e-06,
   8.946376282530511e-08,  -9.559705500923304e-10,   1.072589149735912e-11,  -1.237874086582850e-13,   1.455470312814151e-15,  -1.735754000715994e-17,   2.100929532537873e-19,
  -2.609362374481330e-21,   2.263491173727508e-01,  -1.380106284024921e-03,   1.262027242791880e-05,  -1.282087374900581e-07,   1.367387944690551e-09,  -1.499810013637014e-11,
   1.675268531832349e-13,  -1.895244635558736e-15,   2.164241309473986e-17,  -2.488306272038456e-19,   2.263509156822372e-01,  -1.380161094744129e-03,   1.262144199649110e-05,
  -1.282301289003070e-07,   1.367746578734359e-09,  -1.500378448658799e-11,   1.676134745212539e-13,  -1.896526459520759e-15,   2.166094291038491e-17,  -2.490928894787192e-19,
   2.263538680190160e-01,  -1.380251082025182e-03,   1.262336225430330e-05,  -1.282652522186615e-07,   1.368335468427426e-09,  -1.501311904107237e-11,   1.677557309336948e-13,
  -1.898631754270097e-15,   2.169137942715689e-17,  -2.495237099848687e-19,   2.263570008406093e-01,  -1.380346574476888e-03,   1.262540009764165e-05,  -1.283025287351752e-07,
   1.368960507893063e-09,  -1.502302749565253e-11,   1.679067486759841e-13,  -1.900866958034214e-15,   2.172369780178971e-17,  -2.499812171221290e-19,   2.263594665064852e-01,
  -1.380421734049215e-03,   1.262700410930802e-05,  -1.283318713149145e-07,   1.369452549037352e-09,  -1.503082823257988e-11,   1.680256530864125e-13,  -1.902627033707208e-15,
   2.174914910502227e-17,  -2.503415480377324e-19,   2.263608895381093e-01,  -1.380465112718329e-03,   1.262792990330408e-05,  -1.283488078029177e-07,   1.369736568447348e-09,
  -1.503533128546476e-11,   1.680942962599388e-13,  -1.903643192181451e-15,   2.176384419563374e-17,  -2.505496104844663e-19,   2.263614239096382e-01,  -1.380481402333327e-03,
   1.262827756469506e-05,  -1.283551680595169e-07,   1.369843230549560e-09,  -1.503702243361575e-11,   1.681200764456156e-13,  -1.904024842463454e-15,   2.176936360474060e-17,
  -2.506277605014068e-19,   2.263615124898430e-01,  -1.380484102596208e-03,   1.262833519541953e-05,  -1.283562223861392e-07,   1.369860911846765e-09,  -1.503730277655033e-11,
   1.681243500909897e-13,  -1.904088110294661e-15,   2.177027859209522e-17,  -2.506407160668844e-19,   4.906237553303450e-02,  -2.991453802728867e-04,   2.735511206120172e-06,
  -2.778992722877952e-08,   2.963887457748694e-10,  -3.250929700495796e-12,   3.631318994495981e-14,  -4.108575139140840e-16,   4.693993301518157e-18,  -5.407362053318756e-20,
   4.906276532618543e-02,  -2.991572607884906e-04,   2.735764716456194e-06,  -2.779456394886796e-08,   2.964664835811456e-10,  -3.252161984761197e-12,   3.633197793011910e-14,
  -4.111361165412492e-16,   4.698050488170461e-18,  -5.413239286816109e-20,   4.906340526089319e-02,  -2.991767660114188e-04,   2.736180942760659e-06,  -2.780217714489671e-08,
   2.965941318075271e-10,  -3.254185581695370e-12,   3.636283315729401e-14,  -4.115937060684175e-16,   4.704715047281332e-18,  -5.422895450429321e-20,   4.906408431664497e-02,
  -2.991974645094445e-04,   2.736622656367894e-06,  -2.781025706015607e-08,   2.967296159147075e-10,  -3.256333594076191e-12,   3.639558885799136e-14,  -4.120795406705389e-16,
   4.711792141734207e-18,  -5.433151909226000e-20,   4.906461876284472e-02,  -2.992137557474658e-04,   2.736970334606144e-06,  -2.781661724577626e-08,   2.968362712067896e-10,
  -3.258024684752387e-12,   3.642137929811667e-14,  -4.124621100340029e-16,   4.717365824778084e-18,  -5.441231424639313e-20,   4.906492721252199e-02,  -2.992231583052756e-04,
   2.737171005482218e-06,  -2.782028833436064e-08,   2.968978355234470e-10,  -3.259000884280170e-12,   3.643626808951515e-14,  -4.126829845097872e-16,   4.720584099720415e-18,
  -5.445897331987548e-20,   4.906504304039455e-02,  -2.992266891661772e-04,   2.737246362976747e-06,  -2.782166695935162e-08,   2.969209557032929e-10,  -3.259367501908373e-12,
   3.644185985293698e-14,  -4.127659413722721e-16,   4.721792895274723e-18,  -5.447650005533586e-20,   4.906506224062532e-02,  -2.992272744625536e-04,   2.737258854749254e-06,
  -2.782189549117451e-08,   2.969247883183529e-10,  -3.259428276401988e-12,   3.644278681388616e-14,  -4.127796935196975e-16,   4.721993286338949e-18,  -5.447940566812045e-20,
   1.415017756059861e-03,  -8.627711566646182e-06,   7.889542481857678e-08,  -8.014949275054265e-10,   8.548217375154792e-12,  -9.376163367086603e-14,   1.047383540714935e-15,
  -1.185385711607968e-17,   1.356115187973513e-19,  -1.570693161206258e-21,   1.415028998161966e-03,  -8.628054215011308e-06,   7.890273637054848e-08,  -8.016286575021475e-10,
   8.550459582866328e-12,  -9.379718786853007e-14,   1.047926399012968e-15,  -1.186195371802646e-17,   1.357318442210998e-19,  -1.572545880248568e-21,   1.415047454646664e-03,
  -8.628616769110488e-06,   7.891474085261325e-08,  -8.018482335657706e-10,   8.554141368710418e-12,  -9.385557336123007e-14,   1.048817936182682e-15,  -1.187525248939091e-17,
   1.359295258048984e-19,  -1.575591135057752e-21,   1.415067039429206e-03,  -8.629213738699935e-06,   7.892748042018692e-08,  -8.020812705355779e-10,   8.558049168642210e-12,
  -9.391754870540504e-14,   1.049764398434214e-15,  -1.188937288395332e-17,   1.361394825711674e-19,  -1.578827447928048e-21,   1.415082453498781e-03,  -8.629683597608082e-06,
   7.893750789133706e-08,  -8.022647079169667e-10,   8.561125453782220e-12,  -9.396634088266584e-14,   1.050509611423672e-15,  -1.190049249905604e-17,   1.363048656373843e-19,
  -1.581378116877513e-21,   1.415091349557520e-03,  -8.629954778689812e-06,   7.894329548806521e-08,  -8.023705876746743e-10,   8.562901169294377e-12,  -9.399450672135984e-14,
   1.050939825653724e-15,  -1.190691257027211e-17,   1.364003700309557e-19,  -1.582851633238843e-21,   1.415094690172324e-03,  -8.630056612967082e-06,   7.894546889159444e-08,
  -8.024103493095573e-10,   8.563568030736767e-12,  -9.400508458190416e-14,   1.051101401322520e-15,  -1.190932388593650e-17,   1.364362439636382e-19,  -1.583405232494546e-21,
   1.415095243930014e-03,  -8.630073493618897e-06,   7.894582916979440e-08,  -8.024169405138643e-10,   8.563678575869333e-12,  -9.400683808270951e-14,   1.051128186171401e-15,
  -1.190972362320156e-17,   1.364421911663730e-19,  -1.583497014233059e-21,   2.210213694372535e-01,  -1.284947656509264e-03,   1.120379958169632e-05,  -1.085285048897799e-07,
   1.103705974672240e-09,  -1.154354887602998e-11,   1.229520827219968e-13,  -1.326405783271694e-15,   1.444461541981751e-17,  -1.584139223847731e-19,   2.210229657183930e-01,
  -1.284994047881530e-03,   1.120474346576486e-05,  -1.085449657972999e-07,   1.103969116254126e-09,  -1.154752582189112e-11,   1.230098725511443e-13,  -1.327221442869454e-15,
   1.445586980857694e-17,  -1.585662916009273e-19,   2.210255863696333e-01,  -1.285070211916751e-03,   1.120629316688576e-05,  -1.085719931379108e-07,   1.104401195047774e-09,
  -1.155405638686178e-11,   1.231047763782184e-13,  -1.328561045484077e-15,   1.447435511369188e-17,  -1.588165801537473e-19,   2.210283672155489e-01,  -1.285151034762970e-03,
   1.120793774065943e-05,  -1.086006768043150e-07,   1.104859785438328e-09,  -1.156098822012453e-11,   1.232055208182963e-13,  -1.329983236103299e-15,   1.449398223858968e-17,
  -1.590823593782928e-19,   2.210305558517721e-01,  -1.285214647777323e-03,   1.120923218897765e-05,  -1.086232550335275e-07,   1.105220786401881e-09,  -1.156644534687769e-11,
   1.232848391958476e-13,  -1.331103064403852e-15,   1.450943815209551e-17,  -1.592916766062321e-19,   2.210318189949682e-01,  -1.285251362100140e-03,   1.120997930460507e-05,
  -1.086362869880119e-07,   1.105429162365615e-09,  -1.156959545811009e-11,   1.233306282031411e-13,  -1.331749562490289e-15,   1.451836177661629e-17,  -1.594125368553776e-19,
   2.210322933250638e-01,  -1.285265149073058e-03,   1.121025986608611e-05,  -1.086411809221521e-07,   1.105507416275267e-09,  -1.157077848790154e-11,   1.233478248543892e-13,
  -1.331992371161549e-15,   1.452171338863802e-17,  -1.594579322701887e-19,   2.210323719524498e-01,  -1.285267434481189e-03,   1.121030637380762e-05,  -1.086419921779114e-07,
   1.105520388332435e-09,  -1.157097459897134e-11,   1.233506755733542e-13,  -1.332032622401374e-15,   1.452226900335756e-17,  -1.594654578003411e-19,   4.790755782043204e-02,
  -2.785192414135259e-04,   2.428483173111937e-06,  -2.352413109040396e-08,   2.392341651607366e-10,  -2.502127639411875e-12,   2.665066519922349e-14,  -2.875147519213517e-16,
   3.131453421546709e-18,  -3.436155801387142e-20,   4.790790382286264e-02,  -2.785292969903990e-04,   2.428687765027208e-06,  -2.352769908279328e-08,   2.392912028386632e-10,
  -2.502989693380080e-12,   2.666319362222331e-14,  -2.876916854560836e-16,   3.133900182809734e-18,  -3.439493456413339e-20,   4.790847186296316e-02,  -2.785458059504439e-04,
   2.429023671025824e-06,  -2.353355740779709e-08,   2.393848587776702e-10,  -2.504405277291935e-12,   2.668376811565133e-14,  -2.879822743572443e-16,   3.137919046530227e-18,
  -3.444976338044886e-20,   4.790907462611191e-02,  -2.785633247325724e-04,   2.429380141179166e-06,  -2.353977475058534e-08,   2.394842612853443e-10,  -2.505907841652898e-12,
   2.670560884121096e-14,  -2.882907800634537e-16,   3.142186239663486e-18,  -3.450798969607416e-20,   4.790954902465876e-02,  -2.785771131920388e-04,   2.429660719769330e-06,
  -2.354466870624163e-08,   2.395625106409723e-10,  -2.507090744619295e-12,   2.672280455878513e-14,  -2.885336976763210e-16,   3.145546620956726e-18,  -3.455384940564829e-20,
   4.790982281766758e-02,  -2.785850712169363e-04,   2.429822661074047e-06,  -2.354749345423398e-08,   2.396076775158957e-10,  -2.507773572178430e-12,   2.673273133114464e-14,
  -2.886739391038796e-16,   3.147486796046616e-18,  -3.458033009802093e-20,   4.790992563123964e-02,  -2.785880596167031e-04,   2.429883474274358e-06,  -2.354855424144624e-08,
   2.396246395711077e-10,  -2.508030009285889e-12,   2.673645945984621e-14,  -2.887266104037118e-16,   3.148215508644931e-18,  -3.459027653837607e-20,   4.790994267414393e-02,
  -2.785885549910807e-04,   2.429893555071529e-06,  -2.354873008560580e-08,   2.396274513507609e-10,  -2.508072518914291e-12,   2.673707747834464e-14,  -2.887353419135781e-16,
   3.148336311501902e-18,  -3.459192544449125e-20,   1.381711428127688e-03,  -8.032828980351634e-06,   7.004036755617820e-08,  -6.784641714971012e-10,   6.899802023830429e-12,
  -7.216451856980302e-14,   7.686486974493729e-16,  -8.292999309799741e-18,   9.035500730950418e-20,  -9.929815601964199e-22,   1.381721407252803e-03,  -8.033118995257010e-06,
   7.004626823406003e-08,  -6.785670769196464e-10,   6.901447085587601e-12,  -7.218938359252870e-14,   7.690102044122330e-16,  -8.298113056232907e-18,   9.042616187458139e-20,
  -9.939724359228510e-22,   1.381737790210643e-03,  -8.033595133478262e-06,   7.005595616868459e-08,  -6.787360384399703e-10,   6.904148279328457e-12,  -7.223021461590726e-14,
   7.696038819255138e-16,  -8.306511777839292e-18,   9.054304018803649e-20,  -9.956004248541338e-22,   1.381755174622843e-03,  -8.034100396180472e-06,   7.006623719838675e-08,
  -6.789153544916811e-10,   6.907015214068996e-12,  -7.227355452951358e-14,   7.702340988173217e-16,  -8.315428473681240e-18,   9.066714767590925e-20,  -9.973296245002774e-22,
   1.381768856845957e-03,  -8.034498071900141e-06,   7.007432942377558e-08,  -6.790565023824163e-10,   6.909272056751195e-12,  -7.230767416363484e-14,   7.707302850309366e-16,
  -8.322449584661314e-18,   9.076488655232263e-20,  -9.986918026909283e-22,   1.381776753364735e-03,  -8.034727590889295e-06,   7.007900000658327e-08,  -6.791379716996176e-10,
   6.910574745297968e-12,  -7.232736963982542e-14,   7.710167248800513e-16,  -8.326503058674984e-18,   9.082131989730340e-20,  -9.994784597005031e-22,   1.381779718631474e-03,
  -8.034813779925209e-06,   7.008075393272679e-08,  -6.791685661493282e-10,   6.911063959484042e-12,  -7.233476631274724e-14,   7.711243012204679e-16,  -8.328025453297858e-18,
   9.084251615818356e-20,  -9.997739550901736e-22,   1.381780210169276e-03,  -8.034828067116802e-06,   7.008104467509224e-08,  -6.791736377181074e-10,   6.911145055936982e-12,
  -7.233599246072434e-14,   7.711421343474556e-16,  -8.328277826497999e-18,   9.084603000452812e-20,  -9.998229428451218e-22,   2.160529933679636e-01,  -1.200242983705067e-03,
   1.000028152528076e-05,  -9.256759833721533e-08,   8.995844184737723e-10,  -8.990965493137643e-12,   9.151381328205305e-14,  -9.434468258679463e-16,   9.818583591236870e-18,
  -1.029138495560549e-19,   2.160544180283798e-01,  -1.200282548144986e-03,   1.000105073978511e-05,  -9.258041702557956e-08,   8.997802314627712e-10,  -8.993793410007808e-12,
   9.155308153889832e-14,  -9.439764914012921e-16,   9.825569416649650e-18,  -1.030043223837696e-19,   2.160567569183913e-01,  -1.200347503539365e-03,   1.000231365091714e-05,
  -9.260146389002897e-08,   9.001017508476790e-10,  -8.998437039035720e-12,   9.161756688974229e-14,  -9.448463587534081e-16,   9.837043131832422e-18,  -1.031529303621622e-19,
   2.160592387693499e-01,  -1.200416431620075e-03,   1.000365386175660e-05,  -9.262380019952693e-08,   9.004429902430685e-10,  -9.003365846012118e-12,   9.168601822808596e-14,
  -9.457698116041033e-16,   9.849224907654819e-18,  -1.033107266700386e-19,   2.160611920772182e-01,  -1.200470682282601e-03,   1.000470873386500e-05,  -9.264138185990758e-08,
   9.007116071709646e-10,  -9.007245971127656e-12,   9.173990963413853e-14,  -9.464969044005967e-16,   9.858817300619002e-18,  -1.034349941513753e-19,   2.160623194007021e-01,
  -1.200501992964562e-03,   1.000531756894707e-05,  -9.265152972949453e-08,   9.008666552001936e-10,  -9.009485719518619e-12,   9.177101937469365e-14,  -9.469166564160264e-16,
   9.864355372010040e-18,  -1.035067438107277e-19,   2.160627427277999e-01,  -1.200513750732574e-03,   1.000554620160256e-05,  -9.265534057273744e-08,   9.009248818038152e-10,
  -9.010326852815648e-12,   9.178270289571360e-14,  -9.470743025293303e-16,   9.866435372521033e-18,  -1.035336926593440e-19,   2.160628129006381e-01,  -1.200515699766515e-03,
   1.000558410121409e-05,  -9.265597228601675e-08,   9.009345339356336e-10,  -9.010466287210469e-12,   9.178463968591185e-14,  -9.471004359511456e-16,   9.866780183463200e-18,
  -1.035381601405926e-19,   4.683063587201593e-02,  -2.601590528872248e-04,   2.167614229627321e-06,  -2.006451950086768e-08,   1.949897129452326e-10,  -1.948839946838479e-12,
   1.983613094948842e-14,  -2.044987018221143e-16,   2.128317610055800e-18,  -2.231138958675963e-20,   4.683094467474141e-02,  -2.601676286901052e-04,   2.167780960967492e-06,
  -2.006729802029947e-08,   1.950321565103273e-10,  -1.949452917975430e-12,   1.984464292821122e-14,  -2.046135331804541e-16,   2.129833112052236e-18,  -2.233106224283836e-20,
   4.683145164159607e-02,  -2.601817081174743e-04,   2.168054703680869e-06,  -2.007186004101931e-08,   1.951018476433057e-10,  -1.950459457713534e-12,   1.985862109070930e-14,
  -2.048021204300206e-16,   2.132322226671350e-18,  -2.236337651360716e-20,   4.683198959599669e-02,  -2.601966486457448e-04,   2.168345201517531e-06,  -2.007670155587448e-08,
   1.951758132001283e-10,  -1.951527811875632e-12,   1.987345894510100e-14,  -2.050023253162207e-16,   2.134964964379683e-18,  -2.239768950442764e-20,   4.683241298587020e-02,
  -2.602084077655235e-04,   2.168573850664721e-06,  -2.008051247504340e-08,   1.952340374295316e-10,  -1.952368856793881e-12,   1.988514071932052e-14,  -2.051599594952731e-16,
   2.137045968049781e-18,  -2.242471215857486e-20,   4.683265733923357e-02,  -2.602151945224474e-04,   2.168705818911109e-06,  -2.008271208019630e-08,   1.952676449618444e-10,
  -1.952854338324373e-12,   1.989188422573351e-14,  -2.052509620859443e-16,   2.138247419217098e-18,  -2.244031473998737e-20,   4.683274909763444e-02,  -2.602177430812292e-04,
   2.168755376256771e-06,  -2.008353810090599e-08,   1.952802659056846e-10,  -1.953036660004112e-12,   1.989441680575351e-14,  -2.052851399127708e-16,   2.138698663660777e-18,
  -2.244617504077886e-20,   4.683276430797048e-02,  -2.602181655447068e-04,   2.168763591199404e-06,  -2.008367502814705e-08,   1.952823580595485e-10,  -1.953066883410241e-12,
   1.989483663435807e-14,  -2.052908056642744e-16,   2.138773468507296e-18,  -2.244714654213633e-20,   1.350651707468326e-03,  -7.503299121530512e-06,   6.251659424848744e-08,
  -5.786848105287858e-10,   5.623737486510144e-12,  -5.620690771972649e-14,   5.720997556163623e-16,  -5.898111626549049e-18,   6.139009807510306e-20,  -6.438239757889999e-22,
   1.350660613709312e-03,  -7.503546457972718e-06,   6.252140298059274e-08,  -5.787649464024642e-10,   5.624961614345135e-12,  -5.622458694245113e-14,   5.723452807902120e-16,
  -5.901425360428442e-18,   6.143390921280464e-20,  -6.443963263952739e-22,   1.350675235241464e-03,  -7.503952525547078e-06,   6.252929804923150e-08,  -5.788965206189670e-10,
   5.626971597659730e-12,  -5.625361741640966e-14,   5.727484764885028e-16,  -5.906867514787344e-18,   6.150586713304899e-20,  -6.453365129752802e-22,   1.350690750491608e-03,
  -7.504383428304392e-06,   6.253767635575384e-08,  -5.790361557862445e-10,   5.629104861003562e-12,  -5.628443073845116e-14,   5.731764701180244e-16,  -5.912644948949930e-18,
   6.158226743552216e-20,  -6.463349131468775e-22,   1.350702961563381e-03,  -7.504722575424537e-06,   6.254427087178900e-08,  -5.791460673229320e-10,   5.630784123933052e-12,
  -5.630868804283291e-14,   5.735134278083374e-16,  -5.917193911765380e-18,   6.164242920617031e-20,  -6.471212315218931e-22,   1.350710009007462e-03,  -7.504918313635325e-06,
   6.254807699452289e-08,  -5.792095066068357e-10,   5.631753409139485e-12,  -5.632269023739470e-14,   5.737079425825481e-16,  -5.919820045952540e-18,   6.167716350902509e-20,
  -6.475752607737920e-22,   1.350712655429799e-03,  -7.504991817127734e-06,   6.254950628789569e-08,  -5.792333300472893e-10,   5.632117413677414e-12,  -5.632794873564215e-14,
   5.737809942482420e-16,  -5.920806344031468e-18,   6.169020918837802e-20,  -6.477457966797117e-22,   1.350713094114134e-03,  -7.505004001481198e-06,   6.254974321670831e-08,
  -5.792372791952188e-10,   5.632177754133124e-12,  -5.632882043521872e-14,   5.737931041051901e-16,  -5.920969845422277e-18,   6.169237183381633e-20,  -6.477740677375629e-22,
   2.114053191477811e-01,  -1.124452222364347e-03,   8.970259873157743e-06,  -7.950185205206320e-08,   7.397586645725281e-10,  -7.079275044793156e-12,   6.899345815614651e-14,
  -6.810551466761204e-16,   6.786774860412224e-18,  -6.811675884499634e-20,   2.114065969535650e-01,  -1.124486199113206e-03,   8.970892348130777e-06,  -7.951194361708960e-08,
   7.399062611707052e-10,  -7.081315950130893e-12,   6.902059268275721e-14,  -6.814055884187938e-16,   6.791200706201804e-18,  -6.817165836376241e-20,   2.114086947438144e-01,
  -1.124541980565034e-03,   8.971930749382693e-06,  -7.952851265638427e-08,   7.401486067951830e-10,  -7.084667184568582e-12,   6.906515116542395e-14,  -6.819810989059323e-16,
   6.798469560740197e-18,  -6.826183071074316e-20,   2.114109207501036e-01,  -1.124601173237280e-03,   8.973032697366418e-06,  -7.954609654507401e-08,   7.404058112199826e-10,
  -7.088224133795726e-12,   6.911244851429818e-14,  -6.825920368883480e-16,   6.806186608921389e-18,  -6.835757295364439e-20,   2.114126726929784e-01,  -1.124647761252058e-03,
   8.973900026011693e-06,  -7.955993722707635e-08,   7.406082737227632e-10,  -7.091024217819032e-12,   6.914968434580135e-14,  -6.830730488309787e-16,   6.812263031602963e-18,
  -6.843296781347053e-20,   2.114136837992172e-01,  -1.124674649337368e-03,   8.974400614329796e-06,  -7.956792578486068e-08,   7.407251353376454e-10,  -7.092640500276749e-12,
   6.917117891201718e-14,  -6.833507306398235e-16,   6.815771083077845e-18,  -6.847649779178098e-20,   2.114140634845310e-01,  -1.124684746313455e-03,   8.974588597025282e-06,
  -7.957092572455422e-08,   7.407690211637061e-10,  -7.093247486973895e-12,   6.917925128808654e-14,  -6.834550181216842e-16,   6.817088623659645e-18,  -6.849284715920759e-20,
   2.114141264230632e-01,  -1.124686420044043e-03,   8.974619758206766e-06,  -7.957142301577155e-08,   7.407762960325515e-10,  -7.093348106691309e-12,   6.918058945022997e-14,
  -6.834723060665630e-16,   6.817307037129843e-18,  -6.849555748172835e-20,   4.582322775577250e-02,  -2.437310021036095e-04,   1.944351555870045e-06,  -1.723244944575668e-08,
   1.603466272314522e-10,  -1.534470589211795e-12,   1.495470334781821e-14,  -1.476225941610155e-16,   1.471084430188083e-18,  -1.476540118238755e-20,   4.582350472697502e-02,
  -2.437383667447084e-04,   1.944488648186272e-06,  -1.723463684625818e-08,   1.603786195891535e-10,  -1.534912967167169e-12,   1.496058496475004e-14,  -1.476985583140685e-16,
   1.472043978618398e-18,  -1.477731180563263e-20,   4.582395943417338e-02,  -2.437504576711946e-04,   1.944713727183656e-06,  -1.723822827382931e-08,   1.604311493087806e-10,
  -1.535639366490384e-12,   1.497024335853061e-14,  -1.478233099488260e-16,   1.473619909530369e-18,  -1.479687507900272e-20,   4.582444193288054e-02,  -2.437632879978571e-04,
   1.944952580273344e-06,  -1.724203967541664e-08,   1.604868997535565e-10,  -1.536410355688150e-12,   1.498049542347614e-14,  -1.479557411453392e-16,   1.475293014335513e-18,
  -1.481764690014104e-20,   4.582482167582028e-02,  -2.437733861979461e-04,   1.945140578372860e-06,  -1.724503971700585e-08,   1.605307845919077e-10,  -1.537017290009475e-12,
   1.498856657759493e-14,  -1.480600087017463e-16,   1.476610423234177e-18,  -1.483400433971138e-20,   4.582504083847737e-02,  -2.437792143335036e-04,   1.945249083554786e-06,
  -1.724677127948171e-08,   1.605561149766263e-10,  -1.537367628534315e-12,   1.499322569111328e-14,  -1.481202009932971e-16,   1.477370992984762e-18,  -1.484344851098424e-20,
   4.582512313728933e-02,  -2.437814029067946e-04,   1.945289829804419e-06,  -1.724742153239895e-08,   1.605656274659052e-10,  -1.537499196394940e-12,   1.499497544112483e-14,
  -1.481428070954074e-16,   1.477656645025900e-18,  -1.484699564236261e-20,   4.582513677955107e-02,  -2.437817656968050e-04,   1.945296584156336e-06,  -1.724752932292070e-08,
   1.605672043329287e-10,  -1.537521006297924e-12,   1.499526549813233e-14,  -1.481465545544153e-16,   1.477703998606803e-18,  -1.484758366979321e-20,   1.321596849104931e-03,
  -7.029494432969862e-06,   5.607743094001296e-08,  -4.970045111405042e-10,   4.624589098343821e-12,  -4.425597658798374e-14,   4.313119059136469e-16,  -4.257633435010976e-18,
   4.242899831623444e-20,  -4.259091204699317e-22,   1.321604837286613e-03,  -7.029706838052554e-06,   5.608138484688780e-08,  -4.970675984012993e-10,   4.625511797064405e-12,
  -4.426873536595376e-14,   4.314815437856418e-16,  -4.259824648826772e-18,   4.245669037778217e-20,  -4.262534960124757e-22,   1.321617951587593e-03,  -7.030055554874682e-06,
   5.608787639520868e-08,  -4.971711794911836e-10,   4.627026818426404e-12,  -4.428968570461350e-14,   4.317601116822020e-16,  -4.263423158481935e-18,   4.250217107853227e-20,
  -4.268191429291525e-22,   1.321631867429020e-03,  -7.030425596884760e-06,   5.609476520487757e-08,  -4.972811048963118e-10,   4.628634729451364e-12,  -4.431192207646600e-14,
   4.320558023405315e-16,  -4.267243192274431e-18,   4.255045640317319e-20,  -4.274197442680185e-22,   1.321642819670869e-03,  -7.030716841087456e-06,   5.610018729561746e-08,
  -4.973676297034733e-10,   4.629900421879862e-12,  -4.432942688433338e-14,   4.322885910897010e-16,  -4.270250837011045e-18,   4.258847661056710e-20,  -4.278927149986508e-22,
   1.321649140584764e-03,  -7.030884931507401e-06,   5.610331671524300e-08,  -4.974175700476124e-10,   4.630630981168406e-12,  -4.433953112216229e-14,   4.324229695627931e-16,
  -4.271987112056474e-18,   4.261042659653675e-20,  -4.281657936968558e-22,   1.321651514181211e-03,  -7.030948052586163e-06,   5.610449188596765e-08,  -4.974363241237290e-10,
   4.630905332998897e-12,  -4.434332571761209e-14,   4.324734359768951e-16,  -4.272639195967621e-18,   4.261867050555837e-20,  -4.282683597819064e-22,   1.321651907640402e-03,
  -7.030958515885207e-06,   5.610468668958046e-08,  -4.974394329320038e-10,   4.630950811773373e-12,  -4.434395474478169e-14,   4.324818018219017e-16,  -4.272747293241134e-18,
   4.262003712909205e-20,  -4.282853627561890e-22  };
  static constexpr double wi[7980] = {  -7.649059010516494e-02,   1.138542336484112e-02,  -1.186855460961313e-03,   1.011610195470600e-04,  -7.493406820605894e-06,
   4.982556489668688e-07,  -3.039729729627499e-08,   1.724685159120200e-09,  -9.163362167922118e-11,   4.582632903527849e-12,  -2.164217627187105e-13,   9.656373747805961e-15,
  -4.066677737096898e-16,   1.611428338263017e-17,  -7.280736443322672e-02,   1.084094623231014e-02,  -1.130496987112310e-03,   9.639203569245960e-05,  -7.142780021389458e-06,
   4.751208104840285e-07,  -2.899674520193153e-08,   1.645812225241951e-09,  -8.747277190922681e-11,   4.375890708668608e-12,  -2.067115169304028e-13,   9.224957722134946e-15,
  -3.885481494027144e-16,   1.539670489914376e-17,  -6.578635320701735e-02,   9.801523255860676e-03,  -1.022743268041968e-03,   8.725976863412637e-05,  -6.470266144010887e-06,
   4.306728716746246e-07,  -2.630138911719558e-08,   1.493772505416382e-09,  -7.943949855233854e-11,   3.976164162577067e-12,  -1.879142172511266e-13,   8.389015539550472e-15,
  -3.534166565949516e-16,   1.400521053979997e-17,  -5.609342272964712e-02,   8.363559224472747e-03,  -8.733562799009512e-04,   7.457131763617214e-05,  -5.533758770663906e-06,
   3.686325265868449e-07,  -2.253042842029678e-08,   1.280578001677850e-09,  -6.815066767132154e-11,   3.413338335456009e-12,  -1.614028347437209e-13,   7.208485286553127e-15,
  -3.037622109610581e-16,   1.203811682826177e-17,  -4.466146742693983e-02,   6.663833678214833e-03,  -6.963729631621433e-04,   5.950384739966990e-05,  -4.418991485811492e-06,
   2.946005365543080e-07,  -1.801949716787334e-08,   1.024941162996492e-09,  -5.458385707569739e-11,   2.735550505105035e-12,  -1.294208323134179e-13,   5.782442195134592e-15,
  -2.437303011959415e-16,   9.659489740087522e-18,  -3.260639644672436e-02,   4.867940087149861e-03,  -5.090008670175813e-04,   4.351924775555110e-05,  -3.233885463311243e-06,
   2.157276234548003e-07,  -1.320330198349782e-08,   7.514417337178241e-10,  -4.004073345464771e-11,   2.007704281956602e-12,  -9.502572544702009e-14,   4.247049331039927e-15,
  -1.790488733713445e-16,   7.096285098327018e-18,  -2.111689581331374e-02,   3.153831579025402e-03,  -3.298986712791919e-04,   2.821726286731797e-05,  -2.097650376794584e-06,
   1.399886450161644e-07,  -8.571287266528501e-09,   4.880089423894530e-10,  -2.601317901019036e-11,   1.304770179533472e-12,  -6.177248349741318e-14,   2.761419296168475e-15,
  -1.164321348037505e-16,   4.614679323514285e-18,  -1.133092856414123e-02,   1.692618808485587e-03,  -1.770874874635425e-04,   1.514991511334001e-05,  -1.126466295300589e-06,
   7.519163269045509e-08,  -4.604826138894221e-09,   2.622295243357239e-10,  -1.398069222732853e-11,   7.013623335751666e-13,  -3.320967979343484e-14,   1.484733824126746e-15,
  -6.260626259085197e-17,   2.481366956450051e-18,  -4.216971378606950e-03,   6.299759669234232e-04,  -6.591478633215659e-05,   5.639437599566206e-06,  -4.193484441207247e-07,
   2.799356553336196e-08,  -1.714483905560045e-09,   9.764092530507806e-11,  -5.206037485418932e-12,   2.611839526209544e-13,  -1.236773045695711e-14,   5.529554211780075e-16,
  -2.331681590379661e-17,   9.241532927843998e-19,  -4.763473136683877e-04,   7.116259171425177e-05,  -7.445869290207941e-06,   6.370495513311645e-07,  -4.737152993691081e-08,
   3.162318796543767e-09,  -1.936804731201679e-10,   1.103034484756786e-11,  -5.881241143165715e-13,   2.950612790250514e-14,  -1.397201735275044e-15,   6.246860291407933e-17,
  -2.634162081242335e-18,   1.044040896134201e-19,  -2.888586804156236e-01,   8.393835262200135e-02,  -1.405710818662119e-02,   1.712387909986358e-03,  -1.663336021972035e-04,
   1.352938386113338e-05,  -9.499684625124654e-07,   5.880781253063238e-08,  -3.260733361971743e-09,   1.639514121248887e-10,  -7.549543535005079e-12,   3.208529135898060e-13,
  -1.265746889498538e-14,   4.646448609652592e-16,  -2.752716019413476e-01,   8.001623821117003e-02,  -1.340409881095303e-02,   1.633234803357847e-03,  -1.586773643115283e-04,
   1.290887224430079e-05,  -9.065352794788100e-07,   5.612655016823029e-08,  -3.112438041592698e-09,   1.565119957928018e-10,  -7.207659969797853e-12,   3.063460925402579e-13,
  -1.208575500603755e-14,   4.436612547987076e-16,  -2.492406401300971e-01,   7.249116702585401e-02,  -1.214962091530591e-02,   1.481010644457794e-03,  -1.439395717954864e-04,
   1.171347989968959e-05,  -8.228052255978981e-07,   5.095446947873294e-08,  -2.826221634499685e-09,   1.421463662972422e-10,  -6.547185051886954e-12,   2.783108264206439e-13,
  -1.098063510252864e-14,   4.030982875584432e-16,  -2.130485030074625e-01,   6.200768969103032e-02,  -1.039886704788924e-02,   1.268246262749817e-03,  -1.233141751762748e-04,
   1.003871351059893e-05,  -7.053865127358074e-07,   4.369528744127937e-08,  -2.424201006465757e-09,   1.219543968830984e-10,  -5.618274753374491e-12,   2.388621092230453e-13,
  -9.425132100905677e-15,   3.460010422102235e-16,  -1.700396619214592e-01,   4.952316758303055e-02,  -8.310039082134121e-03,   1.013993793168316e-03,  -9.863379110658302e-05,
   8.032387442259328e-06,  -5.645819143838823e-07,   3.498262283888959e-08,  -1.941299845177482e-09,   9.768259603668328e-11,  -4.500970502132252e-12,   1.913888295530872e-13,
  -7.552621366625540e-15,   2.772639573343872e-16,  -1.243843263046935e-01,   3.624580122246087e-02,  -6.084941619963378e-03,   7.427811865492480e-04,  -7.227640070943862e-05,
   5.887607050969069e-06,  -4.139309804954285e-07,   2.565357412318457e-08,  -1.423879522027332e-09,   7.165961658477465e-11,  -3.302404141336509e-12,   1.404408482493068e-13,
  -5.542517942215728e-15,   2.034731276223952e-16,  -8.065871401971700e-02,   2.351243196821670e-02,  -3.948487445771833e-03,   4.821128730291508e-04,  -4.692237455466642e-05,
   3.822993223113223e-06,  -2.688208585184083e-07,   1.666269137342859e-08,  -9.249676186368946e-10,   4.655627216170637e-11,  -2.145743612087597e-12,   9.125900211864448e-14,
  -3.601725935081755e-15,   1.322248977950562e-16,  -4.330851973910874e-02,   1.262695680641969e-02,  -2.120805643440278e-03,   2.589864337603790e-04,  -2.520909682662348e-05,
   2.054104200686633e-06,  -1.444501314192017e-07,   8.954307784998695e-09,  -4.970980900757489e-10,   2.502186027129904e-11,  -1.153298411572979e-12,   4.905206696664741e-14,
  -1.935990062272567e-15,   7.107338363689535e-17,  -1.612160342079075e-02,   4.700684496927386e-03,  -7.895638680835528e-04,   9.642366716116888e-05,  -9.386008886597709e-06,
   7.648224445926200e-07,  -5.378592288464505e-08,   3.334216451830001e-09,  -1.851031646562573e-10,   9.317519784075981e-12,  -4.294674291158930e-13,   1.826635995138922e-14,
  -7.209441021091409e-16,   2.646707217915153e-17,  -1.821155909164840e-03,   5.310120324654255e-04,  -8.919373096850034e-05,   1.089265928124617e-05,  -1.060312643454104e-06,
   8.640042928523754e-08,  -6.076113651405235e-09,   3.766628714057592e-10,  -2.091098301807236e-11,   1.052597546818456e-12,  -4.851695109911389e-14,   2.063555991005740e-15,
  -8.144537680363199e-17,   2.989997428411586e-18,  -3.253323202020326e-01,   1.227556693463072e-01,  -2.507516051060008e-02,   3.536966405079859e-03,  -3.826060510008688e-04,
   3.364637236859127e-05,  -2.496189457588836e-06,   1.602717828656364e-07,  -9.073009146583857e-09,   4.592885585089518e-10,  -2.102197637022021e-11,   8.778920641327289e-13,
  -3.370834331689331e-14,   1.197126358915630e-15,  -3.103579472920339e-01,   1.171200692529914e-01,  -2.392654142061134e-02,   3.375245843052366e-03,  -3.651387616813969e-04,
   3.211223446280106e-05,  -2.382491472474763e-06,   1.529777739173367e-07,  -8.660371434379872e-09,   4.384113469545049e-10,  -2.006682795451791e-11,   8.380207579973443e-13,
  -3.217814682096091e-14,   1.142820321490104e-15,  -2.815329004635510e-01,   1.062656004319441e-01,  -2.171315488094298e-02,   3.063484391365888e-03,  -3.314543879889052e-04,
   2.915293916126716e-05,  -2.163121913128156e-06,   1.389020461975258e-07,  -7.863959021076456e-09,   3.981125020093556e-10,  -1.822294760909117e-11,   7.610436982009872e-13,
  -2.922358097611647e-14,   1.037948184761374e-15,  -2.411920545917126e-01,   9.106278184393433e-02,  -1.861098229420209e-02,   2.626291329535501e-03,  -2.841958977951779e-04,
   2.499951862267134e-05,  -1.855135959305898e-06,   1.191352364494280e-07,  -6.745313879174722e-09,   3.414993987882842e-10,  -1.563226296500601e-11,   6.528761670141343e-13,
  -2.507124579110658e-14,   8.905304817483059e-16,  -1.929196644110131e-01,   7.285591192897925e-02,  -1.489319575608383e-02,   2.102032949391794e-03,  -2.274986720165931e-04,
   2.001455827534409e-05,  -1.485367537740933e-06,   9.539682759586013e-08,  -5.401621446989487e-09,   2.734855011119395e-10,  -1.251943303994263e-11,   5.228908583862310e-13,
  -2.008060467763638e-14,   7.133118203613012e-16,  -1.413669033439551e-01,   5.339794117539426e-02,  -1.091750780166342e-02,   1.541124199834909e-03,  -1.668125067805576e-04,
   1.467703883826682e-05,  -1.089334988006594e-06,   6.996645879881918e-08,  -3.961893057220600e-09,   2.005999582983659e-10,  -9.183241093851270e-12,   3.835627105136005e-13,
  -1.473054245443248e-14,   5.232935284048752e-16,  -9.177648671682620e-02,   3.467100505522688e-02,  -7.089496400992939e-03,   1.000853825268094e-03,  -1.083416864766777e-04,
   9.533086090396171e-06,  -7.075866152728308e-07,   4.544925358694818e-08,  -2.573679742597277e-09,   1.303149946616433e-10,  -5.965808126746456e-12,   2.491832886199272e-13,
  -9.570007066454330e-15,   3.399810738963917e-16,  -4.930702729693714e-02,   1.862831875870191e-02,  -3.809326611722914e-03,   5.378046498917067e-04,  -5.821928836902760e-05,
   5.122939225362732e-06,  -3.802569159778375e-07,   2.442495923077292e-08,  -1.383149820023050e-09,   7.003500332805256e-11,  -3.206232692050217e-12,   1.339212239563736e-13,
  -5.143377442864091e-15,   1.827254438629585e-16,  -1.835830246081570e-02,   6.935978467601331e-03,  -1.418375382833084e-03,   2.002510742531683e-04,  -2.167820127236887e-05,
   1.907570322825707e-06,  -1.415932614554012e-07,   9.094998703883596e-09,  -5.150396572282736e-10,   2.607886583938811e-11,  -1.193906512202122e-12,   4.986850421739203e-14,
  -1.915258027319140e-15,   6.804257752959896e-17,  -2.073888979282438e-03,   7.835421518976183e-04,  -1.602312517780051e-04,   2.262205517871171e-05,  -2.448958393283458e-06,
   2.154961488316146e-07,  -1.599566107138833e-08,   1.027454923878196e-09,  -5.818368551514677e-11,   2.946114287766137e-12,  -1.348750090087536e-13,   5.633622849916935e-15,
  -2.163660068757019e-16,   7.686753347808398e-18,  -4.437686110857850e-02,   5.270578144352065e-03,  -4.580035315546912e-04,   3.330194883999925e-05,  -2.143559021091318e-06,
   1.252078609218509e-07,  -6.736125977868288e-09,   3.410164106669947e-10,  -1.635957597351822e-11,   7.438750535325804e-13,  -3.227976379376677e-14,   1.341812817606866e-15,
  -5.344714148087138e-17,   2.032504846736708e-18,  -4.223254626102425e-02,   5.017258489273402e-03,  -4.361159352967979e-04,   3.172002288902362e-05,  -2.042352799142185e-06,
   1.193344501709637e-07,  -6.422350147934994e-09,   3.252408856946217e-10,  -1.560790527526735e-11,   7.099332990463208e-13,  -3.081682891826448e-14,   1.281371533746238e-15,
  -5.105165980844922e-17,   1.941808660407612e-18,  -3.814806662906657e-02,   4.534183903461277e-03,  -3.943255763905243e-04,   2.869571108471324e-05,  -1.848613270086253e-06,
   1.080751797646482e-07,  -5.819926676258252e-09,   2.949075479842377e-10,  -1.416043457241976e-11,   6.444726728727375e-13,  -2.799116886895695e-14,   1.164470963979556e-15,
  -4.641336200681317e-17,   1.766023135945563e-18,  -3.251509618364620e-02,   3.866895319016565e-03,  -3.364995979020767e-04,   2.450332897110420e-05,  -1.579552775075562e-06,
   9.240800200981418e-08,  -4.979879749116245e-09,   2.525209153643200e-10,  -1.213363004174804e-11,   5.526187898693719e-13,  -2.401807096672054e-14,   9.997943784827395e-16,
  -3.986949688154859e-17,   1.517685981938376e-18,  -2.587898032775941e-02,   3.079413274693642e-03,  -2.681319263081915e-04,   1.953705875732075e-05,  -1.260200624551990e-06,
   7.377368915136040e-08,  -3.978491265083487e-09,   2.018817333016415e-10,  -9.706958431553367e-12,   4.423995178212497e-13,  -1.924033773160830e-14,   8.013840467749603e-16,
  -3.197265232425115e-17,   1.217587837078711e-18,  -1.888812629175870e-02,   2.248566878871991e-03,  -1.958819643076355e-04,   1.427981326384402e-05,  -9.215554628359080e-07,
   5.397760435522795e-08,  -2.912579289135999e-09,   1.478759232045470e-10,  -7.114078667280532e-12,   3.244053753981803e-13,  -1.411610598003546e-14,   5.882303621285750e-16,
  -2.347749946652453e-17,   8.943706684008332e-19,  -1.223014123925752e-02,   1.456391017796673e-03,  -1.269124105981563e-04,   9.254985747148309e-06,  -5.974738865425442e-07,
   3.500765819153441e-08,  -1.889688858761638e-09,   9.597740379468156e-11,  -4.618969828064198e-12,   2.107032394007113e-13,  -9.171675604792971e-15,   3.823100835812291e-16,
  -1.526263837408728e-17,   5.815537864234518e-19,  -6.561806215397218e-03,   7.815134724454274e-04,  -6.811349263069335e-05,   4.967964928326199e-06,  -3.207714633819661e-07,
   1.879826902752084e-08,  -1.014912896487794e-09,   5.155716290347934e-11,  -2.481673171244151e-12,   1.132272601080859e-13,  -4.929531321840048e-15,   2.055140907276398e-16,
  -8.205622245520155e-18,   3.126944417824594e-19,  -2.441987359249808e-03,   2.908570822838790e-04,  -2.535133812567467e-05,   1.849149013965639e-06,  -1.194029001561952e-07,
   6.997842303892171e-09,  -3.778367260615619e-10,   1.919520591729962e-11,  -9.240085371428561e-13,   4.216094438296671e-14,  -1.835658075375623e-15,   7.653352497714952e-17,
  -3.055913926482384e-18,   1.164572588331860e-19,  -2.758443391246103e-04,   3.285519000731060e-05,  -2.863710589733979e-06,   2.088835396848401e-07,  -1.348811534221932e-08,
   7.905054229546773e-10,  -4.268246470594934e-11,   2.168415966315269e-12,  -1.043830996295903e-13,   4.762872623285995e-15,  -2.073741799222606e-16,   8.646063257631627e-18,
  -3.452318858590101e-19,   1.315645884646200e-20,  -9.218576897505740e-02,   2.306004846591763e-02,  -3.421241154863621e-03,   3.784466537279563e-04,  -3.400559020871338e-05,
   2.596128970989372e-06,  -1.730375460578749e-07,   1.025161513968034e-08,  -5.472312708987219e-10,   2.660457606095579e-11,  -1.188398907725473e-12,   4.914798284000316e-14,
  -1.894356440191095e-15,   6.834494408214424e-17,  -8.781274136580362e-02,   2.197367488079678e-02,  -3.261089911626131e-03,   3.608308517980941e-04,  -3.243049700882777e-05,
   2.476389986658569e-06,  -1.650857928217737e-07,   9.782013025436941e-09,  -5.222347225724204e-10,   2.539244278131101e-11,  -1.134383693830117e-12,   4.691912825071633e-14,
  -1.808623976362823e-15,   6.525713526167745e-17,  -7.944995263363556e-02,   1.989303499254835e-02,  -2.953940316354588e-03,   3.270044713511107e-04,  -2.940269580335529e-05,
   2.246001289816927e-06,  -1.497736223142474e-07,   8.877096895404974e-09,  -4.740367517618483e-10,   2.305390274342536e-11,  -1.030118322636352e-12,   4.261463505820582e-14,
  -1.642976943459147e-15,   5.928879401464016e-17,  -6.785242449637117e-02,   1.700157943289556e-02,  -2.526271915144205e-03,   2.798249734624246e-04,  -2.517334810568426e-05,
   1.923770916379844e-06,  -1.283337169502189e-07,   7.608819672292863e-09,  -4.064273458375257e-10,   1.977097488285971e-11,  -8.836403901042898e-13,   3.656330221794026e-14,
  -1.409961865142550e-15,   5.088879316841184e-17,  -5.410797060192665e-02,   1.356724754810106e-02,  -2.017267303291830e-03,   2.235712311292401e-04,  -2.012260135506692e-05,
   1.538436673458880e-06,  -1.026652817691596e-07,   6.088862634258232e-09,  -3.253284818534840e-10,   1.582982327652971e-11,  -7.076600797439503e-13,   2.928796845314581e-14,
  -1.129632529422805e-15,   4.077770666665207e-17,  -3.955253942848116e-02,   9.923192460651105e-03,  -1.476212271178671e-03,   1.636812386902867e-04,  -1.473800229409352e-05,
   1.127148234271680e-06,  -7.524031015857704e-08,   4.463466114968222e-09,  -2.385363574861553e-10,   1.160902620155824e-11,  -5.190694706226584e-13,   2.148651005596955e-14,
  -8.288627508752081e-16,   2.992435603711700e-17,  -2.563660412677398e-02,   6.434283966914069e-03,  -9.575169642430286e-04,   1.062005705104322e-04,  -9.564881359724036e-06,
   7.316759572934022e-07,  -4.885072613092633e-08,   2.898441410513263e-09,  -1.549210246106892e-10,   7.540653717314570e-12,  -3.372034827844898e-13,   1.395990127464305e-14,
  -5.385726835459167e-16,   1.944570411397429e-17,  -1.376195586598438e-02,   3.454644511476939e-03,  -5.141927825107925e-04,   5.703916517459670e-05,  -5.137878668910893e-06,
   3.930724916585441e-07,  -2.624625087911891e-08,   1.557390759397502e-09,  -8.324841350314276e-11,   4.052322774085555e-12,  -1.812234622148629e-13,   7.502919360338007e-15,
  -2.894778999303329e-16,   1.045234600750753e-17,  -5.122470086917176e-03,   1.285972491331531e-03,  -1.914171537063068e-04,   2.123495171324686e-05,  -1.912855283198235e-06,
   1.463484662096520e-07,  -9.772316820351330e-09,   5.798833751081648e-10,  -3.099776233329717e-11,   1.508928429222712e-12,  -6.748209226776732e-14,   2.793915588862037e-15,
  -1.077969479928126e-16,   3.892345977830592e-18,  -5.786456229258417e-04,   1.452678564621698e-04,  -2.162334703899516e-05,   2.398816509585303e-06,  -2.160882057923568e-07,
   1.653255061750423e-08,  -1.103955487374169e-09,   6.550835788186611e-11,  -3.501774645920738e-12,   1.704622097769176e-13,  -7.623414262366650e-15,   3.156281075850150e-16,
  -1.217783631876609e-17,   4.397199314451856e-19,  -6.582046698327368e-02,   2.357137725741681e-02,  -4.616045641036952e-03,   6.298413687602797e-04,  -6.633914132828838e-05,
   5.708336323519636e-06,  -4.159854331289456e-07,   2.631896030659958e-08,  -1.472218079047325e-09,   7.382064246093896e-11,  -3.353951222403688e-12,   1.392627299576733e-13,
  -5.321781784729204e-15,   1.880898876503124e-16,  -6.277425087822650e-02,   2.248439164802427e-02,  -4.403818812087248e-03,   6.009545614364903e-04,  -6.330269656013349e-05,
   5.447493530522174e-06,  -3.970035775863771e-07,   2.511940737015510e-08,  -1.405183146077562e-09,   7.046197733182306e-11,  -3.201447453161422e-12,   1.329333908688254e-13,
  -5.079998341673245e-15,   1.795470913397463e-16,  -5.691745276153466e-02,   2.039285343540132e-02,  -3.995189164020606e-03,   5.453048668867391e-04,  -5.745047307261555e-05,
   4.944578627030242e-06,  -3.603945078687487e-07,   2.280530751786701e-08,  -1.275835922680089e-09,   6.398014291341340e-11,  -2.907093071108918e-12,   1.207156013678713e-13,
  -4.613237087978204e-15,   1.630541603084543e-16,  -4.873441656877695e-02,   1.746740056619045e-02,  -3.423112869001892e-03,   4.673382109878053e-04,  -4.924635662142884e-05,
   4.239194307841104e-06,  -3.090250757449365e-07,   1.955703114035006e-08,  -1.094219104283879e-09,   5.487681397106156e-11,  -2.493614170360822e-12,   1.035508960283148e-13,
  -3.957416263402764e-15,   1.398786655044233e-16,  -3.895956351730363e-02,   1.396886331536381e-02,  -2.738312304110638e-03,   3.739360500599208e-04,  -3.941174186993343e-05,
   3.393171420892884e-06,  -2.473862423512315e-07,   1.565793027805417e-08,  -8.761463764121367e-10,   4.394345962251123e-11,  -1.996918249509346e-12,   8.292859446432715e-14,
  -3.169400647801955e-15,   1.120289050818551e-16,  -2.853623896061822e-02,   1.023452244657616e-02,  -2.006748193773274e-03,   2.740885051427235e-04,  -2.889266579831511e-05,
   2.487852528975295e-06,  -1.814019353246682e-07,   1.148260578634005e-08,  -6.425627661739345e-10,   3.222994269842516e-11,  -1.464691370315412e-12,   6.082830103547497e-14,
  -2.324826359007929e-15,   8.217771881773372e-17,  -1.852064972332661e-02,   6.643678886933985e-03,  -1.302872749349312e-03,   1.779733454902796e-04,  -1.876276514074321e-05,
   1.615739250557947e-06,  -1.178202230939905e-07,   7.458380199080162e-09,  -4.173891805244164e-10,   2.093642510521722e-11,  -9.514865014547781e-13,   3.951594942523701e-14,
  -1.510306718568857e-15,   5.338702429728390e-17,  -9.948782984835576e-03,   3.569144849637421e-03,  -6.999909443480937e-04,   9.562546893265503e-05,  -1.008181109699911e-05,
   8.682247381934114e-07,  -6.331356186281046e-08,   4.008065521935063e-09,  -2.243068454277000e-10,   1.125156051824493e-11,  -5.113517945270613e-13,   2.123708039508364e-14,
  -8.116926106904810e-16,   2.869232515753004e-17,  -3.704004661329115e-03,   1.328863203860746e-03,  -2.606277486162476e-04,   3.560505091857402e-05,  -3.753916607163620e-06,
   3.232845015325822e-07,  -2.357518159113653e-08,   1.492443047352478e-09,  -8.352362256830830e-11,   4.189697291254657e-12,  -1.904110182670094e-13,   7.908041192670657e-15,
  -3.022505582071311e-16,   1.068421238420897e-17,  -4.184282481817063e-04,   1.501177524352866e-04,  -2.944247764955185e-05,   4.022229693547443e-06,  -4.240735162798602e-07,
   3.652098418355017e-08,  -2.663259704833542e-09,   1.685997697144452e-10,  -9.435591734405784e-12,   4.733070303568446e-13,  -2.151061199004850e-14,   8.933669929597058e-16,
  -3.414509415847705e-17,   1.206990672070452e-18,  -2.872021050605614e-02,   2.767922239126408e-03,  -2.031197253357648e-04,   1.268412867140792e-05,  -7.085523591872823e-07,
   3.700475330959968e-08,  -1.768879187562817e-09,   7.884047879822487e-11,  -3.426988754968611e-12,   1.417092730149649e-13,  -5.569783456691592e-15,   2.137745529321405e-16,
  -7.762307652054506e-18,   2.755929979553175e-19,  -2.732947773434129e-02,   2.634442322694054e-03,  -1.933682632137671e-04,   1.207832379013373e-05,  -6.748880785950829e-07,
   3.525478013409974e-08,  -1.685736607553967e-09,   7.515977610366773e-11,  -3.267877815209781e-12,   1.351723314232238e-13,  -5.314404115899152e-15,   2.040293996803994e-16,
  -7.412022885766023e-18,   2.631991893238885e-19,  -2.468162114801638e-02,   2.380081327433659e-03,  -1.747679151828758e-04,   1.092150133369409e-05,  -6.105314970526048e-07,
   3.190596657940275e-08,  -1.526421704893517e-09,   6.809655547591671e-11,  -2.962179620735218e-12,   1.225951985541933e-13,  -4.822404036139894e-15,   1.852309440914331e-16,
  -6.734790052040130e-18,   2.392196373712032e-19,  -2.103225665370467e-02,   2.029076372885690e-03,  -1.490657781819601e-04,   9.320500704189706e-06,  -5.213235953884042e-07,
   2.725748562822989e-08,  -1.304869583507527e-09,   5.825391927107114e-11,  -2.535477494837520e-12,   1.050052714885571e-13,  -4.133052157124128e-15,   1.588457227783548e-16,
  -5.781292893246744e-18,   2.054233934473607e-19,  -1.673595668401610e-02,   1.615294864715394e-03,  -1.187229984862604e-04,   7.427276363409291e-06,  -4.156548253898391e-07,
   2.174299604116612e-08,  -1.041527365302978e-09,   4.652928763492371e-11,  -2.026289393569226e-12,   8.397162485028704e-14,  -3.307148138542306e-15,   1.271756923598720e-16,
  -4.633138056623631e-18,   1.646830668452800e-19,  -1.221275701901667e-02,   1.179144568746585e-03,  -8.669898207378028e-05,   5.426210581776883e-06,  -3.038009489590887e-07,
   1.589802793965546e-08,  -7.619239859648023e-10,   3.405701796335054e-11,  -1.483798513949486e-12,   6.152202331543643e-14,  -2.424163307968088e-15,   9.326299437750406e-17,
  -3.400298664550883e-18,   1.208958414401598e-19,  -7.906866208352327e-03,   7.635864636471030e-04,  -5.615823540620876e-05,   3.515767974756331e-06,  -1.968963461746277e-07,
   1.030629236807174e-08,  -4.940991442329794e-10,   2.209362107056826e-11,  -9.628589735502109e-13,   3.993616834319069e-14,  -1.574114684916788e-15,   6.057780725338960e-17,
  -2.209744956418009e-18,   7.858080748448367e-20,  -4.241990074222502e-03,   4.097086081656575e-04,  -3.013602227260387e-05,   1.886932634830664e-06,  -1.056909984505212e-07,
   5.532986620330915e-09,  -2.653045940007674e-10,   1.186529495074971e-11,  -5.171776053469043e-13,   2.145454609098789e-14,  -8.457859980494352e-16,   3.255398242420540e-17,
  -1.187806510812669e-18,   4.224363177000389e-20,  -1.578630084670930e-03,   1.524768037547403e-04,  -1.121589598403919e-05,   7.023063802289424e-07,  -3.933965475977606e-08,
   2.059548089334204e-09,  -9.876035953305205e-11,   4.417174936866539e-12,  -1.925433486962734e-13,   7.987935374729321e-15,  -3.149201656782266e-16,   1.212180270546969e-17,
  -4.423316711363846e-19,   1.573178287289909e-20,  -1.783197990662165e-04,   1.722367496946419e-05,  -1.266948862136452e-06,   7.933324980996074e-08,  -4.443884042944581e-09,
   2.326522453928416e-10,  -1.115634745883694e-11,   4.989860887410381e-13,  -2.175083675630265e-14,   9.023731814655522e-16,  -3.557591167538378e-17,   1.369387766162345e-18,
  -4.997047679622428e-20,   1.777238368324106e-21,  -3.517013603526727e-02,   7.457514756299694e-03,  -9.614036506143933e-04,   9.487406708043557e-05,  -7.759400377012778e-06,
   5.471967174824915e-07,  -3.418071875918300e-08,   1.919581602936574e-09,  -9.787858030994915e-11,   4.575819780886986e-12,  -1.975155547703603e-13,   7.913956009003224e-15,
  -2.962552772824340e-16,   1.039956999729045e-17,  -3.349012382257735e-02,   7.103560327696963e-03,  -9.160628496460519e-04,   9.042580677432390e-05,  -7.397542025389557e-06,
   5.218029035366269e-07,  -3.260118110992660e-08,   1.831200868739383e-09,  -9.338683192529081e-11,   4.366427687284706e-12,  -1.885002875007501e-13,   7.553605227805660e-15,
  -2.827955945840854e-16,   9.928179682878612e-18,  -3.028214728964073e-02,   6.426751258424286e-03,  -8.292454367602307e-04,   8.189757640894943e-05,  -6.702973916091928e-06,
   4.730087026518959e-07,  -2.956329235214696e-08,   1.661083046784976e-09,  -8.473475711228114e-11,   3.962840834777122e-12,  -1.711142493204820e-13,   6.858296362750819e-15,
  -2.568119952227754e-16,   9.017706112285063e-18,  -2.584263405387289e-02,   5.488303615574343e-03,  -7.086345307443453e-04,   7.002879725548545e-05,  -5.734769569320517e-06,
   4.048904233376057e-07,  -2.531687106839130e-08,   1.423023811104298e-09,  -7.261519751512947e-11,   3.397020754660733e-12,  -1.467204323115141e-13,   5.882017579356223e-15,
  -2.203040546274011e-16,   7.737558071545073e-18,  -2.059305172585662e-02,   4.376325039261799e-03,  -5.654278988353018e-04,   5.591000512536094e-05,  -4.581036891399367e-06,
   3.235921532026315e-07,  -2.024198233869403e-08,   1.138185955860171e-09,  -5.809900884087154e-11,   2.718696484025045e-12,  -1.174524499485540e-13,   4.709771272589869e-15,
  -1.764370466325704e-16,   6.198238049540969e-18,  -1.504467255201004e-02,   3.198916912898876e-03,  -4.135219763973645e-04,   4.090893843972160e-05,  -3.353367780293421e-06,
   2.369660308841246e-07,  -1.482817246180719e-08,   8.340163850694553e-10,  -4.258360903188110e-11,   1.993112213978349e-12,  -8.612325911397963e-14,   3.454140413100914e-15,
  -1.294211225369783e-16,   4.547380864476032e-18,  -9.747719908876958e-03,   2.073366211048412e-03,  -2.681156087655217e-04,   2.653251816704645e-05,  -2.175534025606755e-06,
   1.537741372526160e-07,  -9.624570147643934e-09,   5.414418254773852e-10,  -2.764990815145291e-11,   1.294336025777855e-12,  -5.593623863131136e-14,   2.243709630419176e-15,
  -8.407780337439498e-17,   2.954531545512976e-18,  -5.231636695056952e-03,   1.112984101985063e-03,  -1.439501904060888e-04,   1.424750360052758e-05,  -1.168395845180607e-06,
   8.259715962182932e-08,  -5.170262960820073e-09,   2.908880586448042e-10,  -1.485613080662986e-11,   6.954916040477201e-13,  -3.005851942202329e-14,   1.205781398847988e-15,
  -4.518649641308269e-17,   1.587969358547112e-18,  -1.947185033260333e-03,   4.142722957475810e-04,  -5.358411164818306e-05,   5.303797996896751e-06,  -4.349711000829428e-07,
   3.075074040976550e-08,  -1.924953766434084e-09,   1.083049856285070e-10,  -5.531481446142468e-12,   2.589637963676624e-13,  -1.119244566939524e-14,   4.489888829052636e-16,
  -1.682614023762274e-17,   5.913261049919653e-19,  -2.199559746993489e-04,   4.679708062088190e-05,  -6.053034748954076e-06,   5.991395372397169e-07,  -4.913658048530690e-08,
   3.473787813566864e-09,  -2.174556735363365e-10,   1.223492328227755e-11,  -6.248796101563269e-13,   2.925470735438318e-14,  -1.264396618333047e-15,   5.072189156426979e-17,
  -1.900840855926615e-18,   6.680204367843358e-20,  -1.484236849649809e-02,   4.925295809095952e-03,  -9.081581795493377e-04,   1.183415728861534e-04,  -1.202168877821131e-05,
   1.004702164899683e-06,  -7.148818765088868e-08,   4.434097492914984e-09,  -2.439521701237398e-10,   1.206537548405238e-11,  -5.420788429945721e-13,   2.231151501746293e-14,
  -8.470500497630015e-16,   2.979548947889236e-17,  -1.415070035711937e-02,   4.696873054414812e-03,  -8.662094319045441e-04,   1.128928177538816e-04,  -1.146962564994430e-05,
   9.586636792295428e-07,  -6.821830017295910e-08,   4.231591327333505e-09,  -2.328253460602016e-10,   1.151567217035978e-11,  -5.174041908217050e-13,   2.129667100354470e-14,
  -8.085430288294797e-16,   2.844151517867603e-17,  -1.282286990794509e-02,   4.257897307014916e-03,  -7.855224416188849e-04,   1.024049162138727e-04,  -1.040638895508802e-05,
   8.699543982819983e-07,  -6.191520537473085e-08,   3.841104796837230e-09,  -2.113636478574785e-10,   1.045513210511337e-11,  -4.697898215611952e-13,   1.933802112319578e-14,
  -7.342153597031275e-16,   2.582779616194333e-17,  -1.097151283744848e-02,   3.644954260061311e-03,  -6.727213888207792e-04,   8.772843869247541e-05,  -8.917343870582345e-06,
   7.456369977435827e-07,  -5.307718699625055e-08,   3.293321141930412e-09,  -1.812447522099907e-10,   8.966293924453466e-12,  -4.029277777714037e-13,   1.658699206043033e-14,
  -6.298006549669516e-16,   2.215563267087474e-17,  -8.764883281696730e-03,   2.913265659075515e-03,  -5.378942080389315e-04,   7.016815819419857e-05,  -7.134229036040369e-06,
   5.966658193571782e-07,  -4.248038484916547e-08,   2.636207580697525e-09,  -1.450995808706178e-10,   7.178939072313127e-12,  -3.226362910508113e-13,   1.328264243420811e-14,
  -5.043628702712182e-16,   1.774355736318993e-17,  -6.416365636595467e-03,   2.133488287691946e-03,  -3.940454328510567e-04,   5.141622578686837e-05,  -5.228737406964304e-06,
   4.373758716118572e-07,  -3.114394869526909e-08,   1.932933435068381e-09,  -1.064014792874214e-10,   5.264766060258477e-12,  -2.366263032029306e-13,   9.742243129019700e-15,
  -3.699441090980531e-16,   1.301508293886659e-17,  -4.162849088605109e-03,   1.384528782772499e-03,  -2.557700826485588e-04,   3.337924630411949e-05,  -3.394940745519340e-06,
   2.840133933792850e-07,  -2.022545042742059e-08,   1.255381396201903e-09,  -6.910914986121323e-11,   3.419727528612243e-12,  -1.537077728315706e-13,   6.328605201978004e-15,
  -2.403241068210410e-16,   8.455063333912067e-18,  -2.235751067007824e-03,   7.436888018500796e-04,  -1.373997707034428e-04,   1.793288416048886e-05,  -1.824047176051545e-06,
   1.526045938305133e-07,  -1.086795303066882e-08,   6.745944941644638e-10,  -3.713791847583668e-11,   1.837748524790687e-12,  -8.260395620773480e-14,   3.401115120177991e-15,
  -1.291566885398590e-16,   4.544026828818465e-18,  -8.323325082609051e-04,   2.768753502400204e-04,  -5.115586194869947e-05,   6.676864003176087e-06,  -6.791551095172504e-07,
   5.682103987166468e-08,  -4.046658376420412e-09,   2.511873039847706e-10,  -1.382858146440090e-11,   6.843062818025372e-13,  -3.075876688957261e-14,   1.266462379913732e-15,
  -4.809390385202531e-17,   1.692059245927484e-18,  -9.402467950434299e-05,   3.127752741780146e-05,  -5.778912526109007e-06,   7.542673434026643e-07,  -7.672261831415315e-08,
   6.418964813887748e-09,  -4.571445064877546e-10,   2.837629011620860e-11,  -1.562199107947216e-12,   7.730542515179688e-14,  -3.474793037214457e-15,   1.430713824901436e-16,
  -5.433139483863925e-18,   1.911510267181889e-19,  -2.014758024495301e-02,   1.603330270621570e-03,  -1.003587885541046e-04,   5.537270905509798e-06,  -2.626367802499993e-07,
   1.218518213133053e-08,  -5.549245722555003e-10,   2.123142922371264e-11,  -7.910453743100981e-13,   3.299028667226030e-14,  -1.103710885381179e-15,   3.504248838789465e-17,
  -1.594978896846837e-18,   4.261595922501396e-20,  -1.917064886041561e-02,   1.525844668195321e-03,  -9.552476470097103e-05,   5.271600206214894e-06,  -2.501120672212151e-07,
   1.160591478420893e-08,  -5.285999838036884e-10,   2.023443645297331e-11,  -7.540710341065444e-13,   3.144390990335803e-14,  -1.053177196731548e-15,   3.343976822994666e-17,
  -1.519304036515780e-18,   4.075937717810411e-20,  -1.731117588192341e-02,   1.378255164360488e-03,  -8.631067749500911e-05,   4.764780910962214e-06,  -2.261874429851806e-07,
   1.049865794889547e-08,  -4.782582484171527e-10,   1.832361653955445e-11,  -6.831369085693808e-13,   2.847907293232437e-14,  -9.557809838263021e-16,   3.035054607338513e-17,
  -1.374614252396168e-18,   3.713943456542793e-20,  -1.474942642524123e-02,   1.174721329750985e-03,  -7.359123213158146e-05,   4.064321896168435e-06,  -1.930613845468399e-07,
   8.964100590634266e-09,  -4.084447386617756e-10,   1.566553987087062e-11,  -5.843261233001400e-13,   2.435262073273907e-14,  -8.192484285198539e-16,   2.601906482972378e-17,
  -1.173990081638553e-18,   3.198599925096234e-20,  -1.173486235426797e-02,   9.349530900305036e-04,  -5.859125986994994e-05,   3.237225929018436e-06,  -1.538698064238673e-07,
   7.146718673752088e-09,  -3.257079635300896e-10,   1.250513072487039e-11,  -4.666665024556067e-13,   1.944347219352642e-14,  -6.555995109304918e-16,   2.082537606212333e-17,
  -9.362334678307495e-19,   2.571220804613131e-20,  -8.562318175505169e-03,   6.823791080911605e-04,  -4.277510163654594e-05,   2.364148056601607e-06,  -1.124280637553918e-07,
   5.223270859316299e-09,  -2.380898603904331e-10,   9.148714524386830e-12,  -3.415445176797412e-13,   1.422708130793331e-14,  -4.805885939142282e-16,   1.526859944321446e-17,
  -6.844241816959818e-19,   1.891538087517568e-20,  -5.543054002973087e-03,   4.418394047460718e-04,  -2.770196712280243e-05,   1.531401204090921e-06,  -7.285075133977069e-08,
   3.385147640345131e-09,  -1.543215754781115e-10,   5.933112185407864e-12,  -2.215551351334586e-13,   9.227527998996382e-15,  -3.120777024926126e-16,   9.916075778292697e-18,
  -4.436437127294318e-19,   1.231135098823060e-20,  -2.973702067366993e-03,   2.370578692551734e-04,  -1.486421773710338e-05,   8.218055754108964e-07,  -3.910106126562421e-08,
   1.817067486345703e-09,  -8.284115114527797e-11,   3.185835873450830e-12,  -1.189817413991693e-13,   4.955079270858922e-15,  -1.676847604294651e-16,   5.328418354436073e-18,
  -2.381590394226551e-19,   6.622861570834701e-21,  -1.106629631068209e-03,   8.822134835513748e-05,  -5.531919151241534e-06,   3.058579551696701e-07,  -1.455342237892595e-08,
   6.763339699748268e-10,  -3.083509788611359e-11,   1.185945718196195e-12,  -4.429368630334837e-14,   1.844592960046463e-15,  -6.243610219383107e-17,   1.984039508637741e-18,
  -8.864844126434605e-20,   2.466972209202412e-21,  -1.250030332427575e-04,   9.965388742198492e-06,  -6.248829445149977e-07,   3.454978223379843e-08,  -1.643973360623934e-09,
   7.639993589977196e-11,  -3.483201210901823e-12,   1.339691305113000e-13,  -5.003627170099432e-15,   2.083731844568535e-16,  -7.053289240116075e-18,   2.241340266524167e-19,
  -1.001394290618282e-20,   2.787071566343219e-22,  -1.567369135480161e-02,   2.822146795634067e-03,  -3.130619446017496e-04,   2.713276243314169e-05,  -2.003633912149543e-06,
   1.287746750718218e-07,  -7.404374776902813e-09,   3.903889948956951e-10,  -1.886265222270755e-11,   8.376258811124460e-13,  -3.480023907163983e-14,   1.350746955753158e-15,
  -4.859944097609201e-17,   1.663277551259301e-18,  -1.492116326052408e-02,   2.687371635866481e-03,  -2.982001439295221e-04,   2.585206454388986e-05,  -1.909539758181679e-06,
   1.227590709973247e-07,  -7.060197514111279e-09,   3.723123396811582e-10,  -1.799251931466152e-11,   7.991299672161832e-13,  -3.320458079197941e-14,   1.288973434584574e-15,
  -4.638517190158193e-17,   1.587513837392873e-18,  -1.348578442095270e-02,   2.430004982354260e-03,  -2.697835612381546e-04,   2.340026550684433e-05,  -1.729205099684686e-06,
   1.112166990268894e-07,  -6.399096297359031e-09,   3.375611980021193e-10,  -1.631836407872054e-11,   7.250023208402680e-13,  -3.013042980717169e-14,   1.169893737504709e-15,
  -4.211321321918704e-17,   1.441339252293927e-18,  -1.150241165064921e-02,   2.073808748966928e-03,  -2.303841619075192e-04,   1.999498056453437e-05,  -1.478354882998298e-06,
   9.513528385581389e-08,  -5.476633086440241e-09,   2.890148799107173e-10,  -1.397694475987592e-11,   6.212126288778024e-13,  -2.582314738811794e-14,   1.002915722128030e-15,
  -3.611607233256437e-17,   1.236121718285276e-18,  -9.160990083859337e-03,   1.652584368712649e-03,  -1.837023639531204e-04,   1.595284059826580e-05,  -1.180104464916511e-06,
   7.598275575987548e-08,  -4.376259860213881e-09,   2.310344184626185e-10,  -1.117714637881425e-11,   4.969566793745502e-13,  -2.066270361711183e-14,   8.026983610134050e-16,
  -2.891654905513998e-17,   9.897400645400918e-19,  -6.689888103426280e-03,   1.207353575771131e-03,  -1.342766702403809e-04,   1.166618521458872e-05,  -8.633600827799880e-07,
   5.561252827306314e-08,  -3.204307234334318e-09,   1.692161648765793e-10,  -8.188911652633625e-12,   3.642014882867555e-13,  -1.514573962388684e-14,   5.884962283550676e-16,
  -2.120626265697944e-17,   7.258570450292493e-19,  -4.333277892684811e-03,   7.822769977586326e-04,  -8.702992002740980e-05,   7.563663543488794e-06,  -5.599052114671491e-07,
   3.607595884516653e-08,  -2.079187810677940e-09,   1.098221209556002e-10,  -5.315692304837395e-12,   2.364610466836465e-13,  -9.834703213719501e-15,   3.821838086538904e-16,
  -1.377449822715625e-17,   4.714887647374023e-19,  -2.325348845648376e-03,   4.198537704311411e-04,  -4.671742883691861e-05,   4.060803641283913e-06,  -3.006460236211401e-07,
   1.937411027465842e-08,  -1.116750689769484e-09,   5.899261833135720e-11,  -2.855693459148652e-12,   1.270441091092892e-13,  -5.284249481904150e-15,   2.053638250445218e-16,
  -7.402355879272239e-18,   2.533786912007789e-19,  -8.654377722116853e-04,   1.562675245303699e-04,  -1.738901402675495e-05,   1.511583616502982e-06,  -1.119172245292081e-07,
   7.212488356098174e-09,  -4.157573904060833e-10,   2.196327959480891e-11,  -1.063227921056858e-12,   4.730252567921608e-14,  -1.967535379202640e-15,   7.646689781472684e-17,
  -2.756349359979741e-18,   9.434871806727677e-20,  -9.775993616512160e-05,   1.765214296868554e-05,  -1.964299400222286e-06,   1.707531546656824e-07,  -1.264261369429617e-08,
   8.147578146385058e-10,  -4.696632970639942e-11,   2.481111814692489e-12,  -1.201096611362445e-13,   5.343653390594475e-15,  -2.222685407380391e-16,   8.638345133724922e-18,
  -3.113821306505088e-19,   1.065849005856814e-20,  -3.848100026047424e-03,   1.151355387341156e-03,  -1.950338537496654e-04,   2.384388805004928e-05,  -2.307148187380115e-06,
   1.854284499623116e-07,  -1.278364158954570e-08,   7.727707381349324e-10,  -4.159988154344777e-11,   2.019851393482097e-12,  -8.937109541278786e-14,   3.630379009243711e-15,
  -1.363417149787782e-16,   4.760061499216492e-18,  -3.667351652464445e-03,   1.097588510602608e-03,  -1.859731698212032e-04,   2.274075965836508e-05,  -2.200764173546606e-06,
   1.769020223764385e-07,  -1.219717011001782e-08,   7.373864352141524e-10,  -3.969824653112643e-11,   1.927649635715566e-12,  -8.529637397111525e-14,   3.465040124942313e-15,
  -1.301377035575304e-16,   4.543587506440060e-18,  -3.320956268383221e-03,   9.944166202178837e-04,  -1.685671391435020e-04,   2.061966912436695e-05,  -1.996059820686153e-06,
   1.604854056640687e-07,  -1.106741834363883e-08,   6.691949697428995e-10,  -3.603212940750269e-11,   1.749840511957590e-12,  -7.743628752973290e-14,   3.146025817612913e-15,
  -1.181650202842682e-16,   4.125776230219779e-18,  -2.839139839486726e-03,   8.506580896887962e-04,  -1.442756414469074e-04,   1.765579689108418e-05,  -1.709730298205617e-06,
   1.375033134861274e-07,  -9.484743588088347e-09,   5.736096681985640e-10,  -3.089065864841981e-11,   1.500368542988750e-12,  -6.640433097954400e-14,   2.698126321391834e-15,
  -1.013507897184920e-16,   3.538906323700953e-18,  -2.266315507120203e-03,   6.794274636657245e-04,  -1.152940096129120e-04,   1.411498200705643e-05,  -1.367300503926001e-06,
   1.099939596696758e-07,  -7.588909926373495e-09,   4.590413969187705e-10,  -2.472483644817896e-11,   1.201058808790198e-12,  -5.316346471950154e-14,   2.160356981917868e-15,
  -8.115723422215611e-17,   2.833958253533236e-18,  -1.658003368689487e-03,   4.972931920292841e-04,  -8.442231935559848e-05,   1.033890848542633e-05,  -1.001782199534283e-06,
   8.060719813591891e-08,  -5.562410688895625e-09,   3.365122635068663e-10,  -1.812755608224382e-11,   8.806802012961036e-13,  -3.898591499296136e-14,   1.584371757634540e-15,
  -5.952348333071824e-17,   2.078614646961361e-18,  -1.075235827454883e-03,   3.226009017188820e-04,  -5.478096714050662e-05,   6.710298728315121e-06,  -6.503036566018968e-07,
   5.233348942329436e-08,  -3.611775176584064e-09,   2.185252371663303e-10,  -1.177273416151765e-11,   5.719894153193129e-13,  -2.532235767860848e-14,   1.029148177928480e-15,
  -3.866594132928792e-17,   1.350289883597483e-18,  -5.773544622143918e-04,   1.732500948074032e-04,  -2.942380212788159e-05,   3.604620252382182e-06,  -3.493595904141055e-07,
   2.811696512695159e-08,  -1.940599864391998e-09,   1.174191533734557e-10,  -6.326067628642033e-12,   3.073694611868662e-13,  -1.360788134663180e-14,   5.530657751854214e-16,
  -2.077961118803957e-17,   7.256753794432331e-19,  -2.149231744452153e-04,   6.449681046678353e-05,  -1.095430505363382e-05,   1.342030692574014e-06,  -1.300735806210422e-07,
   1.046878042465247e-08,  -7.225582650484158e-10,   4.372033591877911e-11,  -2.355510440377969e-12,   1.144504651351299e-13,  -5.067014022043228e-15,   2.059409546725562e-16,
  -7.737609630594515e-18,   2.702178674019676e-19,  -2.427856783087920e-05,   7.285877581851379e-06,  -1.237461907680367e-06,   1.516045152533022e-07,  -1.469403007154154e-08,
   1.182632201415351e-09,  -8.162589311616220e-11,   4.939008570574333e-12,  -2.660984711190627e-13,   1.292932353234750e-14,  -5.724151241263792e-16,   2.326496506655996e-17,
  -8.741119298351434e-19,   3.052633424425917e-20,  -1.500049999646438e-02,   1.009467333501447e-03,  -5.297255925493261e-05,   2.723265946056134e-06,  -1.150178544519055e-07,
   3.987333905339148e-09,  -1.848747539182269e-10,   8.374713068326216e-12,  -1.762792443364239e-13,   4.679298374271875e-15,  -4.981279306106136e-16,   9.397003664767280e-18,
   4.712890691237129e-19,   2.549284415099496e-20,  -1.427247612545691e-02,   9.606117063851001e-04,  -5.041667645188263e-05,   2.592006992645926e-06,  -1.095063706655733e-07,
   3.798641431426105e-09,  -1.760328969616546e-10,   7.972482410951803e-12,  -1.683643505525624e-13,   4.467590579667063e-15,  -4.730268072319568e-16,   8.995783828004499e-18,
   4.436173340828878e-19,   2.400863163807821e-20,  -1.288704081084223e-02,   8.675832746623468e-04,  -4.554669768611172e-05,   2.341851420635026e-06,  -9.898925659939277e-08,
   3.437596567972500e-09,  -1.591542673390255e-10,   7.205338112761063e-12,  -1.530397631227213e-13,   4.058560876441623e-15,  -4.256488616497088e-16,   8.209166182883103e-18,
   3.929348200603077e-19,   2.128949486264043e-20,  -1.097888837073966e-02,   7.393475364141993e-04,  -3.882743802537757e-05,   1.996596953527253e-06,  -8.444835465420787e-08,
   2.936525723783491e-09,  -1.358049354543119e-10,   6.145444335100142e-12,  -1.314261576935937e-13,   3.483169860635248e-15,  -3.611381363260106e-16,   7.081755783322885e-18,
   3.269397409856074e-19,   1.774387288344792e-20,  -8.734118771546695e-03,   5.883527210538457e-04,  -3.090779729413137e-05,   1.589526568647379e-06,  -6.727164440514682e-08,
   2.342239917455928e-09,  -1.082057641284651e-10,   4.894351333993629e-12,  -1.053604998506628e-13,   2.790861443845067e-15,  -2.861672919929257e-16,   5.700922811782815e-18,
   2.540881696014798e-19,   1.381790730070948e-20,  -6.372333469885486e-03,   4.293590322573809e-04,  -2.256128529300637e-05,   1.160386040950460e-06,  -4.913359339987937e-08,
   1.712477028565485e-09,  -7.904500841944785e-11,   3.574073032714473e-12,  -7.734264816458604e-14,   2.047935615582593e-15,  -2.081281866331018e-16,   4.198316087606862e-18,
   1.818669714265267e-19,   9.909243335450346e-21,  -4.125093496225330e-03,   2.779868471753135e-04,  -1.460972768286828e-05,   7.514612597954461e-07,  -3.182895219528892e-08,
   1.110102528368896e-09,  -5.121184494264253e-11,   2.315028392316849e-12,  -5.026910356203000e-14,   1.330767068654333e-15,  -1.344522295346965e-16,   2.734278536988876e-18,
   1.162326761599303e-19,   6.341979027625851e-21,  -2.212944962449047e-03,   1.491406941227813e-04,  -7.838850215618481e-06,   4.032089185025602e-07,  -1.708116765202257e-08,
   5.959493049383109e-10,  -2.748480738756621e-11,   1.242297532535173e-12,  -2.702286095744686e-14,   7.152967285413320e-16,  -7.205190179434677e-17,   1.471356728311394e-18,
   6.194228238322798e-20,   3.382336086255870e-21,  -8.235148592621491e-04,   5.550207272134609e-05,  -2.917284272228025e-06,   1.500586877036159e-07,  -6.357311731224650e-09,
   2.218287301569446e-10,  -1.022958731121954e-11,   4.623518431406847e-13,  -1.006334852882589e-14,   2.663679502530171e-16,  -2.680320245441359e-17,   5.481286974035767e-19,
   2.299761571125839e-20,   1.256120968456426e-21,  -9.302272548609818e-05,   6.269440144336104e-06,  -3.295341488864083e-07,   1.695054064043753e-08,  -7.181247170229743e-10,
   2.505835129313299e-11,  -1.155542663401086e-12,   5.222729547888549e-14,  -1.136866204006650e-15,   3.009167648487304e-17,  -3.027464062254459e-18,   6.192608842302195e-20,
   2.596813430605421e-21,   1.418431780350782e-22,  -7.904613608452838e-03,   1.222513715728103e-03,  -1.182776142932344e-04,   8.793809533172026e-06,  -5.815708333384214e-07,
   3.455942578149352e-08,  -1.791425328853225e-09,   8.559331986670229e-11,  -3.982461571229430e-12,   1.689859719765493e-13,  -6.332812321590588e-15,   2.402125962356894e-16,
  -9.164823485479668e-18,   2.695881840353672e-19,  -7.523802627231476e-03,   1.163854629149670e-03,  -1.126302785163343e-04,   8.376517488121525e-06,  -5.540948267939631e-07,
   3.293274929132445e-08,  -1.707654484889345e-09,   8.161364668068507e-11,  -3.797374740215410e-12,   1.611653813290354e-13,  -6.042989954463167e-15,   2.291677711453816e-16,
  -8.739056330535237e-18,   2.575075224647036e-19,  -6.797969267145108e-03,   1.051952809660715e-03,  -1.018456407863393e-04,   7.578559638797137e-06,  -5.015045186020562e-07,
   2.981671560279241e-08,  -1.546955401482136e-09,   7.396982826445969e-11,  -3.441848618397261e-12,   1.461290545763080e-13,  -5.484369962595994e-15,   2.079027888130688e-16,
  -7.921200498146620e-18,   2.341088370157323e-19,  -5.796055985832213e-03,   8.973005330302963e-04,  -8.691873727723966e-05,   6.472057897905012e-06,  -4.284824450496811e-07,
   2.548522119055776e-08,  -1.323130169877758e-09,   6.330488873294369e-11,  -2.945747310646523e-12,   1.251203429336034e-13,  -4.701199791755430e-15,   1.781334993164014e-16,
  -6.779876985988171e-18,   2.010895793132484e-19,  -4.614571530684677e-03,   7.146929957913054e-04,  -6.926557181206404e-05,   5.160863204480301e-06,  -3.418293471606871e-07,
   2.033901908389228e-08,  -1.056648106386846e-09,   5.058414200135568e-11,  -2.353934052994894e-12,   1.000246863675430e-13,  -3.762347042156525e-15,   1.424989175037166e-16,
  -5.418164741037053e-18,   1.612435500728773e-19,  -3.368861667268830e-03,   5.219375867412584e-04,  -5.060524321402656e-05,   3.772440304131098e-06,  -2.499582194379730e-07,
   1.487719716864970e-08,  -7.733055524823832e-10,   3.703695606276350e-11,  -1.723588095096353e-12,   7.326399472843215e-14,  -2.758149195334331e-15,   1.044303751076783e-16,
  -3.967533445581249e-18,   1.183873551854830e-19,  -2.181717379528918e-03,   3.380891133599108e-04,  -3.278886445203097e-05,   2.445117382673407e-06,  -1.620500347633811e-07,
   9.646964469264027e-09,  -5.016166841024820e-10,   2.403189622311548e-11,  -1.118404065875489e-12,   4.755000435552969e-14,  -1.791117164580124e-15,   6.780168006048476e-17,
  -2.574583351540325e-18,   7.695614339296714e-20,  -1.170651854947228e-03,   1.814305516240837e-04,  -1.759812169615090e-05,   1.312546875801191e-06,  -8.699971222363075e-08,
   5.179698327936717e-09,  -2.693787370799241e-10,   1.290764505905667e-11,  -6.007091613719237e-13,   2.554256717926941e-14,  -9.624183271552564e-16,   3.642784462900555e-17,
  -1.382878015811816e-18,   4.137164108004326e-20,  -4.356731177350169e-04,   6.752441319970209e-05,  -6.549947824201577e-06,   4.885539187923579e-07,  -3.238427209086392e-08,
   1.928130768888847e-09,  -1.002818417245665e-10,   4.805399815612144e-12,  -2.236397848366458e-13,   9.509686401966747e-15,  -3.583515343548010e-16,   1.356321532997039e-17,
  -5.148405414630342e-19,   1.540721750636697e-20,  -4.921341357508888e-05,   7.627571809180457e-06,  -7.398891844679804e-07,   5.518810598558862e-08,  -3.658222249181400e-09,
   2.178085493523588e-10,  -1.132830719848167e-11,   5.428451671499196e-13,  -2.526363741074107e-14,   1.074275522891424e-15,  -4.048234752171567e-17,   1.532203715748149e-18,
  -5.815943783307877e-20,   1.740574798234755e-21,  -1.167606724098542e-03,   3.095149786853236e-04,  -4.693819179104155e-05,   5.246608421057606e-06,  -4.762665266336210e-07,
   3.640299294674571e-08,  -2.403022364347050e-09,   1.404351718588184e-10,  -7.367854412994279e-12,   3.489479589429626e-13,  -1.510222699762842e-14,   6.058254042211840e-16,
  -2.243173706532262e-17,   7.643008586451419e-19,  -1.112338309181289e-03,   2.949493298495476e-04,  -4.474273931290466e-05,   5.002509879378838e-06,  -4.541963802958861e-07,
   3.472181422467260e-08,  -2.292390022887802e-09,   1.339847863458256e-10,  -7.030051056876173e-12,   3.329830207511622e-13,  -1.441243351708006e-14,   5.781638108043954e-16,
  -2.140928454516587e-17,   7.295850420829797e-19,  -1.006595973926895e-03,   2.670463992920229e-04,  -4.053140020257930e-05,   4.533733749063311e-06,  -4.117750953278430e-07,
   3.148799011604485e-08,  -2.079438006863467e-09,   1.215623160542008e-10,  -6.379233777574853e-12,   3.022103478559983e-13,  -1.308235493017132e-14,   5.248223078417982e-16,
  -1.943685665589530e-17,   6.625615862738865e-19,  -8.598566746011814e-04,   2.282571171561228e-04,  -3.466619323835235e-05,   3.879808769267804e-06,  -3.525275618706698e-07,
   2.696682170635351e-08,  -1.781431230905343e-09,   1.041659035363468e-10,  -5.467329580414688e-12,   2.590649971057912e-13,  -1.121654726302003e-14,   4.499884857345599e-16,
  -1.666823109068435e-17,   5.683824713011782e-19,  -6.858323287157979e-04,   1.821690471894039e-04,  -2.768371629280011e-05,   3.099990641138971e-06,  -2.817837138421958e-07,
   2.156250669401740e-08,  -1.424859419284629e-09,   8.333521574362387e-11,  -4.374774051969351e-12,   2.073377430830593e-13,  -8.978424801036055e-15,   3.602119914394333e-16,
  -1.334495888426248e-17,   4.552111590006733e-19,  -5.014276198685684e-04,   1.332516603590368e-04,  -2.025991815784165e-05,   2.269654611076185e-06,  -2.063734995183712e-07,
   1.579628411350882e-08,  -1.044082216495330e-09,   6.107612506608634e-11,  -3.206716859685396e-12,   1.520039091114129e-13,  -6.583149845169903e-15,   2.641221257204089e-16,
  -9.786336855128321e-18,   3.339110446286527e-19,  -3.250463450967703e-04,   8.640656532256891e-05,  -1.314176603926795e-05,   1.472646336457149e-06,  -1.339318859304143e-07,
   1.025327216363103e-08,  -6.778173596315843e-10,   3.965539781564481e-11,  -2.082247441432723e-12,   9.871278789749019e-14,  -4.275531110627180e-15,   1.715417605792749e-16,
  -6.356558213731607e-18,   2.169241579368092e-19,  -1.744982472929432e-04,   4.639411133401167e-05,  -7.057366053030863e-06,   7.909522361953721e-07,  -7.194201958464778e-08,
   5.508087706799188e-09,  -3.641557262718214e-10,   2.130609477041642e-11,  -1.118806130023454e-12,   5.304200700277642e-14,  -2.297502049632039e-15,   9.218074965821520e-17,
  -3.415947343718447e-18,   1.165830729090304e-19,  -6.495303159829962e-05,   1.727013326355315e-05,  -2.627246332442494e-06,   2.944626933655320e-07,  -2.678421605158425e-08,
   2.050741755295006e-09,  -1.355844304560275e-10,   7.932972554869734e-12,  -4.165759777164297e-13,   1.975002664614391e-14,  -8.554809797179071e-16,   3.432387185888220e-17,
  -1.271960765665082e-18,   4.341215964174330e-20,  -7.337263383232653e-06,   1.950896612764282e-06,  -2.967859776894649e-07,   3.326414258253455e-08,  -3.025711930424648e-09,
   2.316657352327476e-10,  -1.531660955561700e-11,   8.961697219170181e-13,  -4.705975841532554e-14,   2.231127975832506e-15,  -9.664251403061729e-17,   3.877523020005075e-18,
  -1.436920896865029e-19,   4.904250586469716e-21,  -1.164094143319253e-02,   6.899658720197008e-04,  -2.929208796943898e-05,   1.348995137693834e-06,  -6.369244076856816e-08,
   1.773508955909107e-09,  -2.451732499718185e-11,   2.841788915720955e-12,  -2.010237476068501e-13,  -3.813587217960141e-16,   2.958816840365240e-16,   1.267228352084708e-17,
  -1.045574838484748e-18,  -3.812250265597551e-20,  -1.107560984429041e-02,   6.565270450618940e-04,  -2.787870087471177e-05,   1.283912288506847e-06,  -6.060598485718300e-08,
   1.689017906271189e-09,  -2.348997325292589e-11,   2.703291343542442e-12,  -1.908660767560700e-13,  -3.428743951700141e-16,   2.795114578594834e-16,   1.197284375805809e-17,
  -9.880831222259018e-19,  -3.586878650650523e-20,  -9.999924957890790e-03,   5.928733653864880e-04,  -2.518565262521174e-05,   1.159901563175409e-06,  -5.473059728300211e-08,
   1.527585600758538e-09,  -2.146827159617864e-11,   2.439992752452396e-12,  -1.717030037587329e-13,  -2.779573287563884e-16,   2.491951492923607e-16,   1.067742279515579e-17,
  -8.815060626930261e-19,  -3.175112335719819e-20,  -8.518672656577552e-03,   5.051660307297520e-04,  -2.147001672752594e-05,   9.887963219896920e-07,  -4.663480232215824e-08,
   1.303995711063407e-09,  -1.855505989397150e-11,   2.077835160788533e-12,  -1.456300301280509e-13,  -2.044890054991265e-16,   2.090441552998575e-16,   8.961048922949516e-18,
  -7.401215477309289e-19,  -2.640483770388992e-20,  -6.776470452036728e-03,   4.019388006959995e-04,  -1.709066101350736e-05,   7.871183656008082e-07,  -3.710605585774647e-08,
   1.039381271171198e-09,  -1.496571651693426e-11,   1.652355848846723e-12,  -1.153572169487650e-13,  -1.379525301907817e-16,   1.638121270093059e-16,   7.025799850945435e-18,
  -5.805072919161506e-19,  -2.051620554873371e-20,  -4.943784142955535e-03,   2.932862807486895e-04,  -1.247533369173163e-05,   5.745648421786892e-07,  -2.707601218194024e-08,
   7.595001034512439e-10,  -1.103871001668740e-11,   1.205185509527063e-12,  -8.387384264695586e-14,  -8.623421802570702e-17,   1.180635993729815e-16,   5.066172772784136e-18,
  -4.187145491929847e-19,  -1.468480209540744e-20,  -3.200216092570529e-03,   1.898723310857384e-04,  -8.078462871502816e-06,   3.720655876547533e-07,  -1.752913342686338e-08,
   4.921613018195539e-10,  -7.197016132996958e-12,   7.800223543776156e-13,  -5.417205830877799e-14,  -4.969442121903692e-17,   7.581020639718617e-17,   3.254229355544556e-18,
  -2.690079439763136e-19,  -9.386133638886184e-21,  -1.716754372634200e-03,   1.018629580161312e-04,  -4.334490615743149e-06,   1.996323313037542e-07,  -9.404120305961598e-09,
   2.641631476366571e-10,  -3.874987431549419e-12,   4.184105670521038e-13,  -2.902729042630214e-14,  -2.497669230147160e-17,   4.049954658860972e-17,   1.738824281544424e-18,
  -1.437512926733777e-19,  -5.002442607266284e-21,  -6.388607676175911e-04,   3.790733913462080e-05,  -1.613110544502412e-06,   7.429467006362958e-08,  -3.499663638017783e-09,
   9.832237535221390e-11,  -1.443842321558314e-12,   1.557002384403209e-13,  -1.079770555742912e-14,  -9.077164016823869e-18,   1.504938411738348e-17,   6.461816464621154e-19,
  -5.342248323053177e-20,  -1.857345132984322e-21,  -7.216446550499197e-05,   4.281953067536470e-06,  -1.822156835034192e-07,   8.392269015901022e-09,  -3.953166304152526e-10,
   1.110663666197438e-11,  -1.631264450698887e-13,   1.758752195503168e-14,  -1.219610637472481e-15,  -1.021442252750325e-18,   1.699557958795947e-18,   7.297544028849807e-20,
  -6.033207898676326e-21,  -2.097263586151270e-22,  -4.407932680034563e-03,   5.807617019922392e-04,  -5.160898742076287e-05,   3.296013522155204e-06,  -1.818338427825920e-07,
   1.019163934031854e-08,  -5.238141355817982e-10,   2.124166115993302e-11,  -7.879895656404517e-13,   3.747341761944861e-14,  -1.659649100490998e-15,   3.931668122800687e-17,
  -6.489234445025361e-19,   7.735851858614387e-20,  -4.195112318170694e-03,   5.528131350199566e-04,  -4.913172245752007e-05,   3.138765736005425e-06,  -1.732255453206527e-07,
   9.709367861602237e-09,  -4.990043910447570e-10,   2.024902282274718e-11,  -7.518934025596821e-13,   3.571668789291856e-14,  -1.580313703027942e-15,   3.758198531704281e-17,
  -6.279226445180896e-19,   7.346544838665337e-20,  -3.789662002183002e-03,   4.995303091254444e-04,  -4.440632574917603e-05,   2.838419952303637e-06,  -1.567560251607356e-07,
   8.786600471240462e-09,  -4.515442328060188e-10,   1.834452554981407e-11,  -6.823299871531523e-13,   3.234876961340679e-14,  -1.428872051405647e-15,   3.420979880900195e-17,
  -5.836195497204403e-19,   6.611843721627662e-20,  -3.230361434202218e-03,   4.259568425056702e-04,  -3.787641524278801e-05,   2.422614368314038e-06,  -1.339019680533829e-07,
   7.505952039690979e-09,  -3.856963894717252e-10,   1.569133923404970e-11,  -5.848278942256500e-13,   2.766160689559871e-14,  -1.219361760671614e-15,   2.942800417927019e-17,
  -5.142569614640106e-19,   5.611364436225486e-20,  -2.571284549709001e-03,   3.391667627860745e-04,  -3.016709205254940e-05,   1.930739760545916e-06,  -1.067996844769151e-07,
   5.987027485452387e-09,  -3.076196637726292e-10,   1.253183496117697e-11,  -4.679799015690497e-13,   2.208556156092929e-14,  -9.716717666967759e-16,   2.362953564784467e-17,
  -4.221986410501273e-19,   4.448071724598039e-20,  -1.876815194100211e-03,   2.476306707560170e-04,  -2.203022118668662e-05,   1.410685690397144e-06,  -7.808227139338946e-08,
   4.377362003192040e-09,  -2.248985347706814e-10,   9.171836320582184e-12,  -3.430379162158290e-13,   1.616050716043145e-14,  -7.098944385540971e-16,   1.736800963312309e-17,
  -3.156825195379238e-19,   3.236195119876626e-20,  -1.215300457121546e-03,   1.603783492362532e-04,  -1.426995142405809e-05,   9.140708253205813e-07,  -5.061555089069309e-08,
   2.837636066695808e-09,  -1.457848635559821e-10,   5.949638440568639e-12,  -2.227501066325991e-13,   1.048162466890673e-14,  -4.599671456328192e-16,   1.129779664666483e-17,
  -2.076144670440345e-19,   2.091148183456144e-20,  -6.520570884466816e-04,   8.605742561367761e-05,  -7.657678529793458e-06,   4.906020821627252e-07,  -2.717232628600557e-08,
   1.523372702016492e-09,  -7.826230048876897e-11,   3.195131242395662e-12,  -1.196855581963838e-13,   5.628546338317383e-15,  -2.468705781522037e-16,   6.075868350492743e-18,
  -1.122724464863106e-19,   1.120789742331170e-20,  -2.426661058672501e-04,   3.202771832042149e-05,  -2.850007019056778e-06,   1.826014614664295e-07,  -1.011426066636091e-08,
   5.670427603843684e-10,  -2.913124461546154e-11,   1.189460530802631e-12,  -4.456372406738579e-14,   2.095304156220742e-15,  -9.188444336858852e-17,   2.262994656498141e-18,
  -4.189642705070580e-20,   4.169534235991523e-21,  -2.741134456829140e-05,   3.617840894989014e-06,  -3.219371997329784e-07,   2.062688356994670e-08,  -1.142532756284366e-09,
   6.405465506365520e-11,  -3.290738850675560e-12,   1.343671554188710e-13,  -5.034275702828332e-15,   2.366946817247990e-16,  -1.037937057000197e-17,   2.556586638327005e-19,
  -4.734620062915857e-21,   4.709593238144372e-22,  -4.111333386287601e-04,   9.638152356447487e-05,  -1.306801898348488e-05,   1.290936430584532e-06,  -1.067147242301675e-07,
   7.723073765372060e-09,  -4.856001750054218e-10,   2.678015435858159e-11,  -1.350697979323176e-12,   6.350240191177046e-14,  -2.681623565291039e-15,   1.004123074018100e-16,
  -3.694894511864580e-18,   1.399101387076856e-19,  -3.915529875735108e-04,   9.181314460908905e-05,  -1.245196250610377e-05,   1.230493431073728e-06,  -1.017450325300719e-07,
   7.364466988081048e-09,  -4.631257474388352e-10,   2.554667920535157e-11,  -1.288647670799456e-12,   6.058096706730298e-14,  -2.558567842523827e-15,   9.585625023781754e-17,
  -3.526718822741579e-18,   1.333649216669771e-19,  -3.541402192464826e-04,   8.307524319075753e-05,  -1.127225291954800e-05,   1.114576623735839e-06,  -9.220303464542659e-08,
   6.675488765516163e-09,  -4.199156001135670e-10,   2.317262815504201e-11,  -1.169152080185755e-12,   5.495680148838551e-14,  -2.321534391184979e-15,   8.705765551829970e-17,
  -3.202183475829118e-18,   1.208134661614759e-19,  -3.023179413724376e-04,   7.095455149060391e-05,  -9.633148358489928e-06,   9.531868706792181e-07,  -7.889617055469721e-08,
   5.713816344139983e-09,  -3.595434328861177e-10,   1.985079727619788e-11,  -1.001818867757817e-12,   4.708464249517287e-14,  -1.989500873003884e-15,   7.468975726948491e-17,
  -2.746444899544993e-18,   1.033367078792583e-19,  -2.409806111686540e-04,   5.658636603703240e-05,  -7.686718631860278e-06,   7.611166765712273e-07,  -6.303237371699565e-08,
   4.566278760745594e-09,  -2.874278071505742e-10,   1.587671914240215e-11,  -8.014633008010779e-13,   3.766319367743146e-14,  -1.591800745706386e-15,   5.982291609146661e-17,
  -2.199160366343782e-18,   8.253086412166547e-20,  -1.760970538286308e-04,   4.136695477957133e-05,  -5.621817296008578e-06,   5.569654504529698e-07,  -4.614545773771883e-08,
   3.343728436090908e-09,  -2.105284272352064e-10,   1.163340871868055e-11,  -5.873803413161509e-13,   2.759998052125872e-14,  -1.166716735613032e-15,   4.388440140082880e-17,
  -1.612894514535541e-18,   6.040577376106188e-20,  -1.141152372204634e-04,   2.681381026555208e-05,  -3.645102528129440e-06,   3.612603804929690e-07,  -2.993953971303942e-08,
   2.169778133541832e-09,  -1.366374639590146e-10,   7.552208865576061e-12,  -3.813690061529617e-13,   1.791869150607357e-14,  -7.575629962745504e-16,   2.851033020940110e-17,
  -1.047702377528897e-18,   3.918621371192308e-20,  -6.125121845592951e-05,   1.439421089027970e-05,  -1.957062913071392e-06,   1.939978614526097e-07,  -1.607997419532278e-08,
   1.165441664363791e-09,  -7.339784546068476e-11,   4.057352823007107e-12,  -2.049011568746295e-13,   9.626998383883046e-15,  -4.070351282152306e-16,   1.532276242788628e-17,
  -5.630440872982449e-19,   2.104476864660535e-20,  -2.279801831544266e-05,   5.357849286542146e-06,  -7.285012178329951e-07,   7.221889018379214e-08,  -5.986339496269268e-09,
   4.338890678131675e-10,  -2.732654984330412e-11,   1.510648670431986e-12,  -7.629140653130944e-14,   3.584405446620864e-15,  -1.515542193589851e-16,   5.705785156276398e-18,
  -2.096574347984269e-19,   7.834481521347786e-21,  -2.575298987337484e-06,   6.052353244287129e-07,  -8.229390757707078e-08,   8.158169307148824e-09,  -6.762491890109480e-10,
   4.901466669584065e-11,  -3.086983173199081e-12,   1.706538061235151e-13,  -8.618462489674896e-15,   4.049211985505340e-16,  -1.712075800356141e-17,   6.445803505878432e-19,
  -2.368482913093365e-20,   8.850221115174334e-22,  -9.268290086805901e-03,   5.056279952109256e-04,  -1.810777487751247e-05,   5.964156523758438e-07,  -3.114032122091342e-08,
   1.490850449609307e-09,  -1.929066402071833e-11,  -1.409500168151186e-12,  -1.265290734202304e-14,   7.364618049825412e-15,  -1.560262695914235e-16,  -1.707054399344868e-17,
   6.395031915970116e-19,   4.191533995083555e-20,  -8.818023961979733e-03,   4.810881246635161e-04,  -1.723258269011193e-05,   5.678464358262240e-07,  -2.963429345533682e-08,
   1.417491162417606e-09,  -1.836402472661542e-11,  -1.333244149193199e-12,  -1.223664221837164e-14,   6.979381064930970e-15,  -1.472519835222244e-16,  -1.614639351454388e-17,
   6.020563993317992e-19,   3.962735017341089e-20,  -7.961344983529571e-03,   4.343886060013974e-04,  -1.556560406037257e-05,   5.133251283336739e-07,  -2.676615140388852e-08,
   1.278303028940319e-09,  -1.659693355504715e-11,  -1.191364484421226e-12,  -1.136178079894017e-14,   6.257807602384329e-15,  -1.310606626777654e-16,  -1.442748075602353e-17,
   5.335053525790213e-19,   3.537858332539351e-20,  -6.781797019071328e-03,   3.700696955682025e-04,  -1.326681262285304e-05,   4.379354150047830e-07,  -2.281168508953950e-08,
   1.087398245686665e-09,  -1.415575977302228e-11,  -1.002187440190873e-12,  -9.998661422392500e-15,   5.286138922872528e-15,  -1.097249461203274e-16,  -1.213629737054397e-17,
   4.442442313681404e-19,   2.972893015161434e-20,  -5.394609881454705e-03,   2.944043509634801e-04,  -1.055885776952586e-05,   3.488699962812479e-07,  -1.815430158560079e-08,
   8.638160556830980e-10,  -1.127428141468130e-11,  -7.874637162407666e-13,  -8.198177290667997e-15,   4.170765361342887e-15,  -8.582037698765734e-17,  -9.536219757221385e-18,
   3.456060623906335e-19,   2.333540422614550e-20,  -3.935526189900530e-03,   2.147947379689001e-04,  -7.706355001668092e-06,   2.548117303268934e-07,  -1.324918130031568e-08,
   6.295019001081557e-10,  -8.233294989785162e-12,  -5.687850022402900e-13,  -6.123278090460744e-15,   3.022779849545440e-15,  -6.176040825631142e-17,  -6.888315403576131e-18,
   2.476253526995591e-19,   1.684142526073545e-20,  -2.547498247278968e-03,   1.390461482002059e-04,  -4.989823142191385e-06,   1.650702983708916e-07,  -8.578479645873559e-09,
   4.071933779788864e-10,  -5.333104519568948e-12,  -3.657523066598080e-13,  -4.024163252153173e-15,   1.948193936656976e-15,  -3.961855115100192e-17,  -4.429664692144223e-18,
   1.583826946838035e-19,   1.082396383191549e-20,  -1.366590110142535e-03,   7.459260868552837e-05,  -2.677156393819717e-06,   8.858637714422195e-08,  -4.602473553586387e-09,
   2.183572242343306e-10,  -2.861917676648278e-12,  -1.955383941407326e-13,  -2.175339849920552e-15,   1.042768847144993e-15,  -2.115464557529850e-17,  -2.368249628968623e-18,
   8.444122996932992e-20,   5.785131718944869e-21,  -5.085513030905305e-04,   2.775854059040028e-05,  -9.963056371095583e-07,   3.297037166596564e-08,  -1.712803334593704e-09,
   8.124736649822719e-11,  -1.065140574070213e-12,  -7.267966418028435e-14,  -8.116587990176943e-16,   3.877460675105632e-16,  -7.859586594079760e-18,  -8.802635437156501e-19,
   3.135579628679156e-20,   2.150072784278587e-21,  -5.744492998665722e-05,   3.135553752970316e-06,  -1.125415951891659e-07,   3.724348904326566e-09,  -1.934762044588193e-10,
   9.177355124466661e-12,  -1.203184769695878e-13,  -8.208201095358594e-15,  -9.172178996244689e-17,   4.379361870209155e-17,  -8.875751420666638e-19,  -9.941421787717891e-20,
   3.540679517819740e-21,   2.428184847420384e-22,  -2.714095655972585e-03,   2.885323767303113e-04,  -2.454289327130655e-05,   1.497334202773268e-06,  -6.638938678898662e-08,
   2.775493147054937e-09,  -1.521648008642249e-10,   7.966893696832168e-12,  -2.464795884065515e-13,   2.729011070273244e-15,  -1.561809460861112e-16,   2.400054988755555e-17,
  -9.152479554987106e-19,  -2.152047682117924e-20,  -2.582828494910976e-03,   2.746332286882232e-04,  -2.336112930638642e-05,   1.425343881739569e-06,  -6.322883421043346e-08,
   2.645481388654922e-09,  -1.449699246505702e-10,   7.582568445859165e-12,  -2.347138408580326e-13,   2.635065917070850e-15,  -1.503280508490040e-16,   2.278575738857292e-17,
  -8.659828521603775e-19,  -2.028879885995818e-20,  -2.332840281309033e-03,   2.481406496964687e-04,  -2.110841633037448e-05,   1.288070599508879e-06,  -5.718933242526532e-08,
   2.396159453666929e-09,  -1.312008073135348e-10,   6.850300231287856e-12,  -2.122465622756337e-13,   2.440499156224203e-15,  -1.384739957950299e-16,   2.049493961987365e-17,
  -7.742885461798588e-19,  -1.802184896370341e-20,  -1.988172558663550e-03,   2.115703287552440e-04,  -1.799837435597686e-05,   1.098469733717913e-06,  -4.882269414027581e-08,
   2.049068295269069e-09,  -1.120867904557096e-10,   5.839962528586604e-12,  -1.811502157510521e-13,   2.142028817333402e-15,  -1.207723209235016e-16,   1.737981581600573e-17,
  -6.519026711772493e-19,  -1.504805217436520e-20,  -1.582245611445813e-03,   1.684444630848782e-04,  -1.433031347817868e-05,   8.747414045888766e-07,  -3.891859544588948e-08,
   1.636059960317025e-09,  -8.941085599020098e-11,   4.649042455073456e-12,  -1.443707183086848e-13,   1.752485172872602e-15,  -9.822700914495112e-17,   1.376487498100158e-17,
  -5.127388975252193e-19,  -1.173643236650144e-20,  -1.154732687827431e-03,   1.229733331019692e-04,  -1.046228476475872e-05,   6.387142100675723e-07,  -2.844073610450934e-08,
   1.197151317237522e-09,  -6.537545300903114e-11,   3.393775094810343e-12,  -1.054856449930048e-13,   1.306979786132392e-15,  -7.291992358220080e-17,   1.000701122457174e-17,
  -3.706900706540025e-19,  -8.425261850438939e-21,  -7.476553432024325e-04,   7.963936318751457e-05,  -6.775704480279201e-06,   4.136868252466073e-07,  -1.843067855421766e-08,
   7.764649478565445e-10,  -4.238124596088324e-11,   2.197754380174186e-12,  -6.835204060034948e-14,   8.581824750010524e-16,  -4.773830872831979e-17,   6.462825235779485e-18,
  -2.385265678038960e-19,  -5.395376769201008e-21,  -4.011268595645791e-04,   4.273245112637817e-05,  -3.635718101347618e-06,   2.219865104889782e-07,  -9.892748833228948e-09,
   4.169540184795717e-10,  -2.275257757012170e-11,   1.179231841720407e-12,  -3.668651527718753e-14,   4.637141199625274e-16,  -2.575636032632705e-17,   3.462887700482946e-18,
  -1.275665186581416e-19,  -2.878264366718183e-21,  -1.492786523618175e-04,   1.590343987984271e-05,  -1.353086199880761e-06,   8.261682843739270e-08,  -3.682145385085650e-09,
   1.552166776016855e-10,  -8.469207927011665e-12,   4.388631297123089e-13,  -1.365473837646515e-14,   1.729959920061592e-16,  -9.603826219401401e-18,   1.288125607290102e-18,
  -4.742122161410613e-20,  -1.069015268404967e-21,  -1.686233555862564e-05,   1.796444642856309e-06,  -1.528440542974152e-07,   9.332385334200979e-09,  -4.159410099338011e-10,
   1.753394762942746e-11,  -9.567050921628549e-13,   4.957369997061512e-14,  -1.542457073091007e-15,   1.954904481725153e-17,  -1.085170579316765e-18,   1.454946822650772e-19,
  -5.355704735164969e-21,  -1.207165748352737e-22,  -1.660608967372444e-04,   3.338545600106158e-05,  -4.243243623164380e-06,   3.742177442851940e-07,  -2.647810188860772e-08,
   1.723731514686924e-09,  -1.064408024591317e-10,   5.777826637385462e-12,  -2.625428879412230e-13,   1.085536794520072e-14,  -4.848202436296926e-16,   2.176933524464724e-17,
  -7.021951255997320e-19,   1.113096111647483e-20,  -1.581169153117186e-04,   3.179595900773405e-05,  -4.041692221484656e-06,   3.565394165152551e-07,  -2.523851850283781e-08,
   1.643551978401308e-09,  -1.014858283884392e-10,   5.508656584415658e-12,  -2.504327026916756e-13,   1.036322696231127e-14,  -4.626283403396238e-16,   2.073835047233393e-17,
  -6.690984113215767e-19,   1.074262123703804e-20,  -1.429526124793210e-04,   2.875864887143779e-05,  -3.656363167521020e-06,   3.227019008230126e-07,  -2.286119100388487e-08,
   1.489562944762788e-09,  -9.197131004294419e-11,   4.991895683222438e-12,  -2.271321091050512e-13,   9.412606828337646e-15,  -4.198549496888968e-16,   1.876645410398388e-17,
  -6.057408241904878e-19,   9.940829929514546e-21,  -1.219759177074062e-04,   2.455111887655915e-05,  -3.122199627953985e-06,   2.757172801031224e-07,  -1.955113475760602e-08,
   1.274738294773763e-09,  -7.870121932816251e-11,   4.271335952514274e-12,  -1.945439660960686e-13,   8.075988061069689e-15,  -3.598900417032734e-16,   1.603086110809963e-17,
  -5.177273815675608e-19,   8.715767626207585e-21,  -9.718330862589529e-05,   1.957054920364576e-05,  -2.489419143427746e-06,   2.199605783323666e-07,  -1.561168260989392e-08,
   1.018538993236429e-09,  -6.287924636446295e-11,   3.412413872959105e-12,  -1.555751032500502e-13,   6.468896673328840e-15,  -2.880095847103021e-16,   1.278701314202021e-17,
  -4.131973176431348e-19,   7.123195594408319e-21,  -7.099047834256789e-05,   1.430157217103222e-05,  -1.819550377495077e-06,   1.608447480187017e-07,  -1.142431571505818e-08,
   7.457299434882557e-10,  -4.603492405182827e-11,   2.498163041401138e-12,  -1.139825517103090e-13,   4.745625418356176e-15,  -2.111319705026199e-16,   9.349484307774721e-18,
  -3.022599402741966e-19,   5.307778316765939e-21,  -4.599227617783347e-05,   9.267922398552161e-06,  -1.179286003155285e-06,   1.042776758830732e-07,  -7.410106747109099e-09,
   4.838635400150846e-10,  -2.986850427838007e-11,   1.620815695571488e-12,  -7.399017754072597e-14,   3.083175394000215e-15,  -1.371045232725745e-16,   6.061067046072678e-18,
  -1.960112268880017e-19,   3.483148088933971e-21,  -2.468318416924908e-05,   4.974587673494933e-06,  -6.330279197335699e-07,   5.598368568827740e-08,  -3.979258611417118e-09,
   2.598818396953383e-10,  -1.604201097238771e-11,   8.705072843101706e-13,  -3.974906206249628e-14,   1.657064036637907e-15,  -7.366940057050964e-17,   3.253937134359531e-18,
  -1.052479146013889e-19,   1.881536342735803e-21,  -9.186804432873978e-06,   1.851572436483164e-06,  -2.356224069282007e-07,   2.083906955345058e-08,  -1.481345655035111e-09,
   9.675120152389444e-11,  -5.972230847463934e-12,   3.240767974277613e-13,  -1.479932962951163e-14,   6.170491596024913e-16,  -2.743032233894876e-17,   1.211219257076944e-18,
  -3.917892499319045e-20,   7.018639898445430e-22,  -1.037748233384901e-06,   2.091565474736002e-07,  -2.661637760635584e-08,   2.354042790971226e-09,  -1.673394630833715e-10,
   1.092955513252187e-11,  -6.746558395909381e-13,   3.660945643779818e-14,  -1.671835994557727e-15,   6.970785962158003e-17,  -3.098753817795454e-18,   1.368227442228161e-19,
  -4.425803066982690e-21,   7.931133426503738e-23,  -7.499425644314301e-03,   3.829652964690492e-04,  -1.307083061911162e-05,   2.998186542369601e-07,  -8.584390860844123e-09,
   6.866297942353486e-10,  -3.829681177901541e-11,   4.428933429628470e-13,   6.390114417252192e-14,  -2.572992788396351e-15,  -1.118513515597872e-16,   1.128797842632670e-17,
  -9.237679819440026e-20,  -2.630279046867074e-20,  -7.135042016283346e-03,   3.643648729877230e-04,  -1.243663367931144e-05,   2.854403217921016e-07,  -8.183721561347613e-09,
   6.534960793841824e-10,  -3.638171331716614e-11,   4.187193691288624e-13,   6.064215067094222e-14,  -2.429952859495156e-15,  -1.065616181893520e-16,   1.067933023411754e-17,
  -8.510385228498423e-20,  -2.492122469669702e-20,  -6.441784356211586e-03,   3.289737617998212e-04,  -1.122968436743518e-05,   2.580079129571682e-07,  -7.414711217715871e-09,
   5.903624308825327e-10,  -3.276042363603873e-11,   3.738333378360587e-13,   5.450423105012445e-14,  -2.165279070927546e-15,  -9.643139077605277e-17,   9.546168936605457e-18,
  -7.244780919624881e-20,  -2.233428637352673e-20,  -5.487289050126212e-03,   2.802407164751600e-04,  -9.567225791133969e-06,   2.200890281402306e-07,  -6.342927457922737e-09,
   5.032561312086128e-10,  -2.781755293422626e-11,   3.141516087888527e-13,   4.617474166577281e-14,  -1.815211737901010e-15,  -8.236264873061473e-17,   8.033793590349221e-18,
  -5.726443813127723e-20,  -1.885368125923594e-20,  -4.364822514258827e-03,   2.229245073250712e-04,  -7.611318419990099e-06,   1.753082113629922e-07,  -5.066141283339999e-09,
   4.005936540571806e-10,  -2.205901306213314e-11,   2.466088203854044e-13,   3.653339072431837e-14,  -1.421488639238588e-15,  -6.567575873304284e-17,   6.315247889598717e-18,
  -4.217340105600032e-20,  -1.486414465027718e-20,  -3.184227599585401e-03,   1.626333942833102e-04,  -5.553285997495822e-06,   1.280320538466463e-07,  -3.708001165186049e-09,
   2.924058375879835e-10,  -1.605251251157688e-11,   1.779947856995447e-13,   2.653657792275546e-14,  -1.023922479499895e-15,  -4.800196138904590e-17,   4.563146249470450e-18,
  -2.881169826675816e-20,  -1.076530600178973e-20,  -2.061160048668481e-03,   1.052753925789631e-04,  -3.594947251788661e-06,   8.293590107599939e-08,  -2.405388738375153e-09,
   1.893451111365248e-10,  -1.037377223341098e-11,   1.144042460711213e-13,   1.712786193851647e-14,  -6.572195296023371e-16,  -3.110896572387371e-17,   2.935007132015885e-18,
  -1.782329598627703e-20,  -6.934792006851962e-21,  -1.105692364296459e-03,   5.647475599471345e-05,  -1.928559536240958e-06,   4.450691527865345e-08,  -1.291779200562259e-09,
   1.015918222845480e-10,  -5.560229302337033e-12,   6.114830330873757e-14,   9.174501145027454e-15,  -3.510304506681158e-16,  -1.669815233156381e-17,   1.569311936167433e-18,
  -9.335002111740887e-21,  -3.710834649070156e-21,  -4.114624303019190e-04,   2.101609125893512e-05,  -7.176871545799310e-07,   1.656455835958416e-08,  -4.808960285562299e-10,
   3.780795046495857e-11,  -2.068526005152238e-12,   2.272635937694905e-14,   3.412354686998875e-15,  -1.304314728582703e-16,  -6.215182504897245e-18,   5.833234945906105e-19,
  -3.444643226190545e-21,  -1.379714172505650e-21,  -4.647795608570010e-05,   2.373936242177870e-06,  -8.106866081310452e-08,   1.871137313100005e-09,  -5.432434776487904e-11,
   4.270753357582537e-12,  -2.336455814883444e-13,   2.566606814785870e-15,   3.854210368197556e-16,  -1.472972791985093e-17,  -7.020772333242470e-19,   6.587909389945689e-20,
  -3.885769420699039e-22,  -1.558281364836914e-22,  -1.860024539636076e-03,   1.492479984803628e-04,  -1.158827904652225e-05,   7.416137104622603e-07,  -3.358756465049869e-08,
   9.928115275617040e-10,  -2.539617484181611e-11,   1.699834611999762e-12,  -1.276817931067143e-13,   4.712569197483617e-15,   1.311027318964533e-17,  -7.248572091770536e-18,
   2.759127875765880e-20,   2.310132124982861e-20,  -1.769905723908125e-03,   1.420552447548270e-04,  -1.103064136978992e-05,   7.058398785288672e-07,  -3.196558651969050e-08,
   9.456054597305929e-10,  -2.426708222638890e-11,   1.622120428299707e-12,  -1.214535975728547e-13,   4.471998564550543e-15,   1.249917323722369e-17,  -6.843380089995427e-18,
   2.374442948480804e-20,   2.190821301825355e-20,  -1.598346168482636e-03,   1.283467346079062e-04,  -9.967507696584280e-06,   6.376731387601840e-07,  -2.887569802497363e-08,
   8.553776021345648e-10,  -2.207624121275785e-11,   1.472264339356927e-12,  -1.096140456948661e-13,   4.019137327155311e-15,   1.131938679293679e-17,  -6.094273493424683e-18,
   1.748284777873978e-20,   1.966648193987088e-20,  -1.361936442220430e-03,   1.094260465269745e-04,  -8.499488422450851e-06,   5.436148675842505e-07,  -2.461364852642650e-08,
   7.303389206454378e-10,  -1.897710554729650e-11,   1.262075742884310e-12,  -9.333224951122310e-14,   3.404884540771160e-15,   9.668355265353155e-18,  -5.104903495814668e-18,
   1.087400746504939e-20,   1.663525094798567e-20,  -1.083667507884795e-03,   8.711687170767569e-05,  -6.767721534689237e-06,   4.327448034908781e-07,  -1.959158472405134e-08,
   5.822637925621790e-10,  -1.522792407591961e-11,   1.010034692356155e-12,  -7.420953623363971e-14,   2.694074056535934e-15,   7.702999576608349e-18,  -3.994257413307019e-18,
   5.592026691123816e-21,   1.314130291562881e-20,  -7.907490779805654e-04,   6.359749081235875e-05,  -4.941228967869201e-06,   3.158906792455373e-07,  -1.430005146045556e-08,
   4.255523716212876e-10,  -1.118705794520138e-11,   7.404303916897912e-13,  -5.411922778460033e-14,   1.957045024683964e-15,   5.622712298248358e-18,  -2.875023897951312e-18,
   2.306067104180944e-21,   9.533031404868547e-21,  -5.119361412208208e-04,   4.118564692789026e-05,  -3.200199446124238e-06,   2.045602373647838e-07,  -9.259724413847509e-09,
   2.757953091545197e-10,  -7.274758729391391e-12,   4.808146309904921e-13,  -3.502377672244856e-14,   1.263259001051515e-15,   3.639698147849214e-18,  -1.844435141911376e-18,
   7.415784997012356e-22,   6.147651023508823e-21,  -2.746465023133347e-04,   2.209888190251583e-05,  -1.717196552657625e-06,   1.097576068230998e-07,  -4.968202765715625e-09,
   1.480402672658324e-10,  -3.911668510275619e-12,   2.583504880114824e-13,  -1.878607955709534e-14,   6.766930708130068e-16,   1.952303143948629e-18,  -9.848735665436965e-19,
   1.921028581067149e-22,   3.291476260242098e-21,  -1.022074071793836e-04,   8.224350521439009e-06,  -6.390837485936535e-07,   4.084718369506897e-08,  -1.848939035371861e-09,
   5.510231825480566e-11,  -1.456842656419275e-12,   9.619478309107909e-14,  -6.990606174098742e-15,   2.516928438651093e-16,   7.264764332015715e-19,  -3.659120548300861e-19,
   4.491516939089312e-23,   1.224033147490178e-21,  -1.154519245180049e-05,   9.290178718809004e-07,  -7.219070038268655e-08,   4.614067775374282e-09,  -2.088544704099240e-10,
   6.224459477338669e-12,  -1.645832924935805e-13,   1.086694396048249e-14,  -7.896396396060260e-16,   2.842845895497279e-17,   8.206058049637324e-20,  -4.132210642197995e-20,
   4.597607826429341e-24,   1.382494519916686e-22,  -7.955406982749420e-05,   1.213482335854671e-05,  -1.489277745746837e-06,   1.291032427977669e-07,  -8.186018187749158e-09,
   4.249947313806458e-10,  -2.194433835639964e-11,   1.245085998829602e-12,  -6.602805289825175e-14,   2.657405653931551e-15,  -7.155996296616687e-17,   1.751068002540639e-18,
  -1.233797052756283e-19,   9.033285154416161e-21,  -7.573099586070559e-05,   1.155634369053814e-05,  -1.418323465747637e-06,   1.229524050519844e-07,  -7.797846514060127e-09,
   4.051137077434042e-10,  -2.093248487712044e-11,   1.187390080634372e-12,  -6.291422123404730e-14,   2.531210020965677e-15,  -6.832962246209950e-17,   1.686608131729582e-18,
  -1.181277559044657e-19,   8.576614027781568e-21,  -6.844025752065140e-05,   1.045124581668775e-05,  -1.282759508793861e-06,   1.112008039557114e-07,  -7.055470778117354e-09,
   3.669788109322097e-10,  -1.898537148168592e-11,   1.076486004640248e-12,  -5.695208768718911e-14,   2.289974082433724e-15,  -6.208538060849636e-17,   1.555524073074290e-18,
  -1.078245914469644e-19,   7.715016278207938e-21,  -5.836886364773445e-05,   8.920955503206966e-06,  -1.095004137231562e-06,   9.492493845002590e-08,  -6.025831611480655e-09,
   3.138697691786137e-10,  -1.626175128482144e-11,   9.215860299476553e-13,  -4.866930266175371e-14,   1.955573302054071e-15,  -5.329550352466104e-17,   1.358726171919403e-18,
  -9.304470591967892e-20,   6.542775941800687e-21,  -4.648285813856799e-05,   7.110252046906172e-06,  -8.728025276745627e-07,   7.566292968983283e-08,  -4.805432484516762e-09,
   2.506466066743212e-10,  -1.300451447956727e-11,   7.366301180528844e-13,  -3.883460219925294e-14,   1.559393243568696e-15,  -4.271199601231979e-17,   1.106729339715474e-18,
  -7.492521163038466e-20,   5.181977767324546e-21,  -3.394184368463582e-05,   5.195396731942894e-06,  -6.377805904280142e-07,   5.528930034867115e-08,  -3.512869800471923e-09,
   1.834299956671501e-10,  -9.527809416925946e-12,   5.394824887462253e-13,  -2.840202383057748e-14,   1.139899306606570e-15,  -3.134764448887635e-17,   8.225889212093040e-19,
  -5.519085581187395e-20,   3.767204112814032e-21,  -2.198420305894828e-05,   3.366558122677728e-06,  -4.132882226789530e-07,   3.582818733005715e-08,  -2.276980759164094e-09,
   1.189825400534157e-10,  -6.184829607225193e-12,   3.501058582918515e-13,  -1.841533998584169e-14,   7.388488457662809e-16,  -2.037236878149711e-17,   5.389567089546407e-19,
  -3.595077069887197e-20,   2.432904097276821e-21,  -1.179697861119697e-05,   1.806944256217294e-06,  -2.218293716864421e-07,   1.923056176149738e-08,  -1.222319847260593e-09,
   6.389553630867381e-11,  -3.322611713061373e-12,   1.880587269088472e-13,  -9.887209888027892e-15,   3.966232580843724e-16,  -1.095095109036068e-17,   2.909054901340802e-19,
  -1.934735287277123e-20,   1.303565096594382e-21,  -4.390505411402378e-06,   6.725472108823947e-07,  -8.256569536170909e-08,   7.157691332533009e-09,  -4.549735835737322e-10,
   2.378636628999775e-11,  -1.237070198312496e-12,   7.001452816237223e-14,  -3.680433185871773e-15,   1.476313808614561e-16,  -4.078088611369658e-18,   1.084862453400303e-19,
  -7.207745517847293e-21,   4.848968215499627e-22,  -4.959511983860681e-07,   7.597184000345554e-08,  -9.326741074992947e-09,   8.085433465325782e-10,  -5.139486724993747e-11,
   2.687018123468327e-12,  -1.397480977239318e-13,   7.909272549608507e-15,  -4.157538631203926e-16,   1.667677730739428e-17,  -4.607045651594564e-19,   1.225852995798472e-20,
  -8.143154438640861e-22,   5.476936710252801e-23,  -6.156199999078695e-03,   2.912077713666207e-04,  -9.986851555216050e-06,   2.295333698318489e-07,  -2.252240668685189e-09,
   5.152472828788271e-11,  -1.267931865252764e-11,   9.097286305355082e-13,  -2.227316380806548e-14,  -9.098235212815694e-16,   8.852980323826395e-17,  -1.770920943516761e-18,
  -1.263259048552020e-19,   9.818056909640102e-21,  -5.857057920594821e-03,   2.770638339867595e-04,  -9.501503555265236e-06,   2.183858419820988e-07,  -2.148413503332768e-09,
   4.958183271620098e-11,  -1.208046882381973e-11,   8.644871696706562e-13,  -2.107341541192639e-14,  -8.682540024167311e-16,   8.397164037609806e-17,  -1.662639591669816e-18,
  -1.205671068462563e-19,   9.294768715869675e-21,  -5.287934968133332e-03,   2.501521348411694e-04,  -8.578149256997310e-06,   1.971752842320917e-07,  -1.948607303922093e-09,
   4.565640970932742e-11,  -1.093399013624049e-11,   7.788321877858998e-13,  -1.883913096662626e-14,  -7.880434523632562e-16,   7.540296679490495e-17,  -1.465824752806014e-18,
  -1.094438131226903e-19,   8.317833368157461e-21,  -4.504369977081001e-03,   2.130952019457907e-04,  -7.306934830533472e-06,   1.679682390952726e-07,  -1.669098065279234e-09,
   3.980878250922165e-11,  -9.341782915440081e-12,   6.617163853463083e-13,  -1.585606770906241e-14,  -6.754803221102308e-16,   6.380692106570415e-17,  -1.212525402868717e-18,
  -9.381793793727174e-20,   7.009084562789754e-21,  -3.582937261736560e-03,   1.695117076423404e-04,  -5.812117444403515e-06,   1.336162181020328e-07,  -1.334802896882343e-09,
   3.237278772214486e-11,  -7.452237193806474e-12,   5.250293267812220e-13,  -1.246522614382472e-14,  -5.404913250156292e-16,   5.042672550918260e-17,  -9.368009999560343e-19,
  -7.506771149630975e-20,   5.516246564238673e-21,  -2.613808774363533e-03,   1.236662314718711e-04,  -4.239984288378832e-06,   9.748012092828748e-08,  -9.779630321937897e-10,
   2.403158487746151e-11,  -5.449042785702826e-12,   3.822370796391977e-13,  -9.007352701582650e-15,  -3.961403936804139e-16,   3.659402545536304e-17,  -6.672382752832442e-19,
  -5.501469416437764e-20,   3.989407950078184e-21,  -1.691918750512364e-03,   8.005121585379317e-05,  -2.744522850340825e-06,   6.310107876138241e-08,  -6.348353632474448e-10,
   1.573300801244807e-11,  -3.532493730705787e-12,   2.470877950376002e-13,  -5.793680788297120e-15,  -2.572003778475265e-16,   2.360457300357429e-17,  -4.250169084870899e-19,
  -3.571616303493126e-20,   2.567440963199265e-21,  -9.076138416842445e-04,   4.294328340945518e-05,  -1.472268045228122e-06,   3.385058727569452e-08,  -3.410475587931155e-10,
   8.488650788414411e-12,  -1.896436125048790e-12,   1.324557036444784e-13,  -3.097849705368914e-15,  -1.381855910410318e-16,   1.263962782848338e-17,  -2.261042965656962e-19,
  -1.918815459389579e-20,   1.373169443240610e-21,  -3.377509997629881e-04,   1.598058842200678e-05,  -5.478754922446081e-07,   1.259692305126329e-08,  -1.269785538632072e-10,
   3.165210084795747e-12,  -7.059114103930071e-13,   4.927888730206676e-14,  -1.151495841637645e-15,  -5.145058053171095e-17,   4.700636238909299e-18,  -8.389560109629361e-20,
  -7.144176396789872e-21,   5.104659469688822e-22,  -3.815165858867598e-05,   1.805135725731055e-06,  -6.188687698105244e-08,   1.422923956195708e-09,  -1.434438866607464e-11,
   3.576489397173204e-13,  -7.974169264795470e-14,   5.566227562714306e-15,  -1.300471406695498e-16,  -5.812243790139882e-18,   5.309211815908052e-19,  -9.472289052824499e-21,
  -8.070572132168627e-22,   5.765163586664012e-23,  -1.403195686129566e-03,   8.435070843466409e-05,  -5.336873529308751e-06,   3.397560752288671e-07,  -1.772253906612193e-08,
   6.398890539110924e-10,  -1.176846400645055e-11,  -5.937604388109050e-14,  -3.395708579465952e-15,   1.474486801691451e-15,  -9.693955046977001e-17,   2.152212494643609e-18,
   8.821952421435091e-20,  -7.782281398664010e-21,  -1.335107128613541e-03,   8.027853064076788e-05,  -5.080460453653180e-06,   3.234203766452490e-07,  -1.686577095636476e-08,
   6.087351274321283e-10,  -1.119960194840200e-11,  -5.488701879153599e-14,  -3.358785366080696e-15,   1.406119399596294e-15,  -9.204805035959170e-17,   2.030000620005838e-18,
   8.422743774057933e-20,  -7.365719676054900e-21,  -1.205528738667907e-03,   7.252034665608569e-05,  -4.591444964719476e-06,   2.922707373319161e-07,  -1.523396503599496e-08,
   5.494902356956390e-10,  -1.011626216803046e-11,  -4.699426470400341e-14,  -3.236097490398495e-15,   1.274675280433562e-15,  -8.281478004217481e-17,   1.804787309081002e-18,
   7.650219788647070e-20,  -6.588689381751654e-21,  -1.027050786251550e-03,   6.181797602612161e-05,  -3.915872630086708e-06,   2.492470776312432e-07,  -1.298383256005251e-08,
   4.679712417217019e-10,  -8.622507932489957e-12,  -3.738791638233869e-14,  -2.965847583590719e-15,   1.091078996714996e-15,  -7.024453446163621e-17,   1.508739321837526e-18,
   6.562391573798257e-20,  -5.549041577393747e-21,  -8.170743718618713e-04,   4.920598160496944e-05,  -3.118522604662191e-06,   1.984800352119124e-07,  -1.033339287721924e-08,
   3.721689422516895e-10,  -6.862898532005293e-12,  -2.769365436578194e-14,  -2.520305230547711e-15,   8.719164125655550e-16,  -5.564348873116676e-17,   1.178163577487146e-18,
   5.254069602962935e-20,  -4.364851562542506e-21,  -5.961399354208939e-04,   3.591637786950886e-05,  -2.277184234267092e-06,   1.449235394493549e-07,  -7.541656395241636e-09,
   2.714615612332532e-10,  -5.009179648050444e-12,  -1.899776917306644e-14,  -1.933087410386398e-15,   6.384219871510500e-16,  -4.045630921784052e-17,   8.466748190120236e-19,
   3.852326022390491e-20,  -3.155325536842814e-21,  -3.859120170808451e-04,   2.325716744600659e-05,  -1.474951309084988e-06,   9.386429898325073e-08,  -4.883120423531546e-09,
   1.756996359831574e-10,  -3.243578615818486e-12,  -1.178090454954096e-14,  -1.291628789300096e-15,   4.142459350932918e-16,  -2.612886595533470e-17,   5.425975750611326e-19,
   2.501705785855800e-20,  -2.030058321510796e-21,  -2.070272813443437e-04,   1.247842780628486e-05,  -7.914798389703818e-07,   5.036784271690369e-08,  -2.619891052167398e-09,
   9.424764647432784e-11,  -1.740304907008511e-12,  -6.177362687221502e-15,  -7.039834864193295e-16,   2.224912160761897e-16,  -1.400044401917878e-17,   2.895727869988423e-19,
   1.344212856253720e-20,  -1.085590311801052e-21,  -7.704230411825189e-05,   4.643909529193809e-06,  -2.945671452830873e-07,   1.874539396774430e-08,  -9.749921197391102e-10,
   3.507183098250420e-11,  -6.476623776967374e-13,  -2.280334863552042e-15,  -2.634110668403209e-16,   8.283108769417824e-17,  -5.207903743331965e-18,   1.075650861706363e-19,
   5.005054101189828e-21,  -4.035389410264567e-22,  -8.702559850736951e-06,   5.245719068013783e-07,  -3.327429385489105e-08,   2.117476513083539e-09,  -1.101340045074027e-10,
   3.961630930889090e-12,  -7.315935516457227e-14,  -2.572511502811328e-16,  -2.978013001354338e-17,   9.357061171402277e-18,  -5.882366006963585e-19,   1.214685769630303e-20,
   5.654111535744585e-22,  -4.557499502555770e-23,  -4.750233336654182e-05,   4.695841006550543e-06,  -5.139261442256930e-07,   4.602785757521902e-08,  -3.051156623527028e-09,
   1.491407059471415e-10,  -5.637467858524346e-12,   2.064795415200489e-13,  -1.070855850132689e-14,   6.584585047448591e-16,  -3.160844741261035e-17,   8.879142223843801e-19,
  -7.828442362303038e-22,  -8.885394110046778e-22,  -4.520789411019273e-05,   4.471624985864497e-06,  -4.894791077020816e-07,   4.383379446169203e-08,  -2.905296543398688e-09,
   1.420187374308111e-10,  -5.372416075529626e-12,   1.971508816950968e-13,  -1.022999114689994e-14,   6.278646444331850e-16,  -3.007259513672343e-17,   8.428089204072648e-19,
  -7.474035503940814e-22,  -8.348021153828747e-22,  -4.083709525239045e-05,   4.043442898979456e-06,  -4.427549753518000e-07,   3.964230723378463e-08,  -2.626823880562735e-09,
   1.284188078605520e-10,  -4.864584909825363e-12,   1.791183951106867e-13,  -9.302512187710354e-15,   5.690847416427905e-16,  -2.715060597964214e-17,   7.578268179619420e-19,
  -6.815297720445531e-22,  -7.368212248061576e-22,  -3.480854935467164e-05,   3.450803221404325e-06,  -3.780115066128210e-07,   3.383800993569792e-08,  -2.241535777553102e-09,
   1.095964616533274e-10,  -4.158446111440028e-12,   1.537376905486947e-13,  -7.992614074258904e-15,   4.870472920725088e-16,  -2.312760486751705e-17,   6.424024364894188e-19,
  -5.912625231581554e-22,  -6.102134013182857e-22,  -2.770550961403423e-05,   2.749930467882174e-06,  -3.013516012868618e-07,   2.696999119311736e-08,  -1.786057567660722e-09,
   8.733730814359176e-11,  -3.319180597348991e-12,   1.231873561957780e-13,  -6.410534976582279e-15,   3.891774152878748e-16,  -1.839669391171389e-17,   5.086151399641450e-19,
  -4.817074204607858e-22,  -4.718854256652504e-22,  -2.022192495840148e-05,   2.009081033767043e-06,  -2.202334420567176e-07,   1.970681033771093e-08,  -1.304758436687845e-09,
   6.380855133101506e-11,  -2.428125547602148e-12,   9.039659861662469e-14,  -4.707684087812684e-15,   2.849440968545750e-16,  -1.342079731087532e-17,   3.696690787690771e-19,
  -3.597280922667300e-22,  -3.362918634164877e-22,  -1.309407379863489e-05,   1.301747024818753e-06,  -1.427252229666548e-07,   1.276982328266907e-08,  -8.453419147830162e-10,
   4.134387468117466e-11,  -1.574614543896459e-12,   5.874059661724421e-14,  -3.060584888320118e-15,   1.848853642914265e-16,  -8.687343522966244e-18,   2.387062943801868e-19,
  -2.369182706472930e-22,  -2.142720865922306e-22,  -7.025410398135791e-06,   6.986595493438923e-07,  -7.660992225425527e-08,   6.854000026805096e-09,  -4.536884373792838e-10,
   2.218973370512539e-11,  -8.454844312471478e-13,   3.157340203111313e-14,  -1.645485762654727e-15,   9.930136049222987e-17,  -4.660261255530055e-18,   1.278929642603681e-19,
  -1.282969839651192e-22,  -1.140038248288664e-22,  -2.614528902200707e-06,   2.600379836214645e-07,  -2.851490720299197e-08,   2.551069680926528e-09,  -1.688589748391279e-10,
   8.258933924042152e-12,  -3.147341014852453e-13,   1.175754034455718e-14,  -6.128103631342848e-16,   3.696879716564712e-17,  -1.734228808470883e-18,   4.757240570101555e-20,
  -4.790422797031287e-23,  -4.230245721788319e-23,  -2.953346389104625e-07,   2.937416803648606e-08,  -3.221092870701521e-09,   2.881722925951077e-10,  -1.907445683815382e-11,
   9.329382336417324e-13,  -3.555357036659024e-14,   1.328252928285574e-15,  -6.923030496127112e-17,   4.176200875175068e-18,  -1.958949643721555e-19,   5.373314125989643e-21,
  -5.414075286964091e-24,  -4.776213775851924e-24,  -5.134566340457655e-03,   2.217252476237828e-04,  -7.448474232923015e-06,   1.922339206986831e-07,  -2.672619940544248e-09,
  -3.831212294262175e-11,   1.621097391885113e-12,   1.572449146723825e-13,  -1.591884997183422e-14,   6.200539876664094e-16,  -2.939860747311587e-18,  -1.012595183331745e-18,
   5.704659056293883e-20,  -1.009347677053883e-21,  -4.885041483640745e-03,   2.109575824250448e-04,  -7.086653086421453e-06,   1.828725212457932e-07,  -2.541950724168070e-09,
  -3.634737052188556e-11,   1.528978662533105e-12,   1.502485471719152e-13,  -1.514758820434898e-14,   5.882184429828823e-16,  -2.686683334905948e-18,  -9.654868616617401e-19,
   5.411621359656507e-20,  -9.458142896025722e-22,  -4.410326731786996e-03,   1.904693048606850e-04,  -6.398235117138802e-06,   1.650706270902577e-07,  -2.293684501043197e-09,
  -3.265077954719092e-11,   1.359148365272676e-12,   1.366731219504098e-13,  -1.367912438458920e-14,   5.283401836314820e-16,  -2.250328228111388e-18,  -8.749635990042793e-19,
   4.860387389996932e-20,  -8.308693037574888e-22,  -3.756762883456226e-03,   1.622561138680973e-04,  -5.450334517600690e-06,   1.405771936398587e-07,  -1.952512900070674e-09,
  -2.764210935823762e-11,   1.135850685814099e-12,   1.174718599379520e-13,  -1.165537105878856e-14,   4.472412262445660e-16,  -1.736987188119933e-18,  -7.486347079473082e-19,
   4.113783590959768e-20,  -6.840736178166480e-22,  -2.988230875493152e-03,   1.290724355263542e-04,  -4.335536602815554e-06,   1.117944750313516e-07,  -1.552109679377794e-09,
  -2.185523296189810e-11,   8.865862894907151e-13,   9.424963053650015e-14,  -9.273338712488294e-15,   3.535771297406416e-16,  -1.243314303066902e-18,  -5.980005852979520e-19,
   3.251675641185487e-20,  -5.259004478058097e-22,  -2.179941823365829e-03,   9.416512414305517e-05,  -3.162927005649465e-06,   8.154076723975836e-08,  -1.131712348838494e-09,
  -1.586565302714572e-11,   6.368411190498834e-13,   6.922992619614578e-14,  -6.766234014353787e-15,   2.566595185027368e-16,  -8.260069455484861e-19,  -4.376963423712330e-19,
   2.359955693685254e-20,  -3.729608599889177e-22,  -1.411068347744261e-03,   6.095513358511342e-05,  -2.047399471545115e-06,   5.277492083635043e-08,  -7.323128845150093e-10,
  -1.023633594577160e-11,   4.079769955612415e-13,   4.501446743217423e-14,  -4.380252135584054e-15,   1.655872250452080e-16,  -5.001182384354669e-19,  -2.839299071893644e-19,
   1.522352939522902e-20,  -2.368527225248884e-22,  -7.569520162874868e-04,   3.269936698634393e-05,  -1.098318145623791e-06,   2.830883879048386e-08,  -3.927752111356622e-10,
  -5.481938483778560e-12,   2.176845174075772e-13,   2.420312595546714e-14,  -2.349867162610958e-15,   8.867646323508014e-17,  -2.587795329411263e-19,  -1.524777532027808e-19,
   8.152012528318852e-21,  -1.258012185404833e-22,  -2.816848099261274e-04,   1.216851190216624e-05,  -4.087192295893886e-07,   1.053435972103473e-08,  -1.461550478759668e-10,
  -2.038798977431676e-12,   8.085544182060757e-14,   9.013915342392698e-15,  -8.744732180845951e-16,   3.297963988342196e-17,  -9.506972952644617e-20,  -5.676309747437627e-20,
   3.031732399063221e-21,  -4.665187565066398e-23,  -3.181853175626194e-05,   1.374531390902873e-06,  -4.616810720483076e-08,   1.189935512119634e-09,  -1.650921829094632e-11,
  -2.302770475683820e-13,   9.130546079026999e-15,   1.018322170343815e-15,  -9.877897162315162e-17,   3.724961007854755e-18,  -1.071683704136822e-20,  -6.412226620984306e-21,
   3.424245088541410e-22,  -5.266785407704858e-24,  -1.131012815928494e-03,   5.401419740066517e-05,  -2.589705287406656e-06,   1.428521458378569e-07,  -7.819799966205461e-09,
   3.527483302732203e-10,  -1.107860878196550e-11,   1.451530241206119e-13,   5.837594300679258e-15,  -3.149651610776239e-16,  -3.564980368019536e-18,   1.035214078199330e-18,
  -5.307240166600227e-20,   9.613320166414908e-22,  -1.076079044271814e-03,   5.139987217023615e-05,  -2.465148102264367e-06,   1.360089161524341e-07,  -7.444364337321541e-09,
   3.356796328017319e-10,  -1.053491504670372e-11,   1.377674350173551e-13,   5.548045920452232e-15,  -2.979329212482376e-16,  -3.494306781254150e-18,   9.869285345618471e-19,
  -5.036592205904267e-20,   9.026599665152513e-22,  -9.715567255605910e-04,   4.642188247907496e-05,  -2.227655628392177e-06,   1.229496198966744e-07,  -6.728239831915876e-09,
   3.031765534570517e-10,  -9.502716991378971e-12,   1.238539888000871e-13,   4.999381446844653e-15,  -2.662271131690487e-16,  -3.317775359890034e-18,   8.942054777213509e-19,
  -4.526734666585269e-20,   7.959316369583962e-22,  -8.276318443453053e-04,   3.956007986094079e-05,  -1.899667676026512e-06,   1.048922126370204e-07,  -5.738697260250729e-09,
   2.583694265320680e-10,  -8.085828939726930e-12,   1.049625907297943e-13,   4.248446754081782e-15,  -2.239329401267172e-16,  -2.993506587631107e-18,   7.649172877680960e-19,
  -3.834700085343776e-20,   6.584510360079512e-22,  -6.583591030745403e-04,   3.148063056954424e-05,  -1.512690734318118e-06,   8.355954861480710e-08,  -4.570510688015758e-09,
   2.056066866239611e-10,  -6.424990361704192e-12,   8.307818849175140e-14,   3.371320086847321e-15,  -1.759227771832258e-16,  -2.509921114279032e-18,   6.108787068908058e-19,
  -3.033680122962045e-20,   5.087092944186156e-22,  -4.803015618580492e-04,   2.297333292129448e-05,  -1.104488301754173e-06,   6.103118790787751e-08,  -3.337632942295344e-09,
   1.500462322847224e-10,  -4.683159185064141e-12,   6.036590378060961e-14,   2.454583832304611e-15,  -1.270421223935145e-16,  -1.906469454464816e-18,   4.470529816274875e-19,
  -2.203293084449708e-20,   3.622914061229185e-22,  -3.109070987123861e-04,   1.487394568809023e-05,  -7.153448266149875e-07,   3.953680359305721e-08,  -2.161892527464631e-09,
   9.714753093296601e-11,  -3.029712473152160e-12,   3.897233462000722e-14,   1.586741978359057e-15,  -8.167914306744742e-17,  -1.266250519470129e-18,   2.899717623638045e-19,
  -1.421964340136076e-20,   2.307460169685056e-22,  -1.667853387510138e-04,   7.979898420726251e-06,  -3.838527969265952e-07,   2.121777045566613e-08,  -1.160124041523779e-09,
   5.212008851410837e-11,  -1.624793431273943e-12,   2.087818541547956e-14,   8.506051722274188e-16,  -4.366291501203904e-17,  -6.881241442062243e-19,   1.557150686041313e-19,
  -7.616304913178475e-21,   1.227454596433471e-22,  -6.206622950751457e-05,   2.969683383619771e-06,  -1.428580351571431e-07,   7.896901587691608e-09,  -4.317692436603657e-10,
   1.939629061082703e-11,  -6.045750637538965e-13,   7.765772753716199e-15,   3.164598504441533e-16,  -1.622847598680352e-17,  -2.572184482365378e-19,   5.796732821359112e-20,
  -2.832744662188904e-21,   4.554323550045556e-23,  -7.010878708877814e-06,   3.354514447529631e-07,  -1.613721193535154e-08,   8.920377951312859e-10,  -4.877268813962307e-11,
   2.190979523513422e-12,  -6.829047198329985e-14,   8.771404785174527e-16,   3.574528142629029e-17,  -1.832779680224001e-18,  -2.907541053974820e-20,   6.548245642118930e-21,
  -3.199538183703489e-22,   5.142066530644215e-24,  -3.436718566040913e-05,   2.150469479497965e-06,  -1.757220930981800e-07,   1.519890409448729e-08,  -1.086157209083169e-09,
   5.947075276668499e-11,  -2.414764628456526e-12,   6.929019306486075e-14,  -1.397326465589432e-15,   4.413633541561567e-17,  -3.936124836611744e-18,   2.831464726462095e-19,
  -1.271472125216208e-20,   2.909246994596967e-22,  -3.270106786913595e-05,   2.047259770126670e-06,  -1.673713065270121e-07,   1.447743890750194e-08,  -1.034407614054009e-09,
   5.662157548136109e-11,  -2.298504377897086e-12,   6.597036821187566e-14,  -1.334828291793627e-15,   4.245867363241481e-17,  -3.769475415209501e-18,   2.700218445615511e-19,
  -1.208365427604544e-20,   2.747895222720137e-22,  -2.952969107038864e-05,   1.850380581445681e-06,  -1.514076124844608e-07,   1.309790800523512e-08,  -9.355352416615703e-10,
   5.118448389289912e-11,  -2.076885145531885e-12,   5.963587470759205e-14,  -1.213773069656195e-15,   3.907832656797948e-17,  -3.442371548810023e-18,   2.447877112401336e-19,
  -1.088816153841173e-20,   2.449106070762522e-22,  -2.516032851234119e-05,   1.578306478056501e-06,  -1.292809579743439e-07,   1.118512478831931e-08,  -7.985975629963811e-10,
   4.366673282736781e-11,  -1.770917182582528e-12,   5.087809087034202e-14,  -1.042889384816451e-15,   3.405732306444297e-17,  -2.972568609568464e-18,   2.095393999045709e-19,
  -9.252405437020131e-21,   2.053551764252431e-22,  -2.001833178751186e-05,   1.257076962368687e-06,  -1.030735043677780e-07,   8.918735371058110e-09,  -6.365385456892785e-10,
   3.478567612028766e-11,  -1.410036497372215e-12,   4.053213575182638e-14,  -8.365343871655559e-16,   2.768629773526049e-17,  -2.395545796034091e-18,   1.674582655414181e-19,
  -7.342130682019151e-21,   1.608334732842858e-22,  -1.460657355273450e-05,   9.180196667000914e-07,  -7.533421626834183e-08,   6.519110775716820e-09,  -4.651323480866532e-10,
   2.540703890717646e-11,  -1.029461935454383e-12,   2.960563266582107e-14,  -6.143967966855456e-16,   2.054860591747394e-17,  -1.765813696335724e-18,   1.226195752822267e-19,
  -5.345719614880363e-21,   1.158575101803893e-22,  -9.456073430869206e-06,   5.946462613732041e-07,  -4.882398106615191e-08,   4.225279202286376e-09,  -3.014086227253615e-10,
   1.645896603175955e-11,  -6.667221022281561e-13,   1.917961203449945e-14,  -3.994753450165516e-16,   1.345151447093562e-17,  -1.150798328112371e-18,   7.956548336708402e-20,
  -3.455753282154213e-21,   7.436585365456895e-23,  -5.072962222069749e-06,   3.191059431695654e-07,  -2.620773729105365e-08,   2.268115219045606e-09,  -1.617782968926832e-10,
   8.832835856544049e-12,  -3.577537577489424e-13,   1.029312036547337e-14,  -2.147855831245136e-16,   7.257414085898590e-18,  -6.194786577350283e-19,   4.273533284336181e-20,
  -1.852549671781922e-21,   3.971987621722996e-23,  -1.887849294497332e-06,   1.187638407773487e-07,  -9.754851472936782e-09,   8.442302094864524e-10,  -6.021439661108725e-11,
   3.287433266597962e-12,  -1.331437401173969e-13,   3.830957465557740e-15,  -7.999197380878341e-17,   2.706081461346543e-18,  -2.308046256148840e-19,   1.591000598530389e-20,
  -6.892274257092625e-22,   1.475859429216535e-23,  -2.132483670919338e-07,   1.341558306434521e-08,  -1.101926457580604e-09,   9.536600156484525e-11,  -6.801904559659819e-12,
   3.713500144037681e-13,  -1.503986861871281e-14,   4.327473237414309e-16,  -9.036870452182999e-18,   3.057697526648761e-19,  -2.607619118027329e-20,   1.797284742340516e-21,
  -7.785078461458026e-23,   1.666699165754426e-24,  -4.353311860924087e-03,   1.705973142126369e-04,  -5.414542608946029e-06,   1.461615651274712e-07,  -2.910801539384403e-09,
   1.427982818790594e-11,   1.778926758354325e-12,  -6.589212641394608e-14,  -7.917046306013483e-16,   1.885430566969148e-16,  -9.774874569167661e-18,   2.415788366182432e-19,
   2.152066525647410e-21,  -4.835712418763777e-22,  -4.141727073241924e-03,   1.623124486474904e-04,  -5.151694764570639e-06,   1.390563403048731e-07,  -2.768428719400619e-09,
   1.354507924312011e-11,   1.691665501726680e-12,  -6.248269082065522e-14,  -7.662320911529907e-16,   1.797563144134579e-16,  -9.294532997347637e-18,   2.286891878632090e-19,
   2.107203517853620e-21,  -4.613785724607814e-22,  -3.739203174937979e-03,   1.465483966666332e-04,  -4.651518007636862e-06,   1.255397080665731e-07,  -2.497941301787100e-09,
   1.216401095051526e-11,   1.525967892051716e-12,  -5.608008478055673e-14,  -7.124720813508580e-16,   1.628842317578581e-16,  -8.382693867209407e-18,   2.046305126963908e-19,
   1.997406578089885e-21,  -4.186047382381500e-22,  -3.185049118496568e-03,   1.248407613211595e-04,  -3.962675910809603e-06,   1.069323960367342e-07,  -2.126270741408056e-09,
   1.029496479669934e-11,   1.298468498835314e-12,  -4.742821875420289e-14,  -6.281946213215966e-16,   1.393566348668339e-16,  -7.131352584715044e-18,   1.724104479434183e-19,
   1.798998348713220e-21,  -3.586646157132563e-22,  -2.533440593112146e-03,   9.930889205513407e-05,  -3.152377444748531e-06,   8.505408158332077e-08,  -1.690134261860298e-09,
   8.137794663971874e-12,   1.031763383565149e-12,  -3.746145043737638e-14,  -5.161177139501992e-16,   1.113159114687956e-16,  -5.665238602322839e-18,   1.356712766472433e-19,
   1.506124063267364e-21,  -2.868817228584058e-22,  -1.848148355359912e-03,   7.245096117125332e-05,  -2.299898336885716e-06,   6.204605294387911e-08,  -1.232287728608673e-09,
   5.906684571108702e-12,   7.520405228373097e-13,  -2.717285977888598e-14,  -3.861627974711114e-16,   8.147923216210844e-17,  -4.128491979006916e-18,   9.810795395225819e-20,
   1.142789412350189e-21,  -2.102038786203524e-22,  -1.196291191376503e-03,   4.689904355466749e-05,  -1.488805563085106e-06,   4.016146096606214e-08,  -7.973643097720626e-10,
   3.810619240335346e-12,   4.865162179705015e-13,  -1.752223186165480e-14,  -2.540867289374468e-16,   5.285754321723412e-17,  -2.670464437390838e-18,   6.313398446164395e-20,
   7.585335397034861e-22,  -1.364538625342650e-22,  -6.417348543864168e-04,   2.515896987150877e-05,  -7.986780169358387e-07,   2.154397244933641e-08,  -4.276571207500248e-10,
   2.040656702893595e-12,   2.609094840305155e-13,  -9.381226561348152e-15,  -1.374379515515236e-16,   2.838680357945123e-17,  -1.432014243504706e-18,   3.376521735932674e-20,
   4.120831201355319e-22,  -7.330580194187201e-23,  -2.388087066311839e-04,   9.362480264495068e-06,  -2.972155233518603e-07,   8.017139909114016e-09,  -1.591338092792630e-10,
   7.589362897016848e-13,   9.708236278669434e-14,  -3.488657244396605e-15,  -5.129193530150849e-17,   1.056772490475750e-17,  -5.328273869879282e-19,   1.255180287226699e-20,
   1.540187253263620e-22,  -2.729308255093968e-23,  -2.697533066666345e-05,   1.057567500066156e-06,  -3.357290633025722e-08,   9.055990285846261e-10,  -1.797523891456238e-11,
   8.571973328813192e-14,   1.096604339745571e-14,  -3.940287866277104e-16,  -5.796467280224842e-18,   1.193782356137360e-18,  -6.018584567283566e-20,   1.417587910255532e-21,
   1.740964520210265e-23,  -3.083216577126002e-24,  -9.479390115819505e-04,   3.847673505316975e-05,  -1.435760449780444e-06,   6.135904271015892e-08,  -3.028420926920871e-09,
   1.467812492167447e-10,  -5.967849255886300e-12,   1.757802681689778e-13,  -2.374188449604953e-15,  -8.657117819139952e-17,   6.535399671199552e-18,  -1.592944414683042e-19,
  -3.140274978441157e-21,   4.469805925112680e-22,  -9.018744358273389e-04,   3.661077111043599e-05,  -1.366471325289849e-06,   5.841849288510440e-08,  -2.883786252299573e-09,
   1.397510597608811e-10,  -5.679497761354993e-12,   1.671358939333061e-13,  -2.250019902152798e-15,  -8.261067593543947e-17,   6.210765242698891e-18,  -1.504943477092065e-19,
  -3.040418036854963e-21,   4.263909303286304e-22,  -8.142367529688342e-04,   3.305924362466405e-05,  -1.234454023044652e-06,   5.280740653696625e-08,  -2.607591230724440e-09,
   1.263343377951486e-10,  -5.130227547982862e-12,   1.507313086736957e-13,  -2.017381391562020e-15,  -7.497319237171400e-17,   5.595874237464344e-18,  -1.341795649680908e-19,
  -2.828853391107322e-21,   3.867412810858633e-22,  -6.935795796643841e-04,   2.816661126550457e-05,  -1.052317561745870e-06,   4.504979682727760e-08,  -2.225339364911512e-09,
   1.077815891214206e-10,  -4.372694049623632e-12,   1.282263557705000e-13,  -1.704040982208757e-15,  -6.426149389357331e-17,   4.754732264267146e-18,  -1.125498355243434e-19,
  -2.495854091831130e-21,   3.312436529144077e-22,  -5.516951707642373e-04,   2.240943129580935e-05,  -8.376576640830046e-07,   3.588629566618121e-08,  -1.773312569165869e-09,
   8.586250854872174e-11,  -3.480240909510307e-12,   1.018644503541460e-13,  -1.344350270920551e-15,  -5.142009384530977e-17,   3.772688402322201e-18,  -8.817316757699410e-20,
  -2.051663516713010e-21,   2.648586297478313e-22,  -4.024685792395116e-04,   1.635079540846150e-05,  -6.114411931396473e-07,   2.621023925898559e-08,  -1.295538997400599e-09,
   6.271388778119087e-11,  -2.540084520345906e-12,   7.423428463629777e-14,  -9.742081747128515e-16,  -3.768897193119755e-17,   2.746624146254633e-18,  -6.352651731054283e-20,
  -1.535633445907492e-21,   1.940154949522967e-22,  -2.605172491845412e-04,   1.058505541331256e-05,  -3.959386951726044e-07,   1.697899746486802e-08,  -8.394066839328693e-10,
   4.062712675172134e-11,  -1.644705809910616e-12,   4.801867887049412e-14,  -6.278210237890654e-16,  -2.447137625552899e-17,   1.775461968967769e-18,  -4.077910485040312e-20,
  -1.010629859729672e-21,   1.259235189203633e-22,  -1.397518232435151e-04,   5.678579237184946e-06,  -2.124396698653071e-07,   9.111834703010168e-09,  -4.505133377981326e-10,
   2.180296617421021e-11,  -8.824267244326854e-13,   2.575001450944671e-14,  -3.360222167041456e-16,  -1.314810051669689e-17,   9.517562023053572e-19,  -2.178134857689605e-20,
  -5.467148557691812e-22,   6.764279347120560e-23,  -5.200592242780630e-05,   2.113216083986844e-06,  -7.906078235432268e-08,   3.391261565082166e-09,  -1.676785530170335e-10,
   8.114709795311736e-12,  -3.283961890061625e-13,   9.581185541517775e-15,  -1.249449509132995e-16,  -4.895483510221055e-18,   3.540902034906698e-19,  -8.093299518632719e-21,
  -2.040412833039094e-22,   2.518388269423852e-23,  -5.874481630774313e-06,   2.387053020350688e-07,  -8.930641198479317e-09,   3.830783217827142e-10,  -1.894113902593398e-11,
   9.166416584804054e-13,  -3.709528254050622e-14,   1.082249757594639e-15,  -1.411174607658624e-17,  -5.530316095641651e-19,   3.999573109284408e-20,  -9.139835868638044e-22,
  -2.305869178190713e-23,   2.844933102213998e-24,  -2.774181566635282e-05,   1.251691710138484e-06,  -6.694554554593195e-08,   4.767380852584487e-09,  -3.415220325485415e-10,
   2.056442078857161e-11,  -9.804858623218171e-13,   3.545802983250172e-14,  -8.780688404203249e-16,   9.395372552393530e-18,   2.067148626300996e-19,  -7.750085408522472e-22,
  -1.168153626202529e-21,   9.254064822410203e-23,  -2.639452616977869e-05,   1.191246097090865e-06,  -6.375128922073390e-08,   4.541675942780322e-09,  -3.253503286262534e-10,
   1.958634547939670e-11,  -9.335241937397283e-13,   3.374340372534159e-14,  -8.351026382705274e-16,   8.939214764249539e-18,   1.942474529324876e-19,  -5.188340540283514e-22,
  -1.122154101467054e-21,   8.832750996167199e-23,  -2.383098592927412e-05,   1.076094838899005e-06,  -5.765036409258541e-08,   4.109856197977792e-09,  -2.944115184041150e-10,
   1.771692746995446e-11,  -8.439010149802818e-13,   3.047790382723061e-14,  -7.534849974193950e-16,   8.071712117648041e-18,   1.714842534969153e-19,  -1.194547930131339e-22,
  -1.030250280562292e-21,   8.019368102835818e-23,  -2.030093766553041e-05,   9.172590235227032e-07,  -4.920440815061447e-08,   3.510644182152770e-09,  -2.514815473008621e-10,
   1.512641937495972e-11,  -7.199701391817207e-13,   2.597540125396129e-14,  -6.413546725144409e-16,   6.877519338680821e-18,   1.420266560805478e-19,   2.589272904650695e-22,
  -8.952187842322401e-22,   6.876863612883426e-23,  -1.614903958279918e-05,   7.301000374816534e-07,  -3.921370780547382e-08,   2.800057980480343e-09,  -2.005752019959671e-10,
   1.205895929569713e-11,  -5.735529803137668e-13,   2.067235134824048e-14,  -5.097922750937847e-16,   5.472678991342534e-18,   1.098130619914607e-19,   4.854992276710581e-22,
  -7.256877716297637e-22,   5.505114771719989e-23,  -1.178153473057605e-05,   5.329015427350160e-07,  -2.865100912126122e-08,   2.047137389848443e-09,  -1.466390120337446e-10,
   8.812989206463395e-12,  -4.189227389776253e-13,   1.508702693585748e-14,  -3.716904189037719e-16,   3.993930580784868e-18,   7.823502226420514e-20,   5.189918458590383e-22,
  -5.373839044857601e-22,   4.036455038462914e-23,  -7.626427985731901e-06,   3.450680559203948e-07,  -1.856463933902288e-08,   1.327017789389973e-09,  -9.505479629860645e-11,
   5.711403493003774e-12,  -2.713854574060638e-13,   9.768496911592148e-15,  -2.405059603030709e-16,   2.586025528613648e-18,   4.983365066647040e-20,   4.066049926738156e-22,
  -3.512605862991724e-22,   2.621458467120104e-23,  -4.091191239193528e-06,   1.851418086131476e-07,  -9.964018240919181e-09,   7.123913678183375e-10,  -5.102854589622969e-11,
   3.065689391158963e-12,  -1.456418551980556e-13,   5.240951540216369e-15,  -1.289927127603873e-16,   1.387473443040521e-18,   2.650927154192263e-20,   2.376134111969575e-22,
  -1.893699044785343e-22,   1.408632617078376e-23,  -1.522466520537482e-06,   6.890127152246306e-08,  -3.708590133046045e-09,   2.651707598493246e-10,  -1.899412157359359e-11,
   1.141078263919426e-12,  -5.420553985877847e-14,   1.950414136566255e-15,  -4.799899619443283e-17,   5.163515721129835e-19,   9.835906804305089e-21,   9.094981506828611e-23,
  -7.059201737742391e-23,   5.245026368420845e-24,  -1.719748414994186e-07,   7.783023346455582e-09,  -4.189267776892351e-10,   2.995436361420518e-11,  -2.145623535213835e-12,
   1.288981755038437e-13,  -6.123084906428078e-15,   2.203164745554678e-16,  -5.421811415879009e-18,   5.832655641380054e-20,   1.110523548870431e-21,   1.031880119842798e-23,
  -7.976109696608942e-24,   5.925224215447716e-25,  -3.734515131436065e-03,   1.330755933930209e-04,  -3.911211792125019e-06,   1.032134561035665e-07,  -2.335915661440954e-09,
   3.592780785031733e-11,   1.793126013086207e-13,  -3.783777228703777e-14,   1.368651144979179e-15,  -1.229372229400100e-17,  -3.453172154464585e-03,   1.230576925925578e-04,
  -3.616991015415113e-06,   9.544866255037358e-08,  -2.159705100259085e-09,   3.318456175014972e-11,   1.674592488460380e-13,  -3.500303563623932e-14,   1.262544100756065e-15,
  -1.112513185148774e-17,  -2.933213980222473e-03,   1.045388062556509e-04,  -3.072970732759489e-06,   8.109172376902865e-08,  -1.834184306700677e-09,   2.813678783343874e-11,
   1.445478215806791e-13,  -2.975406360357353e-14,   1.068232979972736e-15,  -9.111380115147983e-18,  -2.253682016332137e-03,   8.032899229938717e-05,  -2.361554471608186e-06,
   6.231769489442210e-08,  -1.408995943400842e-09,   2.157677095378773e-11,   1.129338068427876e-13,  -2.287810547568615e-14,   8.173051955032839e-16,  -6.723971385680079e-18,
  -1.517989614518983e-03,   5.411087933155192e-05,  -1.590909356718852e-06,   4.198122095175245e-08,  -9.489011339897919e-10,   1.451117639362258e-11,   7.705817825053448e-14,
  -1.541860494570646e-14,   5.486619825366308e-16,  -4.382110498505651e-18,  -8.381889973557924e-04,   2.987986190757804e-05,  -8.785363399048832e-07,   2.318286680270097e-08,
  -5.239097986893966e-10,   8.005608744865711e-12,   4.286435496016556e-14,  -8.516460341746208e-15,   3.023653343827275e-16,  -2.372805501796071e-18,  -3.178509267787485e-04,
   1.133099211696823e-05,  -3.331629525600590e-07,   8.791505894532860e-09,  -1.986661635563469e-10,   3.034817387615724e-12,   1.629948928477172e-14,  -3.229929515003268e-15,
   1.145762740332694e-16,  -8.931173605751557e-19,  -3.623934853161492e-05,   1.291891778030578e-06,  -3.798535260547938e-08,   1.002357379193919e-09,  -2.265053474206845e-11,
   3.459917156089809e-13,   1.859211547096825e-15,  -3.682634369534958e-16,   1.306166930210678e-17,  -1.017013500765400e-19,  -8.104418285782213e-04,   2.919078031835608e-05,
  -9.112031503951889e-07,   3.000089590354380e-08,  -1.173555968165638e-09,   5.242349329282601e-11,  -2.292586517421814e-12,   8.607941830979102e-14,  -2.470196563210695e-15,
   4.033525381185996e-17,  -7.493894838037834e-04,   2.699431172748921e-05,  -8.428273703012885e-07,   2.776260768366887e-08,  -1.086610966293941e-09,   4.855128514453664e-11,
  -2.122793017174382e-12,   7.965292918065340e-14,  -2.282762757917195e-15,   3.712121848603432e-17,  -6.365550575546944e-04,   2.293335906853079e-05,  -7.162970681908595e-07,
   2.361279354605623e-08,  -9.250417375294438e-10,   4.134837342007349e-11,  -1.807225593631386e-12,   6.774033128134235e-14,  -1.937152103514864e-15,   3.128683783794118e-17,
  -4.890890191437539e-04,   1.762344443554046e-05,  -5.506622440327059e-07,   1.816738029458154e-08,  -7.124094946089502e-10,   3.185709634992730e-11,  -1.391864851464478e-12,
   5.211279566317722e-14,  -1.486819622745553e-15,   2.383864101757694e-17,  -3.294325267441659e-04,   1.187204190323512e-05,  -3.710676088691534e-07,   1.225004440822775e-08,
  -4.807369204690825e-10,   2.150423921251966e-11,  -9.392605957095890e-13,   3.513575616636434e-14,  -1.000627817196460e-15,   1.595052470599026e-17,  -1.819034862642722e-04,
   6.555900248499162e-06,  -2.049447659748017e-07,   6.768331812377902e-09,  -2.657314602475377e-10,   1.188885464864040e-11,  -5.191913639655412e-13,   1.941193630708239e-14,
  -5.522492732993366e-16,   8.773516442555781e-18,  -6.897998115518977e-05,   2.486145514366562e-06,  -7.772485358982884e-08,   2.567230551513061e-09,  -1.008087106230454e-10,
   4.510505622355281e-12,  -1.969629890452371e-13,   7.362795017823496e-15,  -2.093810047381946e-16,   3.322189489823774e-18,  -7.864661911530816e-06,   2.834559295798644e-07,
  -8.861835852305556e-09,   2.927107224730220e-10,  -1.149433173109715e-11,   5.142992427072711e-13,  -2.245797695085619e-14,   8.394887941237393e-16,  -2.387157095742259e-17,
   3.786837101185523e-19,  -2.346078309844527e-05,   8.734454099039992e-07,  -3.218684723985358e-08,   1.594278344331956e-09,  -9.970799117016268e-11,   6.108274374330688e-12,
  -3.207591592808357e-13,   1.376029729331655e-14,  -4.633616505578408e-16,   1.111516809844474e-17,  -2.169371223973844e-05,   8.078183307244470e-07,  -2.978730235108523e-08,
   1.476817226117947e-09,  -9.240504387574569e-11,   5.660577888234545e-12,  -2.971500288564202e-13,   1.274049031498419e-14,  -4.286577060594850e-16,   1.026715356396581e-17,
  -1.842771593475953e-05,   6.864258497394039e-07,  -2.533742166606279e-08,   1.258141791885016e-09,  -7.878259546844336e-11,   4.825655511479954e-12,  -2.531818478478238e-13,
   1.084555925494647e-14,  -3.643955452568279e-16,   8.706319904885716e-18,  -1.415902337811274e-05,   5.276022606528539e-07,  -1.949640702231040e-08,   9.696893840432430e-10,
  -6.076914327886512e-11,   3.721919673133390e-12,  -1.951596814207106e-13,   8.352089251585217e-15,  -2.802054069416762e-16,   6.677198829603460e-18,  -9.537172508680067e-06,
   3.554775525843914e-07,  -1.314732489519239e-08,   6.547472448753935e-10,  -4.105800147485653e-11,   2.514478997703335e-12,  -1.317868357791262e-13,   5.635744715620991e-15,
  -1.888554865878159e-16,   4.491043065121015e-18,  -5.266216131510878e-06,   1.963179826873336e-07,  -7.264456145938714e-09,   3.620437500803967e-10,  -2.271132461445993e-11,
   1.390826752249023e-12,  -7.287561165717682e-14,   3.115111849233270e-15,  -1.043185989081644e-16,   2.477763414638546e-18,  -1.997020015330339e-06,   7.445085549709144e-08,
  -2.755462595489023e-09,   1.373640737645884e-10,  -8.618139343085504e-12,   5.277602435624916e-13,  -2.765048385122242e-14,   1.181744676973710e-15,  -3.956423870571357e-17,
   9.393032330913990e-19,  -2.276877598558143e-07,   8.488505772156560e-09,  -3.141735625508672e-10,   1.566275954004064e-11,  -9.826942024142867e-13,   6.017835654945650e-14,
  -3.152820465000238e-15,   1.347437014082585e-16,  -4.510966218230477e-18,   1.070878600283283e-19,  -3.257772783327160e-03,   1.061594523153194e-04,  -2.873214988932415e-06,
   7.154214820904426e-08,  -1.637194691322729e-09,   3.182662530655369e-11,  -3.754459850291236e-13,  -6.147503277732546e-15,   5.784162435642821e-16,  -2.045786920210592e-17,
  -3.012321827911029e-03,   9.816637496210310e-05,  -2.657057581243392e-06,   6.616309494509422e-08,  -1.514023814479650e-09,   2.942165231101913e-11,  -3.464297383915280e-13,
  -5.716283551692929e-15,   5.355044669239020e-16,  -1.890150337514499e-17,  -2.558711116036052e-03,   8.339139351399609e-05,  -2.257390233041155e-06,   5.621547636533042e-08,
  -1.286285621891405e-09,   2.498131976517106e-11,  -2.932452151177746e-13,  -4.900019765437379e-15,   4.557917962657524e-16,  -1.603398650368585e-17,  -1.965912462186043e-03,
   6.407743207297841e-05,  -1.734764685875700e-06,   4.320422900998636e-08,  -9.884849059863059e-10,   1.918559901807378e-11,  -2.244762365685256e-13,  -3.801052303493025e-15,
   3.509444129010656e-16,  -1.230162206669002e-17,  -1.324145277006414e-03,   4.316271808109485e-05,  -1.168647802729965e-06,   2.910703390562976e-08,  -6.659044058857937e-10,
   1.291820610360055e-11,  -1.507559365890254e-13,  -2.579413295676380e-15,   2.367743538507982e-16,  -8.276284009309762e-18,  -7.311493160143934e-04,   2.383404893657446e-05,
  -6.453501480265748e-07,   1.607408324269548e-08,  -3.677247540491744e-10,   7.131632142431017e-12,  -8.310195067477456e-14,  -1.430382995998503e-15,   1.308642325628076e-16,
  -4.566827208662016e-18,  -2.772595956913008e-04,   9.038270155777771e-06,  -2.447323827301839e-07,   6.095767963708112e-09,  -1.394500194005051e-10,   2.704194689566553e-12,
  -3.149312933449462e-14,  -5.432870825953149e-16,   4.964290216933540e-17,  -1.731350683179938e-18,  -3.161136988495493e-05,   1.030488636236977e-06,  -2.790298987710642e-08,
   6.950063233740226e-10,  -1.589929361281605e-11,   3.083113157966470e-13,  -3.590267350652840e-15,  -6.195857927984740e-17,   5.660302966942606e-18,  -1.973892496909109e-19,
  -7.063436887437441e-04,   2.308572939138546e-05,  -6.370470881243736e-07,   1.729879228260834e-08,  -5.203483558384255e-10,   1.877834475197309e-11,  -7.646466752155150e-13,
   3.054286698870447e-14,  -1.072165904150764e-15,   3.024491993848035e-17,  -6.531261938388282e-04,   2.134777190535834e-05,  -5.891633585377599e-07,   1.600309834642667e-08,
  -4.816316361801728e-10,   1.739115531536968e-11,  -7.083292676904795e-13,   2.828824090725887e-14,  -9.924637068828671e-16,   2.796547026540962e-17,  -5.547760917723478e-04,
   1.813506189975890e-05,  -5.006024517685114e-07,   1.360395466841247e-08,  -4.097865288831764e-10,   1.481088476857925e-11,  -6.034706040322552e-13,   2.409338671951908e-14,
  -8.445131824247563e-16,   2.375306193849428e-17,  -4.262471154097626e-04,   1.393514318544137e-05,  -3.847527699238630e-07,   1.046093375975221e-08,  -3.154042954461000e-10,
   1.141102031138652e-11,  -4.651325012669641e-13,   1.856439214094414e-14,  -6.500761975841516e-16,   1.824872688825748e-17,  -2.871002308115450e-04,   9.386892624109913e-06,
  -2.592197546944954e-07,   7.050619957027830e-09,  -2.127368652881509e-10,   7.702644172458254e-12,  -3.140727784602592e-13,   1.253214528009475e-14,  -4.385045151935403e-16,
   1.229068224455712e-17,  -1.585274038606760e-04,   5.183400677249841e-06,  -1.431544561089141e-07,   3.894597149535962e-09,  -1.175605532876111e-10,   4.258480283365034e-12,
  -1.736698552259035e-13,   6.928775347329710e-15,  -2.423325290539480e-16,   6.786228155943818e-18,  -6.011529624382743e-05,   1.965638884801133e-06,  -5.428880651963831e-08,
   1.477083161406002e-09,  -4.459364471195019e-11,   1.615621003174127e-12,  -6.589295752412489e-14,   2.628738022886224e-15,  -9.192420539292329e-17,   2.573367873344280e-18,
  -6.853962834799881e-06,   2.241103252700606e-07,  -6.189722166262888e-09,   1.684115757993628e-10,  -5.084536732472859e-12,   1.842171631529026e-13,  -7.513365576067621e-15,
   2.997359885838371e-16,  -1.048116174061928e-17,   2.933981780368479e-19,  -2.038963064876039e-05,   6.724658004005520e-07,  -1.965593584588458e-08,   6.632262971644415e-10,
  -3.054374409740959e-11,   1.689721570471548e-12,  -9.057884367377260e-14,   4.241586452921197e-15,  -1.668265783461100e-16,   5.334089848446592e-18,  -1.885349255166276e-05,
   6.218626693108590e-07,  -1.818241803680768e-08,   6.139843547221655e-10,  -2.830168875488656e-11,   1.566294195327035e-12,  -8.395718489028580e-14,   3.930301530831107e-15,
  -1.545052107620629e-16,   4.936214638873754e-18,  -1.601455185937095e-05,   5.283068037302594e-07,  -1.545478610044359e-08,   5.225440991130345e-10,  -2.412259258083405e-11,
   1.335855113674073e-12,  -7.159767597246206e-14,   3.350022871107514e-15,  -1.315844708448379e-16,   4.198464129323787e-18,  -1.230441581318357e-05,   4.059807561768348e-07,
  -1.188271468526929e-08,   4.023126700205175e-10,  -1.860149841856130e-11,   1.030794982440687e-12,  -5.524125119484387e-14,   2.583330236042062e-15,  -1.013805565788631e-16,
   3.230284471385333e-18,  -8.287719729884979e-06,   2.734872308978467e-07,  -8.008132484955559e-09,   2.714201498761891e-10,  -1.256499574210135e-11,   6.966467237922063e-13,
  -3.733062708109431e-14,   1.745013806644973e-15,  -6.843418221149982e-17,   2.178146715291323e-18,  -4.576221107468872e-06,   1.510227029120145e-07,  -4.423262525753846e-09,
   1.500101434850395e-10,  -6.949436539211594e-12,   3.854158692224205e-13,  -2.065189267866602e-14,   9.651347542244903e-16,  -3.783457045244060e-17,   1.203456492280770e-18,
  -1.735353963434322e-06,   5.727113609723196e-08,  -1.677552828886806e-09,   5.690552077558790e-11,  -2.636933445557955e-12,   1.462607419250135e-13,  -7.836995285410960e-15,
   3.662166414666760e-16,  -1.435402983189376e-17,   4.564709173237984e-19,  -1.978540281264172e-07,   6.529722020484401e-09,  -1.912677374409766e-10,   6.488383940230466e-12,
  -3.006771991411951e-13,   1.667773812714830e-14,  -8.936296306646226e-16,   4.175798035635135e-17,  -1.636682605875829e-18,   5.204593013373795e-20,  -2.874238323814214e-03,
   8.620746934051304e-05,  -2.152546516752377e-06,   4.992111201846029e-08,  -1.096415547123933e-09,   2.226407195061023e-11,  -3.787705417067684e-13,   3.411946869961157e-15,
   1.002037596278022e-16,  -7.038657951317675e-18,  -2.657667165857413e-03,   7.971556053776684e-05,  -1.990572280287795e-06,   4.616773056381012e-08,  -1.014014190916075e-09,
   2.058884922620751e-11,  -3.500921900290443e-13,   3.143538286035134e-15,   9.312818883811768e-17,  -6.520501574062004e-18,  -2.257438574169773e-03,   6.771609956100373e-05,
  -1.691108336297202e-06,   3.922648320748175e-08,  -8.616060091100488e-10,   1.749156305487390e-11,  -2.971768224900673e-13,   2.654331376437886e-15,   7.976566459617708e-17,
  -5.555527762315549e-18,  -1.734419101212011e-03,   5.203140672631271e-05,  -1.299548324232677e-06,   3.014745150063650e-08,  -6.622243307543319e-10,   1.344164529571341e-11,
  -2.281662276953119e-13,   2.026446039591700e-15,   6.182478335392447e-17,  -4.282181953754982e-18,  -1.168212150128913e-03,   3.504783537824738e-05,  -8.754378983125371e-07,
   2.031061250685922e-08,  -4.461668361282167e-10,   9.054974383344072e-12,  -1.535962015072004e-13,   1.358050973582179e-15,   4.192805685192429e-17,  -2.891544200239731e-18,
  -6.450449420965667e-04,   1.935287954102873e-05,  -4.834273855425981e-07,   1.121635420489764e-08,  -2.463980909727561e-10,   5.000277295303326e-12,  -8.478335512677756e-14,
   7.476802749913626e-16,   2.324237796504778e-17,  -1.598927552834423e-18,  -2.446074389235707e-04,   7.338906248059180e-06,  -1.833264265629404e-07,   4.253575007798988e-09,
  -9.344239852195465e-11,   1.896217928508316e-12,  -3.214684298764874e-14,   2.832161958309093e-16,   8.826728262897376e-18,  -6.066592818036308e-19,  -2.788857058446546e-05,
   8.367369333830364e-07,  -2.090181557455788e-08,   4.849695285815399e-10,  -1.065381226570458e-11,   2.161957941592239e-13,  -3.665104035323278e-15,   3.228460359571923e-17,
   1.006612386933354e-18,  -6.917363525399085e-20,  -6.230476886492861e-04,   1.870142538361204e-05,  -4.695995418624318e-07,   1.121304978166439e-08,  -2.753489321469769e-10,
   7.666788215666651e-12,  -2.559513637440985e-13,   9.551591764563616e-15,  -3.513313463741176e-16,   1.159088299976635e-17,  -5.761017768423554e-04,   1.729315544699477e-05,
  -4.342730435117393e-07,   1.037117738753468e-08,  -2.547626474354716e-10,   7.097735946943027e-12,  -2.370923886872032e-13,   8.849997040116125e-15,  -3.254812154593726e-16,
   1.073309708546080e-17,  -4.893445402521315e-04,   1.469011726734045e-05,  -3.689542166530806e-07,   8.813556809054421e-09,  -2.166217591655257e-10,   6.040917276241270e-12,
  -2.019836183269420e-13,   7.542520119598606e-15,  -2.773338721855188e-16,   9.138451093930104e-18,  -3.759698736674483e-04,   1.128758993170647e-05,  -2.835375903050149e-07,
   6.775010562333347e-09,  -1.666169072661398e-10,   4.651164205909948e-12,  -1.556733341448663e-13,   5.815652499216083e-15,  -2.137872712486183e-16,   7.038846969749847e-18,
  -2.532333324666229e-04,   7.603239901398669e-06,  -1.910104369158618e-07,   4.565112009023369e-09,  -1.123217572267647e-10,   3.138006991567285e-12,  -1.051116995442641e-13,
   3.928066667320993e-15,  -1.443712048318400e-16,   4.750337895175403e-18,  -1.398264120718288e-04,   4.198403252040256e-06,  -1.054801732604752e-07,   2.521273980744492e-09,
  -6.205116085488570e-11,   1.734364261054631e-12,  -5.812137606338068e-14,   2.172431427238746e-15,  -7.983630886715127e-17,   2.625941833828534e-18,  -5.302356616273568e-05,
   1.592099828737859e-06,  -4.000070098331104e-08,   9.561750780056592e-10,  -2.353484760081078e-11,   6.579259581107362e-13,  -2.205195093157870e-14,   8.243052397516957e-16,
  -3.029176695728531e-17,   9.962066319792379e-19,  -6.045406847890591e-06,   1.815214538137577e-07,  -4.560652984308608e-09,   1.090185152920620e-10,  -2.683376083248492e-12,
   7.501699174166535e-14,  -2.514444028337332e-15,   9.399140155012471e-17,  -3.453995082671222e-18,   1.135890892691347e-19,  -1.797296640085965e-05,   5.407095776305645e-07,
  -1.380828934361917e-08,   3.582481264472306e-10,  -1.134992761172855e-11,   4.835410809301466e-13,  -2.386213966599222e-14,   1.138402866880937e-15,  -4.825778507677475e-17,
   1.757725043200131e-18,  -1.661873733082463e-05,   4.999973323749756e-07,  -1.277041829125702e-08,   3.314580386586992e-10,  -1.051027875253444e-11,   4.481527343365316e-13,
  -2.212325002103339e-14,   1.055387414127293e-15,  -4.472666841345466e-17,   1.628392774762272e-18,  -1.411607992710368e-05,   4.247422216896464e-07,  -1.085085978695222e-08,
   2.818268676546818e-10,  -8.949233783429696e-12,   3.821252143167995e-13,  -1.887418311829248e-14,   9.003096910734674e-16,  -3.813773874206833e-17,   1.387504103749373e-18,
  -1.084558535626777e-05,   3.263687443115530e-07,  -8.339786156772929e-09,   2.167636253363303e-10,  -6.893581758631747e-12,   2.947863426254633e-13,  -1.456874030704307e-14,
   6.948699472093753e-16,  -2.942139768303052e-17,   1.069573067513367e-18,  -7.305017912705807e-06,   2.198425170559822e-07,  -5.618790969394230e-09,   1.461238846248283e-10,
  -4.652591754766813e-12,   1.991871122577706e-13,  -9.848562969133072e-15,   4.697001654628233e-16,  -1.988019278956788e-17,   7.222814992659092e-19,  -4.033572781677443e-06,
   1.213948927207368e-07,  -3.102991685864854e-09,   8.072378715312078e-11,  -2.572008939135909e-12,   1.101866063898075e-13,  -5.449460838045128e-15,   2.598853327247971e-16,
  -1.099738412915582e-17,   3.994151945276323e-19,  -1.529571272511909e-06,   4.603496226557133e-08,  -1.176755942734262e-09,   3.061687647650767e-11,  -9.757608889872659e-13,
   4.181272913970166e-14,  -2.068119369726352e-15,   9.862713959768824e-17,  -4.173202178062969e-18,   1.515472400017255e-19,  -1.743919104519286e-07,   5.248626405361996e-09,
  -1.341674984159575e-10,   3.490845955244372e-12,  -1.112581165380733e-13,   4.767764941267942e-15,  -2.358245088526486e-16,   1.124627104464662e-17,  -4.758562658605461e-19,
   1.728005099219924e-20,  -2.560435416816520e-03,   7.111589708861546e-05,  -1.645555644167941e-06,   3.548337004928406e-08,  -7.332129672030975e-10,   1.450440797525939e-11,
  -2.655522917175560e-13,   4.021542930041740e-15,  -2.793451900799818e-17,  -1.200457010148485e-18,  -2.367496989197254e-03,   6.575971574016101e-05,  -1.521703659552527e-06,
   3.281493378457215e-08,  -6.781167024803486e-10,   1.341473062818113e-11,  -2.455678833545931e-13,   3.716450961522413e-15,  -2.568571595724483e-17,  -1.115734530176691e-18,
  -2.010949501626451e-03,   5.585995642233266e-05,  -1.292738274240911e-06,   2.788045874041858e-08,  -5.762064960839943e-10,   1.139903545669858e-11,  -2.086210831697292e-13,
   3.153875313258410e-15,  -2.161649669176595e-17,  -9.557092051168684e-19,  -1.545024703207394e-03,   4.292057790821917e-05,  -9.933856155728436e-07,   2.142683115613745e-08,
  -4.428781200010941e-10,   8.761676776554757e-12,  -1.603139478500445e-13,   2.420787128746325e-15,  -1.644390944007357e-17,  -7.408100955080998e-19,  -1.040638942236545e-03,
   2.891041821325104e-05,  -6.691753951893025e-07,   1.443510654872760e-08,  -2.983898485025569e-10,   5.903331978790358e-12,  -1.079934855747821e-13,   1.629248181947775e-15,
  -1.098845262597147e-17,  -5.024328562485375e-19,  -5.746012722107276e-04,   1.596374682595523e-05,  -3.695214303540502e-07,   7.971548857921013e-09,  -1.647891246202958e-10,
   3.260224669409519e-12,  -5.963475497265786e-14,   8.992082737197486e-16,  -6.039574643246642e-18,  -2.785295809019938e-19,  -2.178941717653577e-04,   6.053674978037196e-06,
  -1.401299967251780e-07,   3.023032731314113e-09,  -6.249378966084208e-11,   1.236397223170263e-12,  -2.261474618078681e-14,   3.409310421377553e-16,  -2.286297149577570e-18,
  -1.057784550227094e-19,  -2.484288906022232e-05,   6.902023827780965e-07,  -1.597679496660280e-08,   3.446694841671072e-10,  -7.125218739986199e-12,   1.409677349379658e-13,
  -2.578400626587677e-15,   3.886967961246990e-17,  -2.605938927418066e-19,  -1.206315339416845e-20,  -5.549960319567051e-04,   1.541781904146330e-05,  -3.572948369350326e-07,
   7.772644190577442e-09,  -1.669869327114484e-10,   3.773218432416229e-12,  -9.777178314688664e-14,   3.023625493109487e-15,  -1.038669513229513e-16,   3.535686309323331e-18,
  -5.131750257934923e-04,   1.425661807638035e-05,  -3.304053216937960e-07,   7.188389987091054e-09,  -1.544639398438700e-10,   3.491597469109453e-12,  -9.053038175204653e-14,
   2.801336195798211e-15,  -9.625623076772028e-17,   3.276333935831900e-18,  -4.358903795296829e-04,   1.211037901363274e-05,  -2.806933556321627e-07,   6.107825521554723e-09,
  -1.312854107568069e-10,   2.969537448723380e-12,  -7.707251626567020e-14,   2.387207211352211e-15,  -8.206161381311154e-17,   2.792788029868359e-18,  -3.348972574331459e-04,
   9.305148196919449e-06,  -2.156970793088156e-07,   4.694323027481758e-09,  -1.009358742746981e-10,   2.284599913927603e-12,  -5.935916933583268e-14,   1.840441543585245e-15,
  -6.329479818111726e-17,   2.153773373804713e-18,  -2.255673679993339e-04,   6.267763107415692e-06,  -1.453015367794866e-07,   3.162695371518579e-09,  -6.802090213527586e-11,
   1.540412870427747e-12,  -4.005731971084098e-14,   1.242979640350147e-15,  -4.276250345872480e-17,   1.454931807723342e-18,  -1.245497332446134e-04,   3.460933868838302e-06,
  -8.023652257087925e-08,   1.746598172687843e-09,  -3.757015329766069e-11,   8.510804015652084e-13,  -2.214251960470038e-14,   6.873999000938013e-16,  -2.365355743201521e-17,
   8.047212559856833e-19,  -4.723042352452423e-05,   1.312434598398536e-06,  -3.042737002154952e-08,   6.623659440264065e-10,  -1.424860526624957e-11,   3.228121573191305e-13,
  -8.400125922126384e-15,   2.608214738813227e-16,  -8.975595317990719e-18,   3.053520004545511e-19,  -5.384908489238477e-06,   1.496356387508619e-07,  -3.469150208857411e-09,
   7.551944415812483e-11,  -1.624565362778172e-12,   3.680637013825536e-14,  -9.577939171864801e-16,   2.974007575955517e-17,  -1.023451909982076e-18,   3.481793726447195e-20,
  -1.600742485217573e-05,   4.449280827316583e-07,  -1.035712754798281e-08,   2.312213664621564e-10,  -5.523668091216597e-12,   1.649917652395565e-13,  -6.478945805979755e-15,
   2.876169130403502e-16,  -1.236951828563594e-17,   4.793216090068831e-19,  -1.480120867290498e-05,   4.114190544778768e-07,  -9.577850256778943e-09,   2.138646273075190e-10,
  -5.111605011200356e-12,   1.528229353687578e-13,  -6.005930215849522e-15,   2.667014823083504e-16,  -1.146956631803312e-17,   4.443470271834159e-19,  -1.257213616876226e-05,
   3.494839924241834e-07,  -8.137050465532299e-09,   1.817494799307696e-10,  -4.347613022380192e-12,   1.301764792713367e-13,  -5.122668697501326e-15,   2.275944673664542e-16,
  -9.787127453348081e-18,   3.790252594730172e-19,  -9.659252411989679e-06,   2.685311194228911e-07,  -6.253078869479128e-09,   1.397152553800326e-10,  -3.345055197627598e-12,
   1.003169223456918e-13,  -3.953139488500952e-15,   1.757273395654534e-16,  -7.556184273902467e-18,   2.925116927340433e-19,  -6.505913730052503e-06,   1.808778151703846e-07,
  -4.212418446931385e-09,   9.414445396596515e-11,  -2.255562960668345e-12,   6.772791597956309e-14,  -2.671832155014245e-15,   1.188193982798995e-16,  -5.108886426548220e-18,
   1.977112814349859e-19,  -3.592318955833310e-06,   9.987731104435171e-08,  -2.326162971554053e-09,   5.199586874263170e-11,  -1.246243043211616e-12,   3.744794318868906e-14,
  -1.478229673984291e-15,   6.575427227164979e-17,  -2.827148852227306e-18,   1.093895170227558e-19,  -1.362241011195159e-06,   3.787490185825493e-08,  -8.821348711470603e-10,
   1.971915438242318e-11,  -4.727020033864382e-13,   1.420790197090551e-14,  -5.609783117962375e-16,   2.495554354679660e-17,  -1.072967008309370e-18,   4.151299307783577e-20,
  -1.553139417677440e-07,   4.318261495683997e-09,  -1.005759397407942e-10,   2.248285574279059e-12,  -5.389660962087835e-14,   1.620031261791388e-15,  -6.396706774165554e-17,
   2.845665499056764e-18,  -1.223495263721839e-19,   4.733638689639642e-21,  -2.299859082097048e-03,   5.947519812300321e-05,  -1.281592990761481e-06,   2.576250261668847e-08,
  -4.983702193011331e-10,   9.356889048968901e-12,  -1.690041203812635e-13,   2.825089192361120e-15,  -3.871716933768357e-17,   2.157429875973358e-19,  -2.126547379518119e-03,
   5.499523315672728e-05,  -1.185115301535860e-06,   2.382458423102697e-08,  -4.609134193267038e-10,   8.654151155152267e-12,  -1.563116510932383e-13,   2.612456993147386e-15,
  -3.577487696506285e-17,   1.979431412103868e-19,  -1.806275045736701e-03,   4.671528550707048e-05,  -1.006768424248877e-06,   2.024129546440978e-08,  -3.916350408330743e-10,
   7.354088469943789e-12,  -1.328303534113993e-13,   2.219362365318290e-15,  -3.035241368870993e-17,   1.659767759909899e-19,  -1.387762206520372e-03,   3.589358687619732e-05,
  -7.736144975370251e-07,   1.555535745065942e-08,  -3.010061958300980e-10,   5.652849642688380e-12,  -1.021027470141774e-13,   1.705426985095098e-15,  -2.329148776453320e-17,
   1.257585802007207e-19,  -9.347108217368697e-04,   2.417686983295504e-05,  -5.211191818700430e-07,   1.047922554601135e-08,  -2.027989470196511e-10,   3.808840769072317e-12,
  -6.879610744919570e-14,   1.148822145574718e-15,  -1.567264030158901e-17,   8.376712866187520e-20,  -5.161101224652660e-04,   1.334987800734055e-05,  -2.877604896405414e-07,
   5.786880185679579e-09,  -1.119965626633760e-10,   2.103546249065780e-12,  -3.799475682251326e-14,   6.343819677349299e-16,  -8.648991937210071e-18,   4.595406165253728e-20,
  -1.957135437379373e-04,   5.062445392173600e-06,  -1.091240703310753e-07,   2.194531624527725e-09,  -4.247280497694803e-11,   7.977483505888107e-13,  -1.440912860056082e-14,
   2.405701023524120e-16,  -3.279087632262051e-18,   1.738360100394772e-20,  -2.231399232627719e-05,   5.771882808495721e-07,  -1.244167236526448e-08,   2.502081011018519e-10,
  -4.842525780127230e-12,   9.095533390466489e-14,  -1.642857925920883e-15,   2.742837582162206e-17,  -3.738473721347194e-19,   1.981160643493125e-21,  -4.985082103006219e-04,
   1.289215370169271e-05,  -2.779113607157684e-07,   5.600354446677618e-09,  -1.096648217574604e-10,   2.159765706693904e-12,  -4.531528555489922e-14,   1.095234801361478e-15,
  -3.140994274198445e-17,   9.960291992349156e-19,  -4.609418681311651e-04,   1.192105537483150e-05,  -2.569907641867906e-07,   5.179138652531541e-09,  -1.014280264514166e-10,
   1.997974536010023e-12,  -4.193826811206865e-14,   1.014263794559808e-15,  -2.910515327236074e-17,   9.232047589172332e-19,  -3.915209317058161e-04,   1.012625355928935e-05,
  -2.183170746641669e-07,   4.400259776083641e-09,  -8.619034416862411e-11,   1.698411238145877e-12,  -3.567492374616609e-14,   8.636927079339569e-16,  -2.480859569712278e-17,
   7.872838843066046e-19,  -3.008057745499289e-04,   7.780487182641378e-06,  -1.677582945552332e-07,   3.381647351631735e-09,  -6.625115043611177e-11,   1.305988679261220e-12,
  -2.745223587896010e-14,   6.653602876431392e-16,  -1.913144905388432e-17,   6.074194245932297e-19,  -2.026041755119299e-04,   5.240709847063920e-06,  -1.130049524404214e-07,
   2.278159187402491e-09,  -4.463915575098942e-11,   8.802162644453989e-13,  -1.851305807069754e-14,   4.490936706801285e-16,  -1.292347345701368e-17,   4.104737678220845e-19,
  -1.118699649859392e-04,   2.893792621384897e-06,  -6.240108891184230e-08,   1.258065240357828e-09,  -2.465321928208601e-11,   4.862063759443161e-13,  -1.022949079730064e-14,
   2.482742518301054e-16,  -7.147863418703214e-18,   2.270791902730981e-19,  -4.242208477609280e-05,   1.097363431543601e-06,  -2.366365265774299e-08,   4.770917889122230e-10,
  -9.349468118617839e-12,   1.844002737721750e-13,  -3.880156403217808e-15,   9.419092436280092e-17,  -2.712248446341418e-18,   8.617198953208988e-20,  -4.836691711160470e-06,
   1.251144988881231e-07,  -2.697988053864750e-09,   5.439534076807076e-11,  -1.065980024377343e-12,   2.102462730869642e-14,  -4.424100441873070e-16,   1.073985512869018e-17,
  -3.092654470492560e-19,   9.825936233218504e-21,  -1.437769994483398e-05,   3.718740679387712e-07,  -8.025301320435293e-09,   1.628933733368551e-10,  -3.303495134238524e-12,
   7.372196323593352e-14,  -2.072594405610017e-15,   7.492317370407528e-17,  -3.015089515473669e-18,   1.179349268648471e-19,  -1.329423263329399e-05,   3.438629323715366e-07,
  -7.421210353485983e-09,   1.506466883174930e-10,  -3.055849045829386e-12,   6.823456505608164e-14,  -1.920110044468994e-15,   6.946404401478413e-17,  -2.796236014733666e-18,
   1.093724159989598e-19,  -1.129203273580293e-05,   2.920921230130529e-07,  -6.304469049844268e-09,   1.279981389750463e-10,  -2.597429246386487e-12,   5.805315308174912e-14,
  -1.636101726654167e-15,   5.926350659044462e-17,  -2.386781302454749e-18,   9.335393093587888e-20,  -8.675676314864022e-06,   2.244286282357781e-07,  -4.844496392467914e-09,
   9.837357345798396e-11,  -1.997086309565038e-12,   4.468007167014302e-14,  -1.261247899184132e-15,   4.574576873275167e-17,  -1.843311453114963e-18,   7.209468385354739e-20,
  -5.843399581025187e-06,   1.511687101238959e-07,  -3.263361070844877e-09,   6.627561566748437e-11,  -1.345899758613599e-12,   3.013507716782376e-14,  -8.517469963515524e-16,
   3.092504467259710e-17,  -1.246613589816627e-18,   4.875551747955052e-20,  -3.226492861191643e-06,   8.347172465736661e-08,  -1.802028126424176e-09,   3.660026131392347e-11,
  -7.434030491068781e-13,   1.665258804346067e-14,  -4.710186473621001e-16,   1.711182308532859e-17,  -6.899498330118458e-19,   2.698372966893673e-20,  -1.223514776572559e-06,
   3.165355824055162e-08,  -6.833635892506670e-10,   1.387992821935159e-11,  -2.819407710495673e-13,   6.316690269108498e-15,  -1.787167732927150e-16,   6.494121268405438e-18,
  -2.618659099816704e-19,   1.024142993752395e-20,  -1.394972411309081e-07,   3.608940366977321e-09,  -7.791304617453302e-11,   1.582514454264159e-12,  -3.214573845957706e-14,
   7.202237247716502e-16,  -2.037806482890129e-17,   7.405153635192696e-19,  -2.986062050620356e-20,   1.167830975965798e-21,  -2.080680102740092e-03,   5.033641197780469e-05,
  -1.014757156796593e-06,   1.908979073259959e-08,  -3.460710211418804e-10,   6.119345184945265e-12,  -1.056795894118031e-13,   1.760475339651133e-15,  -2.715356313417537e-17,
   3.422567936410746e-19,  -1.923878799582637e-03,   4.654446675762363e-05,  -9.383539194319518e-07,   1.765345205288655e-08,  -3.200531321823173e-10,   5.659680443997499e-12,
  -9.774660931704924e-14,   1.628305642993587e-15,  -2.510976725574057e-17,   3.162160111556669e-19,  -1.634120809160223e-03,   3.953634561936250e-05,  -7.971240512637071e-07,
   1.499782080413468e-08,  -2.719362925518345e-10,   4.809350320420353e-12,  -8.306822401283830e-14,   1.383762113750109e-15,  -2.133142109492458e-17,   2.682428471011978e-19,
  -1.255488740291831e-03,   3.037725636725169e-05,  -6.125063442543851e-07,   1.152536039233009e-08,  -2.089983878274913e-10,   3.696703144865224e-12,  -6.385635010808056e-14,
   1.063707435571793e-15,  -1.639164180765430e-17,   2.058051558152390e-19,  -8.456157427871694e-04,   2.046101479916808e-05,  -4.125864077636056e-07,   7.764109260990066e-09,
  -1.408052798829698e-10,   2.490759521911357e-12,  -4.302823393955419e-14,   7.167452928375766e-16,  -1.104180918558045e-17,   1.384652785031401e-19,  -4.669141380914290e-04,
   1.129800455583357e-05,  -2.278265460387629e-07,   4.287458968284749e-09,  -7.775882956186967e-11,   1.375581585124172e-12,  -2.376438819268387e-14,   3.958530471722627e-16,
  -6.097293958084322e-18,   7.640630134202351e-20,  -1.770578146645593e-04,   4.284338783928380e-06,  -8.639566586214964e-08,   1.625903308462413e-09,  -2.948851329459304e-11,
   5.216731008820139e-13,  -9.012508643224187e-15,   1.501244897527414e-16,  -2.312211311458737e-18,   2.896699931716443e-20,  -2.018698346564757e-05,   4.884732588412338e-07,
  -9.850309302631746e-09,   1.853761270917661e-10,  -3.362121189722871e-12,   5.947855510488045e-14,  -1.027563844090905e-15,   1.711647834036631e-17,  -2.636245718208332e-19,
   3.302498491895872e-21,  -4.509987623472945e-04,   1.091079464773426e-05,  -2.199765466539338e-07,   4.140924473446123e-09,  -7.533378883906282e-11,   1.352715446602326e-12,
  -2.468604583459147e-14,   4.834496638428654e-16,  -1.091056483349205e-17,   2.902383855858675e-19,  -4.170112256504342e-04,   1.008886252131076e-05,  -2.034141272399885e-07,
   3.829367766208867e-09,  -6.967126638146402e-11,   1.251192482836562e-12,  -2.283865960707801e-14,   4.474692401706636e-16,  -1.010514431909697e-17,   2.689751144890491e-19,
  -3.542046019881286e-04,   8.569800260228051e-06,  -1.727987723377667e-07,   3.253327047770173e-09,  -5.919845783741270e-11,   1.063332703394446e-12,  -1.941700631196754e-14,
   3.807075786768442e-16,  -8.606676863735214e-18,   2.293156864143464e-19,  -2.721340363223890e-04,   6.584499269215362e-06,  -1.327778557312043e-07,   2.500094039856694e-09,
  -4.549864924897627e-11,   8.174310283982830e-13,  -1.493279863535004e-14,   2.930128058715193e-16,  -6.631669255197104e-18,   1.768781279380776e-19,  -1.832918278972920e-04,
   4.435079431150958e-06,  -8.943967830122513e-08,   1.684206187270667e-09,  -3.065379536318526e-11,   5.508213698779703e-13,  -1.006561477145270e-14,   1.976288448788116e-16,
  -4.476859675591009e-18,   1.195033103193993e-19,  -1.012061882182251e-04,   2.448927866469398e-06,  -4.938781176197784e-08,   9.300464345030736e-10,  -1.692858525018045e-11,
   3.042214785612372e-13,  -5.560321768738919e-15,   1.092100768484383e-16,  -2.475192217158516e-18,   6.610279597150710e-20,  -3.837824788107712e-05,   9.286628199954525e-07,
  -1.872869293151643e-08,   3.526953706626297e-10,  -6.419865748916872e-12,   1.153748596647759e-13,  -2.108878149766355e-15,   4.142587071368414e-17,  -9.390778290861374e-19,
   2.508355894814045e-20,  -4.375638866812313e-06,   1.058802718190124e-07,  -2.135331908590663e-09,   4.021229997645916e-11,  -7.319590484214236e-13,   1.315451017177358e-14,
  -2.404473512548036e-16,   4.723344974690573e-18,  -1.070763316133329e-19,   2.860182574363143e-21,  -1.300736798020729e-05,   3.146893766050032e-07,  -6.346247444680105e-09,
   1.196882051481654e-10,  -2.199702304478858e-12,   4.124966281144091e-14,  -8.650029435050129e-16,   2.282488876150672e-17,  -7.598899767048305e-19,   2.787513509672352e-20,
  -1.202712503498645e-05,   2.909832279050458e-07,  -5.868434548742552e-09,   1.106840204081862e-10,  -2.034456985100467e-12,   3.816141584908683e-14,  -8.007421705439434e-16,
   2.114893976500775e-17,  -7.046121111051891e-19,   2.585504666698937e-20,  -1.021570362541149e-05,   2.471704455296484e-07,  -4.985201099300735e-09,   9.403549920603178e-11,
  -1.728778222809014e-12,   3.244230073310366e-14,  -6.814359308175693e-16,   1.802538084739867e-17,  -6.012682367962739e-19,   2.207363035858866e-20,  -7.848685994334757e-06,
   1.899103733629229e-07,  -3.830615955438740e-09,   7.226485309938395e-11,  -1.328812413493532e-12,   2.494851964254269e-14,  -5.246030311497473e-16,   1.389929706694662e-17,
  -4.642244154646927e-19,   1.705118975726688e-20,  -5.286365635048819e-06,   1.279167479484237e-07,  -2.580322134369855e-09,   4.868232417048768e-11,  -8.953195497896542e-13,
   1.681603907710261e-14,  -3.539010782446168e-16,   9.388492463005985e-18,  -3.138794089696589e-19,   1.153352996116963e-20,  -2.918913106330467e-06,   7.063208770360359e-08,
  -1.424832818980372e-09,   2.688337089650100e-11,  -4.944598610571176e-13,   9.289059430251796e-15,  -1.955891602252693e-16,   5.192504441338067e-18,  -1.736969635649300e-19,
   6.383969093742058e-21,  -1.106876693694775e-06,   2.678453582291396e-08,  -5.403208857196421e-10,   1.019483018710344e-11,  -1.875178220641046e-13,   3.523051274637901e-15,
  -7.419466915921975e-17,   1.970262882111109e-18,  -6.592234394124823e-20,   2.423083108934516e-21,  -1.261989004438125e-07,   3.053803694680243e-09,  -6.160411209654212e-11,
   1.162356478307437e-12,  -2.137983849953601e-14,   4.016860552939071e-16,  -8.459678754360477e-18,   2.246596765284477e-19,  -7.517077387006370e-21,   2.763063325324732e-22,
  -1.894241407670622e-03,   4.304901597009467e-05,  -8.152682609463884e-07,   1.440907677813595e-08,  -2.455157347933246e-10,   4.087152819659370e-12,  -6.682163387318778e-14,
   1.070824644294349e-15,  -1.658457344654085e-17,   2.381554882340991e-19,  -1.751485447991311e-03,   3.980579203179021e-05,  -7.538763814327644e-07,   1.332468664120133e-08,
  -2.270522950610366e-10,   3.780042932093850e-12,  -6.180488100826501e-14,   9.904799396718568e-16,  -1.533990369229266e-17,   2.202318953377888e-19,  -1.487685175738366e-03,
   3.381194854451630e-05,  -6.403999003128734e-07,   1.131991076498266e-08,  -1.929097199845949e-10,   3.211981410425725e-12,  -5.252281634589774e-14,   8.417950582907854e-16,
  -1.303672085375754e-17,   1.870955237533749e-19,  -1.142977361113428e-03,   2.597869958697305e-05,  -4.920704831663441e-07,   8.698734461587936e-09,  -1.482558954542534e-10,
   2.468777126850511e-12,  -4.037464895166928e-14,   6.471495439904704e-16,  -1.002191075231828e-17,   1.437713605644648e-19,  -7.698324926885982e-04,   1.749815432174978e-05,
  -3.314552144584864e-07,   5.859799323251938e-09,  -9.987893220127545e-11,   1.663351108672749e-12,  -2.720518091111821e-14,   4.360908439250141e-16,  -6.753205897771832e-18,
   9.684897827094588e-20,  -4.250688330384986e-04,   9.661946576447582e-06,  -1.830249723557030e-07,   3.235825165148023e-09,  -5.515647939459998e-11,   9.186069657803454e-13,
  -1.502522427029405e-14,   2.408592260390496e-16,  -3.729828102346960e-18,   5.348040852447624e-20,  -1.611895878959546e-04,   3.663919055391869e-06,  -6.940591909539086e-08,
   1.227093118398894e-09,  -2.091686765032428e-11,   3.483682280874294e-13,  -5.698212049261413e-15,   9.134552964680909e-17,  -1.414522961770254e-18,   2.028084938110155e-20,
  -1.837778871010168e-05,   4.177367875072346e-07,  -7.913237082217844e-09,   1.399059661025923e-10,  -2.384825621168282e-12,   3.971915139502625e-14,  -6.496829856420760e-16,
   1.041480733300049e-17,  -1.612773854610488e-19,   2.312302650006337e-21,  -4.105869541632146e-04,   9.331123182135961e-06,  -1.767178812791357e-07,   3.123824591301489e-09,
  -5.327768849333019e-11,   8.909866948202071e-13,  -1.483391082281361e-14,   2.525957356346656e-16,  -4.632291031976113e-18,   9.761810175406491e-20,  -3.796438367512119e-04,
   8.628135716500922e-06,  -1.634105686614872e-07,   2.888735783293246e-09,  -4.927128823407471e-11,   8.240556867600803e-13,  -1.372141709375386e-14,   2.337099219007030e-16,
  -4.287915167579417e-18,   9.042038416251047e-20,  -3.224637173813559e-04,   7.328935575488951e-06,  -1.388133805629363e-07,   2.454111937060240e-09,  -4.186252188455764e-11,
   7.002424964864987e-13,  -1.166235051366760e-14,   1.987199422457330e-16,  -3.648695309895143e-18,   7.702400652763748e-20,  -2.477464554384075e-04,   5.631033610863494e-06,
  -1.066614456641305e-07,   1.885853802852379e-09,  -3.217264123211726e-11,   5.382374909544365e-13,  -8.966288408856902e-15,   1.528467720075063e-16,  -2.808662827532911e-18,
   5.935868465790168e-20,  -1.668653098275301e-04,   3.792826351810621e-06,  -7.184640906659509e-08,   1.270384400538525e-09,  -2.167461398998684e-11,   3.626511933531188e-13,
  -6.042373001320627e-15,   1.030384613695087e-16,  -1.894593355306416e-18,   4.007657268893468e-20,  -9.213594285437747e-05,   2.094282927412101e-06,  -3.967259378953699e-08,
   7.015162311030180e-10,  -1.196948878000187e-11,   2.002822676245092e-13,  -3.337389706253456e-15,   5.692255468774095e-17,  -1.047029186483549e-18,   2.215940737512060e-20,
  -3.493870523361221e-05,   7.941756959485490e-07,  -1.504446569251585e-08,   2.660298051907370e-10,  -4.539168535368591e-12,   7.595461329180517e-14,  -1.265714800714199e-15,
   2.158964417216866e-17,  -3.971724677817486e-19,   8.407422175490877e-21,  -3.983483989174917e-06,   9.054687046303095e-08,  -1.715277687323908e-09,   3.033116050751860e-11,
  -5.175310215248994e-13,   8.659963297985719e-15,  -1.443113926039002e-16,   2.461589190230141e-18,  -4.528548756377242e-20,   9.586426596674150e-22,  -1.184182426535767e-05,
   2.691223953752616e-07,  -5.097093317588506e-09,   9.014245260310149e-11,  -1.541622459674965e-12,   2.612040556141147e-14,  -4.573125496772949e-16,   9.030843426029309e-18,
  -2.231292415072028e-19,   6.842722453192794e-21,  -1.094938735760957e-05,   2.488472788911129e-07,  -4.713270379628438e-09,   8.335881163955922e-11,  -1.425713731118468e-12,
   2.415976618917568e-14,  -4.231161098560611e-16,   8.361028093154357e-18,  -2.067709290114294e-19,   6.345606376031735e-21,  -9.300243590146567e-06,   2.113765724438152e-07,
  -4.003812653851007e-09,   7.081734600261919e-11,  -1.211360158938064e-12,   2.053193299382930e-14,  -3.597628594615804e-16,   7.116793122207069e-18,  -1.762675169544592e-19,
   5.415825927633184e-21,  -7.145307413416205e-06,   1.624067542690786e-07,  -3.076451694054557e-09,   5.441955542016873e-11,  -9.309893504380189e-13,   1.578350467150158e-14,
  -2.767090601013783e-16,   5.480094524574226e-18,  -1.359479756782134e-19,   4.182173890581333e-21,  -4.812597361983726e-06,   1.093903326446145e-07,  -2.072277316224869e-09,
   3.665923970405060e-11,  -6.272163099232575e-13,   1.063546771887789e-14,  -1.865350844246823e-16,   3.697568258136683e-18,  -9.184342827828244e-20,   2.828120470889056e-21,
  -2.657312035245149e-06,   6.040200359272839e-08,  -1.144283146246143e-09,   2.024355569415577e-11,  -3.463747186296252e-13,   5.873973047039712e-15,  -1.030486204976562e-16,
   2.043730191579851e-18,  -5.080082660190721e-20,   1.565173297679570e-21,  -1.007674519625757e-06,   2.290512088586445e-08,  -4.339300351747999e-10,   7.676789982117794e-12,
  -1.313556101755000e-13,   2.227675167320284e-15,  -3.908427257528079e-17,   7.752971305536614e-19,  -1.927674567262874e-20,   5.940404549559796e-22,  -1.148884965455044e-07,
   2.611496457407454e-09,  -4.947404135419735e-11,   8.752627351557054e-13,  -1.497645385924296e-14,   2.539891281527373e-16,  -4.456274329507708e-18,   8.839996905063957e-20,
  -2.198048459829951e-21,   6.773834571992783e-23,  -1.734081289757132e-03,   3.715741820690124e-05,  -6.634881202455006e-07,   1.105684352408871e-08,  -1.776602592127157e-10,
   2.790444969302632e-12,  -4.312532284406363e-14,   6.571556851097665e-16,  -9.838397768005264e-18,   1.425792604570071e-19,  -1.603391845625628e-03,   3.435787283527491e-05,
  -6.135198444630876e-07,   1.022458169837623e-08,  -1.642962827204007e-10,   2.580701849831216e-12,  -3.988655180600061e-14,   6.078434590133768e-16,  -9.100553847104947e-18,
   1.318827204092950e-19,  -1.361891623076724e-03,   2.918410745466899e-05,  -5.211622354425503e-07,   8.686022256112109e-09,  -1.395857170010793e-10,   2.192781077485559e-12,
  -3.389477715328202e-14,   5.165902177197558e-16,  -7.734904475292689e-18,   1.120870106231891e-19,  -1.046326966013617e-03,   2.242278799759419e-05,  -4.004439963049481e-07,
   6.674561654312878e-09,  -1.072711557623574e-10,   1.685326866246466e-12,  -2.605394347589185e-14,   3.971347568734363e-16,  -5.946771653489279e-18,   8.617085147733925e-20,
  -7.047331014074642e-04,   1.510293267673838e-05,  -2.697327329879161e-07,   4.496147572507006e-09,  -7.226572741580964e-11,   1.135456399003096e-12,  -1.755498855277698e-14,
   2.676117111401266e-16,  -4.007519290160215e-18,   5.806813259542736e-20,  -3.891230103324361e-04,   8.339343304628460e-06,  -1.489415508237348e-07,   2.482777196508667e-09,
  -3.990688339198565e-11,   6.270572439045831e-13,  -9.695289900753463e-15,   1.478047912863110e-16,  -2.213475152855534e-18,   3.207207577049324e-20,  -1.475585372092484e-04,
   3.162368000487651e-06,  -5.648079503097378e-08,   9.415172898927120e-10,  -1.513370326114711e-11,   2.378004034417732e-13,  -3.676842517824063e-15,   5.605462249649470e-17,
  -8.394666258515182e-19,   1.216332051062438e-20,  -1.682366305601039e-05,   3.605530264873062e-07,  -6.439590710232346e-09,   1.073462050372628e-10,  -1.725459402925518e-12,
   2.711274215299358e-14,  -4.192155173720278e-16,   6.391093823969700e-18,  -9.571239147311358e-20,   1.386807779365010e-21,  -3.758713550196391e-04,   8.054071649824265e-06,
  -1.438153270178648e-07,   2.396735395840915e-09,  -3.852003266341837e-11,   6.057936266101379e-13,  -9.414210707868184e-15,   1.464104648035170e-16,  -2.337660322640077e-18,
   4.021656831015831e-20,  -3.475437220082800e-04,   7.447255042116304e-06,  -1.329843841504410e-07,   2.216330674840587e-09,  -3.562251819200582e-11,   5.602628162302258e-13,
  -8.707428193289874e-15,   1.354375847287293e-16,  -2.163019766407719e-18,   3.722939275736810e-20,  -2.951972626220849e-04,   6.325813391746679e-06,  -1.129652808035703e-07,
   1.882825536929851e-09,  -3.026486383540123e-11,   4.760512767374431e-13,  -7.399727036228293e-15,   1.151238670499340e-16,  -1.839376692063452e-18,   3.168309421267242e-20,
  -2.267969425753688e-04,   4.860260787619394e-06,  -8.679882618197363e-08,   1.446811774483605e-09,  -2.325849567067127e-11,   3.658873436887021e-13,  -5.688230012841216e-15,
   8.851837315635909e-17,  -1.414927549036025e-18,   2.439174549113227e-20,  -1.527546531305515e-04,   3.273642495940725e-06,  -5.846631628253298e-08,   9.746079635739069e-10,
  -1.566865674116552e-11,   2.465116691102672e-13,  -3.832839422528589e-15,   5.965692608297393e-17,  -9.539280875752383e-19,   1.645512600817169e-20,  -8.434448496151599e-05,
   1.807597852520029e-06,  -3.228404606234098e-08,   5.381795755238105e-10,  -8.652619775820518e-12,   1.361370683477802e-13,  -2.116851305412382e-15,   3.295179615464158e-17,
  -5.270147679481846e-19,   9.094277178227401e-21,  -3.198409883896972e-05,   6.854604015125629e-07,  -1.224257831875167e-08,   2.040881496894435e-10,  -3.281294267970074e-12,
   5.162768042551989e-14,  -8.028014450027366e-16,   1.249726848519941e-17,  -1.998905199753090e-19,   3.449829403378082e-21,  -3.646618570478157e-06,   7.815182239660220e-08,
  -1.395823016599128e-09,   2.326891795108702e-11,  -3.741146692306868e-13,   5.886316448663255e-15,  -9.153160064354615e-17,   1.424888992062627e-18,  -2.279101499747034e-20,
   3.933498945079118e-22,  -1.084058140844841e-05,   2.322893703197506e-07,  -4.147866583518656e-09,   6.913328125778396e-11,  -1.111878887391438e-12,   1.754981825102260e-14,
  -2.770299725419163e-16,   4.554380759103517e-18,  -8.474761432249837e-20,   1.955646399000549e-21,  -1.002357844575092e-05,   2.147880313317783e-07,  -3.835484923069389e-09,
   6.392958280694423e-11,  -1.028245835636402e-12,   1.623108669338950e-14,  -2.562516087055815e-16,   4.214182447294490e-18,  -7.847003378767533e-20,   1.812437108043875e-21,
  -8.513843677623143e-06,   1.824442710270583e-07,  -3.258101918031354e-09,   5.430974655231094e-11,  -8.736018504003609e-13,   1.379184902556394e-14,  -2.177951036888259e-16,
   3.583701161730069e-18,  -6.680397816417307e-20,   1.545292506640367e-21,  -6.541096280872766e-06,   1.401759252222647e-07,  -2.503419208539742e-09,   4.173305123945384e-11,
  -6.713655968283315e-13,   1.060058788564836e-14,  -1.674437200045390e-16,   2.756794171109965e-18,  -5.144987580116627e-20,   1.192010089273524e-21,  -4.405627706201855e-06,
   9.441589438778700e-08,  -1.686263728136846e-09,   2.811242967943496e-11,  -4.522840917036207e-13,   7.142182531086113e-15,  -1.128389781897359e-16,   1.858630560224518e-18,
  -3.471954883894629e-20,   8.053956854726515e-22,  -2.432596273078742e-06,   5.213335570553814e-08,  -9.311244855524084e-10,   1.552372085442395e-11,  -2.497631552377795e-13,
   3.944356506534365e-15,  -6.232408901108362e-17,   1.026844096556246e-18,  -1.919185564922150e-20,   4.455158207812314e-22,  -9.224598345223189e-07,   1.976952503218817e-08,
  -3.530959111258276e-10,   5.886897461602850e-12,  -9.471666231808999e-14,   1.495838649869784e-15,  -2.363654013364515e-17,   3.894713787003211e-19,  -7.280729997435625e-21,
   1.690587896234658e-22,  -1.051728604290393e-07,   2.253995134069605e-09,  -4.025781077841449e-11,   6.711890812712449e-13,  -1.079906160079319e-14,   1.705478058431162e-16,
  -2.694936300411260e-18,   4.440657593106338e-20,  -8.301586041754296e-22,   1.927716823011367e-23,  -1.595290161460013e-03,   3.233582291859624e-05,  -5.461861746344690e-07,
   8.610187115506779e-09,  -1.308765295370637e-10,   1.944922636178972e-12,  -2.845643223232930e-14,   4.113636884569900e-16,  -5.878223429010736e-18,   8.265351670622087e-20,
  -1.475057914922324e-03,   2.989941666607954e-05,  -5.050480252703147e-07,   7.961987728668389e-09,  -1.210295371902422e-10,   1.798689885609589e-12,  -2.631855978972894e-14,
   3.804850200320305e-16,  -5.437340056929727e-18,   7.645756458187235e-20,  -1.252883192122142e-03,   2.539683972164316e-05,  -4.290138105467286e-07,   6.763755642646179e-09,
  -1.028233478695994e-10,   1.528257892825989e-12,  -2.236392144710690e-14,   3.233497532576665e-16,  -4.621348304640349e-18,   6.498802062273659e-20,  -9.625737228997195e-04,
   1.951279551745893e-05,  -3.296355503962007e-07,   5.197328748444411e-09,  -7.901691230479733e-11,   1.174538856017786e-12,  -1.718964674019785e-14,   2.485670966015522e-16,
  -3.552956395554916e-18,   4.996741496343375e-20,  -6.483210348889087e-04,   1.314281845572109e-05,  -2.220348395040149e-07,   3.500986967045566e-09,  -5.323027633101906e-11,
   7.912968588241819e-13,  -1.158182432511453e-14,   1.674922273194489e-16,  -2.394309365079319e-18,   3.367461818208805e-20,  -3.579741740753998e-04,   7.257006964816350e-06,
  -1.226028547350264e-07,   1.933229238191010e-09,  -2.939462664099352e-11,   4.369864160554278e-13,  -6.396278692114767e-15,   9.250574744535911e-17,  -1.322443201688168e-18,
   1.860004845985529e-20,  -1.357465736571007e-04,   2.751930853562444e-06,  -4.649266868527260e-08,   7.331152956852298e-10,  -1.114712882261970e-11,   1.657182138375506e-13,
  -2.425704599723917e-15,   3.508230591474484e-17,  -5.015392963781196e-19,   7.054195661266063e-21,  -1.547693846573904e-05,   3.137575321508091e-07,  -5.300804259334124e-09,
   8.358539652014272e-11,  -1.270931562676858e-12,   1.889429048867020e-14,  -2.765665294038793e-16,   3.999920056091373e-18,  -5.718334538976591e-20,   8.042906198445173e-22,
  -3.457876321478551e-04,   7.008962288917606e-06,  -1.183888913265187e-07,   1.866322728701455e-09,  -2.837020868535997e-11,   4.217457162473783e-13,  -6.180398872592420e-15,
   8.991052741369820e-17,  -1.313309142762211e-18,   1.972756112530134e-20,  -3.197266528777614e-04,   6.480858226035427e-06,  -1.094719691798365e-07,   1.725820719317270e-09,
  -2.623567637965523e-11,   3.900366196945898e-13,  -5.716124243210946e-15,   8.316414586098769e-17,  -1.214942553927218e-18,   1.825475893290073e-20,  -2.715690993724032e-04,
   5.504900633104065e-06,  -9.299113090451670e-08,   1.466095010054660e-09,  -2.228911633265682e-11,   3.313957701075739e-13,  -4.857281049914258e-15,   7.067960347496539e-17,
  -1.032803097061443e-18,   1.552476638011009e-20,  -2.086429769834240e-04,   4.229502633043065e-06,  -7.145034059962775e-08,   1.126560262952888e-09,  -1.712858149030730e-11,
   2.546941697748852e-13,  -3.733518721641533e-15,   5.433625403331350e-17,  -7.941881167470868e-19,   1.194344869786168e-20,  -1.405270344972309e-04,   2.848776088767498e-06,
  -4.812728784258520e-08,   7.588654154865467e-10,  -1.153878941449830e-11,   1.715900435699201e-13,  -2.515551287993001e-15,   3.661508434014611e-17,  -5.352794659113975e-19,
   8.052738014703672e-21,  -7.759280727157386e-05,   1.572995015774238e-06,  -2.657485157243384e-08,   4.190420801188584e-10,  -6.371909241370989e-12,   9.475915390380011e-14,
  -1.389269079658150e-15,   2.022298564135805e-17,  -2.956759323370590e-19,   4.449071764756940e-21,  -2.942379224652895e-05,   5.964957093086007e-07,  -1.007754488297869e-08,
   1.589082952511720e-10,  -2.416376998353018e-12,   3.593550104906521e-14,  -5.268633050248499e-16,   7.669532446840139e-18,  -1.121394523334040e-19,   1.687508009861606e-21,
  -3.354708776510371e-06,   6.800862072995447e-08,  -1.148978846842447e-09,   1.811776807342387e-11,  -2.755014219561063e-13,   4.097170962130019e-15,  -6.007030455562253e-17,
   8.744455377398573e-19,  -1.278572710968350e-20,   1.924059400442635e-22,  -9.972930172502677e-06,   2.021469281915076e-07,  -3.414488116873606e-09,   5.382849513844017e-11,
  -8.183938320148248e-13,   1.217770238141241e-14,  -1.792552732438669e-16,   2.654432127140663e-18,  -4.112785546449603e-20,   7.207707918752834e-22,  -9.221300264017955e-06,
   1.869157701097640e-07,  -3.157312640607379e-09,   4.977614124712797e-11,  -7.568197510500892e-13,   1.126217251924839e-14,  -1.657933315423068e-16,   2.455481294814198e-18,
  -3.805854294912129e-20,   6.674327736723719e-22,  -7.832378644184511e-06,   1.587679759722420e-07,  -2.681984091394525e-09,   4.228513798584499e-11,  -6.429743691806053e-13,
   9.569015035003945e-15,  -1.408883337058222e-16,   2.087177916344619e-18,  -3.236855553566206e-20,   5.682792366645303e-22,  -6.017513778716897e-06,   1.219839591106128e-07,
  -2.060719980781376e-09,   3.249227795071164e-11,  -4.941091160631081e-13,   7.354327924110000e-15,  -1.082972919326615e-16,   1.604811776840041e-18,  -2.490300904383948e-20,
   4.377265976282346e-22,  -4.052968274619682e-06,   8.216213976367708e-08,  -1.388053083561646e-09,   2.188721817301599e-11,  -3.328604803841063e-13,   4.954718697816712e-15,
  -7.297031622670561e-17,   1.081555814044469e-18,  -1.679131123427404e-20,   2.954195259765325e-22,  -2.237869655115542e-06,   4.536707428825498e-08,  -7.664530193906994e-10,
   1.208602495188660e-11,  -1.838111576445638e-13,   2.736212281944944e-15,  -4.030021818936255e-17,   5.974006341990036e-19,  -9.277297421120344e-21,   1.633085518261215e-22,
  -8.486174701425536e-07,   1.720365601581470e-08,  -2.906494026869821e-10,   4.583238258564640e-12,  -6.970550775572088e-14,   1.037654934714891e-15,  -1.528347031201654e-17,
   2.265693393354931e-19,  -3.518860646476403e-21,   6.195508537225560e-23,  -9.675382599029861e-08,   1.961450684313956e-09,  -3.313803308693104e-11,   5.225532636889653e-13,
  -7.947421841594104e-15,   1.183078175609640e-16,  -1.742546422537257e-18,   2.583253216909848e-20,  -4.012133643555267e-22,   7.064229133589741e-24,  -1.474078115017470e-03,
   2.834675728972372e-05,  -4.542547761772873e-07,   6.793809233712872e-09,  -9.797387249060446e-11,   1.381397742049766e-12,  -1.917980875278947e-14,   2.632851225170836e-16,
  -3.580250902344229e-18,   4.820150614695883e-20,  -1.362979036894251e-03,   2.621081553026768e-05,  -4.200379309334969e-07,   6.282284559321116e-09,  -9.060103601183444e-11,
   1.277508006317404e-12,  -1.773839954456972e-14,   2.435144097680144e-16,  -3.311629410229743e-18,   4.458791275427636e-20,  -1.157682651694387e-03,   2.226356919344527e-05,
  -3.567978560711145e-07,   5.336743895078467e-09,  -7.697018159317000e-11,   1.085398186335797e-12,  -1.507236411716915e-14,   2.069368683541057e-16,  -2.814518064507583e-18,
   3.789883099544716e-20,  -8.894298715299285e-04,   1.710534084064960e-05,  -2.741446901172249e-07,   4.100723866811555e-09,  -5.914787310770629e-11,   8.341497614599080e-13,
  -1.158458091204300e-14,   1.590691274479929e-16,  -2.163735360775634e-18,   2.913902754929286e-20,  -5.990552128033695e-04,   1.152122045897873e-05,  -1.846557573102463e-07,
   2.762259301662436e-09,  -3.984451961131091e-11,   5.619577262761921e-13,  -7.805030010528623e-15,   1.071812366361033e-16,  -1.458068651085430e-18,   1.963755956128136e-20,
  -3.307713416016554e-04,   6.361597870349249e-06,  -1.019623797215782e-07,   1.525294201492497e-09,  -2.200252440290507e-11,   3.103308598735507e-13,  -4.310383200282142e-15,
   5.919463533337853e-17,  -8.053138957028831e-19,   1.084668465661112e-20,  -1.254309885892396e-04,   2.412379895660540e-06,  -3.866544157324445e-08,   5.784171495856518e-10,
  -8.343832720426908e-12,   1.176859389111575e-13,  -1.634643296352357e-15,   2.244904302094819e-17,  -3.054144277435635e-19,   4.113672687820064e-21,  -1.430082162640637e-05,
   2.750440550229342e-07,  -4.408391133779460e-09,   6.594760952714368e-11,  -9.513151282264883e-13,   1.341789763141973e-14,  -1.863734906917500e-16,   2.559530804141767e-18,
  -3.482198695900676e-20,   4.690240566895410e-22,  -3.195142748651305e-04,   6.144310575001690e-06,  -9.846216260263358e-08,   1.472597602922890e-09,  -2.123671617546157e-11,
   2.994562923197328e-13,  -4.159551449221932e-15,   5.720484184525164e-17,  -7.833076580264391e-19,   1.078939461427375e-20,  -2.954329585350144e-04,   5.681333826265101e-06,
  -9.104547770917989e-08,   1.361721673028538e-09,  -1.963858915130675e-11,   2.769354321309550e-13,  -3.846959640552101e-15,   5.290970263703603e-17,  -7.245633661261154e-19,
   9.981718453851773e-21,  -2.509338746810481e-04,   4.825747166197884e-06,  -7.733785193208697e-08,   1.156770260417671e-09,  -1.668398093464734e-11,   2.352904512479382e-13,
  -3.268783597630769e-15,   4.496301416216721e-17,  -6.158352898734772e-19,   8.485922336886282e-21,  -1.927886572325607e-04,   3.707673706002626e-06,  -5.942233433019717e-08,
   8.888557503039850e-10,  -1.282083652395438e-11,   1.808254601253871e-13,  -2.512388630522572e-15,   3.456294806254913e-17,  -4.734697448825597e-19,   6.525875792801116e-21,
  -1.298484048961500e-04,   2.497285880447550e-06,  -4.002512745494916e-08,   5.987357788766296e-10,  -8.636660929399704e-12,   1.218202432661488e-13,  -1.692709421266541e-15,
   2.328892459273509e-17,  -3.190713528816931e-19,   4.398683139746306e-21,  -7.169644829810696e-05,   1.378910211492124e-06,  -2.210089361355020e-08,   3.306163974421535e-10,
  -4.769246962805143e-12,   6.727302164230848e-14,  -9.348124586872024e-16,   1.286223292852786e-17,  -1.762331534609792e-19,   2.429816430680004e-21,  -2.718783418428528e-05,
   5.228961874044162e-07,  -8.380942199843203e-09,   1.253752847207846e-10,  -1.808601550425891e-12,   2.551177081377754e-14,  -3.545127833955083e-16,   4.877902463952309e-18,
  -6.683696130814520e-20,   9.215559362164454e-22,  -3.099779180973528e-06,   5.961726343310631e-08,  -9.555424633773253e-10,   1.429452831957802e-11,  -2.062061980235131e-13,
   2.908710589640565e-15,  -4.041970039983756e-17,   5.561550043409597e-19,  -7.620465128995975e-21,   1.050726436495083e-22,  -9.215174934947578e-06,   1.772092949047763e-07,
  -2.839768671062779e-09,   4.247174283828142e-11,  -6.125208802061811e-13,   8.639160227523270e-15,  -1.201458452406220e-16,   1.660922912278478e-18,  -2.318571454512904e-20,
   3.393162069351680e-22,  -8.520640887257177e-06,   1.638564895776109e-07,  -2.625862454819809e-09,   3.927392942621004e-11,  -5.664269514823113e-13,   7.989454951527059e-15,
  -1.111175433121373e-16,   1.536257005038209e-18,  -2.144906474586287e-20,   3.140125174623575e-22,  -7.237233933698631e-06,   1.391803429813640e-07,  -2.230517844659621e-09,
   3.336284981073149e-11,  -4.812086860316155e-13,   6.788031096970887e-15,  -9.441819411639110e-17,   1.305580063334730e-18,  -1.823344614655507e-20,   2.670922244217727e-22,
  -5.560256119087707e-06,   1.069337618597168e-07,  -1.713812505338691e-09,   2.563582706976952e-11,  -3.697858540266140e-13,   5.216750310086888e-15,  -7.257067316914494e-17,
   1.003643956037582e-18,  -1.402081498228794e-20,   2.055112100747194e-22,  -3.744983746721650e-06,   7.202472355786585e-08,  -1.154373435718344e-09,   1.726836719844741e-11,
  -2.491035548439307e-13,   3.514476836944450e-15,  -4.889456022803875e-17,   6.762927837303144e-19,  -9.449949338106952e-21,   1.385812020246239e-22,  -2.067811566812170e-06,
   3.976942631563401e-08,  -6.374166973462196e-10,   9.535433963265315e-12,  -1.375573939222373e-13,   1.940808084134870e-15,  -2.700255276607815e-17,   3.735177014368113e-19,
  -5.219925958704272e-21,   7.657058828161691e-23,  -7.841297489278989e-07,   1.508095394739041e-08,  -2.417165837642299e-10,   3.615996567059608e-12,  -5.216474076391620e-14,
   7.360078150120028e-16,  -1.024030892137494e-17,   1.416548672512498e-19,  -1.979732929114128e-21,   2.904359552549532e-23,  -8.940134967848635e-08,   1.719433466855136e-09,
  -2.755900881018638e-11,   4.122739622784993e-13,  -5.947519492424296e-15,   8.391553353180043e-17,  -1.167547035352104e-18,   1.615082944258218e-20,  -2.257218367094165e-22,
   3.311501810267610e-24,  -1.367477876983837e-03,   2.501412182777460e-05,  -3.812975206896097e-07,   5.424532932782151e-09,  -7.441263445097573e-11,   9.980431391920257e-13,
  -1.318235079308094e-14,   1.721798085186552e-16,  -2.229377280991635e-18,   2.864132957402323e-20,  -1.264411334953617e-03,   2.312922048819445e-05,  -3.525741332735666e-07,
   5.016058720736138e-09,  -6.881194036010017e-11,   9.229673999511739e-13,  -1.219138014618856e-14,   1.592458490666544e-16,  -2.062043910515752e-18,   2.649337523686398e-20,
  -1.073959079244166e-03,   1.964594536384530e-05,  -2.994883948775228e-07,   4.261032160567214e-09,  -5.845796410314620e-11,   7.841496463791308e-13,  -1.035864987393231e-14,
   1.353196606660317e-16,  -1.752416618131502e-18,   2.251778187158679e-20,  -8.251043244395811e-04,   1.509410659358609e-05,  -2.301087699846391e-07,   3.274100584980112e-09,
  -4.492108772552015e-11,   6.026154080241364e-13,  -7.961307968784597e-15,   1.040129123569533e-16,  -1.347141545388317e-18,   1.731224116826938e-20,  -5.557291430551295e-04,
   1.016651789678876e-05,  -1.549932193325968e-07,   2.205415687558041e-09,  -3.026020192059305e-11,   4.059654742145225e-13,  -5.363703485800158e-15,   7.008144882935015e-17,
  -9.077536391188880e-19,   1.166672127951269e-20,  -3.068482957276586e-04,   5.613566052889335e-06,  -8.558305733146238e-08,   1.217801411767989e-09,  -1.670979707672316e-11,
   2.241837942387500e-13,  -2.962088544625902e-15,   3.870408630638371e-17,  -5.013536986080922e-19,   6.443896588662040e-21,  -1.163591407981525e-04,   2.128716883686037e-06,
  -3.245413607135106e-08,   4.618094630591831e-10,  -6.336691148713116e-12,   8.501616249536033e-14,  -1.123316500064843e-15,   1.467805829648012e-17,  -1.901360430016356e-19,
   2.443867292418737e-21,  -1.326650791334239e-05,   2.427025821624586e-07,  -3.700215971370606e-09,   5.265268564383069e-11,  -7.224720836318076e-13,   9.693062414704271e-15,
  -1.280745327305301e-16,   1.673518525990281e-18,  -2.167842700588272e-20,   2.786393173567153e-22,  -2.964081058606233e-04,   5.421944017731750e-06,  -8.264827030877726e-08,
   1.175796945229610e-09,  -1.612939668820116e-11,   2.163365955075098e-13,  -2.857738969229308e-15,   3.734530979141210e-17,  -4.845462442227186e-19,   6.270818768940494e-21,
  -2.740678844832254e-04,   5.013381622036404e-06,  -7.642232297863881e-08,   1.087257945907355e-09,  -1.491541201816603e-11,   2.000631428623475e-13,  -2.642912734670218e-15,
   3.454006529030153e-17,  -4.481819455649509e-19,   5.800766561285049e-21,  -2.327863447073148e-04,   4.258363202835489e-06,  -6.491570620193918e-08,   9.236018454296003e-10,
  -1.267112423621721e-11,   1.699729278557912e-13,  -2.245605834542393e-15,   2.935066115063555e-17,  -3.808918605909947e-19,   4.930622128658658e-21,  -1.788457525066112e-04,
   3.271727927019207e-06,  -4.987730265374483e-08,   7.096790731031406e-10,  -9.736923094177853e-12,   1.306234410866337e-13,  -1.725898493586939e-15,   2.256037568427411e-17,
  -2.928100305709129e-19,   3.791047490358759e-21,  -1.204572486602276e-04,   2.203646855013430e-06,  -3.359560660295284e-08,   4.780358224010233e-10,  -6.559085741606285e-12,
   8.799744351364389e-14,  -1.162775690154755e-15,   1.520070694999025e-17,  -1.973092033847747e-19,   2.554925783326617e-21,  -6.651100076604799e-05,   1.216770314438144e-06,
  -1.855058394731832e-08,   2.639650673184032e-10,  -3.621951815235887e-12,   4.859428639114046e-14,  -6.421395584618259e-16,   8.394957181612218e-18,  -1.089751308408492e-19,
   1.411209977475439e-21,  -2.522146288742346e-05,   4.614107124635390e-07,  -7.034607017340321e-09,   1.000997083007721e-10,  -1.373516986672010e-12,   1.842818255395169e-14,
  -2.435194219692519e-16,   3.183688962060375e-18,  -4.132844524407342e-20,   5.352119612499528e-22,  -2.875586178162976e-06,   5.260707622072204e-08,  -8.020415388947371e-10,
   1.141275546817670e-11,  -1.566002913566206e-13,   2.101077247306384e-15,  -2.776478143208410e-17,   3.629882835185137e-19,  -4.712079635492328e-21,   6.102270252962746e-23,
  -8.548765289982008e-06,   1.563753699972530e-07,  -2.383675550882890e-09,   3.391143888576022e-11,  -4.651960565728332e-13,   6.239837799720308e-15,  -8.245205118841732e-17,
   1.079041604447072e-18,  -1.408115540700272e-20,   1.859489185599155e-22,  -7.904446510228870e-06,   1.445919403729056e-07,  -2.204111740694659e-09,   3.135786477420014e-11,
  -4.301829336705621e-13,   5.770461266986970e-15,  -7.625396860074442e-17,   9.979955828377643e-19,  -1.302479481462789e-20,   1.720290596358132e-22,  -6.713837389324575e-06,
   1.228163034004400e-07,  -1.872247070758232e-09,   2.663782055951997e-11,  -3.654543247389052e-13,   4.902565656480863e-15,  -6.479094916263523e-17,   8.480644428275490e-19,
  -1.106981600082229e-20,   1.462498792384620e-22,  -5.158126012995249e-06,   9.436055841626925e-08,  -1.438521420365801e-09,   2.046802320720913e-11,  -2.808275641163351e-13,
   3.767601992922952e-15,  -4.979632903042547e-17,   6.518732390118144e-19,  -8.510366677286152e-21,   1.124696538431689e-22,  -3.474131529888400e-06,   6.355581895625086e-08,
  -9.689377171108669e-10,   1.378714514821598e-11,  -1.891739491320858e-13,   2.538131610338988e-15,  -3.354895677668560e-17,   4.392231663380923e-19,  -5.734932457634117e-21,
   7.580876116140206e-23,  -1.918257036551540e-06,   3.509311559722370e-08,  -5.350211616096568e-10,   7.613079489963844e-12,  -1.044625702135239e-13,   1.401617136446868e-15,
  -1.852734033481718e-17,   2.425730863351656e-19,  -3.167518392924981e-21,   4.187649446184254e-23,  -7.274172407378558e-07,   1.330763849048029e-08,  -2.028865306482376e-10,
   2.886999576725403e-12,  -3.961430854274860e-14,   5.315287202432095e-16,  -7.026150944480777e-18,   9.199320855953202e-20,  -1.201281716346914e-21,   1.588249081937674e-23,
  -8.293535440668158e-08,   1.517251189618492e-09,  -2.313184302490927e-11,   3.291580043065829e-13,  -4.516589408626246e-15,   6.060190223853980e-17,  -8.010842005219728e-19,
   1.048860931411258e-20,  -1.369648395641171e-22,   1.810867111272259e-24,  -1.273136591288326e-03,   2.220529193958692e-05,  -3.227395578054097e-07,   4.377933302054616e-09,
  -5.726298884090540e-11,   7.323188216620573e-13,  -9.223059368799993e-15,   1.148742305323293e-16,  -1.418660543587018e-18,   1.739656733002698e-20,  -1.177179114363720e-03,
   2.053198803626374e-05,  -2.984258705194534e-07,   4.048237211191106e-09,  -5.295246160962643e-11,   6.772210607767706e-13,  -8.529550861425602e-15,   1.062422908366158e-16,
  -1.312138230737342e-18,   1.609137591023508e-20,  -9.998642533488005e-04,   1.743977729511172e-05,  -2.534909247061515e-07,   3.438844109972420e-09,  -4.498397785243284e-11,
   5.753497124584633e-13,  -7.247060980218325e-15,   9.027593674137695e-17,  -1.115057632964733e-18,   1.367595652469425e-20,  -7.681769281615082e-04,   1.339902783718809e-05,
  -1.947653801975489e-07,   2.642309486167988e-09,  -3.456652764978851e-11,   4.421415770679887e-13,  -5.569648289553458e-15,   6.938714990991948e-17,  -8.571367860483388e-19,
   1.051381128027589e-20,  -5.173862112170893e-04,   9.024776035034277e-06,  -1.311862386488653e-07,   1.779825381122751e-09,  -2.328469117343460e-11,   2.978522724318777e-13,
  -3.752286388517102e-15,   4.674979040913180e-17,  -5.775462523277824e-19,   7.084935033525637e-21,  -2.856768043520388e-04,   4.983128367495486e-06,  -7.243719763929407e-08,
   9.827898881562161e-10,  -1.285777714680935e-11,   1.644790776913721e-13,  -2.072155069453699e-15,   2.581812190132790e-17,  -3.189719782989661e-19,   3.913129051546588e-21,
  -1.083307160363621e-04,   1.889647424061522e-06,  -2.746902494399859e-08,   3.726885145718883e-10,  -4.875911092370989e-12,   6.237433488960930e-14,  -7.858211718045071e-16,
   9.791137355369700e-18,  -1.209675352150192e-19,   1.484051363706935e-21,  -1.235115871724357e-05,   2.154453930573353e-07,  -3.131844251757357e-09,   4.249164448135531e-11,
  -5.559222586984292e-13,   7.111563707401595e-15,  -8.959503256923608e-17,   1.116334928716257e-18,  -1.379213487832690e-20,   1.692049246354623e-22,  -2.759591301844589e-04,
   4.813115179307654e-06,  -6.995551702592579e-08,   9.489404338596122e-10,  -1.241206817184458e-11,   1.587349391919031e-13,  -1.999215834323042e-15,   2.490389136011843e-17,
  -3.077359281374787e-19,   3.782040759956982e-21,  -2.551598364967558e-04,   4.450417654848535e-06,  -6.468539589317952e-08,   8.774770450652633e-10,  -1.147773770206544e-11,
   1.467921396808305e-13,  -1.848889293666767e-15,   2.303256717032006e-17,  -2.846300078755746e-19,   3.498332441310052e-21,  -2.167258969263856e-04,   3.780164523478990e-06,
  -5.494550721293151e-08,   7.453878350011437e-10,  -9.750525022598007e-12,   1.247108572768726e-13,  -1.570893592538868e-15,   1.957119993723916e-17,  -2.418804046362891e-19,
   2.973269370789609e-21,  -1.665064364451473e-04,   2.904310578192559e-06,  -4.221643285935503e-08,   5.727346997874889e-10,  -7.492485351733791e-12,   9.583711696230619e-14,
  -1.207293157484163e-15,   1.504267470597958e-17,  -1.859327658285622e-19,   2.285840539288059e-21,  -1.121462141564305e-04,   1.956168225259808e-06,  -2.843531550995903e-08,
   3.857866617592729e-10,  -5.047085152911738e-12,   6.456145633777181e-14,  -8.133566782281593e-16,   1.013505545316215e-17,  -1.252836736125612e-19,   1.540383630811624e-21,
  -6.192196735399502e-05,   1.080119588238863e-06,  -1.570114816019463e-08,   2.130249598239060e-10,  -2.786994075152670e-12,   3.565193219009182e-14,  -4.491665065084021e-16,
   5.597206968839800e-18,  -6.919287058889464e-20,   8.507880821576747e-22,  -2.348125909995993e-05,   4.095911337362668e-07,  -5.954057370017082e-09,   8.078222701685076e-11,
  -1.056880609019157e-12,   1.352005134597672e-14,  -1.703369461989797e-16,   2.122657670164620e-18,  -2.624086001592675e-20,   3.226619392794865e-22,  -2.677179369210290e-06,
   4.669893530241436e-08,  -6.788439118963802e-10,   9.210290998199614e-12,  -1.204992142649077e-13,   1.541478667024413e-15,  -1.942088722660551e-17,   2.420144770423472e-19,
  -2.991856761722537e-21,   3.678849896964629e-23,  -7.958992301975788e-06,   1.388160148838825e-07,  -2.017601067416068e-09,   2.736858782166420e-11,  -3.579797670952684e-13,
   4.578179749216980e-15,  -5.766520195695034e-17,   7.185985861232590e-19,  -8.894121785265790e-21,   1.099810109302458e-22,  -7.359115725195750e-06,   1.283553832403555e-07,
  -1.865604449292520e-09,   2.530749743984450e-11,  -3.310324964998565e-13,   4.233729850840431e-15,  -5.332921905773357e-17,   6.646031391224441e-19,  -8.226392374958356e-21,
   1.017342672021218e-22,  -6.250634810033353e-06,   1.090244789948375e-07,  -1.584694370810134e-09,   2.149788518380110e-11,  -2.812174996074460e-13,   3.596869314596737e-15,
  -4.531076392159421e-17,   5.647275459275589e-19,  -6.990943429898077e-21,   8.646983027044621e-23,  -4.802245336157494e-06,   8.376380066648005e-08,  -1.217572589927760e-09,
   1.651836033089390e-11,  -2.160927777168863e-13,   2.764102797626438e-15,  -3.482311959726373e-17,   4.340583899901672e-19,  -5.374001839611377e-21,   6.648168356984733e-23,
  -3.234431325290645e-06,   5.641823795394507e-08,  -8.201086262319304e-10,   1.112655319052786e-11,  -1.455643374894543e-13,   1.862060607152007e-15,  -2.346044384506058e-17,
   2.924492167492054e-19,  -3.621109970778900e-21,   4.480281323425926e-23,  -1.785903808166658e-06,   3.115194448078967e-08,  -4.528399568721236e-10,   6.143897090811187e-12,
  -8.038044482236375e-14,   1.028261538164938e-15,  -1.295575412999298e-17,   1.615088847233082e-19,  -1.999915656242188e-21,   2.474625792973638e-23,  -6.772276760432313e-07,
   1.181309958354884e-08,  -1.717221603950522e-10,   2.329856980902713e-12,  -3.048177766538296e-14,   3.899409722329468e-16,  -4.913197758498453e-18,   6.124988555382080e-20,
  -7.584545492557475e-22,   9.385130014935653e-24,  -7.721306403728129e-08,   1.346853307446254e-09,  -1.957867314305847e-11,   2.656359148803469e-13,  -3.475350222829115e-15,
   4.445883206477113e-17,  -5.601759554685023e-19,   6.983396691332706e-21,  -8.647538148869199e-23,   1.070053160986883e-24,  -1.189167147171032e-03,   1.981898080820939e-05,
  -2.752544518620205e-07,   3.567877810741405e-09,  -4.459386466418929e-11,   5.449585262468100e-13,  -6.558485376604145e-15,   7.805936564777239e-17,  -9.212641116075568e-19,
   1.079886592781089e-20,  -1.099537372004451e-03,   1.832545519938359e-05,  -2.545169511786730e-07,   3.299163086736417e-09,  -4.123660666624360e-11,   5.039504110090474e-13,
  -6.065226099691841e-15,   7.219216817671114e-17,  -8.520662305662803e-19,   9.988352409267143e-21,  -9.339158401245713e-04,   1.556549589835822e-05,  -2.161919525400079e-07,
   2.802498543307353e-09,  -3.503059463996765e-11,   4.281338343281911e-13,  -5.153117877253111e-15,   6.134069158630339e-17,  -7.240549850652580e-19,   8.488590006298413e-21,
  -7.175086905629398e-04,   1.195896149216913e-05,  -1.661060859858889e-07,   2.153333835094080e-09,  -2.691769449495192e-11,   3.290021345550304e-13,  -3.960248962179678e-15,
   4.714533699196831e-17,  -5.565493084679745e-19,   6.525500224270409e-21,  -4.832592021122180e-04,   8.054807321021378e-06,  -1.118817998321180e-07,   1.450443990618304e-09,
  -1.813203907789711e-11,   2.216308331210634e-13,  -2.667964923536324e-15,   3.176332876536096e-17,  -3.749937070445125e-19,   4.397141622942916e-21,  -2.668332225032684e-04,
   4.447540979939873e-06,  -6.177763715694657e-08,   8.009066005272321e-10,  -1.001241010618564e-11,   1.223869887466772e-13,  -1.473330856358079e-15,   1.754136084162345e-17,
  -2.071001119405120e-19,   2.428553976959142e-21,  -1.011850616214699e-04,   1.686546609766444e-06,  -2.342676545152079e-08,   3.037150485374343e-10,  -3.796883101879304e-12,
   4.641183717677620e-14,  -5.587267502183801e-16,   6.652254943978898e-18,  -7.854039857537757e-20,   9.210185878686080e-22,  -1.153645740652328e-05,   1.922891270044750e-07,
  -2.670970847245866e-09,   3.462770375382302e-11,  -4.328977195847081e-13,   5.291607779755301e-15,  -6.370291279067796e-17,   7.584549248327535e-19,  -8.954785332290916e-21,
   1.050102705944472e-22,  -2.577583063871199e-04,   4.295869542119528e-06,  -5.966286710600034e-08,   7.733565154520395e-10,  -9.665959239412372e-12,   1.181228197941419e-13,
  -1.421598370642876e-15,   1.692052444865357e-17,  -1.997296452223811e-19,   2.342690248999748e-21,  -2.383305757238989e-04,   3.972139919725035e-06,  -5.516790348642275e-08,
   7.151111681120053e-10,  -8.938255577432776e-12,   1.092340812866692e-13,  -1.314680961732388e-15,   1.564872546309003e-17,  -1.847277381847545e-19,   2.166866314811914e-21,
  -2.024312274614212e-04,   3.373904056163517e-06,  -4.686075609977695e-08,   6.074564835312647e-10,  -7.593069209209343e-12,   9.280041352599283e-14,  -1.116975075868693e-15,
   1.329651085804669e-17,  -1.569751606186070e-19,   1.841519645330999e-21,  -1.555238263498402e-04,   2.592168534137673e-06,  -3.600437801103650e-08,   4.667465760820287e-10,
  -5.834554613331940e-12,   7.131306152867923e-14,  -8.584122816185153e-16,   1.021945924759138e-17,  -1.206601068197375e-19,   1.415654613836007e-21,  -1.047490033497684e-04,
   1.745922344493042e-06,  -2.425097545253384e-08,   3.143914591783247e-10,  -3.930216698107636e-12,   4.803972897111116e-14,  -5.783005052370370e-16,   6.885179989835590e-18,
  -8.129888075960002e-20,   9.539290761589816e-22,  -5.783752072523285e-05,   9.640281716812599e-07,  -1.339063158143122e-08,   1.736007708357531e-10,  -2.170243580770908e-12,
   2.652806793823232e-14,  -3.193550247179021e-16,   3.802354793461262e-18,  -4.489947125814439e-20,   5.268592718232583e-22,  -2.193240048489121e-05,   3.655679513695304e-07,
  -5.077876068807896e-09,   6.583185418548437e-11,  -8.229947728432292e-13,   1.006002667993036e-14,  -1.211080297162536e-16,   1.441976775719687e-18,  -1.702762625157265e-20,
   1.998093126344470e-22,  -2.500588525244036e-06,   4.167969140170868e-08,  -5.789471437611077e-10,   7.505739196292122e-12,  -9.383290210676576e-14,   1.146985741112282e-15,
  -1.380806318409074e-17,   1.644065669193938e-19,  -1.941405280168775e-21,   2.278133577290219e-23,  -7.434058713012658e-06,   1.238980301229584e-07,  -1.720748655819906e-09,
   2.230453073160283e-11,  -2.787779977476357e-13,   3.406816244922819e-15,  -4.100152337141822e-17,   4.880665347358814e-19,  -5.763662158045457e-21,   6.772314957756348e-23,
  -6.873739658952921e-06,   1.145612795272726e-07,  -1.591108513143902e-09,   2.062466496533231e-11,  -2.577901414018918e-13,   3.150453481972226e-15,  -3.791783164753575e-17,
   4.513821839744554e-19,  -5.330760322615697e-21,   6.264099987000011e-23,  -5.838359397177018e-06,   9.730743968960668e-08,  -1.351520417737061e-09,   1.751977457222281e-11,
  -2.189933344116610e-13,   2.676485128297726e-15,  -3.221563348437853e-17,   3.835336872298023e-19,  -4.529911549665140e-21,   5.323655873707445e-23,  -4.485493688110252e-06,
   7.476124960956856e-08,  -1.038409450933108e-09,   1.346153184774527e-11,  -1.682756392270129e-13,   2.056761894156592e-15,  -2.475820723472966e-17,   2.947773737854847e-19,
  -3.481964566211853e-21,   4.092591900211173e-23,  -3.021086893170755e-06,   5.035449450020700e-08,  -6.994272223609413e-10,   9.067427291044269e-12,  -1.133522219209487e-13,
   1.385528599580041e-15,  -1.667926483414376e-17,   1.986011906534049e-19,  -2.346100835689202e-21,   2.757802437201763e-23,  -1.668103468374317e-06,   2.780372874093877e-08,
  -3.862018775768568e-10,   5.006854739872670e-12,  -6.259246025154698e-14,   7.651041774444404e-16,  -9.210795117836986e-18,   1.096779623896861e-19,  -1.295699174856502e-21,
   1.523158589276069e-23,  -6.325567358329222e-07,   1.054341818511133e-08,  -1.464520370054676e-10,   1.898669744397778e-12,  -2.373616864925114e-14,   2.901443292153339e-16,
  -3.492981781734838e-18,   4.159346209821809e-20,  -4.913798951729628e-22,   5.776536376968725e-24,  -7.211997228845415e-08,   1.202092291264417e-09,  -1.669753010382512e-11,
   2.164745334588284e-13,  -2.706254842693107e-15,   3.308056920169835e-17,  -3.982503348684634e-19,   4.742266732178074e-21,  -5.602469922084636e-23,   6.586143453701867e-25,
  -1.114040234167346e-03,   1.777685003149788e-05,  -2.363870639566482e-07,   2.933704549571820e-09,  -3.510750128957573e-11,   4.107789125507133e-13,  -4.733364278887684e-15,
   5.394067123030854e-17,  -6.095504925904846e-19,   6.841852294883872e-21,  -1.030071971790965e-03,   1.643718088196952e-05,  -2.185769675083043e-07,   2.712736189746196e-09,
  -3.246414263453224e-11,   3.798632877726623e-13,  -4.377303003177697e-15,   4.988533125184540e-17,  -5.637523413260795e-19,   6.328150615165942e-21,  -8.749125833235935e-04,
   1.396156171227935e-05,  -1.856626159577784e-07,   2.304331002611203e-09,  -2.757797049685783e-11,   3.227086318153951e-13,  -3.718935067229227e-15,   4.238550888624947e-17,
  -4.790372342481705e-19,   5.377715669932856e-21,  -6.721766053842294e-04,   1.072661983777167e-05,  -1.426486204568215e-07,   1.770542104728838e-09,  -2.119073635505930e-11,
   2.479823330677409e-13,  -2.857980318765693e-15,   3.257561174535279e-17,  -3.681993658310135e-19,   4.133844714488324e-21,  -4.527263931897863e-04,   7.224758003443038e-06,
  -9.608136950353310e-08,   1.192593007553373e-09,  -1.427412964144552e-11,   1.670494759005146e-13,  -1.925340714389294e-15,   2.194664414558727e-17,  -2.480783935572550e-19,
   2.785438339247920e-21,  -2.499742461520110e-04,   3.989214347853759e-06,  -5.305297129237061e-08,   6.585232173674968e-10,  -7.882039744331057e-12,   9.224569291433408e-14,
  -1.063218235117816e-15,   1.211988862424564e-17,  -1.370051742350584e-19,   1.538370346173425e-21,  -9.479199168229984e-05,   1.512744163679752e-06,  -2.011825235633817e-08,
   2.497208183771888e-10,  -2.989001206334074e-12,   3.498147133178807e-14,  -4.031991322236610e-16,   4.596229341649742e-18,  -5.195730429059854e-20,   5.834152755856666e-22,
  -1.080756099369218e-05,   1.724732790071953e-07,  -2.293754785342243e-09,   2.847160846066804e-11,  -3.407877501041621e-13,   3.988381598009591e-15,  -4.597048461084438e-17,
   5.240372518665848e-19,  -5.923906163567717e-21,   6.651821076222315e-23,  -2.414741482625673e-04,   3.853226830218545e-06,  -5.123815388244261e-08,   6.358960732680489e-10,
  -7.609738002923499e-12,   8.903854176880587e-14,  -1.025983883361805e-15,   1.169205383946808e-17,  -1.321303075777776e-19,   1.483350341855046e-21,  -2.232735806200726e-04,
   3.562846414035381e-06,  -4.737772071326796e-08,   5.880000053715804e-10,  -7.036775928508740e-12,   8.233741370101464e-14,  -9.488055660310084e-16,   1.081302834953873e-17,
  -1.222028176137748e-19,   1.371978424700788e-21,  -1.896419576086276e-04,   3.026242786894281e-06,  -4.024335988389620e-08,   4.994760076856254e-10,  -5.977672079435805e-12,
   6.994883432937490e-14,  -8.061005465493683e-16,   9.187385038104461e-18,  -1.038394309239425e-19,   1.165920729339022e-21,  -1.456978556869621e-04,   2.325051923329575e-06,
  -3.091984748996577e-08,   3.837744234395059e-10,  -4.593205040537652e-12,   5.375150666906793e-14,  -6.194836670613518e-16,   7.061014988426488e-18,  -7.981347912521703e-20,
   8.962436774625728e-22,  -9.813085455858730e-05,   1.566004738263197e-06,  -2.082614807047962e-08,   2.585008809800744e-10,  -3.093993674257390e-12,   3.620887393214063e-14,
  -4.173286754276708e-16,   4.757104638071510e-18,  -5.377523140335270e-20,   6.039014812498501e-22,  -5.418324789880834e-05,   8.646834354465450e-07,  -1.149951381234964e-08,
   1.427384118135524e-10,  -1.708474122447665e-12,   1.999475096395074e-14,  -2.304586703063406e-16,   2.627079577981760e-18,  -2.969821846742349e-20,   3.335291467474738e-22,
  -2.054666855969042e-05,   3.278953463872161e-07,  -4.360738243617222e-09,   5.412831631761261e-11,  -6.478819415936346e-13,   7.582422396438697e-15,  -8.739573218518565e-17,
   9.962682654041128e-19,  -1.126263654757510e-20,   1.264884349643650e-22,  -2.342596349492002e-06,   3.738450090928653e-08,  -4.971835543543901e-10,   6.171372650653638e-12,
  -7.386756109131003e-14,   8.645032014116671e-16,  -9.964367088556255e-18,   1.135891284765346e-19,  -1.284108245277433e-21,   1.442160523885685e-23,  -6.964404061313672e-06,
   1.111316833710712e-07,  -1.477769814687932e-09,   1.834000565781608e-11,  -2.194739943697579e-13,   2.567980414321394e-15,  -2.959076043063165e-17,   3.372227107283417e-19,
  -3.811344479149924e-21,   4.280855086539012e-23,  -6.439477860643286e-06,   1.027567638840486e-07,  -1.366430291765388e-09,   1.695862559817122e-11,  -2.029490792850501e-13,
   2.374711696239095e-15,  -2.736483421877529e-17,   3.118698618888099e-19,  -3.524984854304500e-21,   3.959453670247656e-23,  -5.469501515039727e-06,   8.728047167114213e-08,
  -1.160666768268371e-09,   1.440548730100751e-11,  -1.724032508812230e-13,   2.017409930611363e-15,  -2.324902961086349e-17,   2.649830406332070e-19,  -2.995289430239308e-21,
   3.364797808203789e-23,  -4.202100908821458e-06,   6.705728615266298e-08,  -8.917654879055325e-10,   1.106851480105472e-11,  -1.324735567844917e-13,   1.550259201650533e-15,
  -1.786674725956209e-17,   2.036542117791529e-19,  -2.302253944624510e-21,   2.586533730691358e-23,  -2.830211544156391e-06,   4.516545492876593e-08,  -6.006510899321314e-10,
   7.455475541563228e-12,  -8.923449821360002e-14,   1.044308220727752e-15,  -1.203632414357223e-17,   1.372047185324984e-19,  -1.551170930454601e-21,   1.742849110476312e-23,
  -1.562709857087215e-06,   2.493850738576535e-08,  -3.316597712513997e-10,   4.116747046004435e-12,  -4.927444821809802e-14,   5.766730803609853e-16,  -6.646740266680476e-18,
   7.577040656855923e-20,  -8.566590168960928e-22,   9.625614022386915e-24,  -5.925905650487679e-07,   9.456895069828004e-09,  -1.257689213620611e-10,   1.561125582653075e-12,
  -1.868569430927352e-14,   2.186863388726063e-16,  -2.520611334447790e-18,   2.873443773156162e-20,  -3.248760873979428e-22,   3.650445165033699e-24,  -6.756328844229740e-08,
   1.078213845461276e-09,  -1.433937004626380e-11,   1.779897913047120e-13,  -2.130429291737263e-15,   2.493333003779637e-17,  -2.873858485587048e-19,   3.276145466283343e-21,
  -3.704071192726312e-23,   4.162063224032496e-25  };
  int offset = -3;
  for (int i = 1; i <= n; ++i) {
    complex<double> t = ta[i-1];
    offset += 3;
    if (std::isnan(t.real())) {
      fill_n(rr+offset, 3, 0.5);
      fill_n(ww+offset, 3, 0.0);
    } else if (t.real() < -2) {
      throw runtime_error ("ERROR!  Invalid T value!  Real part is too small.  Consider regenerating interpolation files with a larger domain or reducing the magnetic field strength.");
    } else if (t.real() >= 48) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 3; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else if ( fabs(t.imag()) > 5.000000000000000e-01){
      throw runtime_error ("ERROR!  Invalid T value!  Magnitude of imaginary part is too large.  Consider regenerating interpolation files with a larger domain or reducing the magnetic field strength.");
    } else {
      const complex<double> torig = t;
      if (torig.imag() < 0) t = conj(torig);
      int itr = static_cast<int>((t.real()-(-2))*   0.500000000000000) ;
      int iti = static_cast<int>((t.imag()-(0))*   2.000000000000000) ;
      double tr = (t.real()-itr*2.000000000000000-   1.000000000000000 - -2) *   1.000000000000000;
      double ti = (t.imag()-iti*0.500000000000000-   0.250000000000000 - 0) *   4.000000000000000;
      const double tr2 = tr * 2.0;
      const double ti2 = ti * 2.0;
      if (itr < 11) {
        for (int j=1; j <=3; ++j) {
          double xrval[10];
          double xival[10];
          double wrval[10];
          double wival[10];
          for (int k=1; k<= 10; k++){
            const int boxof = iti*7980 + itr*420 + (j-1)*140 + (k-1)*14;
            double dr = xr[boxof+13];
            double di = xi[boxof+13];
            double er = wr[boxof+13];
            double ei = wi[boxof+13];
            double fr = tr2*dr + xr[boxof+12];
            double fi = tr2*di + xi[boxof+12];
            double gr = tr2*er + wr[boxof+12];
            double gi = tr2*ei + wi[boxof+12];
            dr = tr2*fr - dr + xr[boxof+11];
            di = tr2*fi - di + xi[boxof+11];
            er = tr2*gr - er + wr[boxof+11];
            ei = tr2*gi - ei + wi[boxof+11];
            fr = tr2*dr - fr + xr[boxof+10];
            fi = tr2*di - fi + xi[boxof+10];
            gr = tr2*er - gr + wr[boxof+10];
            gi = tr2*ei - gi + wi[boxof+10];
            dr = tr2*fr - dr + xr[boxof+9];
            di = tr2*fi - di + xi[boxof+9];
            er = tr2*gr - er + wr[boxof+9];
            ei = tr2*gi - ei + wi[boxof+9];
            fr = tr2*dr - fr + xr[boxof+8];
            fi = tr2*di - fi + xi[boxof+8];
            gr = tr2*er - gr + wr[boxof+8];
            gi = tr2*ei - gi + wi[boxof+8];
            dr = tr2*fr - dr + xr[boxof+7];
            di = tr2*fi - di + xi[boxof+7];
            er = tr2*gr - er + wr[boxof+7];
            ei = tr2*gi - ei + wi[boxof+7];
            fr = tr2*dr - fr + xr[boxof+6];
            fi = tr2*di - fi + xi[boxof+6];
            gr = tr2*er - gr + wr[boxof+6];
            gi = tr2*ei - gi + wi[boxof+6];
            dr = tr2*fr - dr + xr[boxof+5];
            di = tr2*fi - di + xi[boxof+5];
            er = tr2*gr - er + wr[boxof+5];
            ei = tr2*gi - ei + wi[boxof+5];
            fr = tr2*dr - fr + xr[boxof+4];
            fi = tr2*di - fi + xi[boxof+4];
            gr = tr2*er - gr + wr[boxof+4];
            gi = tr2*ei - gi + wi[boxof+4];
            dr = tr2*fr - dr + xr[boxof+3];
            di = tr2*fi - di + xi[boxof+3];
            er = tr2*gr - er + wr[boxof+3];
            ei = tr2*gi - ei + wi[boxof+3];
            fr = tr2*dr - fr + xr[boxof+2];
            fi = tr2*di - fi + xi[boxof+2];
            gr = tr2*er - gr + wr[boxof+2];
            gi = tr2*ei - gi + wi[boxof+2];
            dr = tr2*fr - dr + xr[boxof+1];
            di = tr2*fi - di + xi[boxof+1];
            er = tr2*gr - er + wr[boxof+1];
            ei = tr2*gi - ei + wi[boxof+1];
            xrval[k-1] = tr*dr - fr + xr[boxof+0]*0.5;
            xival[k-1] = tr*di - fi + xi[boxof+0]*0.5;
            wrval[k-1] = tr*er - gr + wr[boxof+0]*0.5;
            wival[k-1] = tr*ei - gi + wi[boxof+0]*0.5;
          }
          const double denom = 10;
          const double fac = 2 / denom;
          const double pi = 3.141592653589793238462;
          double tcxr[10];
          double tcxi[10];
          double tcwr[10];
          double tcwi[10];
          for (int b = 0; b != 10; ++b) {
            double sumxr = 0;
            double sumxi = 0;
            double sumwr = 0;
            double sumwi = 0;
            double fac2 = pi * b / 10;
            for (int k = 0; k !=10; ++k) {
              double fac3 = cos (fac2 * (k + 0.5) );
              sumxr += xrval[k] * fac3;
              sumxi += xival[k] * fac3;
              sumwr += wrval[k] * fac3;
              sumwi += wival[k] * fac3;
            }
            tcxr[b] = (sumxr * fac);
            tcxi[b] = (sumxi * fac);
            tcwr[b] = (sumwr * fac);
            tcwi[b] = (sumwi * fac);
          }
          double dr = tcxr[9];
          double di = tcxi[9];
          double er = tcwr[9];
          double ei = tcwi[9];
          double fr = ti2*dr + tcxr[8];
          double fi = ti2*di + tcxi[8];
          double gr = ti2*er + tcwr[8];
          double gi = ti2*ei + tcwi[8];
          dr = ti2*fr - dr + tcxr[7];
          di = ti2*fi - di + tcxi[7];
          er = ti2*gr - er + tcwr[7];
          ei = ti2*gi - ei + tcwi[7];
          fr = ti2*dr - fr + tcxr[6];
          fi = ti2*di - fi + tcxi[6];
          gr = ti2*er - gr + tcwr[6];
          gi = ti2*ei - gi + tcwi[6];
          dr = ti2*fr - dr + tcxr[5];
          di = ti2*fi - di + tcxi[5];
          er = ti2*gr - er + tcwr[5];
          ei = ti2*gi - ei + tcwi[5];
          fr = ti2*dr - fr + tcxr[4];
          fi = ti2*di - fi + tcxi[4];
          gr = ti2*er - gr + tcwr[4];
          gi = ti2*ei - gi + tcwi[4];
          dr = ti2*fr - dr + tcxr[3];
          di = ti2*fi - di + tcxi[3];
          er = ti2*gr - er + tcwr[3];
          ei = ti2*gi - ei + tcwi[3];
          fr = ti2*dr - fr + tcxr[2];
          fi = ti2*di - fi + tcxi[2];
          gr = ti2*er - gr + tcwr[2];
          gi = ti2*ei - gi + tcwi[2];
          dr = ti2*fr - dr + tcxr[1];
          di = ti2*fi - di + tcxi[1];
          er = ti2*gr - er + tcwr[1];
          ei = ti2*gi - ei + tcwi[1];
          rr[offset+j-1].real( ti*dr - fr + tcxr[0]*0.5 ) ;
          ww[offset+j-1].real( ti*er - gr + tcwr[0]*0.5 ) ;
          if (torig.imag() < 0) {
            rr[offset+j-1].imag(-1*( ti*di - fi + tcxi[0]*0.5 )) ;
            ww[offset+j-1].imag(-1*( ti*ei - gi + tcwi[0]*0.5 )) ;
          } else {
            rr[offset+j-1].imag( ti*di - fi + tcxi[0]*0.5 ) ;
            ww[offset+j-1].imag( ti*ei - gi + tcwi[0]*0.5 ) ;
          }
        }
      } else {
        for (int j=1; j <=3; ++j) {
          double xrval[8];
          double xival[8];
          double wrval[8];
          double wival[8];
          for (int k=1; k<= 8; k++){
            const int boxof = iti*7980 + itr*240 + 1980 + (j-1)*80 + (k-1)*10;
            double dr = xr[boxof+9];
            double di = xi[boxof+9];
            double er = wr[boxof+9];
            double ei = wi[boxof+9];
            double fr = tr2*dr + xr[boxof+8];
            double fi = tr2*di + xi[boxof+8];
            double gr = tr2*er + wr[boxof+8];
            double gi = tr2*ei + wi[boxof+8];
            dr = tr2*fr - dr + xr[boxof+7];
            di = tr2*fi - di + xi[boxof+7];
            er = tr2*gr - er + wr[boxof+7];
            ei = tr2*gi - ei + wi[boxof+7];
            fr = tr2*dr - fr + xr[boxof+6];
            fi = tr2*di - fi + xi[boxof+6];
            gr = tr2*er - gr + wr[boxof+6];
            gi = tr2*ei - gi + wi[boxof+6];
            dr = tr2*fr - dr + xr[boxof+5];
            di = tr2*fi - di + xi[boxof+5];
            er = tr2*gr - er + wr[boxof+5];
            ei = tr2*gi - ei + wi[boxof+5];
            fr = tr2*dr - fr + xr[boxof+4];
            fi = tr2*di - fi + xi[boxof+4];
            gr = tr2*er - gr + wr[boxof+4];
            gi = tr2*ei - gi + wi[boxof+4];
            dr = tr2*fr - dr + xr[boxof+3];
            di = tr2*fi - di + xi[boxof+3];
            er = tr2*gr - er + wr[boxof+3];
            ei = tr2*gi - ei + wi[boxof+3];
            fr = tr2*dr - fr + xr[boxof+2];
            fi = tr2*di - fi + xi[boxof+2];
            gr = tr2*er - gr + wr[boxof+2];
            gi = tr2*ei - gi + wi[boxof+2];
            dr = tr2*fr - dr + xr[boxof+1];
            di = tr2*fi - di + xi[boxof+1];
            er = tr2*gr - er + wr[boxof+1];
            ei = tr2*gi - ei + wi[boxof+1];
            xrval[k-1] = tr*dr - fr + xr[boxof+0]*0.5;
            xival[k-1] = tr*di - fi + xi[boxof+0]*0.5;
            wrval[k-1] = tr*er - gr + wr[boxof+0]*0.5;
            wival[k-1] = tr*ei - gi + wi[boxof+0]*0.5;
          }
          const double denom = 8;
          const double fac = 2 / denom;
          const double pi = 3.141592653589793238462;
          double tcxr[8];
          double tcxi[8];
          double tcwr[8];
          double tcwi[8];
          for (int b = 0; b != 8; ++b) {
            double sumxr = 0;
            double sumxi = 0;
            double sumwr = 0;
            double sumwi = 0;
            double fac2 = pi * b / 8;
            for (int k = 0; k !=8; ++k) {
              double fac3 = cos (fac2 * (k + 0.5) );
              sumxr += xrval[k] * fac3;
              sumxi += xival[k] * fac3;
              sumwr += wrval[k] * fac3;
              sumwi += wival[k] * fac3;
            }
            tcxr[b] = (sumxr * fac);
            tcxi[b] = (sumxi * fac);
            tcwr[b] = (sumwr * fac);
            tcwi[b] = (sumwi * fac);
          }
          double dr = tcxr[7];
          double di = tcxi[7];
          double er = tcwr[7];
          double ei = tcwi[7];
          double fr = ti2*dr + tcxr[6];
          double fi = ti2*di + tcxi[6];
          double gr = ti2*er + tcwr[6];
          double gi = ti2*ei + tcwi[6];
          dr = ti2*fr - dr + tcxr[5];
          di = ti2*fi - di + tcxi[5];
          er = ti2*gr - er + tcwr[5];
          ei = ti2*gi - ei + tcwi[5];
          fr = ti2*dr - fr + tcxr[4];
          fi = ti2*di - fi + tcxi[4];
          gr = ti2*er - gr + tcwr[4];
          gi = ti2*ei - gi + tcwi[4];
          dr = ti2*fr - dr + tcxr[3];
          di = ti2*fi - di + tcxi[3];
          er = ti2*gr - er + tcwr[3];
          ei = ti2*gi - ei + tcwi[3];
          fr = ti2*dr - fr + tcxr[2];
          fi = ti2*di - fi + tcxi[2];
          gr = ti2*er - gr + tcwr[2];
          gi = ti2*ei - gi + tcwi[2];
          dr = ti2*fr - dr + tcxr[1];
          di = ti2*fi - di + tcxi[1];
          er = ti2*gr - er + tcwr[1];
          ei = ti2*gi - ei + tcwi[1];
          rr[offset+j-1].real( ti*dr - fr + tcxr[0]*0.5 ) ;
          ww[offset+j-1].real( ti*er - gr + tcwr[0]*0.5 ) ;
          if (torig.imag() < 0) {
            rr[offset+j-1].imag(-1*( ti*di - fi + tcxi[0]*0.5 )) ;
            ww[offset+j-1].imag(-1*( ti*ei - gi + tcwi[0]*0.5 )) ;
          } else {
            rr[offset+j-1].imag( ti*di - fi + tcxi[0]*0.5 ) ;
            ww[offset+j-1].imag( ti*ei - gi + tcwi[0]*0.5 ) ;
          }
        }
      }
    }
  }
}
