import { FC } from 'react';
import type { ComponentWithConditionPropsAsyncSupport } from './types';
/**
 * If condition evaluates to true, renders the `<Then />` block will be rendered,
 * otherwise renders the `<Else />` block. Either block may be omitted.
 *
 * This component can contain any number of `<Then />` or `<Else />` blocks,
 * but only the first block of the right type (either Then or Else, depending on the condition) will be rendered.
 * @param __namedParameters The props to pass down to the `<IF />` component, see {@link ComponentWithConditionProps}
 */
export declare const If: FC<ComponentWithConditionPropsAsyncSupport>;
//# sourceMappingURL=If.d.ts.map