import React from 'react';
import PropTypes from 'prop-types';

const General = ({ sourceName, targetName }) => {
    return (
        <>
            <p>
                The user {sourceName} is a SQL admin on the computer{' '}
                {targetName}.
            </p>
            <p>
                There is at least one MSSQL instance running on {targetName}{' '}
                where the user {sourceName} is the account configured to run the
                SQL Server instance. The typical configuration for MSSQL is to
                have the local Windows account or Active Directory domain
                account that is configured to run the SQL Server service (the
                primary database engine for SQL Server) have sysadmin privileges
                in the SQL Server application. As a result, the SQL Server
                service account can be used to log into the SQL Server instance
                remotely, read all of the databases (including those protected
                with transparent encryption), and run operating systems command
                through SQL Server (as the service account) using a variety of
                techniques.
            </p>
            <p>
                For Windows systems that have been joined to an Active Directory
                domain, the SQL Server instances and the associated service
                account can be identified by executing a LDAP query for a list
                of "MSSQLSvc" Service Principal Names (SPN) as a domain user. In
                short, when the Database Engine service starts, it attempts to
                register the SPN, and the SPN is then used to help facilitate
                Kerberos authentication.
            </p>
            <p>Author: Scott Sutherland</p>
        </>
    );
};

General.propTypes = {
    sourceName: PropTypes.string,
    targetName: PropTypes.string,
};

export default General;
