/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.jd.gui.spi.PreferencesPanel;
import org.jd.gui.util.exception.ExceptionUtil;

public class ViewerPreferencesProvider
extends JPanel
implements PreferencesPanel,
DocumentListener {
    protected static final int MIN_VALUE = 2;
    protected static final int MAX_VALUE = 40;
    protected static final String FONT_SIZE_KEY = "ViewerPreferences.fontSize";
    protected PreferencesPanel.PreferencesPanelChangeListener listener = null;
    protected JTextField fontSizeTextField;
    protected Color errorBackgroundColor = Color.RED;
    protected Color defaultBackgroundColor;

    public ViewerPreferencesProvider() {
        super(new BorderLayout());
        this.add((Component)new JLabel("Font size (2..40): "), "West");
        this.fontSizeTextField = new JTextField();
        this.fontSizeTextField.getDocument().addDocumentListener(this);
        this.add((Component)this.fontSizeTextField, "Center");
        this.defaultBackgroundColor = this.fontSizeTextField.getBackground();
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "Viewer";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Appearance";
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void init(Color errorBackgroundColor) {
        this.errorBackgroundColor = errorBackgroundColor;
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        String fontSize = preferences.get(FONT_SIZE_KEY);
        if (fontSize == null) {
            RSyntaxTextArea textArea;
            block3: {
                textArea = new RSyntaxTextArea();
                try {
                    Theme theme = Theme.load((InputStream)this.getClass().getClassLoader().getResourceAsStream("rsyntaxtextarea/themes/eclipse.xml"));
                    theme.apply(textArea);
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block3;
                    throw new AssertionError();
                }
            }
            fontSize = String.valueOf(textArea.getFont().getSize());
        }
        this.fontSizeTextField.setText(fontSize);
        this.fontSizeTextField.setCaretPosition(this.fontSizeTextField.getText().length());
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        preferences.put(FONT_SIZE_KEY, this.fontSizeTextField.getText());
    }

    @Override
    public boolean arePreferencesValid() {
        try {
            int i = Integer.valueOf(this.fontSizeTextField.getText());
            return i >= 2 && i <= 40;
        }
        catch (NumberFormatException e) {
            assert (ExceptionUtil.printStackTrace(e));
            return false;
        }
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    public void onTextChange() {
        this.fontSizeTextField.setBackground(this.arePreferencesValid() ? this.defaultBackgroundColor : this.errorBackgroundColor);
        if (this.listener != null) {
            this.listener.preferencesPanelChanged(this);
        }
    }
}

