/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.container;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jd.gui.api.model.Container;
import org.jd.gui.model.container.ContainerEntryComparator;
import org.jd.gui.util.exception.ExceptionUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class JarContainerEntryUtil {
    public static Collection<Container.Entry> removeInnerTypeEntries(Collection<Container.Entry> entries) {
        Collection<Container.Entry> filtredSubEntries;
        HashSet<String> potentialOuterTypePaths = new HashSet<String>();
        for (Container.Entry e : entries) {
            int lastSeparatorIndex;
            int dollarIndex;
            String p;
            if (e.isDirectory() || !(p = e.getPath()).toLowerCase().endsWith(".class") || (dollarIndex = p.substring((lastSeparatorIndex = p.lastIndexOf(47)) + 1).indexOf(36)) == -1) continue;
            potentialOuterTypePaths.add(p.substring(0, lastSeparatorIndex + 1 + dollarIndex) + ".class");
        }
        if (potentialOuterTypePaths.size() == 0) {
            filtredSubEntries = entries;
        } else {
            HashSet<String> innerTypePaths = new HashSet<String>();
            for (Container.Entry e : entries) {
                if (e.isDirectory() || !potentialOuterTypePaths.contains(e.getPath())) continue;
                JarContainerEntryUtil.populateInnerTypePaths(innerTypePaths, e);
            }
            filtredSubEntries = new ArrayList<Container.Entry>();
            for (Container.Entry e : entries) {
                int indexSeparator;
                int indexDollar;
                String p;
                if (!e.isDirectory() && (p = e.getPath()).toLowerCase().endsWith(".class") && (indexDollar = p.lastIndexOf(36)) != -1 && indexDollar > (indexSeparator = p.lastIndexOf(47))) {
                    if (innerTypePaths.contains(p)) continue;
                    JarContainerEntryUtil.populateInnerTypePaths(innerTypePaths, e);
                    if (innerTypePaths.contains(p)) continue;
                }
                filtredSubEntries.add(e);
            }
        }
        ArrayList<Container.Entry> list = new ArrayList<Container.Entry>(filtredSubEntries);
        list.sort(ContainerEntryComparator.COMPARATOR);
        return list;
    }

    protected static void populateInnerTypePaths(final HashSet<String> innerTypePaths, Container.Entry entry) {
        block14: {
            try (InputStream is = entry.getInputStream();){
                ClassReader classReader = new ClassReader(is);
                String p = entry.getPath();
                final String prefixPath = p.substring(0, p.length() - classReader.getClassName().length() - 6);
                ClassVisitor classVisitor = new ClassVisitor(458752){

                    public void visitInnerClass(String name, String outerName, String innerName, int access) {
                        innerTypePaths.add(prefixPath + name + ".class");
                    }
                };
                classReader.accept(classVisitor, 7);
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block14;
                throw new AssertionError();
            }
        }
    }
}

