/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.LineNumberList;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;
import org.jd.gui.view.component.HyperlinkPage;

public abstract class CustomLineNumbersPage
extends HyperlinkPage {
    protected Color errorForeground = Color.RED;
    protected boolean showMisalignment = true;
    protected int[] lineNumberMap = null;
    protected int maxLineNumber = 0;

    public void setErrorForeground(Color color) {
        this.errorForeground = color;
    }

    public void setShowMisalignment(boolean b) {
        this.showMisalignment = b;
    }

    protected void setMaxLineNumber(int maxLineNumber) {
        if (maxLineNumber > 0) {
            if (this.lineNumberMap == null) {
                this.lineNumberMap = new int[maxLineNumber + 1];
            } else if (this.lineNumberMap.length <= maxLineNumber) {
                int[] tmp = new int[maxLineNumber + 1];
                System.arraycopy(this.lineNumberMap, 0, tmp, 0, this.lineNumberMap.length);
                this.lineNumberMap = tmp;
            }
            this.maxLineNumber = maxLineNumber;
        }
    }

    protected void initLineNumbers() {
        String text = this.getText();
        int len = text.length();
        if (len == 0) {
            this.setMaxLineNumber(0);
        } else {
            int mln = len - text.replace("\n", "").length();
            if (text.charAt(len - 1) != '\n') {
                ++mln;
            }
            this.setMaxLineNumber(mln);
            for (int i = 1; i <= this.maxLineNumber; ++i) {
                this.lineNumberMap[i] = i;
            }
        }
    }

    protected void setLineNumber(int textAreaLineNumber, int originalLineNumber) {
        if (originalLineNumber > 0) {
            this.setMaxLineNumber(textAreaLineNumber);
            this.lineNumberMap[textAreaLineNumber] = originalLineNumber;
        }
    }

    protected void clearLineNumbers() {
        if (this.lineNumberMap != null) {
            Arrays.fill(this.lineNumberMap, 0);
        }
    }

    protected int getMaximumSourceLineNumber() {
        return this.maxLineNumber;
    }

    protected int getTextAreaLineNumber(int originalLineNumber) {
        int textAreaLineNumber = 1;
        int greatestLowerSourceLineNumber = 0;
        int i = this.lineNumberMap.length;
        while (i-- > 0) {
            int sln = this.lineNumberMap[i];
            if (sln > originalLineNumber || greatestLowerSourceLineNumber >= sln) continue;
            greatestLowerSourceLineNumber = sln;
            textAreaLineNumber = i;
        }
        return textAreaLineNumber;
    }

    @Override
    protected RSyntaxTextArea newSyntaxTextArea() {
        return new SourceSyntaxTextArea();
    }

    public class SourceLineNumberList
    extends LineNumberList {
        protected RTextArea rTextArea;
        protected Map<?, ?> aaHints;
        protected Rectangle visibleRect;
        protected Insets textAreaInsets;
        protected Dimension preferredSize;

        public SourceLineNumberList(RTextArea textArea) {
            super(textArea, null);
            this.rTextArea = textArea;
        }

        protected void init() {
            super.init();
            this.visibleRect = new Rectangle();
            this.aaHints = RSyntaxUtilities.getDesktopAntiAliasHints();
            this.textAreaInsets = null;
        }

        protected void paintComponent(Graphics g) {
            this.visibleRect = g.getClipBounds(this.visibleRect);
            if (this.visibleRect == null) {
                this.visibleRect = this.getVisibleRect();
            }
            if (this.visibleRect == null) {
                return;
            }
            int cellWidth = this.getPreferredSize().width;
            int cellHeight = this.rTextArea.getLineHeight();
            int ascent = this.rTextArea.getMaxAscent();
            FoldManager fm = ((RSyntaxTextArea)this.rTextArea).getFoldManager();
            int RHS_BORDER_WIDTH = this.getRhsBorderWidth();
            FontMetrics metrics = g.getFontMetrics();
            int rhs = this.getWidth() - RHS_BORDER_WIDTH;
            if (this.getParent() instanceof Gutter) {
                g.setColor(this.getParent().getBackground());
            } else {
                g.setColor(this.getBackground());
            }
            g.fillRect(0, this.visibleRect.y, cellWidth, this.visibleRect.height);
            g.setFont(this.getFont());
            if (this.aaHints != null) {
                ((Graphics2D)g).addRenderingHints(this.aaHints);
            }
            if (this.rTextArea.getLineWrap()) {
                SourceSyntaxTextAreaUI ui = (SourceSyntaxTextAreaUI)((Object)this.rTextArea.getUI());
                View v = ui.getRootView((JTextComponent)this.rTextArea).getView(0);
                Element root = this.rTextArea.getDocument().getDefaultRootElement();
                int lineCount = root.getElementCount();
                int topPosition = this.rTextArea.viewToModel(this.visibleRect.getLocation());
                int topLine = root.getElementIndex(topPosition);
                Rectangle visibleEditorRect = ui.getVisibleEditorRect();
                Rectangle r = LineNumberList.getChildViewBounds((View)v, (int)topLine, (Rectangle)visibleEditorRect);
                int y = r.y;
                int visibleBottom = this.visibleRect.y + this.visibleRect.height;
                while (y < visibleBottom) {
                    Fold fold;
                    r = SourceLineNumberList.getChildViewBounds((View)v, (int)topLine, (Rectangle)visibleEditorRect);
                    this.paintLineNumber(g, metrics, rhs, y + ascent, topLine + 1);
                    y += r.height;
                    if (fm != null && (fold = fm.getFoldForLine(topLine)) != null && fold.isCollapsed()) {
                        topLine += fold.getCollapsedLineCount();
                    }
                    if (++topLine < lineCount) continue;
                    break;
                }
            } else {
                this.textAreaInsets = this.rTextArea.getInsets(this.textAreaInsets);
                if (this.visibleRect.y < this.textAreaInsets.top) {
                    this.visibleRect.height -= this.textAreaInsets.top - this.visibleRect.y;
                    this.visibleRect.y = this.textAreaInsets.top;
                }
                int topLine = (this.visibleRect.y - this.textAreaInsets.top) / cellHeight;
                int actualTopY = topLine * cellHeight + this.textAreaInsets.top;
                int y = actualTopY + ascent;
                topLine += fm.getHiddenLineCountAbove(topLine, true);
                g.setColor(this.getForeground());
                for (int line = topLine + 1; y < this.visibleRect.y + this.visibleRect.height + ascent && line <= this.rTextArea.getLineCount(); ++line) {
                    int hiddenLineCount;
                    this.paintLineNumber(g, metrics, rhs, y, line);
                    y += cellHeight;
                    if (fm == null) continue;
                    Fold fold = fm.getFoldForLine(line - 1);
                    while (fold != null && fold.isCollapsed() && (hiddenLineCount = fold.getLineCount()) != 0) {
                        fold = fm.getFoldForLine((line += hiddenLineCount) - 1);
                    }
                }
            }
        }

        protected void paintLineNumber(Graphics g, FontMetrics metrics, int x, int y, int lineNumber) {
            int originalLineNumber = CustomLineNumbersPage.this.lineNumberMap != null ? (lineNumber < CustomLineNumbersPage.this.lineNumberMap.length ? CustomLineNumbersPage.this.lineNumberMap[lineNumber] : 0) : lineNumber;
            if (originalLineNumber != 0) {
                String number = Integer.toString(originalLineNumber);
                int strWidth = metrics.stringWidth(number);
                g.setColor(CustomLineNumbersPage.this.showMisalignment && lineNumber != originalLineNumber ? CustomLineNumbersPage.this.errorForeground : this.getForeground());
                g.drawString(number, x - strWidth, y);
            }
        }

        public int getRhsBorderWidth() {
            return ((RSyntaxTextArea)this.rTextArea).isCodeFoldingEnabled() ? 0 : 4;
        }

        public Dimension getPreferredSize() {
            if (this.preferredSize == null) {
                int lineCount = CustomLineNumbersPage.this.getMaximumSourceLineNumber();
                if (lineCount > 0) {
                    Font font = this.getFont();
                    FontMetrics fontMetrics = this.getFontMetrics(font);
                    int count = 1;
                    while (lineCount >= 10) {
                        lineCount /= 10;
                        ++count;
                    }
                    int preferredWidth = fontMetrics.charWidth('9') * count + 10;
                    this.preferredSize = new Dimension(preferredWidth, 0);
                } else {
                    this.preferredSize = new Dimension(0, 0);
                }
            }
            return this.preferredSize;
        }
    }

    public class SourceSyntaxTextAreaEditorKit
    extends RSyntaxTextAreaEditorKit {
        public LineNumberList createLineNumberList(RTextArea textArea) {
            return new SourceLineNumberList(textArea);
        }
    }

    public class SourceSyntaxTextAreaUI
    extends RSyntaxTextAreaUI {
        public SourceSyntaxTextAreaUI(JComponent rSyntaxTextArea) {
            super(rSyntaxTextArea);
        }

        public EditorKit getEditorKit(JTextComponent tc) {
            return new SourceSyntaxTextAreaEditorKit();
        }

        public Rectangle getVisibleEditorRect() {
            return super.getVisibleEditorRect();
        }
    }

    public class SourceSyntaxTextArea
    extends HyperlinkPage.HyperlinkSyntaxTextArea {
        public SourceSyntaxTextArea() {
            super(CustomLineNumbersPage.this);
        }

        protected RTextAreaUI createRTextAreaUI() {
            return new SourceSyntaxTextAreaUI((JComponent)((Object)this));
        }
    }
}

