/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.util.io.TextReader;
import org.jd.gui.util.parser.antlr.ANTLRJavaParser;
import org.jd.gui.util.parser.antlr.AbstractJavaListener;
import org.jd.gui.util.parser.antlr.JavaParser;
import org.jd.gui.view.component.TypePage;

public class JavaFilePage
extends TypePage {
    public JavaFilePage(API api, Container.Entry entry) {
        super(api, entry);
        String text = TextReader.getText(entry.getInputStream()).replace("\r\n", "\n").replace('\r', '\n');
        DeclarationListener declarationListener = new DeclarationListener(entry);
        ReferenceListener referenceListener = new ReferenceListener(entry);
        ANTLRJavaParser.parse((CharStream)new ANTLRInputStream(text), declarationListener);
        referenceListener.init(declarationListener);
        ANTLRJavaParser.parse((CharStream)new ANTLRInputStream(text), referenceListener);
        this.setText(text);
        this.initLineNumbers();
    }

    @Override
    public String getSyntaxStyle() {
        return "text/java";
    }

    @Override
    public String getFileName() {
        String path = this.entry.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    public static class TypeDeclarationData
    extends TypePage.DeclarationData {
        protected String superTypeName;

        public TypeDeclarationData(int startPosition, int length, String type, String name, String descriptor, String superTypeName) {
            super(startPosition, length, type, name, descriptor);
            this.superTypeName = superTypeName;
        }
    }

    public static class Context {
        protected Context outerContext;
        protected HashMap<String, String> nameToDescriptor = new HashMap();

        public Context(Context outerContext) {
            this.outerContext = outerContext;
        }

        public String getDescriptor(String name) {
            String descriptor = this.nameToDescriptor.get(name);
            if (descriptor == null && this.outerContext != null) {
                descriptor = this.outerContext.getDescriptor(name);
            }
            return descriptor;
        }
    }

    public class ReferenceListener
    extends AbstractJavaListener {
        protected StringBuilder sbTypeDeclaration;
        protected HashMap<String, TypePage.ReferenceData> referencesCache;
        protected String currentInternalTypeName;
        protected Context currentContext;

        public ReferenceListener(Container.Entry entry) {
            super(entry);
            this.sbTypeDeclaration = new StringBuilder();
            this.referencesCache = new HashMap();
            this.currentContext = null;
        }

        public void init(DeclarationListener declarationListener) {
            this.nameToInternalTypeName.putAll(declarationListener.getNameToInternalTypeName());
        }

        @Override
        public void enterPackageDeclaration(JavaParser.PackageDeclarationContext ctx) {
            super.enterPackageDeclaration(ctx);
            if (!this.packageName.isEmpty()) {
                this.sbTypeDeclaration.append(this.packageName).append('/');
            }
        }

        @Override
        public void enterImportDeclaration(JavaParser.ImportDeclarationContext ctx) {
            List<TerminalNode> identifiers = ctx.qualifiedName().Identifier();
            int position = identifiers.get(0).getSymbol().getStartIndex();
            String internalTypeName = this.concatIdentifiers(identifiers);
            JavaFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(position, internalTypeName.length(), this.newReferenceData(internalTypeName, null, null, null)));
        }

        @Override
        public void enterClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx);
        }

        @Override
        public void exitClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        @Override
        public void enterEnumDeclaration(JavaParser.EnumDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx);
        }

        @Override
        public void exitEnumDeclaration(JavaParser.EnumDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        @Override
        public void enterInterfaceDeclaration(JavaParser.InterfaceDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx);
        }

        @Override
        public void exitInterfaceDeclaration(JavaParser.InterfaceDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        @Override
        public void enterAnnotationTypeDeclaration(JavaParser.AnnotationTypeDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx);
        }

        @Override
        public void exitAnnotationTypeDeclaration(JavaParser.AnnotationTypeDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        public void enterTypeDeclaration(ParserRuleContext ctx) {
            TerminalNode identifier = ctx.getToken(100, 0);
            String typeName = identifier.getText();
            int length = this.sbTypeDeclaration.length();
            if (length == 0 || this.sbTypeDeclaration.charAt(length - 1) == '/') {
                this.sbTypeDeclaration.append(typeName);
            } else {
                this.sbTypeDeclaration.append('$').append(typeName);
            }
            this.currentInternalTypeName = this.sbTypeDeclaration.toString();
            this.currentContext = new Context(this.currentContext);
        }

        public void exitTypeDeclaration() {
            int index = this.sbTypeDeclaration.lastIndexOf("$");
            if (index == -1) {
                index = this.sbTypeDeclaration.lastIndexOf("/") + 1;
            }
            if (index == -1) {
                this.sbTypeDeclaration.setLength(0);
            } else {
                this.sbTypeDeclaration.setLength(index);
            }
            this.currentInternalTypeName = this.sbTypeDeclaration.toString();
        }

        @Override
        public void enterFormalParameters(JavaParser.FormalParametersContext ctx) {
            JavaParser.FormalParameterListContext formalParameterList = ctx.formalParameterList();
            if (formalParameterList != null) {
                List<JavaParser.FormalParameterContext> formalParameters = formalParameterList.formalParameter();
                for (JavaParser.FormalParameterContext formalParameter : formalParameters) {
                    int dimensionOnParameter = this.countDimension(formalParameter.variableDeclaratorId().children);
                    String descriptor = this.createDescriptor(formalParameter.type(), dimensionOnParameter);
                    String name = formalParameter.variableDeclaratorId().Identifier().getSymbol().getText();
                    this.currentContext.nameToDescriptor.put(name, descriptor);
                }
            }
        }

        @Override
        public void enterType(JavaParser.TypeContext ctx) {
            JavaParser.ClassOrInterfaceTypeContext classOrInterfaceType = ctx.classOrInterfaceType();
            if (classOrInterfaceType != null) {
                List<TerminalNode> identifiers = classOrInterfaceType.Identifier();
                String name = this.concatIdentifiers(identifiers);
                String internalTypeName = this.resolveInternalTypeName(identifiers);
                int position = identifiers.get(0).getSymbol().getStartIndex();
                JavaFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(position, name.length(), this.newReferenceData(internalTypeName, null, null, this.currentInternalTypeName)));
            }
        }

        @Override
        public void enterLocalVariableDeclaration(JavaParser.LocalVariableDeclarationContext ctx) {
            JavaParser.TypeContext typeContext = ctx.type();
            for (JavaParser.VariableDeclaratorContext variableDeclarator : ctx.variableDeclarators().variableDeclarator()) {
                JavaParser.VariableDeclaratorIdContext variableDeclaratorId = variableDeclarator.variableDeclaratorId();
                int dimensionOnVariable = this.countDimension(variableDeclaratorId.children);
                String descriptor = this.createDescriptor(typeContext, dimensionOnVariable);
                String name = variableDeclarator.variableDeclaratorId().Identifier().getSymbol().getText();
                this.currentContext.nameToDescriptor.put(name, descriptor);
            }
        }

        @Override
        public void enterCreator(JavaParser.CreatorContext ctx) {
            this.enterNewExpression(ctx.createdName().Identifier(), ctx.classCreatorRest());
        }

        @Override
        public void enterInnerCreator(JavaParser.InnerCreatorContext ctx) {
            this.enterNewExpression(Collections.singletonList(ctx.Identifier()), ctx.classCreatorRest());
        }

        public void enterNewExpression(List<TerminalNode> identifiers, JavaParser.ClassCreatorRestContext classCreatorRest) {
            if (identifiers.size() > 0) {
                String name = this.concatIdentifiers(identifiers);
                String internalTypeName = this.resolveInternalTypeName(identifiers);
                int position = identifiers.get(0).getSymbol().getStartIndex();
                if (classCreatorRest != null) {
                    JavaParser.ExpressionListContext expressionList = classCreatorRest.arguments().expressionList();
                    String descriptor = expressionList != null ? this.getParametersDescriptor(expressionList).append('V').toString() : "()V";
                    JavaFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(position, name.length(), this.newReferenceData(internalTypeName, "<init>", descriptor, this.currentInternalTypeName)));
                } else {
                    JavaFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(position, name.length(), this.newReferenceData(internalTypeName, null, null, this.currentInternalTypeName)));
                }
            }
        }

        @Override
        public void enterExpression(JavaParser.ExpressionContext ctx) {
            switch (ctx.getChildCount()) {
                case 1: {
                    Token symbol;
                    String name;
                    String internalTypeName;
                    TerminalNode identifier;
                    TerminalNode identifier0 = this.getToken(ctx.children, 100, 0);
                    if (identifier0 != null) {
                        String fieldName;
                        JavaParser.PrimaryContext primaryContext;
                        if (!this.isAField(ctx) || (primaryContext = ctx.primary()) == null || this.currentContext.getDescriptor(fieldName = primaryContext.literal().StringLiteral().getText()) != null) break;
                        String fieldTypeName = this.searchInternalTypeNameForThisFieldName(this.currentInternalTypeName, fieldName);
                        int position = ctx.Identifier().getSymbol().getStartIndex();
                        JavaFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(position, fieldName.length(), this.newReferenceData(fieldTypeName, fieldName, "?", this.currentInternalTypeName)));
                        break;
                    }
                    if (ctx.primary() == null || (identifier = ctx.primary().Identifier()) == null || (internalTypeName = (String)this.nameToInternalTypeName.get(name = (symbol = identifier.getSymbol()).getText())) == null) break;
                    int position = symbol.getStartIndex();
                    JavaFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(position, name.length(), this.newReferenceData(internalTypeName, null, null, this.currentInternalTypeName)));
                    break;
                }
                case 3: {
                    if (this.getToken(ctx.children, 65, 1) != null) {
                        String fieldTypeName;
                        TerminalNode identifier3 = this.getToken(ctx.children, 100, 2);
                        if (identifier3 == null || !this.isAField(ctx) || (fieldTypeName = this.getInternalTypeName(ctx.getChild(0))) == null) break;
                        int position = identifier3.getSymbol().getStartIndex();
                        String fieldName = identifier3.getText();
                        JavaFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(position, fieldName.length(), this.newReferenceData(fieldTypeName, fieldName, "?", this.currentInternalTypeName)));
                        break;
                    }
                    if (this.getToken(ctx.children, 57, 1) == null || this.getToken(ctx.children, 58, 2) == null) break;
                    this.enterCallMethodExpression(ctx, null);
                    break;
                }
                case 4: {
                    JavaParser.ExpressionListContext expressionListContext;
                    if (this.getToken(ctx.children, 57, 1) == null || this.getToken(ctx.children, 58, 3) == null || (expressionListContext = ctx.expressionList()) == null || expressionListContext != ctx.children.get(2)) break;
                    this.enterCallMethodExpression(ctx, expressionListContext);
                }
            }
        }

        public void enterCallMethodExpression(JavaParser.ExpressionContext ctx, JavaParser.ExpressionListContext expressionListContext) {
            ParseTree first = (ParseTree)ctx.children.get(0);
            if (first instanceof JavaParser.ExpressionContext) {
                JavaParser.ExpressionContext f = (JavaParser.ExpressionContext)first;
                switch (f.getChildCount()) {
                    case 1: {
                        JavaParser.PrimaryContext primary = f.primary();
                        TerminalNode identifier = primary.Identifier();
                        if (identifier != null) {
                            String methodName;
                            String methodTypeName;
                            Token symbol = identifier.getSymbol();
                            if (symbol == null || (methodTypeName = this.searchInternalTypeNameForThisMethodName(this.currentInternalTypeName, methodName = symbol.getText())) == null) break;
                            int position = symbol.getStartIndex();
                            String methodDescriptor = expressionListContext != null ? this.getParametersDescriptor(expressionListContext).append('?').toString() : "()?";
                            JavaFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(position, methodName.length(), this.newReferenceData(methodTypeName, methodName, methodDescriptor, this.currentInternalTypeName)));
                            break;
                        }
                        Token symbol = ((TerminalNode)primary.getChild(TerminalNode.class, 0)).getSymbol();
                        if (symbol != null) {
                            switch (symbol.getType()) {
                                case 43: {
                                    int position = symbol.getStartIndex();
                                    String methodDescriptor = expressionListContext != null ? this.getParametersDescriptor(expressionListContext).append('?').toString() : "()?";
                                    JavaFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(position, 4, this.newReferenceData(this.currentInternalTypeName, "<init>", methodDescriptor, this.currentInternalTypeName)));
                                    break;
                                }
                                case 40: {
                                    TypePage.DeclarationData data = (TypePage.DeclarationData)JavaFilePage.this.declarations.get(this.currentInternalTypeName);
                                    if (!(data instanceof TypeDeclarationData)) break;
                                    int position = symbol.getStartIndex();
                                    String methodTypeName = ((TypeDeclarationData)data).superTypeName;
                                    String methodDescriptor = expressionListContext != null ? this.getParametersDescriptor(expressionListContext).append('?').toString() : "()?";
                                    JavaFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(position, 5, this.newReferenceData(methodTypeName, "<init>", methodDescriptor, this.currentInternalTypeName)));
                                }
                            }
                        }
                        break;
                    }
                    case 3: {
                        String methodTypeName;
                        TerminalNode i3;
                        ParseTree identifier3;
                        ParseTree dot = first.getChild(1);
                        if (!(dot instanceof TerminalNode) || ((TerminalNode)dot).getSymbol().getType() != 65 || !((identifier3 = first.getChild(2)) instanceof TerminalNode) || (i3 = (TerminalNode)identifier3).getSymbol().getType() != 100 || (methodTypeName = this.getInternalTypeName(first.getChild(0))) == null) break;
                        int position = i3.getSymbol().getStartIndex();
                        String methodName = i3.getText();
                        String methodDescriptor = expressionListContext != null ? this.getParametersDescriptor(expressionListContext).append('?').toString() : "()?";
                        JavaFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(position, methodName.length(), this.newReferenceData(methodTypeName, methodName, methodDescriptor, this.currentInternalTypeName)));
                    }
                }
            }
        }

        public StringBuilder getParametersDescriptor(JavaParser.ExpressionListContext expressionListContext) {
            StringBuilder sb = new StringBuilder(40);
            for (JavaParser.ExpressionContext exp : expressionListContext.expression()) {
                sb.append('?');
            }
            sb.append(')');
            return sb;
        }

        public boolean isAField(JavaParser.ExpressionContext ctx) {
            int size;
            RuleContext parent = ctx.parent;
            if (parent instanceof JavaParser.ExpressionContext && parent.getChild((size = parent.getChildCount()) - 1) != ctx) {
                for (int i = 0; i < size; ++i) {
                    ParseTree next;
                    if (parent.getChild(i) != ctx || !((next = parent.getChild(i + 1)) instanceof TerminalNode)) continue;
                    switch (((TerminalNode)next).getSymbol().getType()) {
                        case 57: 
                        case 65: {
                            return false;
                        }
                    }
                }
            }
            return true;
        }

        public String getInternalTypeName(ParseTree pt) {
            if (pt instanceof JavaParser.ExpressionContext && pt.getChildCount() == 1) {
                JavaParser.PrimaryContext primary = ((JavaParser.ExpressionContext)pt).primary();
                TerminalNode identifier = primary.Identifier();
                if (identifier != null) {
                    String descriptor;
                    String name = identifier.getSymbol().getText();
                    String string = descriptor = this.currentContext == null ? null : this.currentContext.getDescriptor(name);
                    if (descriptor != null) {
                        if (descriptor.charAt(0) == 'L') {
                            return descriptor.substring(1, descriptor.length() - 1);
                        }
                    } else if (this.currentInternalTypeName != null) {
                        String internalTypeName = this.searchInternalTypeNameForThisFieldName(this.currentInternalTypeName, name);
                        if (internalTypeName != null) {
                            return internalTypeName;
                        }
                        internalTypeName = this.resolveInternalTypeName(Collections.singletonList(identifier));
                        if (internalTypeName != null) {
                            return internalTypeName;
                        }
                        return null;
                    }
                } else {
                    Token symbol;
                    TerminalNode tn = (TerminalNode)primary.getChild(TerminalNode.class, 0);
                    Token token = symbol = tn == null ? null : tn.getSymbol();
                    if (symbol != null) {
                        switch (symbol.getType()) {
                            case 43: {
                                return this.currentInternalTypeName;
                            }
                            case 40: {
                                TypePage.DeclarationData data = (TypePage.DeclarationData)JavaFilePage.this.declarations.get(this.currentInternalTypeName);
                                if (data instanceof TypeDeclarationData) {
                                    return ((TypeDeclarationData)data).superTypeName;
                                }
                                return null;
                            }
                        }
                    }
                }
            }
            return null;
        }

        public String searchInternalTypeNameForThisFieldName(String internalTypeName, String name) {
            String prefix = internalTypeName + '-' + name + '-';
            int length = prefix.length();
            for (Map.Entry entry : JavaFilePage.this.declarations.entrySet()) {
                if (!((String)entry.getKey()).startsWith(prefix) || ((String)entry.getKey()).charAt(length) == '(') continue;
                return ((TypePage.DeclarationData)entry.getValue()).typeName;
            }
            int index = internalTypeName.lastIndexOf(36);
            if (index != -1) {
                internalTypeName = internalTypeName.substring(0, index);
                return this.searchInternalTypeNameForThisFieldName(internalTypeName, name);
            }
            return null;
        }

        public String searchInternalTypeNameForThisMethodName(String internalTypeName, String name) {
            String prefix = internalTypeName + '-' + name + "-(";
            for (Map.Entry entry : JavaFilePage.this.declarations.entrySet()) {
                if (!((String)entry.getKey()).startsWith(prefix)) continue;
                return ((TypePage.DeclarationData)entry.getValue()).typeName;
            }
            int index = internalTypeName.lastIndexOf(36);
            if (index != -1) {
                internalTypeName = internalTypeName.substring(0, index);
                return this.searchInternalTypeNameForThisMethodName(internalTypeName, name);
            }
            return null;
        }

        public TerminalNode getToken(List<ParseTree> children, int type, int i) {
            ParseTree pt = children.get(i);
            if (pt instanceof TerminalNode && ((TerminalNode)pt).getSymbol().getType() == type) {
                return (TerminalNode)pt;
            }
            return null;
        }

        @Override
        public void enterBlock(JavaParser.BlockContext ctx) {
            this.currentContext = new Context(this.currentContext);
        }

        @Override
        public void exitBlock(JavaParser.BlockContext ctx) {
            this.currentContext = this.currentContext.outerContext;
        }

        public TypePage.ReferenceData newReferenceData(String internalName, String name, String descriptor, String scopeInternalName) {
            String key = internalName + '-' + name + '-' + descriptor + '-' + scopeInternalName;
            TypePage.ReferenceData reference = this.referencesCache.get(key);
            if (reference == null) {
                reference = new TypePage.ReferenceData(internalName, name, descriptor, scopeInternalName);
                this.referencesCache.put(key, reference);
                JavaFilePage.this.references.add(reference);
            }
            return reference;
        }

        @Override
        public void enterLiteral(JavaParser.LiteralContext ctx) {
            TerminalNode stringLiteral = ctx.StringLiteral();
            if (stringLiteral != null) {
                String str = stringLiteral.getSymbol().getText();
                int position = stringLiteral.getSymbol().getStartIndex();
                JavaFilePage.this.strings.add(new TypePage.StringData(position, str.length(), str, this.currentInternalTypeName));
            }
        }
    }

    public class DeclarationListener
    extends AbstractJavaListener {
        protected StringBuilder sbTypeDeclaration;
        protected String currentInternalTypeName;

        public DeclarationListener(Container.Entry entry) {
            super(entry);
            this.sbTypeDeclaration = new StringBuilder();
        }

        public HashMap<String, String> getNameToInternalTypeName() {
            return this.nameToInternalTypeName;
        }

        @Override
        public void enterPackageDeclaration(JavaParser.PackageDeclarationContext ctx) {
            super.enterPackageDeclaration(ctx);
            if (!this.packageName.isEmpty()) {
                this.sbTypeDeclaration.append(this.packageName).append('/');
            }
        }

        @Override
        public void enterImportDeclaration(JavaParser.ImportDeclarationContext ctx) {
            List<TerminalNode> identifiers = ctx.qualifiedName().Identifier();
            String internalTypeName = this.concatIdentifiers(identifiers);
            String typeName = identifiers.get(identifiers.size() - 1).getSymbol().getText();
            this.nameToInternalTypeName.put(typeName, internalTypeName);
        }

        @Override
        public void enterClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx);
        }

        @Override
        public void exitClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        @Override
        public void enterEnumDeclaration(JavaParser.EnumDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx);
        }

        @Override
        public void exitEnumDeclaration(JavaParser.EnumDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        @Override
        public void enterInterfaceDeclaration(JavaParser.InterfaceDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx);
        }

        @Override
        public void exitInterfaceDeclaration(JavaParser.InterfaceDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        @Override
        public void enterAnnotationTypeDeclaration(JavaParser.AnnotationTypeDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx);
        }

        @Override
        public void exitAnnotationTypeDeclaration(JavaParser.AnnotationTypeDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        public void enterTypeDeclaration(ParserRuleContext ctx) {
            TerminalNode identifier = ctx.getToken(100, 0);
            String typeName = identifier.getText();
            int position = identifier.getSymbol().getStartIndex();
            int length = this.sbTypeDeclaration.length();
            if (length == 0 || this.sbTypeDeclaration.charAt(length - 1) == '/') {
                this.sbTypeDeclaration.append(typeName);
            } else {
                this.sbTypeDeclaration.append('$').append(typeName);
            }
            this.currentInternalTypeName = this.sbTypeDeclaration.toString();
            this.nameToInternalTypeName.put(typeName, this.currentInternalTypeName);
            JavaParser.TypeContext superType = (JavaParser.TypeContext)ctx.getRuleContext(JavaParser.TypeContext.class, 0);
            String superInternalTypeName = superType != null ? this.resolveInternalTypeName(superType.classOrInterfaceType().Identifier()) : null;
            TypeDeclarationData data = new TypeDeclarationData(position, typeName.length(), this.currentInternalTypeName, null, null, superInternalTypeName);
            JavaFilePage.this.declarations.put(this.currentInternalTypeName, data);
            JavaFilePage.this.typeDeclarations.put(position, data);
        }

        public void exitTypeDeclaration() {
            int index = this.sbTypeDeclaration.lastIndexOf("$");
            if (index == -1) {
                index = this.sbTypeDeclaration.lastIndexOf("/") + 1;
            }
            if (index == -1) {
                this.sbTypeDeclaration.setLength(0);
            } else {
                this.sbTypeDeclaration.setLength(index);
            }
            this.currentInternalTypeName = this.sbTypeDeclaration.toString();
        }

        @Override
        public void enterClassBodyDeclaration(JavaParser.ClassBodyDeclarationContext ctx) {
            TerminalNode f;
            ParseTree first;
            if (ctx.getChildCount() == 2 && (first = ctx.getChild(0)) instanceof TerminalNode && (f = (TerminalNode)first).getSymbol().getType() == 38) {
                String name = f.getText();
                int position = f.getSymbol().getStartIndex();
                JavaFilePage.this.declarations.put(this.currentInternalTypeName + "-<clinit>-()V", new TypePage.DeclarationData(position, 6, this.currentInternalTypeName, name, "()V"));
            }
        }

        @Override
        public void enterConstDeclaration(JavaParser.ConstDeclarationContext ctx) {
            JavaParser.TypeContext typeContext = ctx.type();
            for (JavaParser.ConstantDeclaratorContext constantDeclaratorContext : ctx.constantDeclarator()) {
                TerminalNode identifier = constantDeclaratorContext.Identifier();
                String name = identifier.getText();
                int dimensionOnVariable = this.countDimension(constantDeclaratorContext.children);
                String descriptor = this.createDescriptor(typeContext, dimensionOnVariable);
                int position = identifier.getSymbol().getStartIndex();
                JavaFilePage.this.declarations.put(this.currentInternalTypeName + '-' + name + '-' + descriptor, new TypePage.DeclarationData(position, name.length(), this.currentInternalTypeName, name, descriptor));
            }
        }

        @Override
        public void enterFieldDeclaration(JavaParser.FieldDeclarationContext ctx) {
            JavaParser.TypeContext typeContext = ctx.type();
            for (JavaParser.VariableDeclaratorContext declaration : ctx.variableDeclarators().variableDeclarator()) {
                JavaParser.VariableDeclaratorIdContext variableDeclaratorId = declaration.variableDeclaratorId();
                TerminalNode identifier = variableDeclaratorId.Identifier();
                String name = identifier.getText();
                int dimensionOnVariable = this.countDimension(variableDeclaratorId.children);
                String descriptor = this.createDescriptor(typeContext, dimensionOnVariable);
                int position = identifier.getSymbol().getStartIndex();
                TypePage.DeclarationData data = new TypePage.DeclarationData(position, name.length(), this.currentInternalTypeName, name, descriptor);
                JavaFilePage.this.declarations.put(this.currentInternalTypeName + '-' + name + '-' + descriptor, data);
            }
        }

        @Override
        public void enterMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            this.enterMethodDeclaration(ctx, ctx.Identifier(), ctx.formalParameters(), ctx.type());
        }

        @Override
        public void enterInterfaceMethodDeclaration(JavaParser.InterfaceMethodDeclarationContext ctx) {
            this.enterMethodDeclaration(ctx, ctx.Identifier(), ctx.formalParameters(), ctx.type());
        }

        public void enterMethodDeclaration(ParserRuleContext ctx, TerminalNode identifier, JavaParser.FormalParametersContext formalParameters, JavaParser.TypeContext returnType) {
            String name = identifier.getText();
            String paramDescriptors = this.createParamDescriptors(formalParameters.formalParameterList());
            String returnDescriptor = this.createDescriptor(returnType, 0);
            String descriptor = paramDescriptors + returnDescriptor;
            int position = identifier.getSymbol().getStartIndex();
            JavaFilePage.this.declarations.put(this.currentInternalTypeName + '-' + name + '-' + descriptor, new TypePage.DeclarationData(position, name.length(), this.currentInternalTypeName, name, descriptor));
        }

        @Override
        public void enterConstructorDeclaration(JavaParser.ConstructorDeclarationContext ctx) {
            TerminalNode identifier = ctx.Identifier();
            String name = identifier.getText();
            String paramDescriptors = this.createParamDescriptors(ctx.formalParameters().formalParameterList());
            String descriptor = paramDescriptors + "V";
            int position = identifier.getSymbol().getStartIndex();
            JavaFilePage.this.declarations.put(this.currentInternalTypeName + "-<init>-" + descriptor, new TypePage.DeclarationData(position, name.length(), this.currentInternalTypeName, name, descriptor));
        }

        public String createParamDescriptors(JavaParser.FormalParameterListContext formalParameterList) {
            StringBuilder paramDescriptors = null;
            if (formalParameterList != null) {
                List<JavaParser.FormalParameterContext> formalParameters = formalParameterList.formalParameter();
                paramDescriptors = new StringBuilder("(");
                for (JavaParser.FormalParameterContext formalParameter : formalParameters) {
                    int dimensionOnParameter = this.countDimension(formalParameter.variableDeclaratorId().children);
                    String descriptor = this.createDescriptor(formalParameter.type(), dimensionOnParameter);
                    paramDescriptors.append(descriptor);
                }
            }
            return paramDescriptors == null ? "()" : paramDescriptors.append(')').toString();
        }
    }
}

