/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.analyse;

import eu.bibl.banalysis.analyse.Analyser;
import eu.bibl.banalysis.asm.ClassNode;
import eu.bibl.banalysis.storage.HookMap;
import eu.bibl.banalysis.storage.classes.ClassContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class MassAnalyser {
    protected ClassContainer classContainer;
    protected List<Analyser> singleAnalysers = new ArrayList<Analyser>();

    public void add(Analyser ... analysers) {
        this.singleAnalysers.addAll(Arrays.asList(analysers));
    }

    public void runSingleAnalysers(ClassContainer container, HookMap mapping) {
        ArrayList<Analyser> unanalysed = new ArrayList<Analyser>();
        LinkedList<Analyser> analysed = new LinkedList<Analyser>();
        for (Analyser an : this.singleAnalysers) {
            unanalysed.add(an);
        }
        int iterationsSpentAtThisSize = 0;
        int lastSize = 0;
        while (true) {
            for (ClassNode cn : container.getNodes().values()) {
                for (Analyser an : unanalysed) {
                    an.run(cn);
                    if (!an.isAnalysed()) continue;
                    analysed.add(an);
                }
            }
            while (!analysed.isEmpty()) {
                Analyser sa = (Analyser)analysed.pop();
                unanalysed.remove(sa);
            }
            iterationsSpentAtThisSize = lastSize == unanalysed.size() ? ++iterationsSpentAtThisSize : 0;
            if (iterationsSpentAtThisSize >= 2 || unanalysed.size() == 0) break;
            lastSize = unanalysed.size();
        }
    }

    public ClassContainer getClassContainer() {
        return this.classContainer;
    }

    public List<Analyser> getSingleAnalysers() {
        return this.singleAnalysers;
    }

    public void setClassContainer(ClassContainer classContainer) {
        this.classContainer = classContainer;
    }

    public void setSingleAnalysers(List<Analyser> singleAnalysers) {
        this.singleAnalysers = singleAnalysers;
    }
}

