package the.bytecode.club.bytecodeviewer.malwarescanner;

import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;

/***************************************************************************
 * Bytecode Viewer (BCV) - Java & Android Reverse Engineering Suite        *
 * Copyright (C) 2014 Kalen 'Konloch' Kinloch - http://bytecodeviewer.com  *
 *                                                                         *
 * This program is free software: you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

/**
 * A new malware scan object is created any time the MalicousCodeScanner plugin is ran
 *
 * This contains all of the details for the scan, including what should be scanned,
 * and what was detected during the scan.
 *
 * @author Konloch
 * @since 6/27/2021
 */
public class MalwareScan
{
	public final List<ClassNode> classNodeList;
	public final StringBuilder sb;
	public final Set<String> scanOptions;
	
	public MalwareScan(List<ClassNode> classNodeList, StringBuilder sb, Set<String> scanOptions)
	{
		this.classNodeList = classNodeList;
		this.sb = sb;
		this.scanOptions = scanOptions;
	}
}
