package the.bytecode.club.bytecodeviewer.malwarescanner.impl;

import com.strobel.assembler.ir.OpCode;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import the.bytecode.club.bytecodeviewer.malwarescanner.MalwareCodeScanner;
import the.bytecode.club.bytecodeviewer.malwarescanner.MalwareScan;
import the.bytecode.club.bytecodeviewer.malwarescanner.util.SearchableString;

import static the.bytecode.club.bytecodeviewer.Constants.nl;

/***************************************************************************
 * Bytecode Viewer (BCV) - Java & Android Reverse Engineering Suite        *
 * Copyright (C) 2014 Kalen 'Konloch' Kinloch - http://bytecodeviewer.com  *
 *                                                                         *
 * This program is free software: you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

/**
 * Checks for the security manager getting set to null
 *
 * @author Konloch
 * @author Adrianherrera
 * @since 6/27/2021
 */
public class NullSecurityManagerScanner extends MalwareCodeScanner
{
	private int lastInstruction;
	
	@Override
	public void scanFieldString(MalwareScan scan, ClassNode cn, FieldNode field, SearchableString string) { }
	
	@Override
	public void scanMethodString(MalwareScan scan, ClassNode cn, MethodNode method, SearchableString string) { }
	
	@Override
	public void scanMethodInstruction(MalwareScan scan, ClassNode cn, MethodNode method, AbstractInsnNode instruction)
	{
		if (instruction instanceof MethodInsnNode && instruction.getOpcode() == Opcodes.INVOKESTATIC)
		{
			final MethodInsnNode min = (MethodInsnNode) instruction;
			final String owner = min.owner;
			final String name =  min.name;
			
			if(lastInstruction == OpCode.ACONST_NULL.getCode()
					&& owner.equals("java/lang/System")
					&& name.equals("setSecurityManager"))
			{
				found(scan, "Security Manager set to null at method " + methodToString(cn, method) + nl);
			}
		}
		
		lastInstruction = instruction.getOpcode();
	}
	
	@Override
	public void scanningClass(MalwareScan scan, ClassNode cn)
	{
		lastInstruction = 0;
		super.scanningClass(scan, cn);
	}
}
