/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyManager;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.DataSourcePropertyFilter;
import org.jkiss.dbeaver.runtime.properties.IPropertySourceMulti;
import org.jkiss.dbeaver.runtime.properties.ObjectAttributeDescriptor;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertiesContributor;
import org.jkiss.utils.ArrayUtils;

public abstract class PropertySourceAbstract
implements DBPPropertyManager,
IPropertySourceMulti {
    private static final Log log = Log.getLog(PropertySourceAbstract.class);
    private Object sourceObject;
    private Object object;
    private boolean loadLazyProps;
    private final List<DBPPropertyDescriptor> props = new ArrayList<DBPPropertyDescriptor>();
    private Map<DBPPropertyDescriptor, Object> changedPropertiesValues = new HashMap<DBPPropertyDescriptor, Object>();
    private final Map<Object, Object> propValues = new HashMap<Object, Object>();
    private final Map<Object, Object> lazyValues = new HashMap<Object, Object>();
    private final List<ObjectPropertyDescriptor> lazyProps = new ArrayList<ObjectPropertyDescriptor>();
    private Job lazyLoadJob;
    private String locale;
    private boolean enableFilters = true;

    public PropertySourceAbstract(Object sourceObject, Object object, boolean loadLazyProps) {
        this.sourceObject = sourceObject;
        this.object = object;
        this.loadLazyProps = loadLazyProps;
    }

    @Override
    public synchronized void addProperty(DBPPropertyDescriptor prop) {
        if (!(prop instanceof ObjectPropertyDescriptor) || !((ObjectPropertyDescriptor)prop).isHidden()) {
            this.props.add(prop);
        }
        this.propValues.put(prop.getId(), prop);
    }

    @Override
    public synchronized void addProperty(@Nullable String category, String id, String name, Object value) {
        this.props.add(new PropertyDescriptor(category, id, name, null, value == null ? null : value.getClass(), false, null, null, false));
        this.propValues.put(id, value);
    }

    public synchronized void removeProperty(DBPPropertyDescriptor prop) {
        this.propValues.remove(prop.getId());
        this.lazyValues.remove(prop.getId());
        this.props.remove(prop);
    }

    public synchronized void clearProperties() {
        this.props.clear();
        this.propValues.clear();
        this.lazyValues.clear();
    }

    public synchronized boolean hasProperty(ObjectPropertyDescriptor prop) {
        return this.props.contains(prop);
    }

    public synchronized boolean isEmpty() {
        return this.props.isEmpty();
    }

    public DBPPropertyDescriptor getProperty(String id) {
        for (DBPPropertyDescriptor prop : this.props) {
            if (!prop.getId().equals(id)) continue;
            return prop;
        }
        return null;
    }

    public Object getSourceObject() {
        return this.sourceObject;
    }

    @Override
    public Object getEditableValue() {
        return this.object;
    }

    @Override
    public DBPPropertyDescriptor[] getProperties() {
        return this.props.toArray(new DBPPropertyDescriptor[0]);
    }

    @Override
    public boolean isPropertySet(String id) {
        Object value = this.propValues.get(id);
        if (value instanceof ObjectPropertyDescriptor) {
            return this.isPropertySet(this.getEditableValue(), (ObjectPropertyDescriptor)value);
        }
        return value != null;
    }

    @Override
    public boolean isPropertySet(Object object, ObjectPropertyDescriptor prop) {
        try {
            return !prop.isLazy(object, true) && prop.readValue(object, null, false) != null;
        }
        catch (Exception e) {
            log.error("Error reading property '" + prop.getId() + "' from " + object, e);
            return false;
        }
    }

    @Override
    public final Object getPropertyValue(@Nullable DBRProgressMonitor monitor, String id) {
        Object value = this.propValues.get(id);
        if (value instanceof ObjectPropertyDescriptor) {
            value = this.getPropertyValue(monitor, this.getEditableValue(), (ObjectPropertyDescriptor)value, true);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, Object object, ObjectPropertyDescriptor prop, boolean formatValue) {
        block11: {
            block13: {
                block12: {
                    try {
                        if (monitor != null || !prop.isLazy(object, true) || prop.supportsPreview()) break block11;
                        Object value = this.lazyValues.get(prop.getId());
                        if (value != null) {
                            return value;
                        }
                        if (!this.lazyValues.containsKey(prop.getId())) break block12;
                        return null;
                    }
                    catch (Throwable e) {
                        if (e instanceof InvocationTargetException) {
                            e = ((InvocationTargetException)e).getTargetException();
                        }
                        log.error("Error reading property '" + prop.getId() + "' from " + object, e);
                        return e.getMessage();
                    }
                }
                if (this.loadLazyProps) break block13;
                return null;
            }
            List<ObjectPropertyDescriptor> list = this.lazyProps;
            synchronized (list) {
                this.lazyProps.add(prop);
                if (this.lazyLoadJob == null) {
                    this.lazyLoadJob = DBWorkbench.getPlatformUI().createLoadingService(new PropertyValueLoadService(), new PropertyValueLoadVisualizer());
                    this.lazyLoadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void done(IJobChangeEvent event) {
                            List<ObjectPropertyDescriptor> list = PropertySourceAbstract.this.lazyProps;
                            synchronized (list) {
                                if (!PropertySourceAbstract.this.lazyProps.isEmpty()) {
                                    PropertySourceAbstract.this.lazyLoadJob.schedule(100L);
                                } else {
                                    PropertySourceAbstract.this.lazyLoadJob = null;
                                }
                            }
                        }
                    });
                    this.lazyLoadJob.schedule(100L);
                }
            }
            this.lazyValues.put(prop.getId(), null);
            return null;
        }
        return prop.readValue(object, monitor, formatValue);
    }

    @Override
    public boolean isPropertyResettable(String id) {
        Object value = this.propValues.get(id);
        if (value instanceof ObjectPropertyDescriptor) {
            return this.isPropertyResettable(this.getEditableValue(), (ObjectPropertyDescriptor)value);
        }
        return false;
    }

    @Override
    public boolean isPropertyResettable(Object object, ObjectPropertyDescriptor prop) {
        return false;
    }

    @Override
    public final void resetPropertyValue(@Nullable DBRProgressMonitor monitor, String id) {
        Object value = this.propValues.get(id);
        if (!(value instanceof ObjectPropertyDescriptor)) {
            throw new UnsupportedOperationException("Direct property reset not implemented");
        }
        this.resetPropertyValue(monitor, this.getEditableValue(), (ObjectPropertyDescriptor)value);
    }

    @Override
    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, Object object, ObjectPropertyDescriptor id) {
        throw new UnsupportedOperationException("Cannot reset property in non-editable property source");
    }

    @Override
    public void resetPropertyValueToDefault(String id) {
        throw new UnsupportedOperationException("Cannot reset property in non-editable property source");
    }

    @Override
    public final void setPropertyValue(@Nullable DBRProgressMonitor monitor, String id, Object value) {
        Object prop = this.propValues.get(id);
        if (prop instanceof ObjectPropertyDescriptor) {
            this.setPropertyValue(monitor, this.getEditableValue(), (ObjectPropertyDescriptor)prop, value);
            this.lazyValues.put(((ObjectPropertyDescriptor)prop).getId(), value);
        } else {
            this.propValues.put(id, value);
        }
    }

    @Override
    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, Object object, ObjectPropertyDescriptor prop, Object value) {
        throw new UnsupportedOperationException("Cannot update property in non-editable property source");
    }

    public boolean collectProperties() {
        this.lazyValues.clear();
        this.props.clear();
        this.propValues.clear();
        Object editableValue = this.getEditableValue();
        if (editableValue != null) {
            DBPPropertySource ownPropSource;
            Object[] ownProperties;
            DBCExecutionContext context;
            DataSourcePropertyFilter filter = this.isEnableFilters() ? (editableValue instanceof DBSObject ? new DataSourcePropertyFilter(((DBSObject)editableValue).getDataSource()) : (editableValue instanceof DBPContextProvider ? ((context = ((DBPContextProvider)editableValue).getExecutionContext()) == null ? new DataSourcePropertyFilter() : new DataSourcePropertyFilter(context.getDataSource())) : new DataSourcePropertyFilter())) : null;
            List<ObjectPropertyDescriptor> annoProps = ObjectAttributeDescriptor.extractAnnotations(this, editableValue.getClass(), filter, this.locale);
            for (ObjectPropertyDescriptor desc : annoProps) {
                if (!desc.isPropertyVisible(editableValue, editableValue)) continue;
                this.addProperty(desc);
            }
            if (editableValue instanceof DBPPropertySource && !ArrayUtils.isEmpty((Object[])(ownProperties = (ownPropSource = (DBPPropertySource)editableValue).getProperties()))) {
                Object[] objectArray = ownProperties;
                int n = ownProperties.length;
                int n2 = 0;
                while (n2 < n) {
                    Object prop = objectArray[n2];
                    this.props.add((DBPPropertyDescriptor)prop);
                    this.propValues.put(prop.getId(), ownPropSource.getPropertyValue(null, prop.getId()));
                    ++n2;
                }
            }
        }
        return !this.props.isEmpty();
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public boolean isEnableFilters() {
        return this.enableFilters;
    }

    public void setEnableFilters(boolean enableFilters) {
        this.enableFilters = enableFilters;
    }

    public boolean getEnableFilters() {
        return this.enableFilters;
    }

    public void addChangedProperties(DBPPropertyDescriptor descriptor, Object newValue) {
        this.changedPropertiesValues.put(descriptor, newValue);
    }

    public void setChangedPropertiesMap(Map<DBPPropertyDescriptor, Object> newMap) {
        this.changedPropertiesValues = newMap;
    }

    @Nullable
    public Map<DBPPropertyDescriptor, Object> getChangedPropertiesValues() {
        return this.changedPropertiesValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ObjectPropertyDescriptor> obtainLazyProperties() {
        List<ObjectPropertyDescriptor> list = this.lazyProps;
        synchronized (list) {
            if (this.lazyProps.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ObjectPropertyDescriptor> result = new ArrayList<ObjectPropertyDescriptor>(this.lazyProps);
            this.lazyProps.clear();
            return result;
        }
    }

    private class PropertyValueLoadService
    extends AbstractLoadService<Map<ObjectPropertyDescriptor, Object>> {
        public static final String TEXT_LOADING = "...";

        public PropertyValueLoadService() {
            super(TEXT_LOADING);
        }

        @Override
        public Map<ObjectPropertyDescriptor, Object> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                IdentityHashMap<ObjectPropertyDescriptor, Object> result = new IdentityHashMap<ObjectPropertyDescriptor, Object>();
                for (ObjectPropertyDescriptor prop : PropertySourceAbstract.this.obtainLazyProperties()) {
                    if (monitor.isCanceled()) break;
                    result.put(prop, prop.readValue(PropertySourceAbstract.this.getEditableValue(), monitor, true));
                }
                return result;
            }
            catch (Throwable ex) {
                if (ex instanceof InvocationTargetException) {
                    throw (InvocationTargetException)ex;
                }
                throw new InvocationTargetException(ex);
            }
        }

        @Override
        public Object getFamily() {
            Object editableValue = PropertySourceAbstract.this.getEditableValue();
            return editableValue instanceof DBSObject ? ((DBSObject)editableValue).getDataSource() : editableValue;
        }
    }

    private class PropertyValueLoadVisualizer
    implements ILoadVisualizer<Map<ObjectPropertyDescriptor, Object>> {
        private boolean completed = false;

        private PropertyValueLoadVisualizer() {
        }

        @Override
        public DBRProgressMonitor overwriteMonitor(DBRProgressMonitor monitor) {
            return monitor;
        }

        @Override
        public boolean isCompleted() {
            return this.completed;
        }

        @Override
        public void visualizeLoading() {
        }

        @Override
        public void completeLoading(Map<ObjectPropertyDescriptor, Object> result) {
            this.completed = true;
            if (result != null) {
                for (Map.Entry<ObjectPropertyDescriptor, Object> entry : result.entrySet()) {
                    PropertySourceAbstract.this.lazyValues.put(entry.getKey().getId(), entry.getValue());
                    PropertiesContributor.getInstance().notifyPropertyLoad(PropertySourceAbstract.this.getEditableValue(), entry.getKey(), entry.getValue(), true);
                }
            }
        }
    }
}

