/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.lightgrid.LightGrid;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDecoratorBase;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingConfigDialog;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingPanel;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsContainer;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.utils.ArrayUtils;

public class GroupingResultsDecorator
extends ResultSetDecoratorBase {
    private final GroupingResultsContainer container;

    public GroupingResultsDecorator(GroupingResultsContainer container) {
        this.container = container;
    }

    @Override
    public long getDecoratorFeatures() {
        return 81L;
    }

    @Override
    public String getEmptyDataMessage() {
        if (this.container.getGroupAttributes().isEmpty()) {
            return ResultSetMessages.results_decorator_no_groupings;
        }
        return ResultSetMessages.results_decorator_grouping_failed;
    }

    @Override
    public String getEmptyDataDescription() {
        DBPDataSource dataSource = this.container.getResultSetController().getDataContainer().getDataSource();
        if (dataSource == null) {
            return ResultSetMessages.results_decorator_no_connected_to_db;
        }
        SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
        if (this.container.getGroupAttributes().isEmpty()) {
            return ResultSetMessages.results_decorator_drag_and_drop_results_column;
        }
        return ResultSetMessages.results_decorator_grouping_attempt_failed;
    }

    @Override
    public void fillContributions(@NotNull IContributionManager contributionManager) {
        contributionManager.add((IAction)new GroupingPanel.EditColumnsAction(this.container));
        contributionManager.add((IAction)new GroupingPanel.DeleteColumnAction(this.container));
        contributionManager.add((IAction)new GroupingPanel.ClearGroupingAction(this.container));
    }

    @Override
    public void registerDragAndDrop(final @NotNull IResultSetPresentation presentation) {
        DropTargetListener[] gridDropListeners;
        final Control presentationControl = presentation.getControl();
        Object oldDropTarget = presentationControl.getData("DropTarget");
        if (oldDropTarget instanceof DropTarget) {
            gridDropListeners = ((DropTarget)oldDropTarget).getDropListeners();
            ((DropTarget)oldDropTarget).dispose();
        } else {
            gridDropListeners = null;
        }
        DropTarget dropTarget = new DropTarget(presentationControl, 3);
        dropTarget.setTransfer(new Transfer[]{LightGrid.GridColumnTransfer.INSTANCE});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragLeave(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void drop(DropTargetEvent event) {
                this.handleDragEvent(event);
                if (event.detail == 2 || event.detail == 1) {
                    this.dropColumns(event);
                }
            }

            public void dropAccept(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            private void handleDragEvent(DropTargetEvent event) {
                if (!this.isDropSupported(event)) {
                    event.detail = 0;
                } else if (event.detail == 0) {
                    event.detail = 2;
                }
                event.feedback = 1;
            }

            private boolean isDropSupported(DropTargetEvent event) {
                return true;
            }

            private void dropColumns(DropTargetEvent event) {
                if (!(event.data instanceof List)) {
                    return;
                }
                List dropElements = (List)event.data;
                ArrayList<String> newBindings = new ArrayList<String>();
                ArrayList<DBDAttributeBinding> movedBindings = new ArrayList<DBDAttributeBinding>();
                for (Object element : dropElements) {
                    if (!(element instanceof DBDAttributeBinding)) continue;
                    DBDAttributeBinding binding = (DBDAttributeBinding)element;
                    String attrName = GroupingResultsDecorator.getAttributeBindingName(binding);
                    if (ArrayUtils.contains((Object[])GroupingResultsDecorator.this.container.getResultSetController().getModel().getAttributes(), (Object)binding)) {
                        if (!GroupingResultsDecorator.this.container.getGroupAttributes().contains(attrName)) continue;
                        movedBindings.add(binding);
                        continue;
                    }
                    newBindings.add(attrName);
                }
                if (movedBindings.isEmpty() && newBindings.isEmpty()) {
                    return;
                }
                if (!movedBindings.isEmpty()) {
                    ArrayList<String> curAttributes = new ArrayList<String>(GroupingResultsDecorator.this.container.getGroupAttributes());
                    if (!(presentation.getControl() instanceof Spreadsheet)) {
                        return;
                    }
                    int overColumnIndex = ((Spreadsheet)presentationControl).getColumnIndex(event.x, event.y);
                    if (overColumnIndex < 0) {
                        return;
                    }
                    if (overColumnIndex >= curAttributes.size()) {
                        overColumnIndex = curAttributes.size() - 1;
                    }
                    for (DBDAttributeBinding mb : movedBindings) {
                        String attrName = GroupingResultsDecorator.getAttributeBindingName(mb);
                        curAttributes.remove(attrName);
                        curAttributes.add(overColumnIndex, attrName);
                    }
                    GroupingResultsDecorator.this.container.clearGroupingAttributes();
                    GroupingResultsDecorator.this.container.addGroupingAttributes(curAttributes);
                }
                if (!newBindings.isEmpty()) {
                    GroupingResultsDecorator.this.container.addGroupingAttributes(newBindings);
                }
                UIUtils.asyncExec(() -> {
                    GroupingConfigDialog dialog;
                    if (dropTargetEvent.detail == 1 && (dialog = new GroupingConfigDialog(GroupingResultsDecorator.this.container.getResultSetController().getControl().getShell(), GroupingResultsDecorator.this.container)).open() != 0) {
                        GroupingResultsDecorator.this.container.clearGrouping();
                        return;
                    }
                    try {
                        GroupingResultsDecorator.this.container.rebuildGrouping();
                    }
                    catch (DBException e) {
                        DBWorkbench.getPlatformUI().showError(ResultSetMessages.results_decorator_error_grouping_error, ResultSetMessages.results_decorator_error_cant_perform_grouping_query, (Throwable)e);
                    }
                });
            }
        });
    }

    private static String getAttributeBindingName(DBDAttributeBinding binding) {
        if (binding instanceof DBDAttributeBindingMeta && binding.getMetaAttribute() != null) {
            return DBUtils.getQuotedIdentifier((DBPDataSource)binding.getDataSource(), (String)binding.getMetaAttribute().getLabel());
        }
        return binding.getFullyQualifiedName(DBPEvaluationContext.DML);
    }
}

