/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreBackupAllSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupAllInfo;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupAllWizardPageObjects;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupAllWizardPageSettings;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeExportWizard;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreBackupAllWizard
extends AbstractNativeExportWizard<PostgreBackupAllSettings, PostgreDatabaseBackupAllInfo> {
    private PostgreBackupAllWizardPageObjects objectsPage;
    private PostgreBackupAllWizardPageSettings settingsPage;

    PostgreBackupAllWizard(DBTTask task) {
        super(task);
    }

    PostgreBackupAllWizard(Collection<DBSObject> objects) {
        super(objects, PostgreMessages.wizard_backup_all_page_global_backup_name);
        ((PostgreBackupAllSettings)this.getSettings()).fillExportObjectsFromInput();
    }

    public String getTaskTypeId() {
        return "pgDatabaseBackupAll";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, DBTTask task, Map<String, Object> state) {
        if (this.objectsPage.getControl() != null) {
            this.objectsPage.saveState();
        }
        if (this.settingsPage.getControl() != null) {
            this.settingsPage.saveState();
        }
        ((PostgreBackupAllSettings)this.getSettings()).saveSettings(runnableContext, (DBPPreferenceStore)new TaskPreferenceStore(state));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.objectsPage = new PostgreBackupAllWizardPageObjects(this);
        this.settingsPage = new PostgreBackupAllWizardPageSettings(this);
    }

    public void addPages() {
        this.addTaskConfigPages();
        this.addPage((IWizardPage)this.objectsPage);
        this.addPage((IWizardPage)this.settingsPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.settingsPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.logPage) {
            return this.settingsPage;
        }
        return super.getPreviousPage(page);
    }

    public void onSuccess(long workTime) {
        UIUtils.showMessageBox((Shell)this.getShell(), (String)PostgreMessages.wizard_backup_msgbox_success_title, (String)NLS.bind((String)PostgreMessages.wizard_backup_msgbox_success_description, (Object)CommonUtils.truncateString((String)this.getObjectsName(), (int)255)), (int)2);
        ((PostgreBackupAllSettings)this.getSettings()).getExportObjects().stream().map(it -> ((PostgreBackupAllSettings)this.getSettings()).getOutputFolder(it)).distinct().forEach(it -> {
            boolean bl = ShellUtils.launchProgram((String)it.getAbsolutePath());
        });
    }

    protected PostgreBackupAllSettings createSettings() {
        return new PostgreBackupAllSettings();
    }
}

